;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# dataflash filesystem functions						#
;# copyright (c) 2006/2007 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;delete file
;------------------------------------------------------------------------------
fsys_del:	clr	tempreg4		;first file	
fsys_del_00:	rcall	fsys_check		;check for dataflash
		ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;alert box
		ldi	YH,2
		ldi	ZL,28
		ldi	ZH,21
		libmio_whbox
		ldi	XL,0x40			;color scheme (green on black)
		libmio_setcolor		
		libmio_thistext
		.db	3,2,"Delete file",0

		
fsys_del_01:	rcall	fsys_select		;select a file
		sts	bas_partab,tempreg4
		rcall	fsys_gettype			;get type
		cpi	tempreg1,0xfc		;empty
		breq	fsys_del_01		;non existing file
		rcall	fsys_adel		;ask for deleting
		cpi	tempreg1,0x01		;yes
		brne	fsys_del_02
		mov	XL,tempreg4		;filenumber
		rcall	fsys_wal		;draw alert box
		rcall	fsys_delete

fsys_del_02:	ret


;------------------------------------------------------------------------------
;save file
;------------------------------------------------------------------------------
fsys_savebas:	clr	tempreg4		;first file

fsys_save_00:	rcall	fsys_check		;check for dataflash
		ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;window box
		ldi	YH,2
		ldi	ZL,28
		ldi	ZH,21
		libmio_whbox
		ldi	XL,0x40			;color scheme (green on black)
		libmio_setcolor
		ldi	XL,0x10			;BASIC
		sts	bas_partab+4,XL		;set file type		
		libmio_thistext
		.db	3,2,"Save P",0,0
		rcall	fsys_snn
		
fsys_save_01:	rcall	fsys_select
		sts	bas_partab,tempreg4
		rcall	fsys_gettype		;get type

		cpi	tempreg1,0xe0		;empty
		brcc	fsys_save_02
		cpi	tempreg1,0x10		;basic
		breq	fsys_save_04		
		rcall	fsys_e_cns		;cannot save on this
		rjmp	fsys_save_00		;loop
				
fsys_save_02:	rcall	fsys_free			;count free pages
		cpi	YH,0x00			;<256
		brne	fsys_save_03
		cpi	YL,0x0c			;needed pages for a program
		brcc	fsys_save_03		;we have...
		rcall	fsys_e_nsl		;no space left
		rjmp	fsys_save_00		;loop
fsys_save_03:	rcall	fsys_wal		;box
		rcall	fsys_bsave		;save this file
		ret				;end
		
fsys_save_04:	rcall	fsys_over		;ask for overwrite
		cpi	tempreg1,0x01		;yes?
		brne	fsys_save_00
		rcall	fsys_wal
		rcall	fsys_bover
		ret

;------------------------------------------------------------------------------
;backup
;------------------------------------------------------------------------------
fsys_backup:	clr	tempreg4		;first file

fsys_mbup_00:	rcall	fsys_check		;check for dataflash
		ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;alert box
		ldi	YH,2
		ldi	ZL,28
		ldi	ZH,21
		libmio_whbox
		ldi	XL,0x40			;color scheme (green on black)
		libmio_setcolor		
		ldi	XL,0x12			;BASIC
		sts	bas_partab+4,XL		;set file type		
		libmio_thistext
		.db	3,2,"Backup",0,0

		
fsys_mbup_01:	rcall	fsys_select
		sts	bas_partab,tempreg4
		rcall	fsys_gettype		;get type
		cpi	tempreg1,0x90		;empty
		brcc	fsys_mbup_02
		cpi	tempreg1,0x12		;backup
		breq	fsys_mbup_04		
		rcall	fsys_e_cns		;cannot save on this
		rjmp	fsys_mbup_00		;loop
				
fsys_mbup_02:	rcall	fsys_free		;count free pages
		cpi	YH,0x00			;<256
		brne	fsys_mbup_03
		cpi	YL,0x60			;needed pages for a backup
		brcc	fsys_mbup_03		;we have...
		rcall	fsys_e_nsl		;no space left
		rjmp	fsys_mbup_00		;loop
fsys_mbup_03:	rcall	fsys_wal
		rcall	fsys_msave		;save this file
		ret				;end
		
fsys_mbup_04:	rcall	fsys_over		;ask for overwrite
		cpi	tempreg1,0x01		;yes?
		brne	fsys_mbup_00
		rcall	fsys_wal
		rcall	fsys_mover
		ret	
		
;------------------------------------------------------------------------------
;load file
;------------------------------------------------------------------------------
fsys_loadbas:	clr	tempreg4		;first file

fsys_load_00:	rcall	fsys_check		;check for dataflash
		ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;alert box
		ldi	YH,2
		ldi	ZL,28
		ldi	ZH,21
		libmio_whbox
		ldi	XL,0x40			;color scheme (green on black)
		libmio_setcolor		
		libmio_thistext
		.db	3,2,"Load P",0,0
		rcall	fsys_snn
		
fsys_load_01:	rcall	fsys_select
		sts	bas_partab,tempreg4
		rcall	fsys_gettype		;get type
		cpi	tempreg1,0x10		;basic
		breq	fsys_load_02		
		rcall	fsys_e_cnlb		;cannot load
		rjmp	fsys_load_00		;loop
				
fsys_load_02:	rcall	fsys_bload
		ret						


;------------------------------------------------------------------------------
;restore
;------------------------------------------------------------------------------
fsys_restore:	clr	tempreg4		;first file

fsys_rest_00:	rcall	fsys_check		;check for dataflash
		ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;alert box
		ldi	YH,2
		ldi	ZL,28
		ldi	ZH,22
		libmio_whbox
		ldi	XL,0x40			;color scheme (green on black)
		libmio_setcolor
		libmio_thistext
		.db	3,2,"Restore",0

		
fsys_rest_01:	rcall	fsys_select
		sts	bas_partab,tempreg4
		rcall	fsys_gettype		;get type
		cpi	tempreg1,0x12		;backup
		breq	fsys_rest_02		
		rcall	fsys_e_cnlm		;cannot load
		rjmp	fsys_rest_00		;loop
				
fsys_rest_02:	rcall	fsys_mload
		ret						


;------------------------------------------------------------------------------
;select an entry
;------------------------------------------------------------------------------
fsys_select:	clr	tempreg4
fsys_sel_01:	rcall	fsys_list		;list files
fsys_sel_02:	rcall	fsys_inv		;invert selected
fsys_sel_03:	libmio_waitkey			;wait for key
		cpi	tempreg1,0xed		;ESC
		brne	fsys_sel_10		;no
		rcall	fsys_wnk
		pop	tempreg1		;kill stack
		pop	tempreg1
		ret				;end now
		
fsys_sel_10:	cpi	tempreg1,0xea		;enter
		brne	fsys_sel_15		;no
		ret
						;end
fsys_sel_15:	cpi	tempreg1,0xe0		;pos 1
		brne	fsys_sel_20
		rcall	fsys_reinv		;re-invert
		clr	tempreg4		;first pos
		rjmp	fsys_sel_01		;loop

fsys_sel_20:	cpi	tempreg1,0xe1		;pos 1
		brne	fsys_sel_25
		rcall	fsys_reinv		;re-invert
		lds	tempreg4,bas_partab+8	;maximum
		rjmp	fsys_sel_01		;loop

fsys_sel_25:	cpi	tempreg1,0xe4		;up
		brne	fsys_sel_30
		cpi	tempreg4,0x00
		breq	fsys_sel_03		;do nothing
		rcall	fsys_reinv		;re-invert
		subi	tempreg4,0x01		;-1
		mov	tempreg1,tempreg4
		andi	tempreg1,0x0f
		cpi	tempreg1,0x0f
		breq	fsys_sel_01		;page change
		rjmp	fsys_sel_02		;no page change

fsys_sel_30:	cpi	tempreg1,0xe5		;down
		brne	fsys_sel_35		;no
		lds	tempreg1,bas_partab+8	;maximum
		cp	tempreg1,tempreg4	
		brne	fsys_sel_31
		rjmp	fsys_sel_03		;do nothing

fsys_sel_31:	rcall	fsys_reinv		;re-invert
		inc	tempreg4		;+1
		mov	tempreg1,tempreg4
		andi	tempreg1,0x0f
		breq	fsys_sel_01		;page change
		rjmp	fsys_sel_02		;no page change
		
fsys_sel_35:	cpi	tempreg1,0xe6		;pageup
		brne	fsys_sel_40		;no
		cpi	tempreg4,0x10
		brcs	fsys_sel_03		;do nothing
		rcall	fsys_reinv		;re-invert
		subi	tempreg4,0x10		;-16
		rjmp	fsys_sel_01		;page change

fsys_sel_40:	cpi	tempreg1,0xe7		;pagedown
		brne	fsys_sel_45		;no
		lds	tempreg1,bas_partab+8	;max page
		cpi	tempreg1,0x0f
		breq	fsys_sel_45		;no page down at EEPROM
		subi	tempreg1,0x10
		cp	tempreg1,tempreg4
		brcs	fsys_sel_45		;do nothing
		rcall	fsys_reinv		;re-invert
		subi	tempreg4,0xf0		;+16
		rjmp	fsys_sel_01		;page change
		
fsys_sel_45:	rjmp	fsys_sel_03		;loop		
		
		
;------------------------------------------------------------------------------
;check flash for useability
;------------------------------------------------------------------------------
fsys_check:	call	fsys_maxpage		;get flash status
		cpi	tempreg1,0x00		;no
		brne	fsys_check_01
		pop	tempreg1		;kill stack
		pop	tempreg1		;kill stack
		rjmp	fsys_e_ndf		;show error: not found

fsys_check_01:	sts	bas_partab+8,tempreg1	;store no of pages
fsys_check_02:	libmio_sync
		libmio_sync
		rcall	fsys_checkf		;test for valid format
		cpi	tempreg1,0x01		;OK
		breq	fsys_check_04
		pop	tempreg1		;kill stack
		pop	tempreg1		;killstack
		rjmp	fsys_e_nfor		;show error: not formatted

fsys_check_04:	ret
		
;------------------------------------------------------------------------------
;error:not formatted  
;------------------------------------------------------------------------------
fsys_e_nfor:	libmio_alertthis
		.db	0x4f,"DFLASH not formatted",0
		ret				;abort

;------------------------------------------------------------------------------
;error:no dataflash found  
;------------------------------------------------------------------------------
fsys_e_ndf:;	libmio_thistext
;		.db	0,0,"EREG:",0
;		clr	ctrl
;		push	XH
;		push	XL
;		mov	XL,ereg
;		libmio_outhex
;		pop	XL
;		pop	XH
		libmio_alertthis
		.db	0x4f,"DFLASH error!",0,0
		ret				;end

;------------------------------------------------------------------------------
;error:cannot save  
;------------------------------------------------------------------------------
fsys_e_cns:	libmio_alertthis
		.db	0x4f,"Can not save on this",0
		ret				;end


;------------------------------------------------------------------------------
;error:cannot load  
;------------------------------------------------------------------------------
fsys_e_cnlb:	libmio_alertthis
		.db	0x4f,"No BASIC file",0,0
		ret				;end

;------------------------------------------------------------------------------
;error:cannot restore 
;------------------------------------------------------------------------------
fsys_e_cnlm:	libmio_alertthis
		.db	0x4f,"No BACKUP file",0
		ret				;end


;------------------------------------------------------------------------------
;ask:overwrite  
;------------------------------------------------------------------------------
fsys_over:	libmio_askthis
		.db	0xc0,"Overwrite file?",0,0
		ret

;------------------------------------------------------------------------------
;ask:delete  
;------------------------------------------------------------------------------
fsys_adel:	libmio_askthis
		.db	0x4f,"Delete file?",0
		ret


;------------------------------------------------------------------------------
;no space left  
;------------------------------------------------------------------------------
fsys_e_nsl:	libmio_alertthis
		.db	0x4f,"No space left",0,0
		ret				;end

;------------------------------------------------------------------------------
;list 16 files  
;tempreg4=file
;------------------------------------------------------------------------------
fsys_list:	push	tempreg2
		push	tempreg3
		push	tempreg4
		mov	XL,tempreg4		;copy pagestart
		andi	XL,0xf0			;table start
		sts	dflash_asel,XL		;store first number to display
		
fsys_list_01:
;set cursor
		lds	XL,dflash_asel		;file number
		andi	XL,0x0f			;only position in table
		subi	XL,0xfb			;+5 (Y-pos)
		mov	XH,XL
		ldi	XL,0x04			;X-pos
		libmio_gotoxy			;set cursor
		ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		
;output file number
		lds	XL,dflash_asel		;file number
		clr	XH			;max 256 files
		ldi	ctrl,0x05		;set format
		libmio_outdez			;output file number
		libmio_outspace			;and a space
		
;get file type to tempreg1
		ldi	XL,0x05			;color scheme (cyan on black)
		libmio_setcolor
		lds	XL,dflash_asel		;file number
		sts	bas_partab,XL
		rcall	fsys_gettype		;get file type
		rcall	fsys_pft		;print file type
		cpi	tempreg1,0xff		;empty
		breq	fsys_list_19		;yes
;		rjmp	fsys_list_17		;debug
		
;read first page
		lds	XL,dflash_asel		;position
		sts	bas_partab,XL		;set file number
		ldi	tempreg1,0x00
		sts	bas_partab+2,tempreg1
		ldi	tempreg1,0x02
		sts	bas_partab+4,tempreg1
		clr	ereg
		rcall	fsys_read		;read this page
		cpi	ereg,0x00		;OK?
		brne	fsys_list_17		;no -> empty
		ldi	YL,LOW(bas_array+512)	;no copy
		ldi	YH,HIGH(bas_array+512)		
		
;separating space
		libmio_outspace	

;output file name
		ldi	tempreg2,0x0c		;name length
fsys_list_14:	push	tempreg2
		ld	tempreg1,Y+		;get char
		cpi	tempreg1,0x80		;valid?
		brcs	fsys_list_15		;branch if yes
		ldi	tempreg1,'.'		;replace
fsys_list_15:	cpi	tempreg1,0x20		;valid?
		brcc	fsys_list_16		;branch if yes
		ldi	tempreg1,' '		;replace
fsys_list_16:	libmio_outchar
		pop	tempreg2
		dec	tempreg2
		brne	fsys_list_14		;loop

fsys_list_17:	lds	XL,dflash_asel		;file number
		inc	XL			;+1
		sts	dflash_asel,XL		;store back
		andi	XL,0x0f			;only number in table
		breq	fsys_list_18
		rjmp	fsys_list_01
fsys_list_18:	pop	tempreg4
		pop	tempreg3
		pop	tempreg2
		ret

fsys_list_19:	ldi	tempreg2,0x0d		;name length +1
fsys_list_20:	libmio_outspace			;write space char
		dec	tempreg2		;loop counter
		brne	fsys_list_20		;loop
		rjmp	fsys_list_17		;ok, done


;------------------------------------------------------------------------------
;invert line tempreg4
;------------------------------------------------------------------------------
fsys_inv:	push	tempreg1
		push	tempreg2
		ldi	YL,LOW(libmio_vram+690+150+4)
		ldi	YH,HIGH(libmio_vram+690+150+4)
		mov	tempreg1,tempreg4	;copy line number
		andi	tempreg1,0x0f
		ldi	tempreg2,30		;chars per line
		mul	tempreg1,tempreg2
		add	YL,r0			;set offset
		adc	YH,r1
		ldi	tempreg2,0xf2		;blue on white
		ldi	tempreg1,0x17		;23 chars
fsys_inv_1:	st	Y+,tempreg2
		dec	tempreg1		;loop counter
		brne	fsys_inv_1		;loop		
		pop	tempreg2
		pop	tempreg1
		ret

;------------------------------------------------------------------------------
;re-invert line tempreg4
;------------------------------------------------------------------------------
fsys_reinv:	push	tempreg1
		push	tempreg2
		ldi	YL,LOW(libmio_vram+690+150+4)
		ldi	YH,HIGH(libmio_vram+690+150+4)
		mov	tempreg1,tempreg4	;copy line number
		andi	tempreg1,0x0f
		ldi	tempreg2,30		;chars per line
		mul	tempreg1,tempreg2
		add	YL,r0			;set offset
		adc	YH,r1
		ldi	tempreg2,0x0c		;yellow on black
		ldi	tempreg1,0x4		;4 chars
fsys_reinv_1:	st	Y+,tempreg2
		dec	tempreg1		;loop counter
		brne	fsys_reinv_1		;loop
		ldi	tempreg2,0x0a		;cyan on black
		ldi	tempreg1,0x13		;19 chars
fsys_reinv_2:	st	Y+,tempreg2
		dec	tempreg1		;loop counter
		brne	fsys_reinv_2		;loop
		pop	tempreg2
		pop	tempreg1
		ret


;------------------------------------------------------------------------------
;wait for key release
;------------------------------------------------------------------------------
fsys_wnk:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	fsys_wnk		;wait for key release
		ret


;------------------------------------------------------------------------------
;save basic
;------------------------------------------------------------------------------
fsys_bsave:	sts	bas_partab,tempreg4	;file number
	    	ldi	tempreg1,0x0c		;12 pages
		sts	bas_partab+2,tempreg1	;set
		ldi	tempreg1,0x10		;file type
		sts	bas_partab+4,tempreg1	;set
		rcall	fsys_create		;create new file
		cpi	ereg,0x00
		breq	fsys_bover
		rjmp	fsys_e_ndf		;dataflash error

		
;------------------------------------------------------------------------------
;overwrite basic
;------------------------------------------------------------------------------
fsys_bover:	sts	bas_partab,tempreg4	;file number
		lds	ctrl,libmio_lastmenu	;program number
		ldi	ZL,LOW(bas_programs*2)
		ldi	ZH,HIGH(bas_programs*2)
		andi	ctrl,0x07		;limit programs
		swap	ctrl			;fileno*16
		ldi	tempreg1,0xc0		;*192
		mul	ctrl,tempreg1
		add	ZL,r0			;file offset
		adc	ZH,r1
		ldi	tempreg1,0x00		;first data page
fsys_bover_1:	push	tempreg1
		ldi	r16,0x00		;bytes to copy
		ldi	YL,LOW(bas_array+512)	;buffer
		ldi	YH,HIGH(bas_array+512)
fsys_bover_2:	lpm	r17,Z+			;get flash data
		st	Y+,r17			;write to buffer			
		dec	r16
		brne	fsys_bover_2
		sts	bas_partab+2,tempreg1	;page number
		ldi	tempreg1,0x02		;array pos
		sts	bas_partab+4,tempreg1	;set
		rcall	fsys_write		;write page
		pop	tempreg1
		inc	tempreg1
		cpi	tempreg1,0x0c		;all done
		brne	fsys_bover_1
		ret

;------------------------------------------------------------------------------
;load basic
;------------------------------------------------------------------------------
fsys_bload:	lds	ctrl,libmio_lastmenu
		andi	ctrl,0x07		;8 programs
		ldi	ZL,LOW(bas_programs*2)
		ldi	ZH,HIGH(bas_programs*2)
		swap	ctrl			;fileno*16
		ldi	tempreg1,0xc0		;*192
		mul	ctrl,tempreg1
		add	ZL,r0			;file offset
		adc	ZH,r1
		ldi	tempreg1,0x00		;first data page
fsys_bload1:	push	tempreg1
		sts	bas_partab+2,tempreg1	;page number
		ldi	tempreg1,0x02		;array pos
		sts	bas_partab+4,tempreg1	;set
		sts	bas_partab,tempreg4	;file number
		rcall	fsys_read
		ldi	YL,LOW(bas_array+512)	;buffer
		ldi	YH,HIGH(bas_array+512)	
		call	mem_writepage		;write to flash
		adiw	ZL,2			;next flash page
		pop	tempreg1
		inc	tempreg1		;page counter
		cpi	tempreg1,0x0c		;last?
		brne	fsys_bload1		;no
		sei
		ret	

		
;------------------------------------------------------------------------------
;print file type (tempreg1)
;------------------------------------------------------------------------------
fsys_pft:	cpi	tempreg1,0x10		;BASIC
		brne	fsys_pft_01		;no
		libmio_thistext
		.db	255,"BAS:",0
		ldi	tempreg1,0x10
		ret

fsys_pft_01:	cpi	tempreg1,0x12		;BACKUP
		brne	fsys_pft_02		;no
		libmio_thistext
		.db	255,"BUP:",0
		ldi	tempreg1,0x12
		ret

fsys_pft_02:	cpi	tempreg1,0x14		;USER
		brne	fsys_pft_03		;no
		libmio_thistext
		.db	255,"USR:",0
		ldi	tempreg1,0x14
		ret

fsys_pft_03:	cpi	tempreg1,0x16		;chip8
		brne	fsys_pft_04		;no
		libmio_thistext
		.db	255,"CH8:",0
		ldi	tempreg1,0x16
		ret

fsys_pft_04:	cpi	tempreg1,0x18		;native
		brne	fsys_pft_05		;no
		libmio_thistext
		.db	255,"AVR:",0
		ldi	tempreg1,0x18
		ret

fsys_pft_05:	cpi	tempreg1,0x1a		;GPS position list
		brne	fsys_pft_06		;no
		libmio_thistext
		.db	255,"GPO:",0
		ldi	tempreg1,0x1a
		ret

fsys_pft_06:	cpi	tempreg1,0x1c		;Sampling data
		brne	fsys_pft_07		;no
		libmio_thistext
		.db	255,"SAM:",0
		ldi	tempreg1,0x1c
		ret

fsys_pft_07:	cpi	tempreg1,0x1e		;logic blocks
		brne	fsys_pft_99		;no
		libmio_thistext
		.db	255,"LBL:",0
		ldi	tempreg1,0x1e
		ret


fsys_pft_99:	libmio_thistext			;NO FILE
		.db	255,"----",0
		ldi	tempreg1,0xff		;empty
		ret	
		
;------------------------------------------------------------------------------
;create backup
;------------------------------------------------------------------------------
fsys_msave:	sts	bas_partab,tempreg4	;file number
	    	ldi	tempreg1,0x60		;96 pages
		sts	bas_partab+2,tempreg1	;set
		ldi	tempreg1,0x12		;file type
		sts	bas_partab+4,tempreg1	;set
		rcall	fsys_create		;create new file
		cpi	ereg,0x00
		breq	fsys_mover
		rjmp	fsys_e_ndf		;dataflash error


;------------------------------------------------------------------------------
;overwrite backup
;------------------------------------------------------------------------------
fsys_mover:	sts	bas_partab,tempreg4	;file number
		clr	tempreg1		;first page
		ldi	ZL,LOW(bas_programs*2)
		ldi	ZH,HIGH(bas_programs*2)
fsys_mover1:	push	tempreg1
		ldi	YL,LOW(bas_array+512)	;buffer
		ldi	YH,HIGH(bas_array+512)
		clr	r0			;256 bytes
fsys_mover2:	lpm	r1,Z+			;copy from flash to ram
		st	Y+,r1		
		dec	r0
		brne	fsys_mover2		;loop
		sts	bas_partab+2,tempreg1	;page number
		ldi	tempreg1,0x02		;array pos
		sts	bas_partab+4,tempreg1	;set
		rcall	fsys_write		;write page 0
		pop	tempreg1
		inc	tempreg1		;page+1
		cpi	tempreg1,0x60
		brne	fsys_mover1
		ret

;------------------------------------------------------------------------------
;restore
;------------------------------------------------------------------------------
fsys_mload:	ldi	tempreg1,0x00		;first data page
		ldi	ZL,LOW(bas_programs*2)	;start address
		ldi	ZH,HIGH(bas_programs*2)
		
fsys_mload1:	push	tempreg1
		sts	bas_partab+2,tempreg1	;page number
		ldi	tempreg1,0x02		;array pos
		sts	bas_partab+4,tempreg1	;set
		sts	bas_partab,tempreg4	;file number
		rcall	fsys_read
		ldi	YL,LOW(bas_array+512)	;buffer
		ldi	YH,HIGH(bas_array+512)
		call	mem_writepage
		adiw	ZL,2			;correct pointer
		pop	tempreg1
		inc	tempreg1
		cpi	tempreg1,0x60
		brne	fsys_mload1		
		sei
		ret	

;------------------------------------------------------------------------------
;write-alertbox
;------------------------------------------------------------------------------
fsys_wal:	push	tempreg1		;save registers
		push	ZH
		push	ZL
		push	YH
		push	YL
		push	XH
		push	XL
		lds	tempreg1,libmio_color	;old color
		sts	bas_partab+9,tempreg1	;save
		ldi	tempreg1,0x4c		;yellow on red
		sts	libmio_color,tempreg1	;set new color
		ldi	YL,6
		ldi	YH,10
		ldi	ZL,23
		ldi	ZH,12
		libmio_wbox			;draw window
		libmio_thistext
		.db 	11,7,"Writing data...",0
		lds	tempreg1,bas_partab+9
		sts	libmio_color,tempreg1	;restore old color
		pop	XL			;restore registers
		pop	XH
		pop	YL
		pop	YH
		pop	ZL
		pop	ZH
		pop	tempreg1
		ret

;------------------------------------------------------------------------------
;show number and name
;------------------------------------------------------------------------------
fsys_snn:	ldi	YL,LOW(libmio_vram+98)
		ldi	YL,LOW(libmio_vram+98)
		lds	tempreg1,libmio_lastmenu
		mov	ctrl,tempreg1
		subi	tempreg1,0xcf
		st	Y+,tempreg1
		ldi	tempreg1,0x20
		st	Y+,tempreg1
		ldi	tempreg1,0x5b
		st	Y+,tempreg1
		lds	tempreg1,libmio_config
		push	tempreg1
		ori	tempreg1,0x80
		sts	libmio_config,tempreg1
		call	mem_readnamec
		ldi	tempreg1,0x5d
		st	Y+,tempreg1
		pop	tempreg1
		sts	libmio_config,tempreg1
		ret	
		
;------------------------------------------------------------------------------
;subroutines
;------------------------------------------------------------------------------
fsys_free:
		libdfl_free
		ret
		
fsys_gettype:
		libdfl_gettype
		ret
		
fsys_size:
		libdfl_size
		ret
		
fsys_gword:
		libdfl_gword
		ret
		
fsys_checkf:
		libdfl_checkformat
		ret
		
fsys_create:
		libdfl_create
		ret
		
fsys_delete:
		libdfl_delete
		ret
		
fsys_read:
		libdfl_read
		ret
		
fsys_write:
		libdfl_write
		ret
		
fsys_maxpage:
		libdfl_maxpage
		ret
		
fsys_format:
		libdfl_format
		ret
	

				