;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# monitor module								#
;# copyright (c) 2007-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-----------------------------------------------------------------------
; backup and restore screen
;-----------------------------------------------------------------------
mon_backup:	push	ZH			;save registers
		push	ZL
		lds	XL,libmio_vidmode	;save videomode
		sts	basram_mmode,XL
		clr	XL
		libmio_setvmode	
		lds	XL,libmio_color		;save color
		sts	basram_mcolor,XL
		lds	XL,libmio_border	;save border color
		sts	basram_mborder,XL		
		lds	XL,libmio_channel	;save channel
		sts	basram_mchannel,XL
		sts	libmio_channel,const_0	;screen
		ldi	ZL,LOW(libmio_vram)	;source address
		ldi	ZH,HIGH(libmio_vram)
		ldi	YL,LOW(mon_bpage)	;dest address
		ldi	YH,HIGH(mon_bpage)
mon_backup0:	ldi	XH,libmio_rows*2
mon_backup1:	ldi	XL,libmio_cols
mon_backup2:	ld	tempreg1,Z+		;get byte
		st	Y+,tempreg1
		dec	XL
		brne	mon_backup2
		dec	XH
		brne	mon_backup1
		pop	ZL			;restore registers
		pop	ZH
		ret
		
mon_restore:	push	ZH
		push	ZL
		lds	XL,basram_mmode
		libmio_setvmode
		lds	XL,basram_mborder	;restore border color
		sts	libmio_border,XL	
		lds	XL,basram_mcolor	;restore color
		sts	libmio_color,XL
		lds	XL,basram_mchannel	;restore channel
		sts	libmio_channel,XL
		ldi	ZL,LOW(mon_bpage)	;source address
		ldi	ZH,HIGH(mon_bpage)
		ldi	YL,LOW(libmio_vram)	;dest address
		ldi	YH,HIGH(libmio_vram)
		rjmp	mon_backup0

;-----------------------------------------------------------------------
; show io
;-----------------------------------------------------------------------
mon_sio:	lds	XL,libmio_sysconf
;		sbrc	XL,4
;		rjmp	mon_nsio
		ldi	YL,LOW(libmio_vram+19*libmio_cols+4)
		ldi	YH,HIGH(libmio_vram+19*libmio_cols+4)
		ldi	XL,'I'			;in
		ldi	XH,'O'			;out
		in	tempreg1,DDRA
		ldi	tempreg2,8
mon_sio1:	sbrc	tempreg1,0
		st	Y+,XH
		sbrs	tempreg1,0
		st	Y+,XL
		lsr	tempreg1
		dec	tempreg2
		brne	mon_sio1
		ldi	YL,LOW(libmio_vram+20*libmio_cols+4)
		ldi	YH,HIGH(libmio_vram+20*libmio_cols+4)
		ldi	XL,'0'			;0
		ldi	XH,'1'			;1
		in	tempreg1,PINA
		ldi	tempreg2,8
mon_sio2:	sbrc	tempreg1,0
		st	Y+,XH
		sbrs	tempreg1,0
		st	Y+,XL
		lsr	tempreg1
		dec	tempreg2
		brne	mon_sio2
		ldi	YL,LOW(libmio_vram+19*libmio_cols+694)
		ldi	YH,HIGH(libmio_vram+19*libmio_cols+694)
		ldi	XL,0xaf			;in
		ldi	XH,0x2f			;out
		in	tempreg1,DDRA
		ldi	tempreg2,8
mon_sio3:	sbrc	tempreg1,0
		st	Y+,XH
		sbrs	tempreg1,0
		st	Y+,XL
		lsr	tempreg1
		dec	tempreg2
		brne	mon_sio3
		ldi	YL,LOW(libmio_vram+20*libmio_cols+694)
		ldi	YH,HIGH(libmio_vram+20*libmio_cols+694)
		ldi	XL,0x80			;0
		ldi	XH,0x4e			;1
		in	tempreg1,PINA
		ldi	tempreg2,8
mon_sio4:	sbrc	tempreg1,0
		st	Y+,XH
		sbrs	tempreg1,0
		st	Y+,XL
		lsr	tempreg1
		dec	tempreg2
		brne	mon_sio4
		ret

mon_nsio:	libmio_thistext
		.db 19,0," IO DISABLED ",0	
		ret
		
;-----------------------------------------------------------------------
; show variables
;-----------------------------------------------------------------------
mon_svar:	mov	tempreg1,tempreg2
		ldi	XL,0x16			;yellow
		libmio_setcolor
		subi	tempreg1,0xbf		;+65
		libmio_outchar			;write var name
		ldi	tempreg1,'='
		libmio_outchar
		ldi	XL,0x17			;white
		libmio_setcolor
		ldi	YL,LOW(varspace)
		ldi	YH,HIGH(varspace)
		add	YL,tempreg2
		adc	YH,const_0
		add	YL,tempreg2
		adc	YH,const_0
		ld	XL,Y+
		ld	XH,Y+
		ldi	ctrl,0x0d		;standard format
		libmio_outdez
		ret

;-----------------------------------------------------------------------
; show stack
;-----------------------------------------------------------------------
mon_viewstack:	ldi	XL,19
		libmio_gotoxy
		ldi	XL,5
		mov	YL,tempreg3
		dec	YL
		mul	XL,YL
		ldi	YL,LOW(bas_stacks)
		ldi	YH,HIGH(bas_stacks)
		add	YL,r0
		adc	YH,r1
		ld	XL,Y			;line number
		sbrs	XL,7			;check call/for flag
		rjmp	mon_vst_10		;for
		libmio_thistext
		.db	255,"CALL  ",0
		ldd	XL,Y+1			;statement number
		andi	XL,0x7f
		rjmp	mon_vst_11

		ret
mon_vst_10:	libmio_thistext
		.db	255,"FOR ",0
		ldd	tempreg1,Y+2		;variable offset
		lsr	tempreg1
		subi	tempreg1,0xbf
		libmio_outchar
		libmio_outspace
		ldd	XL,Y+1			;line number
mon_vst_11:	clr	XH
		inc	XL
    		ldi	ctrl,2			;min with zeroes
		libmio_outdez			;write line number
		ldi	tempreg1,':'
		libmio_outchar
		clr	XH
		ld	XL,Y
		andi	XL,0x7f			;clear bit 7
		libmio_outdez			;write statement number
		ret

;-----------------------------------------------------------------------
; show monitor screen
;-----------------------------------------------------------------------
mon_show:	sts	libmio_border,const_0
		clr	ctrl
		ldi	XL,0x07			;white on black
		libmio_setcolor
		libmio_clrscr			;clear screen
		libmio_thistext
		.db 18,0,"BIT 01234567",0,0	;io view
		libmio_thistext
		.db 19,0,"DIR",0		;io view
		libmio_thistext
		.db 20,0,"LEV",0		;io view
		ldi	ZL,LOW(mon_mdata*2)
		ldi	ZH,HIGH(mon_mdata*2)
		libmio_drawmenu
		ldi	XL,0x05			;cyan on black
		libmio_setcolor
		libmio_thistext
		.db 0,0,"AVR-ChipBasic2 MON    P",0	;head message
		lds	tempreg1,libmio_ram+47		;program number
		subi	tempreg1,0xcf
		libmio_outchar
		libmio_thistext
		.db 255,":",0,0		
		ldi 	ctrl,2			;format 2 digits
		clr	XH
		mov	XL,r12			;line number
		inc	XL
		libmio_outdez
		libmio_thistext
		.db 255,":",0,0		
		clr	XH
		mov	XL,r13			;statement number
		inc	XL
		libmio_outdez
		ldi	ZL,LOW(bas_inbuf+3)	;copy line
		ldi	ZH,HIGH(bas_inbuf+3)
		ldi	YL,LOW(libmio_vram+1*libmio_cols)
		ldi	YH,HIGH(libmio_vram+1*libmio_cols)
		ldi	XL,libmio_cols
		ldi	tempreg1,0xf1
mon_show0:	ld	XH,Z+
		cpi	XH,0x00			;end of line
		breq	mon_show00
		std	Y+libmio_cols,XH
		std	Y+(2*libmio_cols),tempreg1
		st	Y+,tempreg1
		dec	XL
		brne	mon_show0		
		rjmp	mon_show04
mon_show00:	ldi	XH,0x20
		std	Y+libmio_cols,XH
		std	Y+(2*libmio_cols),tempreg1
		st	Y+,tempreg1
		dec	XL
		brne	mon_show00		
mon_show04:	ldi	XL,0x17			;BGD blue
		libmio_setcolor
		ldi	YL,0
		ldi	YH,4
		ldi	ZL,17
		ldi	ZH,16
		libmio_cbox
	
	
		ldi 	ctrl,0x0d		;format 5 digits/leading spaces 
		ldi	tempreg2,0x00		;start with var A
mon_show1:	mov	tempreg1,tempreg2	;copy number
		subi	tempreg1,252		;+4
		mov	XH,tempreg1
		clr	XL
		libmio_gotoxy
		rcall	mon_svar
		inc	tempreg2
		cpi	tempreg2,13
		brne	mon_show1		
		
mon_show2:	mov	tempreg1,tempreg2	;copy number
		subi	tempreg1,9		;-13+4
		mov	XH,tempreg1
		ldi	XL,9
		libmio_gotoxy
		rcall	mon_svar
		inc	tempreg2
		cpi	tempreg2,26
		brne	mon_show2		

		ldi	XL,0x37			;BGD magenta
		libmio_setcolor
		ldi	YL,19
		ldi	YH,4
		ldi	ZL,29
		ldi	ZH,16
		libmio_cbox
	
		libmio_thistext
		.db	4,19,"STACK:",0,0
		clr ctrl			;format 2 digits compact
		clr	XH
		lds	XL,bas_stackp		;stackpointer
		libmio_outdez

		ldi	tempreg3,12

mon_show4:	lds	YL,bas_stackp			;stackpointer
		cp	YL,tempreg3
		brcs	mon_show5
		sub	YL,tempreg3
		ldi	XH,4
		add	XH,tempreg3
		rcall	mon_viewstack
mon_show5:	dec	tempreg3
		brne	mon_show4


mon_show8:	ret



;-----------------------------------------------------------------------
; monitor main loop
;-----------------------------------------------------------------------
mon_main:	push	tempreg1
	    	push	tempreg2
		push	tempreg3
	    	push	tempreg4
		push	ZL
		push	ZH
		push	YL
		push	YH
		push	XL
		push	XH
		push	libmio_cur_x
		push	libmio_cur_y
		push	ereg
		push	ctrl

		rcall	mon_backup		;save screen
		rcall	xlin_main		;expand line
mon_main_00:	rcall	mon_show		;show screen
mon_main_0:	rcall	mon_waitkey		;wait for key
		clr	ereg
		lds	XL,libmio_kflags
		cpi	tempreg1,0xed		;exit
		brne	mon_main_1
		ori	XL,0x01			;set break flag
		rjmp	mon_main_end

mon_main_1:	cpi	tempreg1,0xf1		;go
		brne	mon_main_2
		clr	XL			;continue
		rjmp	mon_main_end

mon_main_2:	cpi	tempreg1,0xf2		;step
		brne	mon_main_3 
		ori	XL,0x04			;set monitor flag again
		rjmp	mon_main_end

mon_main_3:	cpi	tempreg1,0xf3		;view
		brne	mon_main_4
		rcall	mon_restore		;restore screen
		libmio_waitkey			;wait for keypress
		clr	XL			;set video mode to text
		libmio_setvmode
		rjmp	mon_main_00		;monitor loop	
		
mon_main_4:	cpi	tempreg1,0xf4		;Array
		brne	mon_main_0
		rjmp	mon_array


mon_main_end:	sts	libmio_kflags,XL	;store flags	
mon_main_end1:	lds	tempreg1,libmio_keycode	;wait until key is released
		cpi	tempreg1,0
		brne	mon_main_end1
		rcall	mon_restore
mme1:		pop	ctrl
		pop	ereg
		pop	libmio_cur_y
		pop	libmio_cur_x
		pop	XH
		pop	XL
		pop	YH
		pop	YL
		pop	ZH
		pop	ZL
		pop	tempreg4
		pop	tempreg3
		pop	tempreg2
		pop	tempreg1
		ret	
							
mon_waitkey:	sts	libmio_lastkey,const_0	;delete last pressed key
mon_waitkey1:	rcall	mon_sio			;show IO
		lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		breq	mon_waitkey1
		jmp	libmio_scrs		;screenshot
		

;------------------------------------------------------------------------
;View array
;------------------------------------------------------------------------
mon_array:	libmio_nokey
		ldi	tempreg4,0		;array base
		clr	tempreg5		;no text
mon_array_02:	rcall	mon_varr		;view array
mon_array_03:	ldi	ZL,LOW(mon_amdata*2)
		ldi	ZH,HIGH(mon_amdata*2)
		libmio_drawmenu
		
mon_array_03a:	libmio_waitkey
		
		cpi	tempreg1,0xed		;exit
		brne	mon_array_04
		ori	XL,0x01			;set break flag
		rjmp	mon_main_end
mon_array_04:	cpi	tempreg1,0xf4		;return to monitor
		brne	mon_array_05
		libmio_nokey
		rjmp	mon_main_00
		
mon_array_05:	cpi	tempreg1,0xe6		;page up
		brne	mon_array_10
		cpi	tempreg4,0
		breq	mon_array_03		;we are at first pos
mon_array_06:	dec	tempreg4
		libmio_nokey
		rjmp	mon_array_02

mon_array_10:	cpi	tempreg1,0xe7		;page down
		brne	mon_array_12		;no
		cpi	tempreg4,10
		brcc	mon_array_03		;last position?
		inc	tempreg4
		libmio_nokey
		rjmp	mon_array_02

mon_array_12:	cpi	tempreg1,0xf3		;text insert
		brne	mon_array_03		;no
		inc	tempreg5
		libmio_nokey
		rjmp	mon_array_02

;view array at pos
mon_varr:	ldi	XL,0x07			;white on black
		libmio_setcolor
		libmio_clrscr			;clear screen
		libmio_thistext
		.db 0,0,"AVR-ChipBasic2 Array View",0	;array view
		ldi	XL,0x60			;black on yellow
		libmio_setcolor
		libmio_thistext
		.db 2,0,"Adr  ",0		;address
		ldi	XL,0x50			;black on cyan
		libmio_setcolor
		libmio_thistext
		.db 2,5,"         Data           ",0,0	;data
		ldi	tempreg3,64
		mul	tempreg3,tempreg4
		ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		add	YL,r0
		adc	YH,r1
		movw	ZL,r0
		ldi	tempreg3,3
mon_varr_02:	ldi	XL,0			;X-pos
		mov	XH,tempreg3		;Y-pos
		libmio_gotoxy			;set pos
		ldi	XL,0x06			;yellow on black
		libmio_setcolor
		movw	XL,ZL
		ldi	ctrl,0x01		;hex16
		libmio_outhex			;show address
		ldi	XL,5			;X-pos
		mov	XH,tempreg3		;Y-pos
		libmio_gotoxy			;set pos
		ldi	XL,0x05			;cyan on black
		libmio_setcolor
		ldi	ctrl,0			;hex8
		ldi	tempreg2,8
mon_varr_04:	ld	XL,Y+
		ldi	XH,0
		libmio_outhex
		mov	tempreg1,tempreg5
		sbrs	tempreg1,0
		rjmp	mon_varr_10
		ldi	XL,0x17			;white on blue
		libmio_setcolor
		sbiw	YL,1
		ld	tempreg1,Y+
		libmio_outchar
		ldi	XL,0x05			;cyan on black
		libmio_setcolor
		rjmp	mon_varr_12

mon_varr_10:	libmio_outspace
mon_varr_12:	dec	tempreg2
		brne	mon_varr_04
		adiw	ZL,8
		inc	tempreg3
		cpi	tempreg3,19
		brne	mon_varr_02
		ret




		    ;....111111222222333333444444555555
mon_amdata:	.db  	" Exit              Char  Mon  "
mon_mdata:	.db	" Exit   Go   Step  View  Array"
		