;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# spi transfer module								#
;# copyright (c) 2006-2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

spi_set:	cpi	XL,0xff
		brne	spi_set_2

spi_set_1:	sbi	PORTB,4			;end transfer
		out	SPCR0,const_0		;disable SPI			
		ldi	XL,0x5c			;standard
		out	SPCR0,XL
		out	SPSR0,const_1		
	    	ret
		
spi_set_2:	bld	XL,7			;SS enable bit
		out	SPCR0,const_0		;disable SPI
		andi	XL,0x3f
		ori	XL,0x40
		out	SPCR0,XL
		out	SPSR0,const_1			
		in	XL,PORTB
		bst	XL,4	
		out	PORTB,XL		;start transfer
	    	ret
		
spi_wait:	in	XH,SPSR0
		sbrs	XH,SPIF0
		rjmp	spi_wait
		ret
		