;################################################################################
;#										#
;# avr-chipbasic2M - mobile single chip basic computer with ATmega644		#
;# X-Modem routines								#
;# copyright (c) 2008 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 2		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################		
		
;-----------------------------------------------------------------------------
; send program to XMODEM
;-----------------------------------------------------------------------------
send_prog:	ldi	tempreg3,1			;first block number
		libmio_gserb				;get char
		
		lds	tempreg2,libmio_keycode		;get keycode
		cpi	tempreg2,0xed			;ESC
		brne	send_prog_01			;not
send_prog_00:	ret					;OK, done
				
send_prog_01:	cpi	tempreg1,0x15			;NAK?
		brne	send_prog			;no->loop
		
		lds	ctrl,libmio_lastmenu		;program number
		ldi	ZL,LOW(bas_programs*2)
		ldi	ZH,HIGH(bas_programs*2)
		andi	ctrl,0x07			;limit programs
		swap	ctrl				;progno*16
		ldi	tempreg1,0xc0			;*192
		mul	ctrl,tempreg1
		add	ZL,r0				;add offset
		adc	ZH,r1
		
send_prog_02:	ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		ldi	tempreg2,0
send_prog_03:	lpm	tempreg1,Z+			;copy to RAM
		st	Y+,tempreg1				
		dec	tempreg2
		brne	send_prog_03	
		
send_prog_04:	ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		libmio_sendx				;send data block		
		libmio_gserb				;get char		
		lds	tempreg2,libmio_keycode		;get keycode
		cpi	tempreg2,0xed			;ESC
		breq	send_prog_00			;yes
		cpi	tempreg1,0x06			;ACK?
		brne	send_prog_04			;no->repeat
		
		inc	tempreg3			;block+1

send_prog_05:	ldi	YL,LOW(bas_array+128)
		ldi	YH,HIGH(bas_array+128)
		libmio_sendx				;send data block		
		libmio_gserb				;get char		
		lds	tempreg2,libmio_keycode		;get keycode
		cpi	tempreg2,0xed			;ESC
		breq	send_prog_00			;yes
		cpi	tempreg1,0x06			;ACK?
		brne	send_prog_05			;no->repeat				
		
		inc	tempreg3
		cpi	tempreg3,25			;all done
		brne	send_prog_02			;no
		ldi	tempreg1,0x04			;send EOT
		libmio_pser						
		ret					;yes
		
				
				
;------------------------------------------------------------------------------
;receive program via XMODEM
;------------------------------------------------------------------------------
recv_prog:	lds	ctrl,libmio_lastmenu
		andi	ctrl,0x07			;8 programs
		ldi	ZL,LOW(bas_programs*2)
		ldi	ZH,HIGH(bas_programs*2)
		swap	ctrl				;fileno*16
		ldi	tempreg1,0xc0			;*192
		mul	ctrl,tempreg1
		add	ZL,r0				;file offset
		adc	ZH,r1
		
		ldi	tempreg1,0x15			;send NAK to start
		libmio_pser
		ldi	tempreg3,0			;blocks received		
recv_prog_00:	push	tempreg3

		
recv_prog_01:	ldi	YL,LOW(bas_array+512)
		ldi	YH,HIGH(bas_array+512)
		libmio_recvx				;send data block
		cpi	ereg,0
		breq	recv_prog_01a
		cpi	ereg,1
		breq	recv_prog_end
		cpi	ereg,40
		breq	recv_prog_end			;abort condition
		ldi	tempreg1,0x15			;send NAK
		libmio_pser		
		rjmp	recv_prog_01			;receive again
recv_prog_01a:	ldi	tempreg1,0x06			;send ACK
		libmio_pser	
		
recv_prog_02:	ldi	YL,LOW(bas_array+640)
		ldi	YH,HIGH(bas_array+640)
		libmio_recvx				;send data block			
		cpi	ereg,0
		breq	recv_prog_03
		cpi	ereg,1
		breq	recv_prog_end
		cpi	ereg,40
		breq	recv_prog_end			;abort condition
		ldi	tempreg1,0x15			;send NAK
		libmio_pser		
		rjmp	recv_prog_02			;receive again		
		
recv_prog_03:	call	mem_writepage			;write to flash
		sei
		adiw	ZL,2				;next flash page
		ldi	tempreg1,0x06			;send ACK
		libmio_pser		
		pop	tempreg3
		inc	tempreg3
		cpi	tempreg3,12
		brne	recv_prog_00

recv_prog_04:	libmio_gser
		cpi	tempreg1,0x04			;EOT
		brne	recv_prog_04
		ldi	tempreg1,0x06			;send ACK
		libmio_pser	
		ret
		
recv_prog_end:	pop	tempreg3
		ret		
		

;-----------------------------------------------------------------------------
; send internal EEPROM (1792 bytes log area) to XMODEM
;-----------------------------------------------------------------------------
send_intee:	ldi	tempreg3,1			;first block number
		libmio_gserb				;get char
		
		lds	tempreg2,libmio_keycode		;get keycode
		cpi	tempreg2,0xed			;ESC
		brne	send_intee_01			;not
send_intee_00:	ret					;OK, done
				
send_intee_01:	cpi	tempreg1,0x15			;NAK?
		brne	send_intee			;no->loop
		
send_intee_02:	ldi	XL,128				;bytes per page
		mov	tempreg4,tempreg3
		dec	tempreg4
		mul	XL,tempreg4
		movw	YL,r0				;get EE start address
		ldi	XL,LOW(bas_array)
		ldi	XH,HIGH(bas_array)
		ldi	tempreg4,128			;number of bytes
send_intee_03:	libeep_read				;copy to RAM
		st	X+,tempreg1				
		dec	tempreg4
		brne	send_intee_03
				
send_intee_04:	ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		libmio_sendx				;send data block		
		libmio_gserb				;get char		
		lds	tempreg2,libmio_keycode		;get keycode
		cpi	tempreg2,0xed			;ESC
		breq	send_intee_00			;yes
		cpi	tempreg1,0x06			;ACK?
		brne	send_intee_04			;no->repeat
		inc	tempreg3			;block+1
		cpi	tempreg3,15			;all done
		brne	send_intee_02			;no
		ldi	tempreg1,0x04			;send EOT
		libmio_pser								
		ret					;yes
		
;------------------------------------------------------------------------------
;receive internal EEPROM via XMODEM (1792 bytes log area)
;------------------------------------------------------------------------------
recv_intee:	ldi	tempreg1,0x15			;send NAK to start
		libmio_pser
		ldi	tempreg3,0			;blocks received		
recv_intee_00:	push	tempreg3

recv_intee_01:	ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		libmio_recvx
		cpi	ereg,0
		breq	recv_intee_02
		cpi	ereg,40
		breq	recv_intee_end			;abort condition
		ldi	tempreg1,0x15			;send NAK
		libmio_pser		
		rjmp	recv_intee_01			;receive again
recv_intee_02:	
		ldi	XL,128				;bytes per page
		mov	tempreg4,tempreg3
		dec	tempreg4
		mul	XL,tempreg4
		movw	YL,r0				;get EE start address
		ldi	XL,LOW(bas_array)
		ldi	XH,HIGH(bas_array)
recv_intee_03:	ldi	tempreg4,128			;number of bytes
recv_intee_04:	ld	tempreg1,X+
		libeep_write				
		dec	tempreg4
		brne	recv_intee_04
		
		ldi	tempreg1,0x06			;send ACK
		libmio_pser			
		
		pop	tempreg3
		inc	tempreg3
		cpi	tempreg3,14
		brne	recv_intee_00
recv_intee_05:	libmio_gser
		cpi	tempreg1,0x04			;EOT
		brne	recv_intee_05
		ldi	tempreg1,0x06			;send ACK
		libmio_pser				
		ret
		
recv_intee_end:	pop	tempreg3
		ret		
				
	