/***********************************************************************/
// Titel     	: HAA-BUS
//----------------------------------------------------------------------
// Beschreibung	: Zusammenstellung relevanter Daten zur Anzeige und 
//				: externer Ansteuerung weiterer Elektronik der Hausalarmanlage
//----------------------------------------------------------------------
// Autor     	: P. Fuhsy
/***********************************************************************/

//-----------------------------Includes---------------------------------
#include <avr/io.h>			//allg. Ports
#include <stdlib.h>			//Standard-Lib
#include <stdbool.h>		//fr Bool-Variablen
#include <string.h>			//zur Stringbearbeitung
#include "haa_bus.h"		//eigene Header
#include "uart.h"			//zur UART-bertragung
//----------------------------------------------------------------------

//-----------------------Konstanten / Variablen-------------------------
//Initialisierung der Bytes
uint8_t BAS	= 0;			//Basis Status
uint8_t SIR	= 0;			//Sirene Status
uint8_t IN0	= 0;			//Status der Kontakte Teil 1
uint8_t IN1	= 0;			//Status der Kontakte Teil 2
uint8_t RES	= 0;			//Reserve
uint8_t SWH	= 0;			//Software-Version Hauptversion
uint8_t SWN	= 0;			//Software-Version Nebenversion
uint8_t CHK	= 0;			//Checksumme
char HAAHEX[_DATA_LEN];	//HAA-Bus als HEX-Wert

//----------------------------------------------------------------------

//------------------------------Funktionen------------------------------
void BAS_byte_schreiben (bool kom, bool err, bool csab, bool alf, bool als, bool alm, bool val, bool kal)	//Statusmeldungen der Basis
{
	BAS = (kom << 7) | (err << 6) | (csab << 5) | (alf << 4) | (als << 3) | (alm << 2) | (val << 1) | (kal << 0);
}
void SIR_byte_schreiben (bool ssab, bool fkt, bool sto)	//Statusmeldungen der Sirene
{
	SIR = (ssab << 2) | (fkt << 1) | (sto << 0);
}
void IN0_byte_schreiben (bool *input)					//Zustnde der Kontakte							//TODO
{
/*	int wert = 0;
	
	for (int i=1; i <=128; i *= 2)			
	{
	wert += *input *i;				//Wertigkeit berechnen und dazu addieren
	*input++;			
	}	
		
	IN0 = wert;						//Wert bertragen
*/
	input[7] = 0 ;
	IN0 = (input[7] << 7) | (input[6] << 6) | (input[5]<< 5) | (input[4] << 4) | (input[3] << 3) | (input[2] << 2) | (input[1] << 1) | (input[0] << 0);

}
void IN1_byte_schreiben (bool insab)					//Status der Kontakte
{
	IN1 = (insab << 0);

}
void RES_byte_schreiben ()								//Reserve
{
	RES = 0;
}
void SWP_byte_schreiben (char swh, char swn)			//Software-Version des Projektes zusammensetzten
{
	SWH = swh;	//Wert im Byte aufteilen	
	SWN = swn;	//Wert im Byte aufteilen								
}
void CHK_byte_schreiben()								//Checksumme bilden
{
	CHK = BAS ^ SIR ^ IN0 ^ IN1 ^ RES ^ SWH ^ SWN;
}
void HAA_Bus_Hex()										//Bildet einen Hex-Wert des kompletten Busses					
{
	//Array um uint8 in char zu wandeln
	char bas_hex[3];
	char sir_hex[3];
	char in0_hex[3];
	char in1_hex[3];
	char res_hex[3];
	char swh_hex[3];
	char swn_hex[3];
	char chk_hex[3];
	
	//Char in Hexzahl wandeln
	sprintf(bas_hex, "%02x", BAS);
	sprintf(sir_hex, "%02x", SIR);
	sprintf(in0_hex, "%02x", IN0);
	sprintf(in1_hex, "%02x", IN1);
	sprintf(res_hex, "%02x", RES);
	sprintf(swh_hex, "%02x", SWH);
	sprintf(swn_hex, "%02x", SWN);
	sprintf(chk_hex, "%02x", CHK);
			
	//Inhalte vom Array lschen
	memset(HAAHEX, '\0', sizeof(HAAHEX));	
	
	//Hexzahl zusammenfgen
	strcat(HAAHEX, bas_hex);
	strcat(HAAHEX, sir_hex);
	strcat(HAAHEX, in0_hex);
	strcat(HAAHEX, in1_hex);
	strcat(HAAHEX, res_hex);
	strcat(HAAHEX, swh_hex);
	strcat(HAAHEX, swn_hex);
	strcat(HAAHEX, chk_hex);
	strcat(HAAHEX, "\0");		//String abschliessen			
} 	
