#ifndef _HAA_BUS_H_
#define _HAA_BUS_H_

#define _DATA_LEN		17	//Zeichenlnge des Busses, 8x 2stellige Werte + 1 Abschlusszeichen

//------------------------------Prototypen-------------------------------
void BAS_byte_schreiben (bool kom, bool err, bool csab, bool alf, bool als, bool alm, bool val, bool kal);
void SIR_byte_schreiben (bool ssab, bool fkt, bool sto);
void IN0_byte_schreiben (bool *input);
void IN1_byte_schreiben (bool insab);
void RES_byte_schreiben ();
void SWP_byte_schreiben (char swh, char swn);
void CHK_byte_schreiben();
void HAA_Bus_Hex();
//----------------------------------------------------------------------

/*							HB			  LB
Beispielcodes:			00.00.00.00 - 00.00.00.00
Status abfragen:        0000000000000000
HAA scharf schalten:    9000000000000000
*/

/**************************Bit-bersicht*********************************		
Bit				8		7		6		5		4		3		2		1		
Byte
1	BAS			KOM		ERR		CSAB	ALF		ALS		ALM		VAL		KAL			
2	SIR			-		-		-		-		-		SSAB	FKT		STO
3	IN0			INP7	INP6	INP5	INP4	INP3	INP2	INP1	INP0		//TODO Fehlersuche: INP7
4	IN1			-		-		-		-		-		-		-		INSAB
5	RES			-		-		-		-		-		-		-		-
6	SWH			H8		H4		H2		H1		N8		N4		N2		N1
7	SWN			H8		H4		H2		H1		N8		N4		N2		N1
8	CHK			128		64		32		16		8		4		2		1
************************************************************************/
/*---------------------BAS - Status der Basis------------------------
Beschreibung: Die allgemeinen Statusmeldungen der Basis.
*/
extern uint8_t BAS;				//Byte
#define KOM			 		7	//true: kommando, false: Statusanfrage
#define ERR			 		6	//Error beim empfangen von Kommandos
#define CSAB			  	5	//Sabotagekontakte Codeschloss
#define ALF			  		4 	//Anlage Scharf / Kommando Anlage scharf schalten
#define ALS			  		3 	//Anlage Start
#define ALM			  		2 	//Alarm
#define VAL			  		1 	//Voralarm
#define KAL			  		0 	//Kontaktalarm

/*---------------------SIR - Status der Sirene------------------------
Beschreibung: Die allgemeinen Statusmeldungen der Sirene.
*/
extern uint8_t SIR;				//Byte
// #define Res.		 		7	//Reserve
// #define Res.		 		6	//Reserve
// #define Res.		 		5	//Reserve
// #define Res.		 		4	//Reserve
// #define Res.		 		3	//Reserve
#define SSAB		 		2	//Sabotagekontakte
#define FKT			 		1	//Kommando Funktionstest
#define STO				  	0 	//Strungsmeldung

/*------------------------IN0 - Status der Inputs---------------------
Beschreibung: Die allgemeinen Statusmeldungen der Inputskontakte.
*/
extern uint8_t IN0;				//Byte
#define INP7			  	7 	//Inputkontakt 7
#define INP6			  	6 	//Inputkontakt 6
#define INP5			  	5 	//Inputkontakt 5
#define INP4			  	4 	//Inputkontakt 4
#define INP3			  	3 	//Inputkontakt 3
#define INP2			  	2 	//Inputkontakt 2
#define INP1			  	1 	//Inputkontakt 1
#define INP0			  	0 	//Inputkontakt 0

/*-----------------------IN1 - Status der Inputs----------------------
Beschreibung: Die allgemeinen Statusmeldungen der Kontakte.
*/
extern uint8_t IN1;				//Byte
// #define Res.		 		7	//Reserve
// #define Res.		 		6	//Reserve
// #define Res.		 		5	//Reserve
// #define Res.		 		4	//Reserve
// #define Res.		 		3	//Reserve
// #define Res.		 		2	//Reserve
// #define Res.		 		1	//Reserve
#define INSAB			  	0 	//Sabotagekontakt der Inputs

/*-----------------------------RES - Reserve-------------------------
Beschreibung: Reservebyte
*/
extern uint8_t RES;				//Byte

/*------------------SWP - Software-Version Hauptversion--------------
Beschreibung: Hauptversion des Projektes
Wert: 0-255
*/
extern uint8_t SWH;				//Byte

/*------------------SWP - Software-Version Nebenversion--------------
Beschreibung: Hauptversion des Projektes
Wert: 0-255
*/
extern uint8_t SWN;				//Byte

/*--------------------------CHK - Checksumme-------------------------
Beschreibung: Bildung der Checksumme.
Wert: 0-255
*/
extern uint8_t CHK;				//Byte

extern char HAAHEX[];			//Array zum abspeichern der HAA-Busses als Hex

#endif
