#ifndef _PORTS_H_
#define _PORTS_H_

//---------------------------------Includes---------------------------------
#include <avr/io.h>				//zur Deklaration der C-Ports
//---------------------------------C-Ports---------------------------------

//PB-Belegung
#define IN_6			0		//Kontaktanschluss
#define IN_7			1		//Kontaktanschluss
#define IN_3			2		//Kontaktanschluss
#define CS_LED_RT		3		//Rot, fr allg. Statuszustand (extern ausgefhrt)
#define CS_LED_GN		4		//Grn, fr allg. Statuszustand (extern ausgefhrt)
#define SIR_STOER		5		//Strung Sirene
#define CS_REL_1		6		//Relais 1 Codeschloss, HAA aktiv/inaktiv
#define CS_REL_2		7		//Relais 2 Codeschloss, frei konfiguierbar

//PC-Belegung
#define IN_1			0		//Kontaktanschluss
#define IN_0			1		//Kontaktanschluss
#define IN_SABO			2		//Kontaktanschluss
#define SIR_SABO		3		//Sabotagekontakt der Sirene
#define SIR_OUT_1		4		//Ansteuerung Sirene, High = OFF
#define SIR_OUT_2		5		//Ansteuerung Sirene, noch frei
//#define				6		//Reset AVR

//PD-Belegung
#define UART_RXD		0		//externer UART-Zugriff
#define UART_TXD		1		//externer UART-Zugriff
#define IN_2			2		//Kontaktanschluss
#define SUM_OUT			3		//Ansteuerung Summer	
#define CS_EXIT			4		//Externer Zugriff auf Codeschloss (Exit-Kontakt), ca. 1s Impuls fr ein- und ausschalten
#define CS_SABO			5		//Sabotagekontake Codeschloss	
#define IN_4			6		//Kontaktanschluss
#define IN_5			7		//Kontaktanschluss

//PORTs auf LOW oder HIGH setzten
#define Led_Rot_On()	PORTB |= (1<<CS_LED_RT)
#define Led_Rot_Off()	PORTB &=~(1<<CS_LED_RT)
#define Led_Gruen_On()	PORTB |= (1<<CS_LED_GN)
#define Led_Gruen_Off()	PORTB &=~(1<<CS_LED_GN)
#define Summer_On()		PORTD |= (1<<SUM_OUT)
#define Summer_Off()	PORTD &=~(1<<SUM_OUT)
#define Sir_Out1_Off()	PORTC |= (1<<SIR_OUT_1)
#define Sir_Out1_On()	PORTC &=~(1<<SIR_OUT_1)
#define Sir_Out2_Off()	PORTC |= (1<<SIR_OUT_2)
#define Sir_Out2_On()	PORTC &=~(1<<SIR_OUT_2)
#define CS_Exit_On()	PORTD |= (1<<CS_EXIT)
#define CS_Exit_Off()	PORTD &=~(1<<CS_EXIT)

//PORTs abfragen
#define In_0_offen()	PINC &(1<<IN_0)
#define In_1_offen()	PINC &(1<<IN_1)
#define In_2_offen()	PIND &(1<<IN_2)
#define In_3_offen()	PINB &(1<<IN_3)
#define In_4_offen()	PIND &(1<<IN_4)
#define In_5_offen()	PIND &(1<<IN_5)
#define In_6_offen()	PINB &(1<<IN_6)
#define In_7_offen()	PINB &(1<<IN_7)
#define CS_Rel1_offen()	PINB &(1<<CS_REL_1)
#define CS_Rel2_offen()	PINB &(1<<CS_REL_2)
#define Sir_Stoer()		PINB &(1<<SIR_STOER)
#define Sir_Sabo()		!(PINC &(1<<SIR_SABO))
#define In_Sabo()		PINC &(1<<IN_SABO)
#define CS_Sabo()		PIND &(1<<CS_SABO)


#endif
