#ifndef _PORTS_H_
#define _PORTS_H_

//---------------------------------Includes---------------------------------
#include <avr/io.h>				//zur Deklaration der C-Ports
//---------------------------------C-Ports---------------------------------

//PB-Belegung
#define	CS_REL1			0		
#define CS_REL2			1
#define CS_SABO			2		
#define	CS_LED_RT		3		
#define CS_LED_GN		4		
#define CS_EXIT			5		
#define SIR_STOER		6		
#define SIR_SABO		7

//PC-Belegung
#define IN0	 			0		
#define IN1				1		
#define IN2				2		
#define	IN3				3		
#define SIR_OUT1		4		//I2C_SDA
#define SIR_OUT2		5		//I2C_SCL
//#define				6		//Reset AVR

//PD-Belegung
#define UART_RXD		0		
#define UART_TXD		1	
#define IN4				2	
#define IN5				3		
#define IN6				4		
#define IN7				5	
#define SUM_OUT			6		
//#define				7

	
	

//PORTs auf LOW oder HIGH setzten
#define Led_Rot_On()	PORTB |= (1<<LED_RT_DATA)
#define Led_Rot_Off()	PORTB &=~(1<<LED_RT_DATA)
#define Led_Gruen_On()	PORTB |= (1<<LED_GN_OK)
#define Led_Gruen_Off()	PORTB &=~(1<<LED_GN_OK)
#define Relais_On()		PORTD |= (1<<RELAIS)
#define Relais_Off()	PORTD &=~(1<<RELAIS)
#define Relais_Toggle()	PORTD ^= (1<<RELAIS)
#define Summer_On()		PORTD |= (1<<SUMMER)
#define Summer_Off()	PORTD &=~(1<<SUMMER)
#define Sirene_Hi()		PORTD |= (1<<SIRENE)
#define Sirene_Low()	PORTD &=~(1<<SIRENE)
#define CS_Exit_On()	PORTD |= (1<<CS_EXIT)
#define CS_Exit_Off()	PORTD &=~(1<<CS_EXIT)
#define Test_On()		PORTC |= (1<<TEST_PORT)
#define Test_Off()		PORTC &=~(1<<TEST_PORT)
#define Test_Toggle()	PORTC ^= (1<<TEST_PORT)


//PORTs abfragen
#define Reed0_offen()	PINC &(1<<REED_0)
#define Reed1_offen()	PINC &(1<<REED_1)
#define Reed2_offen()	PINC &(1<<REED_2)
#define Reed3_offen()	PINB &(1<<REED_3)
#define Reed4_offen()	PINB &(1<<REED_4)
#define Reed5_offen()	PINB &(1<<REED_5)
#define CSRel1_offen()	PIND &(1<<CS_REL1)
#define Sabotage()		!(PIND &(1<<SABOK))
#define Stoerung()		PINB &(1<<STOERUNG)

#endif
