#ifndef _PORTS_H_
#define _PORTS_H_

//---------------------------------Includes---------------------------------
#include <avr/io.h>				//zur Deklaration der C-Ports
//---------------------------------C-Ports---------------------------------

//PB-Belegung
#define IN_3			0		//Kontaktanschluss
#define IN_4			1		//Kontaktanschluss
#define IN_5			2		//Kontaktanschluss
#define CS_LED_RT		3		//Rot, fr allg. Statuszustand (extern ausgefhrt)
#define CS_LED_GN		4		//Grn, fr allg. Statuszustand (extern ausgefhrt)
#define SIR_STOER		5		//Strung der Sirene
//#define				6		//externer Quarz
//#define				7		//externer Quarz

//PC-Belegung
//#define				0		//Reserve
#define IN_2			1		//Kontaktanschluss
#define IN_1			2		//Kontaktanschluss
#define IN_0			3		//Kontaktanschluss (verzgert)
//#define				4		//externer I2C-Zugriff
//#define				5		//externer I2C-Zugriff
//#define				6		//Reset AVR

//PD-Belegung
#define UART_RXD		0		//externer UART-Zugriff
#define UART_TXD		1		//externer UART-Zugriff
#define RELAIS			2		//Relais Wechslerkontakt	
#define SUM_OUT			3		//Anstreuerung, Summer	
#define SIR_OUT_1		4		//Ansteuerung, Sirene, High = OFF
#define CS_REL_1		5		//Relais 1 Codeschloss, HAA aktiv/inaktiv	
#define SIR_SABO		6		//Sabotagekontakt der Sirene
#define CS_EXIT			7		//Externer Zugriff auf Codeschloss (Exit-Kontakt), ca. 1s Impuls fr ein- und ausschalten

//PORTs auf LOW oder HIGH setzten
#define Led_Rot_On()	PORTB |= (1<<CS_LED_RT)
#define Led_Rot_Off()	PORTB &=~(1<<CS_LED_RT)
#define Led_Gruen_On()	PORTB |= (1<<CS_LED_GN)
#define Led_Gruen_Off()	PORTB &=~(1<<CS_LED_GN)
#define Relais_On()		PORTD |= (1<<RELAIS)
#define Relais_Off()	PORTD &=~(1<<RELAIS)
#define Summer_On()		PORTD |= (1<<SUM_OUT)
#define Summer_Off()	PORTD &=~(1<<SUM_OUT)
#define Sirene_Off()	PORTD |= (1<<SIR_OUT_1)
#define Sirene_On()		PORTD &=~(1<<SIR_OUT_1)
#define CS_Exit_On()	PORTD |= (1<<CS_EXIT)
#define CS_Exit_Off()	PORTD &=~(1<<CS_EXIT)


//PORTs abfragen
#define IN_0_offen()	PINC &(1<<IN_0)
#define IN_1_offen()	PINC &(1<<IN_1)
#define IN_2_offen()	PINC &(1<<IN_2)
#define IN_3_offen()	PINB &(1<<IN_3)
#define IN_4_offen()	PINB &(1<<IN_4)
#define IN_5_offen()	PINB &(1<<IN_5)
#define CS_Rel1_offen()	PIND &(1<<CS_REL_1)
#define Sir_Sabo()		!(PIND &(1<<SIR_SABO))
#define Sir_Stoer()		PINB &(1<<SIR_STOER)

#endif
