/***********************************************************************/
// Titel     	: UART
//----------------------------------------------------------------------
// Beschreibung	: Daten senden per UART-Schnittstelle des Controllers Atmega88
//----------------------------------------------------------------------
// Autor     	: P. Fuhsy
/***********************************************************************/

//-----------------------------Includes---------------------------------
#include <avr/io.h>								//allg. Ports
#include "uart.h"								//eigene Header
//----------------------------------------------------------------------

void initUART()					//UART-Schnittstelle initialisieren
{
	//Baudrate einstellen
	UBRR0H = PRESCALE >> 8;
	UBRR0L = PRESCALE; 				
	
	UCSR0B = (1<<RXEN0)|(1<<TXEN0)|(1<<RXCIE0);	//Receiver / Transmitter / RX-Interrupt zulassen
	UCSR0C = (1<<UCSZ01)|(1<<UCSZ00);			//Asynchron 8N1	
}
void putChar(char data)			//Zeichen senden	
{
	while (!(UCSR0A&32));						//warte bis UDR leer ist
	UDR0 = data;								//senden	
}
void putString(char *buffer)	//ganze Strings senden
{
	for (int i=0 ; buffer[i] !=0 ; i++)
		putChar(buffer[i]);
}

