#pragma once
//#include <Arduino.h>

#ifndef ARDUINO_ARCH_AVR
  #error "This library only supports boards with an AVR processor."
#endif

#define INLINE inline __attribute__((always_inline))


namespace Combie 
{ 
  namespace Pin 
  { 
      namespace
      {
      
        /*
        // ausgelagert
        struct RegisterSatz
        {
          uint16_t ddr;
          uint16_t out;
          uint16_t in;
          uint8_t  maske;
        };
        */
        
        using Register = volatile byte *;
  
        // ---------------------------
               
        // Die Arrays sind automatisch generierter Code, bitte nicht haendisch aendern
        // Der Index ist jeweils die Arduino Pinnummer
        
        // UNO, Nano, Pro Mini usw.
        #if defined(__AVR_ATmega328P__) | defined(__AVR_ATmega328__) | defined(__AVR_ATmega168P__) | defined(__AVR_ATmega168__)  
          #include "include/AtMegaxx8.h"
        
        // Leonardo, Micro, usw.
        #elif defined(__AVR_ATmega32U4__)
         #include "include/AtMega32U4.h"
        
        // Mega
        #elif defined(__AVR_ATmega2560__) | defined(__AVR_ATmega1280__)
          #include "include/AtMega2560.h"
          
        // Inhaos Massduino UNO LC
        #elif defined(__MD328D__) | defined(__MD328P__)
          #include "include/MD328D.h"
        
        // ATtiny841, ATtiny441
        #elif defined(__AVR_ATtiny841__) | defined(__AVR_ATtiny441__)
          #include "include/AtTiny841.h"
      
        #else
              #error This AVR type is currently not yet supported.
        #endif  
        
        // ---------------------------       
      
        constexpr Register getOutPort( const byte pin)    //
        {
          return (Register) pinList[pin].out;
        }
        
        constexpr Register getDdrPort(const byte pin)
        {
          return  (Register) pinList[pin].ddr;
        }
        
        constexpr Register getInPort(const byte pin)
        {
          return  (Register) pinList[pin].in;
        }
        
        constexpr byte getMaske(const byte pin)
        {
          return  pinList[pin].maske;
        }
        
        #if defined(__AVR_ATtiny841__) | defined(__AVR_ATtiny441__)
        constexpr Register getPuePort(const uint8_t pin)		// PUE
        {
          return  (Register) pinList[pin].pue;
        }
        #endif       
      }



  template<byte arduinoPin>
  class Pin
  {
      protected:
      void  INLINE initInput()
      {
          *getDdrPort(arduinoPin) &= ~getMaske(arduinoPin);
      }
      
      void  INLINE initPullup()
      { 
          *getDdrPort(arduinoPin) &= ~getMaske(arduinoPin);
          *getOutPort(arduinoPin) |=  getMaske(arduinoPin);
      }
      
      void  INLINE initOutput()
      {
          *getDdrPort(arduinoPin) |= getMaske(arduinoPin);
      }
  
      bool  INLINE isHigh() const
      {
        return *getInPort(arduinoPin)  &  getMaske(arduinoPin);
      }
  
      void  INLINE setHigh()
      {
        *getOutPort(arduinoPin)  |=  getMaske(arduinoPin);
      }
      
      void  INLINE setLow()
      {
        *getOutPort(arduinoPin)  &=  ~getMaske(arduinoPin);
      }
      
      void  INLINE toggle()
      {
        *getInPort(arduinoPin)  =  getMaske(arduinoPin);
      }
  };


  template<byte arduinoPin>
  class InputPin : protected Pin<arduinoPin> 
  {
      public:
      using Pin<arduinoPin>::initPullup;
      using Pin<arduinoPin>::isHigh;
      
       INLINE operator bool() const
      {
        return  Pin<arduinoPin>::isHigh();
      }
    
      void  INLINE init()
      {
          Pin<arduinoPin>::initInput();
      }
  };
  
  template<byte arduinoPin>
  class OpenDrainPin : protected Pin<arduinoPin> 
  {
      public:
      using Pin<arduinoPin>::isHigh;
    
      void  INLINE init()
      {
          Pin<arduinoPin>::initInput();
      }
      
      void  INLINE setHigh()
      {
          Pin<arduinoPin>::initInput();
      }
      
      void  INLINE setLow()
      {
          Pin<arduinoPin>::initOutput();
      }
      
      void  INLINE set(const bool value)
      {
        if(value) setHigh(); else setLow();
      }
      
      bool  INLINE operator = (const bool value)
      {
        set(value);
        return Pin<arduinoPin>::isHigh();
      }
      
       INLINE operator bool() const
      {
        return  Pin<arduinoPin>::isHigh();
      }
      
  };

  template<byte arduinoPin>
  class OutputPin : protected Pin<arduinoPin>
  {
      public:
      using Pin<arduinoPin>::toggle;
      using Pin<arduinoPin>::isHigh;
      using Pin<arduinoPin>::setHigh;
      using Pin<arduinoPin>::setLow;
    
      void  INLINE init()
      {
         Pin<arduinoPin>::initOutput();
      }
     
       INLINE operator bool() const
      {
        return  Pin<arduinoPin>::isHigh();
      }
      
      void  INLINE set(const bool value)
      {
        if(value) setHigh(); else setLow();
      }
      
      bool  INLINE operator = (const bool value)
      {
        set(value);
        return value;
      }
      
      bool  INLINE operator () (const bool value)
      {
        set(value);
        return value;
      }
  };

   template<byte arduinoPin>
   class RelaisINV : protected OutputPin<arduinoPin>
   {
      public:
      using OutputPin<arduinoPin>::toggle;
      
      void  INLINE init()
      {
        // init, ohne Low Puls
        OutputPin<arduinoPin>::setHigh();
        OutputPin<arduinoPin>::initOutput();
      }
      
      void  INLINE on()
      {
         OutputPin<arduinoPin>::setLow();
      }
      
      void  INLINE off()
      {
         OutputPin<arduinoPin>::setHigh();
      }

      bool  INLINE operator = (const bool value)
      {
        OutputPin<arduinoPin>::set(!value);
        return value;
      }
      
      bool  INLINE operator () (const bool value)
      {
        OutputPin<arduinoPin>::set(!value);
        return value;
      }

       INLINE operator bool() const
      {
        return  !OutputPin<arduinoPin>::isHigh();
      }
   };

   
   template<byte arduinoPin>
   class TasterGND : protected InputPin<arduinoPin>
   {
    
      public:
      using InputPin<arduinoPin>::init;
      using InputPin<arduinoPin>::initPullup;
      
      bool  INLINE pressed() const
      {
        return !InputPin<arduinoPin>::isHigh();
      }
      
      bool  INLINE released()  const
      {
        return InputPin<arduinoPin>::isHigh();
      }
      
       INLINE operator bool()  const
      {
        return  pressed();
      }
      
      bool  INLINE operator ()()  const
      {
        return  pressed();
      }
   };
  } 
}
