#pragma once

using reg8 = const uint8_t;
using reg16 = const uint16_t;
 
#if defined (__AVR_ATmega328P__) || (__AVR_ATmega2560__)

constexpr struct Bitmaske
{
  // SPCR
	reg8 SPI_SPIE = 0x80;	
  reg8 SPI_SPE  = 0x40;	
  reg8 SPI_DORD = 0x20;	
  reg8 SPI_MSTR = 0x10;	
  reg8 SPI_CPOL = 0x08;	
  reg8 SPI_CPHA = 0x04;	
  reg8 SPI_SPR1 = 0x02;	
  reg8 SPI_SPR0 = 0x01;
  // SPSR
  reg8 SPI_SPIF  = 0x80;	
  reg8 SPI_WCOL  = 0x40;	
  reg8 SPI_SPI2X = 0x01;	
} const bitmask;

constexpr struct Adresse
{
  reg16 SPI_SPCR = 0x4C;     // Control Register
  reg16 SPI_SPSR = 0x4D;     // Status Register
  reg16 SPI_SPDR = 0x4E;     // Data Register
} const addr;

// constant pointer to variable, assign register address
uint8_t *const ptrControl = reinterpret_cast<uint8_t*> (addr.SPI_SPCR);
uint8_t *const ptrStatus  = reinterpret_cast<uint8_t*> (addr.SPI_SPSR);
uint8_t *const ptrData    = reinterpret_cast<uint8_t*> (addr.SPI_SPDR);
    
#else
	#error "no SPI definition for MCU available"
#endif


