/*
  Devil-Elec
  Arduino IDE 1.8.12
  avr-gcc 9.3.0
  Arduino Mega2560
  28.04.2020
  License: GNU GPLv3
  CombiePin Library hat User combie zur Verfügung gestellt
*/

#include <util/atomic.h>
#include "AvrRegister.h"
#include "DevilSpi.h"
#include <CombiePin.h>
using namespace Combie::Pin;

// notwendige SPI Konfiguration
OutputPin<53> SSpin;    // beim UNO Pin 10
OutputPin<52> CLKpin;   // beim UNO Pin 13
OutputPin<51> MOSIpin;  // beim UNO Pin 11

OutputPin<5> messPin5; 
OutputPin<6> messPin6; 
OutputPin<7> messPin7;

SpiSlave <11, 32> device1;  // slave select pin, SPI clock divider
SpiSlave <12,  8> device2;

ring *ptrISRbuffer = nullptr;

void setup(void)
{
  SSpin.init();
  SSpin.setHigh();
  CLKpin.init();
  MOSIpin.init();
  
  device1.init();
  device2.init();

  messPin5.init();
  messPin6.init();
  messPin7.init();
}

void loop(void)
{
  spiSchaufeltDatenRaus();
}


// ****** Funktionen ******
void spiSchaufeltDatenRaus (void)
{
  messPin5.setHigh();
  static byte number = 0;
  
  switch (number)
  {
    case 0:
      if (ptrISRbuffer == nullptr )       // wenn Zeiger nicht belegt ...
      {
        ptrISRbuffer = &device1.buffer;   // für ISR Objekt an Zeiger binden
        device1.fillBuffer('U');          // FiFo-Buffer füllen
        device1.fillBuffer(24);
        device1.fillBuffer(24);
        device1.fillBuffer('U');
        device1.transferGoOut();          // Datenausgabe starten
        number = 1;
      }
      break;

    case 1:
      if (ptrISRbuffer == nullptr )
      {
        ptrISRbuffer = &device2.buffer;
        device2.fillBuffer(153);
        device2.fillBuffer('U');
        device2.fillBuffer('U');
        device2.fillBuffer(153);
        device2.transferGoOut();
        number = 0;
      }
      break;

    default: number = 0; break;
  }
  
  messPin5.setLow();
}


ISR(SPI_STC_vect)
{  
  if (ptrISRbuffer->head != ptrISRbuffer->tail)
  {
    messPin6.setHigh();
      // calculate and store new buffer index
      uint8_t const tempTail = (ptrISRbuffer->tail + 1) & BUFFER_MASK;
      ptrISRbuffer->tail = tempTail;
      
      // get one byte from buffer and write it to SPI
      *ptrData = static_cast<uint8_t> ( ptrISRbuffer->fifo[tempTail] );  
    messPin6.setLow();
  }
  else
  {       
    messPin7.setHigh();       
      // disable Serial Transfer Complete Interrupt
      *ptrControl &= ~(static_cast<uint8_t> (bitmask.SPI_SPIE));
      
      //digitalWrite(ptrISRbuffer->slaveSelect, HIGH);  // soll ersetzt werden
      device1.slaveSelectHigh();
      device2.slaveSelectHigh();
      
      ptrISRbuffer->startNewTransfer = true;
      ptrISRbuffer = nullptr;         // Objekt vom Zeiger lösen
      
    messPin7.setLow();  
  }
}

