/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        11.01.2009
 Description:    Power Supply LED Display

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#include <avr/interrupt.h>
#include <avr/io.h>

#include "multiplex.h"
#include "adc.h"

//---------------------------------------------------------------------------
int main (void) 
{

	unsigned int tmp1 = 0;
	unsigned int tmp2 = 0;
	unsigned int counter = 0;

	DDRD |= (1<<PD0)|(1<<PD1)|(1<<PD2)|(1<<PD3)|(1<<PD4)|(1<<PD5)|(1<<PD6);
	DDRB |= (1<<PB0)|(1<<PB1)|(1<<PB2)|(1<<PB3)|(1<<PB4)|(1<<PB5);
  
	adc_init();
  
	sei();
  
	init_timer3();
  
	while(1)
	{		
		tmp1 = 0;
		tmp2 = 0;

		for (unsigned char a = 0;a<BUFFER_SIZE;a++)
		{
			tmp1 += display_value_1[a];
			tmp2 += display_value_2[a];
		}
		
		if ((counter++) > 500)
		{
			counter = 0;
			display1 = (tmp1 / BUFFER_SIZE);
			display2 = (tmp2 / BUFFER_SIZE);
		}
	}
}

