#include "M078CKA.h"


/*
 * LCD-related state variables
 */

unsigned short int re = 2;	// 'uninitialized"

/*
 * LCD-related functions.
 */
void lcdInit()
{
	TWCR &= ~_BV(TWEN);
	ASSR &= ~_BV(AS2);
	DDRD = 0xFF;//|= (_BV(RESB) | _BV(CSB) | _BV(RS) | _BV(WRB) | _BV(RDB) );
	
	PORTD &= ~_BV(RESB);
	delayMs(DEFAULT_DELAY);
	PORTD |= _BV(RESB);
	delayMs(DEFAULT_DELAY);
	//   	fprintf(&uart_str, "Initialization:\n");

	lcdExtendedFunction(0);

	/*
	lcdCommandWrite(0x00);
  	lcdCommandWrite(0x10);
	lcdCommandWrite(0x20);
	lcdCommandWrite(0x30);
*/
	lcdCommandWrite(0x40);
	lcdCommandWrite(0x50);
	lcdCommandWrite(0x61);
	lcdCommandWrite(0x70);
	lcdExtendedFunction(0);
	lcdCommandWrite(0x81);  //0x81, graphics ON
	lcdCommandWrite(0x92);  //0x92, SWAP
	lcdCommandWrite(0xA1);  //0xA1, X increment
	lcdCommandWrite(0xB2);	//0xB2, PON
	lcdCommandWrite(0xDE);  //0xDE
	lcdCommandWrite(0xE0);
	lcdExtendedFunction(1);
	lcdCommandWrite(0xE0);
	lcdExtendedFunction(0);

	//lcdCommandWrite(0xB1);
	//lcdCommandWrite(0xB4);
}


void lcdCommandWrite(const unsigned short int data)
{
	PORTC = data;
	DDRC = 0xFF;
	
	PORTD = ~_BV(CSB) & ~_BV(WRB) & ( _BV(PD0) | _BV(PD1) | _BV(RESB) | _BV(RS) | _BV(RDB) );
	delayMs(0);
	
	PORTD |= ( _BV(CSB) | _BV(WRB) );
	delayMs(DEFAULT_DELAY);
	
}

void lcdExtendedFunction(unsigned short int selectExtendedFunction)
{
	if(selectExtendedFunction != re)
	{
		lcdCommandWrite(0xF0 + selectExtendedFunction);
		re = selectExtendedFunction;
	}

	/*if( selectExtendedFunction && !re )
	{
		lcdCommandWrite(0xF1);
		re = 1;
	}
	
	if( !selectExtendedFunction && re )
	{
		lcdCommandWrite(0xF0);
		re = 0;
	}*/	
}

void lcdSetRegisterReadAddress(const unsigned short int readAddress)
{
	lcdExtendedFunction(0);
	lcdCommandWrite( 0b11000000 | (readAddress & 0x0F) );
	delayMs(DEFAULT_DELAY);
}

unsigned short int lcdRegisterRead()
{
	unsigned short int registerValue = 0xAA; //if nothing got read, we return a nice pattern: 10101010
	
	lcdExtendedFunction(0);
	PORTC = 0x00;	//we don't want MOS pull-up resistors
	DDRC = 0x00;
	delayMs(DEFAULT_DELAY);
	PORTD = ~_BV(CSB) & ~_BV(RDB) & ( _BV(PD0) | _BV(PD1) | _BV(RESB) | _BV(RS) | _BV(WRB) );
	delayMs(1);
	registerValue = PINC;
	PORTD |= _BV(CSB) | _BV(RDB);
	delayMs(DEFAULT_DELAY);
	
	return registerValue;
}


void lcdDataWrite(const unsigned short int ramData)
{
	lcdExtendedFunction(0);
	PORTC = ramData;
	DDRC = 0xFF;
	
	//delayMs(DEFAULT_DELAY);

	PORTD = ~_BV(CSB) & ~_BV(RS) & ( _BV(PD0) | _BV(PD1) | _BV(RESB) | _BV(WRB) | _BV(RDB) );
	//delayMs(DEFAULT_DELAY);
	PORTD &= ~_BV(WRB);
	delayMs(0);
/*
	uartSendByteHex(PORTC);
	uartSendChar('\r');
	*/
	PORTD |= _BV(WRB);
	//delayMs(0);
	PORTD |= _BV(CSB);	//in reference implementation they let pass some time between WRB,CSB
	//delayMs(DEFAULT_DELAY);
	
}

unsigned short int lcdDataRead()
{
	unsigned short int registerValue = 0xAA; //if nothing got read, we return a nice pattern: 10101010
	
	lcdExtendedFunction(0);
	PORTC = 0x00;	//we don't want MOS pull-up resistors
	DDRC = 0x00;
	delayMs(DEFAULT_DELAY);
	PORTD = ~( _BV(RDB) | _BV(RS) ) & ( _BV(CSB) | _BV(PD0) | _BV(PD1) | _BV(RESB) | _BV(WRB) );
	delayMs(1);
	registerValue = PINC;
	PORTD |= _BV(RDB);
	PORTD &= ~_BV(CSB);
	delayMs(DEFAULT_DELAY);
	
	return registerValue;
}

/*
void lcdSetReadAddress(const char adress)
char lcdRead()
{
	
}
*/
