#include <avr/io.h>

#include "uartSparse.h"


#define UART_BAUD 9600


/*
 * Initialize the UART to 9600 Bd, tx/rx, 8N1.
 */
void uartInit(void)
{
  DDRD &= ~_BV(PD0);
  DDRD |= _BV(PD1);
  
#if F_CPU < 2000000UL && defined(U2X)
  UCSRA = _BV(U2X);             /* improve baud rate error by using 2x clk */
  UBRRH = ( ( F_CPU / (8UL * UART_BAUD) ) - 1 ) >> 8;
  UBRRL = ( F_CPU / (8UL * UART_BAUD) ) - 1;
#else
  UBRRH = ( ( F_CPU / (16UL * UART_BAUD) ) - 1 ) >> 8;
  UBRRL = ( F_CPU / (16UL * UART_BAUD) ) - 1;
#endif
  UCSRB = _BV(TXEN) | _BV(RXEN); /* tx/rx enable */
}


void uartSendSZ(char* chars)
{
	while(*chars)
	{
		if(*chars == '\n')
		{
			uartSendChar('\r');
		}
		else
		{
			uartSendChar(*chars);
		}
		
		chars++;
	}
		
}


void uartSendChar(const char character)
{
	  loop_until_bit_is_set(UCSRA, UDRE);
	  UDR = character;
}

void uartSendByteHex(const short int byteValue)
{
	  uartSendSZ("0x");
	  uartSendChar( DEC2HEX[ (byteValue & 0xF0) >> 4 ] );
	  uartSendChar( DEC2HEX[ byteValue & 0x0F ] );
	  uartSendChar('h');
	  
}
