void SetADCSetEnable(int onOff)
{
	//printf("Starting/Stopping AD-Converter\n");
	if (onOff == true)
		sbi(ADCSR, ADEN);
	else
		cbi(ADCSR, ADEN);
}

void SetADCFreeRun(int onOff)
{
	//printf("Set AD-Freerun mode\n");
	if (onOff == true)
		sbi(ADCSRA, ADFR);
	else
		cbi(ADCSRA, ADFR);
}

void SetADCStartConversion(void)
{
	//printf("Starting AD-Conversion\n");
	sbi(ADCSR, ADSC);
}

void SetADCStopConversion(void)
{
	//printf("Stopping AD-Conversion\n");
	cbi(ADCSR, ADSC);
}

void SetADCPrescaler(int scale)
{
	//printf("Set AD-Prescaling to: %d\n", scale);
	if (scale == 2)
		_SFR_BYTE(ADCSR) |= _BV(ADPS0);
	if (scale == 4)
		_SFR_BYTE(ADCSR) |= _BV(ADPS1);
	if (scale == 8)
		_SFR_BYTE(ADCSR) |= _BV(ADPS1) | _BV(ADPS0);
	if (scale == 16)
		_SFR_BYTE(ADCSR) |= _BV(ADPS2);
	if (scale == 32)
		_SFR_BYTE(ADCSR) |= _BV(ADPS2) | _BV(ADPS0);
	if (scale == 64)
		_SFR_BYTE(ADCSR) |= _BV(ADPS2) | _BV(ADPS1);
	if (scale == 128)
		_SFR_BYTE(ADCSR) |= _BV(ADPS2) | _BV(ADPS1) | _BV(ADPS0);
}

void SetADCCannel(int8_t channel, int8_t vref, int leftAdjusted)
{
	//printf("Using AD-Channel: %d\n", channel);
	ADMUX = channel;		// 0 for GB_Cam operation
	ADMUX |= (vref<<6);	// 0 for normal 5V operation
	if (leftAdjusted == true)
		sbi(ADMUX, ADLAR);
	else 
		cbi(ADMUX, ADLAR);
}

uint8_t GetADCValue(void)
{
	/*int16_t value;
	value = ADCL;
	value += (ADCH<<8);*/
	//printf("AD-Value: %d\n", ADCH);
	return ADCH;
}

void InitADC(int8_t channel, int8_t freerun, int8_t vref, int8_t scale)
{
	//printf("Initialize AD-Converter\n");
	SetADCSetEnable(true);
	SetADCCannel(channel, vref, true);		// true -> for left adjusted result
	SetADCPrescaler(scale);
	SetADCFreeRun(freerun);
}

void DeinitADC(void)
{
	//printf("Deinitialize AD-Converter\n");
	SetADCFreeRun(false);
	SetADCSetEnable(false);
}
