#include "main.h"

#define true  0xff
#define false 0x00

#define PortB 0x07              // Reset values for every IO
#define PortC 0xc               // Reset values for every IO
#define PortD 0x40              // Reset values for every IO

#define D_RW     0x00           // Display: Read / Write (H = Write)
#define D_Enable 0x01           // Display: Chip enable (LowActive)
#define D_DatIns 0x02           // Display: Data / Instruction (H = Data)

//------------------------------------------------------------------------------
//---- Main functions ----------------------------------------------------------
//------------------------------------------------------------------------------

int main(void)
{
        InitSystem();                           // Reset IO's

        return 0;
}


int SetByte(uint8_t byte)
{
        outb(DDRC, (PortC | 0x03));
        outb(DDRD, (PortD | 0xfc));

        outb(PORTC, (byte & 0x03));
        outb(PORTD, (byte & 0xfc));

        return true;
}

uint8_t GetByte(void)
{
        uint8_t iTmp, byte;

        outb(DDRC, PortC);      // reset PortC to default
        outb(DDRD, PortD);      // reset PortD to default

        byte = inb(PORTC);       // Get PortC
        iTmp = inb(PORTD);       // Get PortD

        iTmp &= 0xfc;           // Mask iTmp so that bit 0 and bit 1 are zero
        byte |= iTmp;           // Add 'byte' and 'iTmp' together to 8 bit

        return byte;
}

//------------------------------------------------------------------------------
//---- Init functions ----------------------------------------------------------
//------------------------------------------------------------------------------


int InitSystem(void)
{
        outb(DDRB, PortB);
        outb(DDRC, PortC);
        outb(DDRD, PortD);

        return true;
}