#include "gb_helper.h"
#define MAX_CHECKS 50
//------------------------------------------------------------------------------
//---- Init Cam function -------------------------------------------------------
//------------------------------------------------------------------------------

void InitCam(void)
{
	//printf("Initilize Camera...\n");	
	// Set the DDRE with Pin 2 to 7 as output. Pin 0 and 1 are used for Uart.
	DDRE = 0x00;
	DDRE = (1<<DDB6)|(1<<DDB5)|(1<<DDB4)|(1<<DDB3)|(1<<DDB2);
	SetCamResetL();
	SetCamClockH();
	_delay_us(5);
	SetCamResetH();
}

void SetCamRegister(int adress, int value)
{
		//printf("\tSet camera register: ADRESS: %d - VALUE: %d\n", adress, value);
	int16_t camReg = 0;
	camReg |= (adress<<8) | value;
		//printf("\t\tReg after shift << 8: %d\n", camReg);
	int16_t adrTmp;
	camReg = (camReg<<5);
		//printf("\t\tReg after shift << 5: %d\n", camReg);
	
	for (int i = 0; i < 11; i++)
	{
		adrTmp = (camReg&32768);
		//printf("\tcamReg: %d -- adrTmp: %d\n", camReg, adrTmp);
		
		if (adrTmp == 0)
		{
			//printf("0");
			SetCamSinL();
			SetCamClockH();
			_delay_us(1);
			if (i == 10)
			{
				SetCamLoadH();
				//printf("-1-");
				_delay_us(1);
			}
			SetCamClockL();
			if (i == 10)
				SetCamLoadL();
			_delay_us(1);
		}
		else
		{
			//printf("1");
			SetCamSinH();
			SetCamClockH();
			_delay_us(1);
			if (i == 10)
			{
				SetCamLoadH();
				//printf("-2-");
				_delay_us(1);
			}
			SetCamSinL();
			SetCamClockL();
			if (i == 10)
				SetCamLoadL();
		}
        camReg = (camReg<<1);
   }
   //printf("\n");
}

void GetCamImage(void)
{
	/*printf("\tPlease press 'a' to start image capture\n");
	while (ReceiveByte() != 'a') {}*/
	
	//printf("\tTrying to capture Image\n");
	imageData=malloc(15744*sizeof(int8_t));
	
	if (imageData==NULL)
		printf("\tRAM full or memory failure..\n");
	else{
		SetADCStartConversion();
		
		// Init Camera and sending start signal
		SetCamClockL();		// 0
		_delay_us(1);
		SetCamClockH();		// 1
		_delay_us(1);
		SetCamClockL();		// 0
		SetCamStartH();
		_delay_us(1);
		SetCamClockH();		// 1
		_delay_us(1);
		SetCamClockL();		// 0
		SetCamStartL();		
		_delay_us(1);

		//printf("\tWaiting for ready signal\n");
		while(GetCamRead() == false)
		{
			SetCamClockL();		// 0
			_delay_us(1);
			SetCamClockH();		// 1
			_delay_us(1);
		}
		
		ADCSRA |= (1<<ADSC);              // eine ADC-Wandlung 
		
		while ( ADCSRA & (1<<ADSC) );     // auf Abschluss der Konvertierung warten 
		GetADCValue();
		
		//printf("\tCapturing Image...\n");
		for (int16_t i = 0; i < 15744; i++){
			if (GetCamRead() == true)
			{
				SetCamClockH();
				_delay_us(1);
				ADCSRA |= (1<<ADSC);              // eine ADC-Wandlung 
				while ( ADCSRA & (1<<ADSC) );     // auf Abschluss der Konvertierung warten 
				*(imageData+i) = GetADCValue();
				_delay_us(1);
			}
			else
				*(imageData+i) = 0;
		}
		SetADCStopConversion();
		//printf("\tCapture completed.\n");
	}
}

void SendCamImage(void)
{
	printf("\tPlease press 'a' to start sending the image\n");
	while (ReceiveByte() != 'a') {}
	for (int16_t i = 0; i < 15744; i++){
		printf("%d\n", *(imageData+i));
	}
	printf("Image successfully sent.\n");
}

void AutoCameraSetting(int8_t exposureTime, int8_t gain, int8_t offset)
{
	InitCam();
	//printf("Camera is ready\n");
	SetCamRegister(0,128);
	SetCamRegister(1, gain);
	SetCamRegister(2,0);
	SetCamRegister(3, exposureTime);
	SetCamRegister(4,1);
	SetCamRegister(5,0);
	SetCamRegister(6,1);
	SetCamRegister(7, offset);
	gotoxy(0,3);
	printf("\nRegisters are set to: EXPOSURE: %d - GAIN: %d - OFFSET: %d\n", exposureTime, gain, offset);
	GetCamImage();
}

void AutoCalibrateImage(int brightnesDifference, int brightnesMeen)
{
	int32_t sumPixel = 0;
	uint8_t meenPixel = 0;
	uint8_t differenceOld = 0;
	uint8_t maxBrightnes = 0;
	uint8_t minBrightnes = 255;
	uint8_t checkRun = 0;
	uint8_t exposureTime = 30;
	uint8_t gain = 0;
	uint8_t offset = 0;
	int goodEnough = false;
//	uint8_t valuesMax[4]; // maxDifference, exposureTime, gain, offset

	//printf("\nStart brightnes check\n");
	
	while (goodEnough == false)
	{
		gotoxy(0,0);
		free(imageData);
		AutoCameraSetting(exposureTime, gain, offset);
		
		sumPixel = 0;
		meenPixel = 0;
		maxBrightnes = 0;
		minBrightnes = 255;
		
		for (int16_t i = 0; i < 15744; i++){
			sumPixel += *(imageData+i);
			if (*(imageData+i) < minBrightnes)
				minBrightnes = *(imageData+i);
			
			if (*(imageData+i) > maxBrightnes)
				maxBrightnes = *(imageData+i);
		}
		
		meenPixel = (sumPixel / 15744);
		printf("\tMeen pixel brightnes: %d\n", meenPixel);
		printf("\tMin / Max pixel brightnes: %d / %d, difference: %d\n", minBrightnes, maxBrightnes, (maxBrightnes - minBrightnes));
		//if ((brightnesDifference < (maxBrightnes - minBrightnes)) && ((meenPixel < (brightnesMeen + 10)) && (meenPixel > (brightnesMeen - 10))))
		
		if ((brightnesDifference < (maxBrightnes - minBrightnes)) && ((maxBrightnes - minBrightnes) < 130) && (meenPixel > 40) && (meenPixel > 80))
			goodEnough = true;
		
		if (goodEnough == false)
		{
			// calculate all the frame bightnes stuff
			if (minBrightnes >= 30)
				offset--;
				
			if ((maxBrightnes <= 60) && (meenPixel < brightnesMeen))
				exposureTime += 10;
			if ((maxBrightnes >= 60) && (maxBrightnes < 100) && (meenPixel < brightnesMeen))
				exposureTime += 5;
			if ((maxBrightnes >= 100) && (maxBrightnes < 120) && (meenPixel < brightnesMeen))
				exposureTime += 1;
				
			if ((maxBrightnes >= 180) && (meenPixel > brightnesMeen))
				exposureTime -= 10;
			if ((maxBrightnes <= 180) && (maxBrightnes > 140) && (meenPixel < brightnesMeen))
				exposureTime -= 5;
			if ((maxBrightnes <= 140) && (maxBrightnes < 120) && (meenPixel < brightnesMeen))
				exposureTime += 1;
				
			if ((exposureTime > 120) && (maxBrightnes < 100) && (meenPixel < brightnesMeen))
			{
				gain++;
				exposureTime = 60;
			}
			
			if ((exposureTime < 10) && (gain > 0) && (maxBrightnes >= 120) && (meenPixel < brightnesMeen))
			{
				gain--;
				exposureTime = 90;
			}
			
			if ((gain > 3) && (maxBrightnes < 100))
			{
				offset++;
				gain--;
				exposureTime = 30;
			}
			if ((gain < 2) && (maxBrightnes > 120) && (offset > 0))
			{
				offset--;
				gain--;
				exposureTime = 30;
			}
			
		}
			
		// Orders for the next frame
		differenceOld = (maxBrightnes - minBrightnes);
		
		if (checkRun > MAX_CHECKS)
			goodEnough = true;
			
		checkRun++;
	}
}
