#include "glcd_definitionen.h"
#include "glcd_helper.h"

int read_status(void);
void write(int,unsigned char);
void reset (void);
void init_display(void);      
void gotoxy(int,int);
void print(unsigned char);                
void clr_txt_lcd(void);  
void clr_grf_lcd(void);                     
void setpixel(int,int);  
void clrpixel(int,int);   
void kreis(int,int,int);  
void linie(int,int,int,int); 
void clrlinie(int,int,int,int); 
void viereck(int, int, int, int);


void printdly(char *ch, int time) {
	int i;
  
	for (i=0; i < strlen(ch); i++) {        
	print(ch[i]);
	_delay_ms(time);
	}
}   

void printstr(unsigned char *ch) {
	int i;
	
	for (i=0;i<strlen(ch);i++) {
		print(ch[i]);
	}
}

void printxt(unsigned char *ch) {
	int i;
	
	for (i=0;i<strlen(ch);i++) {
		print(ch[i]);
	}
}

//******************************************************************************
// Funktion zur Stausabfrage 
int read_status(void) {
	//printf("\t\tRead Status\n");
	int ret;
	ret = 0;
	DDR_LCD = 0x00;
	
	while (ret == 0)
	{
		C_CD(ON);
		C_RD(OFF);
		C_WR(ON);
		C_CE(OFF);
		//#asm("nop");    //einen Takt warten
		_delay_us(5);  
		if (bit_is_set(PIN_LCD, PORTB0) && bit_is_set(PIN_LCD, PORTB1) && bit_is_set(PIN_LCD, PORTB2) && bit_is_set(PIN_LCD, PORTB3));
		{
			//printf("Da sind offenbar Bits gesetzt");
			//if (PIN_LCD.0 == 1 || PIN_LCD.1 == 1 || PIN_LCD.2 == 1 || PIN_LCD.3 == 1)                            
			ret = 1;
		}
			
		C_CE(ON);
	}
	//printf("\t\tEnd read Status\n");
	DDR_LCD = 0xFF;    //Port auf Output setzen
	return ret;
}            

// Funktion zum schreiben von daten oder comandos
void write(int type, unsigned char daten) {
	//printf("\t\tWrite something to the Display\n");
	read_status();
	
	DDR_LCD = 0xFF;    //PortA auf Output setzen
	PORT_LCD = daten;  //Daten auf A schreiben.
	C_WR(OFF);
	C_RD(ON);
	
	if (type == COMMAND)
		C_CD(ON);
		
	if (type == DATA)         
		C_CD(OFF);
		
	C_CE(OFF);
	//#asm("nop");    //einen Takt warten
	_delay_us(5);
	C_CE(ON);
	
	_delay_us(5);
} 

// Funktion fr Controller-Reset
void reset (void) {
	//printf("\t\tReset Display\n");
	C_RST(OFF);
	C_CE(OFF);
	//#asm("nop");
	_delay_ms(1);
	C_CE(ON);
	C_RST(ON);
}
//Initialiesierung des GLCD
void init_display(void) {    
	//printf("\t\tInit Display\n");
	_delay_ms(50);
	reset(); 
	_delay_ms(1);          
	
	//printf("\t\tSet text home adress\n");
	write(DATA,T_BASE && 0xFF);	
	write(DATA,(T_BASE >> 8) && 0xFF); 
	write(COMMAND,0x40);			// 0b0100 0000 -- Set text home adress
	_delay_ms(1);   
	
	//printf("\t\tSet text area");
	write(DATA, (PIXELX/6) && 0xFF);		// 0b0001 0101  --> 0b0000 0101
	write(DATA, 0x00);  //((PIXELX/8) >> 8) && 0xFF);	//		--> 0b0000 0001
	write(COMMAND,0x41);  		// 0b0100 0001 -- Columns Set Text Area
	_delay_ms(1);
	
	//printf("\t\tSet graphics home adress\n");
	write(DATA,G_BASE && 0xFF);
	write(DATA,(G_BASE >> 8)); 
	write(COMMAND,0x42);			// 0b0100 0010 -- Columns Set Graphics Home Adress
	_delay_ms(1);
	
	//printf("\t\tSet Grafik area\n");
	write(DATA, (PIXELX/8) && 0xFF);     // 0b0001 0000	--> 0b0000 0000
	write(DATA, ((PIXELX/8) >> 8) && 0xFF);	// 		--> 0b0000 0001
	write(COMMAND,0x43);			// 0b0100 0011 -- Columns Set Graphics Area
	_delay_ms(1);   
	
	//printf("\t\tDisplay mode\n");
	write(COMMAND,0x82);  		// 0b1000 0010
	write(COMMAND,0x9C);       // 0b1001 1000 Display mode                     
	_delay_ms(1);   
	
	clr_txt_lcd();  
	_delay_ms(1);     
	
	clr_grf_lcd();
	_delay_ms(1);   
	
	gotoxy(0,0);
	//open a channel for printf (STDOUT)
	fdevopen (print, NULL);
}
//GotoXY
void gotoxy(int x, int y) {  
	//printf("\t\tGoto %d, %d\n", x,y);
	int pos;
    
	if (bit_is_set(CMDPORT, FONT))
		pos = 0x00 + y * (PIXELX/8) + x;
	else
		pos = 0x00 + y * (PIXELX/6) + x;
		
	//Move address pointer to position
	write(DATA,pos && 0xFF);
	write(DATA,(pos >> 8) && 0xFF);
	write(COMMAND,0x24);
}                   

void print(unsigned char ch) {  
	//printf("\t\t%c", ch);
	if (ch == '') { ch = 0x7A+0x20; }
	if (ch == '') { ch = 0x79+0x20; }
	if (ch == '') { ch = 0x64+0x20; }
	write(DATA,ch - 0x20);	//have to subtract 0x20 since their ascii table is ASCII-0x20
	write(COMMAND,0xC0);
}                        
 

void clr_txt_lcd(void) { 
	//printf("\t\tClear Text on Display\n");
	int i;
	int cols;
	
	if (bit_is_set(CMDPORT, FONT))
		cols = (PIXELX/8);
	else
		cols = (PIXELX/6);
		
	write(DATA,T_BASE && 0xFF);
	write(DATA,(T_BASE >> 8) && 0xFF);
	write(COMMAND,0x24);	// 0b0010 0100 -- Set Adress Pointer to T_BASE
	
	write(COMMAND,0xB0);	// 0b1011 0000 -- Set Data Auto Write
	
	for (i=0;i<cols*(PIXELY/8);i++) {
		write(DATA,0x00);	// Delete whats in the Displays-SRAM
	}
	
	write(COMMAND,0xB2);	// 0b1011 0010 -- Auto Reset
	
	write(DATA,T_BASE && 0xFF);
	write(DATA,(T_BASE >> 8) && 0xFF);
	write(COMMAND,0x24);	// 0b0010 1000 -- Set Adress Pointer to T_BASE
}

void clr_grf_lcd(void) {
	//printf("\t\tClear Grafics on Display\n");
	int i;
	int cols;
	
	if (bit_is_set(CMDPORT, FONT)) //
		cols = (PIXELX/8);
	else
		cols = (PIXELX/6); 
		
	write(DATA,G_BASE && 0xFF);
	write(DATA,(G_BASE >> 8) && 0xFF);
	write(COMMAND,0x24);	// 0b0010 0100 -- Set Adress Pointer to G_BASE
	
	write(COMMAND,0xB0);	// 0b1011 0000 -- Set Data Auto Write
	
	for (i=0;i<cols*(PIXELY/8);i++) {
		write(DATA,0x00);	// Delete whats in the Displays-SRAM
	}
	
	write(COMMAND,0xB2);	// 0b1011 0010 -- Auto Reset
	
	write(DATA,G_BASE && 0xFF);
	write(DATA,(G_BASE >> 8) && 0xFF);
	write(COMMAND,0x24);	// 0b0010 0100 -- Set Adress Pointer to G_BASE
}                                                                      

void setpixel(int x, int y) 
{                
	//printf("\t\tSet Pixel %d, %d\n", x,y);
	uint8_t pos;
	uint8_t data = 1;
	uint8_t cols;
	uint8_t chw;
	
	if (bit_is_set(CMDPORT, FONT))
	{
		cols = (PIXELX/8);
		chw = 8;
	}
	else
	{
		cols = (PIXELX/6);
		chw = 6;
	}
	pos = G_BASE + y * cols + x / chw;	// chw sollte CharWidth sein.

	write(DATA, pos && 0xFF);  
	write(DATA, (pos>>8) && 0xFF);
	write(COMMAND,0x24);			//Set Address pointer
	
	x %= chw; //Rest 223 % 6 = xxx
	// Now that we have the adress pointer set, we can set the bit within the byte to set the pixel
	write(COMMAND,0xF0 | (data<<3) | (chw-1-x)); // 0b1111 1xxx (6-1-4) = 1
}

void clrpixel(int x, int y) {  
	//printf("\t\tClear Pixel %d, %d\n", x,y);           
	uint8_t pos;
	uint8_t data = 0;
	uint8_t cols;
	uint8_t chw;
	
	if (bit_is_set(CMDPORT, FONT)) 
	{
		cols = (PIXELX/8);
		chw = 8; 
	} 
	else 
	{ 
		cols = (PIXELX/6);
		chw = 6; 
	}                                   
	
	pos = G_BASE + y * cols + x / chw;	// nochmal schauen, was chw ist
	
	write(DATA,pos && 0xFF);  //Set Address pointer
	write(DATA,(pos>>8) && 0xFF);
	write(COMMAND,0x24);
	
	x%=chw; //Rest        
	
	write(COMMAND,0xF0 | (data<<3) | (chw-1-x));
} 
                
void kreis(int xcenter, int ycenter, int radius)
 {
	//printf("\t\tDraw circle: %d, %d, %d\n", xcenter, ycenter, radius);
	int tswitch, y, x = 0;
	
	y = radius;
	tswitch = 3 - 2 * radius;
	
	while (x <= y) 
	{
		setpixel(xcenter + x, ycenter + y);    setpixel(xcenter + x, ycenter - y);
		setpixel(xcenter - x, ycenter + y);    setpixel(xcenter - x, ycenter - y);
		setpixel(xcenter + y, ycenter + x);    setpixel(xcenter + y, ycenter - x);
		setpixel(xcenter - y, ycenter + x);    setpixel(xcenter - y, ycenter - x); 
		
		if (tswitch < 0) tswitch += (4 * x + 6);
		else 
		{
			tswitch += (4 * (x - y) + 10);
			y--;
		}
		x++;
	}
 } 

void linie(int x,int y,int xx,int yy) {
	//printf("\t\tDraw Line %d, %d - %d, %d\n", x,y, xx, yy);
	int xl,yl,l,i,fact;
	float dx,dy,xd,yd;
	fact=1;
	
	if(xx<x) 
		fact=-1;

	xl=abs(xx-x);
	yl=yy-y;
	l=abs(xl)+abs(yl);	// lnge der Linie um die Ecke 
	dx=fact*(float)xl / l;   	// Deltas zum aufaddieren 
	dy=(float)yl / l;           
	
	xd=x;             	// Display Startkoordinaten
	yd=y;
	
	for(i=0;i<l;i++) {
		setpixel((int)xd,(int)yd);	// Werte werden gerundet um Pixel zu treffen
		xd+=dx;
		yd+=dy;	                                  
	}                                             
} 

void clrlinie(int x,int y,int xx,int yy) {
	//printf("\t\tClear Line %d, %d - %d, %d\n", x,y, xx, yy);
	int xl,yl,l,i,fact;
	float dx,dy,xd,yd;
	                            
	fact=1;
	if(xx<x) fact=-1;

	xl=abs(xx-x);
	yl=yy-y;
	l=abs(xl)+abs(yl);	// lnge der Linie um die Ecke 
	dx=fact*(float)xl/l;   	// Deltas zum aufaddieren 
	dy=(float)yl/l;           
	
	xd=x;             	// Display Startkoordinaten
	yd=y;
	for(i=0;i<l;i++) {
		clrpixel((int)xd,(int)yd);	// Werte werden gerundet um Pixel zu treffen
		xd+=dx;
		yd+=dy;	                                  
	}                                             
}

void viereck(int x1, int y1, int x2, int y2)
{
	//printf("\t\tDraw rectangle %d, %d - %d, %d\n", x1,y1, x2, y2);
	int i;
	
	for (i=x1;i<=x2;i++) 
		setpixel(i,y1);    // Top line
	for (i=x1;i<=x2;i++)
		setpixel(i,y2);    // Bottom line
	for (i=y1;i<=y2;i++)
		setpixel(x1,i);    // Left side
	for (i=y1;i<=y2;i++)
		setpixel(x2,i);    // Right side
}
