//------------------------------------------------------------------------------
//---- Interrupt Routines ------------------------------------------------------
//------------------------------------------------------------------------------

/* 	Interrupt luft auf, wenn ein Servo-Signal abgeschaltet werden muss.
	Es wird geprft, welcher Servo geschaltet werden muss. Anschlieend wird berechnet
	Welcher Servo gleichzeitig oder als nchstes ausgeschaltet werden muss und der Timer
	dementsprechend eingestellt. */ 
SIGNAL(SIG_OVERFLOW1) {
	SetByte(255); 				// alle Servos einschalten
	TCNT1 = (uint16_t)48000; 	// Initialwert von 48000 eingeben (fr 20ms Tackt)
	TCCR0 = 3; 					// 8-Bit Timer0 auf Clk/64 initialisieren
	TCNT0 = servoPos;			// Initialwert von 20 eingeben	(fr 1 ms Tackt)
}

/*	Interrupt luft auf, wenn 20ms vergangen sind. Der Puls wird neu gestartet und alle
	vorhandenen Servos werden wieder eingeschaltet. */
SIGNAL(SIG_OVERFLOW0) {
		SetByte(0);
		TCCR0 = 0; 				// 8-Bit Timer0 ausschalten
}