//------------------------------------------------------------------------------
//---- Interrupt Routines ------------------------------------------------------
//------------------------------------------------------------------------------

/* 	Interrupt luft auf, wenn ein Servo-Signal abgeschaltet werden muss.
	Es wird geprft, welcher Servo geschaltet werden muss. Anschlieend wird berechnet
	Welcher Servo gleichzeitig oder als nchstes ausgeschaltet werden muss und der Timer
	dementsprechend eingestellt. */ 
SIGNAL(SIG_OVERFLOW1) {
	aktuellerServo = 0;
	i_OutPort = 255;
	
	SetByte(i_OutPort); 		// alle Servos einschalten
	TCNT1 = (uint16_t)48000; 	// Initialwert von 48000 eingeben (fr 20ms Tackt)
	TCCR0 = 3; 					// 8-Bit Timer0 auf Clk/64 initialisieren
	TCNT0 = servo_Array[aktuellerServo][1];			// Initialwert von 20 eingeben	(fr 1 ms Tackt)
}

/*	Interrupt luft auf, wenn der nchste Servo ausgeschaltet werden muss.
	Der Puls wird neu gestartet und aktuellerServo um eins verringert */
SIGNAL(SIG_OVERFLOW0) {
		//cbi(PORTB, servo_Abschaltung[aktuellerServo]);
		i_OutPort &= (0 << aktuellerServo);
		SetByte(i_OutPort);
		
		if (aktuellerServo == MAX_SERVOS)
		{
			TCCR0 = 0; 				// 8-Bit Timer0 ausschaltet
			//aktuellerServo = MAX_SERVOS - 1;
		}
		else if (aktuellerServo == 0)
		{
			TCNT0 = servo_Array[aktuellerServo][1];
		}
		else if ((aktuellerServo > 0) && (aktuellerServo <= MAX_SERVOS-1))
		{
			TCNT0 = servo_Array[aktuellerServo][1] - servo_Array[aktuellerServo-1][1];
		}
		aktuellerServo++;
}