#include <avr/iom128.h>
int uart_putchar (char c)
{
	if (c == '\n')
		uart_putchar('\r');
	//Warten solange bis Zeichen gesendet wurde
	loop_until_bit_is_set(UCSR0A, UDRE);
	//Ausgabe des Zeichens
	UDR0 = c;
	return (0);
}

/* Initialize UART */
void InitUART( unsigned char baud )
{
	/* Set baud rate */
	//UBRRH = (unsigned char)(baud>>8);
	UBRR0L = (unsigned char)baud;
	/* Enable receiver and transmitter */
	UCSR0B = (1<<RXEN)|(1<<TXEN);
	/* Set frame format: 8data, 2stop bit */
	UCSR0C = (1<<USBS)|(3<<UCSZ0);
	
	//open a channel for printf (STDOUT)
	//fdevopen (uart_putchar, NULL);
}

/* Read and write functions */
unsigned char ReceiveByte( void )
{
	while ( !(UCSR0A & (1<<RXC)) ) 
		;
	return UDR0;
}

void TransmitByte( unsigned char data )
{
	while ( !(UCSR0A & (1<<UDRE)) )
		;
	UDR0 = data;
}
