; copyright HR
; special functions to provide for application code access to FLASH
; can be expanded with own functions and place a rjmp vector at end of this file

.if UseSpecialWrite
writeflash:
; void write_flash(uint32_t address, uint16_t size, const uint8_t* buffer);
; r25:r24:r23:r22, r21:r20, r19:r18

.if PageSize * 2 > 256
.error "PageSize is greater as 256 bytes, check programing loops"
.endif

		movw	zl, r22									; address to r24:Z
		movw	xl, r18									; SRAM buffer to X
		movw	r18, yl									; save Y to r18
		movw	yl, r20									; size to Y
		movw	r20, r16								; save r17:r16 to r21:r20
		xin		r23, SREG								; save SREG to r23
		cli												; disable IRQs
.if UseSpecialWriteBoot
		clt												; set T flag if MSB of address is a magic to deactivate 
		cpi		r25, 0xAC								; write cheks to bootloader section	
		brne	wf1
		set		
.endif ; .if UseSpecialWriteBoot

wf1:	sbic 	EECR, EEWE								; wait for EEPROM
		rjmp 	wf1

		andi	r22, PageSize *2 -1						; align address
		sub		zl, r22

wf2:	ldi		r25, PageSize
.if UseSpecialWriteBoot
		brts	wf3										; if T flag is set ignore sanity check
.endif
		cpi		zl, byte1(BootStart *2)					; sanity check to ensure not to overwrite bootloader
		ldi		r17, byte2(BootStart *2)				
		cpc		zh, r17
.if XMega
		ldi		r17, byte3(BootStart * 2)
		cpc		r24, r17
.endif
		brsh	wf8

wf3:	ldi		r17, (1 << SPMEN)
.if XMega
		xout	RAMPZ, r24
.endif
wf4:	xlpm	r0, z+									; first load word from FLASH
		xlpm	r1, z
		sbiw	z, 1
		sbiw	yl, 0									; size = 0 ?
		breq	wf7
		cpi		r22, 1
		brlo	wf5
		breq	wf6
		subi	r22, 2
		rjmp	wf7
wf5:	ld		r0, x+			
		sbiw	yl, 1
		breq	wf7
wf6:	ld		r1, x+
		sbiw	yl, 1
		clr		r22
wf7:	xwdr
.if BLS
		rcall	dospm									; fill FLASH buffer
.else
		xout	SPMCSR, r17
		spm
.endif
		adiw	z, 2		
		dec		r25										; PageSize
		brne	wf4

		subi	zl, byte1(PageSize *2)
		sbci	zh, byte2(PageSize *2)
.if BLS
		ldi		r17, (1 << PGERS) | (1 << SPMEN)		; erase FLASH page
		rcall	dospm
		ldi		r17, (1 << PGWRT) | (1 << SPMEN)		; program FLASH page
		rcall	dospm
.ifdef RWWSRE
		ldi		r17, (1 << RWWSRE) | (1 << SPMEN)		; unlock FLASH page
		rcall	dospm
.endif
.else
		ldi		r17, (1 << PGERS) | (1 << SPMEN)		; erase FLASH page
		xout	SPMCSR, r17
		spm
		ldi		r17, (1 << PGWRT) | (1 << SPMEN)		; program FLASH page
		xout	SPMCSR, r17
		spm
.endif
		subi	zl, byte1(-PageSize *2)
		sbci	zh, byte2(-PageSize *2)
.if XMega
		sbci	r24, byte3(-PageSize *2)
.endif
		sbiw	yl, 0									; size = 0 ?
		brne	wf2

wf8:	clr		r1										; restore r1=zero
		movw	yl, r18									; restore Y
		movw	r16, r20								; restore r17:r16
		xout	SREG, r23								; restore SREG
.if UseSpecialRead
		ret												; compile ret if readflash used
.endif
.endif ;.if UseSpecialWrite

.if UseSpecialRead
readflash:
; void readflash(uint32_t address, uint16_t size, const uint8_t* buffer);
; r25:r24:r23:r22, r21:r20, r19:r18
.if XMega
		xout	RAMPZ, r24
.endif	
		movw	zl, r22
		movw	xl, r18
		movw	r24, r20
rf1:	sbiw	r24, 1
		brcs	rf2
		xlpm	r23, z+
		st		x+, r23
		rjmp	rf1
rf2:
.endif ;.if UseSpecialRead

.if UseSpecialMsg
getbootmsg:
; return address and size of BootMsg, can be used in application to read out BootMsg and follow datas
		ldi		r22, byte1(BootMsg * 2)
		ldi		r23, byte2(BootMsg * 2)
		ldi		r24, byte3(BootMsg * 2)
		ldi		r25, (BootInfo - BootMsg) * 2
		ret
.endif ;.if UseSpecialMsg

; rjmp vectors for support from application code
; can be expanded with own vectors to own code, look into AVRootloader.h how to call
; please don't reorder this jump table, but you can expand it to own code
.org (FLASHEND +1) -4
		bjmp	getbootmsg, UseSpecialMsg				; rjmp getbootmsg if UseSpecial else ret
		bjmp	readflash, UseSpecialRead
		bjmp	writeflash, UseSpecialWrite
		rjmp	bootstart
