//////////////////////////////////////////////////////////////////////////////////
// Company:         developed for opencores.org
// Engineer/Author: Cristian Bureriu
// 
// Create Date:     10:36:27 12/12/2008
// Design Name:     Sinusoidal Waveform Computator
// Module Name:     sin.v
// Project Name:    SIN
// Target Vendors:  Xilinx, Altera, Actel, Lattice
// Target Devices:  FPGA, CPLD
// Tool versions:   Xilinx Webpack 10.1, Modelsim XE III v6.3c
//
// Description:     Sin & Cos Waveform Generator
// Version:         1.0
// Revision:        1.0-16
//
// Dependencies:    n/a (stand-alone module)
//
// License type:    For education purposes only. Portions of this code or it's entirety cannot be used for
//                  commercial purposes without prior written consent from the author
//
//                  Commercial release of this module is available. Contact the author for details.
//                  Highlights in the commercial release: 8-16-24-32 bit selectable width, signed or unsigned output format,
//                  single, bi-phase, tri-phase synchronous output with rigorous timing constraints
// 
//////////////////////////////////////////////////////////////////////////////////


`timescale 1ns / 1ps


`define AutoInit // comment this line to use async reset to initialize the module
// either AutoInit or reset is required to start sin/cos generation

module sin(
	input  reset,      // async reset
	input  clock,      // input clock
	output [15:0] sin, // sin output: signed, 16-bit
	output [15:0] cos, // cos output: signed, 16-bit
	output sin_sqr,    // sign(sin)
	output cos_sqr     // sign(cos)
   );
	
parameter width = 16;
parameter InitCos = 32640;

reg [width-1:0] sin1, cos1;
wire [31:0] sin2, cos2;

reg [1:0] init = 0;

`ifdef AutoInit		
always @(posedge clock)
  begin
		if (init < 3) init = init + 1;
		if (init == 1)
			begin 
				sin1 <= 0;
				cos1 <= InitCos;
			end
		else
			begin 
            sin1 <= sin;
            cos1 <= cos;
			end
  end
`endif

`ifndef AutoInit
always @(posedge clock, posedge reset)
	if (reset)
		begin 
			sin1 <= 0;
			cos1 <= InitCos;
		end
	else
		begin 
			  sin1 <= sin;
			  cos1 <= cos;
		end
`endif

//the computator
assign sin = sin1 + {cos1[15], cos1[15], cos1[15], cos1[15], cos1[15], cos1[15], cos1[15], cos1[15], cos1[15:7]};
assign cos = cos1 - {sin[15],  sin[15],  sin[15],  sin[15],  sin[15],  sin[15],  sin[15],  sin[15],  sin[15:7]};	

//sign
assign sin_sqr = !sin[15];
assign cos_sqr = !cos[15];

endmodule

