//////////////////////////////////////////////////////////////////////////////////
// Company:         developed for opencores.org
// Engineer/Author: Cristian Bureriu
// 
// Create Date:     10:36:27 12/12/2008
// Design Name:     Sinusoidal Waveform Computator - Test Fixture
// Module Name:     sin_test.v
// Project Name:    SIN
// Target Vendors:  Xilinx, Altera, Actel, Lattice
// Target Devices:  FPGA, CPLD
// Tool versions:   Xilinx Webpack 10.1, Modelsim XE III v6.3c
//
// Description:     Sin & Cos Waveform Generator
// Version:         1.0
// Revision:        1.0-16
//
// Dependencies:    n/a (stand-alone module)
//
// License type:    For education purposes only. Portions of this code or it's entirety cannot be used for
//                  commercial purposes without prior written consent from the author
//
//                  Commercial release of this module is available. Contact the author for details.
//                  Highlights in the commercial release: 8-16-24-32 bit selectable width, signed or unsigned output format,
//                  single, bi-phase, tri-phase synchronous output with rigorous timing constraints
// 
//////////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

module sin_test;

	// Inputs
	reg reset;
	reg clock;

	// Outputs
	wire [15:0] sin;
	wire [15:0] cos;
	wire sin_sqr;
	wire cos_sqr;

	// Instantiate the Unit Under Test (UUT)
	sin uut (
		.reset(reset), 
		.clock(clock), 
		.sin(sin), 
		.cos(cos), 
		.sin_sqr(sin_sqr), 
		.cos_sqr(cos_sqr)
	);

always #5 clock = ~clock;

	initial begin
		// Initialize Inputs
		reset = 0;
		clock = 0;

		// Wait 100 ns for global reset to finish
		#100;
        
		// Add stimulus here
		reset = 1; #10; reset = 0; // if AutoInit mode disabled reset needs to be asserted
		// comment the above line if module works in AutoInit mode
		
		// no other stimulus needed in AutoInit mode

	end
      
endmodule

