--------------------------------------------------------------------
-- Test Bench

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Test_sin is
end entity Test_sin;

architecture test of Test_sin is

       component sin is
       port (
               Clk_IN          : in std_logic;
               nRst_IN         : in std_logic;
               Sin_OUT         : out std_logic_vector(15 downto 0);
               Cos_OUT         : out std_logic_vector(15 downto 0);
               Sin_Sqr_OUT     : out std_logic;
               Cos_Sqr_OUT     : out std_logic
               );
       end component;

       signal Clk_IN           : std_logic;
       signal nRst_IN          : std_logic;
       signal Sin_OUT          : std_logic_vector(15 downto 0);
       signal Cos_OUT          : std_logic_vector(15 downto 0);
       signal Sin_Sqr_OUT      : std_logic;
       signal Cos_Sqr_OUT      : std_logic;

begin

process
begin
       Clk_IN <= '0';
       wait for 100 ns;
       Clk_IN <= '1';
       wait for 100 ns;
end process;


process
begin
       nRst_IN <= '0';
       wait for 100 ns;
       nRst_IN <= '1';
       wait;
end process;

UUT : sin
port map(
       Clk_IN          => Clk_IN,
       nRst_IN         => nRst_IN,
       Sin_OUT         => Sin_OUT,
       Cos_OUT         => Cos_OUT,
       Sin_Sqr_OUT     => Sin_Sqr_OUT,
       Cos_Sqr_OUT     => Cos_Sqr_OUT
       );

end architecture test;