`timescale 1 ns / 1 ps

`define top testsys_tb
`define uart_pins testsys_tb.testsys_inst_uart_external_connection_bfm

module master_test_program #();

	// synthesis translate_off
	import verbosity_pkg::*;
	import avalon_mm_pkg::*;
	import avalon_utilities_pkg::*;
   
initial
begin
	$display ( "@ %t master_test_program: uart pins bfm version: %s", $time, `uart_pins.get_version());
	`uart_pins.set_rxd(1'b1); // Stop bit
	wait (`top.testsys_inst_reset_bfm_reset_reset == 1);
	$display ( "@ %t, master_test_program: reset complete", $time);    
	#10000 $display ( "@ %t, master_test_program: simulated delay", $time); 
	uart_send(8'h48, 50);
	#5000 uart_send(8'h61, 50);
	#5000 uart_send(8'h6C, 50);
	#5000 uart_send(8'h6C, 50);
	#5000 uart_send(8'h6F, 50);
	@(posedge `top.testsys_inst_clk_bfm_clk_clk);
	#5000 $display ( "@ %t, master_test_program: finished", $time); 
end

task automatic uart_send;
  input [7:0] data;
  input time bit_length;
  begin
	$display ( "@ %t, master_test_program: uart_send started", $time);
    `uart_pins.set_rxd(1'b0); // Start bit
	#(bit_length) `uart_pins.set_rxd(data[0]);
	#(bit_length) `uart_pins.set_rxd(data[1]);
	#(bit_length) `uart_pins.set_rxd(data[2]);
	#(bit_length) `uart_pins.set_rxd(data[3]);
	#(bit_length) `uart_pins.set_rxd(data[4]);
	#(bit_length) `uart_pins.set_rxd(data[5]);
	#(bit_length) `uart_pins.set_rxd(data[6]);
	#(bit_length) `uart_pins.set_rxd(data[7]);
	#(bit_length) `uart_pins.set_rxd(1'b1); // Stop bit
	#(bit_length) $display ( "@ %t, master_test_program: uart_send finished", $time);
  end
endtask

endmodule