/**************************************
 Dekomprimieren eines gepackten Bildes
***************************************/
static long  PixPos;
static long  BitPos;
static long  BitBuf;
static word* Palette;
static byte* MapBuf;
static byte  qOld, qRep, mask;
static long  shift, numColors;

byte PxGet (void)
{ long Q;
  byte result;

  if (BitPos < shift)
  { Q = *MapBuf++;
    BitBuf = BitBuf | (Q<<BitPos);
    BitPos += 8;     // ist hier ja immer byteweise
  }
  result = BitBuf & mask;
  BitBuf = BitBuf >> shift;
  BitPos -= shift;
  return result;
}


word GetPixel (void)
{ byte b;
  word result;

  if (qRep>(numColors-1))
  { result = *(Palette + qOld);
    --qRep;
  }
  else
  { b = PxGet();
    if (b<numColors)
    { qOld = b;
      result = *(Palette + b);
    }
    else
    { result = *(Palette + qOld);
      qRep = b-1;
    }
  }
  return result;
}


/**************************************************************
 Zeichnet ein Bild.
 X,Y = Koordinate links oben

 Bildformate:
 a) unkomprimiert:
 zuerst 1 word ID = 0
 dann 1 word unsichtbare Farbe
 dann 1 word Breite
 dann 1 word Hhe
 dann die Pixel als words, beginnend links oben

 b) komprimiert:
 zuerst 1 word ID:
   Hibyte = Bitanzahl pro Pixel
   Lobyte = Anzahl verwendeter Farben.
   (immer Lobyte < (1 << Hibyte)
 dann 1 word unsichtbare Farbe, 0 = aus
 dann 1 word Breite
 dann 1 word Hhe
 dann 1 word Anzahl der Paletteneintrge
 dann die Pixel als Bitstream, beginnend links oben


***************************************************************/
void CgPicture_at (TDCB* DC, POINT* A, const word* Bild)
{ word* Gram;                    /* Zeiger auf Displaypuffer */
  word* Zlanf;                   /* zeigt auf linksoben-Position fr das Bild */
  word x, y, i, dx, dy, w;
  word kenner, farblos, numpal;

  x = A->X;
  y = A->Y;

  kenner  = *Bild++;      /* Flags laden */
  farblos = *Bild++;      /* "hollow" laden */
  dx = *Bild++;           /* Bildbreite in Pixeln */
  dy = *Bild++;           /* Bildhhe in Pixeln */

  Gram = DC->Buffer;      /* zeigt auf links oben im Displaypuffer */
  Zlanf = Gram +
          x +
	  (y * DC->PixelPerLine); /* zeigt auf Bildposition */

  /* jetzt alle Pixel zeilenweise vlnr und von oben nach unten zeichnen */

  if (kenner==0)
  /***************** Bild ist unkomprimiert ********************/
  { while (dy--)
    { i = dx;
      Gram = Zlanf;     /* jetzt Zeiger auf aktuelles Pixel */
      Zlanf = Zlanf + DC->PixelPerLine;
      while (i--)
      { w = *Bild++;
       if (w!=farblos) *Gram = w;
       ++Gram;
      }
    }
  }
  else
  /***************** Bild ist komprimiert ********************/
  { numpal  = *Bild++;
    Palette = (word*) Bild;
    MapBuf  = (byte*) (Bild + numpal);

    numColors = kenner & 0xFF;
    shift     = (kenner >> 8) & 0xFF;
    mask      = (1<<shift) - 1;

    PixPos  = 0;
    BitPos  = 0;
    BitBuf  = 0;
    qOld    = 0;
    qRep    = 0;

    if (!farblos)
    /******* ohne farblose Bits **********/
    { while (dy--)
      { i = dx;
        Gram = Zlanf;
        Zlanf = Zlanf + DC->PixelPerLine;
        while (i--)
        { w = GetPixel();
         *Gram = w;
         ++Gram;
        }
      }
    }
    else
    /******* mit farblosen Bits **********/
    { while (dy--)
      { i = dx;
        Gram = Zlanf;
        Zlanf = Zlanf + DC->PixelPerLine;
        while (i--)
        { w = GetPixel();
         if (w!=farblos) *Gram = w;
         ++Gram;
        }
      }
    }
  }
}



