

; Definitionen

; Belegungen der Atmel-Ports:

;*****************************************************************

;	PA0			Z1
;	PA1			Z2
;	PA2			Z3
;	PA3			Z4
;	PA4			Z5
;	PA5			Z6
;	PA6			Z7
;	PA7			CP1

;	PB0
;	PB1
;	PB2
;	PB3
;	PB4	        SS        frei fr ISP
;	PB5	        MOSI      frei fr ISP
;	PB6	        MISO      frei fr ISP
;	PB7	        SCK       frei fr ISP

;	PC0			CP2
;	PC1			CP3
;	PC2			CP4
;	PC3			D5
;	PC4			D4
;	PC5			D3
;	PC6			D2
;	PC7			D1

;	PD0        RxD       async Serial fr PC
;	PD1        TxD       async Serial fr PC
;	PD2
;	PD3
;	PD4
;	PD5
;	PD6
;	PD7


.include "m8515def.inc"

;*****************************************************************

.DSEG

.ORG    $060
    
LED_TEXT:		.byte    4		; angezeigter Text
UART_BUF:		.byte    16		; Textbuffer vom UART

;**************************** Register-Bits **************************
;--- Display ---------------------------------------------------------

.equ	ON_TIME		= $80

.equ	LINE_PORT	= PORTA

.equ    Z1			= PA0
.equ    Z2			= PA1
.equ    Z3			= PA2
.equ    Z4			= PA3
.equ    Z5			= PA4
.equ    Z6			= PA5
.equ    Z7			= PA6

.equ	CP1_PORT	= PORTA

.equ	CP1			= PA7

.equ	DATA_PORT	= PORTC

; D1 - D5 -> PC0 - PC4

.equ	CP2_PORT	= PORTC
.equ	CP3_PORT	= PORTC
.equ	CP4_PORT	= PORTC

.equ    CP2			= PC2
.equ    CP3			= PC1
.equ    CP4			= PC0

.equ	SPACE		= $20					; Space fr Tabelle

;--- higher Register ----------------------------------------------

.def    TEMP_A      = r16                   ; temporre  8Bit-Register
.def    TEMP_B      = r17
.def	TEMP_C		= r18
.def	TEMP_D		= r19

.def	LINE_COUNT	= r20
.def	LINE_MASK	= r21
.def	NULL		= r22

;--- Macros -------------------------------------------------------

.macro  load_p                    			; ldt 16Bit @1 nach @0 High und @0 Low

        ldi     @0H,HIGH(@1)
        ldi     @0L,LOW(@1)

.endmacro

;****************************** Verktor-Liste ****************************

.CSEG
                rjmp    Reset

.org INT0addr			;External Interrupt0 Vector Address
                reti

.org INT1addr			;External Interrupt1 Vector Address
                reti

.org ICP1addr			;Input Capture1 Interrupt Vector Address
                reti

.org OC1Aaddr			;Output Compare1A Interrupt Vector Address
                reti

.org OC1Baddr			;Output Compare1B Interrupt Vector Address
                reti

.org OVF1addr			;Overflow1 Interrupt Vector Address
				reti

.org OVF0addr			;Overflow0 Interrupt Vector Address
				reti

.org SPIaddr			;SPI Interrupt Vector Address
                reti

.org URXCaddr			;UART Receive Complete Interrupt Vector Address
                reti

.org UDREaddr			;UART Data Register Empty Interrupt Vector Address
                reti

.org UTXCaddr			;UART Transmit Complete Interrupt Vector Address
                reti

.org ACIaddr			;Analog Comparator Interrupt Vector Address
                reti

.org INT2addr			;External Interrupt2 Vector Address
				reti

.org OC0addr			;Output Compare0 Interrupt Vector Address
                reti

.org ERDYaddr			;EEPROM Interrupt Vector Address
                reti

.org SPMRaddr			;Store Program Memory Ready Interrupt Vector Address
                reti

;****************************** Programm-Beginn **********************

;*********************************************************************
;  Initialisierungsroutine
;*********************************************************************

; Hardware initialisieren

Reset:
		ldi     TEMP_A,low(RAMEND)          ; Stack an das interne Ram-Ende
        out     SPL,TEMP_A
        ldi     TEMP_A,high(RAMEND)
        out     SPH,TEMP_A

		clr		TEMP_A
		out		MCUCR,TEMP_A
		out		EMCUCR,TEMP_A

; Port A *************************************************************

		ser		TEMP_A						; Z1-Z7 auf H, CP1 auf H
		out		PORTA,TEMP_A
		out		DDRA,TEMP_A					; alles Ausgang

; Port B *************************************************************

        ser     TEMP_A
        out     PORTB,TEMP_A                ; Alle PullUp ein
        clr     TEMP_A						
		out     DDRB,TEMP_A					; alles Eingang

; Port C *************************************************************

        ser     TEMP_A
        out     PORTC,TEMP_A 				; D1-D5 auf H, CP2-CP4 auf H
        out     DDRC,TEMP_A                 ; alle Ausgang

; Port D *************************************************************

        ser     TEMP_A
        out     PORTD,TEMP_A                ; Alle PullUp ein
        clr     TEMP_A						
		out     DDRD,TEMP_A					; alles Eingang

;*********************************************************************				 

; Software initialisieren

		load_p	Z,LED_TEXT
		ldi		TEMP_A,'0'
		st		Z+,TEMP_A
		ldi		TEMP_A,'1'
		st		Z+,TEMP_A
		ldi		TEMP_A,'2'
		st		Z+,TEMP_A
		ldi		TEMP_A,'3'
		st		Z,TEMP_A

		clr		NULL

;*********************************************************************
;  Main-Loop
;*********************************************************************

main:
		clr		LINE_COUNT
		ldi		LINE_MASK,0b11111110	; 1, Zeile			

line_loop:
		ser		TEMP_C
		out		LINE_PORT,TEMP_C		; alle Zeilen auf H -> aus

		load_p	X,LED_TEXT				; Zeiger auf Text linkes Zeichen
		
		rcall	get_char_line

		out		DATA_PORT,TEMP_A		; Daten auf Port
		cbi		CP1_PORT,CP1			; und in Stelle 1 schreiben
		rcall	clock_wait
		sbi		CP1_PORT,CP1	

		rcall	get_char_line

		out		DATA_PORT,TEMP_A		; Daten auf Port
		cbi		CP2_PORT,CP2			; und in Stelle 2 schreiben
		rcall	clock_wait
		sbi		CP2_PORT,CP2	

		rcall	get_char_line

		out		DATA_PORT,TEMP_A		; Daten auf Port
		cbi		CP3_PORT,CP3			; und in Stelle 3 schreiben
		rcall	clock_wait
		sbi		CP3_PORT,CP3	

		rcall	get_char_line

		out		DATA_PORT,TEMP_A		; Daten auf Port
		cbi		CP4_PORT,CP4			; und in Stelle 4 schreiben
		rcall	clock_wait
		sbi		CP4_PORT,CP4	

		rcall	clock_wait

		out		LINE_PORT,LINE_MASK		; Zeile einschalten

		ldi		TEMP_C,ON_TIME
on_loop:								; Leuchtdauer
		dec		TEMP_C
		brne	on_loop

		sec								; Carry auf 1 fr rol !
		rol		LINE_MASK				; L fr nchste Zeile
		inc		LINE_COUNT
		cpi		LINE_COUNT,7
		brne	line_loop				; nein, nchste Zeile...	
				
		rjmp	main

;***************************************************************************
;  Taktbreite
;	
;  Scratch-Reg: 
;***************************************************************************
clock_wait:
		nop
		nop
		nop
		nop
		nop
		ret	

;***************************************************************************
;  Holt Daten einer Zeile fr eine Spalte
;  Zeiger auf Zeichen in X
;  Daten fr Zeile nach TEMP_A 	
;  X +1
;	
;  Scratch-Reg: 
;***************************************************************************
get_char_line:

		load_p	Z,(charset*2)

		ld		TEMP_A,X+				; erstes Zeichen holen
        subi	TEMP_A,$30				; Offset bis 0 weg
		clr		TEMP_B
		lsl		TEMP_A					; *8 Zeichengre
		rol		TEMP_B
		lsl		TEMP_A
		rol		TEMP_B
		lsl		TEMP_A
		rol		TEMP_B
		
		add		ZL,TEMP_A				; zum Tabellenanfang dazu
		adc		ZH,TEMP_B		

		add		ZL,LINE_COUNT			; aktuelle Zeile
		adc		ZH,NULL					; 0		
		
		lpm		TEMP_A,Z				; und Daten nach TEMP_A

		ori		TEMP_A,(1<<CP2)+(1<<CP3)+(1<<CP4)

		ret

;*** Tabelle Charset *********************************************

charset:
;	0		$30

	.db	0b01110000,0b10001000
	.db	0b10011000,0b10101000
	.db	0b11001000,0b10001000
	.db	0b01110000,0b00000000

;	1		$31
	.db	0b00100000,0b01100000
	.db	0b00100000,0b00100000
	.db	0b00100000,0b00100000
	.db	0b01110000,0b00000000
	  
;	2		$32
	.db	0b01110000,0b10001000
	.db	0b00001000,0b00010000
	.db	0b00100000,0b01000000
	.db	0b11111000,0b00000000

;	3		$33
	.db	0b11111000,0b00010000
	.db	0b00100000,0b00010000
	.db	0b00001000,0b10001000
	.db	0b01110000,0b00000000

;	4		$34
	.db	0b00010000,0b00110000
	.db	0b01010000,0b10010000
	.db	0b11111000,0b00010000
	.db	0b00010000,0b00000000

;	5		$35
	.db	0b11111000,0b10000000
	.db	0b11110000,0b00001000
	.db	0b00001000,0b10001000
	.db	0b01110000,0b00000000

;	6		$36
	.db	0b01000000,0b10000000
	.db	0b10000000,0b11110000
	.db	0b10001000,0b10001000
	.db	0b01110000,0b00000000

;	7		$37
	.db	0b11111000,0b00001000
	.db	0b00010000,0b00100000
	.db	0b01000000,0b10000000
	.db	0b10000000,0b00000000

;	8		$38
	.db	0b01110000,0b10001000
	.db	0b10001000,0b01110000
	.db	0b10001000,0b10001000
	.db	0b01110000,0b00000000

;	9		$39
	.db	0b01110000,0b10001000
	.db	0b10001000,0b01111000
	.db	0b00001000,0b00001000
	.db	0b00010000,0b00000000
	  
;	A
	.db	0b01110000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b11111000,0b10001000
	.db	0b10001000,0b00000000

;	B
	.db	0b11110000,0b10001000
	.db	0b10001000,0b11110000
	.db	0b10001000,0b10001000
	.db	0b11110000,0b00000000

;	C
	.db	0b01110000,0b10001000
	.db	0b10000000,0b10000000
	.db	0b10000000,0b10001000
	.db	0b01110000,0b00000000

;	D
	.db	0b11110000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b11110000,0b00000000

;	E
	.db	0b11111000,0b10000000
	.db	0b10000000,0b11111000
	.db	0b10000000,0b10000000
	.db	0b11111000,0b00000000

;	F
	.db	0b11111000,0b10000000
	.db	0b10000000,0b11111000
	.db	0b10000000,0b10000000
	.db	0b10000000,0b00000000

;	G
	.db	0b01110000,0b10001000
	.db	0b10000000,0b10011000
	.db	0b10001000,0b10001000
	.db	0b01110000,0b00000000

;	H
	.db	0b10001000,0b10001000
	.db	0b10001000,0b11111000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b00000000

;	I
	.db	0b01110000,0b00100000
	.db	0b00100000,0b00100000
	.db	0b00100000,0b00100000
	.db	0b01110000,0b00000000

;	J
	.db	0b00111000,0b00010000
	.db	0b00010000,0b00010000
	.db	0b00010000,0b10010000
	.db	0b01100000,0b00000000

;	K
	.db	0b10001000,0b10010000
	.db	0b10100000,0b11000000
	.db	0b10100000,0b10010000
	.db	0b10001000,0b00000000

;	L
	.db	0b10000000,0b10000000
	.db	0b10000000,0b10000000
	.db	0b10000000,0b10000000
	.db	0b11111000,0b00000000

;	M
	.db	0b10001000,0b11011000
	.db	0b10101000,0b10101000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b00000000

;	N
	.db	0b10001000,0b10001000
	.db	0b11001000,0b10101000
	.db	0b10011000,0b10001000
	.db	0b10001000,0b00000000

;	O
	.db	0b01110000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b01110000,0b00000000

;	P
	.db	0b11110000,0b10001000
	.db	0b10001000,0b11110000
	.db	0b10000000,0b10000000
	.db	0b10000000,0b00000000

;	Q
	.db	0b01110000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b10101000,0b10010000
	.db	0b01101000,0b00000000

;	R
	.db	0b11110000,0b10001000
	.db	0b10001000,0b11110000
	.db	0b10100000,0b10010000
	.db	0b10001000,0b00000000

;	S
	.db	0b01111000,0b10000000
	.db	0b10000000,0b01110000
	.db	0b00001000,0b00001000
	.db	0b11110000,0b00000000

;	T
	.db	0b11111000,0b00100000
	.db	0b00100000,0b00100000
	.db	0b00100000,0b00100000
	.db	0b00100000,0b00000000

;	U
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b01110000,0b00000000

;	V
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10001000
	.db	0b10001000,0b01010000
	.db	0b00100000,0b00000000

;	W
	.db	0b10001000,0b10001000
	.db	0b10001000,0b10101000
	.db	0b10101000,0b10101000
	.db	0b01010000,0b00000000

;	X
	.db	0b10001000,0b10001000
	.db	0b01010000,0b00100000
	.db	0b01010000,0b10001000
	.db	0b10001000,0b00000000

;	Y
	.db	0b10001000,0b10001000
	.db	0b10001000,0b01010000
	.db	0b00100000,0b00100000
	.db	0b00100000,0b00000000

;	Z
	.db	0b11111000,0b00001000
	.db	0b00010000,0b00100000
	.db	0b01000000,0b10000000
	.db	0b11111000,0b00000000


