
#ifndef _dft_h
#include <dft.h>
#endif

#ifndef __math_h
#include <math.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#include <alloc.h>



void dft(int far *wert,float far *spektrum)
{
	int nmax=1024;	           // Anzahl der Summanden ( DFT L�nge )
	float u3=0;
	float re=0,im=0,u1=0,u2=0;
	float x=0,y=0,u0=0;
	int k=0,i=0;	           // Laufvariablen

	for (i=1;i<=nmax-512;i++)  //H�lfte des Spektrums abschneiden
	{                          //�u�ere Schleife gibt die einzelnen
		//Amplituden an das R�ckgabefeld
		re=0;
		im=0;

		for (k=1;k<=nmax;k++)     //Innere Schleife f�hrt die Summation durch
		{
			u0=wert[k];	           //Quantisierte Spannungswerte (12 Bit = 0...4095)

			x=cos(2*M_PI*k*(i-1)/nmax);    //e^j(phi) =cos(phi) + j sin(phi)

			y=sin(2*M_PI*k*(i-1)/nmax);

			re=re+u0*x;

			im=im+u0*y;

			u1=re/nmax;

			u2=im/nmax;

			u3=sqrt(pow(u1,2)+pow(u2,2));   //Betrag = Wurzel(Re^2 + Im^2)

		}  			// Ende innere FOR NEXT ( k )

		//****** Logarithmierte Amplituden ********************

		spektrum[i]=(20 * log((double)u3+0.001));  //0...60dB
		//0.001 begrenzt den Logarithmus
		//nach unten
		//****** Lineare Amplituden ****************************
		//spektrum[i]=u3;

	}			// Ende �u�ere FOR NEXT ( i )

}			// Ende Funktion DFT


void _fft(int far *zeitwert,float far *spektrum)		 //FFT-Funktion
{
	#define FFT_LENGTH 1024       	// Anzahl der Abtastwerte (entspricht POINTS * 2)
	#define LEVEL 10         	// Anzahl der Stufen 10 = ld(1024)

	//Speicher auf dem Stack reservieren
	int   z,l,i,j,la,r,ar,v;
	float z1,z2,z3,z4,xr,xi,yr,yi;
	int d[LEVEL];      		// Inhalt: LEVEL-1  {Umwandlung}

	/*Struktur vom Typ div_t erzeugen*/
	div_t x;

        float far *freq_re;	// Realteil der Frequenzwerte
        float far *freq_im;	// Imagin�rteil der Frequenzwerte
        float far *sin_tab;     // Sinustabelle
        float far *cos_tab;     // Cosinustabelle
        int   far *bit_rev;	// Umsortier-Index-Feld (Bitrevers)

	//___________________________________________________________________

	//Speicher auf dem Heap reservieren
	freq_re = (float far *)farmalloc((FFT_LENGTH+1) * sizeof(float));
	freq_im = (float far *)farmalloc((FFT_LENGTH+1) * sizeof(float));
	sin_tab = (float far *)farmalloc((FFT_LENGTH+1) * sizeof(float));
	cos_tab = (float far *)farmalloc((FFT_LENGTH+1) * sizeof(float));
	bit_rev = (int far *)farmalloc((FFT_LENGTH+1) * sizeof(int));

	for(i=0;i<FFT_LENGTH;i++)  			// {sin und cos-Tabelle anlegen}
	{
		sin_tab[i] = sin(i*2*M_PI/FFT_LENGTH);
		cos_tab[i] = cos(i*2*M_PI/FFT_LENGTH);
	}

	/*Bit-Reversal- Tabelle b[0..] anlegen*/
	for(i=0;i<FFT_LENGTH;i++)
	{
		z=i;
		/*Dezimal-Index in Dualzahl umwandeln*/
		for(j=0;j<LEVEL;j++)
		{
			x=div(z,2);
			d[j]=(int)x.rem;	// den Rest ins Feld
			z=(int)x.quot;		// den Quotienten nach z
		}
		/*Bit-Revers anordnen*/
		x=div(LEVEL,2);
		for(int buff,j=0;j<(int)x.quot;j++)
		{
			buff = d[j];
			d[j] = d[LEVEL-j-1];
			d[LEVEL-j-1] = buff;
		}
		
		/*Bit-Revers anordnen Zeitoptimiert mit Festwert*/
//		for(int buff,j=0;j<5;j++) 	        // 5 = LEVEL/radix  => x=div(LEVEL,2) => x.quot=5
//		{
//			buff 	     = d[j];
//			d[j] 	     = d[LEVEL-j-1];
//			d[LEVEL-j-1] = buff;
//		}

		/*Umsortierten Index zur�ckwandeln in Dezimalzahl*/
		r = 0;
		for(j=0;j<LEVEL;j++)
		{
			r = r + (1<<j) * d[j];
		}
		/*umsortierter Index*/
		bit_rev[i] = r;
	}/*Ende Bit-Reversal-Tabelle*/

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	/*Zeitwerte umsortieren*/
	for(i=0;i<FFT_LENGTH;i++)
	{
		freq_re[i]=zeitwert[bit_rev[i]];
		freq_im[i]=0;
	}
	/*Das komplexe Spektrum berechnen (butterfly)*/
	for(l=1;l<=LEVEL;l++)
	{
		for(i=0;i<=((1<<(LEVEL-l))-1);i++)
		{
			for(j=0;j<=((1<<(l-1))-1);j++)
			{
				r = j + i* (1 << l);
				ar= j * (FFT_LENGTH >> l);
				v = 1 << (l-1);
				
				z1 = cos_tab[ar] * freq_re[r+v];
				z2 = cos_tab[ar] * freq_im[r+v];
				z3 = sin_tab[ar] * freq_re[r+v];
				z4 = sin_tab[ar] * freq_im[r+v];
				xr = freq_re[r] + z1 + z4;
				xi = freq_im[r] - z3 + z2;
				yr = freq_re[r] - z1 - z4;
				yi = freq_im[r] + z3 - z2;
				freq_re[r] = xr;
				freq_im[r] = xi;
				freq_re[r+v] = yr;
				freq_im[r+v] = yi;
			}
		}
	}
	/*Nur von der H�lfte der Frequenzpunkte den Betrag bilden,*/
	/*da das halbe Spektrum gespiegelt ist*/
	for (i=0;i <= FFT_LENGTH/2+1;i++)
	{
		z1=freq_re[i]/FFT_LENGTH;
		z2=freq_im[i]/FFT_LENGTH;
		z3=(float)sqrt(pow((double)z1,2) + pow((double)z2,2));
		spektrum[i] = z3;	// Betrag des Spektrums
	}

	//Heap wieder freigeben
	farfree(freq_re);
        farfree(freq_im);
        farfree(sin_tab);
        farfree(cos_tab);
        farfree(bit_rev);

	return;

} 	// Ende der FFT-Funktion








