
#include <stdio.h>

#include "floatstr_t.h"

// Class FloatStr
void FloatStr::Init(float In_Value, float In_Min_Value, float In_Max_Value, float In_StepSize, int In_AfterDot, int In_MaxLength, char In_Text[20], char In_PreText[10], char In_Unit[5])
{
	Value = In_Value;
	Stored_Value = In_Value;
	Min_Value = In_Min_Value;
	Max_Value = In_Max_Value;
	StepSize = In_StepSize;
	AfterDot = In_AfterDot;
	MaxLength = In_MaxLength;
	
	sprintf(Text, "%s", In_Text);
	
	sprintf(PreText, "%s", In_PreText);
	
	sprintf(Unit, "%s", In_Unit);
	
	sprintf(DimensionUnit, "");
	
	RenderText();
	
}

float FloatStr::Read_Value(void)
{
	return Value;
}

void FloatStr::Write_Value(float In_Value)
{
	Value = In_Value;
}

float FloatStr::Read_Stored_Value(void)
{
	return Stored_Value;
}

void FloatStr::Write_Stored_Value(float In_Stored_Value)
{
	Stored_Value = In_Stored_Value;
}

float FloatStr::Read_Min_Value(void)
{
	return Min_Value;
}

void FloatStr::Write_Min_Value(float In_Min_Value)
{
	Min_Value = In_Min_Value;
}

float FloatStr::Read_Max_Value(void)
{
	return Max_Value;
}

void FloatStr::Write_Max_Value(float In_Max_Value)
{
	Max_Value = In_Max_Value;
}

float FloatStr::Read_StepSize(void)
{
	return StepSize;
}

void FloatStr::Write_StepSize(float In_StepSize)
{
	StepSize = In_StepSize;
}

int FloatStr::Read_AfterDot(void)
{
	return AfterDot;
}

void FloatStr::Write_AfterDot(int In_AfterDot)
{
	AfterDot = In_AfterDot;
}

int FloatStr::Read_MaxLength(void)
{
	return MaxLength;
}

void FloatStr::Write_MaxLength(int In_MaxLength)
{
	MaxLength = In_MaxLength;
}

void FloatStr::RenderText(void)
{
	int cmpvar;
	char Calc_AfterDot = AfterDot;
	volatile float Calc_Value = Value;
	
	float floattempad = 0;
	int inttempbd = 0;
	int inttempad = 0;

	int buf_int = 0;
	
    if (Calc_Value == 0) Calc_Value = 0.0;
	DimensionUnit[0] = 0;
	
	if (Calc_Value == 0)
	{
		DimensionUnit[0] = 0;
		Calc_Value = 0;
	}        	
	else if (Calc_Value > 0)
	{
//		printf("test:%d %f\r\n", 45, 2.34l);
		if (Calc_Value < 1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = 'm';
//			printf("CalcV m : %f\n", Calc_Value);
		}
		if (Calc_Value < 1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = '&';	
//			printf("CalcV  : %f\n", Calc_Value);
		}
		if (Calc_Value < 1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = 'n';	
//			printf("CalcV n : %f\n", Calc_Value);
		}				
		if (Calc_Value >= 1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'k';
//			printf("CalcV k : %f\n", Calc_Value);
		}
		if (Calc_Value >= 1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'M';
//			printf("CalcV M : %f\n", Calc_Value);
		}
		if (Calc_Value >= 1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'T';
//			printf("CalcV T : %f\n", Calc_Value);
		}
	}
	else if (Calc_Value < 0)
	{
		if (Calc_Value > -1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = 'm';
		}
		if (Calc_Value > -1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = '&';	
		}
		if (Calc_Value > -1)
		{
			Calc_Value = Calc_Value * 1000;
			DimensionUnit[0] = 'n';	
		}			
		if (Calc_Value <= -1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'k';
		}
		if (Calc_Value <= -1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'M';
		}
		if (Calc_Value <= -1000)
		{
			Calc_Value = Calc_Value / 1000;
			DimensionUnit[0] = 'T';
		}
	}
	// Copy Float to Integer
	cmpvar = (int) Calc_Value;
	
	// Compare if there is a after Dot integer
	
	if (cmpvar > 0)
	{	
		if (cmpvar < 9)
		{
			if ((AfterDot + 1) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot + 1));
		}
		else if (cmpvar < 99)
		{
			if ((AfterDot + 2) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot));
		}
		else
		{
			if ((AfterDot + 3) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot - 1));
		}
	}
	else
	{	
		if (cmpvar > -9)
		{
			if ((AfterDot + 1) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot + 1));
		}
		else if (cmpvar > -99)
		{
			if ((AfterDot + 2) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot));
		}
		else
		{
			if ((AfterDot + 3) > MaxLength) Calc_AfterDot = AfterDot - (MaxLength - (AfterDot - 1));
		}
	}
	cmpvar = (int) Calc_Value;	
	
	inttempbd = (int) Calc_Value;
	
	floattempad = Calc_Value - inttempbd;

	switch(Calc_AfterDot)
	{	
		case 0: inttempad = (int) floattempad * 1; break;
		case 1: inttempad = (int) floattempad * 10; break;
		case 2: inttempad = (int) floattempad * 100; break;
		case 3: inttempad = (int) floattempad * 1000; break;
		case 4: inttempad = (int) floattempad * 10000; break;
	}
	int temp = (int) Calc_Value*10000;
	switch(Calc_AfterDot)
	{
		case 0: sprintf(Text, "%s%3d.0 %s%s", PreText, temp/10000, DimensionUnit, Unit); break;
		case 1: sprintf(Text, "%s%3d.%01d %s%s", PreText, temp/10000, temp%10000/1000, DimensionUnit, Unit); break;
		case 2: sprintf(Text, "%s%3d.%02d %s%s", PreText, temp/10000, temp%10000/100, DimensionUnit, Unit); break;
		case 3: sprintf(Text, "%s%3d.%03d %s%s", PreText, temp/10000, temp%10000/10, DimensionUnit, Unit); break;
		case 4: sprintf(Text, "%s%3d.%04d %s%s", PreText, temp/10000, temp%10000, DimensionUnit, Unit); break;
	}  
}

char* FloatStr::Read_Text(void)
{
	return(&Text[0]);
}

char* FloatStr::Read_PreText(void)
{
	return(&PreText[0]);
}

void FloatStr::Write_PreText(char In_PreText[10])
{
	sprintf(PreText, "%s", In_PreText);
}

char* FloatStr::Read_Unit(void)
{
	return(&Unit[0]);
}

void FloatStr::Write_Unit(char In_Unit[5])
{
	sprintf(Unit, "%s", In_Unit);
}

void FloatStr::DoStep(char Direction)
{
	float Calc_Value = Value;
/*	
	if (Calc_Value < 0.000001) StepSize = 0.000000005;
	else
	{
		StepSize = 0.01;
		while (Calc_Value < 1)
		{
			Calc_Value = Calc_Value * 10;
			StepSize = StepSize / 10;
		}
	}
*/	
	if (Direction == 1)
	 { if (Value < Max_Value) Value = Value + StepSize; }
	else
	 { if (Value > Min_Value) Value = Value - StepSize; }
}




