#include <stdio.h>
#include "math.h"
#include "tc_vars.h"
#include "hardware_t.h"
#include "flash_t.h"
#include "display_t.h"
#include "floatstr_t.h"

//#define _Debug_
//#define _Debug_IRQ_
//#define _Debug_QM_
//#define _Debug_FindZero_
//#define _Debug_AutoScale_
//#define _Debug_FindVoltage_
//#define _Debug_FindTimebase_
//#define _Debug_ZeroLevel_
//#define _Debug_Cursor_
//#define _Debug_Roll_Mode_
//#define _Debug_Memory_
//#define _Debug_USB_
//#define _Debug_FFT_

// Class Hardware
void Hardware::Init(void)						// Hardware Init Routine
{
	int x;
	unsigned long ChannelSign = 0;

	na_data_adr->np_piodata = 0x01;
	na_mode->np_piodata 	= 0x01;		//reset CH3 & CH4
	na_mode->np_piodata 	= 0x00;
	na_data_adr->np_piodata = 0x01;		// delay

#ifdef _Debug_
	printf("debug\r\n");
#endif

	printf("Get number of channels\r\n");
	ChannelSign = READADC(3);

	if ((ChannelSign & 0xFFFF0000) == 0x12480000)
	{
		printf("4-Channels found Signatur : %x\r\n", ChannelSign);
		NumberOfChannels = 4;
	}
	else
	{
		printf("2-Channels found Signatur : %x\r\n", ChannelSign);
		NumberOfChannels = 2;
	}
	
	printf("Set piodata pointer\r\n");
	data_adr->np_piodata = 0x00;

	printf("Setup hardware\r");
	Setup_Hardware();	
	printf("Setup hardware 				- done\r\n");

	Read_Version();	
	printf("HW Version : %x  Channels : %d\r\n", tc_hw_version, NumberOfChannels);

	printf("Testing LEDs\r\n");
	//LED-test, 	BF
	for(x=0;x<16;x++)	//switch all LEDs off 	
	{ Reset_LED(x); }
	
	//Set_LED(12);		//Run/Stop green
	//Set_LED(15);		//Single green

	Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red

	for(x=0;x<12;x++)	//switch  LEDs on 
	{ Set_LED(x); }		
	
	//Reset_LED(12);
	//Reset_LED(15);
	//Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red
	Send_LED();
	
	//for(x=0;x<16;x++)	//Init LED status
	//{ LED_ON[x] = 0; }

	
	printf("Setup vars\r");
	Setup_Vars();
	printf("Setup vars 				- done\r\n");

	printf("Setup vars to default values\r");
	Set_Vars_Default();
	printf("Setup vars to default values 		- done\r\n");	

	printf("Read config from flash\r");
	AMDFlash::Read_Config_Flash();
	printf("Read config from flash 			- done\r\n");
	
	printf("Read protected config from flash\r");
	AMDFlash::Read_Protected_Flash();
	printf("Read protected config from flash	- done\r\n");
        
	//printf("11\r\n");
  	//  out_test->np_piodata = test_port_reg;		

	printf("Recalc vars\r");
	Recalc_Vars();
        printf("Recalc vars				- done\r\n");
	
	if (ROLLMODE_TB < 3) ROLLMODE_TB = 3;
	
	if (MenuStatus[1][3] < 104) MenuStatus[1][3] = 104;
	if (MenuStatus[2][3] < 104) MenuStatus[2][3] = 104;
	if (MenuStatus[3][3] < 104) MenuStatus[3][3] = 104;
	if (MenuStatus[4][3] < 104) MenuStatus[4][3] = 104;
	if (MenuStatus[12][4] < 104) MenuStatus[12][4] = 104;
	
	// Coupling channel popup
    	if (MenuStatus[1][0] == 7)
    	{
        	MenuPopupStatus[13][0] = 2;                                     // Popup Coupling = AC
        	MenuPopupStatus[13][1] = 3;
        	MenuPopupStatus[13][2] = 2;
    	}
    	else if (MenuStatus[1][0] == 8)
    	{
        	MenuPopupStatus[13][0] = 2;                                     // Popup Coupling = DC
        	MenuPopupStatus[13][1] = 2;
        	MenuPopupStatus[13][2] = 3;
    	}
    	else
    	{
        	MenuPopupStatus[13][0] = 3;                                     // Popup Coupling = GND
        	MenuPopupStatus[13][1] = 2;
        	MenuPopupStatus[13][2] = 2;
    	}	

	if (MenuStatus[2][0] == 7)
	{
		MenuPopupStatus[14][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[14][1] = 3;
		MenuPopupStatus[14][2] = 2;
	}
	else if (MenuStatus[2][0] == 8)
	{
		MenuPopupStatus[14][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[14][1] = 2;
		MenuPopupStatus[14][2] = 3;
	}
	else
	{
		MenuPopupStatus[14][0] = 3;                                     // Popup Coupling = DC
		MenuPopupStatus[14][1] = 2;
		MenuPopupStatus[14][2] = 2;
	}	
	
	if (MenuStatus[3][0] == 7)
	{
		MenuPopupStatus[15][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 3;
		MenuPopupStatus[15][2] = 2;
	}
	else if (MenuStatus[3][0] == 8)
	{
		MenuPopupStatus[15][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 2;
		MenuPopupStatus[15][2] = 3;
	}
	else
	{
		MenuPopupStatus[15][0] = 3;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 2;
		MenuPopupStatus[15][2] = 2;
	}	
	
	if (MenuStatus[4][0] == 7)
	{
		MenuPopupStatus[16][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 3;
		MenuPopupStatus[16][2] = 2;
	}
	else if (MenuStatus[4][0] == 8)
	{
		MenuPopupStatus[16][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 2;
		MenuPopupStatus[16][2] = 3;
	}
	else
	{
		MenuPopupStatus[16][0] = 3;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 2;
		MenuPopupStatus[16][2] = 2;
	}	

	
//    Debug_Mode = true;	
//    ADC_Debug_Mode = true;	

	

    	dmode_factor = Timebase_Delayed_Factor_Matrix[Selected_Timebase][SIGNALFaktor_idx] / Timebase_Delayed_Factor_Matrix[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx];

    	Cursor_Delayed_1 = ((GRID_WIDTH / 2) - (int) (((float) GRID_WIDTH / dmode_factor) / 2)) + dmode_Window_Offset_Pos;
    	Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / dmode_factor);
    	Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;
		
	if (NumberOfChannels == 2)
	{
		Channel_3_Active = 0;
		Channel_4_Active = 0;
		
		LED_ON[2] = 0;
		LED_ON[3] = 0;
		
		sprintf(&MenuData[29][0], "Math");
		sprintf(&MenuData[140][0], "External");	
		
		MenuDataDef[29] = 33;
		MenuDataDef[140] = 21;
		
		sprintf(&MenuPopupText[1][3][0], "Math");
		sprintf(&MenuPopupText[3][3][0], "Math");
		sprintf(&MenuPopupText[5][3][0], "Math");
		sprintf(&MenuPopupText[6][3][0], "Math");
		sprintf(&MenuPopupText[7][3][0], "External");		
		sprintf(&MenuPopupText[24][3][0], "Math");
		sprintf(&MenuPopupText[25][3][0], "Math");
		sprintf(&MenuPopupText[26][3][0], "Math");

		
		MenuPopupDef[1][1] = 2;//3
		MenuPopupDef[3][1] = 2;//3
		MenuPopupDef[5][1] = 3;
		MenuPopupDef[6][1] = 3;
		MenuPopupDef[7][1] = 3;	
		MenuPopupDef[24][1] = 3;
		MenuPopupDef[25][1] = 3;
		MenuPopupDef[26][1] = 3;
		MenuPopupDef[28][1] = 2;
		MenuPopupDef[29][1] = 2;

		MenuPopupStatus[1][2] = 0;//1;
		MenuPopupStatus[1][3] = 0;
		//MenuPopupStatus[1][4] = 0;
		MenuPopupStatus[3][2] = 0;//1
		MenuPopupStatus[3][3] = 0;
//		MenuPopupStatus[3][4] = 0;    //kein math mehr
		MenuPopupStatus[5][2] = 1;
		MenuPopupStatus[5][3] = 0;
		MenuPopupStatus[5][4] = 0;
		MenuPopupStatus[6][2] = 1;
		MenuPopupStatus[6][3] = 0;
		MenuPopupStatus[6][4] = 0;
		MenuPopupStatus[7][3] = 0;
		MenuPopupStatus[7][4] = 0;
		MenuPopupStatus[24][2] = 1;
		MenuPopupStatus[24][3] = 0;
		MenuPopupStatus[24][4] = 0;
		MenuPopupStatus[25][2] = 1;
		MenuPopupStatus[25][3] = 0;
		MenuPopupStatus[25][4] = 0;
		MenuPopupStatus[26][2] = 0;
		MenuPopupStatus[26][3] = 1;
		MenuPopupStatus[26][4] = 0;	
		MenuPopupStatus[28][2] = 0;
		MenuPopupStatus[28][3] = 0;		
		MenuPopupStatus[29][2] = 0;
		MenuPopupStatus[29][3] = 0;
	}

	key_reset->np_piodata = 0;
	nr_delay(1);
	key_reset->np_piodata = 1;	

	key_int->np_pioedgecapture = 0;				// clear IRQ conditions		
		       		
//	FindSlope();
	
#ifdef _Debug_		       		
	if (Debug_Mode) printf("Init Hardware Ready \n");
#endif

	if (Selected_Timebase > 18)
	{
		Selected_Timebase = 18;
		timebase_reg      = tb_value[Selected_Timebase];
		Display_Timebase  = Selected_Timebase + SIGNALFaktor_idx;
	}
}

void Hardware::Reset_the_Watchdog(void)					//Resets the WatchDog
{
	reset_watchdog->np_piodata = 0x00;			// Reset WatchDog
	reset_watchdog->np_piodata = 0x01;	
}

void Hardware::Start_Record(void)						
{
    //if (Test_Mode) return;

    la_pulse->np_piodata = 0x01;				//stop record Port On
    la_pulse->np_piodata = 0x00;				//stop record Port Off	

    READADC(1);

    adc_started = true;
    start_acq->np_piodata = 0x01;				//start record Port On
    start_acq->np_piodata = 0x00;				//start record Port Off	
#ifdef _Debug_
    if (Debug_Mode) printf("Start Record\n");
#endif
}

void Hardware::Stop_Record(void)							
{
    adc_started = false;
    la_pulse->np_piodata = 0x01;				//stop record Port On
    la_pulse->np_piodata = 0x00;				//stop record Port Off	

//    READADC(1);
#ifdef _Debug_
    if (Debug_Mode) printf("Stop Record\n");
#endif
}

void Hardware::Read_Version(void)					//Read the hardware version
{
    la_gate->np_piodata = 0x01;
    tc_hw_version = (unsigned long) la_data->np_piodata;
    la_gate->np_piodata = 0x00;
}

void Hardware::Setup_Vars(void)						// Set standart values for variables
{
	short ix, ix2, ix3;
    	int cnt;
	
	for (ix = 0;ix < 480;ix++)
	    Display_Line_Adresses[ix] = ix * 20;

	for (ix = 0;ix < 480;ix++)
	    Display_Line_Adresses2[ix] = ix * 80;
	
	for (ix = 0; ix <= 255; ix++) 
        for (ix2 = 0; ix2 < 6; ix2++) 
            for (ix3 = 0; ix3 < 9; ix3++)
                FIR_Tab_big[ix][ix2][ix3] = (short) FIR_Tabel[ix2][ix3] * ix;
    
	for (ix = 0;ix < 32;ix++)
		LogicData[ix] = ix;
	
	// kann wahrscheinlich auf 600 reduziert werden
	//for (ix = 0;ix <= 16385;ix++)
	for (ix = 0;ix <= GRID_WIDTH;ix++) {	
	    SIGNAL1_SUM_MIN[ix] = 255;
	    SIGNAL1_SUM_MAX[ix] = 0;
	}
	
	printf("Building trigonometric tables\r");
	Build_Trigo_Tables();						// BF insert - init FFT-data
	printf("Building trigonometric tables 		- done\r\n");

	MenuStored  = 0;
	MenuActive  = 0;
	MenuChanged = 0;
		
	IsPopuped   = 0;
	
	Selected_ADCs_CH1 = 0;
	Selected_ADCs_CH2 = 0;
	Selected_ADCs_CH3 = 0;
	Selected_ADCs_CH4 = 0;
	
	SelectedChannel    = 1;
	SelectedChannelOld = 1;
		
	Channel_1_Active = 1;	
	Channel_2_Active = 1;
	Channel_3_Active = 1;
	Channel_4_Active = 1;			
	Channel_Math_Active = 0;
	
	Channel_1_Active_Old = 0;	
	Channel_2_Active_Old = 0;
	Channel_3_Active_Old = 0;
	Channel_4_Active_Old = 0;			
	Channel_Math_Active_Old = 0;
	
	//Reset all LEDs	BF
//	for(cnt=0;cnt<16;cnt++)
//	{ Reset_LED(cnt); }

	led_status = 0x01;

	// Channel 1-4 on + Math off
	LED_ON[0] = 1;				
	LED_ON[1] = 1;
	LED_ON[2] = 1;
	LED_ON[3] = 1;	
	LED_ON[4] = 0;
	
	// General Wheel LED off
	LED_ON[5] = 0;	
	
	// Run Green LED On
	LED_ON[12] = 1;
	
	// Trigger edge On
	LED_ON[8] = 1;		

/*	BF del -> is set in default setup
	Virtual_ZeroLevelCH1 = -1 * GRID_HEIGHT / 4;		//-120;
	Virtual_ZeroLevelCH2 = GRID_HEIGHT / 4;			//-50;
	Virtual_ZeroLevelCH3 = (GRID_HEIGHT / 8) * 5;		//50;	
	Virtual_ZeroLevelCH4 = (GRID_HEIGHT / 8) * 3;		//120;
*/
	
	Virtual_ZeroLevelXYCH1 = 0;
	Virtual_ZeroLevelXYCH2 = 0;
	Virtual_ZeroLevelXYCH3 = 0;	
	Virtual_ZeroLevelXYCH4 = 0;	

/*	BF del -> is set in default setup	
	ZeroLevelCH1 = GRID_HEIGHT / 4;
	ZeroLevelCH2 = (GRID_HEIGHT / 4) * 3;
	ZeroLevelCH3 = (GRID_HEIGHT / 8) * 5;	
	ZeroLevelCH4 = (GRID_HEIGHT / 8) * 3;
*/		
	ZeroLevelCH1_Old = GRID_HEIGHT / 4;
	ZeroLevelCH2_Old = (GRID_HEIGHT / 4) * 3;
	ZeroLevelCH3_Old = (GRID_HEIGHT / 8) * 5;
	ZeroLevelCH4_Old = (GRID_HEIGHT / 8) * 3;
	
    	Cursor_Enabled = false;
	
	Cursor_Both_Selected_Old = 0;	
    	Cursor_Both_Selected = 0;	
	
	SelectedCursor = 0;
	SelectedCursorOld = 0;	
	
	CursorChanged = 0;
	
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Active_Old = 0; 	

	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	

	Cursor_Horizontal_Position1_Old = 103;
	Cursor_Horizontal_Position2_Old = 203;	

	Cursor_Vertical_Active = 0;
	Cursor_Vertical_Active_Old = 0;	

	Cursor_Vertical_Position_Real1 = 103;
	Cursor_Vertical_Position_Real2 = 203;	

	Cursor_Vertical_Position1_Old = 103;
	Cursor_Vertical_Position2_Old = 203;	

	Cursor_Vertical_Position_Real_XY_1 = 103;
	Cursor_Vertical_Position_Real_XY_2 = 203;	

	Cursor_Vertical_Position_XY_1_Old = 103;
	Cursor_Vertical_Position_XY_2_Old = 203;
	
    	QM_Enabled = false;
	QM_Changed[0] = 0;
	QM_Changed[1] = 0;
	QM_Changed[2] = 0;
	
	QM_Type[0] = 0;
	QM_Type[1] = 0;
	QM_Type[2] = 0;

	QM_Type_Old[0] = 0;
	QM_Type_Old[1] = 0;
	QM_Type_Old[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 3;
	QM_Horizontal_Active_Old = 3; 	

	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Horizontal_Position1_Old = 103;
	QM_Horizontal_Position2_Old = 203;	

	QM_Vertical_Active = 3;
	QM_Vertical_Active_Old = 3;	

	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	QM_Vertical_Position1_Old = 103;
	QM_Vertical_Position2_Old = 203;		

    	Quick_Measure_Threshold_btn_select = 1;

	SelectedEdgeExtern = 0;

	Memory_Position = 0;	
	
	Selected_Trigger_Source = 0;
	Selected_Trigger_Source_Old = 5;
	
	Selected_Timebase = 4;
	Display_Timebase  = 4;       // Mu� vielleicht ins Flash
	Selected_Expand_Timebase = 0;
	
	dmode_Selected_Timebase = 4;
	dmode_Window_Offset_Pos = 0;
	
	TriggerWay = 1;

/*	BF del -> is set in default setup
	Trigger_Pos_CH1 = 50;
	Trigger_Pos_CH2 = 100;
	Trigger_Pos_CH3 = 150;
	Trigger_Pos_CH4 = 200;
	Trigger_Pos_CHE = 15;
*/	
	Trigger_Pos_CH1_Old = 50;
	Trigger_Pos_CH2_Old = 100;
	Trigger_Pos_CH3_Old = 150;
	Trigger_Pos_CH4_Old = 200;
	Trigger_Pos_CHE_Old = 15;	
	
	Timebase_Offset_Pos 	= 0;
	Timebase_Offset_Pos_Old = 0;

	Trigger_Offset_Pos 	= 8192;
	Trigger_Offset_Pos_Old 	= 8192;
    	
	Selected_Voltage_CH1 = 9;
	Selected_Voltage_CH2 = 9;
	Selected_Voltage_CH3 = 9;
	Selected_Voltage_CH4 = 9;
	Selected_TB = 0;	
	
	SwitchesCH1 = 0x00D5;
	SwitchesCH2 = 0x00D5;
	SwitchesCH3 = 0x00D5;
	SwitchesCH4 = 0x00D5;	
	SwitchesTB = 0x0000;		

	SwitchesCH1Old = 0x0000;
	SwitchesCH2Old = 0x0000;
	SwitchesCH3Old = 0x0000;
	SwitchesCH4Old = 0x0000;		
	SwitchesTBOld = 0x0001;
	
	ScreenShotActive = 0;	
	
	USB_Data_Trans  = 0;
	USB_SendAllData = 0;
	USB_OnlyTrigger = 0;
	Continius       = 1;													// Constant Recodinng
	SingleMode      = 0;	
	
	GridColorArrayPos         = 3;
	GridColor_Val             = 0x3F;
	GridColorArrayPos_Delayed = 2;
	GridColor_Val_Delayed     = 0x15;	
		
	ADC_Debug_Mode = false;
	Debug_Mode     = false;
	Command_Mode   = false;
	Calc_Mode      = false;
	ExtraTrg_Mode  = false;
	Search_Mode    = false;
	Search_Auto    = false;
	
	adc_started    = false;
	Connect_Vals   = true;
	
	ctrl_reg     = 0x00A3;
	adc_ctrl_reg = 0x01C0;
	
	adc_del_reg = 0;
	pre_reg = 0x0000;
	//trg_val_reg = 0x00A0;
	//trg_hyst_reg = 0x0090;
	ext_trg_val_reg = 0x80;
	triggering = 0x00;
	channel_Adr_add = 0x0000;
	trig_range_reg = 0;
	trig_width_reg = 0x0001;
	
	trg_val_CHI_reg   = 0x00A0;
	trg_val_CHII_reg  = 0x00A0;
	trg_val_CHIII_reg = 0x00A0;
	trg_val_CHIV_reg  = 0x00A0;
	
	trig_holdoff_reg = 0x00000000;
	adc_change12_reg = 0x00000000;
	adc_change34_reg = 0x00000000;
	adc_ctr12_reg = 0x00000000;
	adc_ctr34_reg = 0x00000000;
	
	timebase_reg = 0xFFFFFFFF;
	ram_adress_reg = 0;
	test_port_reg = 0;
	
	CH1_DAC_Offset = 8192;
	CH1_Zero_Offset = 0;
	CH1_DAC_1 = 0;
	CH1_DAC_2 = 0;
	CH1_DAC_3 = 0;
	CH1_DAC_4 = 0;
	
	CH2_DAC_Offset = 8192;
	CH2_Zero_Offset = 0;
	CH2_DAC_1 = 0;
	CH2_DAC_2 = 0;
	CH2_DAC_3 = 0;
	CH2_DAC_4 = 0;
	
	CH3_DAC_Offset = 8192;
	CH3_Zero_Offset = 0;
	CH3_DAC_1 = 0;
	CH3_DAC_2 = 0;
	CH3_DAC_3 = 0;
	CH3_DAC_4 = 0;
	
	CH4_DAC_Offset = 8192;
	CH4_Zero_Offset = 0;
	CH4_DAC_1 = 0;
	CH4_DAC_2 = 0;
	CH4_DAC_3 = 0;
	CH4_DAC_4 = 0;
	
	Channel1_1_ADC_Correction = 0;
	Channel1_2_ADC_Correction = 0;
	Channel1_3_ADC_Correction = 0;//256;
	Channel1_4_ADC_Correction = 0;
	
	Channel2_1_ADC_Correction = 0;
	Channel2_2_ADC_Correction = 0;
	Channel2_3_ADC_Correction = 0;//256;
	Channel2_4_ADC_Correction = 0;
	
	Channel3_1_ADC_Correction = 0;
	Channel3_2_ADC_Correction = 0;
	Channel3_3_ADC_Correction = 0;//256;
	Channel3_4_ADC_Correction = 0;
	
	Channel4_1_ADC_Correction = 0;
	Channel4_2_ADC_Correction = 0;
	Channel4_3_ADC_Correction = 0;//256;
	Channel4_4_ADC_Correction = 0;
	
	CH1_X_Offset_1 = 0;
	CH1_X_Offset_2 = 0;
	CH1_X_Offset_3 = 0;
	CH1_X_Offset_4 = 0;
	
	CH2_X_Offset_1 = 0;
	CH2_X_Offset_2 = 0;
	CH2_X_Offset_3 = 0;
	CH2_X_Offset_4 = 0;
	
	CH3_X_Offset_1 = 0;
	CH3_X_Offset_2 = 0;
	CH3_X_Offset_3 = 0;
	CH3_X_Offset_4 = 0;
	
	CH4_X_Offset_1 = 0;
	CH4_X_Offset_2 = 0;
	CH4_X_Offset_3 = 0;
	CH4_X_Offset_4 = 0;
	
	Channel1_Zero_Sign_Offset_1 = 100;
	Channel1_Zero_Sign_Offset_2 = 130;
	Channel1_Zero_Sign_Offset_3 = 100;
	Channel2_Zero_Sign_Offset_1 = 100;
	Channel2_Zero_Sign_Offset_2 = 130;
	Channel2_Zero_Sign_Offset_3 = 100;
	Channel3_Zero_Sign_Offset_1 = 100;
	Channel3_Zero_Sign_Offset_2 = 130;
	Channel3_Zero_Sign_Offset_3 = 100;
	Channel4_Zero_Sign_Offset_1 = 100;
	Channel4_Zero_Sign_Offset_2 = 130;
	Channel4_Zero_Sign_Offset_3 = 100;
	
	VSync_Needed = 0;
	DrawSignals_Needed = 0;
	
	ClearPlane  = 0x00;
	DrawPlane   = 0x00;
	RemovePlane = 0x00;
	ClearPhase  = true;
	
	Rotary_Direction           = 0;
	Rotary_Direction_mem       = 0;
	Rotary_Direction_mem_pulse = 1;
	Rotary_Switch              = 0;
	Rotary_Steps               = 1;
	Rotary_Changed             = 0;
	
	Keyboard_mem     = 0;
	Keyboard_Changed = 0;
	
	ADC_Data_Available = 0;

	SwitchesCH1 = 0x00D5;
	SwitchesCH2 = 0x00D5;
	SwitchesCH3 = 0x00D5;
	SwitchesCH4 = 0x00D5;	
	SwitchesTB  = 0x0000;		
	SwitchesCH1Old = 0x0000;
	SwitchesCH2Old = 0x0000;
	SwitchesCH3Old = 0x0000;
	SwitchesCH4Old = 0x0000;		
	SwitchesTBOld  = 0x0001;
	
	SIGNAL_StartFr_idx = 0;
	SIGNAL_OFFSET 	   = 0;
	SIGNALFaktor_idx   = 0;	
	
	FirEnabledCH1 = 0;
	FirEnabledCH2 = 0;
	FirEnabledCH3 = 0;
	FirEnabledCH4 = 0;
	
	FirStartCH = 5;
	FirStartCH_delayed = 5;
	
	SmoothEnabledCH1 = 0;
	SmoothEnabledCH2 = 0;
	SmoothEnabledCH3 = 0;
	SmoothEnabledCH4 = 0;
	
	USB_Data_Trans  = false;
	USB_SendAllData = false;
	USB_OnlyTrigger = false;
	
	Continius = true;
	
	SingleMode     = false;
	Single_Restart = false;
	
	ButtonChanged = false;
	RoteryChanged = false;
	
	DoDraw = false;
	
	PopUpPosition    = 0;
	IsPopuped        = false;
	PopupTimeCounter = 0;
	
	TriggerLevelChanged = 1;								// Was Triggerlevel changed
	TriggerModeChanged  = 1;								// Was Triggermode changed
	TriggerWayChanged   = 1;								// Was Triggerway changed
	TimebaseChanged     = 1;								// Was Timebase changed
	TimeOffsetChanged   = 1;								// Was Time_Offset changed
	SIGNALFaktorChanged = 1;								// Was SIGNALFaktor changed
	
	TriggerLevelActive = 0;								    	// Is Triggerlevel selected ?
	TimeOffsetActive   = 0;									// Is Time_Offset selected ?
	
	StatusbarChanged  = 0;									// When 1 then is changed
	ZeroPopupChanged  = 0;									// When 1 then is changed
	MenuPopupChanged  = 0;									// When 1 then is changed
	MenuPopupActive   = -1;									// Stores the actual Menupopup
	VoltageChangedCh1 = 1;									// Was Voltage changed
	VoltageChangedCh2 = 1;									// Was Voltage changed
	VoltageChangedCh3 = 1;									// Was Voltage changed
	VoltageChangedCh4 = 1;									// Was Voltage changed
	MenuPopupChanged2 = 0;									// Was MenuPopup changed
	MenuOnlyChanged  = 0;									// When 1 then is changed
	
	MenuItemChanged[0] = 0;
	MenuItemChanged[1] = 0;
	MenuItemChanged[2] = 0;
	MenuItemChanged[3] = 0;
	MenuItemChanged[4] = 0;
	MenuItemChanged[5] = 0;
	
	MenuItemPushed[0] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[1] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[2] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[3] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[4] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[5] = 0;				                    // When Menuitem is pushed drawed
	
	MenuStatusChanged = 0;									// When switching on/off a menu holds menunr
	
	VS_ZeroChangedCh1 = 1;									// Was Zero changed
	VS_ZeroChangedCh2 = 1;									// Was Zero changed
	VS_ZeroChangedCh3 = 1;									// Was Zero changed
	VS_ZeroChangedCh4 = 1;									// Was Zero changed
	VS_TrigLevelChanged = 1;								// Was Triggerlevel changed
	
	MenuPopupX = 0;
	MenuPopupY = 0;
	MenuPopupSizeX = 0;
	MenuPopupSizeY = 0;
	
	MenuStored      = 0;
	MenuActive      = 18;		//Startmenu
	MenuActiveOld   = 0;
	MenuChanged     = true;
	MenuTimeCounter = 0;										// Counter for Menu Pulldown
	
	MenuItemCount    = 0;											// Store the count of the Menuitems
	MenuOldItemCount = 0;										// Store the count of the old Menuitems
	
	New_Menu     = -1;
	Active_Menu  = -1;
	Menu_Changed = -1;
	
/*	BF not used
	Btns_Status[0] = 0;
	Btns_Status[1] = 0;
	Btns_Status[2] = 0;
	Btns_Status[3] = 0;
	Btns_Status[4] = 0;
	Btns_Status[5] = 0;
*/	
	wheelchanged = 0;
	Rot_Summary  = 0;
	
	Memory_Position = 0;

	//clear buffers
	for (cnt = 0; cnt < 32; cnt++)
	  LogicData[cnt] = 0;
	
	for (cnt = 0; cnt < 301; cnt++)
	  SIGNAL_IntBuf[cnt] = 0;
	
	for (cnt = 0; cnt < 256; cnt++)
	{
		SIGNAL1_Histo[cnt] = 0;
		SIGNAL2_Histo[cnt] = 0;
		SIGNAL3_Histo[cnt] = 0;
		SIGNAL4_Histo[cnt] = 0;
	}
	// kann wahrscheinlich auf 600 reduziert werden
	for (cnt = 0; cnt < 16386; cnt++) {
		SIGNAL1[cnt] = 0;
		SIGNAL2[cnt] = 0;
		SIGNAL3[cnt] = 0;
		SIGNAL4[cnt] = 0;
	}	
}

void Hardware::Setup_Hardware(void)					// Setup the Hardware
{
	dma->np_piointerruptmask = 0x00;							// disable all IRQs
	dma->np_piodirection = 0x01;								// set all bits to output
	dma->np_piodata = 0x00;									// Set to 0

	serstartled->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartled->np_piodirection = 0x01;							// set all bits to output
	serstartled->np_piodata = 0x00;								// Set to 0

	serstartsw->np_piointerruptmask = 0x00;							// disable all IRQs
	serstartsw->np_piodirection = 0x01;							// set all bits to output
	serstartsw->np_piodata = 0x00;								// Set to 0

	serstartdac->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartdac->np_piodirection = 0x01;							// set all bits to output
	serstartdac->np_piodata = 0x00;								// Set to 0

	serdata->np_piointerruptmask = 0x00;							// disable all IRQs
	serdata->np_piodirection = 0xFF;							// set all bits to output
	serdata->np_piodata = 0x00;								// Set to 0

	key_reset->np_piointerruptmask = 0x00;							// disable all IRQs
	key_reset->np_piodirection = 0x01;							// set all bits to output
	key_reset->np_piodata = 0x01;								// Set to 1

	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piodata = 0x00;								// Set to 0

	key->np_piointerruptmask = 0x00;							// disable all IRQs
	key->np_piodirection = 0x00;								// set all bits to input
	key->np_piodata = 0x00;									// Set to 0

	rot_speed_read->np_piointerruptmask = 0x00;						// disable all IRQs
	rot_speed_read->np_piodirection = 0x01;							// set all bits to output
	rot_speed_read->np_piodata = 0x00;							// Set to 0

	data_adr->np_piointerruptmask = 0x00;							// disable all IRQs
	data_adr->np_piodirection = 0x01;							// set all bits to output
	data_adr->np_piodata = 0x00;								// Set to 0
	
	mode->np_piointerruptmask = 0x00;							// disable all IRQs
	mode->np_piodirection = 0x01;								// set all bits to output
	mode->np_piodata = 0x00;								// Set to 0
	
	start_acq->np_piointerruptmask = 0x00;							// disable all IRQs
	start_acq->np_piodirection = 0x01;							// set all bits to output
	start_acq->np_piodata = 0x00;								// Set to 0

	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	acq_ready->np_piodirection = 0x00;							// set all bits to input
	acq_ready->np_piodata = 0x00;								// Set to 0

	reset_watchdog->np_piointerruptmask = 0x00;						// disable all IRQs
	reset_watchdog->np_piodirection = 0x01;							// set all bits to output
	reset_watchdog->np_piodata = 0x00;							// Set to 0

	la_data->np_piointerruptmask = 0x00;							// disable all IRQs
	la_data->np_piodirection = 0x00;							// set all bits to input
	la_data->np_piodata = 0x00;								// Set to 0

	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
	la_interrupt->np_piodirection = 0x00;							// set all bits to input
	la_interrupt->np_piodata = 0x00;							// Set to 0

	la_gate->np_piointerruptmask = 0x00;							// disable all IRQs
	la_gate->np_piodirection = 0x01;							// set all bits to output
	la_gate->np_piodata = 0x00;									// Set to 0

	la_pulse->np_piointerruptmask = 0x00;							// disable all IRQs
	la_pulse->np_piodirection = 0x01;							// set all bits to output
	la_pulse->np_piodata = 0x00;								// Set to 0

	//out_test->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	//out_test->np_piodirection = 0x01;								// set all bits to output
	//out_test->np_piodata = 0x08;

	boot_reset_key->np_piointerruptmask = 0x00;						// disable all IRQs
	boot_reset_key->np_piodirection = 0x00;							// set all bits to input
	boot_reset_key->np_piodata = 0x00;							// Set to 0

	power_on_boot_key->np_piointerruptmask = 0x00;						// disable all IRQs
	power_on_boot_key->np_piodirection = 0x00;						// set all bits to input
	power_on_boot_key->np_piodata = 0x00;							// Set to 0
	
	//key_test->np_piointerruptmask = 0x00;							// disable all IRQs
	//key_test->np_piodirection = 0x00;							// set all bits to input
	//key_test->np_piodata = 0x00;			

    if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("No Keyboard selected\n");
        keyboard_found = 1;
    } 
	else if ((boot_reset_key->np_piodata == 0x01) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("Power on Boot Pressed\n");
        keyboard_found = 2;
    } 
	else if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x01)) {
        printf("Reset on Boot Pressed\n");
        keyboard_found = 3;
    } else {
        printf("Keyboard found\n");
        keyboard_found = 4;
    }

	triggering = 0;
}

void Hardware::Setup_Interrupts(void)					// Setup the Interrupts
{
	if (keyboard_found == 4)
	{
		DoEnableKeyInterrupt();
		DoEnableRotInterrupt();
	}
	
	DoEnableUARTInterrupt();
	DoEnableUART2Interrupt();
	DoEnableTimerInterrupt();
	DoEnableADCInterrupt();	
	DoEnableReadVSyncInterrupt();
	//    DoEnableLogicAnalyserInterrupt();
	DoEnableTimer3Interrupt();	
}

void Hardware::Set_Vars_Default(void)					//Resets all vars to standard values
{
	int cnt;
	
	// Main/Delayed - Timebase
	MenuStatus[10][0] = 1;                                          // Main
	MenuStatus[10][1] = 0;                                          // Delayed
	MenuStatus[10][2] = 0;                                          // XY-Mode (Roll)
	//    MenuStatus[10][3] = 0;                                          // XY-Mode
	//    MenuStatus[10][4] = 33;                                         // TimeRef Center
	MenuStatus[5][2] = 136;                                         // Display - Grid - 100%
	Display_Mode = 0;                                               // Normal Mode - No XY-Mode
	
	MenuStatus[23][1] = 240;                                        // Autoscale - Search Slow TBs
	
	Selected_Timebase  = 4;                                         // 50 ns
	SIGNALFaktor_idx   = 0;                                         // non zoom
	SIGNAL_StartFr_idx = 0;                                         // running. so 0
	SIGNAL_OFFSET      = 0;                                         // signal offset
	
	Timebase_Offset_Pos = -300;//-298;                              // Timebase Offset
	Memory_Position     = 0;                               		// Memory Position

//BF ins	
	//Trig_Pos_Mem           = 300; 
	Trig_Pos_Display       = 300;      
	Trig_Pos_Display_dmode = 300;             
	Trig_Pos_Zoom          = 1.0;                     
	//Trig_Mem_Pos           = -300;       

	Trig_Pos_Mem_old           = 300;           	
	Trig_Pos_Display_old       = 300;    
	Trig_Pos_Display_dmode_old = 300;   	
	Trig_Pos_Zoom_old          = 1.0;    
	Trig_Mem_Pos_old           = -300;     

// BF end
	
	Trig_Pos_Mem = 300;
	Trig_Mem_Pos = 0;   	
	dmode_Window_Offset_Pos = 0;
		
	SwitchesTB = 0;                                                 // timebase switches
	timebase_reg = 0xFFFFFFFF;                                      // fastest timebase
	Display_Timebase = 4;                                           // Displayed timebase is 50 ns
	
	dmode_Selected_Timebase = 3;                                    // delayed timebase is 20 ns
	dmode_SIGNALFaktor_idx = 0;                                     // non zoom for delayed windows
	dmode_factor = 0;                                               // factor for delayed windows cursor calculation
	dmode_SIGNAL_StartFr_idx = 0;                                   // running. so 0
	dmode_SIGNAL_OFFSET = 0;                                        // signal offset
	
	Cursor_Delayed_1    = 180;                                      // Delayed windows cursor position 1
	Cursor_Delayed_2    = 420;                                      // Delayed windows cursor position 2
	Cursor_Delayed_Size = 240;                                      // Delayed windows size
	
	ROLLMODE_TB 	= 3;                                        	// Roll-Mode timebase is 500 ms
	ROLLMODE_OFFSET = GRID_WIDTH;                                   // start from the right side
	
	// Nicht sicher ob diese ben�tigt werden
	ROLLMODE_STARTED   = false;                                     // Is Roll- Mode started
	ROLLMODE_Value_rec = false;                                     // was a Roll value sampled
	
	// Trigger
	// Trigger Mode
	MenuStatus[12][0] = 93;                                         // Triggering - Auto
	MenuStatus[12][1] = 95;                                         // Triggering - Coupling DC
	MenuStatus[12][2] = 97;                                         // Triggering - LF Reject
	MenuStatus[12][4] = 104;                                        // Triggering - External Probe 1:1
	
	MenuPopupStatus[9][0] = 3;
	MenuPopupStatus[9][1] = 2;
		
	EdgeToggle = 1;                                                 // Holdoff deaktive
	
	// Trigger Edge
	MenuStatus[14][0] = 2;                                          // Triggering - positive edge
	MenuStatus[14][1] = 138;                                        // Triggering - Source = channel 1
	MenuStatus[14][2] = 0;                                          // Triggering - no externel triggering
	MenuStatus[14][3] = 0;                                          // Triggering - no externel TV triggering
	MenuPopupStatus[28][0] = 3;
	MenuPopupStatus[28][1] = 2;
	
	
	// Trigger Pulse
	MenuStatus[15][0] = 138;                                        // Triggering - Source Channel 1
	//MenuStatus[15][1] = 2;                                          // Triggering - Negative Pulse
	MenuStatus[15][2] = 3;                                          // Triggering - bigger - smaller - then
	
	// Quick Print
	//    MenuStatus[17][0] = 241;                                        // quick Print - USB
	//    MenuStatus[17][1] = 240;                                        // quick Print - RS-232
	
	Selected_Trigger_Source = 1;                                    // Selected Trigger Source is Channel 1
	SelectedEdgeExtern = 0;                                         // Trigger Edge by extern triggering
			
	//BF
	Virtual_ZeroLevelCH1 = -1 * GRID_HEIGHT / 4;		//-120;
	Virtual_ZeroLevelCH2 = GRID_HEIGHT / 4;			//-50;
	Virtual_ZeroLevelCH3 = (GRID_HEIGHT / 8) * 5;		//50;	
	Virtual_ZeroLevelCH4 = (GRID_HEIGHT / 8) * 3;		//120;
	
	ZeroLevelCH1 = GRID_HEIGHT / 4;
	ZeroLevelCH2 = (GRID_HEIGHT / 4) * 3;
	ZeroLevelCH3 = (GRID_HEIGHT / 8) * 5;	
	ZeroLevelCH4 = (GRID_HEIGHT / 8) * 3;

	if (NumberOfChannels < 4)
	{
		Trigger_Pos_CH1 = GRID_HEIGHT / 4;			// Trigger Level Channel 1
		Trigger_Pos_CH2 = (GRID_HEIGHT / 4) * 3;		// Trigger Level Channel 2
	}
	else
	{
		Trigger_Pos_CH1 = GRID_HEIGHT / 4;		//42;   // Trigger Level Channel 1			BF???
		Trigger_Pos_CH2 = (GRID_HEIGHT / 4) * 3;	//140;	// Trigger Level Channel 2			BF???
		Trigger_Pos_CH3 = (GRID_HEIGHT / 8) * 5;	//238;	// Trigger Level Channel 3			BF???
		Trigger_Pos_CH4 = (GRID_HEIGHT / 8) * 3;	//336;	// Trigger Level Channel 4			BF???
	}
	Trigger_Pos_CHE = 15;
	
	//trg_val_reg = 0xB1;                                             // Trigger Value
	//trg_hyst_reg = 0xA9;                                            // Trigger Hysterese
	trg_val_CHI_reg   = 0x00A0;
	trg_val_CHII_reg  = 0x00A0;
	trg_val_CHIII_reg = 0x00A0;
	trg_val_CHIV_reg  = 0x00A0;
	
	ext_trg_val_reg  = 0x80;                                         // Trigger Extern Value
	
	trig_range_reg   = 0;                                             // Trigger Range
	trig_holdoff_reg = 0;                                             // Trigger Holdoff
	trig_width_reg   = 0;                                             // Trigger Width
	ctrl_reg         = 0x0007;                                        // Control register
	//adc_ctrl_reg = 0x01C0;                                          // ADC Control register
	adc_ctrl_reg     = 0x81C0;                                          // ADC Control register - Auto Slope detect off
	
	pre_reg          = 0x6C;                                                 // PreTrigger Value
	//    channel_Adr_add = 0;                                            // Channel Add Value
	//    adc_change12_reg &= 0x0000FF00;                                   // ADC Change  - let ADC Shift Bits set
	//    adc_change34_reg &= 0x0000FF00;                                   // ADC Change  - let ADC Shift Bits set
	
	//    adc_ctr12_reg &= 0x000000FF;
	//    adc_ctr34_reg &= 0x000000FF;
	
	triggering = 1;                                                 // Triggering - Free Run
	TriggerWay = 1;                                                 // Edge
	Continius  = 1;                                                 // Continius Running
	
	Trigger_Offset_Pos = 353;//(pre_reg << 2);
	
	HoldOff_Value = 0;
	HoldOff_Expo  = 1;   //ns
	HoldOff_Steps = 40;
	
	Pulse11_Value = 16;
	Pulse11_Expo  = 1;   //ns
	Pulse11_Steps = 8;
	
	Pulse12_Value = 8;
	Pulse12_Expo  = 1;   //ns
	Pulse12_Steps = 8;
	
	Pulse21_Value = 16;
	Pulse21_Expo  = 1;   //ns
	Pulse21_Steps = 8;
	
	Pulse22_Value = 16;
	Pulse22_Expo  = 1;   //ns
	Pulse22_Steps = 8;
	
	Math_Off_Mul_Value     = 1;
	Math_Off_Mul_Value_int = 1;
	Math_Off_Mul_Expo      = 0;   //�V
	Math_Off_Mul_Steps     = 1;
	
	Math_Off_Sub_Value     = 1;
	Math_Off_Sub_Value_int = 1;
	Math_Off_Sub_Expo      = 0;   //mV
	Math_Off_Sub_Steps     = 1;
	
	Math_Off_Add_Value     = 1;
	Math_Off_Add_Value_int = 1;
	Math_Off_Add_Expo      = 0;   //mV
	Math_Off_Add_Steps     = 1;
	Math_Offset_mul.Init(0.000001, 0.000001, 1000, 0.000001, 2, 3, "", "", "V");
	Math_Offset_mul.RenderText();
	Math_Offset_add.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_add.RenderText();
	Math_Offset_sub.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_sub.RenderText();
	// Channel 1
	Channel_1_Active = 1;                                           // Channel 1 active
	Channel_1_Active_Old = 0;                                       // Channel 1 old must be 0
	MenuStatus[1][0] = 8;                                           // Channel 1 - Coupling AC
	MenuStatus[1][1] = 240;                                         // Channel 1 - BW Linit off
	MenuStatus[1][2] = 240;                                         // Channel 1 - Invert off
	MenuStatus[1][3] = 104;                                         // Channel 1 - Probe 1.0 : 1
	
	MenuPopupStatus[13][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[13][1] = 2;
	MenuPopupStatus[13][2] = 3;
	
	SwitchesCH1 = 0x0F1A;                                           // Switches for Channel 1 and for the other the AC bit
	Selected_Voltage_CH1 = 11;                                      // Voltage 5V

//    Channel1_Zero_Sign_Offset_1 = 100;                              // Search Zeors offset
//    Channel1_Zero_Sign_Offset_2 = 130;                              // Search Zeors offset
//    Channel1_Zero_Sign_Offset_3 = 100;                              // Search Zeors offset

	CH1_DAC_1 = 0;                                                  // channel 1 dac 1 offset
	CH1_DAC_2 = 0;                                                  // channel 1 dac 2 offset
	CH1_DAC_3 = 0;                                                  // channel 1 dac 3 offset
	CH1_DAC_4 = 0;                                                  // channel 1 dac 4 offset
	
	signal_zoomed1 = false;                                         // signal not zoomed
	
	if (NumberOfChannels == 2) {
		//CH1_DAC_Offset = 8192;                                    // Channel DAC was set while executing config functions
		//ZeroLevelCH1 = 0;                                         // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH1 = -1 * GRID_HEIGHT / 4;		// Virtual ZeroLevel
		CH1_Zero_Offset = 0;                                        // Shift offset when stopped
	} else {
		//CH1_DAC_Offset = 8192;                                    // Channel DAC was set while executing config functions
		//ZeroLevelCH1 = 0;                                         // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH1 = -120;                                // Virtual ZeroLevel
		CH1_Zero_Offset = 0;                                        // Shift offset when stopped
	}
	
	// Channel2
	Channel_2_Active = 1;                                           // Channel 2 active
	Channel_2_Active_Old = 0;                                       // Channel 2 old must be 0
	MenuStatus[2][0] = 8;                                           // Channel 2 - Coupling AC
	MenuStatus[2][1] = 240;                                         // Channel 2 - BW Linit off
	MenuStatus[2][2] = 240;                                         // Channel 2 - Invert off
	MenuStatus[2][3] = 104;                                         // Channel 2 - Probe 1.0 : 1
	
	MenuPopupStatus[14][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[14][1] = 2;
	MenuPopupStatus[14][2] = 3;
	
	SwitchesCH2 = 0x001A;                                           // Switches for Channel 2
	Selected_Voltage_CH2 = 11;                                      // Voltage 5V

//    Channel2_Zero_Sign_Offset_1 = 100;                              // Search Zeors offset
//    Channel2_Zero_Sign_Offset_2 = 130;                              // Search Zeors offset
//    Channel2_Zero_Sign_Offset_3 = 100;                              // Search Zeors offset

	CH2_DAC_1 = 0;                                                  // channel 2 dac 1 offset
	CH2_DAC_2 = 0;                                                  // channel 2 dac 2 offset
	CH2_DAC_3 = 0;                                                  // channel 2 dac 3 offset
	CH2_DAC_4 = 0;                                                  // channel 2 dac 4 offset
	
	signal_zoomed2 = false;                                         // signal not zoomed
	
	if (NumberOfChannels == 2)
	{
		//CH2_DAC_Offset = 8192;                                    // Channel DAC was set while executing config functions
		//ZeroLevelCH2 = 0;                                         // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH2 = GRID_HEIGHT / 4;                                  // Virtual ZeroLevel
		CH2_Zero_Offset = 0;                                        // Shift offset when stopped
	}
	else
	{
		//CH2_DAC_Offset = 8192;                                    // Channel DAC was set while executing config functions
		//ZeroLevelCH2 = 0;                                         // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH2 = -24;                                // Virtual ZeroLevel
		CH2_Zero_Offset = 0;                                        // Shift offset when stopped
	}
	
	if (NumberOfChannels == 4)
	{
		// Channel 3
		Channel_3_Active = 1;                                           // Channel 3 active
		Channel_3_Active_Old = 0;                                       // Channel 3 old must be 0
		MenuStatus[3][0] = 8;                                           // Channel 3 - Coupling AC
		MenuStatus[3][1] = 240;                                         // Channel 3 - BW Linit off
		MenuStatus[3][2] = 240;                                         // Channel 3 - Invert off
		MenuStatus[3][3] = 104;                                         // Channel 3 - Probe 1.0 : 1
	
		MenuPopupStatus[15][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 2;
		MenuPopupStatus[15][2] = 3;
	
		SwitchesCH3 = 0x001A;                                           // Switches for Channel 3
		Selected_Voltage_CH3 = 11;                                      // Voltage 5V
	
	//        Channel3_Zero_Sign_Offset_1 = 100;                              // Search Zeors offset
	//        Channel3_Zero_Sign_Offset_2 = 130;                              // Search Zeors offset
	//        Channel3_Zero_Sign_Offset_3 = 100;                              // Search Zeors offset
	
		CH3_DAC_1 = 0;                                                  // channel 3 dac 1 offset
		CH3_DAC_2 = 0;                                                  // channel 3 dac 2 offset
		CH3_DAC_3 = 0;                                                  // channel 3 dac 3 offset
		CH3_DAC_4 = 0;                                                  // channel 3 dac 4 offset
	
		signal_zoomed3 = false;                                         // signal not zoomed
	
		//CH3_DAC_Offset = 8192;                                        // Channel DAC was set while executing config functions
		//ZeroLevelCH3 = 0;                                             // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH3 = 72;                                      // Virtual ZeroLevel
		CH3_Zero_Offset = 0;                                            // Shift offset when stopped
	
		// Channel 4
		Channel_4_Active = 1;                                           // Channel 4 active
		Channel_4_Active_Old = 0;                                       // Channel 4 old must be 0
		MenuStatus[4][0] = 8;                                           // Channel 4 - Coupling AC
		MenuStatus[4][1] = 240;                                         // Channel 4 - BW Linit off
		MenuStatus[4][2] = 240;                                         // Channel 4 - Invert off
		MenuStatus[4][3] = 104;                                         // Channel 4 - Probe 1.0 : 1
	
		MenuPopupStatus[16][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 2;
		MenuPopupStatus[16][2] = 3;
	
		SwitchesCH4 = 0x001A;                                           // Switches for Channel 4
		Selected_Voltage_CH4 = 11;                                      // Voltage 5V
	
	//        Channel4_Zero_Sign_Offset_1 = 100;                              // Search Zeors offset
	//        Channel4_Zero_Sign_Offset_2 = 130;                              // Search Zeors offset
	//        Channel4_Zero_Sign_Offset_3 = 100;                              // Search Zeors offset
	
		CH4_DAC_1 = 0;                                                  // channel 4 dac 1 offset
		CH4_DAC_2 = 0;                                                  // channel 4 dac 2 offset
		CH4_DAC_3 = 0;                                                  // channel 4 dac 3 offset
		CH4_DAC_4 = 0;                                                  // channel 4 dac 4 offset
	
		signal_zoomed4 = false;                                         // signal not zoomed
	
		//CH4_DAC_Offset = 8192;                                        // Channel DAC was set while executing config functions
		//ZeroLevelCH4 = 0;                                             // ZeroLevel was set while executing config functions
		Virtual_ZeroLevelCH4 = 168;                                     // Virtual ZeroLevel
		CH4_Zero_Offset = 0;                                            // Shift offset when stopped
	}
	
	Channel_Math_Active = 0;                                        // Math channel off
	MenuStatus[26][1] = 0;                                          // standart math fft off
	MenuStatus[26][2] = 0;                                          // standart math 1*2 off
	MenuStatus[26][3] = 1;                                          // standart math 1-2 on
	MenuStatus[26][4] = 0;                                          // standart math 1+2 off
	
	math_mul_scale = 177;//166;
	math_sub_scale = 161;//153;
	math_add_scale = 161;//153;
	
	// deactivate Trigger TV
	//MenuStatus[14][3] = 246;                                          // Trigger TV deactive
	
	// deactive LF Reject and Holdoff
	//MenuStatus[12][2] = 246;                                          // Reject deactive
	//MenuStatus[12][3] = 246;                                          // Holdoff deactive
	
	MenuPopupStatus[8][0] = 3;
	MenuPopupStatus[8][1] = 2;
	MenuPopupStatus[8][2] = 2;

//    Recalc_Trigger();

	if (Selected_Timebase > 7)
	 { adc_change12_reg |= 0x01000000; }
	else
	 { adc_change12_reg &= 0xFEFFFFFF; }

	adc_change12_reg |= 0x02000000; 				//filter
	
	//Recalc_Vars();						//BF del 
	
	// Cursors
	MenuStatus[16][0] = 27;                                         // Cursor soruce = channel 1
	
	Cursor_Enabled = false;
	Cursor_Both_Selected = 0;	
	SelectedCursor = 0;
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	
	Cursor_Vertical_Active = 0;
	Cursor_Vertical_Position_Real1 = 103;
	Cursor_Vertical_Position_Real2 = 203;	
	Cursor_Vertical_Position_Real_XY_1 = 103;
	Cursor_Vertical_Position_Real_XY_2 = 203;	
		

    	// Quick Measure
	QM_Enabled = false;
	
	QM_Type[0] = 5;
	QM_Type[1] = 8;
	QM_Type[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 0;
	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Vertical_Active = 0;
	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	Quick_Measure_Threshold_btn_select = 1;
	
	// Display settings
	GridColorArrayPos = 1;                                          // Normal Grid 33 %
	GridColor_Val = GridColorArray[GridColorArrayPos];              // GridColor White
	GridColorArrayPos_Delayed = 1;                                  // Delayed Grid 33 %
	GridColor_Val_Delayed = 0x15;                                   // GridColore Gray

 	MenuStatus[5][0] = 240;                                         // Display - Persist off
	MenuStatus[5][2] = GridColorArrayPos + 133;                     // Display - Grid 33%
	MenuStatus[5][3] = 241;                                         // Display - Vectors on
	MenuStatus[5][4] = 240;                                         // Display - Browse off
	
	// Aquire
	MenuStatus[0][0] = 1;                                           // Aquire - Normal on
	MenuStatus[0][1] = 0;                                           // Aquire - Averaging

	// LED�s
	LED_ON[0] = 1;			                                        // Select Channel 1
	LED_ON[1] = 1;			                                        // Select Channel 2
	LED_ON[2] = 1;			                                        // Select Channel 3
	LED_ON[3] = 1;			                                        // Select Channel 4
	LED_ON[4] = 0;			                                        // Select Channel Math
	LED_ON[5] = 1;			                                        // General
	LED_ON[6] = 0;			                                        // Cursor
	LED_ON[7] = 0;			                                        // Quick Measure
	LED_ON[8] = 1;			                                        // Edge
	LED_ON[9] = 0;			                                        // Pattern - Not Used
	LED_ON[10] = 0;			                                        // Pulse Width
	LED_ON[11] = 0;			                                        // More - Not Used
	LED_ON[12] = 1;			                                        // Run/Stop Green
	LED_ON[13] = 0;			                                        // Run/Stop Red
	LED_ON[14] = 0;			                                        // Single Red
	LED_ON[15] = 0;			                                        // Single Green
	
	MenuItemChanged[0] = true;
	MenuItemChanged[1] = true;
	MenuItemChanged[2] = true;
	MenuItemChanged[3] = true;
	MenuItemChanged[4] = true;
	MenuItemChanged[5] = true;
	
	RemovePlane |= 0x1F;
	
	ClearPlanes();
	
	//    config_changed = true;
		
}


char Hardware::SearchZero(char channel, char level, int *DAC_Offset, int *ZeroSign)
{
	int lcnt = 0;
	int lcnt2 = 0;
	unsigned long buflong = 0, buflong1 = 0, buflong2 = 0;
	char is_running = 1;

#ifdef _Debug_FindZero_
    	printf("Start searching zero %d\n", channel);
    
    	printf("ZeroSign %8x %d\n", ZeroSign[0], ZeroSign[0]);
#endif
	
	lcnt = 0;
	DAC_Offset[0] = 0x2000;
	is_running = 1;
	
	SetDacOffset(channel);
	SetSwitches(channel, level);
	
	triggering = 0;								
	ctrl_reg = 0x0083;							        // Trigger_Master / Trigger_INT / Free Run  / Zero Line search bit
	if (NumberOfChannels == 2) adc_ctrl_reg = 0x00C0;				// Disable Trigger sources and remove the master bits
	else  adc_ctrl_reg = 0x0000;						        // Remove the master bits
	
	switch (channel)
	{
		case 1 : adc_ctrl_reg |= 0x0100; break;                     // Set channel 1 Master bit
		case 2 : adc_ctrl_reg |= 0x0200; break;                     // Set channel 2 Master bit
		case 3 : adc_ctrl_reg |= 0x0400; break;                     // Set channel 3 Master bit
		case 4 : adc_ctrl_reg |= 0x0800; break;                     // Set channel 4 Master bit
	}

	SetupADC();
	
	nr_delay(100);
	
	ctrl_reg = 0x0183;                                               // Add zero_line_adj
	
	SetupADC();



	buflong = 0x00000000;
	if (channel < 3)					// Channel 1 & 2
	{
		
	while (1 == 1)
	{
		data_adr->np_piodata = 0x01;
		
		buflong = READADC(1);
		
		if ((buflong & 0x00008000) == 0x00008000)
		{
		
			buflong1 = READADC(1) & 0x3FFF;
		
			ZeroSign[0] = (int) (buflong1 - 8192);		// Wert�bergabe an NIOS
		
	//          printf("buflong_ch1 %8x %d\n", buflong, buflong);
	//          printf("buflong1_ch1 %8x %d\n", buflong1, buflong1);
			printf("ZeroSign %d\n", ZeroSign[0]);	            
			break;
		}
		
		data_adr->np_piodata = 0x00;
		lcnt++;
		
		if (lcnt == 50000) break;
		}
	}
	else
	{
		lcnt = 0;
		while (1 == 1)		// Channel 3 & 4
		{
			data_adr->np_piodata = 0x01;

			buflong = READADC(3);

			lcnt2 = 0;

/*			while (key_test->np_piodata == 0)
			{
		
				lcnt2++;
				if (lcnt2 == 50000)
				{
				 break;
				}
			}*/

			lcnt2 = 0;
			
			buflong = READADC(1);			//neu eingebaut
			
			if ((buflong & 0x00008000) == 0x00008000)
			{
				
				buflong1 = READADC(1) & 0x3FFF;
				
				ZeroSign[0] = (int) (buflong1 - 8192);	// x-value to NIOS	
				
	//			printf("buflong_ch3 %8x %d\n", buflong, buflong);
	//			printf("buflong1_ch3 %8x %d\n", buflong1, buflong1);
				printf("ZeroSign %d\n", ZeroSign[0]);				
				data_adr->np_piodata = 0x00;

				
				break;
			}
			
			lcnt++;
			if (lcnt == 50000) break;
		}
	}
//	printf("lcnt %d\n", lcnt);
//	printf("lcnt2 %d\n", lcnt2);
	printf("Master %x\n", adc_ctrl_reg);
	lcnt = 0;
	lcnt2 = 0;
	data_adr->np_piodata = 0x00;


	buflong2 = READADC(channel);
	    
#ifdef _Debug_FindZero_
	printf("buflong %8x %d\n", buflong, buflong);
	printf("buflong1 %8x %d\n", buflong1, buflong1);
	printf("buflong2 %8x %d\n", buflong2, buflong2);
	printf("ZeroSign %8x %d\n", ZeroSign[0], ZeroSign[0]);
  //  printf("%i %i : dir : %i lcnt : %i  BB : %i  BT : %i CZSO : %i \n", channel, level, dir, lcnt, bottom_val, top_val, ZeroSign[0]);
#endif

	ctrl_reg = 0x0083;	// Trigger_Master / Trigger_INT / FreeRun bit  /
	SetupADC();
	
	return 0;
}

char Hardware::SearchZeros(void)
{
    char IsSearching = true;
    int searchcnt = 0;

    if ((Search_Mode == false) && (Search_Auto == false)) return 0;

    Stop_Record();
    AutoTimerOff = true;

    //reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
#ifdef _Debug_FindZero_
    printf("We start searching\n");
#endif
	printf("We start searching\n");
	
    DoDisableUARTInterrupt();
    DoDisableADCInterrupt();

//    if (Search_Auto == false)
//    {
        Display::DRAWROUNDBUTTON(230, 180, 180, 80, 0, 0);
        Display::TEXTOUTxvbig("Searching zero lines.", 247, 192, 1, UI_Plane2);
        Display::TEXTOUTxvbig("Remove all input lines.", 247, 212, 1, UI_Plane2);
        Display::TEXTOUTxvbig("Can take up to 1 min.", 247, 232, 1, UI_Plane2);
//    }

    // Backup old vars
    Channel_1_Active_bak = Channel_1_Active;
    Channel_2_Active_bak = Channel_2_Active;
    Channel_3_Active_bak = Channel_3_Active;
    Channel_4_Active_bak = Channel_4_Active;

    Selected_Timebase_bak = Selected_Timebase;
    SIGNALFaktor_idx_bak = SIGNALFaktor_idx;
    SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
    timebase_reg_bak = timebase_reg;
    Display_Timebase_bak = Display_Timebase;
    Continius_bak = Continius;
    SingleMode_bak = SingleMode;

    triggering_bak = triggering;
    ctrl_reg_bak = ctrl_reg;
    adc_ctrl_reg_bak = adc_ctrl_reg;

    // Data for undo
    CH1_DAC_Offset_bak = CH1_DAC_Offset;
    CH2_DAC_Offset_bak = CH2_DAC_Offset;
    CH3_DAC_Offset_bak = CH3_DAC_Offset;
    CH4_DAC_Offset_bak = CH4_DAC_Offset;
    
    CH1_DAC_Offset = 0x2000;
    CH2_DAC_Offset = 0x2000;
    CH3_DAC_Offset = 0x2000;
    CH4_DAC_Offset = 0x2000;
    
    /*

    Channel1_Zero_Sign_Offset_1_bak = Channel1_Zero_Sign_Offset_1;
    Channel1_Zero_Sign_Offset_2_bak = Channel1_Zero_Sign_Offset_2;
    Channel1_Zero_Sign_Offset_3_bak = Channel1_Zero_Sign_Offset_3;

    Channel2_Zero_Sign_Offset_1_bak = Channel2_Zero_Sign_Offset_1;
    Channel2_Zero_Sign_Offset_2_bak = Channel2_Zero_Sign_Offset_2;
    Channel2_Zero_Sign_Offset_3_bak = Channel2_Zero_Sign_Offset_3;

    Channel3_Zero_Sign_Offset_1_bak = Channel3_Zero_Sign_Offset_1;
    Channel3_Zero_Sign_Offset_2_bak = Channel3_Zero_Sign_Offset_2;
    Channel3_Zero_Sign_Offset_3_bak = Channel3_Zero_Sign_Offset_3;

    Channel4_Zero_Sign_Offset_1_bak = Channel4_Zero_Sign_Offset_1;
    Channel4_Zero_Sign_Offset_2_bak = Channel4_Zero_Sign_Offset_2;
    Channel4_Zero_Sign_Offset_3_bak = Channel4_Zero_Sign_Offset_3;
      */

    Channel_1_Active = true;
    Channel_2_Active = true;

    if (NumberOfChannels > 2)
    {
        Channel_3_Active = true;
        Channel_4_Active = true;
    }

    Continius = 0;
 //   SingleMode = 1;

    if (adc_started)
    {
        while (acq_ready->np_piodata == 0x01) {}
        adc_started = false;
    }

    Selected_Timebase = 4;                                          // 50 nS
    SIGNALFaktor_idx = 0;                                           // zoom factor 0
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = 0xFFFFFFFF;                                      // real timebase
    Display_Timebase = 4;                                           // Displayed timebase is 50ns
    
  /*
    Selected_Timebase = 8;                                          // 10 �S // 500 nS
    SIGNALFaktor_idx = 4;                                           // zoom factor 1 = 10 �S
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = 0xFFFFFFFB;                                      // real timebase
    Display_Timebase = 12;                                          // Displayed timebase is 10 �s
    */
    // start condition made -> start searching

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;

        IsSearching = SearchZero(1, 9, &CH1_DAC_Offset, &Channel1_Zero_Sign_Offset_1);
    }

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;
        IsSearching = SearchZero(1, 10, &CH1_DAC_Offset, &Channel1_Zero_Sign_Offset_2);
    }

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;
        IsSearching = SearchZero(1, 11, &CH1_DAC_Offset, &Channel1_Zero_Sign_Offset_3);
    }

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;
        IsSearching = SearchZero(2, 9, &CH2_DAC_Offset, &Channel2_Zero_Sign_Offset_1);
    }

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;
        IsSearching = SearchZero(2, 10, &CH2_DAC_Offset, &Channel2_Zero_Sign_Offset_2);
    }

    searchcnt = 0;
    IsSearching = true;
    while (IsSearching)
    {
        searchcnt++;
        if (searchcnt == 3) break;
        IsSearching = SearchZero(2, 11, &CH2_DAC_Offset, &Channel2_Zero_Sign_Offset_3);
    }

    if (NumberOfChannels > 2)
    {
        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(3, 9, &CH3_DAC_Offset, &Channel3_Zero_Sign_Offset_1);
        }

        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(3, 10, &CH3_DAC_Offset, &Channel3_Zero_Sign_Offset_2);
        }

        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(3, 11, &CH3_DAC_Offset, &Channel3_Zero_Sign_Offset_3);
        }
        
        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(4, 9, &CH4_DAC_Offset, &Channel4_Zero_Sign_Offset_1);
        }

        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(4, 10, &CH4_DAC_Offset, &Channel4_Zero_Sign_Offset_2);
        }

        searchcnt = 0;
        IsSearching = true;
        while (IsSearching)
        {
            searchcnt++;
            if (searchcnt == 3) break;
            IsSearching = SearchZero(4, 11, &CH4_DAC_Offset, &Channel4_Zero_Sign_Offset_3);
        }
    }
        

    Channel_1_Active = Channel_1_Active_bak;
    Channel_2_Active = Channel_2_Active_bak;
    Channel_3_Active = Channel_3_Active_bak;
    Channel_4_Active = Channel_4_Active_bak;

    Selected_Timebase = Selected_Timebase_bak;
    SIGNALFaktor_idx = SIGNALFaktor_idx_bak;
    SIGNAL_StartFr_idx = SIGNAL_StartFr_idx_bak;
    timebase_reg = timebase_reg_bak;
    Display_Timebase = Display_Timebase_bak;
    Continius = Continius_bak;
    SingleMode = SingleMode_bak;

    triggering = triggering_bak;
    ctrl_reg = ctrl_reg_bak;
    adc_ctrl_reg = adc_ctrl_reg_bak;
    
    CH1_DAC_Offset = CH1_DAC_Offset_bak;
    CH2_DAC_Offset = CH2_DAC_Offset_bak;
    CH3_DAC_Offset = CH3_DAC_Offset_bak;
    CH4_DAC_Offset = CH4_DAC_Offset_bak;


    Rotary_Steps = 0;
    ON_Zero_Channel_1();
    Rotary_Steps = 0;
    ON_Zero_Channel_2();


    SetSwitches(1, Selected_Voltage_CH1);
    SetSwitches(2, Selected_Voltage_CH2);

    if (NumberOfChannels > 2)
    {
        Rotary_Steps = 0;
        ON_Zero_Channel_3();
        Rotary_Steps = 0;
        ON_Zero_Channel_4();

        SetSwitches(3, Selected_Voltage_CH3);
        SetSwitches(4, Selected_Voltage_CH4);
    }
    
    SetDacOffset(1);
    SetDacOffset(2);
    
    if (NumberOfChannels > 2)
    {
        SetDacOffset(3);
        SetDacOffset(4);
    }

    SetupADC();

    SingleMode = 0;
    Continius = 1;

    Search_Mode = 0;
    Search_Auto = 0;

// BF ????????????????????? 
   /*
//    if (USB_Data_Trans == 1)
    {
        send_buffer[0] = (unsigned char) 13;
        send_buffer[1] = (unsigned char) (CH1_DAC_Offset & 0xFF);
        send_buffer[2] = (unsigned char) ((CH1_DAC_Offset & 0xFF00) >> 8);
        send_buffer[3] = (unsigned char) (Channel1_Zero_Sign_Offset_1 & 0xFF);
        send_buffer[4] = (unsigned char) ((Channel1_Zero_Sign_Offset_1 & 0xFF00) >> 8);
        send_buffer[5] = (unsigned char) (Channel1_Zero_Sign_Offset_2 & 0xFF);
        send_buffer[6] = (unsigned char) ((Channel1_Zero_Sign_Offset_2 & 0xFF00) >> 8);
        send_buffer[7] = (unsigned char) (Channel1_Zero_Sign_Offset_3 & 0xFF);
        send_buffer[8] = (unsigned char) ((Channel1_Zero_Sign_Offset_3 & 0xFF00) >> 8);
        send_buffer[9] = (unsigned char) (CH2_DAC_Offset & 0xFF);
        send_buffer[10] = (unsigned char) ((CH2_DAC_Offset & 0xFF00) >> 8);
        send_buffer[11] = (unsigned char) (Channel2_Zero_Sign_Offset_1 & 0xFF);
        send_buffer[12] = (unsigned char) ((Channel2_Zero_Sign_Offset_1 & 0xFF00) >> 8);
        send_buffer[13] = (unsigned char) (Channel2_Zero_Sign_Offset_2 & 0xFF);
        send_buffer[14] = (unsigned char) ((Channel2_Zero_Sign_Offset_2 & 0xFF00) >> 8);
        send_buffer[15] = (unsigned char) (Channel2_Zero_Sign_Offset_3 & 0xFF);
        send_buffer[16] = (unsigned char) ((Channel2_Zero_Sign_Offset_3 & 0xFF00) >> 8);
        send_buffer[17] = (unsigned char) (CH3_DAC_Offset & 0xFF);
        send_buffer[18] = (unsigned char) ((CH3_DAC_Offset & 0xFF00) >> 8);
        send_buffer[19] = (unsigned char) (Channel3_Zero_Sign_Offset_1 & 0xFF);
        send_buffer[20] = (unsigned char) ((Channel3_Zero_Sign_Offset_1 & 0xFF00) >> 8);
        send_buffer[21] = (unsigned char) (Channel3_Zero_Sign_Offset_2 & 0xFF);
        send_buffer[22] = (unsigned char) ((Channel3_Zero_Sign_Offset_2 & 0xFF00) >> 8);
        send_buffer[23] = (unsigned char) (Channel3_Zero_Sign_Offset_3 & 0xFF);
        send_buffer[24] = (unsigned char) ((Channel3_Zero_Sign_Offset_3 & 0xFF00) >> 8);
        send_buffer[25] = (unsigned char) (CH4_DAC_Offset & 0xFF);
        send_buffer[26] = (unsigned char) ((CH4_DAC_Offset & 0xFF00) >> 8);
        send_buffer[27] = (unsigned char) (Channel4_Zero_Sign_Offset_1 & 0xFF);
        send_buffer[28] = (unsigned char) ((Channel4_Zero_Sign_Offset_1 & 0xFF00) >> 8);
        send_buffer[29] = (unsigned char) (Channel4_Zero_Sign_Offset_2 & 0xFF);
        send_buffer[30] = (unsigned char) ((Channel4_Zero_Sign_Offset_2 & 0xFF00) >> 8);
        send_buffer[31] = (unsigned char) (Channel4_Zero_Sign_Offset_3 & 0xFF);
        send_buffer[32] = (unsigned char) ((Channel4_Zero_Sign_Offset_3 & 0xFF00) >> 8);
        send_buffer[33] = (unsigned char) NumberOfChannels;

        SendData(send_buffer);
    }
    */
#ifdef _Debug_FindZero_
    printf("DAC1 : %i DAC2 : %i DAC3 : %i DAC4 : %i\n", CH1_DAC_Offset, CH2_DAC_Offset, CH3_DAC_Offset, CH4_DAC_Offset);

    printf("CH1_1 :%3d CH1_2 :%3d CH1_3 :%3d CH2_1 :%3d CH2_2 :%3d CH2_3 :%3d \n", Channel1_Zero_Sign_Offset_1, Channel1_Zero_Sign_Offset_2, Channel1_Zero_Sign_Offset_3, Channel2_Zero_Sign_Offset_1, Channel2_Zero_Sign_Offset_2, Channel2_Zero_Sign_Offset_3);
    printf("CH3_1 :%3d CH3_2 :%3d CH3_3 :%3d CH4_1 :%3d CH4_2 :%3d CH4_3 :%3d \n", Channel3_Zero_Sign_Offset_1, Channel3_Zero_Sign_Offset_2, Channel3_Zero_Sign_Offset_3, Channel4_Zero_Sign_Offset_1, Channel4_Zero_Sign_Offset_2, Channel4_Zero_Sign_Offset_3);
#endif

 //   config_changed = true;
 //   AMDFlash::Write_Config_Flash();
   
    if (Search_Auto == false)
    {
        Display::DRAWROUNDBUTTON(230, 180, 180, 80, 0, 1);
        Display::TEXTOUTxvbig("Searching zero lines.", 247, 192, 0, UI_Plane2);
        Display::TEXTOUTxvbig("Remove all input lines.", 247, 212, 0, UI_Plane2);
        Display::TEXTOUTxvbig("Can take up to 1 min.", 247, 232, 0, UI_Plane2);
    }


    AutoTimerOff = false;

    DoEnableADCInterrupt();
    DoEnableUARTInterrupt();

    acq_ready->np_pioedgecapture = 0;
    Start_Record();

    //reset_watchdog->np_piodata = 0x01;						// Enable WatchDog

    return 0;
}
//#####################################################################################################################################


void Hardware::DoEnableKeyInterrupt(void)							// Enable Keyboard service routine
{
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piointerruptmask = 0x01;							// enable Keyboard IRQ

	key_reset->np_piodata = 0;								// Reset Keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;
	
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions	

	nr_installuserisr(na_key_interrupt_irq,ISR_KEY,(int)key_int);	// Install ISR for Keyboard
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nKEY interrupt enabled.\n"); 							// print on console
#endif
}
//#####################################################################################################################################


void Hardware::DoDisableKeyInterrupt(void)							// Disable Keyboard I/O service routine
{
	nr_installuserisr(na_key_interrupt_irq,0,0); 					// Install empty routine for Keyboard irq
	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
}
//#####################################################################################################################################


void Hardware::ISR_KEY(int context)									// Keyboard Interrupt subroutine
{
    int KeyData = key->np_piodata;									// Get interrupt Keyboad data

	//if (init_done) Reset_the_Watchdog();
	//if (adc_started)
	
	tc_test_var2++;

    /*
    if (MenuStatus[10][2] == 1)
    {
        DoDisableTimer2Interrupt();
        Continius = 0;
        //UserIface_active = 0;
        TriggerModeChanged = 1;
        Display::StatusUpdate();
    }
    */

    //Stop_Record();

    ADC_Data_Available_cnt = 2;

    //acq_ready->np_piointerruptmask = 0x00;								// disable adc irq
 	
	key_reset->np_piodata = 0;									// Reset Keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;
	key_int->np_pioedgecapture = 0;									// clear IRQ conditions	

    Keyboard_mem = KeyData;
    Keyboard_Changed = 1;
	//UserIface_active = 1;
	UserIface_active_2 = 1;

    if (SingleMode == 1)
    {
        SingleMode = 0;

        LED_ON[14] = 0;
        LED_ON[15] = 0;
    }
    /*
    LED_ON[12] = 0;
    LED_ON[13] = 1;
    Send_LED();  */

	printf("\nKEY interrupt occured.\n"); 							// print on console
}
//#####################################################################################################################################


void Hardware::Keyboard_Interface(void)
{
	int cnt;
	
	if (Keyboard_Changed == 0) return;
	Keyboard_Changed = 0;
	
	ButtonChanged = 1;												// Set Button Changed True	
	  /*
	if (MenuStatus[10][2] == 1)
	{
        ClearPlanes();
        ROLLMODE_OFFSET = 601;	
        ROLLMODE_POS = 0;
    }
    */
    	
#ifdef _Debug_						
    printf("MPA0 %d SEE %d MPS[8][0] %d MPS[8][1] %d MPS[8][2] %d\n", MenuPopupActive, SelectedEdgeExtern, MenuPopupStatus[8][0], MenuPopupStatus[8][1], MenuPopupStatus[8][2]);
#endif	    	
    	
	//if ((Keyboard_mem & 0x00000004) != 0x00) ResetTimer();
#ifdef _Debug_	
    if (Debug_Mode) printf("kd : %x \n", Keyboard_mem);									// print Keyboard Data to console
#endif
			
	if      ((Keyboard_mem & 0x00080000) == 0x00) {ResetTimer(); Buttonhandler(30, 0);}	// Function Button 1
	else if ((Keyboard_mem & 0x00040000) == 0x00) {ResetTimer(); Buttonhandler(31, 0);}	// Function Button 2
	else if ((Keyboard_mem & 0x00020000) == 0x00) {ResetTimer(); Buttonhandler(32, 0);}	// Function Button 3
	else if ((Keyboard_mem & 0x00010000) == 0x00) {ResetTimer(); Buttonhandler(33, 0);}	// Function Button 4
	else if ((Keyboard_mem & 0x00400000) == 0x00) {ResetTimer(); Buttonhandler(34, 0);}	// Function Button 5
	else if ((Keyboard_mem & 0x00100000) == 0x00) {ResetTimer(); Buttonhandler(35, 0);}	// Function Button 6
	
	else if ((Keyboard_mem & 0x00200000) == 0x00) Buttonhandler( 1, 0);	// Channel 1 Button
	else if ((Keyboard_mem & 0x00800000) == 0x00) Buttonhandler( 2, 0);	// Channel 2 Button
	else if ((Keyboard_mem & 0x01000000) == 0x00) Buttonhandler( 3, 0);	// Channel 3 Button !!!
	else if ((Keyboard_mem & 0x02000000) == 0x00) Buttonhandler( 4, 0);	// Channel 4 Button
	else if ((Keyboard_mem & 0x04000000) == 0x00) Buttonhandler(26, 0);	// Channel Math Button
	
	else if ((Keyboard_mem & 0x00008000) == 0x00) Buttonhandler(23, 0);	// Auto Scale
	else if ((Keyboard_mem & 0x00000100) == 0x00) Buttonhandler( 8, 0);	// Save/Recall
	else if ((Keyboard_mem & 0x00000800) == 0x00) Buttonhandler(17, 0);	// Quick Print
	else if ((Keyboard_mem & 0x00002000) == 0x00) Buttonhandler( 6, 0);	// Utility
	else if ((Keyboard_mem & 0x00000001) == 0x00) Buttonhandler(15, 0);	// Pulse Width
	
//	else if ((Keyboard_mem & 0x00000020) == 0x00) Buttonhandler(-1, 0);	// Not used
//	else if ((Keyboard_mem & 0x00000002) == 0x00) Buttonhandler(-1, 0);	// Not used
	else if ((Keyboard_mem & 0x00004000) == 0x00) Buttonhandler(16, 0);	// Cursor
	else if ((Keyboard_mem & 0x00000200) == 0x00) Buttonhandler(19, 0);	// Quick Messurement 	// Kurz geschlossen
	else if ((Keyboard_mem & 0x00000400) == 0x00) Buttonhandler( 0, 0);	// Acquire				//
	else if ((Keyboard_mem & 0x00001000) == 0x00) Buttonhandler( 5, 0);	// Display
	else if ((Keyboard_mem & 0x00000010) == 0x00) Buttonhandler(14, 0);	// Edge
	else if ((Keyboard_mem & 0x00000040) == 0x00) Buttonhandler(12, 0);	// Trigger Mode /Coupling
	
	else if ((Keyboard_mem & 0x00000080) == 0x00) Buttonhandler(10, 0);	// Mode Button (Main/Delayed)
	else if ((Keyboard_mem & 0x00000004) == 0x00) Buttonhandler(37, 0);	// Run / Stop Button
	else if ((Keyboard_mem & 0x00000008) == 0x00) Buttonhandler(38, 0);	// Single Button
	
	
	if (USB_Data_Trans == 1)
	{
		//reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
		
		for (cnt = 0; cnt < 32; cnt++)
		{
			send_buffer[0] = 7;
			send_buffer[1] = cnt;
			send_buffer[2] = 1;
			send_buffer[3] = MenuActive;			
			
			send_buffer[4] = (unsigned char) MenuStatus[cnt][0];
			send_buffer[5] = (unsigned char) MenuStatus[cnt][1];
			send_buffer[6] = (unsigned char) MenuStatus[cnt][2];
			send_buffer[7] = (unsigned char) MenuStatus[cnt][3];
			send_buffer[8] = (unsigned char) MenuStatus[cnt][4];
			send_buffer[9] = (unsigned char) MenuStatus[cnt][5];			
		
			SendData(send_buffer);
		}	
		
		//reset_watchdog->np_piodata = 0x01;						// Enable WatchDog
	}
}

//#####################################################################################################################################
//Main button handler
void Hardware::Buttonhandler(int MenuKey, char Pushedlong)			// Button Handler
{
	volatile int pm, xm,ym;
	volatile int res_xm;
	
	volatile long lpm, lxm,lym;
	volatile long lres_xm;
	
	short x, pos = 0;
	int ix, ix2, xa, Ct, result;
	unsigned long buffer_long;
	unsigned long *flash_address = 0;
	
	float buf_float;
	int buf_int;
	
	long timerVal;
	long timerPeriod;


#ifdef _Debug_        	
	if (Debug_Mode) printf("BH %i MA %i\n", MenuKey, MenuActive);
#endif
	//if (ButtonChanged == 0) return;									// If No Button Pressed return.
	//ButtonChanged = 0;

	if (Splash_drawed)
	{
		Display::REMOVE_SPLASH();
		Display::DrawStartScreen();
		Splash_drawed = false;
	
		Continius = true;
	
		TimebaseChanged     = 1;
		TimeOffsetChanged   = 1;
		TriggerLevelChanged = 1;
		TriggerModeChanged  = 1;
		TriggerWayChanged   = 1;
		VoltageChangedCh1   = 1;									// Was Voltage changed
		VoltageChangedCh2   = 1;									// Was Voltage changed
		VoltageChangedCh3   = 1;									// Was Voltage changed
		VoltageChangedCh4   = 1;									// Was Voltage changed          		
			
		Display::StatusUpdate();
		
		CursorChanged = 3;
		Cursor_Data_First_Draw = 1;
		Display::DRAWCURSORDATA(0);
	
		Quick_Measure_First_Draw = 1;
		Display::DRAWQMDATA(0); 	
	
		Display::DRAW_ALL_CURSOR();
		if (Continius) Start_Record();
	
		return;
	}
	if (StatusbarChanged) Display::RemoveStatusBtn();
//	if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
	
	MenuAktive = 1;
	
	switch(MenuKey)
	{			
		//--------------------------------------------
		// Acquire Button pressed	
		//--------------------------------------------
		case 0:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
						
			New_Menu = 0;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}	
		
		//--------------------------------------------
		// Channel 1 Button pressed
		//--------------------------------------------	
		case 1:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
										
			if (Active_Menu == 1)
			{
                		if ((Channel_2_Active == 0) && (Channel_3_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_1_Active == 0) UpdateChannel(1, 1);
				else UpdateChannel(1, 0);
				
				VoltageChangedCh1 = 1;
			}
			else
				UpdateChannel(1, 1);
			
			if (Channel_1_Active == 0)
			{
				if (MenuStatus[10][2] == 1)
				{
				MenuStatus[10][0] = 1;
				MenuStatus[10][2] = 246;
				Display_Mode = 0;
				}
				RemovePlane |= 0x01;
				ClearPlanes();
			}

            		if ((Channel_1_Active == 1) && (Channel_2_Active == 1)) MenuStatus[10][2] = 0;
			
			DrawSignals_Needed = true;
			UserIface_active = false;
			
			MenuStatusChanged = 1;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
	
			New_Menu = 1;
			Menu_Changed = 1;
			
			if (Channel_1_Active == 1)
			{
				Set_LED(5);
				MenuAktive = 1;
			}
			else
			{
				Reset_LED(5);
				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Channel 2 Button pressed	
		//--------------------------------------------
		case 2:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			MenuButtonCheck(-1);
					
			if (Active_Menu == 2)
			{
                		if ((Channel_1_Active == 0) && (Channel_3_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_2_Active == 0) UpdateChannel(2, 1);
				else UpdateChannel(2, 0);
				
				VoltageChangedCh2 = 1;
			}
			else UpdateChannel(2, 1);
			
			if (Channel_2_Active == 0)
            		{
				if (MenuStatus[10][2] == 1)
				{
					MenuStatus[10][0] = 1;
					MenuStatus[10][2] = 0;
					Display_Mode = 0;
				}

                		RemovePlane |= 0x02;
                		ClearPlanes();
            		}

            		if ((Channel_1_Active == 1) && (Channel_2_Active == 1)) MenuStatus[10][2] = 0;
			
			DrawSignals_Needed = true;
			UserIface_active = false;
			
			MenuStatusChanged = 2;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
							
			Display::StatusUpdate();				
			
            		New_Menu = 2;
			Menu_Changed = 1;
			
			if (Channel_2_Active == 1)
			{
				Set_LED(5);
				MenuAktive = 1;
			}
			else
			{
				Reset_LED(5);
				MenuAktive = 0;
			}
						
			break;	
		}
		
		//--------------------------------------------
		// Channel 3 Button pressed	
		//--------------------------------------------
		case 3:
		{
			if (NumberOfChannels == 2) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			MenuButtonCheck(-1);			
			
			if (Active_Menu == 3)
			{
                		if ((Channel_1_Active == 0) && (Channel_2_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_3_Active == 0) UpdateChannel(3, 1);
				else UpdateChannel(3, 0);

				VoltageChangedCh3 = 1;
			}
			else
				UpdateChannel(3, 1);
			
			if (Channel_3_Active == 0)
			{
				RemovePlane |= 0x04;
				ClearPlanes();
			}
			
			DrawSignals_Needed = true;
			UserIface_active = false;
			
			MenuStatusChanged = 3;	
			if (Cursor_Enabled) Display::CALCCURSORDATA();
				
			Display::StatusUpdate();
			
           		New_Menu = 3;
			Menu_Changed = 1;
			
			if (Channel_3_Active == 1)
			{
				Set_LED(5);
				MenuAktive = 1;
			}
			else
			{
				Reset_LED(5);
				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Channel 4 Button pressed	
		//--------------------------------------------
		case 4:
		{
			if (NumberOfChannels == 2) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
						
			if (Active_Menu == 4)
			{
                		if ((Channel_1_Active == 0) && (Channel_2_Active == 0) && (Channel_3_Active == 0)) break;

				if (Channel_4_Active == 0) UpdateChannel(4, 1);
				else UpdateChannel(4, 0);
				
				VoltageChangedCh4 = 1;
			}
			else UpdateChannel(4, 1);
			
			if (Channel_4_Active == 0)
			{
				RemovePlane |= 0x08;
				ClearPlanes();
			}
			
			DrawSignals_Needed = true;
			UserIface_active = false;
			
			MenuStatusChanged = 4;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
			
            		New_Menu = 4;
			Menu_Changed = 1;
			
			if (Channel_4_Active == 1)
			{
				Set_LED(5);
				MenuAktive = 1;
			}
			else
			{
				Reset_LED(5);
				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Display Button pressed	
		//--------------------------------------------
		case 5:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
						
			New_Menu = 5;
			Menu_Changed = 1;
			
			Set_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Utility Button pressed	
		//--------------------------------------------
		case 6:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
							
			New_Menu = 6;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}
		
//BF ????	//--------------------------------------------
		// Service Button pressed	// Ist im menu Utility versteckt. Mu� noch gemacht werden
		//--------------------------------------------
		case 7:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
							
			New_Menu = 7;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Save / Recall Button pressed	
		//--------------------------------------------
		case 8:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 8;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Print Menu Button pressed	
		//--------------------------------------------
		case 9:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 9;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Main/Delay Button pressed	
		//--------------------------------------------
		case 10:
		{		


			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 10;
			Menu_Changed = 1;
			
			Reset_LED(5);
			
			break;	
		}		
		
		//--------------------------------------------
		// Trigger Mode / Coupling Button
		//--------------------------------------------
		case 12: 
		{ 	
			/* Toggle deactive		
			if (Active_Menu == 12)
			{
				if (MenuStatus[12][0] == 93)
					MenuStatus[12][0] = 94;
				else
					MenuStatus[12][0] = 93;
	
				MenuItemChanged[0] = 1;						
			}
			*/			

			New_Menu = 12;
			Menu_Changed = 1;
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;
			
			UpdateTrigger(1);
						
			Display::StatusUpdate();			
			
			Set_LED(5);
			
			break;
		}		
		
		//--------------------------------------------	
		// Edge Trigger Menu Button pressed	
		//--------------------------------------------
		case 14:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
					
			TriggerWay = 1;
			
			New_Menu = 14;
			Menu_Changed = 1;
			
            		TriggerWayChanged = 1;

            		Display::StatusUpdate();				
			
			LED_ON[5] = 1;
			LED_ON[8] = 1;
			LED_ON[10] = 0;

			Send_LED();
			
			UpdateTrigger(2);
			
			break;	
		}
		
		//--------------------------------------------
		// Pulse Width Trigger Menu Button pressed	
		//--------------------------------------------
		case 15:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		
		
            		New_Menu = 15;
			Menu_Changed = 1;


			TriggerWay = 2;			
			
            		TriggerWayChanged = 1;

            		Display::StatusUpdate();			
			
			LED_ON[5] = 1;
			LED_ON[8] = 0;
			LED_ON[10] = 1;	
            		Send_LED();	

            		UpdateTrigger(3);	



			break;	
		}		
		
		//--------------------------------------------
		// Cursor Menu Button pressed	
		//--------------------------------------------
		case 16:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			//CursorChanged = 7; 			
			if ((Cursor_Enabled) && (Active_Menu == 16))
			{
                		Cursor_Enabled_Old = Cursor_Enabled;
                		Cursor_Enabled = false;
				Cursor_Data_First_Draw = 0;
				//Quick_Measure_First_Draw = 0;
				MenuStatusChanged = 1;

				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;		// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text				
					*(UI_Plane4 + ix) = 0;		// delete
					*(UI_Plane5 + ix) = 0;		// delete
				}
		
				LED_ON[5] = 0;
				LED_ON[6] = 0;
		
				Send_LED();			
						
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 0;
						
				Display::DRAW_ALL_CURSOR();
			}
			else
			{
				LED_ON[5] = 1;
				LED_ON[6] = 1;
							
				if (QM_Enabled)
				{
					QM_Enabled_Old = QM_Enabled;
					QM_Enabled = false;
					Quick_Measure_First_Draw = 0;
					MenuStatusChanged = 1;
			
					// remove the cursor data
					for (ix = 408 * 20; ix < 430 * 20; ix++)
					{
						*(UI_Plane1 + ix) = 0;	// delete
						*(Buffer_UI2Plane + ix) = 0;	// delete Text				
						*(UI_Plane4 + ix) = 0;	// delete
						*(UI_Plane5 + ix) = 0;	// delete
					}
			
					LED_ON[7] = 0;
							
					//New_Menu = 19;
					Menu_Changed = 1;
					//MenuAktive = 0;
							
					Display::CALCQMDATA();
				}	
		
				Cursor_Vertical_Active = 1;
				Cursor_Horizontal_Active = 3;
		
				Send_LED();	
		
				Cursor_Enabled_Old = Cursor_Enabled;
				Cursor_Enabled = true;
				
				Cursor_Data_First_Draw = 1;		
				MenuStatusChanged = 1;
				
				//SelectedChannel = 0;
				
				CursorChanged = 1;
				CursorChanged = 4;
				//CursorChanged = 3;	
						
				Display::CALCCURSORDATA();
				//Display::DRAWCURSORDATA(0);
				Display::DRAW_ALL_CURSOR();

						
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 1;
			}
#ifdef _Debug_Cursor_			
if (Debug_Mode) printf("CE : %d CB : %d CVA : %d CHA : %d \n", Cursor_Enabled, Cursor_Both_Selected, Cursor_Vertical_Active, Cursor_Horizontal_Active);
#endif			
			UpdateMenuTextPlane = true;
            	
			break;	
		}

		//--------------------------------------------
		// Quick Print Button pressed
		//--------------------------------------------
		case 17: 
		{
			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{
				send_buffer[0] = 151;			// Check USB Connection
				send_buffer[1] = 0;
				send_buffer[2] = 0;
							
				SendData(send_buffer);	
			}
				
			New_Menu = 17;
			Menu_Changed = 1;
			USB_Connected = false;
			
			//if (USB_Connected) USB_Connected = false;
			//else USB_Connected = true;
			
			Reset_LED(5);
			
			break;
		}
		
		//--------------------------------------------
		// Quick Measure Button pressed
		//--------------------------------------------
		case 19:
		{ 	
           		// if ((MenuStatus[10][2] == 1) || (Display_Mode == 1)) return;
            		if (Display_Mode == 1) return;


            		MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			
			
			if ((QM_Enabled) && (Active_Menu == 19))
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
			
				QM_Type_Old[0] = QM_Type[0];
				QM_Type_Old[1] = QM_Type[1];
				QM_Type_Old[2] = QM_Type[2];				
						
				QM_Type[0] = 0;
				QM_Type[1] = 0;
				QM_Type[2] = 0;
		
				QM_Channel[0] = MenuStatus[19][0] - 26;
				QM_Channel[1] = MenuStatus[19][0] - 26;
				QM_Channel[2] = MenuStatus[19][0] - 26;
		
				QM_Changed[0] = 0;
				QM_Changed[1] = 0;
				QM_Changed[2] = 0;
		
				Quick_Measure_First_Draw = 1;
		
				LED_ON[5] = 0;
				LED_ON[7] = 0;
		
				New_Menu = 19;
				Menu_Changed = 1;
		
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = false;
		
				QM_Vertical_Active = 0;
				QM_Horizontal_Active = 0;
		
				Display::CALCQMDATA();
			}
			else
			{ 	
				LED_ON[5] = 1;
				LED_ON[7] = 1;
					
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = true;
		
				QM_Vertical_Active = 3;
				QM_Horizontal_Active = 3;
			
				Quick_Measure_First_Draw = 1;		
				MenuStatusChanged = 1;
				
				if (QM_Type[0] == 0)
				{
					if (QM_Type_Old[0] == 0)
					{
						QM_Type_Old[0] = 5;             // Freqency
						QM_Type_Old[1] = 8;            // Peak-Peak
						QM_Type_Old[2] = 0;
					}

					QM_Type[0] = QM_Type_Old[0];
					QM_Type[1] = QM_Type_Old[1];
					QM_Type[2] = QM_Type_Old[2];
			
					QM_Channel[0] = MenuStatus[19][0] - 26;
					QM_Channel[1] = MenuStatus[19][0] - 26;
					QM_Channel[2] = MenuStatus[19][0] - 26;
                		}
				
				if (QM_Type[0] > 0) QM_Changed[0] = 1;
				if (QM_Type[1] > 0) QM_Changed[1] = 1;
				if (QM_Type[2] > 0) QM_Changed[2] = 1;
			
				if (Cursor_Enabled)
				{
					Cursor_Enabled_Old = Cursor_Enabled;
					Cursor_Enabled = false;
					Cursor_Data_First_Draw = 0;
		
					//MenuStatusChanged = 1;
		
				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;	// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text				
					*(UI_Plane4 + ix) = 0;	// delete
					*(UI_Plane5 + ix) = 0;	// delete
				}
		
				LED_ON[6] = 0;
						
				//New_Menu = 16;
				Menu_Changed = 1;
				//MenuAktive = 0;
						
				Display::DRAW_ALL_CURSOR();
				}
                				
				Display::CALCQMDATA();
				
                		New_Menu     = 19;
				Menu_Changed = 1;
				MenuAktive   = 1;
				UpdateMenuTextPlane = true;
			}
			
			Send_LED();	
			
			break;
		}
		
		//--------------------------------------------
		// Autoscale Button pressed
		//--------------------------------------------
		case 23:
		{	
            		if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

            		SingleMode = 0;
            		Continius = 1;
		
			New_Menu = 23;
			Menu_Changed = 1;
			
            		AutoScale();
			
			break;
        	}

		//--------------------------------------------
		// Math Button pressed
		//--------------------------------------------
		case 26:
		{		
            		//if (MenuStatus[10][2] == 1) break;
            		if (Display_Mode == 1) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
			

			//BF change activate FFT again /*	TMW changed; disable FFT
		
			//FFT-Menu	
			if (Channel_Math_Active == 0)
			{
				if ((Channel_1_Active == false) || (Channel_2_Active == false))    // if only one channel active then FFT
				{
					MenuStatus[26][1] = 1;
					MenuStatus[26][2] = 0;
					MenuStatus[26][3] = 0;
					MenuStatus[26][4] = 0;
					
					TransferPlanes_clear_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
					
					for (ix = 0; ix < 600; ix++)
					{
						SIGNALM[ix] = FFTOffsetY;
					}
				}
			}   //BF change end TMW change ends */



			if ((Active_Menu == 26) && (Channel_Math_Active == 1))
			{							
				if (Channel_Math_Active) Channel_Math_Active = 0;
				else Channel_Math_Active = 1;
			}
			else 
			{	Channel_Math_Active = 1;}

            		New_Menu = 26;
			Menu_Changed = 1;
			
			if (Channel_Math_Active == 1)
            		{
				Set_LED(4);
				MenuAktive = 1;
		
				if (NumberOfChannels == 2)
				{
				//if (MenuPopupStatus[1][2] == 1) MenuPopupStatus[1][2] = 2;
				//if (MenuPopupStatus[3][2] == 1) MenuPopupStatus[3][2] = 2;
				}
				else
				{
				//if (MenuPopupStatus[1][4] == 1) MenuPopupStatus[1][4] = 2;
				//if (MenuPopupStatus[3][4] == 1) MenuPopupStatus[3][4] = 2;
				}
            		}
			else
            		{
				Reset_LED(4);
				MenuAktive = 0;
		
				if (NumberOfChannels == 2)
				{
				//if (MenuPopupStatus[1][2] != 1) MenuPopupStatus[1][2] = 1;
				//if (MenuPopupStatus[3][2] != 1) MenuPopupStatus[3][2] = 1;
				}
				else
				{
				//if (MenuPopupStatus[1][4] != 1) MenuPopupStatus[1][4] = 1;
				//if (MenuPopupStatus[3][4] != 1) MenuPopupStatus[3][4] = 1;
				}
		
				RemovePlane |= 0x10;
				ClearPlanes();
            		}

			// Wenn FFT dann vorerst Cursor off
			if ((Cursor_Enabled) && (MenuStatus[26][1] == 1))
			{
				Cursor_Enabled_Old = Cursor_Enabled;
				Cursor_Enabled = false;
				Cursor_Data_First_Draw = 0;
		
				//MenuStatusChanged = 1;
		
				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;	// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text				
					*(UI_Plane4 + ix) = 0;	// delete
					*(UI_Plane5 + ix) = 0;	// delete
				}
		
				LED_ON[6] = 0;
						
				//New_Menu = 16;
				Menu_Changed = 1;
				//MenuAktive = 0;
						
				Display::DRAW_ALL_CURSOR();
			}

			break;	
		}
		
		//--------------------------------------------
		// Function Button 1 pressed
		//--------------------------------------------
		case 30 :
		{
			// Button handler for function button 1 	BF new function
			F1_Btnhandler();
			break;
		}	

		//--------------------------------------------
		// Function Button 2 pressed
		//--------------------------------------------
		case 31 :
		{
			// Button handler for function button 2 	BF new function
			F2_Btnhandler();
			break;
		}

		//--------------------------------------------	
		// Function Button 3
		//--------------------------------------------
		case 32 :
		{
			// Button handler for function button 3 	BF new function
			F3_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 4
		//--------------------------------------------
		case 33 :
		{
			// Button handler for function button 4 	BF new function
			F4_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 5
		//--------------------------------------------
		case 34 :
		{
			// Button handler for function button 5 	BF new function
			F5_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 6
		//--------------------------------------------
		case 35 :
		{		
			// Button handler for function button 6 	BF new function
			F6_Btnhandler();
			break;
		}
		
		//--------------------------------------------
        	// Run / Stop Button pressed
		//--------------------------------------------
		case 37 :
		{	
			if (Continius == 1)
			{
				Continius = 0;
				UserIface_active = 0;
		
				// Run/Stop to red
				LED_ON[12] = 0;
				LED_ON[13] = 1;
		
				LED_ON[14] = 0;
				LED_ON[15] = 0;
		
		
				SIGNAL_StartFr_idx = SIGNALFaktor_idx;
				Selected_Voltage_CH1_Old = Selected_Voltage_CH1;
				Selected_Voltage_CH2_Old = Selected_Voltage_CH2;
				Selected_Voltage_CH3_Old = Selected_Voltage_CH3;
				Selected_Voltage_CH4_Old = Selected_Voltage_CH4;
		
		/*
				printf("SVC1_Old %d SVC1 %d\n", Selected_Voltage_CH1_Old, Selected_Voltage_CH1);
				printf("SVC2_Old %d SVC2 %d\n", Selected_Voltage_CH2_Old, Selected_Voltage_CH2);
				printf("SVC3_Old %d SVC3 %d\n", Selected_Voltage_CH3_Old, Selected_Voltage_CH3);
				printf("SVC4_Old %d SVC4 %d\n", Selected_Voltage_CH4_Old, Selected_Voltage_CH4);
		*/
				//if (MenuStatus[10][2] == 1) DoDisableTimer2Interrupt();
		
				AUTOMODE_bak = MenuStatus[12][0];
			}
			else
			{
			/* TMW if (Memory_Window_visible)
				{
				Display::DRAWMEMORY(0, 0, 1);
				}*/
		
				Display::DRAW_ALL_CURSOR();
		
				Continius = 1;
				Signal_Loaded = 0;
				//UserIface_active = 0;
		
				SingleMode = 0;
		
				LED_ON[12] = 1;
				LED_ON[13] = 0;
		
				LED_ON[14] = 0;
				LED_ON[15] = 0;
		
		
				MenuStatus[12][0] = AUTOMODE_bak;
				
				if (MenuStatus[12][0] == 93)
				{
				MenuPopupStatus[9][0] = 3;
				MenuPopupStatus[9][1] = 2;
				}
				else
				{
				MenuPopupStatus[9][0] = 2;
				MenuPopupStatus[9][1] = 3;
				}
				
				
				MenuItemChanged[0] = 1;						
				Menu_Changed = 1;
				TriggerLevelChanged = 1;
				TriggerModeChanged = 1;
		
				UpdateTrigger(55);			
				Display::StatusUpdate();
				/*
				if (MenuStatus[10][2] == 1)
				{
				ClearPlanes();
				ROLLMODE_OFFSET = 601;	
				ROLLMODE_POS = 0;
				ROLLMODE_STARTED = false;
		
				//DoEnableTimer2Interrupt();
				//Start_Record();
				}
				*/
		
				//if (adc_started == false) Start_Record();
				//ResetTimer();
		
				Start_Record();
			}

			Send_LED();
		
			TriggerModeChanged = 1;
			Display::StatusUpdate();
#ifdef _Debug_
			if (Debug_Mode)
			{
			printf("Run / Stop Button \n");
			if (Continius) printf("Continius Mode enabled\n");
			else printf("Continius Mode disabled\n");
			}	
#endif	
		
			break;
        	}

		//--------------------------------------------
        	// Single Button pressed
		//--------------------------------------------
		case 38 :
		{	
            		//if (MenuStatus[10][2] == 1) break;

			if (SingleMode == 1)
			{
				// Run / Stop out
				LED_ON[12] = 0;
				LED_ON[13] = 0;
		
				// Single orange
				LED_ON[14] = 1;
				LED_ON[15] = 1;
				Send_LED();	
		
				UserIface_active = 0;
		
				//Single_Restart = 1;
			}
			else
			{		
				SingleMode = 1;
				Continius = 0;
				UserIface_active = 0;
		
				// Run / Stop out
				LED_ON[12] = 0;
				LED_ON[13] = 0;
		
				// Single orange
				LED_ON[14] = 1;
				LED_ON[15] = 1;
		
				AUTOMODE_bak = MenuStatus[12][0];
			}

			MenuStatus[12][0] = 94;
			MenuPopupStatus[9][0] = 2;
			MenuPopupStatus[9][1] = 3;
			MenuItemChanged[0] = 1;						
			Menu_Changed = 1;
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;

            		//timebase_reg = tb_value[Selected_Timebase];     // Switch to old timebase

			UpdateTrigger(15);			
            		Display::StatusUpdate();

            		Send_LED();	

           		if (adc_started == false) Start_Record();
#ifdef _Debug_
			if (Debug_Mode) printf("Single Button sm : %i  c : %i\n", SingleMode, Continius);
#endif			
			break;
        }
		
		//--------------------------------------------
		// Test Funktion 0 Q
		//--------------------------------------------
		case 40 :
		{	
			if (ADC_Debug_Mode) ADC_Debug_Mode = false;
			else ADC_Debug_Mode = true;

			if (Debug_Mode)
			{
				if (ADC_Debug_Mode) printf("ADC Debug Mode enabled\n");
				else printf("ADC Debug Mode disabled\n");
			}

            		config_changed = true;
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 1 W
		//--------------------------------------------
		case 41 :
		{	

			for (ix = 0x0000; ix < 0x0400; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				nr_delay(10);
			}

			printf("CH1VZL %d\n", Virtual_ZeroLevelCH1);
			printf("CH1ZL %d\n", ZeroLevelCH1);
			printf("CH1RK %d\n", (ZeroLevelCH1 + 64) >> 1);
		
			printf("CH1ZSO1 %d\n", Channel1_Zero_Sign_Offset_1);
			printf("CH1ZSO2 %d\n", Channel1_Zero_Sign_Offset_2);
			printf("CH1ZSO3 %d\n", Channel1_Zero_Sign_Offset_3);
			printf("CH1ZO %d\n", CH1_Zero_Offset);
		
			printf("Signal Buf_Adr %d Buf_wit %d  pre_reg %d\n", buffer_addi, buffer_long1, pre_reg);
		
			printf("STB %d STB_idx %d\n", Selected_Timebase, SIGNALFaktor_idx);

			
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 2 E
		//--------------------------------------------
		case 42 :
		{	

			for (ix = 0x3C00; ix < 0x4000; ix+=4)
		{
			printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
			nr_delay(10);
		}

			printf("CH1VZL %d\n", Virtual_ZeroLevelCH1);
			printf("CH1ZL %d\n", ZeroLevelCH1);
			printf("CH1RK %d\n", (ZeroLevelCH1 + 64) >> 1);
		
			printf("CH1ZSO1 %d\n", Channel1_Zero_Sign_Offset_1);
			printf("CH1ZSO2 %d\n", Channel1_Zero_Sign_Offset_2);
			printf("CH1ZSO3 %d\n", Channel1_Zero_Sign_Offset_3);
			printf("CH1ZO %d\n", CH1_Zero_Offset);
		
			printf("Signal Buf_Adr %d Buf_wit %d  pre_reg %d\n", buffer_addi, buffer_long1, pre_reg);
	
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 3 R
		//--------------------------------------------
		case 43 :
		{	/*
			for (ix = 0x0000; ix < 0x0250; ix+=4)
			{
				printf("S1_Min_%d : %3d %3d %3d %3d\n", ix, SIGNAL1_SUM_MIN[ix], SIGNAL1_SUM_MIN[ix + 1], SIGNAL1_SUM_MIN[ix + 2], SIGNAL1_SUM_MIN[ix + 3]);
				nr_delay(10);
			} */
			Do_Gen_Signal();
			VSync_Needed = 1;
			UserIface_active = 0;
			DrawSignals_Needed = 1;
		
			Display::DRAWSIGNALS(1);		
			TransferPlanes();			
			printf("Generate Signal  ready\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 4 T
		//--------------------------------------------
		case 44 :
		{		
			Do_Gen_Signal();
			VSync_Needed = 1;
			UserIface_active = 0;
			DrawSignals_Needed = 1;
		
			Display::DRAWSIGNALS(1);		
			TransferPlanes();			
			printf("Generate Signal ready\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 5 Z
		//--------------------------------------------
		case 45 :
		{	
			Channel_Math_Active = 1;
			MenuStatus[26][1] = 1;
			MenuStatus[26][2] = 0;
			MenuStatus[26][3] = 0;
			MenuStatus[26][4] = 0;
				
			VSync_Needed = 1;
			UserIface_active = 0;
			DrawSignals_Needed = 1;

			//BF change activated FFT
			Do_FFT();
			//BF end
			Display::DRAWSIGNALS(1);		
			TransferPlanes();

            		printf("FFT  ready\n");            	

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 6 U
		//--------------------------------------------
		case 46 :
		{		
			if (Test_Mode) Test_Mode = false;
			else Test_Mode = true;

			if (Test_Mode) printf("Test Mode enabled\n");
			else printf("Test Mode disabled\n");
            		
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 7 I
		//--------------------------------------------
		case 47 :
		{		
			if (FirEnabledCH1 == 0x00) FirEnabledCH1 = 0x01;
			else FirEnabledCH1 = 0x00;

            		if (FirEnabledCH1) printf("FIR CH 1 enabled\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 8 O
		//--------------------------------------------
		case 48 :
		{		
            		Test_Slip = Test_Slip - 0.1;

//            		printf("Slip = %f \n", Test_Slip);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 9 P
		//--------------------------------------------
		case 49 :
		{

            		Test_Slip = Test_Slip + 0.1;

//            		printf("Slip = %f \n", Test_Slip);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 10 A
		//--------------------------------------------
		case 50 :
		{	
            		Test_Range--;
            		//Test_Slip = Test_Slip - 1.0;

            		//printf("Slip = %f \n", Test_Slip);
           		 printf("Range = %d \n", Test_Range);

            		break;
		}
		
		//--------------------------------------------
		// Test Funktion 11 S
		//--------------------------------------------
		case 51 :
		{	
	
            		Test_Range++;
            		//Test_Slip = Test_Slip + 1.0;

            		//printf("Slip = %f \n", Test_Slip);
            		printf("Range = %d \n", Test_Range);


			break;
		}
		
		//--------------------------------------------
		// Test Funktion 12 D
		//--------------------------------------------
		case 52 :
		{	
			if (Debug_Mode) Debug_Mode = false;
			else Debug_Mode = true;
		
			if (Debug_Mode) printf("Debug Mode enabled\n");
			else printf("Debug Mode disabled\n");
		
			config_changed = true;
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 13 F
		//--------------------------------------------
		case 53 :
		{	
			//reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
			
			AMDFlash::Clear_Data_FLASH();

			printf("Flash formated\n");

			//reset_watchdog->np_piodata = 0x01;						// Enable WatchDog
			
			//Reset_the_Watchdog();

			printf("Reset Hardware\n");

		    nr_delay(3000);						

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 14 G
		//--------------------------------------------
		case 54 :
		{	
			if (Continius)
			{
				Continius = 0;
				SIGNAL_StartFr_idx = SIGNALFaktor_idx;
			}
			else Continius = 1;

			if (Debug_Mode)
			{
				if (Continius) printf("Continius Mode enabled\n");
				else printf("Continius Mode disabled\n");
			}

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 15 H
		//--------------------------------------------
		case 55 :
		{	
	
			printf("\r\n");
			printf("***************************************************************************\r\n");
			printf("* Keyboard Commands : Menus                                               *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Channel 1     : i  *  Mode / Timebase : b * Display      : d * File : f *\r\n");
			printf("* Channel 2     : j  *  Cursor          : c * Trigger Edge : e *          *\r\n");
			printf("* Channel 3     : k  *  Quick Meas      : q * Mode / Coup  : t *          *\r\n");
			printf("* Channel 4     : l  *  Quick Meas Sett : w * Pulse Width  : p *          *\r\n");
			printf("* Channel Math  : o  *  Acquire         : a * Utility      : u *          *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Extended Commands : Help Keys                                           *\r\n");
			printf("***************************************************************************\r\n");
			printf("* This Help Screen  : h / Shift + H * Write Config to Flash  : Shift + Y  *\r\n");
			printf("* Enable Debug Mode :     Shift + D * Read Config from Flash : Shift + X  *\r\n");
			printf("* Clear Data Flash  :     Shift + F * Write Logo 1 to Flash  : Shift + W  *\r\n");
			printf("* Shoot Signal      :     Shift + S * Write Logo 2 to Flash  : Shift + E  *\r\n");
			printf("* Reset Hardware    :     Shift + R * Print Config in Flash  : Shift + P  *\r\n");
			printf("* Enable Debug Sig  :     Shift + Q * Interpolate CH1        : Shift + I  *\r\n");
			printf("* Continius Rec     :     Shift + G * Show Trigger Vals      : Shift + J  *\r\n");
			printf("* Smooth CH I       :     Shift + K * Smooth CH II           : Shift + L  *\r\n");
			printf("* Enable Extra Trg  :     Shift + T * Rot Timer Status       : Shift + A  *\r\n");
			printf("* Colordemo         :     Shift + C * Enable Command Debug   : Shift + B  *\r\n");
			printf("* Connect_Vals      :     Shift + V * Search Mode            : Shift + M  *\r\n");
			printf("* Show Variables    :     ,         * DRAW GRIDXY            : Shift + 6  *\r\n");
			printf("* Multiplier On/Off :     Shift + 1 * Test Multiplier        : -          *\r\n");
			printf("* M-Factor CHI + 10 :     Shift + 2 * M-Factor CHI - 10      : Shift + 3  *\r\n");
		//            printf("*                   :     Shift + V *                        : Shift + B  *\r\n");
		//            printf("*                   :     Shift + _ *                                     *\r\n");
		//            printf("* Timebase manipulation : Press ShiftKey +                                *\r\n");
		//            printf("*      1       2       3     4    5    6    7      8      9         0     *\r\n");
		//            printf("* -0x10000 -0x1000 -0x100 -0x10 -0x1 +0x1 +0x10 +0x100 +0x1000 +0x100000  *\r\n");
			printf("***************************************************************************\r\n");
			printf("\r\n");

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 16 J
		//--------------------------------------------
		case 56 :
		{		
			printf("ctr %x actr %x tb %x pr %x tvr1 %x tvr2 %x trr %x trw %x tp1 %i adc_ch %x \r\n", ctrl_reg, adc_ctrl_reg, timebase_reg, pre_reg, trg_val_CHI_reg, trg_val_CHII_reg, trig_range_reg, trig_width_reg, Trigger_Pos_CH1, adc_change12_reg);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 17 K
		//--------------------------------------------
		case 57 :
		{		
			if (SmoothEnabledCH1) SmoothEnabledCH1 = 0;
			else SmoothEnabledCH1 = 1;
		
			if (Debug_Mode)
			{
				if (SmoothEnabledCH1) printf("Smooth CH I enabled\n");
				else printf("Smooth CH I disabled\n");
			}

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 18 L
		//--------------------------------------------
		case 58 :
		{		
			if (SmoothEnabledCH2) SmoothEnabledCH2 = 0;
			else SmoothEnabledCH2 = 1;
		
			if (Debug_Mode)
			{
				if (SmoothEnabledCH2) printf("Smooth CH II enabled\n");
				else printf("Smooth CH II disabled\n");
			}

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 19 �
		//--------------------------------------------
		case 59 :
		{		
	
            		TestFir();

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 20 Y
		//--------------------------------------------
		case 60 :
		{	
			
			Display::ColorDemo5();
			
			break;
		}	
		
		//--------------------------------------------
		// Test Funktion 21 X
		//--------------------------------------------
		case 61 :
		{
			Display::ColorDemo6();
			break;	
		}	

		//--------------------------------------------
		// Test Funktion 22 C
		//--------------------------------------------
		case 62 :
		{		
			Display::ColorDemo();

			break;
		}	

		//--------------------------------------------
		// Test Funktion 23 V
		//--------------------------------------------
		case 63 :
		{	
			if (Connect_Vals) Connect_Vals = false;
			else Connect_Vals = true;
		
			if (Debug_Mode)
			{
				if (Connect_Vals) printf("Connect_Vals enabled\n");
				else printf("Connect_Vals disabled\n");
			}

            		config_changed = true;		

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 24 B
		//--------------------------------------------
		case 64 :
		{		
			if (Command_Mode) Command_Mode = false;
			else Command_Mode = true;
		
			if (Debug_Mode)
			{
				if (Command_Mode) printf("Command Mode enabled\n");
				else printf("Command Mode disabled\n");
			}
		
			config_changed = true;
			break;
		} 

		//--------------------------------------------	
		// Test Funktion 25 N
		//--------------------------------------------
		case 65 :
		{	
		    	//Display::GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);

			//printf("Add  : %d\n", nm_math_pfx(0x040A, 0x00643040, 0x00C8FFB0));
			//printf("Sub  : %d\n", nm_math_pfx(0x000A, 0x00643040, 0x00C8FFB0));
			//printf("Mult : %d\n", nm_math_pfx(0x0212, 0x00643040, 0x00C8FFB0));

            		// Multiplikation
            /*
			xm = 0x00010101;
			ym = 0x00010101;
			res_xm = nm_math_pfx(0x0201, xm, ym);
	
			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult1 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
	
			xm = 0x00010502;
			ym = 0x00010502;
			res_xm = nm_math_pfx(0x0201, xm, ym);

			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult2 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult3 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

            		printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult4 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E90;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult5 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

           		xm = 0x01F47E65;
		    	ym = 0x01F47E7D;
		   	res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult6 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E99;
		    	ym = 0x01F47E7D;
		    	res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult7 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            */

            		// Addition
			xm = 0x00010101;
			ym = 0x00010101;
			res_xm = nm_math_pfx(0x0401, xm, ym);

            		printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
            		//printf("mth ad1 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            		printf("mth ad1 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));

			xm = 0x00010502;
			ym = 0x00010502;
			res_xm = nm_math_pfx(0x0401, xm, ym);

            		printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
            		//printf("mth ad2 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            		printf("mth ad2 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));

			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad3 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad3 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad4 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad4 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad5 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad5 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad6 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad6 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E99;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad7 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad7 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47EA0;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad8 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad8 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));



            // Subtraction
            /*		
		    xm = 0x00010101;//0x00643040;
		    ym = 0x00010101;//0x00C8FFB0;
		    res_xm = nm_math_pfx(0x0001, xm, ym);

            printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub1 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
		    xm = 0x00010502;//0x00643040;
		    ym = 0x00010502;//0x00C8FFB0;
		    res_xm = nm_math_pfx(0x0001, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub2 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
		    xm = 0x01F47E92;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub3 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
            xm = 0x01F47E6A;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub4 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            			
            xm = 0x01F47E90;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub5 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
            xm = 0x01F47E65;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub6 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));	
		
            xm = 0x01F47E99;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub7 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            */           	
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 26 M
		//--------------------------------------------
		case 66 :
		{	
            		// Clear All Planes
            		//for (ix = 0; ix < 153600; ix++) Planes[ix] = 0;	

            		Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);		
            /*	
		   	 Search_Step = 0;
            		
            		if (Search_Mode) Search_Mode = false;
            		else Search_Mode = true;

			if (Debug_Mode)
			{
				if (Search_Mode) printf("Search Mode enabled\n");
				else printf("Search Mode disabled\n");
			}

            		printf("SearchResult : %i\n", Hardware::SearchZeros());
            */
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 27 ;
		//--------------------------------------------
		case 67 :
		{	
			for (ix = 0; ix < 3; ix++)
			{
				printf("QMT %2i = %2i QMC = %2i QMCC = %2i QMSC = %2i QMEI = %2i QMEII = %2i\n", ix, QM_Type[ix], QM_Channel[ix], QM_Changed[ix], QM_Second_Channel[ix], QM_CHI_Edge[ix], QM_CHII_Edge[ix]);
			}
  	
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 28 :
		//--------------------------------------------
		case 68 :
		{	
		
			for (ix = 0; ix < 32; ix++)
			{
				printf("M %2i =", ix);
		
				for (ix2 = 0; ix2 < 6; ix2++)
				{
					printf("  I %i : %3i", ix2, MenuStatus[ix][ix2]);
		
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 69 ,
		//--------------------------------------------
		case 69 :
		{	
			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Variables                           *                                     *\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Selected_Timebase       : %5d     * Debug Mode               : %5d    *\r\n", Selected_Timebase, Debug_Mode);
			printf("* SIGNALFaktor_idx        : %5d     * ADC Debug Mode           : %5d    *\r\n", SIGNALFaktor_idx, ADC_Debug_Mode);
			printf("* Timebase_Offset_Pos     : %5d     * Command Debug Mode       : %5d    *\r\n", Timebase_Offset_Pos, Command_Mode);
			printf("* SIGNAL_OFFSET           : %5d     * Calc Mode                : %5d    *\r\n", SIGNAL_OFFSET, Calc_Mode);
			printf("* correction              : %5d     * ExtraTrg Mode            : %5d    *\r\n", correction, ExtraTrg_Mode);
			printf("* Signal Start            : %5d     * Search Mode              : %5d    *\r\n", SIG_Start_Stop[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]][0], Search_Mode);
			printf("* Signal Stop             : %5d     * Search Auto              : %5d    *\r\n", SIG_Start_Stop[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]][1], Search_Auto);
			printf("* Signal Start Calc       : %5d     * Connect Vals             : %5d    *\r\n", SIG_Start_Stop[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]][0] + (int)((float) Timebase_Offset_Pos * Offset_Faktor_Table[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]]), Connect_Vals);
			printf("* Signal Stop Calc        : %5d     * Continius                : %5d    *\r\n", SIG_Start_Stop[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]][1] + (int)((float) Timebase_Offset_Pos * Offset_Faktor_Table[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]]), Continius);
			//printf("* Zoom Faktor             : %3.3f     * SingleMode               : %5d    *\n",
			//Zoom_Faktor_Table[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]], SingleMode);
			//printf("* Offset Faktor           : %3.3f    * Single Restart           : %5d    *\n", OFT_float , Single_Restart);
			//Offset_Faktor_Table[Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx]], Single_Restart);
			printf("* Multiplier Enabled      : %5d     * adc started              : %5d    *\r\n", multi_active, adc_started);
			printf("* ADC_Data_Available      : %5d     * VSync Needed             : %5d    *\r\n", ADC_Data_Available, VSync_Needed);
			printf("* Keyboard_Changed        : %5d     * ZFT_float                : %5f    *\r\n", Keyboard_Changed, ZFT_float);
			printf("* Triggering              : %5d     * DrawSignals Needed       : %5d    *\r\n", triggering, DrawSignals_Needed);
			printf("* SelectedTriggerSource   : %5d     * SelectedTriggerSourceOld : %5d    *\r\n", Selected_Trigger_Source, Selected_Trigger_Source_Old);
			printf("* UserIface_active        : %5d     * OneShotRestart           : %5d    *\r\n", UserIface_active, OneShotRestart);
			printf("* ctrl_reg                :  %4x     * adc_ctrl_reg             :  %4x    *\r\n", ctrl_reg, adc_ctrl_reg);
			printf("* pre_reg                 :  %4x     * channel_Adr_add          :  %4x    *\r\n", pre_reg, channel_Adr_add);
			printf("* trg_val_CHI_reg         :  %4x     * trg_val_CHII_reg         :  %4x    *\r\n", trg_val_CHI_reg, trg_val_CHII_reg);
			printf("* trg_val_CHIII_reg       :  %4x     * trg_val_CHIV_reg         :  %4x    *\r\n", trg_val_CHIII_reg, trg_val_CHIV_reg);
			printf("* trig_range_reg          :  %4x     * trig_holdoff_reg         :  %4x    *\r\n", trig_range_reg, trig_holdoff_reg);
			printf("* trig_width_reg          :  %4x     *                                     *\r\n", trig_width_reg);
			printf("* adc_change12_reg        :  %8x * adc_change34_reg         : %8x *\r\n", adc_change12_reg, adc_change34_reg);
			printf("* adc_ctr12_reg           :  %8x * adc_ctr34_reg            : %8x *\r\n", adc_ctr12_reg, adc_ctr34_reg);
		
			printf("* Selected_Timebase       : %5d     * SIGNALFaktor_idx         : %5d    *\r\n", Selected_Timebase, SIGNALFaktor_idx);
			printf("* SIGNAL_StartFr_idx      : %5d     * timebase_reg             : %8x    *\r\n", SIGNAL_StartFr_idx, timebase_reg);
			printf("* Display_Timebase        : %5d     * dmode_Selected_Timebase  : %5d    *\r\n", Display_Timebase, dmode_Selected_Timebase);
			printf("* dmode_SIGNALFaktor_idx  : %5d     * dmode_factor             : %5d    *\r\n", dmode_SIGNALFaktor_idx, dmode_factor);
			printf("* dmode_SIGNAL_StartFr_idx: %5d     * Cursor_Delayed_1         : %5d    *\r\n", dmode_SIGNAL_StartFr_idx, Cursor_Delayed_1);
			printf("* Cursor_Delayed_2        : %5d     * Cursor_Delayed_Size      : %5d    *\r\n", Cursor_Delayed_2, Cursor_Delayed_Size);
			printf("* ROLLMODE_TB             : %5d     * ROLLMODE_OFFSET          : %5d    *\r\n", ROLLMODE_TB, ROLLMODE_OFFSET);
			printf("* dmode_Window_Offset_Pos : %5d     *                                   *\r\n", dmode_Window_Offset_Pos);
		
			printf("* SelectedEdgeExtern      : %5d     * TriggerWay               : %5d    *\r\n", SelectedEdgeExtern, TriggerWay );
			printf("* Trigger_Pos_CH1         : %5d     * Trigger_Pos_CH2          : %5d    *\r\n", Trigger_Pos_CH1, Trigger_Pos_CH2);
			printf("* Trigger_Pos_CH3         : %5d     * Trigger_Pos_CH4          : %5d    *\r\n", Trigger_Pos_CH3, Trigger_Pos_CH4);
			printf("* Trigger_Pos_CHE         : %5d     * FirStartCH_delayed       : %5d    *\r\n", Trigger_Pos_CHE, FirStartCH_delayed);
			printf("* Selected_Voltage_CH1    : %5d     * CH1_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH1, CH1_DAC_Offset);
			printf("* Selected_Voltage_CH2    : %5d     * CH2_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH2, CH2_DAC_Offset);
			printf("* Selected_Voltage_CH3    : %5d     * CH3_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH3, CH3_DAC_Offset);
			printf("* Selected_Voltage_CH4    : %5d     * CH4_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH4, CH4_DAC_Offset);
			printf("* Virtual_ZeroLevelCH1    : %5d     * ZeroLevelCH1             : %5d    *\r\n", Virtual_ZeroLevelCH1, ZeroLevelCH1);
			printf("* Virtual_ZeroLevelCH2    : %5d     * ZeroLevelCH2             : %5d    *\r\n", Virtual_ZeroLevelCH2, ZeroLevelCH2);
			printf("* Virtual_ZeroLevelCH3    : %5d     * ZeroLevelCH3             : %5d    *\r\n", Virtual_ZeroLevelCH3, ZeroLevelCH3);
			printf("* Virtual_ZeroLevelCH4    : %5d     * ZeroLevelCH4             : %5d    *\r\n", Virtual_ZeroLevelCH4, ZeroLevelCH4);
			printf("* CH1_Zero_Offset         : %5d     * signal_zoomed1           : %5d    *\r\n", CH1_Zero_Offset, signal_zoomed1);
			printf("* Ch1_Zero_Sign_Offset_1  : %5d     * Ch1_Zero_Sign_Offset_2   : %5d    *\r\n", Channel1_Zero_Sign_Offset_1, Channel1_Zero_Sign_Offset_2);
			printf("* Ch1_Zero_Sign_Offset_3  : %5d     * FirStartCH               : %5d    *\r\n", Channel1_Zero_Sign_Offset_3, FirStartCH);
			printf("* CH1_DAC_1               : %5d     * CH1_DAC_2                : %5d    *\r\n", CH1_DAC_1, CH1_DAC_2);
			printf("* CH1_DAC_3               : %5d     * CH1_DAC_4                : %5d    *\r\n", CH1_DAC_3, CH1_DAC_4);
		
			printf("* SwitchesCH1             : %5d     * SwitchesCH2              : %5d    *\r\n", SwitchesCH1, SwitchesCH2);
			printf("* SwitchesCH3             : %5d     * SwitchesCH4              : %5d    *\r\n", SwitchesCH3, SwitchesCH4);
		
			printf("* SwitchesTB              : %5d     * Trigger_Offset_Pos       : %5d    *\r\n", SwitchesTB, Trigger_Offset_Pos);
			printf("* HoldOff_Value           : %5d     * trig_holdoff_reg         : %8x    *\r\n", HoldOff_Value, trig_holdoff_reg);
			printf("* CVP_Real1               : %5d     *  CVP_Real2               : %5d    *\r\n", Cursor_Vertical_Position_Real1, Cursor_Vertical_Position_Real2);
			printf("* CVP_RealXY1             : %5d     *  CVP_RealXY2             : %5d    *\r\n", Cursor_Vertical_Position_Real_XY_1, Cursor_Vertical_Position_Real_XY_2);
			printf("* CHP_Real1               : %5d     *  CHP_Real1               : %5d    *\r\n", Cursor_Horizontal_Position_Real1, Cursor_Horizontal_Position_Real2);
			printf("* m2k_filter_Mode         :  %4x     *  kill_adc                :  %4x  *\r\n", m2k_filter_Mode, kill_adc);
			printf("* zeros_filter_Mode       :  %4x     *  tc_hw_version           : %8x   *\r\n", zeros_filter_Mode, tc_hw_version);
		
			printf("* draw_dm_ixstart         : %5d     * draw_dm_ixstop           : %5d    *\r\n", draw_dm_ixstart, draw_dm_ixstop);
			printf("* draw_dm_ixfactor        : %5d     * draw_dm_ixoffset         : %5d    *\r\n", draw_dm_ixfactor, draw_dm_ixoffset);
			printf("* dmode_Window_Offset_Pos : %5d     * dmode_Zoom_Index_Table   : %5d    *\r\n", dmode_Window_Offset_Pos, Zoom_Index_Table[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx]);
			printf("* dmode_SIG_Start_Stop    : %5d     * dmode_Offset_Faktor_Tab  : %5f *\r\n", SIG_Start_Stop[Zoom_Index_Table[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx]][0], Offset_Faktor_Table[Zoom_Index_Table[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx]]);
		
		
			printf("* ZFT_float               : %3.3f     * ZFT_float_dmode          : %3.3f    *\r\n", ZFT_float, ZFT_float_dmode);
			printf("* ZIT_short               : %5d     * ZIT_short_dmode          : %5d    *\r\n", ZIT_short, ZIT_short_dmode);
			printf("* Trig_Pos_Mem            : %5d     * Trig_Pos_Display         : %5d    *\r\n", Trig_Pos_Mem, Trig_Pos_Display);
			printf("* Trig_Pos_Zoom           : %3.3f     * Trig_Mem_Pos             : %5d    *\r\n", Trig_Pos_Zoom, Trig_Mem_Pos);
			printf("* Trig_Pos_Mem_old        : %5d     * Trig_Pos_Display_old     : %5d    *\r\n", Trig_Pos_Mem_old, Trig_Pos_Display_old);
			printf("* Trig_Pos_Zoom_old       : %3.3f     * Trig_Mem_Pos_old         : %5d    *\r\n", Trig_Pos_Zoom_old, Trig_Mem_Pos_old);
			printf("* OFT_float               : %3.3f     * OFT_float_old            : %3.3f  *\r\n", OFT_float, OFT_float_old);
			
		//            printf("*                                    *                                    *\n");
			printf("*****************************************************************************\r\n");
			printf("\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 70 .
		//--------------------------------------------
		case 70 :
		{		

			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Interrupts                          *                                     *\r\n");
			printf("*****************************************************************************\r\n");		
			printf("* ADC Interrupt Edge      : %5d     * Keyboard IRQ Edge        : %5d    *\r\n", acq_ready->np_pioedgecapture, key_int->np_pioedgecapture);
			printf("* ADC Interrupt           : %5d     * Keyboard IRQ             : %5d    *\r\n", acq_ready->np_piodata, acq_ready->np_piodata);
		//            printf("*                                    *                                    *\n");
			printf("*****************************************************************************\r\n");
			printf("\r\n");
		
			break;
		}

		//--------------------------------------------
		// Test Funktion 71 -
		//--------------------------------------------
		case 71 :
		{		
			xm = 100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 100 x 20 = %d\n", res_xm);
	
			xm = -100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -100 x 20 = %d\n", res_xm);		
	
			xm = 54;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 74 x 55 = %d\n", res_xm);
			
			xm = -74;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -54 x 55 = %d\n", res_xm);		

			break;
		}

		//--------------------------------------------
		// Test Funktion 31 !
		//--------------------------------------------
		case 80 :
		{		
			if (multi_active)
			{
				multi_active = false;
				SwitchesCH1 &= 0x7FFF;					
				SetSwitches(1, -1);
			}
			else
			{
				multi_active = true;
				SwitchesCH1 |= 0x8000;					
				SetSwitches(1, -1);
			}


            		printf("CH I Multiplier Active : %d\n", multi_active);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 31 "
		//--------------------------------------------
		case 81 :
		{		
			pre_reg--;
		
			SetupADC();	
			
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 32 �
		//--------------------------------------------
		case 82 :
		{		
			pre_reg++;
		
			SetupADC();	
			
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 33 $
		//--------------------------------------------
		case 83 :
		{	
		
			pre_reg -= 10;
		
			SetupADC();	
		
			printf("pre_reg : %i\n", pre_reg);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 34 %
		//--------------------------------------------
		case 84 :
		{		
			pre_reg += 10;
		
			SetupADC();	
		
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 35 &
		//--------------------------------------------
		case 85 :
		{		
			if (Display_Mode) Display_Mode = 0;
			else Display_Mode = 1;
				
			if (Continius == 0) DrawSignals_Needed = 1;
		
			printf("Display Mode %d\n", Display_Mode);

			break;
		}

		//--------------------------------------------
		// Test Funktion 36 /
		//--------------------------------------------
		case 86 :
		{		
			if (SIGNALFaktor_idx == 0) pre_reg = pre_reg - 6;
			else if (SIGNALFaktor_idx == 1) pre_reg = pre_reg - 10;
			else if (SIGNALFaktor_idx == 2) pre_reg = pre_reg - 18;
			else if (SIGNALFaktor_idx == 3) pre_reg = pre_reg - 55;
			else if (SIGNALFaktor_idx == 4) pre_reg = pre_reg - 90;
		
			SetupADC();
		
		
			printf("Test Pre Reg manipulation\n");

			break;
		}

		//--------------------------------------------
		// Test Funktion 37 (
		//--------------------------------------------
		case 87 :
		{	
			printf("MenuPopupStatus\n");
			for (ix2 = 0; ix2 < 30; ix2++)
			{
				printf("MPS[%2d] : ", ix2);
				
				for (ix = 0; ix < 21; ix++)
				{
				printf("%2d ", MenuPopupStatus[ix2][ix]);
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 38 )
		//--------------------------------------------
		case 88 :
		{		
			ix = (int) (Pulse11.Read_Value() * 100000000);			
			printf("PV 11 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse11_Value, Pulse11_Steps, Pulse11_Expo);
			ix = (int) (Pulse12.Read_Value() * 100000000);			
			printf("PV 12 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse12_Value, Pulse12_Steps, Pulse12_Expo);
		
			ix = (int) (Pulse21.Read_Value() * 100000000);			
			printf("PV 21 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse21_Value, Pulse21_Steps, Pulse21_Expo);
			ix = (int) (Pulse22.Read_Value() * 100000000);			
			printf("PV 22 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse22_Value, Pulse22_Steps, Pulse22_Expo);

			break;
		}

		//--------------------------------------------
		// Test Funktion 39 =
		//--------------------------------------------
		case 89 :
		{		
			printf("\n");
			printf("*****************************************************************************\n");
			printf("* Channel corrections                                                       *\n");
			printf("*****************************************************************************\n");		
			printf("* CH 1 V  0 : %3d    CH 2 V  0 : %3d    CH 3 V  0 : %3d    CH 4 V  0 : %3d  *\n", Voltage_Correction[0][0], Voltage_Correction[1][0], Voltage_Correction[2][0], Voltage_Correction[3][0]);
			printf("* CH 1 V  1 : %3d    CH 2 V  1 : %3d    CH 3 V  1 : %3d    CH 4 V  1 : %3d  *\n", Voltage_Correction[0][1], Voltage_Correction[1][1], Voltage_Correction[2][1], Voltage_Correction[3][1]);
			printf("* CH 1 V  2 : %3d    CH 2 V  2 : %3d    CH 3 V  2 : %3d    CH 4 V  2 : %3d  *\n", Voltage_Correction[0][2], Voltage_Correction[1][2], Voltage_Correction[2][2], Voltage_Correction[3][2]);
			printf("* CH 1 V  3 : %3d    CH 2 V  3 : %3d    CH 3 V  3 : %3d    CH 4 V  3 : %3d  *\n", Voltage_Correction[0][3], Voltage_Correction[1][3], Voltage_Correction[2][3], Voltage_Correction[3][3]);
			printf("* CH 1 V  4 : %3d    CH 2 V  4 : %3d    CH 3 V  4 : %3d    CH 4 V  4 : %3d  *\n", Voltage_Correction[0][4], Voltage_Correction[1][4], Voltage_Correction[2][4], Voltage_Correction[3][4]);
			printf("* CH 1 V  5 : %3d    CH 2 V  5 : %3d    CH 3 V  5 : %3d    CH 4 V  5 : %3d  *\n", Voltage_Correction[0][5], Voltage_Correction[1][5], Voltage_Correction[2][5], Voltage_Correction[3][5]);
			printf("* CH 1 V  6 : %3d    CH 2 V  6 : %3d    CH 3 V  6 : %3d    CH 4 V  6 : %3d  *\n", Voltage_Correction[0][6], Voltage_Correction[1][6], Voltage_Correction[2][6], Voltage_Correction[3][6]);
			printf("* CH 1 V  7 : %3d    CH 2 V  7 : %3d    CH 3 V  7 : %3d    CH 4 V  7 : %3d  *\n", Voltage_Correction[0][7], Voltage_Correction[1][7], Voltage_Correction[2][7], Voltage_Correction[3][7]);
			printf("* CH 1 V  8 : %3d    CH 2 V  8 : %3d    CH 3 V  8 : %3d    CH 4 V  8 : %3d  *\n", Voltage_Correction[0][8], Voltage_Correction[1][8], Voltage_Correction[2][8], Voltage_Correction[3][8]);
			printf("* CH 1 V  9 : %3d    CH 2 V  9 : %3d    CH 3 V  9 : %3d    CH 4 V  9 : %3d  *\n", Voltage_Correction[0][9], Voltage_Correction[1][9], Voltage_Correction[2][9], Voltage_Correction[3][9]);
			printf("* CH 1 V 10 : %3d    CH 2 V 10 : %3d    CH 3 V 10 : %3d    CH 4 V 10 : %3d  *\n", Voltage_Correction[0][10], Voltage_Correction[1][10], Voltage_Correction[2][10], Voltage_Correction[3][10]);
			printf("* CH 1 V 11 : %3d    CH 2 V 11 : %3d    CH 3 V 11 : %3d    CH 4 V 11 : %3d  *\n", Voltage_Correction[0][11], Voltage_Correction[1][11], Voltage_Correction[2][11], Voltage_Correction[3][11]);
			printf("* Channel corrections Float                                                 *\n");
			printf("*****************************************************************************\n");		
			printf("* CH 1 V  0 : %3f    CH 2 V  0 : %3f    CH 3 V  0 : %3f    CH 4 V  0 : %3f  *\n", Volt_Correct_float[0][0], Volt_Correct_float[1][0], Volt_Correct_float[2][0], Volt_Correct_float[3][0]);
			printf("* CH 1 V  1 : %3f    CH 2 V  1 : %3f    CH 3 V  1 : %3f    CH 4 V  1 : %3f  *\n", Volt_Correct_float[0][1], Volt_Correct_float[1][1], Volt_Correct_float[2][1], Volt_Correct_float[3][1]);
			printf("* CH 1 V  2 : %3f    CH 2 V  2 : %3f    CH 3 V  2 : %3f    CH 4 V  2 : %3f  *\n", Volt_Correct_float[0][2], Volt_Correct_float[1][2], Volt_Correct_float[2][2], Volt_Correct_float[3][2]);
			printf("* CH 1 V  3 : %3f    CH 2 V  3 : %3f    CH 3 V  3 : %3f    CH 4 V  3 : %3f  *\n", Volt_Correct_float[0][3], Volt_Correct_float[1][3], Volt_Correct_float[2][3], Volt_Correct_float[3][3]);
			printf("* CH 1 V  4 : %3f    CH 2 V  4 : %3f    CH 3 V  4 : %3f    CH 4 V  4 : %3f  *\n", Volt_Correct_float[0][4], Volt_Correct_float[1][4], Volt_Correct_float[2][4], Volt_Correct_float[3][4]);
			printf("* CH 1 V  5 : %3f    CH 2 V  5 : %3f    CH 3 V  5 : %3f    CH 4 V  5 : %3f  *\n", Volt_Correct_float[0][5], Volt_Correct_float[1][5], Volt_Correct_float[2][5], Volt_Correct_float[3][5]);
			printf("* CH 1 V  6 : %3f    CH 2 V  6 : %3f    CH 3 V  6 : %3f    CH 4 V  6 : %3f  *\n", Volt_Correct_float[0][6], Volt_Correct_float[1][6], Volt_Correct_float[2][6], Volt_Correct_float[3][6]);
			printf("* CH 1 V  7 : %3f    CH 2 V  7 : %3f    CH 3 V  7 : %3f    CH 4 V  7 : %3f  *\n", Volt_Correct_float[0][7], Volt_Correct_float[1][7], Volt_Correct_float[2][7], Volt_Correct_float[3][7]);
			printf("* CH 1 V  8 : %3f    CH 2 V  8 : %3f    CH 3 V  8 : %3f    CH 4 V  8 : %3f  *\n", Volt_Correct_float[0][8], Volt_Correct_float[1][8], Volt_Correct_float[2][8], Volt_Correct_float[3][8]);
			printf("* CH 1 V  9 : %3f    CH 2 V  9 : %3f    CH 3 V  9 : %3f    CH 4 V  9 : %3f  *\n", Volt_Correct_float[0][9], Volt_Correct_float[1][9], Volt_Correct_float[2][9], Volt_Correct_float[3][9]);
			printf("* CH 1 V 10 : %3f    CH 2 V 10 : %3f    CH 3 V 10 : %3f    CH 4 V 10 : %3f  *\n", Volt_Correct_float[0][10], Volt_Correct_float[1][10], Volt_Correct_float[2][10], Volt_Correct_float[3][10]);
			printf("* CH 1 V 11 : %3f    CH 2 V 11 : %3f    CH 3 V 11 : %3f    CH 4 V 11 : %3f  *\n", Volt_Correct_float[0][11], Volt_Correct_float[1][11], Volt_Correct_float[2][11], Volt_Correct_float[3][11]);
		//            printf("*                                    *                                    *\n");
			printf("*****************************************************************************\n");
			printf("* CH 1 V  0 : %3d    CH 2 V  0 : %3d    CH 3 V  0 : %3d    CH 4 V  0 : %3d  *\n", Voltage_Offset[0][0], Voltage_Offset[1][0], Voltage_Offset[2][0], Voltage_Offset[3][0]);
			printf("* CH 1 V  1 : %3d    CH 2 V  1 : %3d    CH 3 V  1 : %3d    CH 4 V  1 : %3d  *\n", Voltage_Offset[0][1], Voltage_Offset[1][1], Voltage_Offset[2][1], Voltage_Offset[3][1]);
			printf("* CH 1 V  2 : %3d    CH 2 V  2 : %3d    CH 3 V  2 : %3d    CH 4 V  2 : %3d  *\n", Voltage_Offset[0][2], Voltage_Offset[1][2], Voltage_Offset[2][2], Voltage_Offset[3][2]);
			printf("* CH 1 V  3 : %3d    CH 2 V  3 : %3d    CH 3 V  3 : %3d    CH 4 V  3 : %3d  *\n", Voltage_Offset[0][3], Voltage_Offset[1][3], Voltage_Offset[2][3], Voltage_Offset[3][3]);
		
			printf("*****************************************************************************\n");
			printf("\n");

			break;
		}  	
	}
	if (Splash_drawed == false) UpdateMenuTextPlane = true;
}	

//######################################################################################################################################################

// BF insert
//Function button 1 pressed
void Hardware::F1_Btnhandler(void)					// Button Handler for function button
{ 

	short pos = 0;
	int ix;

#ifdef _Debug_		
       	printf("F1 Btn start\n");
#endif

	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;	// BF del ???

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(0);
	
	switch(Active_Menu)
	{
		// Acquire -> Normal
		case 0 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[0][0] == 0)
			{
				MenuStatus[0][1]   = 0;
				MenuItemChanged[1] = 1;
														
				MenuStatus[0][0]   = 1;
				MenuItemChanged[0] = 1;

				New_Menu = 0;
				Menu_Changed = 1;
				
				if (MenuStatus[0][1] == 1) Set_LED(5);
				else Reset_LED(5);						
			}
				
			break;	
		}				

		// Channel 1 -> Coupling
		case 1 :
		{

			if (Channel_1_Active == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 13)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 13)
			{
				pos = -1;
				MenuPopupStep(13, &MenuStatus[1][0], &pos, &pos, 1, 6, 2);
			}

			New_Menu = 1;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(13);
			
			SetSwitches(1, -1);

			//S Display::Update_Channel_Data(1);
		
			break;
		}

		// Channel 2 -> Coupling
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 14)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 14)
			{
				pos = -1;
				MenuPopupStep(14, &MenuStatus[2][0], &pos, &pos, 2, 6, 2);

			}				

			New_Menu = 2;
			Menu_Changed = 1;
								
			Display::DRAWMENUPOPUP(14);
			
			SetSwitches(1, -1);

			//S Display::Update_Channel_Data(2);
	
			break;
		}

		// Channel 3 -> Coupling
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 15)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 15)
			{
				pos = -1;
				MenuPopupStep(15, &MenuStatus[3][0], &pos, &pos, 3, 6, 2);
			}				

			New_Menu = 3;
			Menu_Changed = 1;
							
			Display::DRAWMENUPOPUP(15);
			
			SetSwitches(1, -1);

			//S Display::Update_Channel_Data(3);

			break;
		}

		// Channel 4 -> Coupling
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 16)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 16)
			{
				pos = -1;
				MenuPopupStep(16, &MenuStatus[4][0], &pos, &pos, 4, 6, 2);
			}				

			New_Menu = 4;
			Menu_Changed = 1;
				
			Display::DRAWMENUPOPUP(16);
			
			SetSwitches(1, -1);
			
			//S Display::Update_Channel_Data(4);

			break;
		}						

		// Display -> Persist
		case 5 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[5][0] == 240) MenuStatus[5][0] = 241;
			else MenuStatus[5][0] = 240;
			
			New_Menu = 5;
			Menu_Changed = 1;
	
			break;
		}		

		// Utility -> Calibrate Zero Lines
		case 6 :
		{
			UserIface_active = 0;

			Search_Step = 0;           		
			Search_Mode = true;
#ifdef _Debug_
			if (Debug_Mode)
			{
				if (Search_Mode) printf("Search Mode enabled\n");
				else printf("Search Mode disabled\n");
			}

					//printf("SearchResult : %i\n", );
#endif
			Hardware::SearchZeros();
	
			if (Continius)
			{
				LED_ON[12] = 1;
				LED_ON[13] = 0;
				Send_LED();
			}

			break;		
		}					             	
		
		// Timebase -> Main
		case 10 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[10][0] == 0)	//Check if main mode is not active
			{
				//dmode_Window_Offset_Pos++; // for removing the cursor from delayed mode
	
				Display_Mode = 0; // Set first XY-mode off, needed in On_Zero
			
				if (MenuStatus[10][1] == 1)		//Delayed mode active?
				{			
					MenuItemChanged[1] = 1;
					MenuStatus[10][1] = 0;		//switch delayed mode off
									
				}
				else if (MenuStatus[10][2] == 1)	//XY-mode active?	
				{
					ZeroLevelCH1         = ZeroLevelCH1_XY_bak;
					Virtual_ZeroLevelCH1 = VZeroLevelCH1_XY_bak;
					ZeroLevelCH2         = ZeroLevelCH2_XY_bak;
					Virtual_ZeroLevelCH2 = VZeroLevelCH2_XY_bak;
					
					ON_Zero_Channel_1();
					ON_Zero_Channel_2();

					MenuItemChanged[2] = 1;
					MenuStatus[10][2] = 0;		//switch XY-mode off
					//DoDisableTimer2Interrupt();
				}

/* 
				else if (MenuStatus[10][3] == 1)	//rollmode active?
				{
					MenuItemChanged[3] = 1;
					MenuStatus[10][3] = 0;

				}
*/				
				ROLLMODE_STARTED = false;

				//BF transfered from above
				//Draw main grid into grid plane
				Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);		
				GridColor_Val = GridColorArray[GridColorArrayPos];
				SetupADC();
				MenuStatus[5][2] = GridColorArrayPos + 133;	
				//BF end

				MenuStatus[10][0] = 1;	//Main mode active
			
				TimebaseChanged     = 1;
				TriggerWayChanged   = 1;
				TriggerModeChanged  = 1;
				TriggerLevelChanged = 1;
	
				Display::StatusUpdate();
	
				New_Menu     = 10;
				Menu_Changed = 1;
				ClearPlanes();			
			}
			
			Display::DRAW_ALL_CURSOR();	
			
			UpdateTrigger(20);
				
			break;		
		}

		// Trigger Mode -> Mode
		case 12 :
		{
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 9)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 9)
			{
				pos = -1;
				MenuPopupStep(9, &MenuStatus[12][0], &pos, &pos, 12, 93, 2);						
				
				New_Menu = 12;
				Menu_Changed = 1;
				TriggerLevelChanged = 1;
				TriggerModeChanged = 1;
		
				UpdateTrigger(4);
				
				Display::StatusUpdate();						
			}				
			
			Display::DRAWMENUPOPUP(9);
			break;
		}			

		// Edge -> Rising/Falling
		case 14 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[14][0] == 2) MenuStatus[14][0] = 3;
			else MenuStatus[14][0] = 2;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			UpdateTrigger(5);					
			
			New_Menu = 14;
			Menu_Changed = 1;

			Display::StatusUpdate();
								
			break;	
		
		}		

		// Pulse Width -> Source
		case 15 :
		{		
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 7)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 7)
			{
				pos = -1;
				MenuPopupStep(7, &MenuStatus[15][0], &pos, &pos, 15, 138, 2);
				
				New_Menu = 15;
				Menu_Changed = 1;
				TriggerWayChanged = 1;
			}				
			
			Display::StatusUpdate();		
			Display::DRAWMENUPOPUP(7);
			
			UpdateTrigger(6);
			
			break;			
		}				
	
		// Cursor -> Source
		case 16 :
		{
			if (Cursor_Enabled == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 1)) Display::DRAWMENUPOPDOWN();
			if (MenuPopupActive == 1)
			{
				pos = -1;
				MenuPopupStep(1, &MenuStatus[16][0], &pos, &pos, 16, 27, 2);
				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;
				Display::CALCCURSORDATA();
				
				CursorChanged = 3;
				New_Menu = 16;
				Menu_Changed = 1;
			}
			else if (MenuPopupActive == -1)
			{
				New_Menu = 16;
				Menu_Changed = 1;
			}
			Display::DRAWMENUPOPUP(1);

			break;
		}
		
		// Quick Print -> Print to Printer
		case 17 :
		{		
			if (USB_Connected == false) break;
		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (MenuStatus[17][2] == 143) MenuStatus[17][2] = 144;
			//else MenuStatus[17][2] = 143;

			MenuItemChanged[0] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;


			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{					
				send_buffer[0] = 150;			// Command Quick Print requested
				send_buffer[1] = 0;                     // Printer ??
				send_buffer[2] = 0;
						
				SendData(send_buffer);					
			}
							
			break;					
		}
		
//BF???				// Getting Started
		case 18 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
//P			Display::PopUp(1);
			break;
		}		
		
		// Quick Measurement -> Source
		case 19 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
		
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 3)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 3)
			{
				pos = -1;
				MenuPopupStep(3, &MenuStatus[19][0], &pos, &pos, 19, 27, 2);
				
				New_Menu = 19;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(3);
			break;
		}	
		
		// Quick Measurement Delay Settings
		case 20 :
		{	
		//if (MenuStatus[10][2] == 1) break;
		
		if (QM_Enabled == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 5)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 5)
			{
				pos = -1;
				MenuPopupStep(5, &MenuStatus[20][0], &pos, &pos, 20, 27, 2);
				
				New_Menu = 20;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(5);
			break;
		}	

		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 24)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 24)
			{
				pos = -1;
				MenuPopupStep(24, &MenuStatus[21][0], &pos, &pos, 21, 27, 2);
				
				New_Menu = 21;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(24);
			break;
		}	

		// Quick Measurement Thresholds
		case 22 :
		{	
			//if (MenuStatus[10][2] == 1) break;

			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 26)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 26)
			{
				pos = -1;
				MenuPopupStep(26, &MenuStatus[22][0], &pos, &pos, 22, 27, 2);
			}

			New_Menu = 22;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(26);					
			
			
			break;
		}	

		// AutoScale -> Undo
		case 23 :
		{
			Selected_Timebase = Selected_Timebase_bak;
			SIGNALFaktor_idx = SIGNALFaktor_idx_bak;
			SIGNAL_StartFr_idx = SIGNAL_StartFr_idx_bak;
			timebase_reg = timebase_reg_bak;
			Display_Timebase = Display_Timebase_bak;

			Selected_Voltage_CH1 = Selected_Voltage_CH1_bak;
			Selected_Voltage_CH2 = Selected_Voltage_CH2_bak;
			Selected_Voltage_CH3 = Selected_Voltage_CH3_bak;
			Selected_Voltage_CH4 = Selected_Voltage_CH4_bak;
	
			ZeroLevelCH1 = ZeroLevelCH1_bak;            	
			ZeroLevelCH2 = ZeroLevelCH2_bak;
			ZeroLevelCH3 = ZeroLevelCH3_bak;
			ZeroLevelCH4 = ZeroLevelCH4_bak;
	
			Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_bak;            	
			Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_bak;
			Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_bak;
			Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_bak;
	
			Trigger_Pos_CH1 = Trigger_Pos_CH1_bak;
			Trigger_Pos_CH2 = Trigger_Pos_CH2_bak;
			Trigger_Pos_CH3 = Trigger_Pos_CH3_bak;
			Trigger_Pos_CH4 = Trigger_Pos_CH4_bak;
	
			Timebase_Offset_Pos = Timebase_Offset_Pos_bak;
			Trigger_Offset_Pos = Trigger_Offset_Pos_bak;
	
			MenuStatus[1][0] = AC_CH1_bak;
			MenuStatus[2][0] = AC_CH2_bak;
			MenuStatus[3][0] = AC_CH3_bak;
			MenuStatus[4][0] = AC_CH4_bak;
			
			MenuStatus[1][2] = Invert_CH1_bak;
			MenuStatus[2][2] = Invert_CH2_bak;
			MenuStatus[3][2] = Invert_CH3_bak;
			MenuStatus[4][2] = Invert_CH4_bak;
	
			MenuStatus[10][0] = MAINMODE_bak;
			//MenuStatus[10][2] = ROLLMODE_bak;
			ROLLMODE_STARTED = ROLLMODESTARTED_bak;
	
			MenuStatus[0][0] = Acquire_bak_0;
			MenuStatus[0][1] = Acquire_bak_1;		
	
			MenuStatus[12][0] = AUTOMODE_bak;

			if (MenuStatus[12][0] == 93)
			{
				MenuPopupStatus[9][0] = 3;
				MenuPopupStatus[9][1] = 2;
			}
			else
			{
				MenuPopupStatus[9][0] = 2;
				MenuPopupStatus[9][1] = 3;
			}                    	
	
			if (Channel_1_Active)
			{
				SetDacOffset(1);
				SetCHDacOffset(1);
				SetSwitches(1, Selected_Voltage_CH1);
			}
	
			if (Channel_2_Active)
			{
				SetDacOffset(2);
				SetCHDacOffset(2);
				SetSwitches(2, Selected_Voltage_CH2);
			}

			if (NumberOfChannels > 2)
			{
				if (Channel_3_Active)
				{
					SetDacOffset(3);
					SetCHDacOffset(3);
					SetSwitches(3, Selected_Voltage_CH3);
				}
	
				if (Channel_4_Active)
				{
					SetDacOffset(4);
					SetCHDacOffset(4);
					SetSwitches(4, Selected_Voltage_CH4);
				}
			}

			timebase_reg = tb_value[Selected_Timebase];

			UpdateTrigger(31);
	
			if (Cursor_Enabled)
			{
				Display::CALCCURSORDATA();
				Menu_Changed = 1;
				CursorChanged = 4;
			}
	
			if (QM_Enabled)
			{
				Display::CALCQMDATA();
				Menu_Changed = 1;
			}

			VoltageChangedCh1 = 1;
			Display::DRAWSTATUS(1, 0);
			Rotary_Steps = 0;
			ON_Zero_Channel_1();
	
			VoltageChangedCh2 = 1;
			Display::DRAWSTATUS(2, 0);
			Rotary_Steps = 0;
			ON_Zero_Channel_2();

			if (NumberOfChannels > 2)
			{
				VoltageChangedCh3 = 1;
				Display::DRAWSTATUS(3, 0);
				Rotary_Steps = 0;
				ON_Zero_Channel_3();
	
				VoltageChangedCh4 = 1;
				Display::DRAWSTATUS(4, 0);
				Rotary_Steps = 0;
				ON_Zero_Channel_4();
			}
			Display::DRAWSTATUS(6, 0);


			break;
		}

		// Trigger Mode TV
		case 24 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			break;
		}
	
		// Math - Settings
		case 26 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			MenuItemChanged[2] = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
	
			if (MenuStatus[26][1] == 1)	New_Menu = 27;		// FFT Settings Menu
			else if (MenuStatus[26][2] == 1) New_Menu = 29;		// Math Settings Menu
			else if (MenuStatus[26][3] == 1) New_Menu = 29;		// Math Settings Menu
			else if (MenuStatus[26][4] == 1) New_Menu = 29;		// Math Settings Menu						

			Menu_Changed = 1;
		
		//printf("We are here and NewMenu is %d Active_Menu is %d MenuAktive is %d\n", New_Menu, Active_Menu, MenuAktive);
			
			break;
		}
		
		// FFT - Settings - Channel
		case 27 :
		{	
			//if (MenuStatus[10][2] == 1) break;
	
			if ((MenuPopupActive > -1) && (MenuPopupActive != 29)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 29)
			{
				pos = -1;
				MenuPopupStep(29, &MenuStatus[27][0], &pos, &pos, 27, 138, 2);
			}

			New_Menu = 27;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(29);					
			
			
			break;
		}					
		
		// Math Settings Scale
		case 29 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			MathToggle = 0;
			
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;
			MenuItemChanged[1] = 1;
			
			break;
		}				
	}					
#ifdef _Debug_			
			if (Debug_Mode) printf("Function Button 1\n");		
#endif
}
// BF insert end
//######################################################################################################################################################

// BF insert
//Function button 2 pressed
void Hardware::F2_Btnhandler(void)					// Button Handler for function button
{

	short pos = 0;
	int ix, result;

#ifdef _Debug_		
       	printf("F2 Btn start\n");
#endif

	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(1);
			
	switch(Active_Menu)
	{
		// Acquire -> Averaging
		case 0 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[0][1] == 0)
			{
				MenuItemChanged[0] = 1;
				MenuStatus[0][0] = 0;
		
				MenuItemChanged[1] = 1;
				MenuStatus[0][1] = 1;

				New_Menu = 0;
				Menu_Changed = 1;
			}
				
			break;							
		}

		// Channel 1 -> BW Linit
		case 1 :
		{
			if (Channel_1_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[1][1] == 240) MenuStatus[1][1] = 241;
			else MenuStatus[1][1] = 240;					
			
			SetSwitches(1, -1);

			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 2 -> BW Linit
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[2][1] == 240) MenuStatus[2][1] = 241;
			else MenuStatus[2][1] = 240;
			
			SetSwitches(2, -1);

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 3 -> BW Linit
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[3][1] == 240) MenuStatus[3][1] = 241;
			else MenuStatus[3][1] = 240;
			
			SetSwitches(3, -1);

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 4 -> BW Limit
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[4][1] == 240) MenuStatus[4][1] = 241;
			else MenuStatus[4][1] = 240;
			
			SetSwitches(4, -1);

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}		

		// Display -> Clear Display
		case 5 :
		{		
			if ((Continius == false) || (MenuStatus[5][0] == 241)) ClearPlanes();
			break;
		}
		
		// Utility
		case 6 :
		{		
			Continius = false;
			ClearPlanes();
			Display::DRAW_SPLASH(false);
			break;
		}				
				
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Save
		case 8 :
		{	
			//&~np_timercontrol_cont_mask;	// Stop Timer
			timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);
			timer_rotary_busy->np_timerstatus = 0;
	
			Display::DRAWROUNDBUTTON(250, 200, 140, 40, 0, 0);
			Display::TEXTOUTxvbig("Saving Signals", 260, 212, 1, UI_Plane2);
#ifdef _Debug_
			printf("Lets save a signal %d\n", SavePointer);
#endif
			switch(SavePointer)
			{
				case 1 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A01); break;
				case 2 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A02); break;
				case 3 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A03); break;
				case 4 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A04); break;
				case 5 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A05); break;
				case 6 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A06); break;
				case 7 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A07); break;
				case 8 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A08); break;
				case 9 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A09); break;
				case 10 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A10); break;
				case 11 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A11); break;
				case 12 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A12); break;
				case 13 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A13); break;
				case 14 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A14); break;
				case 15 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A15); break;
				case 16 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_A16); break;
	
				case 17 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B01); break;
				case 18 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B02); break;
				case 19 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B03); break;
				case 20 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B04); break;
				case 21 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B05); break;
				case 22 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B06); break;
				case 23 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B07); break;
				case 24 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B08); break;
				case 25 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B09); break;
				case 26 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B10); break;
				case 27 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B11); break;
				case 28 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B12); break;
				case 29 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B13); break;
				case 30 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B14); break;
				case 31 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B15); break;
				case 32 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_B16); break;
	
				case 33 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C01); break;
				case 34 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C02); break;
				case 35 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C03); break;
				case 36 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C04); break;
				case 37 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C05); break;
				case 38 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C06); break;
				case 39 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C07); break;
				case 40 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C08); break;
				case 41 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C09); break;
				case 42 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C10); break;
				case 43 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C11); break;
				case 44 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C12); break;
				case 45 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C13); break;
				case 46 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C14); break;
				case 47 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C15); break;
				case 48 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_C16); break;
	
				case 49 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D01); break;
				case 50 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D02); break;
				case 51 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D03); break;
				case 52 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D04); break;
				case 53 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D05); break;
				case 54 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D06); break;
				case 55 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D07); break;
				case 56 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D08); break;
				case 57 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D09); break;
				case 58 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D10); break;
				case 59 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D11); break;
				case 60 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D12); break;
				case 61 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D13); break;
				case 62 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D14); break;
				case 63 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D15); break;
				case 64 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_D16); break;
	
				case 65 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E01); break;
				case 66 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E02); break;
				case 67 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E03); break;
				case 68 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E04); break;
				case 69 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E05); break;
				case 70 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E06); break;
				case 71 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E07); break;
				case 72 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E08); break;
				case 73 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E09); break;
				case 74 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E10); break;
				case 75 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E11); break;
				case 76 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E12); break;
				case 77 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E13); break;
				case 78 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E14); break;
				case 79 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E15); break;
				case 80 :	result = AMDFlash::copy_signal_to_flash(SAVE_SIGNAL_NR_E16); break;
	
			}

			Display::DRAWROUNDBUTTON(250, 200, 140, 40, 0, 1);
			Display::TEXTOUTxvbig("Saving Signals", 260, 212, 0, UI_Plane2); 
			break;
		}
		
		// Timebase -> Delayed Mode (function button 2)
		case 10 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[10][1] == 0)				//Check delayed mode not active yet
			{
				if (MenuStatus[10][0] == 1)			//main mode active?
				{
					MenuItemChanged[0] = 1;
					MenuStatus[10][0]  = 0;			//switch off main mode
				}			
				else if (MenuStatus[10][2] == 1)		//XY-mode active?
				{
					Display_Mode 	     = 0;
					ZeroLevelCH1         = ZeroLevelCH1_XY_bak;
					Virtual_ZeroLevelCH1 = VZeroLevelCH1_XY_bak;
					ZeroLevelCH2         = ZeroLevelCH2_XY_bak;
					Virtual_ZeroLevelCH2 = VZeroLevelCH2_XY_bak;
					
					ON_Zero_Channel_1();
					ON_Zero_Channel_2();
					
					MenuItemChanged[2] = 1;
					MenuStatus[10][2]  = 0;			//switch off XY-mode
					//DoDisableTimer2Interrupt();	
				}
/*
				else if (MenuStatus[10][3] == 1)		//roll mode active?
				{
					MenuItemChanged[3] = 1;
					MenuStatus[10][3] = 0;
				}
*/					
				else if (MenuStatus[26][1] == 1)		//FFT active?
				{
					MenuItemChanged[1] = 1;
					MenuStatus[26][1]  = 0;			//Switch off FFT
					MenuStatus[26][3]  = 1;			//Set 1 - 2 as default
					MenuItemChanged[3] = 1;
					if (Channel_Math_Active)		//Math function active?
					{
						LED_ON[4] = 0;
						Channel_Math_Active = 0;	//switch off math function
					}
	
					Send_LED();

				}


				MenuStatus[10][1] = 1;

				New_Menu     = 10;
				Menu_Changed = 1;

				//Draw grid for delayed mode	BF insert
				Display::GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);
				// BF end
				
				GridColor_Val = GridColorArray[GridColorArrayPos_Delayed];
				SetupADC();
							
				MenuStatus[5][2] = GridColorArrayPos_Delayed + 133;
			}
			
			dmode_SIGNAL_StartFr_idx = SIGNAL_StartFr_idx;
			dmode_Selected_Timebase  = Selected_Timebase;
			dmode_SIGNALFaktor_idx   = SIGNALFaktor_idx;
	
			if (dmode_SIGNALFaktor_idx == 0)
				dmode_Selected_Timebase--;
			else
				dmode_SIGNALFaktor_idx--;
	
			dmode_factor = Timebase_Delayed_Factor_Matrix[Selected_Timebase][SIGNALFaktor_idx] / Timebase_Delayed_Factor_Matrix[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx];
	
			Cursor_Delayed_1 = ((GRID_WIDTH/2) - (int) (((float) GRID_WIDTH / dmode_factor) / 2)) + dmode_Window_Offset_Pos;
			Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / dmode_factor);
			Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;
	
			Recalc_Vars();
			
			Display::DRAW_ALL_CURSOR();
			ClearPlanes();
	
			TimebaseChanged     = 1;
			SIGNALFaktorChanged = 1;
				
			Display::DRAWSTATUS(0, 1);
				
			break;							
		}
	
		// Trigger Mode -> Coupling
		case 12 :
		{
			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 10)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 10)
			{
				pos = -1;
				MenuPopupStep(10, &MenuStatus[12][1], &pos, &pos, 12, 95, 2);
				
				New_Menu = 12;
				Menu_Changed = 1;
			}				
			
			UpdateTrigger(23);	
			
			Display::DRAWMENUPOPUP(10);
			break;
		}					
	
		// Edge -> source
		case 14 :
		{	
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 28)) { Display::DRAWMENUPOPDOWN(); }

			if ((MenuPopupStatus[28][0] != 3) && (MenuPopupStatus[28][1] != 3) && (MenuPopupStatus[28][2] != 3) 
				&& (MenuPopupStatus[28][3] != 3))
			{
				if (Channel_1_Active) MenuPopupStatus[28][0] = 3;
				else if (Channel_2_Active) MenuPopupStatus[28][1] = 3;
				else if (Channel_3_Active) MenuPopupStatus[28][2] = 3;
				else if (Channel_4_Active) MenuPopupStatus[28][3] = 3;
			}

			if (MenuPopupActive == 28)
			{
				pos = -1;
				MenuPopupStep(28, &MenuStatus[14][1], &pos, &pos, 28, 138, 2);
				
				New_Menu = 14;
				Menu_Changed = 1;
			}	

			if (MenuPopupStatus[28][0] == 3) MenuStatus[14][1] = 138;
			else if (MenuPopupStatus[28][1] == 3) MenuStatus[14][1] = 139;
			else if (MenuPopupStatus[28][2] == 3) MenuStatus[14][1] = 140;
			else if (MenuPopupStatus[28][3] == 3) MenuStatus[14][1] = 141;
	
			MenuItemChanged[1] = 1;	
				
			MenuStatus[14][2] = 0;
			MenuItemChanged[2] = 1;	
		
			MenuStatus[14][3] = 0;
			MenuItemChanged[3] = 1;

			Display::DRAWMENUPOPUP(28);
			
			Selected_Trigger_Source = MenuStatus[14][1] - 137;
			SelectedEdgeExtern = 0;               // No External
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;		
				
			Display::StatusUpdate();
				
			UpdateTrigger(7);					
			
			break;
		}				
		
		// Pulse Width -> Pulse
		case 15 :
		{
			break;
			/*
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[15][1] == 2) MenuStatus[15][1] = 3;
			else MenuStatus[15][1] = 2;

			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;

			Display::StatusUpdate();
			
			UpdateTrigger(8);
			
			break;	
			*/
		}
	
		// Cursor -> X1
		case 16 :
		{	
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
						
				if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
						
				Cursor_Vertical_Active = 1;
				Cursor_Horizontal_Active = 3;
	
				Display::CALCCURSORDATA();
							
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;				
		}
		
		// Quick Print -> Save to BMP
		case 17 :
		{		
			if (USB_Connected == false) break;
		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (MenuStatus[17][2] == 143) MenuStatus[17][2] = 144;
			//else MenuStatus[17][2] = 143;

			MenuItemChanged[1] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;


			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{					
				send_buffer[0] = 150;			// Command Quick Print requested
				send_buffer[1] = 1;                     // BMP
				send_buffer[2] = 0;
						
				SendData(send_buffer);					
			}
							
			break;					
		}				
			
		// Start screen - disabled
		case 18 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			break;
		}	
	
		// Quick Measurement -> Select
		case 19 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 4)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 4)
			{
				MenuPopupStep(4, &MenuStatus[19][1], &MenuStatus[19][2], &MenuStatus[20][4], 19, 52, 2);
				MenuStatus[21][4] = MenuStatus[20][4];
	
				if (((MenuStatus[19][1] - 52) == 4) || ((MenuStatus[19][1] - 52) == 13))
				{
				if (MenuStatus[19][4] == 244) MenuItemChanged[4] = 1;
				MenuStatus[19][4] = 242;
				}
				else
				{
				if (MenuStatus[19][4] == 242) MenuItemChanged[4] = 1;
				MenuStatus[19][4] = 244;
				}
	
				MenuItemChanged[1] = 1;
				MenuItemChanged[2] = 1;		
						
				New_Menu = 19;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(4);
			
			ResetTimer();
			
			break;
		}	
	
		// Quick Measurement Settings
		case 20 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[20][1] == 2) MenuStatus[20][1] = 3;
			else MenuStatus[20][1] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}
	
		// Quick Measurement Thresholds
		case 22 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 27)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 27)
			{
				pos = -1;
				MenuPopupStep(27, &MenuStatus[22][1], &pos, &pos, 22, 49, 2);

				New_Menu = 22;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(27);
			break;
		}


		// Autoscale -> Slow TB
		case 23 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[23][1] == 240) MenuStatus[23][1] = 241;
			else MenuStatus[23][1] = 240;
			
			MenuItemChanged[1] = 1;
			New_Menu = 23;
			Menu_Changed = 1;
			
			break;
		}
	
	
		// Trigger Mode TV
		case 24 :
		{
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[24][1] == 2) MenuStatus[24][1] = 3;
			else MenuStatus[24][1] = 2;		
		
			New_Menu = 24;
			Menu_Changed = 1;

			break;	
		}	
	
		// Math - FFT
		case 26 :
		{		
			//BF change activate FFT again
			//break;		// TMW broke here to disable FFT
			//BF change end
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[26][1] == 0)
			{
				if (MenuStatus[26][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[26][2] = 0;
				}
				
				else if (MenuStatus[26][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[26][3] = 0;
				}
				
				else if (MenuStatus[26][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[26][4] = 0;
				}

				MenuStatus[26][1] = 1;

				New_Menu = 26;
				Menu_Changed = 1;
			}
				
			break;				
		}

		// FFT - Settings - Window
		case 27 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 30)) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 30)
			{
				pos = -1;
				MenuPopupStep(30, &MenuStatus[27][1], &pos, &pos, 27, 182, 2);
				New_Menu = 27;
				Menu_Changed = 1; 	
			}
			
			Display::DRAWMENUPOPUP(30);	
			
			break;
		}
		
		
		// FFT - Settings - Scale	BF reactivated
		case 28 :	// BF Changed case 27 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
		
			FFTToggle = 0;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;	

			New_Menu = 27;
			Menu_Changed = 1;	

			break;
		}				
		
		// Math Settings Offset
		case 29 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			MathToggle = 1;
			
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;
			MenuItemChanged[1] = 1;
			
			break;
		}				
	}					
#ifdef _Debug_			
	if (Debug_Mode) printf("Function Button 2\n");		
#endif

}
// BF insert end
//######################################################################################################################################################

// BF insert
//Function button 3 pressed
void Hardware::F3_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;
	int ix;

#ifdef _Debug_		
       	printf("F3 Btn start\n");
#endif	

	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	
	MenuButtonCheck(2);

	switch(Active_Menu)
	{	
		// Channel 1 -> Invert
		case 1 :
		{
			if (Channel_1_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[1][2] == 240) MenuStatus[1][2] = 241;
			else MenuStatus[1][2] = 240;

			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			UpdateTrigger(55);						
			Display::StatusUpdate();

			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 2 -> Invert
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[2][2] == 240) MenuStatus[2][2] = 241;
			else MenuStatus[2][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			UpdateTrigger(56);						
			Display::StatusUpdate();

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 3 -> Invert
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[3][2] == 240) MenuStatus[3][2] = 241;
			else MenuStatus[3][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			UpdateTrigger(57);						
			Display::StatusUpdate();

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 4 -> Invert
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[4][2] == 240) MenuStatus[4][2] = 241;
			else MenuStatus[4][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			UpdateTrigger(58);
			Display::StatusUpdate();

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}		
			
		// Utility
		case 6 :
		{		
			FindSlope();
			break;
		}
					
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Recall Signal
		case 8 :
		{	
			//if (MenuStatus[10][2] == 1) DoDisableTimer2Interrupt();
	
			switch(SavePointer)
			{
				case 1 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A01); break;
				case 2 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A02); break;
				case 3 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A03); break;
				case 4 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A04); break;
				case 5 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A05); break;
				case 6 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A06); break;
				case 7 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A07); break;
				case 8 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A08); break;
				case 9 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A09); break;
				case 10 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A10); break;
				case 11 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A11); break;
				case 12 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A12); break;
				case 13 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A13); break;
				case 14 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A14); break;
				case 15 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A15); break;
				case 16 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_A16); break;
	
				case 17 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B01); break;
				case 18 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B02); break;
				case 19 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B03); break;
				case 20 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B04); break;
				case 21 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B05); break;
				case 22 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B06); break;
				case 23 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B07); break;
				case 24 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B08); break;
				case 25 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B09); break;
				case 26 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B10); break;
				case 27 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B11); break;
				case 28 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B12); break;
				case 29 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B13); break;
				case 30 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B14); break;
				case 31 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B15); break;
				case 32 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_B16); break;
	
				case 33 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C01); break;
				case 34 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C02); break;
				case 35 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C03); break;
				case 36 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C04); break;
				case 37 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C05); break;
				case 38 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C06); break;
				case 39 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C07); break;
				case 40 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C08); break;
				case 41 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C09); break;
				case 42 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C10); break;
				case 43 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C11); break;
				case 44 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C12); break;
				case 45 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C13); break;
				case 46 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C14); break;
				case 47 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C15); break;
				case 48 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_C16); break;
	
				case 49 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D01); break;
				case 50 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D02); break;
				case 51 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D03); break;
				case 52 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D04); break;
				case 53 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D05); break;
				case 54 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D06); break;
				case 55 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D07); break;
				case 56 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D08); break;
				case 57 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D09); break;
				case 58 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D10); break;
				case 59 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D11); break;
				case 60 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D12); break;
				case 61 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D13); break;
				case 62 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D14); break;
				case 63 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D15); break;
				case 64 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_D16); break;
	
				case 65 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E01); break;
				case 66 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E02); break;
				case 67 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E03); break;
				case 68 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E04); break;
				case 69 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E05); break;
				case 70 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E06); break;
				case 71 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E07); break;
				case 72 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E08); break;
				case 73 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E09); break;
				case 74 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E10); break;
				case 75 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E11); break;
				case 76 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E12); break;
				case 77 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E13); break;
				case 78 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E14); break;
				case 79 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E15); break;
				case 80 :	AMDFlash::load_signal_from_flash(SAVE_SIGNAL_NR_E16); break;
			}

			break;
		}

		// Print
		case 9 :
		{		
	//
			break;
		}

		// Timebase-> X-Y Mode (button 3 pressed)
		case 10 :
		{		
			if ((Channel_1_Active == false) || (Channel_2_Active == false)) break;
			
			printf("MA : %d L4 : %d \n", Channel_Math_Active, LED_ON[4]);
			
			ZeroLevelCH1_XY_bak  = ZeroLevelCH1;
			VZeroLevelCH1_XY_bak = Virtual_ZeroLevelCH1;
			ZeroLevelCH2_XY_bak  = ZeroLevelCH2;
			VZeroLevelCH2_XY_bak = Virtual_ZeroLevelCH2;
		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[10][2] == 0)				//Check if XY-mode is active yet
			{
				if (MenuStatus[10][0] == 1)			//main mode active?
				{
					MenuItemChanged[0] = 1;
					MenuStatus[10][0]  = 0;			//switch off main mode
				}
				else if (MenuStatus[10][1] == 1)		//delayed mode active?
				{				
					MenuItemChanged[1] = 1;
					MenuStatus[10][1]  = 0;			//switch off delayed mode
				}
				
				if (QM_Enabled)
				{
					QM_Enabled_Old           = QM_Enabled;
					QM_Enabled               = false;
					Quick_Measure_First_Draw = 0;
					MenuStatusChanged        = 1;
		
					// remove the cursor data
					for (ix = 408 * 20; ix < 430 * 20; ix++)
					{
						*(UI_Plane1 + ix) = 0;	// delete
						*(Buffer_UI2Plane + ix) = 0;	// delete Text	
						*(UI_Plane4 + ix) = 0;	// delete
						*(UI_Plane5 + ix) = 0;	// delete
					}
		
					LED_ON[7] = 0;
						
					//New_Menu = 19;
					Menu_Changed = 1;
					//MenuAktive = 0;
						
					Display::CALCQMDATA();
				}

				if (Channel_Math_Active)		//Math function active?
				{
					LED_ON[4] = 0;
					Channel_Math_Active = 0;	//switch off math function
				}
	
				Send_LED();
		
				//Draw XY-grid into the grid plane
				Display::GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);
				
				GridColor_Val = GridColorArray[GridColorArrayPos];
				SetupADC();
						
				MenuStatus[5][2] = GridColorArrayPos + 133;

				Display_Mode 	     = 1;
				Virtual_ZeroLevelCH1 = 0;
				Virtual_ZeroLevelCH2 = 0;
				
				ON_Zero_Channel_1();
				ON_Zero_Channel_2();
							
				MenuStatus[10][2] = 1;			//Switch XY-mode on
				
				New_Menu     = 10;
				Menu_Changed = 1;
				
				Display::DRAWSTATUS(0, 1);
				ClearPlanes();
			}
			
			Display::DRAW_ALL_CURSOR();

			printf("MA2 : %d L4 : %d \n", Channel_Math_Active, LED_ON[4]);
				
			break;							
		}
					     /*
		// Timebase-> Roll Mode
		case 10 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[10][2] == 0)
			{
				if (MenuStatus[10][0] == 1)
				{
					MenuItemChanged[0] = 1;
					MenuStatus[10][0] = 0;
				}
				else if (MenuStatus[10][1] == 1)
				{				
				for (ix = 380; ix < 8120; ix++) //400
				{
					Grid_Plane[ix] = *(Grid_Plane_Flash + ix);
	
					if (tc_hw_version < 0x4c7) {if ((ix % 20) == 0) Grid_Plane[ix] = Grid_Plane[ix] << 2;} // Gap
				}
				MenuItemChanged[1] = 1;
				MenuStatus[10][1] = 0;
								
				GridColor_Val = GridColorArray[GridColorArrayPos];
				SetupADC();
							
				MenuStatus[5][2] = GridColorArrayPos + 133;	

				}						
				else if (MenuStatus[10][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[10][3] = 0;
				}						
				
				MenuStatus[10][2] = 1;
				
				TimebaseChanged = 1;
				TriggerWayChanged = 1;
				TriggerModeChanged = 1;
				TriggerLevelChanged = 1;
	
				QM_Type_Old[0] = QM_Type[0];
				QM_Type_Old[1] = QM_Type[1];
				QM_Type_Old[2] = QM_Type[2];				
					
				QM_Type[0] = 0;
				QM_Type[1] = 0;
				QM_Type[2] = 0;
	
				QM_Channel[0] = MenuStatus[19][0] - 26;
				QM_Channel[1] = MenuStatus[19][0] - 26;
				QM_Channel[2] = MenuStatus[19][0] - 26;
	
				QM_Changed[0] = 0;
				QM_Changed[1] = 0;
				QM_Changed[2] = 0;
	
				Quick_Measure_First_Draw = 1;
	
				LED_ON[5] = 0;
				LED_ON[7] = 0;
	
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = false;
	
				QM_Vertical_Active = 0;
				QM_Horizontal_Active = 0;
	
				Display::CALCQMDATA();
	
				Display::StatusUpdate();

				New_Menu = 10;
				Menu_Changed = 1;
				Display_Mode = 0;
				ROLLMODE_Value_rec = false;
	
				ClearPlanes();
				ROLLMODE_OFFSET = 601;
				SetSwitches(1, -1);
			}
			
			Display::DRAW_ALL_CURSOR();	
			
			UpdateTrigger(21);
				
			break;							
		}   */
	
		// Trigger Mode -> Reject
		case 12 :
		{
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 12)) { Display::DRAWMENUPOPDOWN(); }
		
			if (MenuPopupActive == 12)
			{
				if (MenuPopupStatus[12][0] == 3)	
				{
					MenuPopupStatus[12][0] = 2;
					MenuPopupStatus[12][1] = 3;
					MenuStatus[12][2] = 98;
				}
				else if (MenuPopupStatus[12][1] == 3)	
				{
					MenuPopupStatus[12][0] = 3;
					MenuPopupStatus[12][1] = 2;
					MenuStatus[12][2]      = 97;
				}

				New_Menu           = 12;
				Menu_Changed       = 1;
				MenuItemChanged[2] = 1;

				//UpdateTrigger();    						
			}

			Display::DRAWMENUPOPUP(12);
			break;
		}

		// Edge -> External
		case 14 :
		{				
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 8)) { Display::DRAWMENUPOPDOWN(); }			

#ifdef _Debug_						
printf("MPA1 %d SEE %d MPS[8][0] %d MPS[8][1] %d MPS[8][2] %d\n", MenuPopupActive, SelectedEdgeExtern, MenuPopupStatus[8][0], MenuPopupStatus[8][1], MenuPopupStatus[8][2]);
#endif	
			if (MenuStatus[14][2] == 0)
			{				
				MenuItemChanged[1] = 1;
				MenuStatus[14][1] = 0;
						
				MenuItemChanged[2] = 1;		
				MenuStatus[14][2] = 1;
				
				MenuItemChanged[3] = 1;
				MenuStatus[14][3] = 0;		

				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;	

				if (MenuPopupStatus[8][0] == 3)
				{					
					Selected_Trigger_Source = 5;	
					SelectedEdgeExtern = 0;             // External
				}
				else if (MenuPopupStatus[8][1] == 3)
				{					
					Selected_Trigger_Source = 5;	
					SelectedEdgeExtern = 0;             // External
				}
				else if (MenuPopupStatus[8][1] == 3)
				{					
					Selected_Trigger_Source = 6;	
					SelectedEdgeExtern = 1;             // External
				}

				New_Menu = 14;
				Menu_Changed = 1;

				UpdateTrigger(9);

				Display::StatusUpdate();
				Display::DRAWMENUPOPUP(8);
			}
			else
			{				
				if ((MenuPopupActive > -1) && (MenuPopupActive != 8)) { Display::DRAWMENUPOPDOWN(); }
				if (MenuPopupActive == 8)
				{
					if (MenuPopupStatus[8][0] == 3)	
					{
						SelectedEdgeExtern = 0;             // External LF
						Selected_Trigger_Source = 5;
						MenuPopupStatus[8][0] = 2;
						MenuPopupStatus[8][1] = 3;
						MenuPopupStatus[8][2] = 2;
					}
					else if (MenuPopupStatus[8][1] == 3)	
					{
						SelectedEdgeExtern = 1;             // External HF
						Selected_Trigger_Source = 6;
						MenuPopupStatus[8][0] = 2;
						MenuPopupStatus[8][1] = 2;
						MenuPopupStatus[8][2] = 3;
					}
					else if (MenuPopupStatus[8][2] == 3)	
					{
						SelectedEdgeExtern = 0;             // Line
						Selected_Trigger_Source = 5;
						MenuPopupStatus[8][0] = 3;
						MenuPopupStatus[8][1] = 2;
						MenuPopupStatus[8][2] = 2;
					} 			
				}	
#ifdef _Debug_						
printf("MPA2 %d SEE %d MPS[8][0] %d MPS[8][1] %d MPS[8][2] %d\n", MenuPopupActive, SelectedEdgeExtern, MenuPopupStatus[8][0], MenuPopupStatus[8][1], MenuPopupStatus[8][2]);
#endif															
				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;					
				
				New_Menu = 14;
				Menu_Changed = 1;

				UpdateTrigger(10);

				Display::StatusUpdate();
				Display::DRAWMENUPOPUP(8);
			}
			break;
		}
			
		// Pulse Width -> Dir
		case 15 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[15][2] == 2)
			{
				MenuStatus[15][2] = 1;
				PulseToggle = 2;					
			}
			else if (MenuStatus[15][2] == 1)
			{
				MenuStatus[15][2] = 3;
				PulseToggle = 1;			
			}
			else
			{
				MenuStatus[15][2] = 2;
				PulseToggle = 1;
			}
#ifdef _Debug_					
			printf("PW MS[15/2] %d PT %d\n", MenuStatus[15][2], PulseToggle);
#endif					
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			MenuItemChanged[5] = 1;					
			MenuStatusChanged = 1;
			TriggerWayChanged = 1;
		
			New_Menu = 15;
			Menu_Changed = 1;

			Display::StatusUpdate();
			UpdateTrigger(11);

			break;	
		}		
	
		// Cursor -> X2		
		case 16 :
		{
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;

				Cursor_Vertical_Active = 2;
				Cursor_Horizontal_Active = 3;
	
				Display::CALCCURSORDATA();
							
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;		
		}
		
		// Quick Print -> Save to JPEG
		case 17 :
		{	
			if (USB_Connected == false) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (MenuStatus[17][2] == 143) MenuStatus[17][2] = 144;
			//else MenuStatus[17][2] = 143;
	
			MenuItemChanged[2] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;


			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{					
				send_buffer[0] = 150;			// Command Quick Print requested
				send_buffer[1] = 2;  	      	 	// JPEG
				send_buffer[2] = 0;
						
				SendData(send_buffer);					
			}
							
			break;					
		}					
	
		// About Oscilloscope
		case 18 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			//Display::PopUp(3);
			break;
		}	

		// Quick Measurement -> Add Measurement
		case 19 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
			
			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[19][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[19][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[19][1] - 51)) || (QM_Channel[0] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[1] = MenuStatus[19][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[19][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[19][1] - 51)) || (QM_Channel[1] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[2] = MenuStatus[19][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[19][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[19][1] - 51)) || (QM_Channel[2] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[19][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[19][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			if (NumberOfChannels == 2)
			{
				if (QM_Channel[0] == 3) QM_Channel[0] = 5;
				if (QM_Channel[1] == 3) QM_Channel[1] = 5;
				if (QM_Channel[2] == 3) QM_Channel[2] = 5;
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 19;
			Menu_Changed = 1;
#ifdef _Debug_
if (Debug_Mode) printf("QT1 : %d QT2 : %d QT3 : %d MS19,1 : %d\n", QM_Type[0], QM_Type[1], QM_Type[2], MenuStatus[19][1]);
#endif
			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;

			Display::CALCQMDATA();

			break;
		}
		
		// Quick Measurement Delay Settings
		case 20 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 6)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 6)
			{
				pos = -1;
				MenuPopupStep(6, &MenuStatus[20][2], &pos, &pos, 20, 27, 2);
				
				New_Menu = 20;
				Menu_Changed = 1;
			}				
				
			Display::DRAWMENUPOPUP(6);
			break;
		}	
		
		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 25)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 25)
			{
				pos = -1;
				MenuPopupStep(25, &MenuStatus[21][2], &pos, &pos, 21, 27, 2);
				
				New_Menu = 21;
				Menu_Changed = 1;
			}				
				
			Display::DRAWMENUPOPUP(25);
			break;
		}

		// Quick Measurement Threshold -> Lower
		case 22 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 1;

			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 

		// Trigger Mode TV
		case 24 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 21)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 21)
			{
				pos = -1;
				MenuPopupStep(21, &MenuStatus[24][2], &pos, &pos, 24, 114, 2);
				
				New_Menu = 24;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(21);	
			break;
		}

		// Math - 1 * 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[26][2] == 0)
			{
				if (MenuStatus[26][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[26][1] = 0;
				}
				
				else if (MenuStatus[26][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[26][3] = 0;
				}
				
				else if (MenuStatus[26][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[26][4] = 0;
				}
														
				MenuStatus[26][2] = 1;

				New_Menu = 26;
				Menu_Changed = 1;
			}
				
			break;
		}
		
		// BF reactivated
		// FFT - Settings - Offset
		case 27 :
		{					
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			FFTToggle = 1;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;					

			New_Menu = 27;
			Menu_Changed = 1;

			break;
		}

	}
#ifdef _Debug_						
			if (Debug_Mode) printf("Function Button 3\n");
#endif
}
// BF insert end
//######################################################################################################################################################

// BF insert
//Function button 4 pressed
void Hardware::F4_Btnhandler(void)					// Button Handler for function button
{
			
	short pos = 0;
	int ix;
	int buf_int;

#ifdef _Debug_		
       	printf("F4 Btn start\n");
#endif	
	
	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();
	
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
				
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(3);
			
	switch(Active_Menu)
	{				
		// Display -> Grid
		case 5 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[5][3] == 240) MenuStatus[5][3] = 241;
			else MenuStatus[5][3] = 240;
			
			if (Continius == false)
			{
				DrawSignals_Needed = 1;
				UserIface_active = 0;
			}
			
			New_Menu = 5;
			Menu_Changed = 1;
			break;
		}	
	
		// Service - RS-232 Setup
		case 7 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}	

		// Save / Recall
		case 8 :
		{
			Set_Vars_Default();
			// BF insert - Recalc vars			
			Recalc_Vars();
			// BF insert - init display
			Display::DrawStartScreen();

			UpdateChannel(1, 1);
			UpdateChannel(2, 1);
			
			VoltageChangedCh1 = 1;
			VoltageChangedCh2 = 1;
			
			LED_ON[0] = 1;
			LED_ON[1] = 1;
			LED_ON[5] = 1;
			LED_ON[6] = 0;
	
			Rotary_Steps = 0;
			ON_Zero_Channel_1();
			Rotary_Steps = 0;
			ON_Zero_Channel_2();
	
			SetSwitches(1, Selected_Voltage_CH1);
			SetSwitches(2, Selected_Voltage_CH2);
	
			if (NumberOfChannels > 2)
			{
				UpdateChannel(3, 1);
				UpdateChannel(4, 1);
	
				VoltageChangedCh3 = 1;
				VoltageChangedCh4 = 1;
			
				LED_ON[2] = 1;
				LED_ON[3] = 1;
			
				Rotary_Steps = 0;
				ON_Zero_Channel_3();
				Rotary_Steps = 0;
				ON_Zero_Channel_4();
	
				SetSwitches(3, Selected_Voltage_CH3);
				SetSwitches(4, Selected_Voltage_CH4);
	
			}
			else
			{
				UpdateChannel(3, 0);
				UpdateChannel(4, 0);
			}

			TriggerLevelChanged = 1;
			TriggerModeChanged  = 1;	
			TriggerWayChanged   = 1;
			TimebaseChanged     = 1;
			TimeOffsetChanged   = 1;
			MenuStatusChanged   = 1;
			MenuAktive          = 1;

			Cursor_Data_First_Draw   = 0;
			Quick_Measure_First_Draw = 0;

			UpdateTrigger(12);
			Display::CALCPRETRIGGER();
			Display::DRAW_ALL_CURSOR();
		
			// remove the cursor data
			for (ix = 408 * 20; ix < 430 * 20; ix++)
			{
				*(UI_Plane1 + ix) = 0;		// delete
				*(Buffer_UI2Plane + ix) = 0;	// delete Text				
				*(UI_Plane4 + ix) = 0;		// delete
				*(UI_Plane5 + ix) = 0;		// delete
			}				
	
			Display::DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);				// Button
			Display::TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);					// Draw Voltage Text
	//                    Display::TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);				// Draw Voltage Text
	
			Display::DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);				// Button
			Display::TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);					// Draw Voltage Text
	//                    Display::TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);				// Draw Voltage Text
	
			Display::StatusUpdate();
	
			if (NumberOfChannels > 2)
			{
				Display::DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);			// Button
				Display::TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);				// Draw Voltage Text
	//                        Display::TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);				// Draw Voltage Text
	
				Display::DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);			// Button		
				Display::TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);				// Draw Voltage Text
	//                        Display::TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);				// Draw Voltage Text
			}
				
			Display::DRAWSTATUS(6, 0);
		
			// BF insert - init display
			//Display::DrawStartScreen();
			
			Send_LED();
			config_changed = true;  	// TMW changed (added save paramter on default)
			AMDFlash::Write_Config_Flash();	// TMW changed (added save paramter on default)
				
			break;
		}	
	
		/* is moved up
		// Timebase-> X-Y Mode
		case 10 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[10][3] == 0)
			{
				if (MenuStatus[10][0] == 1)
				{
					MenuItemChanged[0] = 1;
					MenuStatus[10][0] = 0;
				}
				else if (MenuStatus[10][1] == 1)
				{				
				for (ix = 380; ix < 8120; ix++) //400
				{
					Grid_Plane[ix] = *(Grid_Plane_Flash + ix);
	
					if (tc_hw_version < 0x4c7) {if ((ix % 20) == 0) Grid_Plane[ix] = Grid_Plane[ix] << 2;} // Gap
				}
								MenuItemChanged[1] = 1;
								MenuStatus[10][1] = 0;
								
				GridColor_Val = GridColorArray[GridColorArrayPos];
				SetupADC();
							
				MenuStatus[5][2] = GridColorArrayPos + 133;									
				}
				else if (MenuStatus[10][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[10][2] = 0;
				}
				
				if (QM_Enabled)
				{
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = false;
				Quick_Measure_First_Draw = 0;
				MenuStatusChanged = 1;
	
				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;	// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text				
					*(UI_Plane4 + ix) = 0;	// delete
					*(UI_Plane5 + ix) = 0;	// delete
				}
	
				LED_ON[7] = 0;
					
				//New_Menu = 19;
				Menu_Changed = 1;
				//MenuAktive = 0;
					
				Display::CALCQMDATA();
				}

				Virtual_ZeroLevelCH1 = 0;
				ON_Zero_Channel_1();
				Virtual_ZeroLevelCH2 = 0;
				ON_Zero_Channel_2();
							
				Display::GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);

				MenuStatus[10][3] = 1;

				New_Menu = 10;
				Menu_Changed = 1;
				Display_Mode = 1;
				Display::DRAWSTATUS(0, 1);
				ClearPlanes();
			}
			Display::DRAW_ALL_CURSOR();
							
			break;							
		}*/		
					
		// Trigger Mode  -> Holdoff
		case 12 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
		
			if (EdgeToggle == 0)
			{		
				buf_int = (int) (HoldOff.Read_Value() * 100000000);	

				printf("HF bi : %d\n", buf_int);
		
				if (Rotary_Direction_mem_pulse == 1)
				{	
					if (buf_int == 0)
					{
						HoldOff.Write_Value(0.000000040);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int >= 1) && (buf_int < 100))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 100) && (buf_int < 1000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 1000) && (buf_int < 10000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 10000) && (buf_int < 100000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 100000) && (buf_int < 1000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 1000000) && (buf_int < 10000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 10000000) && (buf_int < 100000000))
					{
						HoldOff.Write_Value(1);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((buf_int >= 100000000) && (buf_int < 1000000000))
					{
						HoldOff.Write_Value(10);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((((int) (HoldOff.Read_Value() * 1000000)) >= 10000000) && (((int) (HoldOff.Read_Value() * 1000000)) < 100000000))
					{
						HoldOff.Write_Value(100);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
				}
				else 	                 		
				{
					if (buf_int == 0)
					{
						HoldOff.Write_Value(100);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if (buf_int == 4)
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if (buf_int == 12)
					{
						HoldOff.Write_Value(0.000000040);
		
						HoldOff_Value = 40;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 10) && (buf_int <= 100))
					{
						HoldOff.Write_Value(0.000000120);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 100) && (buf_int <= 1000))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int > 1000) && (buf_int <= 10000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int > 10000) && (buf_int <= 100000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
		
					else if ((buf_int > 100000) && (buf_int <= 1000000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 1000000) && (buf_int <= 10000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 10000000) && (buf_int <= 100000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 100000000) && (buf_int <= 1000000000))
					{
						HoldOff.Write_Value(1);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((((int) (HoldOff.Read_Value() * 1000000)) > 10000000) && (((int) (HoldOff.Read_Value() * 1000000)) <= 100000000))
					{
						HoldOff.Write_Value(10);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
				}

		
				HoldOff.RenderText();				
			}
		
			EdgeToggle = 0;
			New_Menu = 12;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
	
			UpdateTrigger(13);


			break;
		}	


		// Edge -> TV
		case 14 :
		{	
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 11)) { Display::DRAWMENUPOPDOWN(); }			

			if (MenuStatus[14][3] == 0)
			{				
				MenuItemChanged[1] = 1;
				MenuStatus[14][1] = 0;
						
				MenuItemChanged[2] = 1;								
				MenuStatus[14][2] = 0;
				
				MenuItemChanged[3] = 1;
				MenuStatus[14][3] = 1;						
				
				New_Menu = 14;
				Menu_Changed = 1;

									
			}
			else
			{
				if (MenuPopupActive == 11)
				{
					if (MenuPopupStatus[11][0] == 3)	
					{
						MenuPopupStatus[11][0] = 2;
						MenuPopupStatus[11][1] = 3;
					}
					else
					{
						MenuPopupStatus[11][0] = 3;
						MenuPopupStatus[11][1] = 2;
					}
				}
			}
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;		
			Selected_Trigger_Source = 6;
			SelectedEdgeExtern = 2;               // TV CH 1	

			Display::StatusUpdate();
				
			UpdateTrigger(14);	
			
			Display::DRAWMENUPOPUP(11);

			break;
		} 
	
		// Pulse Width
		case 15 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[15][2] == 1) break;

			if (MenuStatus[15][2] == 3)
			{					
				if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse11.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
					}					
		
					Pulse11.RenderText();
					trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);
				}
				else PulseToggle = 1;
			}
			else
			{
				if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse21.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
						Pulse21.Write_Value(0.000000016);
		
						Pulse21_Value = 16;
						Pulse21_Steps = 8;
						Pulse21_Expo = 1;
						}
					}
					else 
					{
						if (buf_int == 1)
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse21.Write_Value(0.000000016);
			
							Pulse21_Value = 16;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
					}			
			
					Pulse21.RenderText();
					trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
				}
				else PulseToggle = 1;
			}

			
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
								
			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
			UpdateTrigger(27);

			Display::StatusUpdate();

			break;	
		}

		// Cursor -> Y1
		case 16 :
		{	
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		

				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
	
				Cursor_Vertical_Active = 3;
				Cursor_Horizontal_Active = 1; 			
	
				Display::CALCCURSORDATA();
								
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;						
		}
		
		// Quick Print -> Save to XLS
		case 17 :
		{	
			if (USB_Connected == false) break;
	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (MenuStatus[17][2] == 143) MenuStatus[17][2] = 144;
			//else MenuStatus[17][2] = 143;

			MenuItemChanged[3] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;


			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{					
				send_buffer[0] = 150;						// Command Quick Print requested
				send_buffer[1] = 3;                         // XLS
				send_buffer[2] = 0;
						
				SendData(send_buffer);					
			}
							
			break;					
		}				

		// Quick Measurement -> Clear
		case 19 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
		
			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			QM_Type[0] = 0;
			QM_Type[1] = 0;
			QM_Type[2] = 0;
	
			QM_Channel[0] = MenuStatus[19][0] - 26;
			QM_Channel[1] = MenuStatus[19][0] - 26;
			QM_Channel[2] = MenuStatus[19][0] - 26;
	
			QM_Changed[0] = 0;
			QM_Changed[1] = 0;
			QM_Changed[2] = 0;
	
			Quick_Measure_First_Draw = 1;

			New_Menu = 19;
			Menu_Changed = 1;
	
			QM_Vertical_Active = 0;
			QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}
	
		// Quick Measurement Settings
		case 20 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			if (MenuStatus[20][3] == 2) MenuStatus[20][3] = 3;
			else MenuStatus[20][3] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}	

		// Quick Measurement Threshold -> Middle
		case 22 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 2;
			
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		}
	
		// Trigger Mode TV
		case 24 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 22)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 22)
			{
				pos = -1;
				MenuPopupStep(22, &MenuStatus[24][3], &pos, &pos, 24, 119, 2);
				
				New_Menu = 24;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(22);	
			break;
		}		

		// Math
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[26][3] == 0)
			{
				if (MenuStatus[26][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[26][1] = 0;
				}
				
				else if (MenuStatus[26][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[26][2] = 0;
				}
				
				else if (MenuStatus[26][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[26][4] = 0;
				}
														
				MenuStatus[26][3] = 1;

				New_Menu = 26;
				Menu_Changed = 1;
			}
				
			break;
		}	
		
	}	
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 4\n");		
#endif


}
// BF insert end
//######################################################################################################################################################

// BF insert
//Function button 5 pressed
void Hardware::F5_Btnhandler(void)					// Button Handler for function button
{
	int buf_int;

#ifdef _Debug_		
       	printf("F5 Btn start\n");
#endif	
			
	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();
			
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
				
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;
			
	MenuButtonCheck(4);
			
	switch(Active_Menu)
	{
		// Display / Browse
		case 5 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[5][4] == 241) MenuStatus[5][4] = 240;
			else MenuStatus[5][4] = 241;

			if (MenuStatus[5][4] == 241) Display::DRAWMEMORY(0, 1, 1);
			else
			{
				Display::DRAWMEMORY(1, 0, 0);			
				Display::DRAW_ALL_CURSOR();
			}

			New_Menu = 5;
			Menu_Changed = 1;				

			break;
		}			
	
		//  Save / Recall - > Clear Display
		case 8 :
		{		
			if ((Continius == false) || (MenuStatus[5][0] == 241)) ClearPlanes();	
			break;	
		}				


		case 10 :
		{

			break;
		}
		
		// Trigger Mode  -> Probe
		case 12 :
		{
			EdgeToggle = 1;
			New_Menu = 12;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;

			break;
		}	
		
	
		// Pulse Width
		case 15 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[15][2] == 2) break;

			if (MenuStatus[15][2] == 3)
			{					
				if (PulseToggle == 2)
				{					
					buf_int = (int) (Pulse12.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
					}
					else	
					{
						if (buf_int == 1)
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
					}

					Pulse12.RenderText();
					trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
				}
				else PulseToggle = 2;
			}
			else
			{
				if (PulseToggle == 2)
				{					
					buf_int = (int) (Pulse22.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{		
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
					}		
		
					Pulse22.RenderText();
					trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
				}
				else PulseToggle = 2;
			}

			
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
		
			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
	
			UpdateTrigger(31);

			Display::StatusUpdate();

			break;	
		}	
	
		// Cursor -> Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;					
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;

				Cursor_Vertical_Active = 3;
				Cursor_Horizontal_Active = 2;
					
				Display::CALCCURSORDATA();
								
				New_Menu = 16;
				Menu_Changed = 1;

				Display::DRAW_ALL_CURSOR();
			}
			break;			
		}
		
		// Quick Print -> Print start XLS
		case 17 :
		{		/*
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (MenuStatus[17][2] == 143) MenuStatus[17][2] = 144;
			//else MenuStatus[17][2] = 143;

			//MenuItemChanged[4] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;


			if ((USB_Data_Requested == false) && (USB_Data_Trans == false))
			{					
				send_buffer[0] = 150;						// Command Quick Print requested
				send_buffer[1] = 4;                         //
				send_buffer[2] = 0;
						
				SendData(send_buffer);					
			}  */
							
			break;					
		}				
	
		// Quick Measurement -> Settings
		case 19 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if ((MenuStatus[19][1] - 52) == 4)
			{
				New_Menu = 20;
				Menu_Changed = 1;
			}
			if ((MenuStatus[19][1] - 52) == 13)
			{
				New_Menu = 21;
				Menu_Changed = 1;
			}

			break;
		}
		
		// Quick Measurement -> Add Measurement
		case 20 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[19][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[19][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[19][1] - 51)) || (QM_Channel[0] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[1] = MenuStatus[19][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[19][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[19][1] - 51)) || (QM_Channel[1] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[2] = MenuStatus[19][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[19][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[19][1] - 51)) || (QM_Channel[2] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[19][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[19][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 20;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement -> Add Measurement
		case 21 :
		{	
			//if (MenuStatus[10][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[19][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[19][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[19][1] - 51)) || (QM_Channel[0] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[1] = MenuStatus[19][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[19][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[19][1] - 51)) || (QM_Channel[1] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[2] = MenuStatus[19][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[19][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[19][1] - 51)) || (QM_Channel[2] != (MenuStatus[19][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[19][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[19][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 21;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement Threshold -> Upper
		case 22 :
		{	
			//if (MenuStatus[10][2] == 1) break;
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;

			Quick_Measure_Threshold_btn_select = 3;
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 	
	
		// Math
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[26][4] == 0)
			{
				if (MenuStatus[26][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[26][1] = 0;
				}
				
				else if (MenuStatus[26][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[26][2] = 0;
				}
				
				else if (MenuStatus[26][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[26][3] = 0;
				}
														
				MenuStatus[26][4] = 1;

				New_Menu = 26;
				Menu_Changed = 1;
			}
				
			break;
		}	
	
		// FFT Settings
		case 27 :
		{				
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 28;
			Menu_Changed = 1;
			break;
		}
	}
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 5\n");		
#endif			

}
// BF insert end
//######################################################################################################################################################

// BF insert
//Function button 6 pressed
void Hardware::F6_Btnhandler(void)					// Button Handler for function button
{

	int ix;

#ifdef _Debug_		
       	printf("F6 Btn start\n");
#endif

	if (MenuPopupActive > 0) ResetTimer();
//	if (ZeroPopupChanged > 0) ResetTimer();
				
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
							
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(5);
			
	switch(Active_Menu)
	{		              		
		// Cursor -> X1X2/Y1Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0) break;
			
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
	
				Cursor_Both_Selected_Old = Cursor_Both_Selected;

				if ((Cursor_Vertical_Active == 4) || (Cursor_Horizontal_Active == 4))
				{
					if (Cursor_Both_Selected == 0)
					{
						Cursor_Both_Selected = 1;
						Cursor_Vertical_Active = 3;
						Cursor_Horizontal_Active = 4;
					}
					else
					{
						Cursor_Both_Selected = 0;
						Cursor_Vertical_Active = 4;
						Cursor_Horizontal_Active = 3;
					}
				}
				else
				{
					if (Cursor_Both_Selected == 0)
					{
						Cursor_Vertical_Active = 4;
						Cursor_Horizontal_Active = 3;
					}
					else
					{
						Cursor_Vertical_Active = 3;
						Cursor_Horizontal_Active = 4;
					}
				}
					
				Display::CALCCURSORDATA();
								
				New_Menu = 16;
				Menu_Changed = 1;

				Display::DRAW_ALL_CURSOR();
			}
			break;	
		}	
						
		// Quick Measurement -> Thresholds
		case 19 :
		{	
			//if (MenuStatus[10][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 22;
			Menu_Changed = 1;
			break;		
		}				
			
		// Quick Measurement Delay Settings
		case 20 :
		{	
			//if (MenuStatus[10][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;		
		}
		
		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;		
		}				
		
		// Quick Measurement Thresholds
		case 22 :
		{		
			//if (MenuStatus[10][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;
		}	
	
		// FFT settings
		case 27 :
		{	
			//if (MenuStatus[10][2] == 1) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 26;
			Menu_Changed = 1;
			break;	
		}		

		// More FFT settings
		case 28 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 27;
			Menu_Changed = 1;
			break;		
		}	
					
		// Math settings
		case 29 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 26;
			Menu_Changed = 1;
			break;		
		}		
				
		// TMW changed; added Setup Default Button in Edge Menu
		// Edge -> Default Setup
		case 14 :
		{
			Set_Vars_Default();
			// BF insert - Recalc vars			
			Recalc_Vars();
			// BF insert - init display
			Display::DrawStartScreen();

			UpdateChannel(1, 1);
			UpdateChannel(2, 1);
			
			VoltageChangedCh1 = 1;
			VoltageChangedCh2 = 1;				
			
			LED_ON[0] = 1;
			LED_ON[1] = 1; 				
			LED_ON[5] = 1;
			LED_ON[6] = 0;
	
			Rotary_Steps = 0;
			ON_Zero_Channel_1();
			Rotary_Steps = 0;
			ON_Zero_Channel_2();
	
			SetSwitches(1, Selected_Voltage_CH1);
			SetSwitches(2, Selected_Voltage_CH2);

			if (NumberOfChannels > 2)
			{
				UpdateChannel(3, 1);
				UpdateChannel(4, 1);
	
				VoltageChangedCh3 = 1;
				VoltageChangedCh4 = 1;
			
				LED_ON[2] = 1;
				LED_ON[3] = 1;
			
				Rotary_Steps = 0;
				ON_Zero_Channel_3();
				Rotary_Steps = 0;
				ON_Zero_Channel_4();
	
				SetSwitches(3, Selected_Voltage_CH3);
				SetSwitches(4, Selected_Voltage_CH4);
	
			}
			else
			{
				UpdateChannel(3, 0);
				UpdateChannel(4, 0);
			} 	

			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;	
			TriggerWayChanged = 1;
			TimebaseChanged = 1;
			TimeOffsetChanged = 1;
			MenuStatusChanged = 1;
			MenuAktive = 1;

			Cursor_Data_First_Draw = 0;
			Quick_Measure_First_Draw = 0;   				    	

			UpdateTrigger(12);
			Display::CALCPRETRIGGER();
			Display::DRAW_ALL_CURSOR();
		
			// remove the cursor data
			for (ix = 408 * 20; ix < 430 * 20; ix++)
			{
				*(UI_Plane1 + ix) = 0;	// delete
				*(Buffer_UI2Plane + ix) = 0;	// delete Text	
				*(UI_Plane4 + ix) = 0;	// delete
				*(UI_Plane5 + ix) = 0;	// delete
			}				

			Display::DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);					// Button
			Display::TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);						// Draw Voltage Text
	//                    Display::TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);					// Draw Voltage Text

			Display::DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);					// Button
			Display::TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);						// Draw Voltage Text
	//                    Display::TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);					// Draw Voltage Text

			Display::StatusUpdate();

			if (NumberOfChannels > 2)
			{
				Display::DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);				// Button
				Display::TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);					// Draw Voltage Text
	//                        Display::TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);					// Draw Voltage Text
	
				Display::DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);				// Button		
				Display::TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);					// Draw Voltage Text
	//                        Display::TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);					// Draw Voltage Text
			}
				
			Display::DRAWSTATUS(6, 0);
		
			Send_LED();
			config_changed = true;  	// TMW changed (added save paramter on default)
			AMDFlash::Write_Config_Flash();	// TMW changed (added save paramter on default)

			break;
		} // TMW change ends
	}			
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 6\n");
#endif			


}
// BF insert end
//######################################################################################################################################################

char Hardware::MenuButtonCheck(char BtnNr)
{
	char ct, found = 0;
	
	for (ct = 0; ct < 6; ct++)
	{
		if (MenuItemPushed[ct] == 1) { found = 1; MenuItemPushed[ct] = 0; MenuItemPushed_old[ct] = 1; MenuItemChanged[ct] = 1;}
	}
	
	if (found) ResetTimer();

	if (BtnNr > -1)
	{
		MenuItemChanged[BtnNr] = 1;
		MenuItemPushed[BtnNr] = 1;	
	}
	return found;
}

void Hardware::MenuPopupStep(int MenuPopupNr, short *MenuStatusNr, short *MenuStatusNr2, short *MenuStatusNr3, int DrawMenuNr, int start, char dir)
{
	int x, pos = 0;
	int newpos = 0;
	
	unsigned short count = 0;
	
	count = MenuPopupDef[MenuPopupActive][1];
	
	for (x = 0; x < count; x++)
	{
		if (MenuPopupStatus[MenuPopupNr][x] == 3) pos = x;
	}
	
	
	if (dir == 2)
	{
        newpos = -1;
        for (x = pos; x < count; x++)
        {
            if (MenuPopupStatus[MenuPopupNr][x] == 2)
            {
                newpos = x;
                break;
            }
        }	
	
        if (newpos == -1)
        {
            for (x = 0; x < pos; x++)
            {
                if (MenuPopupStatus[MenuPopupNr][x] == 2)
                {
                    newpos = x;
                    break;
                }
            }
        }
    }
    else
	{
        newpos = -1;
        for (x = pos; x >= 0; x--)
        {
            printf("DoStep (%d) down to %d = %d\n", MenuPopupNr, x, MenuPopupStatus[MenuPopupNr][x]);
            if (MenuPopupStatus[MenuPopupNr][x] == 2)
            {
                newpos = x;
                break;
            }
        }	
	
        if (newpos == -1)
        {
            printf("Nothing found\n");
            for (x = count; x > pos; x--)
            {
                if (MenuPopupStatus[MenuPopupNr][x] == 2)
                {
                    newpos = x;
                    break;
                }
            }
        }
    }    	
    
    printf("Pos : %2d NewPos : %2d dir : %2d\n", pos, newpos, dir);
	
    if (newpos == -1) return;	
	
	MenuPopupStatus[MenuPopupNr][pos] = 2;
	MenuPopupStatus[MenuPopupNr][newpos] = 3;
	
	MenuStatusNr[0] = start + newpos;
    if (MenuStatusNr2[0] > -1) { MenuStatusNr2[0] = start + newpos; }
    if (MenuStatusNr3[0] > -1) { MenuStatusNr3[0] = start + newpos; }	
}		

void Hardware::UpdateChannel(int channel, char active)
{
	char *iipos = 0;
	char *iiipos = 0;	
	int x= 0;
	int pos = 0;
	int bufchannel = channel;
	char lednr = 0;
	
	switch(channel)
	{
		case 1:
		{
			iipos = &Channel_1_Active;
			iiipos = &Channel_1_Active_Old;
			lednr = 0;
			break;
		}	
		case 2:
		{
			iipos = &Channel_2_Active;
			iiipos = &Channel_2_Active_Old;
			lednr = 1;
			break;
		}
		case 3:
		{
			iipos = &Channel_3_Active;
			iiipos = &Channel_3_Active_Old;
			lednr = 2;
			break;
		}
		case 4:
		{
			iipos = &Channel_4_Active;
			iiipos = &Channel_4_Active_Old;
			lednr = 3;
			break;
		}
		case 5:
		{
			iipos = &Channel_Math_Active;
			iiipos = &Channel_Math_Active_Old;
			lednr = 4;
			
			if (NumberOfChannels == 2) bufchannel = 3;
			break;
		}		
	}
						
	if (active == 1)
	{
		*iiipos = *iipos;
		*iipos = 1;
		
		// FFT Source
		if (MenuPopupStatus[29][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[27][0] == 91)
			{
				MenuPopupStatus[29][0 + (bufchannel - 1)] = 3;
				MenuStatus[27][0] = 138 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[29][0 + (bufchannel - 1)] = 2;			
		} 		
		
		// Edge Source
		if (MenuPopupStatus[28][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[14][1] == 91)
			{
				MenuPopupStatus[28][0 + (bufchannel - 1)] = 3;
				MenuStatus[14][1] = 138 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[28][0 + (bufchannel - 1)] = 2;			
		} 		
		
		// Cursor Source
		if (MenuPopupStatus[1][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[16][0] == 91)
			{
				MenuPopupStatus[1][0 + (bufchannel - 1)] = 3;
				MenuStatus[16][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[1][0 + (bufchannel - 1)] = 2;			
		}
		
		// Quick Measurement Source
		if (MenuPopupStatus[3][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[19][0] == 91)
			{
				MenuPopupStatus[3][0 + (bufchannel - 1)] = 3;
				MenuStatus[19][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[3][0 + (bufchannel - 1)] = 2;			
		}		
		
		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[20][0] == 91)
			{
				MenuPopupStatus[5][0 + (bufchannel - 1)] = 3;
				MenuStatus[20][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[5][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[20][2] == 91)
			{
				MenuPopupStatus[6][0 + (bufchannel - 1)] = 3;
				MenuStatus[20][2] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[6][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[21][0] == 91)
			{
				MenuPopupStatus[24][0 + (bufchannel - 1)] = 3;
				MenuStatus[21][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[24][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[21][2] == 91)
			{
				MenuPopupStatus[25][0 + (bufchannel - 1)] = 3;
				MenuStatus[21][2] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[25][0 + (bufchannel - 1)] = 2;			
		}		
		
		// Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[22][0] == 91)
			{
				MenuPopupStatus[26][0 + (bufchannel - 1)] = 3;
				MenuStatus[22][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[26][0 + (bufchannel - 1)] = 2;			
		}			
		
		// Pulse Width Source
		if (MenuPopupStatus[7][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[15][0] == 91)
			{
				MenuPopupStatus[7][0 + (bufchannel - 1)] = 3;
				MenuStatus[15][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[7][0 + (bufchannel - 1)] = 2;			
		}
		Set_LED(lednr);
	}
	else
	{
		*iiipos = *iipos;
		*iipos = 0;      		
		
		if ((Channel_Math_Active) && ((bufchannel == 1) || (bufchannel == 2)) && (MenuStatus[26][1] == 0))
		{
			Channel_Math_Active = 0;
			RemovePlane |= 0x10;
			ClearPlanes();	
			Reset_LED(4);		
		}
		
		// Switch from XY to Main
		if ((Display_Mode == 1) && ((bufchannel == 1) || (bufchannel == 2)))
		{
		    	MenuStatus[10][0] = 1;
			MenuStatus[10][2] = 246;
			Display_Mode = 0;	//Main

/* BF del for the new grid
            for (x = GRID_PLANE_MIN; x < GRID_PLANE_MAX; x++)
            {
                Grid_Plane[x] = *(Grid_Plane_Flash + x);
            }
BF end	*/ 
			// Draw main grid into gridplane
			Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);

			GridColor_Val = GridColorArray[GridColorArrayPos];
			SetupADC();
							
			MenuStatus[5][2] = GridColorArrayPos + 133;							
		}
		
		// FFT Source
		if (MenuPopupStatus[29][0 + (bufchannel - 1)] == 3)
		{	
			MenuPopupStatus[29][0 + (bufchannel - 1)] = 1;
				
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[29][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[29][pos] = 3;
				MenuStatus[27][0] = 138 + pos;
			}
			else
			{
				MenuStatus[27][0] = 91;						//None
			}
		}
		else MenuPopupStatus[29][0 + (bufchannel - 1)] = 1;		
		
		// Edge Source
		if (MenuPopupStatus[28][0 + (bufchannel - 1)] == 3)
		{	
			MenuPopupStatus[28][0 + (bufchannel - 1)] = 1;
				
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[28][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[28][pos] = 3;
				MenuStatus[14][1] = 138 + pos;
			}
			else
			{
				MenuStatus[14][1] = 91;						//None
			}
		}
		else MenuPopupStatus[28][0 + (bufchannel - 1)] = 1;

        Selected_Trigger_Source	= MenuStatus[14][1] - 137;
        TriggerWayChanged = true;	
        TriggerLevelChanged = 1;

        Display::StatusUpdate();
        UpdateTrigger(45);
		
		// Cursor Source
		if (MenuPopupStatus[1][0 + (bufchannel - 1)] == 3)
		{	
			MenuPopupStatus[1][0 + (bufchannel - 1)] = 1;
				
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[1][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[1][pos] = 3;
				MenuStatus[16][0] = 27 + pos;
			}
			else
			{
				MenuStatus[16][0] = 91;						//None
			}
		}
		else MenuPopupStatus[1][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Source
		if (MenuPopupStatus[3][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[3][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 4;x++)
			{
				if (MenuPopupStatus[3][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[3][pos] = 3;
				MenuStatus[19][0] = 27 + pos;
			}
			else
			{
				MenuStatus[19][0] = 91;						//None
			}
		}
		else MenuPopupStatus[3][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[5][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[5][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[5][pos] = 3;
				MenuStatus[20][0] = 27 + pos;
			}
			else
			{
				MenuStatus[20][0] = 91;						//None
			}
		}
		else MenuPopupStatus[5][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[6][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[6][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[6][pos] = 3;
				MenuStatus[20][2] = 27 + pos;
			}
			else
			{
				MenuStatus[20][2] = 91;						//None
			}
		}
		else MenuPopupStatus[6][0 + (bufchannel - 1)] = 1;
		
        // Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[24][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[24][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[24][pos] = 3;
				MenuStatus[21][0] = 27 + pos;
			}
			else
			{
				MenuStatus[21][0] = 91;						//None
			}
		}
		else MenuPopupStatus[24][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[25][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[25][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[25][pos] = 3;
				MenuStatus[21][2] = 27 + pos;
			}
			else
			{
				MenuStatus[21][2] = 91;						//None
			}
		}
		else MenuPopupStatus[25][0 + (bufchannel - 1)] = 1;		
		
        // Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[26][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[26][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[26][pos] = 3;
				MenuStatus[22][0] = 27 + pos;
			}
			else
			{
				MenuStatus[22][0] = 91;						//None
			}
		}
		else MenuPopupStatus[26][0 + (bufchannel - 1)] = 1;
		
		// Pulse Width Source
		if (MenuPopupStatus[7][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[7][0 + (bufchannel - 1)] = 1;		
		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[7][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[7][pos] = 3;
				MenuStatus[15][0] = 27 + pos;
			}
			else
			{
				MenuStatus[15][0] = 91;						//None
			}
		}	
		else MenuPopupStatus[7][0 + (bufchannel - 1)] = 1;
		
		Reset_LED(lednr);
	}	
	
	MenuPopupStatus[28][0] = 2;
	MenuPopupStatus[28][1] = 2;
	
	if (NumberOfChannels > 2)
	{
        MenuPopupStatus[28][2] = 2;
        MenuPopupStatus[28][3] = 2;
    }
	
	if (MenuStatus[14][1] == 138) MenuPopupStatus[28][0] = 3;
	else if (MenuStatus[14][1] == 139) MenuPopupStatus[28][1] = 3;
	else if (MenuStatus[14][1] == 140) MenuPopupStatus[28][2] = 3;
	else if (MenuStatus[14][1] == 141) MenuPopupStatus[28][3] = 3;
	
    if (Cursor_Enabled)
    {
        CursorChanged = 3;
        Cursor_Data_First_Draw = 1;
        Display::CALCCURSORDATA();
        Display::DRAWCURSORDATA(0);
    }

    // Check Measurements

    QM_Type_Old[0] = QM_Type[0];
    QM_Type_Old[1] = QM_Type[1];
    QM_Type_Old[2] = QM_Type[2];

    pos = -1;
    for (x = 0; x < 3; x++)
    {
        if (QM_Type[x] > 0)
        {
            if ((QM_Channel[x] == 1) && (Channel_1_Active == 0)) { QM_Type[x] = 0; pos = 1; }
            if ((QM_Channel[x] == 2) && (Channel_2_Active == 0)) { QM_Type[x] = 0; pos = 1; }
            if ((QM_Channel[x] == 3) && (Channel_3_Active == 0)) { QM_Type[x] = 0; pos = 1; }
            if ((QM_Channel[x] == 4) && (Channel_4_Active == 0)) { QM_Type[x] = 0; pos = 1; }
            if ((QM_Channel[x] == 5) && (Channel_Math_Active == 0)) { QM_Type[x] = 0; pos = 1; }
        }
    }

    if (pos == 1)
    {
        QM_Channel[0] = MenuStatus[19][0] - 26;
        QM_Channel[1] = MenuStatus[19][0] - 26;
        QM_Channel[2] = MenuStatus[19][0] - 26;

        QM_Changed[0] = 0;
        QM_Changed[1] = 0;
        QM_Changed[2] = 0;

        Quick_Measure_First_Draw = 1;

        New_Menu = 19;
        Menu_Changed = 1;
    }

    printf("********  Update channel %d done  ***********\n", bufchannel);
}

void Hardware::UpdateTrigger(char nr)
{
    int trg_buf, p_mul_value;
    //if (AutoTimerOff) return;

	Selected_Trigger_Source_Old = Selected_Trigger_Source;
	
	adc_ctrl_reg &= 0xFFF0;
    //ctrl_reg &= 0xC17F;  // remove holdoff and pulse bits
    ctrl_reg &= 0xC17D;  // remove holdoff and pulse bits and internel bit
    	
    if (HoldOff_Value)
    {
        trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
        ctrl_reg |= 0x2000;
    }
    else trig_holdoff_reg = 0x00000000;
                    	
  //  if (TriggerWay == 1)
    {
        if (MenuStatus[14][1] == 138)
        {
            triggering = 1;
            ctrl_reg |= 0x0002;
            adc_ctrl_reg |= 0x0001;
			
            trg_buf = (128 - ((Trigger_Pos_CH1 + 64) >> 1)) >> 1;

            if (multi_active)
            {
                if (Voltage_Correction[0][Selected_Voltage_CH1] == 0) trg_buf = 0;
                else trg_buf = int (float (trg_buf) / Volt_Correct_float[0][Selected_Voltage_CH1]);
            }

            trg_val_CHI_reg	= ((Trigger_Pos_CH1 + 64) >> 1) + trg_buf;

            trg_val_CHI_reg	= 255 - trg_val_CHI_reg;

		
            if (MenuStatus[14][0] == 2)
            {
                ctrl_reg |= 0x0004;
            }
            else if (MenuStatus[14][0] == 3)
            {
                ctrl_reg &= 0xFFFB;
            }
        }
        else if (MenuStatus[14][1] == 139)
        {
            triggering = 2;
            ctrl_reg |= 0x0002;
            adc_ctrl_reg |= 0x0002;
				
            trg_buf = (128 - ((Trigger_Pos_CH2 + 64) >> 1)) >> 1;

            if (multi_active)
            {
                if (Voltage_Correction[1][Selected_Voltage_CH2] == 0) trg_buf = 0;
                else trg_buf = int (float (trg_buf) / Volt_Correct_float[1][Selected_Voltage_CH2]);
            }

            trg_val_CHII_reg	= ((Trigger_Pos_CH2 + 64) >> 1) + trg_buf;

            trg_val_CHII_reg	= 255 - trg_val_CHII_reg;
            				
			
            //trg_val_reg	= 255 - ((Trigger_Pos_CH2 + 64) >> 1);
				
            if (MenuStatus[14][0] == 2)
            {
                ctrl_reg |= 0x0004;
            }
            else if (MenuStatus[14][0] == 3)
            {
                ctrl_reg &= 0xFFFB;
            }
        }
        else if (MenuStatus[14][1] == 140)
        {
            triggering = 3;
            ctrl_reg |= 0x0002;
            adc_ctrl_reg |= 0x0004;
			
            trg_buf = (128 - ((Trigger_Pos_CH3 + 64) >> 1)) >> 1;

            if (multi_active)
            {
                if (Voltage_Correction[2][Selected_Voltage_CH3] == 0) trg_buf = 0;
                else trg_buf = int (float (trg_buf) / Volt_Correct_float[2][Selected_Voltage_CH3]);
            }

            trg_val_CHIII_reg	= ((Trigger_Pos_CH3 + 64) >> 1) + trg_buf;

            trg_val_CHIII_reg	= 255 - trg_val_CHIII_reg;
                        	
            //trg_val_reg	= 255 - ((Trigger_Pos_CH3 + 64) >> 1);
				
            if (MenuStatus[14][0] == 2)
            {
                ctrl_reg |= 0x0004;
            }
            else if (MenuStatus[14][0] == 3)
            {
                ctrl_reg &= 0xFFFB;
            }
        }
        else if (MenuStatus[14][1] == 141)
        {
            triggering = 4;
            ctrl_reg |= 0x0002;
            adc_ctrl_reg |= 0x0008;
			
            trg_buf = (128 - ((Trigger_Pos_CH4 + 64) >> 1)) >> 1;

            if (multi_active)
            {
                if (Voltage_Correction[3][Selected_Voltage_CH4] == 0) trg_buf = 0;
                else trg_buf = int (float (trg_buf) / Volt_Correct_float[3][Selected_Voltage_CH4]);
            }

            trg_val_CHIV_reg	= ((Trigger_Pos_CH4 + 64) >> 1) + trg_buf;

            trg_val_CHIV_reg	= 255 - trg_val_CHIV_reg;
                        	
            //trg_val_reg	= 255 - ((Trigger_Pos_CH4 + 64) >> 1);
				
            if (MenuStatus[14][0] == 2)
            {
                ctrl_reg |= 0x0004;
            }
            else if (MenuStatus[14][0] == 3)
            {
                ctrl_reg &= 0xFFFB;
            }
        }

        if (MenuStatus[14][2] == 1)
        {
            triggering = 5;
				
            ctrl_reg &= 0xFFFD;
            adc_ctrl_reg &= 0xFFF0;

            if (MenuStatus[14][0] == 2) ctrl_reg |= 0x0004;
            else if (MenuStatus[14][0] == 3) ctrl_reg &= 0xFFFB;

            SwitchesTB = 0x00;
            
            if (MenuPopupStatus[8][0] == 3) SwitchesTB = 0x40;
            else if (MenuPopupStatus[8][1] == 3) SwitchesTB = 0xC0;
            else if (MenuPopupStatus[8][2] == 3) SwitchesTB = 0x80;

            if (MenuStatus[12][1] == 95) SwitchesTB |= 0x04;
            else SwitchesTB &= 0xFB;
        							
            SetSwitches(5, SwitchesTB);
#ifdef _Debug_
            printf("TE %d\n", Trigger_Pos_CHE);
#endif
            ext_trg_val_reg = Extern_Trigger_Values[Trigger_Pos_CHE];
            
            printf("extern level %d \n", ext_trg_val_reg);

            serdata->np_piodata = ext_trg_val_reg;
            serstartpwm->np_piodata = 1;
            serstartpwm->np_piodata = 0;
        }
        
        if (MenuStatus[14][3] == 1)
        {
            triggering = 5;
				
            ctrl_reg &= 0xFFFD;
            adc_ctrl_reg &= 0xFFF0;

            if (MenuStatus[14][0] == 2) ctrl_reg |= 0x0004;
            else if (MenuStatus[14][0] == 3) ctrl_reg &= 0xFFFB;

            SwitchesTB = 0x00;
            
            if (MenuPopupStatus[11][0] == 3) SwitchesTB = 0x01;
            else if (MenuPopupStatus[11][1] == 3) SwitchesTB = 0x02;

            if (MenuStatus[12][1] == 95) SwitchesTB |= 0x04;
            else SwitchesTB &= 0xFB;
        							
            SetSwitches(5, SwitchesTB);
#ifdef _Debug_
            printf("TE %d\n", Trigger_Pos_CHE);
#endif
            ext_trg_val_reg = Extern_Trigger_Values[Trigger_Pos_CHE];

            serdata->np_piodata = ext_trg_val_reg;
            serstartpwm->np_piodata = 1;
            serstartpwm->np_piodata = 0;
        }
    }

    if (TriggerWay == 2)
    {
        if (MenuStatus[15][2] == 1) ctrl_reg |= 0x1200;
        else if (MenuStatus[15][2] == 2) ctrl_reg |= 0x1400;
        else if (MenuStatus[15][2] == 3) ctrl_reg |= 0x1800;
    }

    // Autotrigger
    if ((MenuStatus[12][0] == 93) && (TriggerWay == 1)) ctrl_reg |= 0x0040;
    else ctrl_reg &= 0xFFBF;
    	
    Selected_Trigger_Source = triggering;
			
	MenuPopupStatus[28][0] = 2;
	MenuPopupStatus[28][1] = 2;
	
	if (NumberOfChannels > 2)
	{
        MenuPopupStatus[28][2] = 2;
        MenuPopupStatus[28][3] = 2;
    }
	
	if (MenuStatus[14][1] == 138) MenuPopupStatus[28][0] = 3;
	else if (MenuStatus[14][1] == 139) MenuPopupStatus[28][1] = 3;
	else if (MenuStatus[14][1] == 140) MenuPopupStatus[28][2] = 3;
	else if (MenuStatus[14][1] == 141) MenuPopupStatus[28][3] = 3;			
			
         /*
    // Rollmode
    if (MenuStatus[10][2] == 1)
    {
        adc_ctrl_reg &= 0xFFF0;
        ctrl_reg |= 0x0087;
        triggering = 0;
    }  */
        	
#ifdef _Debug_	
	if (Debug_Mode) printf("Trigger Updated Nr : %d MS12 %i MS14 %i actrl %x ctrl %x trv1 %x trv2 %x\n", nr, MenuStatus[12][0], MenuStatus[14][1], adc_ctrl_reg, ctrl_reg, trg_val_CHI_reg, trg_val_CHII_reg);
#endif	
	SetupADC();
}

void Hardware::Set_LED(int LED)
{
	LED_ON[LED] = 1;
	Send_LED();
}

void Hardware::Reset_LED(int LED)
{
	LED_ON[LED] = 0;
	Send_LED();
}

void Hardware::Clear_LED(void)
{
	int ct;
	
	for (ct = 0; ct < 13;ct++) LED_ON[ct] = 0;
}

void Hardware::Send_LED(void)
{
	int led_value = 0xFFFF;
	
	if (LED_ON[0] == 1) led_value = led_value & 0xBFFF;			// Select Channel 1
	if (LED_ON[1] == 1) led_value = led_value & 0xEFFF;			// Select Channel 2
	
	//if (NumberOfChannels > 2)
	//{
	   if (LED_ON[2] == 1) led_value = led_value & 0xFEFF;			// Select Channel 3
	   if (LED_ON[3] == 1) led_value = led_value & 0x7FFF;			// Select Channel 4
    	//}
	if (LED_ON[4] == 1) led_value = led_value & 0xDFFF;		// Select Channel Math
	if (LED_ON[5] == 1) led_value = led_value & 0xFDFF;		// General
	if (LED_ON[6] == 1) led_value = led_value & 0xFBFF;		// Cursor						
	if (LED_ON[7] == 1) led_value = led_value & 0xF7FF;		// Quick Measure
	if (LED_ON[8] == 1) led_value = led_value & 0xFFBF;		// Edge
	if (LED_ON[9] == 1) led_value = led_value & 0xFFFD;		// Pattern - Not Used
	if (LED_ON[10] == 1) led_value = led_value & 0xFF7F;		// Pulse Width
	if (LED_ON[11] == 1) led_value = led_value & 0xFFFE;		// More - Not Used
	if (LED_ON[12] == 1) led_value = led_value & 0xFFDF;		// Run/Stop Green
	if (LED_ON[13] == 1) led_value = led_value & 0xFFEF;		// Run/Stop Red
	if (LED_ON[14] == 1) led_value = led_value & 0xFFF7;		// Single Red					
	if (LED_ON[15] == 1) led_value = led_value & 0xFFFB;		// Single Green
	
	serdata->np_piodata = led_value;
	serstartled->np_piodata = 0x01;
	serstartled->np_piodata = 0x00;	
#ifdef _Debug_	
	if (Debug_Mode) printf("LED VAL : %x \n", led_value);
#endif
}

void Hardware::DoEnableRotInterrupt(void)						// Enable service routine
{
	rot_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	rot_int->np_piodirection = 0x00;							// set all bits to input
	rot_int->np_piointerruptmask = 0x01;						// enable Button IRQs

	key_reset->np_piodata = 0;
	nr_delay(1);
	key_reset->np_piodata = 1;

	rot_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	
	nr_installuserisr(na_rot_interrupt_irq,ISR_ROT,(int)rot_int);	// Install ISR for parallel I/Os
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nRot interrupt enabled.\n");  						// print on console
#endif	
}
	
void Hardware::DoDisableRotInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_rot_interrupt_irq,0,0); 				// Install empty routine for pio irq
	rot_int->np_piointerruptmask = 0x00;						// disable all IRQs
}

void Hardware::ISR_ROT(int context)								// Parallel I/O Interrupt subroutine
{
    int ct;
	int KeyData = key->np_piodata;								// Get interrupt data to asign respective ISR
	int Rot_Dir = KeyData & 0x000FFF;							// Get interrupt data to asign respective ISR
	
	     /*
    if (MenuStatus[10][2] == 1)
    {
        DoDisableTimer2Interrupt();
        Continius = 0;
        UserIface_active = 0;
        TriggerModeChanged = 1;
        Display::StatusUpdate();
    }	   */

    ADC_Data_Available_cnt = 2;
	
	Rotary_Switch = (KeyData & 0xFFF000) >> 12;

	for (ct = 0; ct < 100; ct++){};
	
	rot_speed_read->np_piodata = 1;
	Rotary_Steps = key->np_piodata & 0x000FFF;							// Get interrupt data to asign respective ISR

	
	//printf("\nkeydata : %3x RotSW %3x RotDir %i RotaryDirec %i RotDirMem %i RotSpe : %i \n\n", key->np_piodata, Rotary_Switch, Rot_Dir, Rotary_Direction, Rotary_Direction_mem, Rotary_Steps);	

	rot_speed_read->np_piodata = 0;

	key_reset->np_piodata = 0;
	for (ct = 0; ct < 100; ct++){};
	key_reset->np_piodata = 1;

    Rotary_Changed = 1;
    //UserIface_active = 1;
    //UserIface_active_2 = 1;
       	
	rot_int->np_pioedgecapture = 0;								// clear IRQ conditions		

	if (Rotary_Switch == Rot_Dir) Rotary_Direction = 1;
    else Rotary_Direction = 0;

#ifdef _Debug_IRQ_
    if (Debug_Mode) printf("RotSW %3x RotDir %i RotaryDirec %i RotDirMem %i RotSpe : %i \n", Rotary_Switch, Rot_Dir, Rotary_Direction, Rotary_Direction_mem, Rotary_Steps);	
#endif
    Rotary_Direction_mem = Rotary_Direction;

    if (SingleMode == 1)
    {
        SingleMode = 0;

        LED_ON[14] = 0;
        LED_ON[15] = 0;
    }

}

void Hardware::Rotary_Interface(void)
{
    if (Rotary_Changed == 0) return;
    Rotary_Changed = 0;

//    ClearPlanes();

    if (Splash_drawed)
    {
        Display::REMOVE_SPLASH();
        Display::DrawStartScreen();
        Splash_drawed = false;

        TimebaseChanged = 1;
        TimeOffsetChanged = 1;
        TriggerLevelChanged = 1;
        TriggerModeChanged = 1;
        TriggerWayChanged = 1;
        VoltageChangedCh1 = 1;									// Was Voltage changed
        VoltageChangedCh2 = 1;									// Was Voltage changed
        VoltageChangedCh3 = 1;									// Was Voltage changed
        VoltageChangedCh4 = 1;									// Was Voltage changed          		
		
        Display::StatusUpdate();
	
        CursorChanged = 3;
        Cursor_Data_First_Draw = 1;
        Display::DRAWCURSORDATA(0);

        Quick_Measure_First_Draw = 1;
        Display::DRAWQMDATA(0); 	

        Display::DRAW_ALL_CURSOR();

        if (Continius) Start_Record();

        return;
    }

    if ((Active_Menu == 12) || (Active_Menu == 15)) Rotary_Direction_mem_pulse = Rotary_Direction;



#ifdef _Debug_
    if (Debug_Mode) printf("Steps = %i Dir = %i \n", Rotary_Steps, Rotary_Direction);
#endif
         if ((Rotary_Switch & 0x00000001) == 0x00000001) { ResetTimer(); ON_Rotary_Position(); }     // ON Trigger Position
    else if ((Rotary_Switch & 0x00000002) == 0x00000002) { ResetTimer(); ON_Trigger_Level(); }
    else if ((Rotary_Switch & 0x00000004) == 0x00000004) { ResetTimer(); ON_Main_Wheel(); }
    else if ((Rotary_Switch & 0x00000008) == 0x00000008) { ResetTimer(); ON_Timebase(); }
    else if ((Rotary_Switch & 0x00000010) == 0x00000010) { ResetTimer(); ON_Zero_Channel_2(); }
    else if ((Rotary_Switch & 0x00000020) == 0x00000020) { ResetTimer(); ON_Voltage_Channel_2(); }
    else if ((Rotary_Switch & 0x00000040) == 0x00000040) { ResetTimer(); ON_Voltage_Channel_1(); }
    else if ((Rotary_Switch & 0x00000080) == 0x00000080) { ResetTimer(); ON_Zero_Channel_1(); }
    else if ((Rotary_Switch & 0x00000100) == 0x00000100) { ResetTimer(); ON_Zero_Channel_4(); }
    else if ((Rotary_Switch & 0x00000200) == 0x00000200) { ResetTimer(); ON_Voltage_Channel_4(); }
    else if ((Rotary_Switch & 0x00000400) == 0x00000400) { ResetTimer(); ON_Voltage_Channel_3(); }
    else if ((Rotary_Switch & 0x00000800) == 0x00000800) { ResetTimer(); ON_Zero_Channel_3(); }

    Rotary_Steps = 0;


    ////if ((adc_started == false) && (Continius)) Start_Record();
}

void Hardware::ON_Rotary_Position(void)
{
	int pos = 0;
	
	int cd_size_buf = (int) (Cursor_Delayed_Size / 2);
	
	int rot_buf = Rotary_Steps;


//	if (Selected_Timebase > 6) rot_buf = Rotary_Steps << 2;
	
	//if (MenuStatus[10][2] == 1) return;
	
#ifdef _Debug_Memory_
    if (Debug_Mode) printf("TB Offset MS[10][1] = %d MS[10][2] = %d\n", MenuStatus[10][1], MenuStatus[10][2]);
#endif	

    if ((MenuStatus[10][1] == 0) || (MenuStatus[10][1] == 246))
    {
        rot_buf = ((int) ((float)rot_buf * ZFT_float));
        
        if ((rot_buf > ((int) ((float)5 * ZFT_float))) && (rot_buf < ((int) ((float)11 * ZFT_float)))) rot_buf = rot_buf * 3;
        else if (rot_buf > ((int) ((float)10 * ZFT_float))) rot_buf = rot_buf * 7;	

        //if ((rot_buf > 5) && (rot_buf < 11)) rot_buf = rot_buf * 15;
        //else if (rot_buf > 10) rot_buf = rot_buf * 40;	
        	
        if (Rotary_Direction)
        {
            if (Selected_Timebase < 9)
            {
                if ((Trig_Mem_Pos + SIG_Size[ZIT_short] + rot_buf) < 16250) Trig_Mem_Pos = Trig_Mem_Pos + rot_buf;
                else Trig_Mem_Pos = 16250 - SIG_Size[ZIT_short];
            }
            else
            {
                if ((Trig_Mem_Pos + SIG_Size[ZIT_short] + rot_buf) < 4070) Trig_Mem_Pos = Trig_Mem_Pos + rot_buf;
                else Trig_Mem_Pos = 4070 - SIG_Size[ZIT_short];
            }
        }
        else
        {
            if ((Trig_Mem_Pos - rot_buf) > 100) Trig_Mem_Pos = Trig_Mem_Pos - rot_buf;
            else Trig_Mem_Pos = 100;
        }

    }    		
    else  // Delayed mode
    {
        if ((rot_buf > 5) && (rot_buf < 11)) rot_buf = rot_buf * 3;
        else if (rot_buf > 10) rot_buf = rot_buf * 7;	
        
        if (Rotary_Direction)
        {
            if ((dmode_Window_Offset_Pos + rot_buf) < (300 - cd_size_buf)) dmode_Window_Offset_Pos = dmode_Window_Offset_Pos + rot_buf;
            else dmode_Window_Offset_Pos = 300 - cd_size_buf;
        }
        else
        {
            if ((dmode_Window_Offset_Pos - rot_buf) > (-300 + cd_size_buf)) dmode_Window_Offset_Pos = dmode_Window_Offset_Pos - rot_buf;
            else dmode_Window_Offset_Pos = (-300 + cd_size_buf);
        }
    }

    Recalc_Vars();
    
 // TMW changed 
	if ((MenuStatus[10][1] == 0) || (MenuStatus[10][1] == 246))
	{
        	if (Memory_Window_visible)
            	  Display::DRAWMEMORY(0, 0, 1);
        	else
	          Display::DRAWMEMORY(0, 1, 1);
     	}
// TMW change ends
    
    
    Display::CALCPRETRIGGER();
    Display::DRAW_ALL_CURSOR();

    //Display::DRAWSTATUS(5, 1);									// Draw Pre Trigger

    //if (Continius == 0)
    //UserIface_active = 0;
    DrawSignals_Needed = 1;


#ifdef _Debug_Memory_
    if (Debug_Mode) printf("TB Offset = %d\n", Timebase_Offset_Pos);
#endif
}

void Hardware::ON_Trigger_Level(void)
{
    if (MenuStatus[14][3] == 1) return;
    if ((MenuPopupStatus[8][2] == 3) && (MenuStatus[14][2] == 1)) return;
    if (Display_Mode) return;
    
    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) Rotary_Steps = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) Rotary_Steps = Rotary_Steps * 7;

    if (Rotary_Direction == 0)
    {
	    //if (triggering == 0) return;
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		
		switch(Selected_Trigger_Source)
		{
			case 1: if ((Trigger_Pos_CH1 + Rotary_Steps) < 386) Trigger_Pos_CH1 = Trigger_Pos_CH1 + Rotary_Steps; else Trigger_Pos_CH1 = 386; Trigger_Pos_CH1_os = 0; break;
			case 2: if ((Trigger_Pos_CH2 + Rotary_Steps) < 386) Trigger_Pos_CH2 = Trigger_Pos_CH2 + Rotary_Steps; else Trigger_Pos_CH2 = 386; Trigger_Pos_CH2_os = 0; break;
			case 3: if ((Trigger_Pos_CH3 + Rotary_Steps) < 386) Trigger_Pos_CH3 = Trigger_Pos_CH3 + Rotary_Steps; else Trigger_Pos_CH3 = 386; Trigger_Pos_CH3_os = 0; break;
			case 4: if ((Trigger_Pos_CH4 + Rotary_Steps) < 386) Trigger_Pos_CH4 = Trigger_Pos_CH4 + Rotary_Steps; else Trigger_Pos_CH4 = 386; Trigger_Pos_CH4_os = 0; break;
			case 5: if ((Trigger_Pos_CHE + 1) < 32) Trigger_Pos_CHE = Trigger_Pos_CHE + 1; else Trigger_Pos_CHE = 32; break;
		}
			
		
        UpdateTrigger(16);

		Display::DRAWSTATUS(6, 1);									// Draw Trigger Level

        //S Display::Update_Channel_Data(Selected_Trigger_Source);
        VS_TrigLevelChanged = 1;

        DrawSignals_Needed = 1;
    }

    else
    {
	   //if (triggering == 0) return;
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		
		switch(Selected_Trigger_Source)
		{
			case 1: if ((Trigger_Pos_CH1 - Rotary_Steps) > 0) Trigger_Pos_CH1 = Trigger_Pos_CH1 - Rotary_Steps; else Trigger_Pos_CH1 = 0; break;
			case 2: if ((Trigger_Pos_CH2 - Rotary_Steps) > 0) Trigger_Pos_CH2 = Trigger_Pos_CH2 - Rotary_Steps; else Trigger_Pos_CH2 = 0; break;
			case 3: if ((Trigger_Pos_CH3 - Rotary_Steps) > 0) Trigger_Pos_CH3 = Trigger_Pos_CH3 - Rotary_Steps; else Trigger_Pos_CH3 = 0; break;
			case 4: if ((Trigger_Pos_CH4 - Rotary_Steps) > 0) Trigger_Pos_CH4 = Trigger_Pos_CH4 - Rotary_Steps; else Trigger_Pos_CH4 = 0; break;
			case 5: if ((Trigger_Pos_CHE - 1) > 0) Trigger_Pos_CHE = Trigger_Pos_CHE - 1; else Trigger_Pos_CHE = 0; break;
		}

		
        UpdateTrigger(17);

		Display::DRAWSTATUS(6, 1);									// Draw Trigger Level

        //S Display::Update_Channel_Data(Selected_Trigger_Source);
        VS_TrigLevelChanged = 1;

        DrawSignals_Needed = 1;
    }
}

void Hardware::ON_Main_Wheel(void)
{
    if (Rotary_Direction)
    {
        HandleMainWheel(1);
    }
    else
    {
        HandleMainWheel(0);
    }
}

void Hardware::ON_Timebase(void)
{
    int rbuf = Rotary_Steps;

//    reset_watchdog->np_piodata = 0x00;

    //printf("On_TB_1_%d : rbuf : %d distb :%d = Sel %d + idx %d\n", Rotary_Direction, rbuf, Display_Timebase, Selected_Timebase, SIGNALFaktor_idx);

    Display_Timebase_Old = Display_Timebase;
    Selected_Timebase_Old = Selected_Timebase;
    SIGNALFaktor_idx_Old = SIGNALFaktor_idx;
                
    if (Rotary_Direction)
    {
//		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }          	
		
		// Delayed Mode
		if (MenuStatus[10][1] == 1)
		{
            if (Continius == 0)
            {
                while (rbuf > 0)
                {
                    if (dmode_SIGNALFaktor_idx > 0)
                    {	
                        dmode_SIGNALFaktor_idx--;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((dmode_Selected_Timebase > 2) && (dmode_Selected_Timebase < 5) && (dmode_SIGNALFaktor_idx == 0) && (Selected_Timebase < 5))
                    {
                        dmode_Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    rbuf--;
                }

                DrawSignals_Needed = 1;
                UserIface_active = 0;

            }
            else
            {
                while (rbuf > 0)
                {
                    if ((dmode_Selected_Timebase > 4) && (dmode_SIGNALFaktor_idx == 4))
                    {
                        dmode_Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    else if (dmode_SIGNALFaktor_idx > 0)
                    {	
                        dmode_SIGNALFaktor_idx--;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((dmode_Selected_Timebase > 2) && (dmode_SIGNALFaktor_idx == 0) && (Selected_Timebase < 5))
                    {
                        dmode_Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    rbuf--;
                }
            }			
		}    /*
		// Roll Mode
		else if (MenuStatus[10][2] == 1)
		{
            while (rbuf > 0)
            {		
                if (ROLLMODE_TB > 3)
                {
                    ROLLMODE_TB--;
                    ROLLMODE_OFFSET = 601;
                    ROLLMODE_STARTED = false;
                    ROLLMODE_Value_rec = false;
                    ClearPlanes();
                }
                rbuf--;
            }
		}    */
		// Main Mode
		else		
		{	  	
            if (Continius == 0)
            {
                while (rbuf > 0)
                {
                    if (SIGNALFaktor_idx > 0)
                    {	
                        SIGNALFaktor_idx--;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((Selected_Timebase > 2) && (Selected_Timebase < 5) && (SIGNALFaktor_idx == 0))
                    {
                        Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    rbuf--;
                }

                DrawSignals_Needed = 1;
                UserIface_active = 0;

            }
            else
            {
                while (rbuf > 0)
                {
                    if ((Selected_Timebase > 4) && (SIGNALFaktor_idx == 4))
                    {
                        Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx == 2))
                    {
                        Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    else if (SIGNALFaktor_idx > 0)
                    {	
                        SIGNALFaktor_idx--;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((Selected_Timebase > 2) && (SIGNALFaktor_idx == 0))
                    {
                        Selected_Timebase--;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    
                    if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
                    {
                        if (Selected_Timebase_Old < 6)
                        {
                            Selected_Timebase = 9;
                            SIGNALFaktor_idx = 2;
                        }
                    }

                    if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
                    {
                        if (Selected_Timebase_Old == 9)
                        {
                            Selected_Timebase = 6;
                            SIGNALFaktor_idx = 4;
                        }
                    }

                    rbuf--;
                }
            }		
		}
    }
    else
    {
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }

        // Delayed Mode
		if (MenuStatus[10][1] == 1)
		{	
            if (Continius == 0)
            {
                while (rbuf > 0)
                {
                    if ((dmode_Selected_Timebase > 1) && (dmode_Selected_Timebase < 4) && (dmode_SIGNALFaktor_idx == 0) && (dmode_Selected_Timebase < (Selected_Timebase - 1)))
                    {
                        dmode_Selected_Timebase++;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
	
                    else if ((dmode_SIGNALFaktor_idx < 4) && (dmode_SIGNALFaktor_idx < (SIGNALFaktor_idx - 1)) && (dmode_Selected_Timebase == Selected_Timebase))
                    {	
                        dmode_SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }
                    
                    rbuf--;
                }                	

                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }	
            else
            {
                while (rbuf > 0)
                {
                    if ((dmode_Selected_Timebase > 1) && (dmode_Selected_Timebase < 5) && (((dmode_SIGNALFaktor_idx == 0) && (dmode_Selected_Timebase < (Selected_Timebase - 1)))  || ((SIGNALFaktor_idx > 0) && (dmode_Selected_Timebase < Selected_Timebase)) ))
                    {
                        dmode_Selected_Timebase++;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
	
                    else if ((dmode_SIGNALFaktor_idx < 4) && (dmode_SIGNALFaktor_idx < (SIGNALFaktor_idx - 1)) && (dmode_Selected_Timebase == Selected_Timebase))
                    {	
                        dmode_SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }

                    rbuf--;
		        }
		    }       	
		}   /*
		// Roll Mode
		else if (MenuStatus[10][2] == 1)
		{
            while (rbuf > 0)
            {		
                if (ROLLMODE_TB < 8)
                {
                    ROLLMODE_TB++;
                    ROLLMODE_OFFSET = 601;
                    ROLLMODE_STARTED = false;	
                    ROLLMODE_Value_rec = false;
                    ClearPlanes();
                }
                rbuf--;
            }
		}    */
		// Main Mode
		else
		{        		                                                             		
            if (Continius == 0)
            {
                while (rbuf > 0)
                {
                	if ((Selected_Timebase > 1) && (Selected_Timebase < 4) && (SIGNALFaktor_idx == 0))
                	{
                		Selected_Timebase++;
                		TimebaseChanged = 1;
                		SIGNALFaktorChanged = 1;
                	}                	
                	else if ((Selected_Timebase < 8) && (SIGNALFaktor_idx < 4))
                	{	
                        SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }
                	else if ((Selected_Timebase > 7) && (SIGNALFaktor_idx < 2))
                    {	
                        SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }

                    rbuf--;
                }

                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }	
            else
            {
                //printf("Here we are %d %d %d\n", Selected_Timebase, SIGNALFaktor_idx, Selected_Timebase_Old);
                		
                while (rbuf > 0)
                {
                    if (Selected_Timebase == 2)
                    {
                        Selected_Timebase++;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }
                    else if (Selected_Timebase == 3)
                    {
                        Selected_Timebase++;
                        TimebaseChanged = 1;
                        SIGNALFaktorChanged = 1;
                    }		
                    else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx < 4))
                    {	
                        SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx < 2))
                    {	
                        SIGNALFaktor_idx++;
                        SIGNALFaktorChanged = 1;
                    }
                    else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx == 4))
                    {
                        if (Selected_Timebase < 31)
                        {
                            Selected_Timebase++;
                            TimebaseChanged = 1;
                            SIGNALFaktorChanged = 1;
                        }
                    }
                    else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx == 2))
                    {
                        if (Selected_Timebase < 31)
                        {
                            Selected_Timebase++;
                            TimebaseChanged = 1;
                            SIGNALFaktorChanged = 1;
                        }
                    }
                    
                    if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
                    {
                        if (Selected_Timebase_Old < 7)
                        {
                            Selected_Timebase = 9;
                            SIGNALFaktor_idx = 2;
                        }
                    }

                    if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
                    {
                        if (Selected_Timebase_Old > 8)
                        {
                            Selected_Timebase = 6;
                            SIGNALFaktor_idx = 4;
                        }
                    }

                    rbuf--;
		        }
                //printf("Here we are2 %d %d %d\n", Selected_Timebase, SIGNALFaktor_idx, Selected_Timebase_Old);		
		    }
        }		
    }
    
	timebase_reg = tb_value[Selected_Timebase];
    Display_Timebase = Selected_Timebase + SIGNALFaktor_idx;
    
    if (Selected_Timebase > 7) adc_change12_reg |= 0x01000000;
    else adc_change12_reg &= 0xFEFFFFFF;

//    printf("On_TB_2_O distb_old :%d = Sel_old %d + idx_old %d\n", Display_Timebase_Old, Selected_Timebase_Old, SIGNALFaktor_idx_Old);    
//    printf("On_TB_2_%d : rbuf : %d distb :%d = Sel %d + idx %d\n", Rotary_Direction, rbuf, Display_Timebase, Selected_Timebase, SIGNALFaktor_idx);
    //printf("TB_reg %8x \n", timebase_reg);

   	Recalc_Vars();

    //printf("TPM : %d  %d\n", Trig_Pos_Mem, Trig_Pos_Display);
       	   	
	if (Cursor_Enabled)
	{
        Display::CALCCURSORDATA();

        if (Active_Menu == 16)
        {
            MenuItemChanged[1] = 1;
            MenuItemChanged[2] = 1;
            New_Menu = Active_Menu;
        }
        Menu_Changed = 1;
        CursorChanged = 1;
    }
	
	Display::DRAWSTATUS(0, 1);
	SetupADC();	

	if (Channel_1_Active == 1)
	{	
        if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate[0]);
        if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate_delayed[0]);
	}
	
	if (Channel_2_Active == 1)
	{	
        if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2_Intpolate[0]);
        if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2_Intpolate_delayed[0]);
	}
	
	if (Channel_3_Active == 1)
	{	
        if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL3[0], &SIGNAL3_Intpolate[0]);
        if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL3[0], &SIGNAL3_Intpolate_delayed[0]);
	}
	
	if (Channel_4_Active == 1)
	{	
        if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL4[0], &SIGNAL4_Intpolate[0]);
        if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL4[0], &SIGNAL4_Intpolate_delayed[0]);
	}	

// TMW changed
	if (Memory_Window_visible) 		// if Memory Window visible
          Display::DRAWMEMORY(0, 0, 1); 	// redraw Memory Window
   	else
	  Display::DRAWMEMORY(0, 1, 1); 	// if Memory Window not visible yet, make it visible.
// TMW change ends



   /*
    if (Cursor_Vertical_Position_Real1 < SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float)) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
    if (Cursor_Vertical_Position_Real1 > SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float)) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);

    if (Cursor_Vertical_Position_Real2 < SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float)) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
    if (Cursor_Vertical_Position_Real2 > SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float)) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);
 */

    Menu_Changed = 1;
    MenuItemChanged[4] = 1;
    Display::CALCPRETRIGGER();
    Display::CALCCURSORDATA();
    Display::DRAW_ALL_CURSOR();

//    reset_watchdog->np_piodata = 0x01;

}

void Hardware::Recalc_Vars(void)
{
	ZIT_short_old       = ZIT_short;
	ZIT_short_dmode_old = ZIT_short_dmode;
	ZFT_float_old       = ZFT_float;
	ZFT_float_dmode_old = ZFT_float_dmode;
	OFT_float_old       = OFT_float;
    	
	ZIT_short       = Zoom_Index_Table[Selected_Timebase][SIGNALFaktor_idx];
	ZIT_short_dmode = Zoom_Index_Table[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx];
	
	ZFT_float       = Zoom_Faktor_Table[ZIT_short];
	ZFT_float_dmode = Zoom_Faktor_Table[ZIT_short_dmode];
	
	OFT_float = Offset_Faktor_Table[ZIT_short];

//    printf("1 ZITs : %d  %d  ", ZIT_short, ZIT_short_old);
//    printf("ZFTf : %f  %f  ", ZFT_float, ZFT_float_old);
//    printf("OFTf : %f  %f\n", OFT_float, OFT_float_old);    
    
//    printf("TPM : %d  %d\n", Trig_Pos_Mem, Trig_Pos_Display);

    //if ((Selected_Timebase > 3) && (Selected_Timebase_Old > 3))
    {
      //  if (ZFT_float_old != ZFT_float)
        {
            // Correct the Trigger Position
            Trig_Pos_Mem = (int)((float) Trig_Pos_Mem * (ZFT_float / ZFT_float_old));
            
            // Correct the Memory Position
            Trig_Mem_Pos = (int)((float) (Trig_Mem_Pos) * (ZFT_float / ZFT_float_old));
        }
    }
    
//    printf("A TPM : %d  %d\n\n", Trig_Pos_Mem, Trig_Pos_Display); 
    
    // Check memory pos
    
    //if (Selected_Timebase < 4)
    {
        if (Trig_Mem_Pos < 100) 
        {
//        	printf("tmp : %d = to small\n", Trig_Mem_Pos);
        	
        	Trig_Pos_Mem = Trig_Pos_Mem + (100 - Trig_Mem_Pos);
        	
        	Trig_Mem_Pos = 100;
        	
        }
       // if (Trig_Pos_Mem < 100) Trig_Pos_Mem = 100;
    }/*
    else if (Selected_Timebase == 4)
    {
        if (Trig_Mem_Pos < 100) Trig_Mem_Pos = 100;
    }        
    else */if (Selected_Timebase < 9)
    {
        if ((Trig_Mem_Pos + SIG_Size[ZIT_short]) > 16250) Trig_Mem_Pos = 16250 - SIG_Size[ZIT_short];
    }
    else
    {
        if ((Trig_Mem_Pos + SIG_Size[ZIT_short]) > 4070) Trig_Mem_Pos = 4070 - SIG_Size[ZIT_short];
    }

//   printf("B TPM : %d  %d\n\n", Trig_Pos_Mem, Trig_Pos_Display); 
    
    //// if (Trig_Mem_Pos > 583) Trig_Mem_Pos = 583;
   //// if (Trig_Mem_Pos < 1) Trig_Mem_Pos = 1;

    if (MenuStatus[10][1] == 1)
    {
        dmode_factor = Timebase_Delayed_Factor_Matrix[Selected_Timebase][SIGNALFaktor_idx] / Timebase_Delayed_Factor_Matrix[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx];

        Cursor_Delayed_1 = ((GRID_WIDTH / 2) - (int) (((float) GRID_WIDTH / dmode_factor) / 2)) + dmode_Window_Offset_Pos;
        Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / dmode_factor);
        Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;
    }
    
    Recalc_Trigger();

    ////if (Selected_Timebase < 4) FirStartCH = (int)((float) Trig_Mem_Pos * OFT_float) + 20;
    if (Selected_Timebase < 4) FirStartCH = Trig_Mem_Pos + 40;
    
    
//    printf("2 ZITs : %d  %d  ", ZIT_short, ZIT_short_old);
//    printf("ZFTf : %f  %f  ", ZFT_float, ZFT_float_old);
//    printf("OFTf : %f  %f\n", OFT_float, OFT_float_old);    
    
//    printf("2 TPM : %d  %d\n\n", Trig_Pos_Mem, Trig_Pos_Display);    

}

void Hardware::Recalc_Trigger(void)
{
    FirStartCH_delayed = (short) (ZFT_float * (float) (Cursor_Delayed_1 + (Cursor_Delayed_Size >> 1))) - 10;
    
//    printf("C1 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, Trig_Mem_Pos, Trig_Pos_Display);
    
    Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - Trig_Mem_Pos) / ZFT_float);
    Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - Trig_Mem_Pos) / ZFT_float_dmode) - ((float) Cursor_Delayed_1 * (ZFT_float / ZFT_float_dmode)));
    
    if (Selected_Timebase < 9) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;
    else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;

//    printf("C2 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, Trig_Mem_Pos, Trig_Pos_Display);
    
    if (pre_reg > 0x1000)
    {
    	printf("pre overrun \n");
        Trig_Pos_Mem = 300;
        Trig_Mem_Pos = 100;

        Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - Trig_Mem_Pos) / ZFT_float);

        if (Selected_Timebase < 9) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;
        else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;
    }
    
//    printf("C3 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, Trig_Mem_Pos, Trig_Pos_Display);
}

void Hardware::ON_Voltage_Channel_1(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_1_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH1 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH1 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH1 -= Rotary_Steps;
		}
		else Selected_Voltage_CH1 = 3;
		
		SetSwitches(1, Selected_Voltage_CH1);
		VoltageChangedCh1 = 1;

        if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(1, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	
             /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }*/			
    }
    else
    {
        if (Selected_Voltage_CH1 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH1 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH1 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH1 = 11;	

		SetSwitches(1, Selected_Voltage_CH1);
		VoltageChangedCh1 = 1;
			
		if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(1, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
                  /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }   */
    }

    Rotary_Steps = 0;
    ON_Zero_Channel_1();
}

void Hardware::ON_Zero_Channel_1(void)
{
    int lChannel1_Zero_Sign_Offset_1, lChannel1_Zero_Sign_Offset_2, lChannel1_Zero_Sign_Offset_3, Virtual_ZeroLevel_Buf;

    int rotbuf;
    
    //If XY-mode leave function
    if (Display_Mode) return;

    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
    else rotbuf = Rotary_Steps;
	

    if (rotbuf)
    {
        if (Rotary_Direction == 0)
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if (Display_Mode)	//XY-mode
            {
                if ((Virtual_ZeroLevelXYCH1 + rotbuf) > ((GRID_XY / 2) - 1)) // 0
                {
                    Virtual_ZeroLevelXYCH1 = Virtual_ZeroLevelXYCH1 + rotbuf;
                }		
                else
                {
                    Virtual_ZeroLevelXYCH1 = ((GRID_XY / 2) - 1);  // 0
                }
            }
            else	//Normal mode
            {
                if ((Virtual_ZeroLevelCH1 + rotbuf) < 4095) // 0
                {
                    Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1 + rotbuf;
                }		
                else
                {
                    Virtual_ZeroLevelCH1 = 4095;  // 0
                }
            }
		
            if (Continius == false)
            {
                CH1_Zero_Offset = CH1_Zero_Offset + rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }  	
		
            VS_ZeroChangedCh1 = 1;

            if ((Virtual_ZeroLevelCH1 < 4095) && (Virtual_ZeroLevelCH1 > -4095))
            {
                if (Trigger_Pos_CH1_os < 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH1_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH1_os++;
                    }
                }
                if ((Trigger_Pos_CH1 + rotbuf) <= GRID_HEIGHT) Trigger_Pos_CH1 = Trigger_Pos_CH1 + rotbuf;	//BF 386
                else
                {
                    Trigger_Pos_CH1_os = Trigger_Pos_CH1_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH1));
                    Trigger_Pos_CH1 = GRID_HEIGHT;	
                }
            }
            
            if (Selected_Trigger_Source == 1)
            {
                UpdateTrigger(18);	
            }
        }
        else
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if (Display_Mode)	//XY-mode
            {
                if ((Virtual_ZeroLevelXYCH1 - rotbuf) > (-1 * ((GRID_XY / 2) - 1)))
                {
                    Virtual_ZeroLevelXYCH1 = Virtual_ZeroLevelXYCH1 - rotbuf;
                }		
                else
                {
                    Virtual_ZeroLevelXYCH1 = -1 * ((GRID_XY / 2) - 1);  // 0
                }
            }
            else
            {
                if ((Virtual_ZeroLevelCH1 - rotbuf) > -4095) // 0
                {
                    Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1 - rotbuf;
                }		
                else
                {
                    Virtual_ZeroLevelCH1 = -4095;  // 0
                }
            }

            if (Continius == false)
            {
                CH1_Zero_Offset = CH1_Zero_Offset - rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }		
            
            VS_ZeroChangedCh1 = 1;
		
            if ((Virtual_ZeroLevelCH1 < 4095) && (Virtual_ZeroLevelCH1 > -4095))
            {
                if (Trigger_Pos_CH1_os > 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH1_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH1_os--;
                    }
                }
                if ((Trigger_Pos_CH1 - rotbuf) >= 0) Trigger_Pos_CH1 = Trigger_Pos_CH1 - rotbuf;
                else
                {
                    Trigger_Pos_CH1_os = Trigger_Pos_CH1_os - (rotbuf - Trigger_Pos_CH1);
                    
                    Trigger_Pos_CH1 = 0;
                }
            }
            
            if (Selected_Trigger_Source == 1)
            {
                UpdateTrigger(19);	
            }
        }
    }


    if (Display_Mode)
    {
        ZeroLevelCH1 = Virtual_ZeroLevelXYCH1 + (GRID_XY / 2);
        if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
        if (ZeroLevelCH1 > GRID_XY) ZeroLevelCH1 = GRID_XY;

        Virtual_ZeroLevel_Buf = Virtual_ZeroLevelXYCH1 >> 2;
    }
    else
    {
        ZeroLevelCH1 = Virtual_ZeroLevelCH1 + (GRID_HEIGHT / 2);
        if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
        if (ZeroLevelCH1 > (GRID_HEIGHT + 1)) ZeroLevelCH1 = (GRID_HEIGHT + 1);

        Virtual_ZeroLevel_Buf = Virtual_ZeroLevelCH1 >> 2;
    }

    lChannel1_Zero_Sign_Offset_1 = 8192 + Channel1_Zero_Sign_Offset_1;
    lChannel1_Zero_Sign_Offset_2 = 8192 + Channel1_Zero_Sign_Offset_2;
    lChannel1_Zero_Sign_Offset_3 = 8192 + Channel1_Zero_Sign_Offset_3 + Virtual_ZeroLevel_Buf;

    if (Display_Mode)
    {
        switch(Selected_Voltage_CH1)
        {
            case 0: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / Volt_Correct_float[0][0])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -   1 mV
            case 1: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / Volt_Correct_float[0][1])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 -   2 mV
            case 2: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / Volt_Correct_float[0][2])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 -   5 mV
            case 3: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / Volt_Correct_float[0][3])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -  10 mV
            case 4: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / Volt_Correct_float[0][4])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 -  20 mV
            case 5: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / Volt_Correct_float[0][5])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 -  50 mV
            case 6: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / Volt_Correct_float[0][6])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 - 100 mV
            case 7: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / Volt_Correct_float[0][7])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 - 200 mV
            case 8: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / Volt_Correct_float[0][8])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 - 500 mV
            case 9: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / Volt_Correct_float[0][9])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -   1 V
            case 10: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / Volt_Correct_float[0][10])) + lChannel1_Zero_Sign_Offset_2; break;   // 210 -   2 V
            case 11: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / Volt_Correct_float[0][11])) + lChannel1_Zero_Sign_Offset_3; break;   // 100 -   5 V
        }
    }
    else
    {
        switch(Selected_Voltage_CH1)
        {
            case 0: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / Volt_Correct_float[0][0])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -   1 mV
            case 1: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / Volt_Correct_float[0][1])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 -   2 mV
            case 2: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / Volt_Correct_float[0][2])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 -   5 mV
            case 3: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / Volt_Correct_float[0][3])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -  10 mV
            case 4: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / Volt_Correct_float[0][4])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 -  20 mV
            case 5: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / Volt_Correct_float[0][5])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 -  50 mV
            case 6: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / Volt_Correct_float[0][6])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 - 100 mV
            case 7: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / Volt_Correct_float[0][7])) + lChannel1_Zero_Sign_Offset_2; break;    // 210 - 200 mV
            case 8: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / Volt_Correct_float[0][8])) + lChannel1_Zero_Sign_Offset_3; break;    // 100 - 500 mV
            case 9: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / Volt_Correct_float[0][9])) + lChannel1_Zero_Sign_Offset_1; break;    // 110 -   1 V
            case 10: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / Volt_Correct_float[0][10])) + lChannel1_Zero_Sign_Offset_2; break;   // 210 -   2 V
            case 11: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / Volt_Correct_float[0][11])) + lChannel1_Zero_Sign_Offset_3; break;   // 100 -   5 V
        }
    }

    SetDacOffset(1);
}

void Hardware::ON_Voltage_Channel_2(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_2_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH2 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH2 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH2 -= Rotary_Steps;
		}
		else Selected_Voltage_CH2 = 3;
		
		SetSwitches(2, Selected_Voltage_CH2);
		VoltageChangedCh2 = 1;

        if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(2, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	
             /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }*/			
    }
    else
    {
        if (Selected_Voltage_CH2 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH2 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH2 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH2 = 11;	

		SetSwitches(2, Selected_Voltage_CH2);
		VoltageChangedCh2 = 1;
			
		if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(2, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
                  /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }   */
    }

    Rotary_Steps = 0;
    ON_Zero_Channel_2();
}

void Hardware::ON_Zero_Channel_2(void)
{
    int lChannel2_Zero_Sign_Offset_1, lChannel2_Zero_Sign_Offset_2, lChannel2_Zero_Sign_Offset_3, Virtual_ZeroLevel_Buf;

    //If XY-mode leave function
    if (Display_Mode) return;

    int rotbuf;

    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
    else rotbuf = Rotary_Steps;


    if (rotbuf)
    {
        if (Rotary_Direction == 0)
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if ((Virtual_ZeroLevelCH2 + rotbuf) < 4095) //16384
            {
                Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2 + rotbuf;
            }
            else
            {
                Virtual_ZeroLevelCH2 = 4095; //16384
            }	
		
            if (Continius == false)
            {
                CH2_Zero_Offset = CH2_Zero_Offset + rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }  	
		
            VS_ZeroChangedCh2 = 1;

            
            if ((Virtual_ZeroLevelCH2 < 4095) && (Virtual_ZeroLevelCH2 > -4095))
            {
                if (Trigger_Pos_CH2_os < 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH2_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH2_os++;
                    }
                }
                if ((Trigger_Pos_CH2 + rotbuf) <= GRID_HEIGHT) Trigger_Pos_CH2 = Trigger_Pos_CH2 + rotbuf;	//BF  old 386
                else
                {
                    Trigger_Pos_CH2_os = Trigger_Pos_CH2_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH2));	//BF  old 386
                    Trigger_Pos_CH2 = GRID_HEIGHT;								//BF  old 386
                }
            }
            

            if (Selected_Trigger_Source == 2)
            {
                UpdateTrigger(20);	
            }
        }
        else
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if ((Virtual_ZeroLevelCH2 - rotbuf) > -4095) // 0
            {
                Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2 - rotbuf;
            }		
            else
            {
                Virtual_ZeroLevelCH2 = -4095;  // 0
            }

            if (Continius == false)
            {
                CH2_Zero_Offset = CH2_Zero_Offset - rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }		
		
            VS_ZeroChangedCh2 = 1;

            if ((Virtual_ZeroLevelCH2 < 4095) && (Virtual_ZeroLevelCH2 > -4095))
            {
                if (Trigger_Pos_CH2_os > 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH2_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH2_os--;
                    }
                }
                if ((Trigger_Pos_CH2 - rotbuf) >= 0) Trigger_Pos_CH2 = Trigger_Pos_CH2 - rotbuf;
                else
                {
                    Trigger_Pos_CH2_os = Trigger_Pos_CH2_os - (rotbuf - Trigger_Pos_CH2);

                    Trigger_Pos_CH2 = 0;
                }
            }

            if (Selected_Trigger_Source == 2)
            {
                UpdateTrigger(21);
            }	
        }
    }

    ZeroLevelCH2 = Virtual_ZeroLevelCH2 + (GRID_HEIGHT / 2);
    if (ZeroLevelCH2 < 0) ZeroLevelCH2 = 0;
    if (ZeroLevelCH2 > (GRID_HEIGHT + 1)) ZeroLevelCH2 = (GRID_HEIGHT + 1);

    Virtual_ZeroLevel_Buf = Virtual_ZeroLevelCH2 >> 2;

    lChannel2_Zero_Sign_Offset_1 = 8192 + Channel2_Zero_Sign_Offset_1;
    lChannel2_Zero_Sign_Offset_2 = 8192 + Channel2_Zero_Sign_Offset_2;
    lChannel2_Zero_Sign_Offset_3 = 8192 + Channel2_Zero_Sign_Offset_3 + Virtual_ZeroLevel_Buf;

    switch(Selected_Voltage_CH2)
    {
        case 0: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / Volt_Correct_float[1][0])) + lChannel2_Zero_Sign_Offset_1; break;    // 110 -   1 mV
        case 1: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / Volt_Correct_float[1][1])) + lChannel2_Zero_Sign_Offset_2; break;    // 210 -   2 mV
        case 2: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / Volt_Correct_float[1][2])) + lChannel2_Zero_Sign_Offset_3; break;    // 100 -   5 mV
        case 3: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / Volt_Correct_float[1][3])) + lChannel2_Zero_Sign_Offset_1; break;    // 110 -  10 mV
        case 4: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / Volt_Correct_float[1][4])) + lChannel2_Zero_Sign_Offset_2; break;    // 210 -  20 mV
        case 5: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / Volt_Correct_float[1][5])) + lChannel2_Zero_Sign_Offset_3; break;    // 100 -  50 mV
        case 6: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / Volt_Correct_float[1][6])) + lChannel2_Zero_Sign_Offset_1; break;    // 110 - 100 mV
        case 7: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / Volt_Correct_float[1][7])) + lChannel2_Zero_Sign_Offset_2; break;    // 210 - 200 mV
        case 8: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / Volt_Correct_float[1][8])) + lChannel2_Zero_Sign_Offset_3; break;    // 100 - 500 mV
        case 9: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / Volt_Correct_float[1][9])) + lChannel2_Zero_Sign_Offset_1; break;    // 110 -   1 V
        case 10: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / Volt_Correct_float[1][10])) + lChannel2_Zero_Sign_Offset_2; break;   // 210 -   2 V
        case 11: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / Volt_Correct_float[1][11])) + lChannel2_Zero_Sign_Offset_3; break;   // 100 -   5 V
    }

    SetDacOffset(2);	

}

void Hardware::ON_Voltage_Channel_3(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_3_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH3 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH3 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH3 -= Rotary_Steps;
		}
		else Selected_Voltage_CH3 = 3;
		
		SetSwitches(3, Selected_Voltage_CH3);
		VoltageChangedCh3 = 1;

        if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(3, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	
             /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }*/			
    }
    else
    {
        if (Selected_Voltage_CH3 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH3 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH3 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH3 = 11;	

		SetSwitches(3, Selected_Voltage_CH3);
		VoltageChangedCh3 = 1;
			
		if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(3, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
                  /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }   */
    }

    Rotary_Steps = 0;
    ON_Zero_Channel_3();
}

void Hardware::ON_Zero_Channel_3(void)
{
    int lChannel3_Zero_Sign_Offset_1, lChannel3_Zero_Sign_Offset_2, lChannel3_Zero_Sign_Offset_3, Virtual_ZeroLevel_Buf;
    
    //If XY-mode leave function
    if (Display_Mode) return;

    int rotbuf;

    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
    else rotbuf = Rotary_Steps;

    if (rotbuf)
    {
        if (Rotary_Direction == 0)
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
         if ((Virtual_ZeroLevelCH3 + rotbuf) < 4095) //16384
            {
                Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3 + rotbuf;
            }
            else
            {
                Virtual_ZeroLevelCH3 = 4095; //16384
            }	
		
           if (Continius == false)
            {
                CH3_Zero_Offset = CH3_Zero_Offset + rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }  	
		
            VS_ZeroChangedCh3 = 1;

            if ((Virtual_ZeroLevelCH3 < 4095) && (Virtual_ZeroLevelCH3 > -4095))
            {
                if (Trigger_Pos_CH3_os < 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH3_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH3_os++;
                    }
                }
                if ((Trigger_Pos_CH3 + rotbuf) <= GRID_HEIGHT) Trigger_Pos_CH3 = Trigger_Pos_CH3 + rotbuf;	// BF old 386
                else
                {
                    Trigger_Pos_CH3_os = Trigger_Pos_CH3_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH3));	// BF old 386
                    Trigger_Pos_CH3 = GRID_HEIGHT;								// BF old 386
                }
            }

         if (Selected_Trigger_Source == 3)
            {
                UpdateTrigger(20);	
            }
        }
        else
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if ((Virtual_ZeroLevelCH3 - rotbuf) > -4095) // TMW repaired (xchged Rotary_Steps/rotbuf)
            {
                Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3 - rotbuf; // TMW repaired (xchged Rotary_Steps/rotbuf)
            }		
            else
            {
                Virtual_ZeroLevelCH3 = -4095;  // 0
            }                                		

            if (Continius == false)
            {
                CH3_Zero_Offset = CH3_Zero_Offset - rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }		
		
            VS_ZeroChangedCh3 = 1;

            if ((Virtual_ZeroLevelCH3 < 4095) && (Virtual_ZeroLevelCH3 > -4095))
            {
                if (Trigger_Pos_CH3_os > 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH3_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH3_os--;
                    }
                }
                if ((Trigger_Pos_CH3 - rotbuf) >= 0) Trigger_Pos_CH3 = Trigger_Pos_CH3 - rotbuf;
                else
                {
                    Trigger_Pos_CH3_os = Trigger_Pos_CH3_os - (rotbuf - Trigger_Pos_CH3);

                    Trigger_Pos_CH3 = 0;
                }
            }

            if (Selected_Trigger_Source == 3)
            {
                UpdateTrigger(21);
            }	
        }
    }

    ZeroLevelCH3 = Virtual_ZeroLevelCH3 + (GRID_HEIGHT / 2);
    if (ZeroLevelCH3 < 0) ZeroLevelCH3 = 0;
    if (ZeroLevelCH3 > (GRID_HEIGHT + 1)) ZeroLevelCH3 = (GRID_HEIGHT + 1);

    Virtual_ZeroLevel_Buf = Virtual_ZeroLevelCH3 >> 2;

    lChannel3_Zero_Sign_Offset_1 = 8192 + Channel3_Zero_Sign_Offset_1;
    lChannel3_Zero_Sign_Offset_2 = 8192 + Channel3_Zero_Sign_Offset_2;
    lChannel3_Zero_Sign_Offset_3 = 8192 + Channel3_Zero_Sign_Offset_3 + Virtual_ZeroLevel_Buf;

    switch(Selected_Voltage_CH3)
    {
        case 0: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / Volt_Correct_float[2][0])) + lChannel3_Zero_Sign_Offset_1; break;    // 110 -   1 mV
        case 1: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / Volt_Correct_float[2][1])) + lChannel3_Zero_Sign_Offset_2; break;    // 210 -   2 mV
        case 2: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / Volt_Correct_float[2][2])) + lChannel3_Zero_Sign_Offset_3; break;    // 100 -   5 mV
        case 3: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / Volt_Correct_float[2][3])) + lChannel3_Zero_Sign_Offset_1; break;    // 110 -  10 mV
        case 4: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / Volt_Correct_float[2][4])) + lChannel3_Zero_Sign_Offset_2; break;    // 210 -  20 mV
        case 5: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / Volt_Correct_float[2][5])) + lChannel3_Zero_Sign_Offset_3; break;    // 100 -  50 mV
        case 6: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / Volt_Correct_float[2][6])) + lChannel3_Zero_Sign_Offset_1; break;    // 110 - 100 mV
        case 7: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / Volt_Correct_float[2][7])) + lChannel3_Zero_Sign_Offset_2; break;    // 210 - 200 mV
        case 8: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / Volt_Correct_float[2][8])) + lChannel3_Zero_Sign_Offset_3; break;    // 100 - 500 mV
        case 9: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / Volt_Correct_float[2][9])) + lChannel3_Zero_Sign_Offset_1; break;    // 110 -   1 V
        case 10: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / Volt_Correct_float[2][10])) + lChannel3_Zero_Sign_Offset_2; break;   // 210 -   2 V
        case 11: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / Volt_Correct_float[2][11])) + lChannel3_Zero_Sign_Offset_3; break;   // 100 -   5 V
    }

    SetDacOffset(3);	
}

void Hardware::ON_Voltage_Channel_4(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_4_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH4 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH4 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH4 -= Rotary_Steps;
		}
		else Selected_Voltage_CH4 = 3;
		
		SetSwitches(4, Selected_Voltage_CH4);
		VoltageChangedCh4 = 1;

        if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(4, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	
             /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }*/			
    }
    else
    {
        if (Selected_Voltage_CH4 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH4 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH4 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH4 = 11;	

		SetSwitches(4, Selected_Voltage_CH4);
		VoltageChangedCh4 = 1;
			
		if (Cursor_Enabled)
        {
            Display::CALCCURSORDATA();
            Menu_Changed = 1;
            CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(4, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
                  /*
            if (Continius == false)
            {
                if (signal_zoomed1 == false) for (cnt = 0; cnt < 16383; cnt++) SIGNAL1_IntBuf_YZoom[cnt] = (int) SIGNAL1[cnt];

                Voltage_Zoom(&SIGNAL1[0], &SIGNAL1_IntBuf_YZoom[0], Selected_Voltage_CH1, Selected_Voltage_CH1_Old, ZeroLevelCH1);

                UserIface_active = 0;
                DrawSignals_Needed = 1;
                signal_zoomed1 = true;
            }   */
    }

    Rotary_Steps = 0;
    ON_Zero_Channel_4();
}

void Hardware::ON_Zero_Channel_4(void)
{
    int lChannel4_Zero_Sign_Offset_1, lChannel4_Zero_Sign_Offset_2, lChannel4_Zero_Sign_Offset_3, Virtual_ZeroLevel_Buf;

    //If XY-mode leave function
    if (Display_Mode) return;

    int rotbuf;

    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
    else rotbuf = Rotary_Steps;


    if (rotbuf)
    {
        if (Rotary_Direction == 0)
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if ((Virtual_ZeroLevelCH4 + rotbuf) < 4095) //16384
            {
                Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4 + rotbuf;
            }
            else
            {
                Virtual_ZeroLevelCH4 = 4095; //16384
            }	
		
            if (Continius == false)
            {
                CH4_Zero_Offset = CH4_Zero_Offset + rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }  	
		
            VS_ZeroChangedCh4 = 1;

            if ((Virtual_ZeroLevelCH4 < 4095) && (Virtual_ZeroLevelCH4 > -4095))
            {
                if (Trigger_Pos_CH4_os < 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH4_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH4_os++;
                    }
                }
                if ((Trigger_Pos_CH4 + rotbuf) <= GRID_HEIGHT) Trigger_Pos_CH4 = Trigger_Pos_CH4 + rotbuf;	// BF old 386
                else
                {
                    Trigger_Pos_CH4_os = Trigger_Pos_CH4_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH4));	// BF old 386
                    Trigger_Pos_CH4 = GRID_HEIGHT;								// BF old 386
                }
            }

            if (Selected_Trigger_Source == 4)
            {
                UpdateTrigger(20);	
            }
        }
        else
        {
            if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
            if ((Virtual_ZeroLevelCH4 - rotbuf) > -4095) 		// TMW repaired (xchged Rotary_Steps/rotbuf)
            {
                Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4 - rotbuf; 	// TMW repaired (xchged Rotary_Steps/rotbuf)
            }		
            else
            {
                Virtual_ZeroLevelCH4 = -4095;  // 0
            }                                		

            if (Continius == false)
            {
                CH4_Zero_Offset = CH4_Zero_Offset - rotbuf;
                DrawSignals_Needed = 1;
                UserIface_active = 0;
            }		
		
            VS_ZeroChangedCh4 = 1;

            if ((Virtual_ZeroLevelCH4 < 4095) && (Virtual_ZeroLevelCH4 > -4095))
            {
                if (Trigger_Pos_CH4_os > 0)
                {
                    while ((rotbuf > 0) && (Trigger_Pos_CH4_os != 0))
                    {
                        rotbuf--;
                        Trigger_Pos_CH4_os--;
                    }
                }
                if ((Trigger_Pos_CH4 - rotbuf) >= 0) Trigger_Pos_CH4 = Trigger_Pos_CH4 - rotbuf;
                else
                {
                    Trigger_Pos_CH4_os = Trigger_Pos_CH4_os - (rotbuf - Trigger_Pos_CH4);

                    Trigger_Pos_CH4 = 0;
                }
            }

            if (Selected_Trigger_Source == 4)
            {
                UpdateTrigger(21);
            }	
        }
    }

    ZeroLevelCH4 = Virtual_ZeroLevelCH4 + (GRID_HEIGHT / 2);
    if (ZeroLevelCH4 < 0) ZeroLevelCH4 = 0;
    if (ZeroLevelCH4 > (GRID_HEIGHT + 1)) ZeroLevelCH4 = (GRID_HEIGHT + 1);

    Virtual_ZeroLevel_Buf = Virtual_ZeroLevelCH4 >> 2;

    lChannel4_Zero_Sign_Offset_1 = 8192 + Channel4_Zero_Sign_Offset_1;
    lChannel4_Zero_Sign_Offset_2 = 8192 + Channel4_Zero_Sign_Offset_2;
    lChannel4_Zero_Sign_Offset_3 = 8192 + Channel4_Zero_Sign_Offset_3 + Virtual_ZeroLevel_Buf;

    switch(Selected_Voltage_CH4)
    {
        case 0: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / Volt_Correct_float[3][0])) + lChannel4_Zero_Sign_Offset_1; break;    // 110 -   1 mV
        case 1: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / Volt_Correct_float[3][1])) + lChannel4_Zero_Sign_Offset_2; break;    // 210 -   2 mV
        case 2: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / Volt_Correct_float[3][2])) + lChannel4_Zero_Sign_Offset_3; break;    // 100 -   5 mV
        case 3: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / Volt_Correct_float[3][3])) + lChannel4_Zero_Sign_Offset_1; break;    // 110 -  10 mV
        case 4: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / Volt_Correct_float[3][4])) + lChannel4_Zero_Sign_Offset_2; break;    // 210 -  20 mV
        case 5: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / Volt_Correct_float[3][5])) + lChannel4_Zero_Sign_Offset_3; break;    // 100 -  50 mV
        case 6: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / Volt_Correct_float[3][6])) + lChannel4_Zero_Sign_Offset_1; break;    // 110 - 100 mV
        case 7: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / Volt_Correct_float[3][7])) + lChannel4_Zero_Sign_Offset_2; break;    // 210 - 200 mV
        case 8: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / Volt_Correct_float[3][8])) + lChannel4_Zero_Sign_Offset_3; break;    // 100 - 500 mV
        case 9: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / Volt_Correct_float[3][9])) + lChannel4_Zero_Sign_Offset_1; break;    // 110 -   1 V
        case 10: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / Volt_Correct_float[3][10])) + lChannel4_Zero_Sign_Offset_2; break;   // 210 -   2 V
        case 11: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / Volt_Correct_float[3][11])) + lChannel4_Zero_Sign_Offset_3; break;   // 100 -   5 V
    }

    SetDacOffset(4);	
}

void Hardware::Voltage_Zoom(unsigned char *OrgData, unsigned char *ZoomData, int NewVoltage, int OldVoltage, int ZeroLevel)
{
    int cnt;
    float vfactor = 0;
    int int_vfactor = 0;
    int int_bufval = 0;
    int int_bufzero = ZeroLevel >> 1;
#ifdef _Debug_
    printf("Start Zooom n: %d o: %d z: %d\n", NewVoltage, OldVoltage, ZeroLevel);
#endif
    if (NewVoltage > OldVoltage)
    {
        vfactor = Voltage_Value_Matrix[NewVoltage][3] / Voltage_Value_Matrix[OldVoltage][3];

        if (vfactor == 2.5)
        {
            for (cnt = 0; cnt < 16383; cnt++)
            {
                int_bufval = ((((int) ZoomData[cnt] - int_bufzero) << 2) / 10) + int_bufzero;

                if (int_bufval > 255) OrgData[cnt] = (unsigned char) 255;
                else if (int_bufval < 0) OrgData[cnt] = (unsigned char) 0;
                else OrgData[cnt] = (unsigned char) int_bufval;
            }
        }
        else
        {
            int_vfactor = (int) vfactor;
            for (cnt = 0; cnt < 16383; cnt++)
            {
                int_bufval = ((((int) ZoomData[cnt] - int_bufzero) / int_vfactor) + int_bufzero);

                if (int_bufval > 255) OrgData[cnt] = (unsigned char) 255;
                else if (int_bufval < 0) OrgData[cnt] = (unsigned char) 0;
                else OrgData[cnt] = (unsigned char) int_bufval;
            }
        }
    }
    else if (OldVoltage > NewVoltage)
    {
        vfactor = Voltage_Value_Matrix[OldVoltage][3] / Voltage_Value_Matrix[NewVoltage][3];

        if (vfactor == 2.5)
        {
            for (cnt = 0; cnt < 16383; cnt++)
            {
                int_bufval = ((((int) ZoomData[cnt] - int_bufzero) << 1) + ((ZoomData[cnt] - int_bufzero) >> 1)) + int_bufzero;

                if (int_bufval > 255) OrgData[cnt] = (unsigned char) 255;
                else if (int_bufval < 0) OrgData[cnt] = (unsigned char) 0;
                else OrgData[cnt] = (unsigned char) int_bufval;
            }
        }
        else
        {
            int_vfactor = (int) vfactor;
            for (cnt = 0; cnt < 16383; cnt++)
            {
                int_bufval = (((int) ZoomData[cnt] - int_bufzero) * int_vfactor) + int_bufzero;

                if (int_bufval > 255) OrgData[cnt] = (unsigned char) 255;
                else if (int_bufval < 0) OrgData[cnt] = (unsigned char) 0;
                else OrgData[cnt] = (unsigned char) int_bufval;
            }
        }
    }
    else  if (OldVoltage == NewVoltage)
    {
        for (cnt = 0; cnt < 16383; cnt++)
        {
            OrgData[cnt] = ZoomData[cnt];
        }
    }
#ifdef _Debug_
    //printf("Stop Zooom %f %d\n", vfactor, int_vfactor);
#endif
}

void Hardware::HandleMainWheel(char Direction)						// Main Wheel Handler
{
	bool doit = false;
	bool changing = false;
	double voltoff = 0;
	double timeoff = 0;
	short pos = 0;
	
	int rot_buf = 0;
	int buf_int = 0; 	
	float buf_float = 0;
	
	int rbuf = Rotary_Steps;
    		
//	Display::DRAWP(550, 50, 80, 20, 0, 6);
//	sprintf(speedt, "%i\n" , Speed);
//	Display::TEXTOUTxvbig(speedt, 550, 50, 1, 6);				// Draw the Ground Sign
	
	Rot_Time = 0;
	
//	if (RoteryChanged == 0) return;
	
	switch(Active_Menu)
	{      /*
		// Averaging
		case 0:
		{
			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);

            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
                    case 0: if (MenuStatus[0][2] > 74) {MenuStatus[0][2]--; changing = true;} break;
                    case 1: if (MenuStatus[0][2] < 81) {MenuStatus[0][2]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(248, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[0][2]], 219 + MenuDataDef[MenuStatus[0][2]], 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);			
            }
			
			switch(MenuStatus[0][2])
			{
                case 74 : Average_Max = 1; break;
                case 75 : Average_Max = 2; break;
                case 76 : Average_Max = 4; break;
                case 77 : Average_Max = 8; break;
                case 78 : Average_Max = 16; break;
                case 79 : Average_Max = 32; break;
                case 80 : Average_Max = 64; break;
                case 81 : Average_Max = 128; break;
                case 82 : Average_Max = 256; break;
                case 83 : Average_Max = 512; break;
                case 84 : Average_Max = 1024; break;
                case 85 : Average_Max = 2048; break;
                case 86 : Average_Max = 4096; break;
                case 87 : Average_Max = 8192; break;
                case 88 : Average_Max = 16384; break;
            }
            Average_Cnt = 0;
						
			Menu_Changed = 1;

			break;
		}
        */	
		// Channel 1
		case 1:
		{
            if (Channel_1_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);

            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
				    case 0: if (MenuStatus[1][3] > 104) {MenuStatus[1][3]--; changing = true;} break;
				    case 1: if (MenuStatus[1][3] < 113) {MenuStatus[1][3]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[1][3]], 354, 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);		
                Display::DRAWSTATUS(6, 0);				
            }                		
			
			if (Cursor_Enabled)
			{
                CursorChanged = 4;
				Display::CALCCURSORDATA();
			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();
			
			Menu_Changed = 1;

			break;
		}
		
		// Channel 2
		case 2:
		{
            	if (Channel_2_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);
			
            	changing = false;
		while (rbuf > 0)
		{
			switch(Direction)
			{
					case 0: if (MenuStatus[2][3] > 104) {MenuStatus[2][3]--; changing = true;} break;
					case 1: if (MenuStatus[2][3] < 113) {MenuStatus[2][3]++; changing = true;} break;
			}
                	rbuf--;
		}
			
			if (changing)
			{
				Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TEXTOUTxvbig(MenuData[MenuStatus[2][3]], 354, 455, 1, Buffer_UI2Plane);
				Display::DRAWSTATUS(Active_Menu, 1);		
				Display::DRAWSTATUS(6, 0);				
            		}

			if (Cursor_Enabled)
			{
                	CursorChanged = 4;
				Display::CALCCURSORDATA();
			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}		
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();			

            		Menu_Changed = 1;	

			break;
		}
		
		// Channel 3
		case 3:
		{
            if (Channel_3_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);
			
            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
				    case 0: if (MenuStatus[3][3] > 104) {MenuStatus[3][3]--; changing = true;} break;
				    case 1: if (MenuStatus[3][3] < 113) {MenuStatus[3][3]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[3][3]], 354, 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);		
                Display::DRAWSTATUS(6, 0);				
            }
			
			if (Cursor_Enabled)
			{
                		CursorChanged = 4;
				Display::CALCCURSORDATA();

			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();
            			
			Menu_Changed = 1;

			break;
		}
		
		// Channel 4
		case 4:
		{
            if (Channel_4_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);
			
            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
				    case 0: if (MenuStatus[4][3] > 104) {MenuStatus[4][3]--; changing = true;} break;
				    case 1: if (MenuStatus[4][3] < 113) {MenuStatus[4][3]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[4][3]], 354, 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);		
                Display::DRAWSTATUS(6, 0);				
            }
			
			if (Cursor_Enabled)
			{
                CursorChanged = 4;
				Display::CALCCURSORDATA();

			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}	
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();			

            Menu_Changed = 1;		

			break;
		}
		
		// Display Menu
		case 5:
		{
			if (MenuItemPushed[2] == 0) doit = true;
			MenuButtonCheck(2);
			
			changing = false;
			
            while (rbuf > 0)
            {		
                switch(Direction)
                {
                    case 0:
                    {
                        if (MenuStatus[10][1] == 1)
                        {
                            if (GridColorArrayPos_Delayed > 0)
                            {
                                GridColorArrayPos_Delayed--;
                                GridColor_Val = GridColorArray[GridColorArrayPos_Delayed];

                                changing = true;
                            }
                        }
                        else
                        {
                            if (GridColorArrayPos > 0)
                            {
                                GridColorArrayPos--;
                                GridColor_Val = GridColorArray[GridColorArrayPos];

                                changing = true;
                            }				
                        }				
                        break;
                    }

                    case 1:
                    {
                        if (MenuStatus[10][1] == 1)
                        {
                            if (GridColorArrayPos_Delayed < 3)
                            {
                                GridColorArrayPos_Delayed++;
                                GridColor_Val = GridColorArray[GridColorArrayPos_Delayed];

                                changing = true;		
                            }				
                        }
                        else
                        {
                            if (GridColorArrayPos < 3)
                            {
                                GridColorArrayPos++;
                                GridColor_Val = GridColorArray[GridColorArrayPos];
						
                                changing = true;
                            }				
                        }
                        break;
                    }				
                }
                rbuf--;
			}			
			
			if (changing)
			{			
                SetupADC();
						
                MenuStatus[5][2] = GridColorArrayPos + 133;
						
                Display::DRAWP(240, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[5][2]], 218 + MenuDataDef[MenuStatus[5][2]], 455, 1, Buffer_UI2Plane);			
            }			
			
#ifdef _Debug_			
			if (Debug_Mode) printf("GV %i : %2x\n", GridColorArrayPos, GridColor_Val);
#endif			
			//ResetTimer();
			
			MenuItemChanged[2] = 1;
			Menu_Changed = 1;

			break;
		}
		
		// Save / Recall Menu
		case 8:
		{		
			if (MenuItemPushed[0] == 0) doit = true;
			MenuButtonCheck(0);
			
			while (rbuf > 0)
			{				
				switch(Direction)
				{
				case 0: if (SavePointer > 1) SavePointer--; break;
				case 1: if (SavePointer < 80) SavePointer++; break;
				}
				rbuf--;
			}
		
			MenuItemChanged[0] = 1;
								
			New_Menu = 8;
			Menu_Changed = 1;
		
			break;	            			
		}
		
		// Edge
		case 12:
		{
            if (EdgeToggle == 0)
            {
                if (MenuItemPushed[3] == 0) doit = true;
                MenuButtonCheck(3);

                while (rbuf > 0)
                {
                    if (Direction)
                    {
                        if ((HoldOff_Expo == 4) && (HoldOff_Value == 300)) break;
                        HoldOff_Value = HoldOff_Value + HoldOff_Steps;
                    }
                    else
                    {
                        if ((HoldOff_Expo == 1) && (HoldOff_Value == 0)) break;
                        HoldOff_Value = HoldOff_Value - HoldOff_Steps;
                    }

                    if (HoldOff_Value > 1000)
                    {
                        HoldOff_Value = 1;
                        HoldOff_Steps = 1;
                        HoldOff_Expo++;
                    }
/*                  else if ((HoldOff_Value > 100) && (HoldOff_Expo != 1))
                    {
                        HoldOff_Steps = 10;
                    }*/
                    else if (HoldOff_Value <= 0)
                    {
                        if (HoldOff_Expo > 2)
                        {
                            HoldOff_Expo--;
                            HoldOff_Value = 999;
                            HoldOff_Steps = 1;
                        }
                        else if (HoldOff_Expo > 1)
                        {
                            HoldOff_Expo = 1;
                            HoldOff_Value = 960;
                            HoldOff_Steps = 40;
                        }
                    }

                    switch(HoldOff_Expo)
                    {
                        case 1:
                        {
                            //HoldOff.Write_StepSize(0.00000004);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            //HoldOff.Write_StepSize(0.0000001);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            //HoldOff.Write_StepSize(0.001);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000);
                            break;
                        }
                        case 4:
                        {
                            //HoldOff.Write_StepSize(1);
                            HoldOff.Write_Value((float) HoldOff_Value);
                            break;
                        }
                    }
                    rbuf--;
                }

                HoldOff.RenderText();

                if (HoldOff_Value) trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
                else trig_holdoff_reg = 0x00000000;

                UpdateTrigger(26);
            }
            else if (EdgeToggle == 1)
            {
                if (MenuItemPushed[4] == 0) doit = true;
                MenuButtonCheck(4);

                changing = false;

                while (rbuf > 0)
                {
                    switch(Direction)
                    {
                        case 0: if (MenuStatus[12][4] > 104) {MenuStatus[12][4]--; changing = true;} break;
				        case 1: if (MenuStatus[12][4] < 113) {MenuStatus[12][4]++; changing = true;} break;
                    }
                    rbuf--;
                }

                if (changing)
                {
                    Display::DRAWP(442, 454, 60, 14, 0, Buffer_UI2Plane);
                    Display::TEXTOUTxvbig(MenuData[MenuStatus[12][4]], 444, 455, 1, Buffer_UI2Plane);
                }
            }


			TriggerLevelChanged = 1;
			Display::StatusUpdate();
            Menu_Changed = 1;		

			break;
		}		
			
		
		// Pre Trigger
        case 14:
		{	
            if (Display_Mode) return;

            printf("TPM : %d rb : %d  %d\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);

            while (rbuf > 0)
            {
                rot_buf = (int) ZFT_float * Rotary_Steps;
                if (rot_buf < 1) rot_buf = Rotary_Steps; // For interpolation
                
                if (Rotary_Direction)
                {
                    if ((Trig_Pos_Mem + (int) rot_buf) < 0x3FFF) Trig_Pos_Mem = Trig_Pos_Mem + rot_buf;
                    else Trig_Pos_Mem = 0x3FFF;
                }
                else
                {
                    if ((Trig_Pos_Mem - (int) rot_buf) >= 0x0064) Trig_Pos_Mem = Trig_Pos_Mem - rot_buf;
                    else Trig_Pos_Mem = 0x0064;
                }
                
                Recalc_Trigger();
                
                SetupADC();
                
            /*    	
                rot_buf = (int) ZFT_float * Rotary_Steps;
                if (rot_buf < 1) rot_buf = Rotary_Steps; // For interpolation

                if (Rotary_Direction)
                {
                    if ((Trigger_Offset_Pos + (int) rot_buf) < 0x3FFF) Trigger_Offset_Pos = Trigger_Offset_Pos + rot_buf;
                    else Trigger_Offset_Pos = 0x3FFF;
                }
                else
                {
                    if ((Trigger_Offset_Pos - (int) rot_buf) >= 0x002F) Trigger_Offset_Pos = Trigger_Offset_Pos - rot_buf;
                    else Trigger_Offset_Pos = 0x002F;
                }

                {
                    if (Trigger_Offset_Pos > SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float)) Trigger_Offset_Pos = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);	
                    if (Trigger_Offset_Pos < SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float)) Trigger_Offset_Pos = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                }


                if (Selected_Timebase < 7) pre_reg = Trigger_Offset_Pos >> 2;	
                else pre_reg = Trigger_Offset_Pos;

                pre_reg += 20;
                */
                
                TriggerOffsetChanged = true;
                
                rbuf--;
            }

            printf("TPM : %d rb : %d  %d\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);
            
  
// TMW changed 
       		if (Memory_Window_visible)
            	Display::DRAWMEMORY(0, 0, 1);
        	else
	  	Display::DRAWMEMORY(0, 1, 1);
// TMW change ends








#ifdef _Debug_
            if (Debug_Mode) printf("before PreTrig Offset = %d  Old = %d\n", Trigger_Offset_Pos, Trigger_Offset_Pos_Old);
#endif
            Display::CALCPRETRIGGER();
            Display::DRAW_ALL_CURSOR();
#ifdef _Debug_
            if (Debug_Mode) printf("after PreTrig Offset = %d  Old = %d\n", Trigger_Offset_Pos, Trigger_Offset_Pos_Old);
#endif
            MenuItemPushed[4] = 1;
            MenuButtonCheck(4);

            Menu_Changed = 1;

            break;
        }

        // Pulse/Width
		case 15:
		{
            if (MenuStatus[15][2] == 3)     // range
            {
#ifdef _Debug_
                printf("A Dir %d PT %d \n", Direction, PulseToggle);
                printf("A PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
                printf("A PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);
#endif

                if (PulseToggle == 1)
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse11_Expo == 3) && (Pulse11_Value >= 268)) break;
                            // if ((Pulse12_Expo == 3) && (Pulse12_Value >= 268)) break;
                            Pulse11_Value = Pulse11_Value + Pulse11_Steps;
                        }
                        else
                        {
                            if ((Pulse11_Expo == 1) && (Pulse11_Value <= 16)) break;
                            Pulse11_Value = Pulse11_Value - Pulse11_Steps;
                        }

                        if (Pulse11_Value >= 1000)
                        {
                            Pulse11_Value = 1;
                            Pulse11_Steps = 1;
                            Pulse11_Expo++;
                            /*
                            if ((Pulse11_Value >= Pulse12_Value) && (Pulse11_Expo == Pulse12_Expo))
                            {
                            printf("Update Val2 1\n");

                            Pulse12_Value = 2;
                            Pulse12_Steps = 1;
                            Pulse12_Expo = Pulse11_Expo;

                            switch(Pulse12_Expo)
                            {
                                case 1:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                                    break;
                                }
                                case 2:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                                    break;
                                }
                                case 3:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                                    break;
                                }
                            }
                            Pulse12.RenderText();
                            } */
                        }
                        else if ((Pulse11_Value >= 100) && (Pulse11_Expo == 2))
                        {
                            Pulse11_Steps = 1;
                        }
                        else if (Pulse11_Value <= 0)
                        {
                            if (Pulse11_Expo == 3)
                            {
                                Pulse11_Expo--;
                                Pulse11_Value = 999;
                                Pulse11_Steps = 1;
                            }
                            else if (Pulse11_Expo == 2)
                            {
                                Pulse11_Expo = 1;
                                Pulse11_Value = 992;
                                Pulse11_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse11_Expo)
                    {
                        case 1:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse11.RenderText();
                }
                else
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse12_Expo == 2) && (Pulse12_Value >= 524)) break;
                            Pulse12_Value = Pulse12_Value + Pulse12_Steps;
                        }
                        else
                        {
                            if ((Pulse12_Expo == 1) && (Pulse12_Value <= 8)) break;
                            Pulse12_Value = Pulse12_Value - Pulse12_Steps;
                        }

                        if (Pulse12_Value >= 1000)
                        {
                            Pulse12_Value = 1;
                            Pulse12_Steps = 1;
                            Pulse12_Expo++;
                        }
                        else if ((Pulse12_Value >= 100) && (Pulse12_Expo == 2))
                        {
                            Pulse12_Steps = 1;
                        }
                        else if (Pulse12_Value <= 0)
                        {
                            if (Pulse12_Expo == 3)
                            {
                                Pulse12_Expo--;
                                Pulse12_Value = 999;
                                Pulse12_Steps = 1;
                            }
                            else if (Pulse12_Expo == 2)
                            {
                                Pulse12_Expo = 1;
                                Pulse12_Value = 992;
                                Pulse12_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse12_Expo)
                    {
                        case 1:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                            break;
                        }
                    }
                    Pulse12.RenderText();
                }

                trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
                trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);
#ifdef _Debug_
                printf("B PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
                printf("B PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);
#endif
                MenuItemChanged[3] = 1;
                MenuItemChanged[4] = 1;
            }
            else
            {
                if (PulseToggle == 1)
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse21_Expo == 3) && (Pulse21_Value >= 268)) break;
                            Pulse21_Value = Pulse21_Value + Pulse21_Steps;
                        }
                        else
                        {
                            if ((Pulse21_Expo == 1) && (Pulse21_Value <= 16)) break;
                            Pulse21_Value = Pulse21_Value - Pulse21_Steps;
                        }

                        if (Pulse21_Value >= 1000)
                        {
                            Pulse21_Value = 1;
                            Pulse21_Steps = 1;
                            Pulse21_Expo++;
                        }
                        else if ((Pulse21_Value >= 100) && (Pulse21_Expo == 2))
                        {
                            Pulse21_Steps = 10;
                        }
                        else if (Pulse21_Value <= 0)
                        {
                            if (Pulse21_Expo > 2)
                            {
                                Pulse21_Expo--;
                                Pulse21_Value = 999;
                                Pulse21_Steps = 1;
                            }
                            else if (Pulse21_Expo > 1)
                            {
                                Pulse21_Expo = 1;
                                Pulse21_Value = 992;
                                Pulse21_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse21_Expo)
                    {
                        case 1:
                        {
                            Pulse21.Write_StepSize(0.000000008);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse21.Write_StepSize(0.0000001);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse21.Write_StepSize(0.001);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse21.RenderText();

                    trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
                    MenuItemChanged[3] = 1;
                }
                else
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse22_Expo == 3) && (Pulse22_Value >= 268)) break;
                            Pulse22_Value = Pulse22_Value + Pulse22_Steps;
                        }
                        else
                        {
                            if ((Pulse22_Expo == 1) && (Pulse22_Value <= 16)) break;
                            Pulse22_Value = Pulse22_Value - Pulse22_Steps;
                        }

                        if (Pulse22_Value >= 1000)
                        {
                            Pulse22_Value = 1;
                            Pulse22_Steps = 1;
                            Pulse22_Expo++;
                        }
                        else if ((Pulse22_Value >= 100) && (Pulse22_Expo == 2))
                        {
                            Pulse22_Steps = 10;
                        }
                        else if (Pulse22_Value <= 0)
                        {
                            if (Pulse22_Expo > 2)
                            {
                                Pulse22_Expo--;
                                Pulse22_Value = 999;
                                Pulse22_Steps = 1;
                            }
                            else if (Pulse22_Expo > 1)
                            {
                                Pulse22_Expo = 1;
                                Pulse22_Value = 992;
                                Pulse22_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse22_Expo)
                    {
                        case 1:
                        {
                            Pulse22.Write_StepSize(0.000000008);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse22.Write_StepSize(0.0000001);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse22.Write_StepSize(0.001);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse22.RenderText();

                    trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
                    MenuItemChanged[4] = 1;
                }
            }

            New_Menu = 15;
            Menu_Changed = 1;
            UpdateTrigger(27);

			break;
		}

        case 16: // Main Wheel -> Cursor ( comment TMW added)
		{		
            if (Cursor_Enabled == 0) break;

		    rot_buf = (int) ZFT_float * 1;
		
		    if (rot_buf < 1) rot_buf = Rotary_Steps; // For interpolation (TMW enabled this line)		
 
            if ((rbuf > 5) && (rbuf < 11)) rbuf = rbuf * 3;
            else if (rbuf > 10) rbuf = rbuf * 7;

            while (rbuf > 0)
            {            				
  				if (Cursor_Horizontal_Active == 3)	
				{
				    if (Display_Mode == 1)
				    {

                    switch(Cursor_Vertical_Active)
					{
						case 1:
						{
							CursorChanged = 1;
							
							if (MenuItemPushed[1] == 0) doit = true;
							MenuButtonCheck(1);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 + rot_buf;

									break;
								}							
							}

							break;
						}
						case 2:
						{
							CursorChanged = 2;
							
							if (MenuItemPushed[2] == 0) doit = true;
							MenuButtonCheck(2);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_2 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_2 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 + rot_buf;

									break;
								}							
							}
							break;
						}
						case 4:
						{
							CursorChanged = 1;
							
							//if (MenuItemPushed[5] == 0) doit = true;
							//MenuButtonCheck(5);
				            MenuItemPushed[1] = 1;
                            MenuItemChanged[1] = 1;
				            MenuItemChanged[2] = 1;
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 - rot_buf;
                                    if ((Cursor_Vertical_Position_Real_XY_2 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 + rot_buf;
                                    if ((Cursor_Vertical_Position_Real_XY_2 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 + rot_buf;

									break;
								}							
							}
							break;
						}                        						
					}				
				
				    }
				    else // TMW comment added: else means Display_Mode ==0
				    {
				
					switch(Cursor_Vertical_Active)
					{
						case 1: // TMW comment added: 1 means Cursor X1 is active
						{
							CursorChanged = 1;					
							if (MenuItemPushed[1] == 0) doit = true;
							MenuButtonCheck(1);
							
                            //if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            //if (Cursor_Vertical_Position_Real1 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
							
							if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) 
								Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real1 > (SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float))) 
								Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);

							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real1 - rot_buf) > 0) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 - rot_buf;		
 				             	
									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real1 + rot_buf) < 16384) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 + rot_buf;		

									break;
								}
							}

							break;
						}
						case 2: // TMW comment added: 2 means Cursor X2 is active
						{
							CursorChanged = 2;
							
							if (MenuItemPushed[2] == 0) doit = true;
							MenuButtonCheck(2);
							
                            //if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            //if (Cursor_Vertical_Position_Real2 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		

							if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real2 > (SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);

							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real2 - rot_buf) > 0) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real2 + rot_buf) < 16384) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 + rot_buf;

									break;
								}
							}
							break;
						}	
						case 4:
						{
							CursorChanged = 1;					
							//if (MenuItemPushed[5] == 0) doit = true;
							MenuItemPushed[1] = 1;
							//MenuButtonCheck(5);
				            MenuItemChanged[1] = 1;
				            MenuItemChanged[2] = 1;							
						    /*
                            if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real1 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
						
                            if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		
                            if (Cursor_Vertical_Position_Real2 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		
						    */
							if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real1 > (SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);							
							
							if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real2 > (SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float);
						
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real1 - rot_buf) > 0) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 - rot_buf;
                                    if ((Cursor_Vertical_Position_Real2 - rot_buf) > 0) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 - rot_buf;		

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real1 + rot_buf) < 16384) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 + rot_buf;		
                                    if ((Cursor_Vertical_Position_Real2 + rot_buf) < 16384) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 + rot_buf;

									break;
								}
							}

							break;
						}                        					
					}
                    } // if (Display_Mode == 1)				
				}
				
				else if (Cursor_Vertical_Active == 3)
				{
					switch(Cursor_Horizontal_Active)
					{
						case 1:
						{
							CursorChanged = 4;
							
							if (MenuItemPushed[3] == 0) doit = true;
							MenuButtonCheck(3);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real1 + 1) < 384) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real1 - 1) > 0) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H1 Pos %i\n", Cursor_Horizontal_Position_Real1);
#endif							
							break;
						}
						case 2:
						{
							CursorChanged = 5;
							
							if (MenuItemPushed[4] == 0) doit = true;
							MenuButtonCheck(4);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real2 + 1) < 384) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real2 - 1) > 0) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H2 Pos %i\n", Cursor_Horizontal_Position_Real2);
#endif							
							break;
						}
						case 4:
						{
							CursorChanged = 4;
							
							if (MenuItemPushed[5] == 0) doit = true;
							MenuButtonCheck(5);
				            MenuItemChanged[3] = 1;
				            MenuItemChanged[4] = 1;
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real1 + 1) < 384) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 + 1;
                                    if ((Cursor_Horizontal_Position_Real2 + 1) < 384) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real1 - 1) > 0) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 - 1;
                                    if ((Cursor_Horizontal_Position_Real2 - 1) > 0) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H1H2 Pos %i  %i\n", Cursor_Horizontal_Position_Real1, Cursor_Horizontal_Position_Real2);
#endif							
							break;
						}                        						
					}			
				}	

                rbuf--;
            }
							
			if (Cursor_Enabled)
			{	
                Display::CALCCURSORDATA();
				Display::DRAW_ALL_CURSOR();
				//if (doit == 0) ResetTimer();
			}		
			
			break;	
		} // Ende Cursor Menu
		
		
		case 19:
		{
            if (QM_Enabled == 0) break; 		

            while (rbuf > 0)
            {
                if ((MenuPopupActive > -1) && (MenuPopupActive != 4)) Display::DRAWMENUPOPDOWN();
                if (MenuPopupActive == 4)
                {

                    pos = -1;
                    if (Direction == 0) MenuPopupStep(4, &MenuStatus[19][1], &MenuStatus[19][2], &MenuStatus[20][4], 19, 52, 2);
                    else if (Direction == 1) MenuPopupStep(4, &MenuStatus[19][1], &MenuStatus[19][2], &MenuStatus[20][4], 19, 52, 1);

                    MenuStatus[21][4] = MenuStatus[20][4];

                    if (((MenuStatus[19][1] - 52) == 4) || ((MenuStatus[19][1] - 52) == 13))
                    {
                        if (MenuStatus[19][4] == 244) MenuItemChanged[4] = 1;
                        MenuStatus[19][4] = 242;
                    }
                    else
                    {
                        if (MenuStatus[19][4] == 242) MenuItemChanged[4] = 1;
                        MenuStatus[19][4] = 244;
                    }

                    MenuItemChanged[1] = 1;
                    MenuItemChanged[2] = 1;
						
                    New_Menu = 19;
                    Menu_Changed = 1;
                }
                else if (MenuPopupActive == -1)
                {
                    New_Menu = 19;
                    Menu_Changed = 1;
                }


                rbuf--;
            }

            Display::DRAWMENUPOPUP(4);		

            ResetTimer();
/*			
		
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
				if (doit == 0) ResetTimer();
			}						
*/
            break;
        }		

		case 22:
		{
            if (QM_Enabled == 0) break;

            while (rbuf > 0)
            {
                switch(Quick_Measure_Threshold_btn_select)
                {
                    case 1:
                    {
                        MenuButtonCheck(2);
                        //MenuItemPushed[2] = 1;
                        //MenuItemChanged[2] = 1;
                    		
                        QM_Threshold_lower.DoStep(Direction);
                        QM_Threshold_lower.RenderText();

                        break;
                    }
                    case 2:
                    {
                        MenuButtonCheck(3);

                        //MenuItemPushed[3] = 1;
                        //MenuItemChanged[3] = 1;

                        //ResetTimer();
		
                        QM_Threshold_middle.DoStep(Direction);
                        QM_Threshold_middle.RenderText();

                        break;
                    }
                    case 3:
                    {
                        MenuButtonCheck(4);
		
                        //MenuItemPushed[4] = 1;
                        //MenuItemChanged[4] = 1;
                        //ResetTimer();

                        QM_Threshold_upper.DoStep(Direction);
                        QM_Threshold_upper.RenderText();

                        break;
                    }
                }
                rbuf--;
            }

            ResetTimer();
            New_Menu = 22;
            Menu_Changed = 1;

            	
			break;
		}
		
		
		// Math Settings - Scale and Offset
		case 29:
		{		
		    if (MathToggle == 0)
		    {
                if (MenuItemPushed[0] == 0) doit = true;
                MenuButtonCheck(0);
			
                while (rbuf > 0)
                {				
                    switch(Direction)
                    {
                        case 0:
                        {
                            if (MenuStatus[26][2] == 1){ if (math_mul_scale > 166) math_mul_scale--; }
                            else if (MenuStatus[26][3] == 1){ if (math_sub_scale > 153) math_sub_scale--; }
                            else if (MenuStatus[26][4] == 1){ if (math_add_scale > 153) math_add_scale--; }
                            break;
                        }

                        case 1:
                        {
                            if (MenuStatus[26][2] == 1){ if (math_mul_scale < 181) math_mul_scale++; }
                            else if (MenuStatus[26][3] == 1){ if (math_sub_scale < 165) math_sub_scale++; }
                            else if (MenuStatus[26][4] == 1){ if (math_add_scale < 165) math_add_scale++; }
                            break;
                        }
                    }
                    rbuf--;
                }

                MenuItemChanged[0] = 1;
			}

		    if (MathToggle == 1)
		    {
                if (MenuItemPushed[1] == 0) doit = true;
                MenuButtonCheck(1);
			
                if ((rbuf > 5) && (rbuf < 11)) rbuf = rbuf * 3;
                else if (rbuf > 10) rbuf = rbuf * 7;
    			
                if (MenuStatus[26][2] == 1)
                {
                    while (rbuf > 0)
                    {
                        //Math_Offset_mul.DoStep(Direction);
                        //Math_Offset_mul.RenderText();

                        if (Direction)
                        {
                            if ((Math_Off_Mul_Expo == 2) && (Math_Off_Mul_Value >= 999)) break;
                            Math_Off_Mul_Value = Math_Off_Mul_Value + Math_Off_Mul_Steps;
                        }
                        else
                        {
                            if ((Math_Off_Mul_Expo == -2) && (Math_Off_Mul_Value <= -999)) break;
                            Math_Off_Mul_Value = Math_Off_Mul_Value - Math_Off_Mul_Steps;
                        }

                        if ((Math_Off_Mul_Value >= 1000) && (Math_Off_Mul_Expo == 0))
                        {
                            Math_Off_Mul_Value = 1;
                            Math_Off_Mul_Steps = 1;
                            Math_Off_Mul_Expo = 1;
                        }
                        else if ((Math_Off_Mul_Value >= 1000) && (Math_Off_Mul_Expo == 1))
                        {
                            Math_Off_Mul_Value = 1;
                            Math_Off_Mul_Steps = 1;
                            Math_Off_Mul_Expo = 2;
                        }
                        else if ((Math_Off_Mul_Value <= -1000) && (Math_Off_Mul_Expo == 0))
                        {
                            Math_Off_Mul_Value = -1;
                            Math_Off_Mul_Steps = 1;
                            Math_Off_Mul_Expo = -1;
                        }
                        else if ((Math_Off_Mul_Value <= -1000) && (Math_Off_Mul_Expo == -1))
                        {
                            Math_Off_Mul_Value = -1;
                            Math_Off_Mul_Steps = 1;
                            Math_Off_Mul_Expo = -2;
                        }
                        else if ((Math_Off_Mul_Value <= 0) && (Math_Off_Mul_Expo == 1))
                        {
                            if ((math_mul_scale >= 166) && (math_mul_scale <= 168))
                            {
                                Math_Off_Mul_Value = 999;
                                Math_Off_Mul_Expo = 0;
                                Math_Off_Mul_Steps = 1;
                            }
                            else
                            {
                                Math_Off_Mul_Value = -1;
                                Math_Off_Mul_Steps = 1;
                                Math_Off_Mul_Expo = -1;
                            }
                        }
                        else if ((Math_Off_Mul_Value <= 0) && (Math_Off_Mul_Expo == 2))
                        {
                            Math_Off_Mul_Value = 999;
                            Math_Off_Mul_Expo = 1;
                            Math_Off_Mul_Steps = 1;
                        }
                        else if ((Math_Off_Mul_Value >= 0) && (Math_Off_Mul_Expo == -1))
                        {
                            if ((math_mul_scale >= 166) && (math_mul_scale <= 168))
                            {
                                Math_Off_Mul_Value = -999;
                                Math_Off_Mul_Expo = 0;
                                Math_Off_Mul_Steps = 1;
                            }
                            else
                            {
                                Math_Off_Mul_Value = 1;
                                Math_Off_Mul_Steps = 1;
                                Math_Off_Mul_Expo = 1;
                            }
                        }
                        else if ((Math_Off_Mul_Value >= 0) && (Math_Off_Mul_Expo == -2))
                        {
                            Math_Off_Mul_Value = -999;
                            Math_Off_Mul_Expo = 1;
                            Math_Off_Mul_Steps = 1;
                        }
                        rbuf--;
                    }

                    switch(Math_Off_Mul_Expo)
                    {
                        case -2:
                        {
                            Math_Offset_mul.Write_StepSize(1);
                            Math_Offset_mul.Write_Value((float) Math_Off_Mul_Value / (float) 1);
                            break;
                        }
                        case -1:
                        {
                            Math_Offset_mul.Write_StepSize(0.001);
                            Math_Offset_mul.Write_Value((float) Math_Off_Mul_Value / (float) 1000);
                            break;
                        }
                        case 0:
                        {
                            Math_Offset_mul.Write_StepSize(0.000001);
                            Math_Offset_mul.Write_Value((float) Math_Off_Mul_Value / (float) 1000000);
                            break;
                        }
                        case 1:
                        {
                            Math_Offset_mul.Write_StepSize(0.001);
                            Math_Offset_mul.Write_Value((float) Math_Off_Mul_Value / (float) 1000);
                            break;
                        }
                        case 2:
                        {
                            Math_Offset_mul.Write_StepSize(1);
                            Math_Offset_mul.Write_Value((float) Math_Off_Mul_Value);
                            break;
                        }
                    }

                    Math_Offset_mul.RenderText();

                }
                else if (MenuStatus[26][3] == 1)
                {
                    while (rbuf > 0)
                    {
                        //Math_Offset_mul.DoStep(Direction);
                        //Math_Offset_mul.RenderText();

                        if (Direction)
                        {
                            if ((Math_Off_Sub_Expo == 1) && (Math_Off_Sub_Value >= 999)) break;
                            Math_Off_Sub_Value = Math_Off_Sub_Value + Math_Off_Sub_Steps;
                        }
                        else
                        {
                            if ((Math_Off_Sub_Expo == -1) && (Math_Off_Sub_Value <= -999)) break;
                            Math_Off_Sub_Value = Math_Off_Sub_Value - Math_Off_Sub_Steps;
                        }

                        if ((Math_Off_Sub_Value >= 1000) && (Math_Off_Sub_Expo == 0))
                        {
                            Math_Off_Sub_Value = 1;
                            Math_Off_Sub_Steps = 1;
                            Math_Off_Sub_Expo = 1;
                        }
                        else if ((Math_Off_Sub_Value <= -1000) && (Math_Off_Sub_Expo == 0))
                        {
                            Math_Off_Sub_Steps = 1;
                            Math_Off_Sub_Value = -1;
                            Math_Off_Sub_Expo = -1;
                        }

                        else if ((Math_Off_Sub_Value <= 0) && (Math_Off_Sub_Expo == 1))
                        {
                            Math_Off_Sub_Expo = 0;
                            Math_Off_Sub_Value = 999;
                            Math_Off_Sub_Steps = 1;
                        }
                        else if ((Math_Off_Sub_Value >= 0) && (Math_Off_Sub_Expo == -1))
                        {
                            Math_Off_Sub_Expo = 0;
                            Math_Off_Sub_Value = -999;
                            Math_Off_Sub_Steps = 1;
                        }
                        rbuf--;
                    }

                    switch(Math_Off_Sub_Expo)
                    {
                        case -1:
                        {
                            Math_Offset_sub.Write_StepSize(1);
                            Math_Offset_sub.Write_Value((float) Math_Off_Sub_Value);
                            break;
                        }
                        case 0:
                        {
                            Math_Offset_sub.Write_StepSize(0.001);
                            Math_Offset_sub.Write_Value((float) Math_Off_Sub_Value / (float) 1000);
                            break;
                        }
                        case 1:
                        {
                            Math_Offset_sub.Write_StepSize(1);
                            Math_Offset_sub.Write_Value((float) Math_Off_Sub_Value);
                            break;
                        }
                    }

                    Math_Offset_sub.RenderText();

                }
                /*
                if (MenuStatus[26][3] == 1)
                {
                    while (rbuf > 0)
                    {
                        //Math_Offset_sub.DoStep(Direction);
                        //Math_Offset_sub.RenderText();

                        if (Direction)
                        {
                            if ((Math_Off_Sub_Expo == 2) && (Math_Off_Sub_Value >= 999)) break;
                            Math_Off_Sub_Value = Math_Off_Sub_Value + Math_Off_Sub_Steps;
                        }
                        else
                        {
                            if ((Math_Off_Sub_Expo == 1) && (Math_Off_Sub_Value <= 1)) break;
                            Math_Off_Sub_Value = Math_Off_Sub_Value - Math_Off_Sub_Steps;
                        }

                        if (Math_Off_Sub_Value >= 1000)
                        {
                            Math_Off_Sub_Value = 1;
                            Math_Off_Sub_Steps = 1;
                            Math_Off_Sub_Expo++;
                        }
                        else if (Math_Off_Sub_Value <= 0)
                        {
                            if (Math_Off_Sub_Expo > 1)
                            {
                                Math_Off_Sub_Expo--;
                                Math_Off_Sub_Value = 999;
                                Math_Off_Sub_Steps = 1;
                            }
                        }
                        rbuf--;
                    }

                    switch(Math_Off_Sub_Expo)
                    {
                        case 1:
                        {
                            Math_Offset_sub.Write_StepSize(0.001);
                            Math_Offset_sub.Write_Value((float) Math_Off_Sub_Value / (float) 1000);
                            break;
                        }
                        case 2:
                        {
                            Math_Offset_sub.Write_StepSize(1);
                            Math_Offset_sub.Write_Value((float) Math_Off_Sub_Value);
                            break;
                        }
                    }

                    Math_Offset_sub.RenderText();

                }
                */
                else if (MenuStatus[26][4] == 1)
                {
                    while (rbuf > 0)
                    {
                        //Math_Offset_mul.DoStep(Direction);
                        //Math_Offset_mul.RenderText();

                        if (Direction)
                        {
                            if ((Math_Off_Add_Expo == 1) && (Math_Off_Add_Value >= 999)) break;
                            Math_Off_Add_Value = Math_Off_Add_Value + Math_Off_Add_Steps;
                        }
                        else
                        {
                            if ((Math_Off_Add_Expo == -1) && (Math_Off_Add_Value <= -999)) break;
                            Math_Off_Add_Value = Math_Off_Add_Value - Math_Off_Add_Steps;
                        }

                        if ((Math_Off_Add_Value >= 1000) && (Math_Off_Add_Expo == 0))
                        {
                            Math_Off_Add_Steps = 1;
                            Math_Off_Add_Value = 1;
                            Math_Off_Add_Expo = 1;
                        }
                        else if ((Math_Off_Add_Value <= -1000) && (Math_Off_Add_Expo == 0))
                        {
                            Math_Off_Add_Steps = 1;
                            Math_Off_Add_Value = -1;
                            Math_Off_Add_Expo = -1;
                        }

                        else if ((Math_Off_Add_Value <= 0) && (Math_Off_Add_Expo == 1))
                        {
                            Math_Off_Add_Expo = 0;
                            Math_Off_Add_Value = 999;
                            Math_Off_Add_Steps = 1;
                        }
                        else if ((Math_Off_Add_Value >= 0) && (Math_Off_Add_Expo == -1))
                        {
                            Math_Off_Add_Expo = 0;
                            Math_Off_Add_Value = -999;
                            Math_Off_Add_Steps = 1;
                        }
                        rbuf--;
                    }

                    switch(Math_Off_Add_Expo)
                    {
                        case -1:
                        {
                            Math_Offset_add.Write_StepSize(1);
                            Math_Offset_add.Write_Value((float) Math_Off_Add_Value);
                            break;
                        }
                        case 0:
                        {
                            Math_Offset_add.Write_StepSize(0.001);
                            Math_Offset_add.Write_Value((float) Math_Off_Add_Value / (float) 1000);
                            break;
                        }
                        case 1:
                        {
                            Math_Offset_add.Write_StepSize(1);
                            Math_Offset_add.Write_Value((float) Math_Off_Add_Value);
                            break;
                        }
                    }

                    Math_Offset_add.RenderText();

                }
                /*
                if (MenuStatus[26][4] == 1)
                {
                    while (rbuf > 0)
                    {
                        //Math_Offset_add.DoStep(Direction);
                        //Math_Offset_add.RenderText();

                        if (Direction)
                        {
                            if ((Math_Off_Add_Expo == 2) && (Math_Off_Add_Value >= 999)) break;
                            Math_Off_Add_Value = Math_Off_Add_Value + Math_Off_Add_Steps;
                        }
                        else
                        {
                            if ((Math_Off_Add_Expo == 1) && (Math_Off_Add_Value <= 1)) break;
                            Math_Off_Add_Value = Math_Off_Add_Value - Math_Off_Add_Steps;
                        }

                        if (Math_Off_Add_Value >= 1000)
                        {
                            Math_Off_Add_Value = 1;
                            Math_Off_Add_Steps = 1;
                            Math_Off_Add_Expo++;
                        }
                        else if (Math_Off_Add_Value <= 0)
                        {
                            if (Math_Off_Add_Expo > 1)
                            {
                                Math_Off_Add_Expo--;
                                Math_Off_Add_Value = 999;
                                Math_Off_Add_Steps = 1;
                            }
                        }
                        rbuf--;
                    }

                    switch(Math_Off_Add_Expo)
                    {
                        case 1:
                        {
                            Math_Offset_add.Write_StepSize(0.001);
                            Math_Offset_add.Write_Value((float) Math_Off_Add_Value / (float) 1000);
                            break;
                        }
                        case 2:
                        {
                            Math_Offset_add.Write_StepSize(1);
                            Math_Offset_add.Write_Value((float) Math_Off_Add_Value);
                            break;
                        }
                    }

                    Math_Offset_add.RenderText();
                }
                */

                MenuItemChanged[1] = 1;
			}
			
                        			
            New_Menu = 29;
            Menu_Changed = 1;

            break;	            			
		}		
		
		
	}	
	
	if (doit)
	{
		//printf("Do it\n");
		//ResetTimer();
		Display::DRAWSTATUS(Active_Menu, 1);		
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
		
        New_Menu = Active_Menu;
        Menu_Changed = 1;
	}
	UpdateMenuTextPlane = true;	
}

void Hardware::DoEnableUARTInterrupt(void)						// Enable service routine
{
	nr_installuserisr(na_uart1_irq, ISR_UART, (int)puart);				// Install ISR for UART

	puart->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART interrupt enabled.\n"); 				// print on console
#endif	
}
	
void Hardware::DoDisableUARTInterrupt(void)						// Disable service routine
{
	puart->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart1_irq, 0, 0); 						// Install empty routine for uart irq
}

void Hardware::ISR_UART(int context)							// UART Interrupt subroutine
{
	char rxchar = -1;
	int status;
	int x;		
	
	int secbuf = 0;
	
	int Press_Time = 0;										// Stores Press Time;
	char Read_Key_Buffer = -1;									// Buffer Keyboard key
	char Read_Key = -1;										// Buffer Keyboard key
	int MenuKey = -1;										// Buffer Menu Key
	char longpush = 0;										// Stores if the Button pushed long

	unsigned long buffer_long;
			
//	if (init_done) Reset_the_Watchdog();
	
	tc_test_var2++;
	
	status = puart->np_uartstatus;	
	rxchar = puart->np_uartrxdata;	
	
	puart->np_uartstatus = 0;
    	
	
	if (status & np_uartstatus_rrdy_mask)
	{
		Read_Key = rxchar;
	
		MenuKey = -1;										// Define value in MenuKey

		if (Read_Key != -1)
		{
			Read_Key_Buffer = Read_Key;							// Buffer Read_Key
			Press_Time = 0;
			longpush = 0;
				
			while (Read_Key == Read_Key_Buffer)
			{
				nr_delay(100);
				Read_Key = nr_rxchar();							// Read the Console
				Press_Time++;
			}
			if (Press_Time > 20) longpush = 1;
						
			Read_Key = Read_Key_Buffer;
		}
		
		// Identify the pressed key
		if (Read_Key == 'a' ) { MenuKey = 0; }	// Acquire
		if (Read_Key == 'i' ) { MenuKey = 1; }	// Channel 1
		if (Read_Key == 'j' ) { MenuKey = 2; }	// Channel 2
		if (Read_Key == 'k' ) { MenuKey = 3; }	// Channel 3
		if (Read_Key == 'l' ) { MenuKey = 4; }	// Channel 4
		if (Read_Key == 'd' ) { MenuKey = 5; }	// Display
		if (Read_Key == 'u' ) { MenuKey = 6; }
		if (Read_Key == 'f' ) { MenuKey = 7; }	// File
		if (Read_Key == 's' ) { MenuKey = 8; }	// Save
		if (Read_Key == 'r' ) { MenuKey = 9; }	// Recall
		if (Read_Key == 'b' ) { MenuKey = 10; }	// Timebase Main/Delayed
		if (Read_Key == 'y' ) { MenuKey = 11; }
		if (Read_Key == 't' ) { MenuKey = 12; }
		if (Read_Key == 'm' ) { MenuKey = 13; }
		if (Read_Key == 'e' ) { MenuKey = 14; }	// Edge Trigger
		if (Read_Key == 'p' ) { MenuKey = 15; }	// Pulse Width		
		if (Read_Key == 'c' ) { MenuKey = 16; }	// 16 : CursorX
		if (Read_Key == 'q' ) { MenuKey = 19; }	// Quick Measure
		if (Read_Key == 'w' ) { MenuKey = 20; }	// Quick Measure Delay Settings
		if (Read_Key == 'v' ) { MenuKey = 21; }	// Quick Measure Phase Settings
		if (Read_Key == 'n' ) { MenuKey = 22; } // New File
		if (Read_Key == 'g' ) { MenuKey = 23; } // Pattern
		if (Read_Key == 'h' ) { MenuKey = 55; } // Help Menu // 24 Trigger More  25 : Settings
		if (Read_Key == 'o' ) { MenuKey = 26; } // Math  27 : Settings
		if (Read_Key == 'x' ) { MenuKey = 99; } // BF unused
		if (Read_Key == 'z' ) { MenuKey = 99; } // BF unused
		
		if (Read_Key == '1' ) { MenuKey = 30; }
		if (Read_Key == '2' ) { MenuKey = 31; }
		if (Read_Key == '3' ) { MenuKey = 32; }
		if (Read_Key == '4' ) { MenuKey = 33; }
		if (Read_Key == '5' ) { MenuKey = 34; }
		if (Read_Key == '6' ) { MenuKey = 35; }
		if (Read_Key == '7' ) { MenuKey = 36; }
		if (Read_Key == '8' ) { MenuKey = 37; }
		if (Read_Key == '9' ) { MenuKey = 38; }
		if (Read_Key == '0' ) { MenuKey = 39; }

		if (Read_Key == 'Q' ) { MenuKey = 40; }
		if (Read_Key == 'W' ) { MenuKey = 41; }
		if (Read_Key == 'E' ) { MenuKey = 42; }
		if (Read_Key == 'R' ) { MenuKey = 43; }
		if (Read_Key == 'T' ) { MenuKey = 44; }
		if (Read_Key == 'Z' ) { MenuKey = 45; }
		if (Read_Key == 'U' ) { MenuKey = 46; }
		if (Read_Key == 'I' ) { MenuKey = 47; }
		if (Read_Key == 'O' ) { MenuKey = 48; }
		if (Read_Key == 'P' ) { MenuKey = 49; }

		if (Read_Key == 'A' ) { MenuKey = 50; }
		if (Read_Key == 'S' ) { MenuKey = 51; }
		if (Read_Key == 'D' ) { MenuKey = 52; }
		if (Read_Key == 'F' ) { MenuKey = 53; }
		if (Read_Key == 'G' ) { MenuKey = 54; }
		if (Read_Key == 'H' ) { MenuKey = 55; } // Help Menu
		if (Read_Key == 'J' ) { MenuKey = 56; }
		if (Read_Key == 'K' ) { MenuKey = 57; }
		if (Read_Key == 'L' ) { MenuKey = 58; }
		//if (Read_Key == 'Ö' ) { MenuKey = 59; }	//BF
		//if (Read_Key == 'Ä' ) { MenuKey = 99; }	//BF unused
		
		if (Read_Key == 'Y' ) { MenuKey = 60; }
		if (Read_Key == 'X' ) { MenuKey = 61; }
		if (Read_Key == 'C' ) { MenuKey = 62; }
		if (Read_Key == 'V' ) { MenuKey = 63; }
		if (Read_Key == 'B' ) { MenuKey = 64; }
		if (Read_Key == 'N' ) { MenuKey = 65; }
		if (Read_Key == 'M' ) { MenuKey = 66; }		
		if (Read_Key == ';' ) { MenuKey = 67; }
		if (Read_Key == ':' ) { MenuKey = 68; }	
		if (Read_Key == ',' ) { MenuKey = 69; }	
		if (Read_Key == '.' ) { MenuKey = 70; }	
		if (Read_Key == '-' ) { MenuKey = 71; }	
		
		
		if (Read_Key == '!' ) { MenuKey = 80; }
		if (Read_Key == '"' ) { MenuKey = 81; }	
		//if (Read_Key == '§' ) { MenuKey = 82; }	//BF
		if (Read_Key == '$' ) { MenuKey = 83; }	
		if (Read_Key == '%' ) { MenuKey = 84; }	

		if (Read_Key == '&' ) { MenuKey = 85; }
		if (Read_Key == '/' ) { MenuKey = 86; }	
		if (Read_Key == '(' ) { MenuKey = 87; }	
		if (Read_Key == ')' ) { MenuKey = 88; }	
		if (Read_Key == '=' ) { MenuKey = 89; }		
		
		if (Read_Key == ' ' ) { MenuKey = -2; }
		
		if (Read_Key == 0x0A ) { MenuKey = -10; }	// Enter Key
		if (Read_Key == 0x08 ) { MenuKey = -11; }	// Backspace Key
		if (Read_Key == 0x09 ) { MenuKey = -12; }	// TAB Key
//		if (Read_Key == 0x1b ) { MenuKey = -13; }	// ESC Key
		if (Read_Key == 'x' )
		{

		}
			
		if (MenuKey != -1)
		{
#ifdef _Debug_IRQ_		
			if (Debug_Mode) printf("MKey : %i RKey : %2i  PL : %i\n\n", MenuKey, Read_Key, longpush);
#endif			
			//ButtonChanged = 1;
			Buttonhandler(MenuKey, longpush);			
		}
		
		
		//if ((MenuKey == -1) && (Read_Key != -1)) printf("Key : %2x\n\n", Read_Key);
		
		/*
		if (MenuKey == -11)
		{
			for (x = 0; x < 20; x++)
			{
				buffer_long = READADC(4);
			}				
		}
		
		if (MenuKey == -12) Display::REMOVESIG(1);*/
	}
}

void Hardware::DoEnableUART2Interrupt(void)						// Enable service routine
{
	uart2_count = 0;
	
	nr_installuserisr(na_uart_usb_irq, ISR_UART2, (int)puart2);			// Install ISR for UART2

	puart2->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART USB interrupt enabled.\n"); 			// print on console
#endif	
}
	
void Hardware::DoDisableUART2Interrupt(void)						// Disable service routine
{
	puart2->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart_usb_irq, 0, 0); 					// Install empty routine for uart2 irq
}

void Hardware::ISR_UART2(int context)							// UART Interrupt subroutine
{
	char rxchar = -1;
	int status;
	int x;	
		
//	if (init_done) Reset_the_Watchdog();
		
	status = puart2->np_uartstatus;	
	rxchar = puart2->np_uartrxdata;	
	
	tc_test_var2++;
	
	puart2->np_uartstatus = 0;									// Clear Interrupt condition
	   	
	if (status & np_uartstatus_rrdy_mask)
	{
		uart2_buffer[uart2_count] = rxchar;
			
		uart2_count++;
	}	
	
	if (uart2_buffer[0] != 37) uart2_count = 0;
	
	if (uart2_count == 37)
	{		
		InterpretUART(uart2_buffer);
		
		uart2_count = 0;
		
		//config_changed = true;
#ifdef _Debug_USB_		
		if (Debug_Mode) printf("USB DATA Received\n");
#endif	
#ifdef _Debug_IRQ_		
		if (Debug_Mode) printf("USB DATA Received\n");
#endif		
	}
	
	puart2->np_uartstatus = 0;
}

void Hardware::InterpretUART(volatile unsigned char data[37])
{	
	char cnt, result_buf = 0;
	char CalcBuf;
	int	ix, CalcBufInt;
	long int libuf;
	
    int lcnt = 0;
    unsigned long buflong, buflong1, buflong2 = 0;	
	
	unsigned long *prog_flash_adr_buf;
	unsigned long *prog_flash_adr_buf2;
    unsigned char add_buf = 0;

    char DataStr[50];
	
//	unsigned char SendBuffer[37] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#ifdef _Debug_USB_	
//	printf("Received Command %d  Which %d  dl %d  dh %d  dxl %d  dxh %d  dext %d\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6]);
	if (Debug_Mode) printf("Received %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x %x\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15], data[16], data[17], data[18], data[19], data[20], data[21], data[22], data[23], data[24], data[25], data[26], data[27]);
#endif
    if ((data[1] == 3) && (data[2] == 4))
    {
        //start_acq->np_piodata = 0x01;				//start record Port On
        //start_acq->np_piodata = 0x00;				//start record Port Off			
    }
    else
    {
	switch(data[1])
	{
		case 1: 											// Send Screen Shot
		{
			if (data[2] == 0) SendShot();
			else SendSWShot();
			break;
		}
		case 2: 											// Send Data
		{
			
			//switch(which)
			switch(data[2])
			{
				
				case 0: 									//
				{
					//
					break;
				}
				
				case 1:										// Main Time Base
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = Selected_Timebase;
					
					SendData(send_buffer);

					break;
				}
				
				case 2:										// Expand Time Base
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = Selected_Expand_Timebase;
					
					SendData(send_buffer);
					break;
				}
							
				case 8:
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = GridColor_Val;
					
					SendData(send_buffer);
					break;
				}				
				
				case 9:										// Main Time Base
				{
					
					for (cnt = 0; cnt < 32; cnt++)
					{
						send_buffer[0] = 3;						// Command Write Data
						send_buffer[1] = data[2];
						
						send_buffer[2] = cnt;
					
						send_buffer[3] = LogicData[cnt] & 0xFF;
						send_buffer[4] = (LogicData[cnt] & 0xFF00) >> 8;
										
						SendData(send_buffer);
					}

					break;
				}				
				
				case 12:									// Channel 1
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
										
					CalcBuf = Selected_Voltage_CH1;
									
					if ((MenuStatus[1][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[1][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
							
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[1][3] - 101;
					
//					if ((MenuStatus[1][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;				
					
					send_buffer[4] = (char) (ZeroLevelCH1 / 1.5);
					
					SendData(send_buffer);
					
					break;
				}
				case 13:									// Channel 2
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
										
					CalcBuf = Selected_Voltage_CH2;
					if ((MenuStatus[2][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[2][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[2][3] - 101;
				//	if ((MenuStatus[2][4] - 99) == 1) CalcBuf = CalcBuf || 0x80;

					send_buffer[3] = CalcBuf;
					
					send_buffer[4] = (char) (ZeroLevelCH2 / 1.5);
					
					SendData(send_buffer);
												
					break;
				}
				case 14:									// Channel 3
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];					
					
					CalcBuf = Selected_Voltage_CH3;
					if ((MenuStatus[3][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[3][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[3][3] - 101;
				//	if ((MenuStatus[3][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;
					
					
					
					
					send_buffer[4] = (char) (ZeroLevelCH3 / 1.5);
					
					SendData(send_buffer);
												
					break;
				}
				case 15:									// Channel 4
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];					
					
					CalcBuf = Selected_Voltage_CH4;
					if ((MenuStatus[4][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[4][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[4][3] - 101;
				//	if ((MenuStatus[4][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;
					
					send_buffer[4] = (char) (ZeroLevelCH4 / 1.5);
					
					SendData(send_buffer);
													
					break;
				}	

				case 20:										// Protected Config Shifting
				{
				
					send_buffer[0] = 2;						// Command Write Data
					send_buffer[1] = 20;
					
					send_buffer[2] = tc_model & 0x000000FF;
					send_buffer[3] = (tc_model & 0x0000FF00) >> 8;
					send_buffer[4] = (tc_model & 0x00FF0000) >> 16;
					send_buffer[5] = (tc_model & 0xFF000000) >> 24;
					
					send_buffer[6] = tc_serial & 0x000000FF;
					send_buffer[7] = (tc_serial & 0x0000FF00) >> 8;
					send_buffer[8] = (tc_serial & 0x00FF0000) >> 16;
					send_buffer[9] = (tc_serial & 0xFF000000) >> 24;

					send_buffer[10] = tc_production_lot1 & 0x000000FF;
					send_buffer[11] = (tc_production_lot1 & 0x0000FF00) >> 8;
					send_buffer[12] = (tc_production_lot1 & 0x00FF0000) >> 16;
					send_buffer[13] = (tc_production_lot1 & 0xFF000000) >> 24;

					send_buffer[14] = tc_production_lot2 & 0x000000FF;
					send_buffer[15] = (tc_production_lot2 & 0x0000FF00) >> 8;
					send_buffer[16] = (tc_production_lot2 & 0x00FF0000) >> 16;
					send_buffer[17] = (tc_production_lot2 & 0xFF000000) >> 24;

					send_buffer[18] = tc_shipment_date & 0x000000FF;
					send_buffer[19] = (tc_shipment_date & 0x0000FF00) >> 8;
					send_buffer[20] = (tc_shipment_date & 0x00FF0000) >> 16;
					send_buffer[21] = (tc_shipment_date & 0xFF000000) >> 24;

					send_buffer[22] = kill_adc & 0x000000FF;
					send_buffer[23] = (kill_adc & 0x0000FF00) >> 8;

					send_buffer[24] = m2k_filter_Mode | (volt_filter_Mode << 4);
					
					SendData(send_buffer);					
				
				    break;
				}
				
				case 21:										// Hardware Shifting
				{
					la_gate->np_piodata = 0x00;
                    				
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = la_data->np_piodata & 0x00FF;
					send_buffer[3] = (la_data->np_piodata & 0xFF00) >> 8;
                    					
					SendData(send_buffer);
#ifdef _Debug_USB_									
					printf("Hardware read : %x \n", la_data->np_piodata);
#endif					
					break;
				}	

				case 22:
				{                  				
					send_buffer[0] = 2;
					send_buffer[1] = 22;
                    send_buffer[2] = 1;

                    send_buffer[4] = (unsigned char) Voltage_Correction[0][0];
                    send_buffer[5] = (unsigned char) Voltage_Correction[0][1];
                    send_buffer[6] = (unsigned char) Voltage_Correction[0][2];
                    send_buffer[7] = (unsigned char) Voltage_Correction[0][3];
                    send_buffer[8] = (unsigned char) Voltage_Correction[0][4];
                    send_buffer[9] = (unsigned char) Voltage_Correction[0][5];
                    send_buffer[10] = (unsigned char) Voltage_Correction[0][6];
                    send_buffer[11] = (unsigned char) Voltage_Correction[0][7];
                    send_buffer[12] = (unsigned char) Voltage_Correction[0][8];
                    send_buffer[13] = (unsigned char) Voltage_Correction[0][9];
                    send_buffer[14] = (unsigned char) Voltage_Correction[0][10];
                    send_buffer[15] = (unsigned char) Voltage_Correction[0][11];

                    send_buffer[16] = (unsigned char) Voltage_Correction[1][0];
                    send_buffer[17] = (unsigned char) Voltage_Correction[1][1];
                    send_buffer[18] = (unsigned char) Voltage_Correction[1][2];
                    send_buffer[19] = (unsigned char) Voltage_Correction[1][3];
                    send_buffer[20] = (unsigned char) Voltage_Correction[1][4];
                    send_buffer[21] = (unsigned char) Voltage_Correction[1][5];
                    send_buffer[22] = (unsigned char) Voltage_Correction[1][6];
                    send_buffer[23] = (unsigned char) Voltage_Correction[1][7];
                    send_buffer[24] = (unsigned char) Voltage_Correction[1][8];
                    send_buffer[25] = (unsigned char) Voltage_Correction[1][9];
                    send_buffer[26] = (unsigned char) Voltage_Correction[1][10];
                    send_buffer[27] = (unsigned char) Voltage_Correction[1][11];

                    send_buffer[28] = (unsigned char) Voltage_Offset[0][0];
                    send_buffer[29] = (unsigned char) Voltage_Offset[0][1];
                    send_buffer[30] = (unsigned char) Voltage_Offset[0][2];
                    send_buffer[31] = (unsigned char) Voltage_Offset[0][3];

                    send_buffer[32] = (unsigned char) Voltage_Offset[1][0];
                    send_buffer[33] = (unsigned char) Voltage_Offset[1][1];
                    send_buffer[34] = (unsigned char) Voltage_Offset[1][2];
                    send_buffer[35] = (unsigned char) Voltage_Offset[1][3];


					SendData(send_buffer);
					
					nr_delay(10);
					
					send_buffer[0] = 2;
					send_buffer[1] = 22;
                    send_buffer[2] = 2;

                    send_buffer[4] = (unsigned char) Voltage_Correction[2][0];
                    send_buffer[5] = (unsigned char) Voltage_Correction[2][1];
                    send_buffer[6] = (unsigned char) Voltage_Correction[2][2];
                    send_buffer[7] = (unsigned char) Voltage_Correction[2][3];
                    send_buffer[8] = (unsigned char) Voltage_Correction[2][4];
                    send_buffer[9] = (unsigned char) Voltage_Correction[2][5];
                    send_buffer[10] = (unsigned char) Voltage_Correction[2][6];
                    send_buffer[11] = (unsigned char) Voltage_Correction[2][7];
                    send_buffer[12] = (unsigned char) Voltage_Correction[2][8];
                    send_buffer[13] = (unsigned char) Voltage_Correction[2][9];
                    send_buffer[14] = (unsigned char) Voltage_Correction[2][10];
                    send_buffer[15] = (unsigned char) Voltage_Correction[2][11];

                    send_buffer[16] = (unsigned char) Voltage_Correction[3][0];
                    send_buffer[17] = (unsigned char) Voltage_Correction[3][1];
                    send_buffer[18] = (unsigned char) Voltage_Correction[3][2];
                    send_buffer[19] = (unsigned char) Voltage_Correction[3][3];
                    send_buffer[20] = (unsigned char) Voltage_Correction[3][4];
                    send_buffer[21] = (unsigned char) Voltage_Correction[3][5];
                    send_buffer[22] = (unsigned char) Voltage_Correction[3][6];
                    send_buffer[23] = (unsigned char) Voltage_Correction[3][7];
                    send_buffer[24] = (unsigned char) Voltage_Correction[3][8];
                    send_buffer[25] = (unsigned char) Voltage_Correction[3][9];
                    send_buffer[26] = (unsigned char) Voltage_Correction[3][10];
                    send_buffer[27] = (unsigned char) Voltage_Correction[3][11];

                    send_buffer[28] = (unsigned char) Voltage_Offset[2][0];
                    send_buffer[29] = (unsigned char) Voltage_Offset[2][1];
                    send_buffer[30] = (unsigned char) Voltage_Offset[2][2];
                    send_buffer[31] = (unsigned char) Voltage_Offset[2][3];

                    send_buffer[32] = (unsigned char) Voltage_Offset[3][0];
                    send_buffer[33] = (unsigned char) Voltage_Offset[3][1];
                    send_buffer[34] = (unsigned char) Voltage_Offset[3][2];
                    send_buffer[35] = (unsigned char) Voltage_Offset[3][3];

					SendData(send_buffer);					
#ifdef _Debug_USB_									
					printf("Sending Voltage Corretion \n");
#endif
                    break;
                }                															
			}
			
			
			break;
		}
		case 3: 											// Receive Data
		{		
			switch(data[2])
			{
				case 0: 								
				{                                           // Connection made
					if ((data[3] & 0x01) == 0x01) OneShotRestart = true;
					if ((data[3] & 0x02) == 0x02) USB_Data_Trans = true;
					if ((data[3] & 0x04) == 0x04) Continius = true;
					if ((data[3] & 0x08) == 0x08) USB_SendAllData = true;
					
					USB_At_Startup = true;
                    /*					
					if (Debug_Mode)
					{
                        if ((data[3] & 0x80) == 0x80) printf("Received USB open at startup\n");
                        else printf("Received USB open\n");
                    }
					 */
					config_changed = true;
					break;
				}
				
				case 1:										// Main Time Base
				{
					Selected_Timebase = data[3];
					break;
				}
				
				case 2:										// Expand Time Base
				{
					Selected_Expand_Timebase = data[3];
					break;
				}
				
				case 3:										// Main Registers
				{
				    AutoTimerOff = true;
				
					ctrl_reg = data[3] + (data[4] << 8);
					adc_ctrl_reg = data[20] + (data[21] << 8);
					
					if ((ctrl_reg & 0x0010) == 0x0010)
					{					
                        data_adr->np_piodata = 0x01;

                        if ((adc_ctrl_reg & 0x0100) == 0x0100) WRITEADC(1, 0x200);
                        if ((adc_ctrl_reg & 0x0200) == 0x0200) WRITEADC(2, 0x200);
                        if ((adc_ctrl_reg & 0x0400) == 0x0400) WRITEADC(3, 0x200);
                        if ((adc_ctrl_reg & 0x0800) == 0x0800) WRITEADC(4, 0x200);

                        data_adr->np_piodata = 0x00;

                        if ((adc_ctrl_reg & 0x0100) == 0x0100) printf("Read Test ADC1 : %d\n", READADC(1));
                        if ((adc_ctrl_reg & 0x0200) == 0x0200) printf("Read Test ADC2 : %d\n", READADC(2));
                        if ((adc_ctrl_reg & 0x0400) == 0x0400) printf("Read Test ADC3 : %d\n", READADC(3));
                        if ((adc_ctrl_reg & 0x0800) == 0x0800) printf("Read Test ADC4 : %d\n", READADC(4));
					}
					
					trig_holdoff_reg = 0xFFFFFFFF - (data[5] + (data[6] << 8) + (data[7] << 16) + (data[8] << 24));					
									
					timebase_reg = tb_value[data[9]];
					Selected_Timebase = data[9];
					Selected_Expand_Timebase = data[10];
					
					SIGNALFaktor_idx = data[10];
					
					pre_reg = data[11] + (data[12] << 8);
					//trg_val_CHI_reg = (data[13] + (data[14] << 8));
					//trg_val_CHII_reg = (data[15] + (data[16] << 8));
					//trg_val_CHIII_reg = (data[31] + (data[32] << 8));					
					//trg_val_CHIV_reg = (data[33] + (data[34] << 8));

					Trigger_Pos_CH1 = (unsigned int)((255 - (data[13] + (data[14] << 8))) << 1) - 64;
					Trigger_Pos_CH2 = (unsigned int)((255 - (data[15] + (data[16] << 8))) << 1) - 64;
					Trigger_Pos_CH3 = (unsigned int)((255 - (data[31] + (data[32] << 8))) << 1) - 64;
					Trigger_Pos_CH4 = (unsigned int)((255 - (data[33] + (data[34] << 8))) << 1) - 64; 	                      					
                    					
					ram_adress_reg = data[17] + (data[18] << 8);
					
					triggering = data[19];
					
                    TimebaseChanged = 1;
                    SIGNALFaktorChanged = 1;					
				    /* siehe oben
					if ((data[20] & 0x01) == 0x01) adc_ctrl_reg |= 0x0001;
					if ((data[20] & 0x02) == 0x02) adc_ctrl_reg |= 0x0002;
					if ((data[20] & 0x04) == 0x04) adc_ctrl_reg |= 0x0004;
					if ((data[20] & 0x08) == 0x08) adc_ctrl_reg |= 0x0008;					
					
					if ((data[20] & 0x10) == 0x10) adc_ctrl_reg |= 0x0010;
					if ((data[20] & 0x20) == 0x20) adc_ctrl_reg |= 0x0020;
					if ((data[20] & 0x40) == 0x40) adc_ctrl_reg |= 0x0040;
					if ((data[20] & 0x80) == 0x80) adc_ctrl_reg |= 0x0080;						
					
					if ((data[21] & 0x01) == 0x01) adc_ctrl_reg |= 0x0100;
					if ((data[21] & 0x02) == 0x02) adc_ctrl_reg |= 0x0200;
					if ((data[21] & 0x04) == 0x04) adc_ctrl_reg |= 0x0400;
					if ((data[21] & 0x08) == 0x08) adc_ctrl_reg |= 0x0800;															
					
					if ((data[21] & 0x10) == 0x10) adc_ctrl_reg |= 0x1000;
					if ((data[21] & 0x20) == 0x20) adc_ctrl_reg |= 0x2000;
					if ((data[21] & 0x40) == 0x40) adc_ctrl_reg |= 0x4000;
					if ((data[21] & 0x80) == 0x80) adc_ctrl_reg |= 0x8000;	
					*/					
					if ((data[20] & 0x10) == 0x10) Channel_1_Active = 0;
					else Channel_1_Active = 1;
					if ((data[20] & 0x20) == 0x20) Channel_2_Active = 0;
					else Channel_2_Active = 1;
					if ((data[20] & 0x40) == 0x40) Channel_3_Active = 0;
					else Channel_3_Active = 1;
					if ((data[20] & 0x80) == 0x80) Channel_4_Active = 0;
					else Channel_4_Active = 1;	
								
					Selected_Trigger_Source = 0;
					
                    CalcBufInt = (128 - ((Trigger_Pos_CH1 + 64) >> 1)) >> 1;
                    if (multi_active)
                    {
                        if (Voltage_Correction[0][Selected_Voltage_CH1] == 0) CalcBufInt = 0;
                        else CalcBufInt = int (float (CalcBufInt) / Volt_Correct_float[0][Selected_Voltage_CH1]);
                    }
                    trg_val_CHI_reg	= 255 - (((Trigger_Pos_CH1 + 64) >> 1) + CalcBufInt);

                    CalcBufInt = (128 - ((Trigger_Pos_CH2 + 64) >> 1)) >> 1;
                    if (multi_active)
                    {
                        if (Voltage_Correction[0][Selected_Voltage_CH2] == 0) CalcBufInt = 0;
                        else CalcBufInt = int (float (CalcBufInt) / Volt_Correct_float[0][Selected_Voltage_CH2]);
                    }
                    trg_val_CHII_reg = 255 - (((Trigger_Pos_CH2 + 64) >> 1) + CalcBufInt);

                    CalcBufInt = (128 - ((Trigger_Pos_CH3 + 64) >> 1)) >> 1;
                    if (multi_active)
                    {
                        if (Voltage_Correction[0][Selected_Voltage_CH3] == 0) CalcBufInt = 0;
                        else CalcBufInt = int (float (CalcBufInt) / Volt_Correct_float[0][Selected_Voltage_CH3]);
                    }
                    trg_val_CHIII_reg = 255 - (((Trigger_Pos_CH3 + 64) >> 1) + CalcBufInt);

                    CalcBufInt = (128 - ((Trigger_Pos_CH4 + 64) >> 1)) >> 1;
                    if (multi_active)
                    {
                        if (Voltage_Correction[0][Selected_Voltage_CH4] == 0) CalcBufInt = 0;
                        else CalcBufInt = int (float (CalcBufInt) / Volt_Correct_float[0][Selected_Voltage_CH4]);
                    }
                    trg_val_CHIV_reg = 255 - (((Trigger_Pos_CH4 + 64) >> 1) + CalcBufInt);


                    printf("Trig1 : %x - %x\n", Trigger_Pos_CH1, trg_val_CHI_reg);
                    printf("Trig2 : %x - %x\n", Trigger_Pos_CH2, trg_val_CHII_reg);
                    printf("Trig3 : %x - %x\n", Trigger_Pos_CH3, trg_val_CHIII_reg);
                    printf("Trig4 : %x - %x\n", Trigger_Pos_CH4, trg_val_CHIV_reg);

									
					if ((data[3] & 0x02) == 0x02)
					{
						if ((data[20] & 0x01) == 0x01) Selected_Trigger_Source = 1;
						if ((data[20] & 0x02) == 0x02) Selected_Trigger_Source = 2;
						if ((data[20] & 0x04) == 0x04) Selected_Trigger_Source = 3;
						if ((data[20] & 0x08) == 0x08) Selected_Trigger_Source = 4;
						
					}
					else Selected_Trigger_Source = 5;
					
					Trigger_Offset_Pos = pre_reg << 2;					
					
					if ((ctrl_reg & 0x40) == 0x40) MenuStatus[12][0] = 93;
					else MenuStatus[12][0] = 94;
                 									
					trig_range_reg = data[22] + (data[23] << 8);
					
					trig_width_reg = data[24] + (data[25] << 8);
					
					
					// pulse width menu update
					if ((ctrl_reg & 0x1200) == 0x1200)
					{
					   MenuStatus[15][2] = 1;
					   Pulse22.Write_Value((float) trig_width_reg * (float) 0.000000008);					
					   Pulse22.RenderText();
                    }
   					if ((ctrl_reg & 0x1400) == 0x1400)
					{
					   MenuStatus[15][2] = 2;
					   Pulse21.Write_Value((float) trig_width_reg * (float) 0.000000008);
                       Pulse21.RenderText();				
                    }
					if ((ctrl_reg & 0x1800) == 0x1800)
					{
					   MenuStatus[15][2] = 3;
					
					   Pulse11.Write_Value((float) trig_width_reg * (float) 0.000000008);
					   Pulse12.Write_Value((float) trig_range_reg * (float) 0.000000008);
					
					   Pulse11.RenderText();
					   Pulse12.RenderText();
                    }
                    				
					
					// Extern Trigger Level
					ext_trg_val_reg = data[26];
					Trigger_Pos_CHE = data[26];
					
					// Channel Address Add
					
					channel_Adr_add = data[27] + (data[28] << 8);
					channel_Adr_add2 = data[29] + (data[30] << 8);
					
					serdata->np_piodata = ext_trg_val_reg;
	
					serstartpwm->np_piodata = 1;
					serstartpwm->np_piodata = 0;						
					
    				data_adr->np_piodata = ram_adress_reg;					
	
    				mode->np_piodata = 0x00;
    				mode->np_piodata = 0x00;
					mode->np_piodata = 0x01;
    				mode->np_piodata = 0x00;
					
#ifdef _Debug_USB_
					if (Debug_Mode)
					{
                        		    printf("pre :%x \n", pre_reg);
					    printf("ctr :%x \n", ctrl_reg);
					    printf("adc :%x \n", adc_ctrl_reg);
					    printf("del :%x \n", adc_del_reg);
					    printf("trg1 :%x \n", trg_val_CHI_reg);
					    printf("extrg :%x \n", ext_trg_val_reg);	
					    printf("tb :%x \n", timebase_reg);
					    printf("tr :%x \n", trig_range_reg);
					    printf("tw :%x \n", trig_width_reg);
					    printf("CHA 1 :%d, 2 :%d, 3 :%d, 4 :%d\n", Channel_1_Active, Channel_2_Active, Channel_3_Active, Channel_4_Active);
					    printf("TrigSrc %d, Trig %d\n", Selected_Trigger_Source, triggering);
					    printf("Channel Add %x\n", channel_Adr_add);
						printf("Channel2 Add %x\n", channel_Adr_add2);
	                }		
#endif
                    //S Display::Update_Channel_Data(1);

					SetupADC();	
					Display::DRAW_ALL_CURSOR();
					
					config_changed = true;
					
					
                    if ((adc_ctrl_reg & 0x1000) == 0x1000)
                    {
                        tc_test_var = (unsigned long) la_data->np_piodata;

                        send_buffer[0] = 6;								 // Kennung Test Var

                        send_buffer[1] = (unsigned char) (tc_test_var & 0x000000FF);
                        send_buffer[2] = (unsigned char) ((tc_test_var & 0x0000FF00) >> 8);


                        send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
                        send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
                        send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
                        send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);

                        SendData(send_buffer);
                    }
                    else					
                    {
                        tc_test_var = (unsigned long) la_data->np_piodata;

                        send_buffer[0] = 8;								 // Kennung Test Var

                        send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
                        send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
                        send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
                        send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);

                        SendData(send_buffer);
                    }

                    if (Active_Menu == 15)
                    {
                        MenuItemChanged[1] = 1;
                        MenuItemChanged[2] = 1;
                        MenuItemChanged[3] = 1;
                        MenuItemChanged[4] = 1;
                        MenuChanged = 1;
                        Display::UpdateMenu();
                    }

					
					break;
				}	
				
				case 4:									
				{		
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Continius = 0;
					else Continius = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("Trigger Only %d\n", USB_OnlyTrigger);
#endif					
				    config_changed = true;
		
					break;
				}	
						
				case 5:									
				{
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Continius = 0;
					else Continius = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;
					
					if (data[6] == 0) Transfer_man_data = 0;
					else Transfer_man_data = 1;
					
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("USB %d\n", USB_Data_Trans);
#endif					
				    config_changed = true;
					break;
				}	

				case 6:									
				{
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Continius = 0;
					else Continius = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("Cont %d\n", Continius);
#endif					
				    config_changed = true;
					break;
				}
						
				case 7:
				{
				    ADC_Data_Available = 1;
					ISR_ADC_INT(0);
					
					break;
				}
				
				case 8:
				{
					GridColor_Val = data[3];
					SetupADC();
					config_changed = true;
					break;
				}

				case 9:
				{
					adc_change12_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Change12 %x\n", adc_change12_reg);
#endif					
					SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				}

				case 10:
				{
					adc_ctr12_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Ctr12 %x\n", adc_ctr12_reg);
#endif					
					SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				}                           						

				case 11:
				{
					adc_change34_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Change34 %x\n", adc_change34_reg);
#endif					
					SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				}                           						
										
				case 12:									// Channel 1
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[1][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[1][0] = 7;
					else MenuStatus[1][0] = 8;					
				
					Selected_Voltage_CH1 = data[3] & 0x3F;					
					
					MenuStatus[1][3] = (data[4] & 0x3F) + 101;
					
					if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x01;
					else volt_filter_Mode &= 0xFE;					
					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x01;
					else m2k_filter_Mode &= 0xFE;					
					
					SwitchesCH1 = data[5] | (data[6] << 8);

                    SwitchesCH2 &= 0xFCFF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x0200; break;    // caution 1 & 2 turned
					   case 2 : SwitchesCH2 |= 0x0100; break;
					   case 3 : SwitchesCH2 |= 0x0300; break;
                    }
                       					
					if ((data[20] & 0x01) == 0x01)
                    {
                        multi_active = 1;
                        SwitchesCH1 |= 0x8000;					
                    }
					else
                    {
                        multi_active = 0;
                    }
                    			
					//ch1_factor = data[21];	
					
					SetSwitches(1, -1);
					
					nr_delay(10);
                    					
					SetSwitches(2, -1);
					
//					ZeroLevelCH1 = (int) (data[7] * 1.5);
					
					//CH1_DAC_Offset = data[7] | (data[8] << 8);
                    Virtual_ZeroLevelCH1 = (data[7] | (data[8] << 8)) - 8192;

					Channel1_Zero_Sign_Offset_1 = data[18] | (data[19] << 8);
					Channel1_Zero_Sign_Offset_2 = data[24] | (data[25] << 8);
					Channel1_Zero_Sign_Offset_3 = data[26] | (data[27] << 8);
					
					if (Channel1_Zero_Sign_Offset_1 > 32768) Channel1_Zero_Sign_Offset_1 -= 65536;
					if (Channel1_Zero_Sign_Offset_2 > 32768) Channel1_Zero_Sign_Offset_2 -= 65536;
					if (Channel1_Zero_Sign_Offset_3 > 32768) Channel1_Zero_Sign_Offset_3 -= 65536;
														
					//ZeroLevelCH1 = (unsigned int) CH1_DAC_Offset - 7999 + Channel1_Zero_Sign_Offset;
					
                    //ZeroLevelCH1 = (unsigned int) ((CH1_DAC_Offset - 7999) / 1.74) + Channel1_Zero_Sign_Offset;	
                    //ZeroLevelCH1 = (unsigned int) (CH1_DAC_Offset - 7999) + Channel1_Zero_Sign_Offset;//8115;

                    Rotary_Steps = 0;
                    ON_Zero_Channel_1();
                    					
					CH1_DAC_1 = data[9];
					CH1_DAC_2 = data[11];
					CH1_DAC_3 = data[13];
					CH1_DAC_4 = data[15];
					
					if ((data[16] & 0x01) == 0x01) FirEnabledCH1 = 1;
					else FirEnabledCH1 = 0;
					
					FirStartCH = data[17];		
					
					SetCHDacOffset(1);
					
					CH1_DAC_OffsetOld = CH1_DAC_Offset;
					
					CH1_DAC_1Old = CH1_DAC_1;
					CH1_DAC_2Old = CH1_DAC_2;
					CH1_DAC_3Old = CH1_DAC_3;
					CH1_DAC_4Old = CH1_DAC_4;
					
					Selected_ADCs_CH1 = data[23];					
					
					kill_adc &= 0xFFF0;
					kill_adc |= data[28];					
					
					config_changed = true;				
					break;						
				}					
				case 13:									// Channel 2
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[2][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[2][0] = 7;
					else MenuStatus[2][0] = 8;
					
					Selected_Voltage_CH2 = data[3] & 0x3F;					
					
					MenuStatus[2][3] = (data[4] & 0x3F) + 101;
					
					if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x02;
					else volt_filter_Mode &= 0xFD;	
                    					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x02;
					else m2k_filter_Mode &= 0xFD;	
					
					SwitchesCH2 &= 0xFF00;
					SwitchesCH2 |= data[5];// | (data[6] << 8); Hier nur unteres Byte. Oberes bleibt erhalten

                    SwitchesCH2 &= 0xF3FF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x0400; break;
					   case 2 : SwitchesCH2 |= 0x0800; break;
					   case 3 : SwitchesCH2 |= 0x0C00; break;
                    }					
					
					if ((data[20] & 0x01) == 0x01)
                    {
                        multi_active = 1;
                        SwitchesCH1 |= 0x8000;					
                    }
					else
                    {
                        multi_active = 0;
                        SwitchesCH1 &= 0x7FFF;					
                    }
                    				
					//ch2_factor = data[21];						
					
					SetSwitches(2, -1);
					
					nr_delay(10);
					
					SetSwitches(1, -1);
					
					
					//printf("serdat : %8x\n", (0x40000000 | data[5] | (data[6] * 256)) & 0xFFFF0FFF);					
					
//					ZeroLevelCH2 = (int) (data[7] * 1.5);
					
					//CH2_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH2 = (data[7] | (data[8] << 8)) - 8192;
					
					Channel2_Zero_Sign_Offset_1 = data[18] | (data[19]  << 8);
					Channel2_Zero_Sign_Offset_2 = data[24] | (data[25]  << 8);
					Channel2_Zero_Sign_Offset_3 = data[26] | (data[27]  << 8);					
					
					if (Channel2_Zero_Sign_Offset_1 > 32768) Channel2_Zero_Sign_Offset_1 -= 65536;
					if (Channel2_Zero_Sign_Offset_2 > 32768) Channel2_Zero_Sign_Offset_2 -= 65536;
					if (Channel2_Zero_Sign_Offset_3 > 32768) Channel2_Zero_Sign_Offset_3 -= 65536;
									
					//ZeroLevelCH2 = (unsigned int) CH2_DAC_Offset - 7999 + Channel2_Zero_Sign_Offset;
					//ZeroLevelCH2 = (unsigned int) ((CH2_DAC_Offset - 7999) / 1.74) + Channel2_Zero_Sign_Offset;	
					//ZeroLevelCH2 = (unsigned int) (CH2_DAC_Offset - 7999) + Channel2_Zero_Sign_Offset;//8115;
					
					Rotary_Steps = 0;
					ON_Zero_Channel_2();
					
					CH2_DAC_1 = data[9];
					CH2_DAC_2 = data[11];
					CH2_DAC_3 = data[13];
					CH2_DAC_4 = data[15];		
					
					if ((data[16] & 0x01) == 0x01) FirEnabledCH2 = 1;
					else FirEnabledCH2 = 0;
					
					FirStartCH = data[17];	                   							
					
                    SetCHDacOffset(2);						
									
					CH2_DAC_OffsetOld = CH2_DAC_Offset;
					
					CH2_DAC_1Old = CH2_DAC_1;
					CH2_DAC_2Old = CH2_DAC_2;
					CH2_DAC_3Old = CH2_DAC_3;
					CH2_DAC_4Old = CH2_DAC_4;
					
					Selected_ADCs_CH2 = data[23];
					
					kill_adc &= 0xFF0F;
					kill_adc |= (data[6] << 4);	
					
					config_changed = true;				
					break;
				}	
				
				case 14:									// Channel 3
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[3][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[3][0] = 7;
					else MenuStatus[3][0] = 8;
					
					Selected_Voltage_CH3 = data[3] & 0x3F;					
					
					MenuStatus[3][3] = (data[4] & 0x3F) + 101;
					
					if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x04;
					else volt_filter_Mode &= 0xFB;	
                    					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x04;
					else m2k_filter_Mode &= 0xFB;	
					
					SwitchesCH3 = data[5] | (data[6] << 8);

                    SwitchesCH2 &= 0xCFFF;

					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x2000; break;
					   case 2 : SwitchesCH2 |= 0x1000; break;
					   case 3 : SwitchesCH2 |= 0x3000; break;
                    }	
                    					
					if ((data[20] & 0x01) == 0x01)
                    {
                        multi_active = 1;
                        SwitchesCH1 |= 0x8000;					
                    }
					else
                    {
                        multi_active = 0;
                        SwitchesCH1 &= 0x7FFF;					
                    }
                    				
					//ch3_factor = data[21];						
					
					SetSwitches(3, -1);
					
					nr_delay(10);

					SetSwitches(2, -1);		
					
					nr_delay(10);					
					
					SetSwitches(1, -1);					
					
//					ZeroLevelCH3 = (int) (data[7] * 1.5);
					
					//CH3_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH3 = (data[7] | (data[8] << 8)) - 8192;
					
                    Channel3_Zero_Sign_Offset_1 = data[18] | (data[19]  << 8);
                    Channel3_Zero_Sign_Offset_2 = data[24] | (data[25]  << 8);
                    Channel3_Zero_Sign_Offset_3 = data[26] | (data[27]  << 8);

                    if (Channel3_Zero_Sign_Offset_1 > 32768) Channel3_Zero_Sign_Offset_1 -= 65536;
                    if (Channel3_Zero_Sign_Offset_2 > 32768) Channel3_Zero_Sign_Offset_2 -= 65536;
                    if (Channel3_Zero_Sign_Offset_3 > 32768) Channel3_Zero_Sign_Offset_3 -= 65536;
                    				
					//ZeroLevelCH3 = (unsigned int) CH3_DAC_Offset - 7999 + Channel3_Zero_Sign_Offset;
					//ZeroLevelCH3 = (unsigned int) (CH3_DAC_Offset - 7999) + Channel3_Zero_Sign_Offset;//8115;
					
					Rotary_Steps = 0;
					ON_Zero_Channel_3();
					
					CH3_DAC_1 = data[9];
					CH3_DAC_2 = data[11];
					CH3_DAC_3 = data[13];
					CH3_DAC_4 = data[15];
					
					if ((data[16] & 0x01) == 0x01) FirEnabledCH3 = 1;
					else FirEnabledCH3 = 0;
					
					FirStartCH = data[17];	                   				
					
					SetCHDacOffset(3);					

					CH3_DAC_OffsetOld = CH3_DAC_Offset;
					
					CH3_DAC_1Old = CH3_DAC_1;
					CH3_DAC_2Old = CH3_DAC_2;
					CH3_DAC_3Old = CH3_DAC_3;
					CH3_DAC_4Old = CH3_DAC_4;
					
					Selected_ADCs_CH3 = data[23];
					
					kill_adc &= 0xF0FF;
					kill_adc |= (data[6] << 8);						
					
                    config_changed = true;
					break;
				}													
							
				
				case 15:									// Channel 4
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[4][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[4][0] = 7;
					else MenuStatus[4][0] = 8;
					
					Selected_Voltage_CH4 = data[3] & 0x3F;
					
					
					MenuStatus[4][3] = (data[4] & 0x3F) + 101;
					
					if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x08;
					else volt_filter_Mode &= 0xF7;						
					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x08;
					else m2k_filter_Mode &= 0xF7;	
					
					SwitchesCH4 = data[5] | (data[6] << 8);

                    SwitchesCH2 &= 0x3FFF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x4000; break;
					   case 2 : SwitchesCH2 |= 0x8000; break;
					   case 3 : SwitchesCH2 |= 0xC000; break;
                    }						
					
					if ((data[20] & 0x01) == 0x01)
                    {
                        multi_active = 1;
                        SwitchesCH1 |= 0x8000;					
                    }
					else
                    {
                        multi_active = 0;
                        SwitchesCH1 &= 0x7FFF;					
                    }
                    				
					//ch4_factor = data[21];						
					
					SetSwitches(4, -1);		
					
					nr_delay(10);
					
					SetSwitches(2, -1);		
					
					nr_delay(10);					
					
					SetSwitches(1, -1);					
				
//					ZeroLevelCH4 = (int) (data[7] * 1.5);  // data[8] is high byte
				
					//CH4_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH4 = (data[7] | (data[8] << 8)) - 8192;
					
                    Channel4_Zero_Sign_Offset_1 = data[18] | (data[19]  << 8);
                    Channel4_Zero_Sign_Offset_2 = data[24] | (data[25]  << 8);
                    Channel4_Zero_Sign_Offset_3 = data[26] | (data[27]  << 8);
                    		
                    if (Channel4_Zero_Sign_Offset_1 > 32768) Channel4_Zero_Sign_Offset_1 -= 65536;
                    if (Channel4_Zero_Sign_Offset_2 > 32768) Channel4_Zero_Sign_Offset_2 -= 65536;
                    if (Channel4_Zero_Sign_Offset_3 > 32768) Channel4_Zero_Sign_Offset_3 -= 65536;
                            			
					//ZeroLevelCH4 = (unsigned int) CH4_DAC_Offset - 7999 + Channel4_Zero_Sign_Offset;
					//ZeroLevelCH4 = (unsigned int) (CH4_DAC_Offset - 7999) + Channel4_Zero_Sign_Offset;//8115;
					Rotary_Steps = 0;
					ON_Zero_Channel_4();
					
					CH4_DAC_1 = data[9];
					CH4_DAC_2 = data[11];
					CH4_DAC_3 = data[13];
					CH4_DAC_4 = data[15];
					
					if ((data[16] & 0x01) == 0x01) FirEnabledCH4 = 1;
					else FirEnabledCH4 = 0;
					
					FirStartCH = data[17];	                   				
					
					SetCHDacOffset(4);                    					

					CH4_DAC_OffsetOld = CH4_DAC_Offset;
					
					CH4_DAC_1Old = CH4_DAC_1;
					CH4_DAC_2Old = CH4_DAC_2;
					CH4_DAC_3Old = CH4_DAC_3;
					CH4_DAC_4Old = CH4_DAC_4;
					
					Selected_ADCs_CH4 = data[23];
					
					kill_adc &= 0x0FFF;
					kill_adc |= (data[6] << 12);						
					
                    config_changed = true;
					break;
				}
				
				case 16:									// Trigger
				{
					SwitchesTB = data[3];		// External			
									
					SetSwitches(5, SwitchesTB);					
					config_changed = true;
					break;
				}	
				
				
				case 17:									// Spike Generator / TestPort Bits
				{				
					// TestBits
					test_port_reg = data[3];
					//out_test->np_piodata = test_port_reg;
					
                    config_changed = true;			
					break;								
				}
				
				case 18:									// Triangle Generator
				{	
					rot_speed_read->np_piodata = 1;
								
					for (cnt = 0; cnt < 32; cnt++)
					{					
						serdata->np_piodata = data[cnt + 3];
	
						serstartpwm->np_piodata = 1;
						serstartpwm->np_piodata = 0;
						
						//printf("gtd :%x \n", data[cnt + 3]);
					}
					
					rot_speed_read->np_piodata = 0;
					config_changed = true;
					break;								
				}

				case 19:									// Only one shot after restart bit
				{
					OneShotRestart = data[3];
#ifdef _Debug_USB_					
					if (Debug_Mode)
                    {
                        if (OneShotRestart) printf("One shot will made after restart\n");
                        else printf("Normal mode after restart\n");
                    }
#endif					
					config_changed = true;
					
					break;
				}


				case 20:									// Protected Config
				{
					tc_model = data[4] | (data[5] << 8);

                    			tc_serial = data[6] | (data[7] << 8) | (data[8] << 16) | (data[9] << 24);
					
                    			tc_production_lot1 = data[10];				
                    			tc_production_lot2 = data[11];

                    			tc_shipment_date = (data[12] << 8) | (data[13] << 4) | (data[14] & 0x0000000F);

                    			kill_adc = data[15] | (data[16] << 8);
                    			m2k_filter_Mode = data[17] & 0x0F;
                    			volt_filter_Mode = (data[17] & 0xF0) >> 4;

                   // if (data[19] != 5) Voltage_Correction[data[19]][data[18]] = data[20];


                   // if ((data[21] != 5) && (data[22] != 5)) Voltage_Offset[data[21]][data[22]] = data[23];



                   			 AMDFlash::Write_Protected_Flash();

					break;
				}

				case 22:									// Protected Config
				{				
        			switch(data[3])
		          	{
					case 1:	
					{
						Voltage_Correction[0][0] = (int) data[4];
						Voltage_Correction[0][1] = (int) data[5];
						Voltage_Correction[0][2] = (int) data[6];
						Voltage_Correction[0][3] = (int) data[7];
						Voltage_Correction[0][4] = (int) data[8];
						Voltage_Correction[0][5] = (int) data[9];
						Voltage_Correction[0][6] = (int) data[10];
						Voltage_Correction[0][7] = (int) data[11];
						Voltage_Correction[0][8] = (int) data[12];
						Voltage_Correction[0][9] = (int) data[13];
						Voltage_Correction[0][10] = (int) data[14];
						Voltage_Correction[0][11] = (int) data[15];
	
						Voltage_Correction[1][0] = (int) data[16];
						Voltage_Correction[1][1] = (int) data[17];
						Voltage_Correction[1][2] = (int) data[18];
						Voltage_Correction[1][3] = (int) data[19];
						Voltage_Correction[1][4] = (int) data[20];
						Voltage_Correction[1][5] = (int) data[21];
						Voltage_Correction[1][6] = (int) data[22];
						Voltage_Correction[1][7] = (int) data[23];
						Voltage_Correction[1][8] = (int) data[24];
						Voltage_Correction[1][9] = (int) data[25];
						Voltage_Correction[1][10] = (int) data[26];
						Voltage_Correction[1][11] = (int) data[27];
	
						Voltage_Offset[0][0] = (int) data[28];
						Voltage_Offset[0][1] = (int) data[29];
						Voltage_Offset[0][2] = (int) data[30];
						Voltage_Offset[0][3] = (int) data[31];

						Voltage_Offset[1][0] = (int) data[32];
						Voltage_Offset[1][1] = (int) data[33];
						Voltage_Offset[1][2] = (int) data[34];
						Voltage_Offset[1][3] = (int) data[35];
				
						Volt_Correct_float[0][0] = (float) ((Voltage_Correction[0][0] + 100) / 100);
						Volt_Correct_float[0][1] = (float) ((Voltage_Correction[0][1] + 100) / 100);
						Volt_Correct_float[0][2] = (float) ((Voltage_Correction[0][2] + 100) / 100);
						Volt_Correct_float[0][3] = (float) ((Voltage_Correction[0][3] + 100) / 100);
						Volt_Correct_float[0][4] = (float) ((Voltage_Correction[0][4] + 100) / 100);
						Volt_Correct_float[0][5] = (float) ((Voltage_Correction[0][5] + 100) / 100);
						Volt_Correct_float[0][6] = (float) ((Voltage_Correction[0][6] + 100) / 100);
						Volt_Correct_float[0][7] = (float) ((Voltage_Correction[0][7] + 100) / 100);
						Volt_Correct_float[0][8] = (float) ((Voltage_Correction[0][8] + 100) / 100);
						Volt_Correct_float[0][9] = (float) ((Voltage_Correction[0][9] + 100) / 100);
						Volt_Correct_float[0][10] = (float) ((Voltage_Correction[0][10] + 100) / 100);
						Volt_Correct_float[0][11] = (float) ((Voltage_Correction[0][11] + 100) / 100);
	
						Volt_Correct_float[1][0] = (float) ((Voltage_Correction[1][0] + 100) / 100);
						Volt_Correct_float[1][1] = (float) ((Voltage_Correction[1][1] + 100) / 100);
						Volt_Correct_float[1][2] = (float) ((Voltage_Correction[1][2] + 100) / 100);
						Volt_Correct_float[1][3] = (float) ((Voltage_Correction[1][3] + 100) / 100);
						Volt_Correct_float[1][4] = (float) ((Voltage_Correction[1][4] + 100) / 100);
						Volt_Correct_float[1][5] = (float) ((Voltage_Correction[1][5] + 100) / 100);
						Volt_Correct_float[1][6] = (float) ((Voltage_Correction[1][6] + 100) / 100);
						Volt_Correct_float[1][7] = (float) ((Voltage_Correction[1][7] + 100) / 100);
						Volt_Correct_float[1][8] = (float) ((Voltage_Correction[1][8] + 100) / 100);
						Volt_Correct_float[1][9] = (float) ((Voltage_Correction[1][9] + 100) / 100);
						Volt_Correct_float[1][10] = (float) ((Voltage_Correction[1][10] + 100) / 100);
						Volt_Correct_float[1][11] = (float) ((Voltage_Correction[1][11] + 100) / 100);
	
						break;
					}
	
					case 2:	
					{
						Voltage_Correction[2][0] = (int) data[4];
						Voltage_Correction[2][1] = (int) data[5];
						Voltage_Correction[2][2] = (int) data[6];
						Voltage_Correction[2][3] = (int) data[7];
						Voltage_Correction[2][4] = (int) data[8];
						Voltage_Correction[2][5] = (int) data[9];
						Voltage_Correction[2][6] = (int) data[10];
						Voltage_Correction[2][7] = (int) data[11];
						Voltage_Correction[2][8] = (int) data[12];
						Voltage_Correction[2][9] = (int) data[13];
						Voltage_Correction[2][10] = (int) data[14];
						Voltage_Correction[2][11] = (int) data[15];
	
						Voltage_Correction[3][0] = (int) data[16];
						Voltage_Correction[3][1] = (int) data[17];
						Voltage_Correction[3][2] = (int) data[18];
						Voltage_Correction[3][3] = (int) data[19];
						Voltage_Correction[3][4] = (int) data[20];
						Voltage_Correction[3][5] = (int) data[21];
						Voltage_Correction[3][6] = (int) data[22];
						Voltage_Correction[3][7] = (int) data[23];
						Voltage_Correction[3][8] = (int) data[24];
						Voltage_Correction[3][9] = (int) data[25];
						Voltage_Correction[3][10] = (int) data[26];
						Voltage_Correction[3][11] = (int) data[27];
	
						Voltage_Offset[2][0] = (int) data[28];
						Voltage_Offset[2][1] = (int) data[29];
						Voltage_Offset[2][2] = (int) data[30];
						Voltage_Offset[2][3] = (int) data[31];
	
						Voltage_Offset[3][0] = (int) data[32];
						Voltage_Offset[3][1] = (int) data[33];
						Voltage_Offset[3][2] = (int) data[34];
						Voltage_Offset[3][3] = (int) data[35];
	
						Volt_Correct_float[2][0] = (float) ((Voltage_Correction[2][0] + 100) / 100);
						Volt_Correct_float[2][1] = (float) ((Voltage_Correction[2][1] + 100) / 100);
						Volt_Correct_float[2][2] = (float) ((Voltage_Correction[2][2] + 100) / 100);
						Volt_Correct_float[2][3] = (float) ((Voltage_Correction[2][3] + 100) / 100);
						Volt_Correct_float[2][4] = (float) ((Voltage_Correction[2][4] + 100) / 100);
						Volt_Correct_float[2][5] = (float) ((Voltage_Correction[2][5] + 100) / 100);
						Volt_Correct_float[2][6] = (float) ((Voltage_Correction[2][6] + 100) / 100);
						Volt_Correct_float[2][7] = (float) ((Voltage_Correction[2][7] + 100) / 100);
						Volt_Correct_float[2][8] = (float) ((Voltage_Correction[2][8] + 100) / 100);
						Volt_Correct_float[2][9] = (float) ((Voltage_Correction[2][9] + 100) / 100);
						Volt_Correct_float[2][10] = (float) ((Voltage_Correction[2][10] + 100) / 100);
						Volt_Correct_float[2][11] = (float) ((Voltage_Correction[2][11] + 100) / 100);
	
						Volt_Correct_float[3][0] = (float) ((Voltage_Correction[3][0] + 100) / 100);
						Volt_Correct_float[3][1] = (float) ((Voltage_Correction[3][1] + 100) / 100);
						Volt_Correct_float[3][2] = (float) ((Voltage_Correction[3][2] + 100) / 100);
						Volt_Correct_float[3][3] = (float) ((Voltage_Correction[3][3] + 100) / 100);
						Volt_Correct_float[3][4] = (float) ((Voltage_Correction[3][4] + 100) / 100);
						Volt_Correct_float[3][5] = (float) ((Voltage_Correction[3][5] + 100) / 100);
						Volt_Correct_float[3][6] = (float) ((Voltage_Correction[3][6] + 100) / 100);
						Volt_Correct_float[3][7] = (float) ((Voltage_Correction[3][7] + 100) / 100);
						Volt_Correct_float[3][8] = (float) ((Voltage_Correction[3][8] + 100) / 100);
						Volt_Correct_float[3][9] = (float) ((Voltage_Correction[3][9] + 100) / 100);
						Volt_Correct_float[3][10] = (float) ((Voltage_Correction[3][10] + 100) / 100);
						Volt_Correct_float[3][11] = (float) ((Voltage_Correction[3][11] + 100) / 100);
	
						break;
					}
                    		}

                    		AMDFlash::Write_Protected_Flash();

				break;
			}	

			case 23:									// USB Data Received
			{
                    		switch(data[3])
		          	{
					case 1: Virtual_ZeroLevelCH1 = 196 - (data[4] + (data[5] << 8)); ON_Zero_Channel_1(); break;
					case 2: Virtual_ZeroLevelCH2 = 196 - (data[4] + (data[5] << 8)); ON_Zero_Channel_2(); break;
					case 3: Virtual_ZeroLevelCH3 = 196 - (data[4] + (data[5] << 8)); ON_Zero_Channel_3(); break;
					case 4: Virtual_ZeroLevelCH4 = 196 - (data[4] + (data[5] << 8)); ON_Zero_Channel_4(); break;
  	       			}
  	       			
  	       			if (MenuStatus[14][1] == 138) Trigger_Pos_CH1 = 384 - (data[4] + (data[5] << 8));
  	       			else if (MenuStatus[14][1] == 139) Trigger_Pos_CH2 = 384 - (data[4] + (data[5] << 8));
  	       			else if (MenuStatus[14][1] == 140) Trigger_Pos_CH3 = 384 - (data[4] + (data[5] << 8));
  	       			else if (MenuStatus[14][1] == 141) Trigger_Pos_CH4 = 384 - (data[4] + (data[5] << 8));
  	       			
  	       			UpdateTrigger(43);
  	       			
 			    }                				
			}
			
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;	
			TriggerWayChanged = 1;
			TimebaseChanged = 1;
			TimeOffsetChanged = 1;	
			
			Display::StatusUpdate();			
			
			break;
		}

		
		case 5: 											// Receive Data
		{

			start_acq->np_piodata = 0x01;				//start record Port On
			start_acq->np_piodata = 0x00;				//start record Port Off


			break;			
		}
					
		case 6: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button1\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(30, 0);
					break;
				}		
				case 2: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button2\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(31, 0);
					break;
				}
				case 3: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button3\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(32, 0);
					break;
				}
				case 4: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button4\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(33, 0);
					break;
				}
				case 5: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button5\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(34, 0);
					break;
				}
				case 6: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button6\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(35, 0);
					break;
				}
				case 7: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 1\n");
#endif					
//					ButtonChanged = 1;
//					Buttonhandler(1, 0);

					if ((data[3]) && (Channel_1_Active == 0)) UpdateChannel(1, 1);
					if ((data[3] == 0) && (Channel_1_Active == 1)) UpdateChannel(1, 0);
					
					if (Channel_1_Active == 0)
					{
						RemovePlane |= 0x01;
						ClearPlanes();
					}
					
					
					break;
				}
				case 8: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Math\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(26, 0);
					break;
				}
				case 9: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 2\n");
#endif					
//					ButtonChanged = 1;
//					Buttonhandler(2, 0);
					
					if ((data[3]) && (Channel_2_Active == 0)) UpdateChannel(2, 1);
					if ((data[3] == 0) && (Channel_2_Active == 1)) UpdateChannel(2, 0);
					
					if (Channel_2_Active == 0)
					{
						RemovePlane |= 0x02;
						ClearPlanes();
					}
					
				
					break;
				}
				case 10: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 3\n");
#endif					
					//ButtonChanged = 1;
					//Buttonhandler(3, 0);
					
					if ((data[3]) && (Channel_3_Active == 0)) UpdateChannel(3, 1);
					if ((data[3] == 0) && (Channel_3_Active == 1)) UpdateChannel(3, 0);
                    					
					if (Channel_3_Active == 0)
					{
						RemovePlane |= 0x04;
						ClearPlanes();
					}
					
					break;
				}
				case 11: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 4\n");
#endif					
					//ButtonChanged = 1;
					//Buttonhandler(4, 0);
					
					if ((data[3]) && (Channel_4_Active == 0)) UpdateChannel(4, 1);
					if ((data[3] == 0) && (Channel_4_Active == 1)) UpdateChannel(4, 0);
					
					if (Channel_4_Active == 0)
					{
						RemovePlane |= 0x08;
						ClearPlanes();
					}
                    					
					break;
				}
				case 12: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Auto Scale\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(23, 0);
					break;
				}
				case 13: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Save/Recall\n");
#endif					
					ButtonChanged = 1;
					break;
				}
				case 14: 									// All
    			{
#ifdef _Debug_USB_			
					if (Debug_Mode) printf("USB Function Quick Print\n");
#endif					
					ButtonChanged = 1;
					break;
				}
				case 15: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Utility\n");
#endif					
					ButtonChanged = 1;
					break;
				}
				case 16: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Pulse Width\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(15, 0);
					break;
				}
				case 17: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Cursor\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(16, 0);
					break;
				}
				case 18: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Quick Meas\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(19, 0);
					break;
				}
				case 19: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Acquire\n");
#endif
					ButtonChanged = 1;
					Buttonhandler(0, 0);
					break;
				}
				case 20: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Display\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(5, 0);
					break;
				}
				case 21: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Edge\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(14, 0);
					break;
				}
				case 22: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Mode / Coupling\n");
#endif					
					break;
				}
				case 23: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Mode\n");
#endif					
					break;
				}
				case 24: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Run/Stop\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(37, 0);
			
                    if (Continius)
                    {		
                        LED_ON[12] = 1;
                        LED_ON[13] = 0;
                        Send_LED();					
                    }
                    else
                    {		
                        LED_ON[12] = 0;
                        LED_ON[13] = 1;
                        Send_LED();					
                    }					
					break;
				}
				case 25: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Single\n");
#endif					
					ButtonChanged = 1;
					Buttonhandler(38, 0);
					
					break;
				}
				case 26: 									// All
				{
					printf("USB Test Button\n");
					
					
					
                    buflong = 0x00000000;

                    while (1 == 1)
                    {
                        data_adr->np_piodata = 0x01;
                        buflong = READADC(1);

                        if ((buflong & 0x00008000) == 0x00008000)
                        {
                            buflong1 = READADC(1);

                            if (Selected_Voltage_CH1 == 9) Channel1_Zero_Sign_Offset_1 = (int) (buflong1 - 8192);
                            else if (Selected_Voltage_CH1 == 10) Channel1_Zero_Sign_Offset_2 = (int) (buflong1 - 8192);
                            else if (Selected_Voltage_CH1 == 11) Channel1_Zero_Sign_Offset_3 = (int) (buflong1 - 8192);

                            printf("buflong %8x %d\n", buflong, buflong);
                            printf("buflong1 %8x %d\n", buflong1, buflong1);
                            printf("CH1_1 : %4.4d CH1_2 : %4.4d CH1_3 : %4.4d \n", Channel1_Zero_Sign_Offset_1, Channel1_Zero_Sign_Offset_2, Channel1_Zero_Sign_Offset_3);
                            
                            break;
                        }

                        data_adr->np_piodata = 0x00;
                        lcnt++;
                        if (lcnt == 50000) break;
                    }					
					

                    printf("lcnt %d\n", lcnt);

				}	
				case 27:
				{
					if (data[3] == 1)
					{
						USB_SendAllData = 1;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function Send All Data On\n");
#endif						
					}					
					else
					{
						USB_SendAllData = 0;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function Send All Data Off\n");
#endif						
					}
					
					if (data[4] == 1)
					{
						OneShotRestart = 1;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function OneShotRestart On\n");
#endif
					}					
					else
					{
						OneShotRestart = 0;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function OneShotRestart Off\n");
#endif						
					}
					
					config_changed = true;
                    					
					break;
				}


				case 28: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 1 ACDC\n");
#endif									
					if (data[3]) MenuStatus[1][0] = 7;  // DC
					else MenuStatus[1][0] = 8;  // AC
					
					SetSwitches(1, -1);
					
					MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();
                    					
					break;
				}
				case 29: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 2 ACDC\n");
#endif									
					if (data[3]) MenuStatus[2][0] = 7;  // DC
					else MenuStatus[2][0] = 8;  // AC
					
					SetSwitches(1, -1);
					
					MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				case 30: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 3 ACDC\n");
#endif									
					if (data[3]) MenuStatus[3][0] = 7;  // DC
					else MenuStatus[3][0] = 8;  // AC
					
					SetSwitches(1, -1);
					
					MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				case 31: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 4 ACDC\n");
#endif									
					if (data[3]) MenuStatus[4][0] = 7;  // DC
					else MenuStatus[4][0] = 8;  // AC
                    					
					SetSwitches(1, -1);
					
					MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 32: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 1 Invert\n");
#endif									
					if (data[3]) MenuStatus[1][2] = 241;  // Invert
					else MenuStatus[1][2] = 240;
				
					MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 33: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 2 Invert\n");
#endif									
					if (data[3]) MenuStatus[2][2] = 241;  // Invert
					else MenuStatus[2][2] = 240;
				
					MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				
				case 34: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 3 Invert\n");
#endif									
					if (data[3]) MenuStatus[3][2] = 241;  // Invert
					else MenuStatus[3][2] = 240;
				
					MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 35: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 4 Invert\n");
#endif									
					if (data[3]) MenuStatus[4][2] = 241;  // Invert
					else MenuStatus[4][2] = 240;
				
					MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}                				
                                                                              							
			}
			SendCtrlBlock();
			
			nr_delay(10);
			
			SendCtrlBlock3();	

			nr_delay(10);
			
			SendCtrlBlock2();

			break;
		}

		case 7: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 1\n");
#endif					
					if (data[3] == 1) Set_LED(0);
					else Reset_LED(0);					
					break;
				}	
				case 2: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Math\n");
#endif					
					if (data[3] == 1) Set_LED(4);
					else Reset_LED(4);
					break;
				}	
				case 3: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 2\n");
#endif					
					if (data[3] == 1) Set_LED(1);
					else Reset_LED(1);
					break;
				}	
				case 4: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 3\n");
#endif					
					if (data[3] == 1) Set_LED(2);
					else Reset_LED(2);
					break;
				}	
				case 5: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 4\n");
#endif					
					if (data[3] == 1) Set_LED(3);
					else Reset_LED(3);
					break;
				}	
				case 6: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Pulse Width\n");
#endif					
					if (data[3] == 1) Set_LED(10);
					else Reset_LED(10);
					break;
				}	
				case 7: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Wheel\n");
#endif					
					if (data[3] == 1) Set_LED(6);
					else Reset_LED(6);
					break;
				}	
				case 8: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Cursor\n");
#endif					
					if (data[3] == 1) Set_LED(5);
					else Reset_LED(5);
					break;
				}	
				case 9: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Quick Meas\n");
#endif					
					if (data[3] == 1) Set_LED(7);
					else Reset_LED(7);
					break;
				}	
				case 10: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Edge\n");
#endif					
					if (data[3] == 1) Set_LED(8);
					else Reset_LED(8);
					break;
				}	
				case 11: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Run/Stop Green\n");
#endif					
					LED_ON[12] = 1;
					LED_ON[13] = 0;
					Send_LED();
					break;
				}	
				case 12: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Run/Stop Red\n");
#endif					
					LED_ON[13] = 1;
					LED_ON[12] = 0;
					Send_LED();
					break;
				}	
				case 13: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Single Green\n");
#endif					
					LED_ON[14] = 1;
					LED_ON[15] = 0;
					Send_LED();
					break;
				}	
				case 14: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Single Red\n");
#endif					
					LED_ON[15] = 1;
					LED_ON[14] = 0;
					Send_LED();
					break;
				}									
			}
			
			SendCtrlBlock();
			
			nr_delay(10);
			
			SendCtrlBlock3();			

			nr_delay(10);
			
			SendCtrlBlock2();
			
			
			break;			
		}	
		
		case 8: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 1 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 1 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 2: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 2 Right\n");
#endif							
							break;
						}
						case 2:
						{	
#ifdef _Debug_USB_                        				
							if (Debug_Mode) printf("USB Wheel Pos Channel 2 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 3: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 3 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 3 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 4: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 4 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 4 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 5: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 1 Right\n");
#endif							
                            Rotary_Direction = 1;
                            ON_Voltage_Channel_1();	

							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 1 Left\n");
#endif						
                            Rotary_Direction = 0;
                            ON_Voltage_Channel_1();	
                            	
							break;
						}
					}
					break;						
				}	
				case 6: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 2 Right\n");
#endif							
                            Rotary_Direction = 1;
                            ON_Voltage_Channel_2();	

							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 2 Left\n");
#endif						
                            Rotary_Direction = 0;
                            ON_Voltage_Channel_2();		

							break;
						}
					}
					break;						
				}	
				case 7: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 3 Right\n");
#endif							
                            Rotary_Direction = 1;
                            ON_Voltage_Channel_3();	
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 3 Left\n");
#endif						
                            Rotary_Direction = 0;
                            ON_Voltage_Channel_3();		
							break;
						}
					}
					break;						
				}	
				case 8: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 4 Right\n");
#endif						
                            Rotary_Direction = 1;
                            ON_Voltage_Channel_4();	
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Volt Channel 4 Left\n");
#endif							
                            Rotary_Direction = 0;
                            ON_Voltage_Channel_4();	

							break;
						}
					}
					break;						
				}	
				case 9: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Generic Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Generic Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 10: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Level Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Level Left\n");
#endif							
							break;
						}
					}
					break;						
				}				
				case 11: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Timebase Right\n");
#endif						
                            Rotary_Direction = 1;
                            ON_Timebase();
                            	
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Timebase Left\n");
#endif							
                            Rotary_Direction = 0;
                            ON_Timebase();

							break;
						}
					}
					break;						
				}	
				case 12: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Delay Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Delay Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				
			}
			
			SendCtrlBlock();
			
			nr_delay(10);
			
			SendCtrlBlock3();			
			
			nr_delay(10);
			
			SendCtrlBlock2();			
			
			break;
		}
		
		case 9:
		{	
		
			switch(data[10])
			{
				case 1 :
				{
					CH1_X_Offset_1 = data[6];
					CH1_X_Offset_2 = data[7];
					CH1_X_Offset_3 = data[8];
					CH1_X_Offset_4 = data[9];
					
			        if (data[2] > 127) Channel1_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel1_1_ADC_Correction = data[2];
			        if (data[3] > 127) Channel1_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel1_2_ADC_Correction = data[3];
			        if (data[4] > 127) Channel1_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel1_3_ADC_Correction = data[4];
			        if (data[5] > 127) Channel1_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel1_4_ADC_Correction = data[5];					
					
					break;					
				}
				case 2 :
				{
					CH2_X_Offset_1 = data[6];
					CH2_X_Offset_2 = data[7];
					CH2_X_Offset_3 = data[8];
					CH2_X_Offset_4 = data[9];
					
			        if (data[2] > 127) Channel2_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel2_1_ADC_Correction = data[2];
			        if (data[3] > 127) Channel2_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel2_2_ADC_Correction = data[3];
			        if (data[4] > 127) Channel2_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel2_3_ADC_Correction = data[4];
			        if (data[5] > 127) Channel2_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel2_4_ADC_Correction = data[5];	
					
					break;					
				}
				case 3 :
				{
					CH3_X_Offset_1 = data[6];
					CH3_X_Offset_2 = data[7];
					CH3_X_Offset_3 = data[8];
					CH3_X_Offset_4 = data[9];	
					
			        if (data[2] > 127) Channel3_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel3_1_ADC_Correction = data[2];
			        if (data[3] > 127) Channel3_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel3_2_ADC_Correction = data[3];
			        if (data[4] > 127) Channel3_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel3_3_ADC_Correction = data[4];
			        if (data[5] > 127) Channel3_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel3_4_ADC_Correction = data[5];	
									
					break;				
				}
				case 4 :
				{
					CH4_X_Offset_1 = data[6];
					CH4_X_Offset_2 = data[7];
					CH4_X_Offset_3 = data[8];
					CH4_X_Offset_4 = data[9];
					
			        if (data[2] > 127) Channel4_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel4_1_ADC_Correction = data[2];
			        if (data[3] > 127) Channel4_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel4_2_ADC_Correction = data[3];
			        if (data[4] > 127) Channel4_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel4_3_ADC_Correction = data[4];
			        if (data[5] > 127) Channel4_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel4_4_ADC_Correction = data[5];	
								
					break;					
				}												
			}
#ifdef _Debug_USB_			
			if (Debug_Mode) printf("W : %d ; X1 : %d ; X2 : %d ; X3 : %d ; X4 : %d ; idx %i\n", data[10], data[6], data[7], data[8], data[9], data[11]);
#endif			
			
			config_changed = true;
			
			break;			
		}
		case 10: 											// Prgram the Flash
		{
			switch(data[2])
			{
				case 0 :                                    // Set programm mode
				{
                    switch(data[3])
                    {				
				        case 0 :                            // End programm mode
				        {				
//                            reset_watchdog->np_piodata = 0x01;						// Enableable WatchDog
                            Continius = true;
                            //adc_started = false;
                            result_buf = 0;
                            AutoTimerOff = false;

#ifdef _Debug_USB_
                            printf("Program mode disabled \n");
#endif
                            break;
                        }
				        case 1 :                            // Start programm mode
				        {				
//                            reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
                            Continius = false;
                            //adc_started = true;
                            result_buf = 1;

                            Stop_Record();
                            AutoTimerOff = true;

#ifdef _Debug_USB_
                            printf("Program mode enabled \n");
#endif
                            break;
                        }
                    }
                    break;
                }			
				case 1 :                                    // Erase a block
				{
				    prog_flash_adr = (unsigned long *) (data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24));
#ifdef _Debug_USB_				
				    printf("Erase address %x \n", prog_flash_adr);
#endif				
				    result_buf = AMDFlash::EraseSector_Flash(prog_flash_adr);
				
				    break;
                }
				case 2 :                                    // receive offset
				{
				    prog_flash_offset = (unsigned long) (data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24));
#ifdef _Debug_USB_				
				    printf("Received Flash Offset %x \n", prog_flash_offset);
#endif				
				    result_buf = 0;
				
				    break;
                }
				case 3 :                                    // Write a block
				{
				    prog_flash_adr = (unsigned long *) ((data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24)) - prog_flash_offset);
				
                    prog_flash_length = data[7];

                    result_buf = 0;
                    for (cnt = 0; cnt < prog_flash_length; cnt++)
                    {
                        result_buf = result_buf + AMDFlash::WriteData_Byte_Flash(prog_flash_adr, cnt, data[8 + cnt]);
                        //nr_delay(20);
                    }

#ifdef _Debug_USB_
                    printf("PFD @ %x[%d]  : %d \n", prog_flash_adr, prog_flash_length, result_buf);
#endif
				    break;
                }

				case 4 :                                    // Read Data
				{
				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif				
				    break;
                }

				case 5 :                                    // Read Software Version
				{
#ifdef _Debug_USB_				
				    printf("Read Software Version %x \n", tc_version);				
				    printf("Read Software Subversion %x \n", tc_subversion);
				    printf("Read Software Reversion %x \n", tc_dev_version);
				    printf("Read Software Compile %x \n", tc_dev_subversion);
#endif				
                    result_buf = 0;

                    send_buffer[7] = (unsigned char) tc_version & 0x000000FF;
                    send_buffer[8] = (unsigned char) ((tc_version & 0x0000FF00) >> 8);
                    send_buffer[9] = (unsigned char) ((tc_version & 0x00FF0000) >> 16);
                    send_buffer[10] = (unsigned char) ((tc_version & 0xFF000000) >> 24);

                    send_buffer[11] = (unsigned char) tc_subversion & 0x000000FF;
                    send_buffer[12] = (unsigned char) ((tc_subversion & 0x0000FF00) >> 8);
                    send_buffer[13] = (unsigned char) ((tc_subversion & 0x00FF0000) >> 16);
                    send_buffer[14] = (unsigned char) ((tc_subversion & 0xFF000000) >> 24);

                    send_buffer[15] = (unsigned char) tc_dev_version & 0x000000FF;
                    send_buffer[16] = (unsigned char) ((tc_dev_version & 0x0000FF00) >> 8);
                    send_buffer[17] = (unsigned char) ((tc_dev_version & 0x00FF0000) >> 16);
                    send_buffer[18] = (unsigned char) ((tc_dev_version & 0xFF000000) >> 24);

                    send_buffer[19] = (unsigned char) tc_dev_subversion & 0x000000FF;
                    send_buffer[20] = (unsigned char) ((tc_dev_subversion & 0x0000FF00) >> 8);
                    send_buffer[21] = (unsigned char) ((tc_dev_subversion & 0x00FF0000) >> 16);
                    send_buffer[22] = (unsigned char) ((tc_dev_subversion & 0xFF000000) >> 24);

				    break;
                }

				case 6 :                                    // Read Hardware Version
				{		
#ifdef _Debug_USB_                	
				    printf("Read Hardware Version %x \n", tc_hw_version);				
				    printf("Read Hardware SW Version %x \n", tc_hw_sw_version);				
				    printf("Read Serial %d hex : %x\n", tc_serial, tc_serial);				
#endif				
                    result_buf = 0;

                    send_buffer[7] = (unsigned char) (tc_hw_version & 0x000000FF);
                    send_buffer[8] = (unsigned char) ((tc_hw_version & 0x0000FF00) >> 8);
                    send_buffer[9] = (unsigned char) ((tc_hw_version & 0x00FF0000) >> 16);
                    send_buffer[10] = (unsigned char) ((tc_hw_version & 0xFF000000) >> 24);

                    send_buffer[11] = (unsigned char) (tc_hw_sw_version & 0x000000FF);
                    send_buffer[12] = (unsigned char) ((tc_hw_sw_version & 0x0000FF00) >> 8);
                    send_buffer[13] = (unsigned char) ((tc_hw_sw_version & 0x00FF0000) >> 16);
                    send_buffer[14] = (unsigned char) ((tc_hw_sw_version & 0xFF000000) >> 24);

                    send_buffer[15] = (unsigned char) (tc_serial & 0x000000FF);
                    send_buffer[16] = (unsigned char) ((tc_serial & 0x0000FF00) >> 8);
                    send_buffer[17] = (unsigned char) ((tc_serial & 0x00FF0000) >> 16);
                    send_buffer[18] = (unsigned char) ((tc_serial & 0xFF000000) >> 24);

                    send_buffer[19] = (unsigned char) (tc_production_lot1 & 0x000000FF);
                    send_buffer[20] = (unsigned char) ((tc_production_lot1 & 0x0000FF00) >> 8);
                    send_buffer[21] = (unsigned char) ((tc_production_lot1 & 0x00FF0000) >> 16);
                    send_buffer[22] = (unsigned char) ((tc_production_lot1 & 0xFF000000) >> 24);

                    send_buffer[23] = (unsigned char) (tc_production_lot2 & 0x000000FF);
                    send_buffer[24] = (unsigned char) ((tc_production_lot2 & 0x0000FF00) >> 8);
                    send_buffer[25] = (unsigned char) ((tc_production_lot2 & 0x00FF0000) >> 16);
                    send_buffer[26] = (unsigned char) ((tc_production_lot2 & 0xFF000000) >> 24);

                    send_buffer[27] = (unsigned char) (tc_model & 0x000000FF);
                    send_buffer[28] = (unsigned char) ((tc_model & 0x0000FF00) >> 8);
                    send_buffer[29] = (unsigned char) ((tc_model & 0x00FF0000) >> 16);
                    send_buffer[30] = (unsigned char) ((tc_model & 0xFF000000) >> 24);

				    break;
                }

				case 7 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 8 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 9 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 10 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 11 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 12 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 13 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 14 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 15 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 16 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 17 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

				case 18 :                                    // Read Data
				{

				    prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
				    if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
#ifdef _Debug_USB_
				    printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
#endif
				    break;
                }

            }

            send_buffer[0] = 10;
            send_buffer[1] = data[2];
            send_buffer[2] = data[3];
            send_buffer[3] = data[4];
            send_buffer[4] = data[5];
            send_buffer[5] = data[6];

            send_buffer[6] = result_buf;
            		
            SendData(send_buffer);

			break;
		}

		case 11: 											// Prgram the Flash
		{

            timebase_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_
            if (Debug_Mode) printf("TB Reg written %x\n", timebase_reg);
#endif
            SetupADC();	

			break;
		}
		case 12: 											// Prgram the Flash
		{
#ifdef _Debug_USB_		
			if (Debug_Mode) printf("Read TB Reg %x\n", timebase_reg);
#endif
			send_buffer[0] = 8;								 // Kennung Test Var
		
			send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
			send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
			send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
			send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);
		
			SendData(send_buffer);

			break;
		}		
		case 13: 											// Search Zeros
		{
			Search_Mode = true;
		
			CalcBuf = 0x01;
			while (CalcBuf != 0x00)
			{
				CalcBuf = Hardware::SearchZeros();
#ifdef _Debug_USB_
				printf("SearchResult : %i\n", CalcBuf);
#endif
			} 
			break;
		}
		
		case 14: 											// Receive Data
		{

			USB_Data_Requested = true;
			
			if (Continius == false) ISR_ADC_INT(6);

			break;			
		}	

		case 15: 											// Receive Data
        	{

			Set_Vars_Default();
			// BF insert - Recalc vars			
			Recalc_Vars();
			// BF insert - init display
			Display::DrawStartScreen();
			
			UpdateChannel(1, 1);
			UpdateChannel(2, 1);
		
			VoltageChangedCh1 = 1;
			VoltageChangedCh2 = 1;				
		
			LED_ON[0] = 1;
			LED_ON[1] = 1; 				
			LED_ON[5] = 1;
			LED_ON[6] = 0;
	
			Rotary_Steps = 0;
			ON_Zero_Channel_1();
			Rotary_Steps = 0;
			ON_Zero_Channel_2();
	
			SetSwitches(1, Selected_Voltage_CH1);
			SetSwitches(2, Selected_Voltage_CH2);

			if (NumberOfChannels > 2)
			{
				UpdateChannel(3, 1);
				UpdateChannel(4, 1);
	
				VoltageChangedCh3 = 1;
				VoltageChangedCh4 = 1;
			
				LED_ON[2] = 1;
				LED_ON[3] = 1;
					
				ON_Zero_Channel_3();
				ON_Zero_Channel_4();
	
				SetSwitches(3, Selected_Voltage_CH3);
				SetSwitches(4, Selected_Voltage_CH4);
	
			}
			else
			{
				UpdateChannel(3, 0);
				UpdateChannel(4, 0);
			}

			TriggerLevelChanged = 1;
			TriggerModeChanged  = 1;	
			TriggerWayChanged   = 1;
			TimebaseChanged     = 1;
			TimeOffsetChanged   = 1;
			MenuStatusChanged   = 1;
			MenuAktive          = 1;

			Cursor_Data_First_Draw = 0;
			Quick_Measure_First_Draw = 0;
			

			UpdateTrigger(12);
			Display::CALCPRETRIGGER();
			Display::DRAW_ALL_CURSOR();
				
                    	// remove the cursor data
			for (ix = 408 * 20; ix < 430 * 20; ix++)
			{
				*(UI_Plane1 + ix) = 0;	// delete
				*(Buffer_UI2Plane + ix) = 0;	// delete Text				
				*(UI_Plane4 + ix) = 0;	// delete
				*(UI_Plane5 + ix) = 0;	// delete
			}				

			Display::DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);						// Button
			Display::TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);							// Draw Voltage Text
//                   	Display::TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);							// Draw Voltage Text

			Display::DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);						// Button
			Display::TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);							// Draw Voltage Text
	//                    Display::TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);						// Draw Voltage Text
	
			Display::StatusUpdate();


			if (NumberOfChannels > 2)
			{
				Display::DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);					// Button
				Display::TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);						// Draw Voltage Text
	//                        Display::TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);						// Draw Voltage Text
	
				Display::DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);					// Button		
				Display::TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);						// Draw Voltage Text
	//                        Display::TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);						// Draw Voltage Text
			}
                    	Display::DRAWSTATUS(6, 0);
				
			Send_LED();

			break;			
		}

		case 16: 											// Receive Data
		{

			SendCtrlBlock();
			
			nr_delay(100);
			
			SendCtrlBlock3();
			
			nr_delay(10);
			
			SendCtrlBlock2();
            			
			USB_Connected = true;	

			break;			
		}             	

		case 17: 											// Receive Data
		{

			SendCtrlBlock2();

			break;			
		}
		
		case 18: 											// Receive Data
		{		
		
			New_Menu = 17;
			Menu_Changed = 1;
			
			USB_Connected = true;		
			
			break;			
		}		
	}
    }   // else			
}
/*
unsigned char Hardware::Calc_Chksum(volatile unsigned char Bytes[37])
{
    int i;

    for (i = 0; i < 37; i++)
    {
        calc_chks += Bytes[i];
        nr_uart_txchar(Bytes[i], puart2);
    }

}
*/
void Hardware::SendData(volatile unsigned char Bytes[40])
{
	int i;

#ifdef _Debug_USB_
    if (Command_Mode)
    {
        printf("Sending  0:%x  1:%x  2:%x  3:%x  4:%x  5:%x  6:%x  7:%x  8:%x 9:%x \n", Bytes[0], Bytes[1], Bytes[2], Bytes[3], Bytes[4], Bytes[5], Bytes[6], Bytes[7], Bytes[8], Bytes[9]);
        printf("Sending 10:%x 11:%x 12:%x 13:%x 14:%x 15:%x 16:%x 17:%x 18:%x 19:%x\n", Bytes[10], Bytes[11], Bytes[12], Bytes[13], Bytes[14], Bytes[15], Bytes[16], Bytes[17], Bytes[18], Bytes[19]);
        printf("Sending 20:%x 21:%x 22:%x 23:%x 24:%x 25:%x 26:%x 27:%x 28:%x 29:%x\n", Bytes[20], Bytes[21], Bytes[22], Bytes[23], Bytes[24], Bytes[25], Bytes[26], Bytes[27], Bytes[28], Bytes[29]);
        printf("Sending 30:%x 31:%x 32:%x 33:%x 34:%x 35:%x 36:%x \n", Bytes[30], Bytes[31], Bytes[32], Bytes[33], Bytes[34], Bytes[35], Bytes[36]);
    }
#endif

    nr_uart_txchar(40, puart2);
    for (i = 0; i < 40; i++)
    {
        nr_uart_txchar(Bytes[i], puart2);
    }
}

void Hardware::SendShot(void)
{
//    reset_watchdog->np_piodata = 0x00;                                  // Disable Watchdog

    // Disable all Interrupts
	DoDisableLogicAnalyserInterrupt();
	DoDisableReadVSyncInterrupt();
	DoDisableADCInterrupt();
	DoDisableTimer3Interrupt();
	DoDisableTimerInterrupt();
	DoDisableUART2Interrupt();
	DoDisableUARTInterrupt();
	DoDisableRotInterrupt();
	DoDisableKeyInterrupt();

	SendLayer(1);
	SendLayer(2);
	SendLayer(3);
	SendLayer(4);
	SendLayer(5);
	SendLayer(6);
	SendLayer(7);
	SendLayer(8);
	SendLayer(9);
	SendLayer(10);
	SendLayer(11);
	SendLayer(12);
	SendLayer(13);
	SendLayer(14);
	SendLayer(15);
	SendLayer(16);

    // Enable all Interrupts
	DoEnableKeyInterrupt();
	DoEnableRotInterrupt();
	DoEnableUARTInterrupt();
	DoEnableUART2Interrupt();
//	DoEnableTimerInterrupt();
	DoEnableTimer3Interrupt();
	DoEnableADCInterrupt();	
	DoEnableReadVSyncInterrupt();
//    DoEnableLogicAnalyserInterrupt();	

//    reset_watchdog->np_piodata = 0x01;                                  // Enable Watchdog
}

void Hardware::SendSWShot(void)
{
    unsigned int LineCnt, PackCnt;
    unsigned long *Layer1 = UI_Plane1;
    unsigned long *Layer2 = UI_Plane2;
    unsigned long *Layer3 = UI_Plane3;
    unsigned long *Layer4 = UI_Plane4;
    unsigned long *Layer5 = UI_Plane5;
    unsigned long *Layer6 = Channel_Plane1;
    unsigned long *Layer7 = Channel_Plane2;
    unsigned long *Layer8 = Channel_Plane3;
    unsigned long *Layer9 = Channel_Plane4;
    unsigned long *Layer10 = Channel_Math_Plane;
    unsigned long *Layer11 = Memory_Plane1;
    unsigned long *Layer12 = Memory_Plane2;
    unsigned long *Layer13 = Memory_Plane3;
    unsigned long *Layer14 = Marker_Plane1;
    unsigned long *Layer15 = Marker_Plane2;
    unsigned long *Layer16 = Grid_Plane;

    unsigned long BufLayer = 0x00000000;

//    reset_watchdog->np_piodata = 0x00;                                  // Disable Watchdog

    // Disable all Interrupts
	DoDisableLogicAnalyserInterrupt();
	DoDisableReadVSyncInterrupt();
	DoDisableADCInterrupt();
	DoDisableTimer3Interrupt();
	DoDisableTimerInterrupt();
	DoDisableUART2Interrupt();
	DoDisableUARTInterrupt();
	DoDisableRotInterrupt();
	DoDisableKeyInterrupt();


    send_buffer[0] = 254;                                               // Kennung Screen Data
    send_buffer[1] = 1;                                                 // Layer number

    for(LineCnt = 0; LineCnt < 1200; LineCnt++)
    {
        send_buffer[2] = (unsigned char) ((LineCnt & 0xFF00) >> 8);     // High Line Address
        send_buffer[3] = (unsigned char) (LineCnt & 0x00FF);            // Low Line Address

        for(PackCnt = 0; PackCnt < 8; PackCnt++)
        {

            BufLayer = Layer1[(LineCnt * 8) + PackCnt] | Layer2[(LineCnt * 8) + PackCnt] | Layer5[(LineCnt * 8) + PackCnt] | Layer6[(LineCnt * 8) + PackCnt] | Layer7[(LineCnt * 8) + PackCnt] | Layer8[(LineCnt * 8) + PackCnt] | Layer9[(LineCnt * 8) + PackCnt] | Layer10[(LineCnt * 8) + PackCnt] | Layer11[(LineCnt * 8) + PackCnt] | Layer12[(LineCnt * 8) + PackCnt] | Layer13[(LineCnt * 8) + PackCnt] | Layer14[(LineCnt * 8) + PackCnt] | Layer15[(LineCnt * 8) + PackCnt] | Layer16[(LineCnt * 8) + PackCnt];

            send_buffer[4 + (PackCnt * 4)] = (unsigned char) (BufLayer & 0x000000FF);
            send_buffer[5 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0x0000FF00) >> 8);
            send_buffer[6 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0x00FF0000) >> 16);
            send_buffer[7 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0xFF000000) >> 24);
        }

        SendData(send_buffer);
    }

    // Enable all Interrupts
	DoEnableKeyInterrupt();
	DoEnableRotInterrupt();
	DoEnableUARTInterrupt();
	DoEnableUART2Interrupt();
//	DoEnableTimerInterrupt();
	DoEnableTimer3Interrupt();
	DoEnableADCInterrupt();	
	DoEnableReadVSyncInterrupt();
//    DoEnableLogicAnalyserInterrupt();	

//    reset_watchdog->np_piodata = 0x01;                                  // Enable Watchdog
}

void Hardware::SendLayer(unsigned char LayerNr)						// Send a Layer through USB
{
    unsigned int LineCnt, PackCnt;
    unsigned long *Layer = Planes;

    switch(LayerNr)
    {
        case 1 : Layer = UI_Plane1; break;
        case 2 : Layer = UI_Plane2; break;
        case 3 : Layer = UI_Plane3; break;
        case 4 : Layer = UI_Plane4; break;
        case 5 : Layer = UI_Plane5; break;
        case 6 : Layer = Channel_Plane1; break;
        case 7 : Layer = Channel_Plane2; break;
        case 8 : Layer = Channel_Plane3; break;
        case 9 : Layer = Channel_Plane4; break;
        case 10 : Layer = Channel_Math_Plane; break;
        case 11 : Layer = Memory_Plane1; break;
        case 12 : Layer = Memory_Plane2; break;
        case 13 : Layer = Memory_Plane3; break;
        case 14 : Layer = Marker_Plane1; break;
        case 15 : Layer = Marker_Plane2; break;
        case 16 : Layer = Grid_Plane; break;
    }
    send_buffer[0] = 253;                                               // Kennung Screen Data
    send_buffer[1] = LayerNr;                                                 // Layer number

    for(LineCnt = 0; LineCnt < 1200; LineCnt++)
    {
        send_buffer[2] = (unsigned char) ((LineCnt & 0xFF00) >> 8);     // High Line Address
        send_buffer[3] = (unsigned char) (LineCnt & 0x00FF);            // Low Line Address

        for(PackCnt = 0; PackCnt < 8; PackCnt++)
        {
            send_buffer[4 + (PackCnt * 4)] = 0;
            send_buffer[5 + (PackCnt * 4)] = 0;
            send_buffer[6 + (PackCnt * 4)] = 0;
            send_buffer[7 + (PackCnt * 4)] = 0;

            send_buffer[4 + (PackCnt * 4)] = (unsigned char) (Layer[(LineCnt * 8) + PackCnt] & 0x000000FF);
            send_buffer[5 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0x0000FF00) >> 8);
            send_buffer[6 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0x00FF0000) >> 16);
            send_buffer[7 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0xFF000000) >> 24);
        }

        SendData(send_buffer);
    }
}

void Hardware::SendCtrlBlock(void)
{
    int intbuf, ix;
    int chk_calc = 0;

    send_buffer[0] = 105;								// Kennung Data
//    send_buffer[1] = 5;									// Kennung Datablock

    send_buffer[2] = (unsigned char) (Selected_Voltage_CH1);
    send_buffer[3] = (unsigned char) (Selected_Voltage_CH2);
    send_buffer[4] = (unsigned char) (Selected_Voltage_CH3);
    send_buffer[5] = (unsigned char) (Selected_Voltage_CH4);
    send_buffer[6] = (unsigned char) (Selected_Timebase);
    send_buffer[7] = (unsigned char) (SIGNALFaktor_idx);
		
    send_buffer[8] = (unsigned char) ((ZeroLevelCH1 + 64) >> 1);		
    send_buffer[9] = (unsigned char) ((ZeroLevelCH2 + 64) >> 1);		
    send_buffer[10] = (unsigned char) ((ZeroLevelCH3 + 64) >> 1);		
    send_buffer[11] = (unsigned char) ((ZeroLevelCH4 + 64) >> 1);		

    send_buffer[12] = (unsigned char) (NumberOfChannels);
    send_buffer[13] = (unsigned char) (ZFT_float);
        		
    send_buffer[14] = (unsigned char) SingleMode;
    send_buffer[15] = (unsigned char) Continius;

    send_buffer[16] = (unsigned char) Selected_Trigger_Source;

    send_buffer[17] = (unsigned char) 0;

    switch(Selected_Trigger_Source)
    {
        case 1 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH1 + 64) >> 1); break;
        case 2 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH2 + 64) >> 1); break;
        case 3 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH3 + 64) >> 1); break;
        case 4 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH4 + 64) >> 1); break;
        case 5 : send_buffer[17] = (unsigned char) Trigger_Pos_CHE; break;
    }

    send_buffer[18] = 0;
    if (Channel_1_Active) send_buffer[18] = send_buffer[18] | 0x01;
    if (MenuStatus[1][0] == 7) send_buffer[18] = send_buffer[18] | 0x02;  // AC
    if (MenuStatus[1][0] == 8) send_buffer[18] = send_buffer[18] | 0x04;  // AC
    if (MenuStatus[1][0] == 9) send_buffer[18] = send_buffer[18] | 0x08;  // AC
    if (MenuStatus[1][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert

    send_buffer[19] = 0;
    if (Channel_2_Active) send_buffer[19] = send_buffer[19] | 0x01;
    if (MenuStatus[2][0] == 7) send_buffer[19] = send_buffer[19] | 0x02;  // AC
    if (MenuStatus[2][0] == 8) send_buffer[19] = send_buffer[19] | 0x04;  // AC
    if (MenuStatus[2][0] == 9) send_buffer[19] = send_buffer[19] | 0x08;  // AC
    if (MenuStatus[2][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert

    send_buffer[20] = 0;
    if (Channel_3_Active) send_buffer[20] = send_buffer[20] | 0x01;
    if (MenuStatus[3][0] == 7) send_buffer[20] = send_buffer[20] | 0x02;  // AC
    if (MenuStatus[3][0] == 8) send_buffer[20] = send_buffer[20] | 0x04;  // AC
    if (MenuStatus[3][0] == 9) send_buffer[20] = send_buffer[20] | 0x08;  // AC
    if (MenuStatus[3][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert

    send_buffer[21] = 0;
    if (Channel_4_Active) send_buffer[21] = send_buffer[21] | 0x01;
    if (MenuStatus[4][0] == 7) send_buffer[21] = send_buffer[21] | 0x02;  // AC
    if (MenuStatus[4][0] == 8) send_buffer[21] = send_buffer[21] | 0x04;  // AC
    if (MenuStatus[4][0] == 9) send_buffer[21] = send_buffer[21] | 0x08;  // AC
    if (MenuStatus[4][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert

    send_buffer[22] = (unsigned char) Channel_Math_Active;

    send_buffer[23] = (unsigned char) MenuStatus[1][3];
    send_buffer[24] = (unsigned char) MenuStatus[2][3];
    send_buffer[25] = (unsigned char) MenuStatus[3][3];
    send_buffer[26] = (unsigned char) MenuStatus[4][3];
    send_buffer[27] = (unsigned char) MenuStatus[12][4];

    intbuf = (int)((float) Timebase_Offset_Pos * OFT_float);

    send_buffer[28] = (unsigned char) (intbuf & 0x00FF);
    send_buffer[29] = (unsigned char) ((intbuf & 0xFF00) >> 8);
    send_buffer[30] = (unsigned char) ((Timebase_Offset_Pos + 300) & 0x00FF);      // + 300 so it was unsigned
    send_buffer[31] = (unsigned char) (((Timebase_Offset_Pos + 300)  & 0xFF00) >> 8);

    send_buffer[32] = (unsigned char) MenuStatus[14][0];        // Trigger Edge
    send_buffer[33] = (unsigned char) MenuStatus[14][2];        // Trigger Extern

    send_buffer[34] = (unsigned char) (pre_reg & 0x00FF);
    send_buffer[35] = (unsigned char) ((pre_reg & 0xFF00) >> 8);

    chk_calc = 0;	
    for (ix = 0; ix < 32; ix++)
    {	
        chk_calc += send_buffer[3 + ix];
    }	
				
    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
        		
    SendData(send_buffer);
}

void Hardware::SendCtrlBlock2(void)
{
    int intbuf, ix;
    int chk_calc = 0;

    send_buffer[0] = 107;								// Kennung Data
//    send_buffer[1] = 7;									// Kennung Datablock

    send_buffer[2] = (unsigned char) (Cursor_Enabled);
    send_buffer[3] = (unsigned char) (SelectedCursor);
    send_buffer[4] = (unsigned char) (Cursor_XY_Selected);
    send_buffer[5] = (unsigned char) (Cursor_Both_Selected);
    send_buffer[6] = (unsigned char) (Cursor_Horizontal_Active);
    send_buffer[7] = (unsigned char) (Cursor_Vertical_Active);

    send_buffer[8] = (unsigned char) (Cursor_Horizontal_Position_Real1 & 0x000000FF);
    send_buffer[9] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0x0000FF00) >> 8);
    send_buffer[10] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0x00FF0000) >> 16);
    send_buffer[11] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0xFF000000) >> 24);

    send_buffer[12] = (unsigned char) (Cursor_Horizontal_Position_Real2 & 0x000000FF);
    send_buffer[13] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0x0000FF00) >> 8);
    send_buffer[14] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0x00FF0000) >> 16);
    send_buffer[15] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0xFF000000) >> 24);

    send_buffer[16] = (unsigned char) (Cursor_Vertical_Position_Real1 & 0x000000FF);
    send_buffer[17] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0x0000FF00) >> 8);
    send_buffer[18] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0x00FF0000) >> 16);
    send_buffer[19] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0xFF000000) >> 24);

    send_buffer[20] = (unsigned char) (Cursor_Vertical_Position_Real2 & 0x000000FF);
    send_buffer[21] = (unsigned char) ((Cursor_Vertical_Position_Real2 & 0x0000FF00) >> 8);
    send_buffer[22] = (unsigned char) ((Cursor_Vertical_Position_Real2 & 0x00FF0000) >> 16);
    send_buffer[23] = (unsigned char) ((Cursor_Vertical_Position_Real2 & 0xFF000000) >> 24);

    send_buffer[24] = (unsigned char) QM_Threshold_lower.Read_Value();
    send_buffer[25] = (unsigned char) QM_Threshold_middle.Read_Value();
    send_buffer[26] = (unsigned char) QM_Threshold_upper.Read_Value();

    send_buffer[27] = (unsigned char) ((SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float)) & 0x00FF);
    send_buffer[28] = (unsigned char) (((SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float)) & 0xFF00) >> 8);

    send_buffer[29] = (unsigned char) ((SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float)) & 0x00FF);
    send_buffer[30] = (unsigned char) (((SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float)) & 0xFF00) >> 8);

    //send_buffer[31] = (unsigned char) ((SIG_Start_Stop[ZIT_short][0] + (int)((float) -300 * OFT_float)) & 0x00FF);
    //send_buffer[32] = (unsigned char) (((SIG_Start_Stop[ZIT_short][0] + (int)((float) -300 * OFT_float)) & 0xFF00) >> 8);

    send_buffer[31] = (unsigned char) (Trig_Mem_Pos & 0x00FF);
    send_buffer[32] = (unsigned char) ((Trig_Mem_Pos & 0xFF00) >> 8);


    send_buffer[33] = (unsigned char) ((Trigger_Offset_Calc + 100) & 0x00FF);
    send_buffer[34] = (unsigned char) (((Trigger_Offset_Calc + 100) & 0xFF00) >> 8);

    send_buffer[35] = (unsigned char) (FirStartCH & 0x00FF);
    send_buffer[36] = (unsigned char) ((FirStartCH & 0xFF00) >> 8);
    

    //send_buffer[8] = (unsigned char) (Cursor_Vertical_Position_Real1 & 0x000000FF);
    //send_buffer[9] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0x0000FF00) >> 8);
    //send_buffer[10] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0x00FF0000) >> 16);
    //send_buffer[11] = (unsigned char) ((Cursor_Vertical_Position_Real1 & 0xFF000000) >> 24);            		
    //send_buffer[8] = (unsigned char) ((ZeroLevelCH1 + 64) >> 1);		
    //send_buffer[9] = (unsigned char) ((ZeroLevelCH2 + 64) >> 1);		
    //send_buffer[10] = (unsigned char) ((ZeroLevelCH3 + 64) >> 1);		
    //send_buffer[11] = (unsigned char) ((ZeroLevelCH4 + 64) >> 1);		

    //send_buffer[12] = (unsigned char) (NumberOfChannels);
    //send_buffer[13] = (unsigned char) (ZFT_float);
        		
    //send_buffer[14] = (unsigned char) SingleMode;
    //send_buffer[15] = (unsigned char) Continius;

    //send_buffer[16] = (unsigned char) Selected_Trigger_Source;

    //send_buffer[17] = (unsigned char) 0;
    /*
    switch(Selected_Trigger_Source)
    {
        case 1 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH1 + 64) >> 1); break;
        case 2 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH2 + 64) >> 1); break;
        case 3 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH3 + 64) >> 1); break;
        case 4 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH4 + 64) >> 1); break;
        case 5 : send_buffer[17] = (unsigned char) Trigger_Pos_CHE; break;
    }
    */
    //send_buffer[18] = (unsigned char) Channel_1_Active;
    //send_buffer[19] = (unsigned char) Channel_2_Active;
    //send_buffer[20] = (unsigned char) Channel_3_Active;
    //send_buffer[21] = (unsigned char) Channel_4_Active;
    //send_buffer[22] = (unsigned char) Channel_Math_Active;

    //send_buffer[23] = (unsigned char) MenuStatus[1][3];
    //send_buffer[24] = (unsigned char) MenuStatus[2][3];
    //send_buffer[25] = (unsigned char) MenuStatus[3][3];
    //send_buffer[26] = (unsigned char) MenuStatus[4][3];
    //send_buffer[27] = (unsigned char) MenuStatus[12][4];

    //intbuf = (int)((float) Timebase_Offset_Pos * OFT_float);

    //send_buffer[28] = (unsigned char) (intbuf & 0x00FF);
    //send_buffer[29] = (unsigned char) ((intbuf & 0xFF) >> 8);
    //send_buffer[30] = (unsigned char) ((Timebase_Offset_Pos + 300) & 0x00FF);      // + 300 so it was unsigned
    //send_buffer[31] = (unsigned char) (((Timebase_Offset_Pos + 300)  & 0xFF00) >> 8);

    chk_calc = 0;	
    for (ix = 0; ix < 32; ix++)
    {	
        chk_calc += send_buffer[3 + ix];
    }	
				
    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                    		
    SendData(send_buffer);
}

void Hardware::SendCtrlBlock3(void)
{
    int intbuf, ix;
    int chk_calc = 0;

    send_buffer[0] = 108;								// Kennung Data

    send_buffer[2] = (unsigned char) (Voltage_Correction[0][Selected_Voltage_CH1]);
    send_buffer[3] = (unsigned char) (Voltage_Correction[1][Selected_Voltage_CH2]);
    send_buffer[4] = (unsigned char) (Voltage_Correction[2][Selected_Voltage_CH3]);
    send_buffer[5] = (unsigned char) (Voltage_Correction[3][Selected_Voltage_CH4]);
    send_buffer[6] = (unsigned char) AutoFreeRun;
    
    send_buffer[7] = (unsigned char) 0;
    send_buffer[8] = (unsigned char) 0;
    send_buffer[9] = (unsigned char) 0;
    send_buffer[10] = (unsigned char) 0;
    send_buffer[11] = (unsigned char) 0;
    send_buffer[12] = (unsigned char) 0;
    send_buffer[13] = (unsigned char) 0;
    send_buffer[14] = (unsigned char) 0;
    send_buffer[15] = (unsigned char) 0;
    send_buffer[16] = (unsigned char) 0;
    send_buffer[17] = (unsigned char) 0;
    send_buffer[18] = (unsigned char) 0;
    send_buffer[19] = (unsigned char) 0;
    send_buffer[20] = (unsigned char) 0;
    send_buffer[21] = (unsigned char) 0;
    send_buffer[22] = (unsigned char) 0;
    send_buffer[23] = (unsigned char) 0;
    send_buffer[24] = (unsigned char) 0;
    send_buffer[25] = (unsigned char) 0;
    send_buffer[26] = (unsigned char) 0;
    send_buffer[27] = (unsigned char) 0;
    send_buffer[28] = (unsigned char) 0;
    send_buffer[29] = (unsigned char) 0;
    send_buffer[30] = (unsigned char) 0;
    send_buffer[31] = (unsigned char) 0;
    send_buffer[32] = (unsigned char) 0;
    send_buffer[33] = (unsigned char) 0;
    send_buffer[34] = (unsigned char) 0;
    send_buffer[35] = (unsigned char) 0;
    send_buffer[36] = (unsigned char) 0;

    chk_calc = 0;	
    for (ix = 0; ix < 32; ix++)
    {	
        chk_calc += send_buffer[3 + ix];
    }	
				
    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                    		
    SendData(send_buffer);
}

void Hardware::DoEnableTimerInterrupt(void)											// Enable service routine
{	
    return;
    					
	nr_installuserisr(na_timer1_irq,ISR_TIMER,(int)timer1); 						// Install timer isr
	

//	timer1->np_timerperiodh = timer_array_first[Selected_Timebase] >> 16;					// Set High Register of Timer
//	timer1->np_timerperiodl = timer_array_first[Selected_Timebase] & 0xffff;					// Set Low Register of Timer

    timer_reload_high = timerAutoFreefirst >> 16;					// Set High Register of Timer 200 ms  -> mu� in TB array
    timer_reload_low = timerAutoFreefirst & 0xffff;					// Set Low Register of Timer

    timer1->np_timerperiodh = timer_reload_high;
    timer1->np_timerperiodl = timer_reload_low;	

    timer_counter_value = 0;

    timer1->np_timercontrol = timer1->np_timercontrol | np_timercontrol_ito_mask;  	// Enable timer interrupt
    timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nTimer1 interrupt enabled.\n"); 										// print on console
#endif	
}
	
void Hardware::DoDisableTimerInterrupt(void)										// Disable service routine
{
	nr_installuserisr(na_timer1_irq,0,0); 											// Install empty routine for timer irq
	timer1->np_timercontrol = timer1->np_timercontrol & ~np_timercontrol_ito_mask; 	// Disable timer interrupt
}

void Hardware::Start_Timer1(void)
{
    return;

    if (init_done == false) return;

    if (Selected_Timebase < 17)
    {
        if (AutoSearchTrigger)
        {
            timer_reload_high = timerAutoFreefast >> 16;					// Set High Register of Timer 1 ms
            timer_reload_low = timerAutoFreefast & 0xffff;					// Set Low Register of Timer
        }
        else
        {
            timer_reload_high = timerAutoFreefirst >> 16;					// Set High Register of Timer 200 ms  -> mu� in TB array
            timer_reload_low = timerAutoFreefirst & 0xffff;					// Set Low Register of Timer
        }
    }
    else if (Selected_Timebase < 23)
    {
        if (AutoSearchTrigger)
        {
            timer_reload_high = timerAutoFreefast >> 13;					// Set High Register of Timer 4 ms
            timer_reload_low = timerAutoFreefast & 0xffff;					// Set Low Register of Timer
        }
        else
        {
            timer_reload_high = timerAutoFreefirst >> 13;					// Set High Register of Timer 800 ms  -> mu� in TB array
            timer_reload_low = timerAutoFreefirst & 0xffff;					// Set Low Register of Timer
        }
    }
    else
    {
        if (AutoSearchTrigger)
        {
            timer_reload_high = timerAutoFreefast >> (11 - (Selected_Timebase - 23));					// Set High Register of Timer 4 ms
            timer_reload_low = timerAutoFreefast & 0xffff;					// Set Low Register of Timer
        }
        else
        {
            timer_reload_high = timerAutoFreefirst >> (11 - (Selected_Timebase - 23));					// Set High Register of Timer 800 ms  -> mu� in TB array
            timer_reload_low = timerAutoFreefirst & 0xffff;					// Set Low Register of Timer
        }
    }

    timer1->np_timerperiodh = timer_reload_high;
    timer1->np_timerperiodl = timer_reload_low;	

    timer_counter_value = 0;
	
    timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_start_mask);	// Start Timer
}

void Hardware::Stop_Timer1(void)
{
    timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer
}

void Hardware::ISR_TIMER(int context)												// Menu Timer service subroutine
{
	char fchanged = 0;    	

	tc_test_var2++;
	
	timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer
	timer1->np_timerstatus = 0;										// write anything to clear the ISR

    timer1->np_timerperiodh = timer_reload_high;
    timer1->np_timerperiodl = timer_reload_low;	


#ifdef _Debug_IRQ_
	if (Debug_Mode)  printf("We got a timer1 irq  AFR %d  AST %d tcv %d tcm %d irq %d\n", AutoFreeRun, AutoSearchTrigger, timer_counter_value, timer_counter_max, acq_ready->np_piodata);
#endif

    Start_Record();  	
}

void Hardware::DoEnableTimer2Interrupt(void)										// Enable service routine
{	
    ROLLMODE_STARTED = true;

	timer2->np_timercontrol = ((timer2->np_timercontrol & 3) + np_timercontrol_stop_mask) & ~np_timercontrol_cont_mask;	// Stop Timer
	timer2->np_timerperiodh = rollmode_value[ROLLMODE_TB] >> 16;					// Set High Register of Timer
	timer2->np_timerperiodl = rollmode_value[ROLLMODE_TB] & 0xffff;					// Set Low Register of Timer
	timer2->np_timerstatus = 0;										// write anything to clear the ISR

	nr_installuserisr(na_timer2_irq,ISR_TIMER2,(int)timer2); 						// Install timer isr
	timer2->np_timercontrol = timer2->np_timercontrol | np_timercontrol_ito_mask;  	// Enable timer interrupt
	timer2->np_timercontrol = ((timer2->np_timercontrol & 3) + np_timercontrol_start_mask) | np_timercontrol_cont_mask;	// Start Timer
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nTimer2 interrupt enabled.\n");
#endif	
}
	
void Hardware::DoDisableTimer2Interrupt(void)										// Disable service routine
{
	nr_installuserisr(na_timer2_irq,0,0); 											// Install empty routine for timer irq
	timer2->np_timercontrol = timer2->np_timercontrol & ~np_timercontrol_ito_mask; 	// Disable timer interrupt
    timer2->np_timerstatus = 0;
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nTimer2 interrupt disabled.\n");	
#endif	
}

void Hardware::ISR_TIMER2(int context)												// Menu Timer service subroutine
{
    int cnt;

    tc_test_var2++;

	timer2->np_timerstatus = 0;														// write anything to clear the IRQ
	
	if (Search_Mode) return;
	if (Splash_drawed) return;
	if (Continius == false) return;
	
           	
    if (ROLLMODE_STARTED == false)
    {
        DoDisableTimer2Interrupt();
        return;
    }

	if (ROLLMODE_POS < 20)
    {
        ROLLMODE_POS++;
        return;
    }

#ifdef _Debug_Roll_Mode_
	if (Debug_Mode) printf("Got Rollmode irq\n");
#endif
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("Got Rollmode irq\n");
#endif		
//	{
//	   printf("ADCs per sec %d\n", sps_counter);
//	   printf("vsync per sec %d\n", vs_counter);
//    }
            	
	sps_counter = 0;
	vs_counter = 0;

	
	if (ROLLMODE_Value_rec == false) return;
	
	ROLLMODE_Value_rec = false;
	
	if (ROLLMODE_OFFSET > 5) ROLLMODE_OFFSET--;
	
	SIGNAL1_Intpolate[GRID_WIDTH] = ROLLMODE_BUFFVALUE_CH1;
	SIGNAL2_Intpolate[GRID_WIDTH] = ROLLMODE_BUFFVALUE_CH2;
	
	if (NumberOfChannels > 2)
	{
		SIGNAL3_Intpolate[GRID_WIDTH] = ROLLMODE_BUFFVALUE_CH3;
		SIGNAL4_Intpolate[GRID_WIDTH] = ROLLMODE_BUFFVALUE_CH4;
	}

    	Copy_in_asm((GRID_WIDTH + 1 - ROLLMODE_OFFSET), &SIGNAL1_Intpolate[GRID_WIDTH + 1 - (GRID_WIDTH - ROLLMODE_OFFSET)],
			 &SIGNAL1_Intpolate[GRID_WIDTH - (GRID_WIDTH - ROLLMODE_OFFSET)]);
    
	Copy_in_asm((GRID_WIDTH + 1 - ROLLMODE_OFFSET), &SIGNAL2_Intpolate[GRID_WIDTH + 1 - (GRID_WIDTH - ROLLMODE_OFFSET)],
			 &SIGNAL2_Intpolate[GRID_WIDTH - (GRID_WIDTH - ROLLMODE_OFFSET)]);

	if (NumberOfChannels > 2)
	{
		Copy_in_asm((GRID_WIDTH + 1 - ROLLMODE_OFFSET), &SIGNAL3_Intpolate[GRID_WIDTH + 1 - (GRID_WIDTH - ROLLMODE_OFFSET)],
				&SIGNAL3_Intpolate[GRID_WIDTH - (GRID_WIDTH - ROLLMODE_OFFSET)]);
		
		Copy_in_asm((GRID_WIDTH + 1 - ROLLMODE_OFFSET), &SIGNAL4_Intpolate[GRID_WIDTH + 1 - (GRID_WIDTH - ROLLMODE_OFFSET)],
				&SIGNAL4_Intpolate[GRID_WIDTH - (GRID_WIDTH - ROLLMODE_OFFSET)]);
	}

    	if (ROLLMODE_OFFSET > 597) return;

    	DrawSignals_Needed = 1;


}

void Hardware::Copy_in_asm(int cnt, unsigned char *DataArray_in, unsigned char *DataArray_out)
{
    asm("
            ;MOV		%l0, %i0

            ;MOV		%l1, %i1
            ;SUB     %l1, %i0

            ;MOV		%l2, %i2
            ;SUB     %l2, %i0

        copy_asm1 :
            LD      %r0, [%i1]          ; save old value
            EXT8D   %r0, %i1            ; extract byte

            FILL8	%r0, %r0
            ST8D	[%i2], %r0

            ADDI   %i1, 1                            ; Add Address Counter
            ADDI   %i2, 1                            ; Add Address Counter
                        	
            SUBI   %i0, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     copy_asm1	
            NOP

        ");

}

void Hardware::DoEnableTimer3Interrupt(void)										// Enable service routine
{					
	timer_rotary_busy->np_timerperiodh = timerrotPeriod >> 16;									// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = timerrotPeriod & 0xffff;									// Set Low Register of Timer
    timer_rotary_busy->np_timerstatus = 0;														// write anything to clear the IRQ

	nr_installuserisr(na_timer3_irq,ISR_TIMER3,(int)timer_rotary_busy); 						// Install timer isr

	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol | np_timercontrol_ito_mask;  	// Enable timer interrupt
	
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("Timer3 interrupt enabled & started.\n"); 										// print on console
#endif	
}
	
void Hardware::DoDisableTimer3Interrupt(void)										// Disable service routine
{
	nr_installuserisr(na_timer3_irq,0,0); 											// Install empty routine for timer irq
	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol & ~np_timercontrol_ito_mask; 	// Disable timer interrupt
}

void Hardware::ISR_TIMER3(int context)		// Menu Timer service subroutine
{
	char fchanged = 0;
	char already_saved =0;					// TMW added variable

	tc_test_var2++;

	timer_rotary_busy->np_timerstatus = 0;	// write anything to clear the IRQ
    	
	if ((Search_Mode) || (Splash_drawed)) return;

	
 	if (MenuItemPushed[0] == 1) { fchanged = 1; MenuItemPushed[0] = 0; MenuItemPushed_old[0] = 1; MenuItemChanged[0] = 1;}
	if (MenuItemPushed[1] == 1) { fchanged = 1; MenuItemPushed[1] = 0; MenuItemPushed_old[1] = 1; MenuItemChanged[1] = 1;}
	if (MenuItemPushed[2] == 1) { fchanged = 1; MenuItemPushed[2] = 0; MenuItemPushed_old[2] = 1; MenuItemChanged[2] = 1;}
	if (MenuItemPushed[3] == 1) { fchanged = 1; MenuItemPushed[3] = 0; MenuItemPushed_old[3] = 1; MenuItemChanged[3] = 1;}
	if (MenuItemPushed[4] == 1) { fchanged = 1; MenuItemPushed[4] = 0; MenuItemPushed_old[4] = 1; MenuItemChanged[4] = 1;}
	if (MenuItemPushed[5] == 1) { fchanged = 1; MenuItemPushed[5] = 0; MenuItemPushed_old[5] = 1; MenuItemChanged[5] = 1;}

	if (StatusbarChanged) { Display::RemoveStatusBtn(); }	// Remove the Status Button
	if (MenuPopupActive > -1)
    	{
  		config_changed = true;  								// TMW changed (moved from below)
		AMDFlash::Write_Config_Flash();							// TMW changed (moved from below)
       	fchanged = 0;
        Display::DRAWMENUPOPDOWN();
		already_saved =1;										// TMW added variable
    	}	 

// TMW changed    
	if ((Memory_Window_visible) && (MenuStatus[5][4] == 240)) 	// if Memory Window is visible and
    	{													  	// Browse Function not active
		if ( already_saved == 0 )								// TMW added variable
			{
  			config_changed = true;  							// TMW changed (added to above)
			AMDFlash::Write_Config_Flash();						// TMW changed (added to above)
			}
			
      	Display::DRAWMEMORY(1, 0, 0);     					  	// Close Memory Window and
        //Display::DRAW_ALL_CURSOR();	// TMW removed			// redraw all cursors due to closure
    	}
// TMW change ends




//	if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
	
	if (fchanged == 1) { New_Menu = Active_Menu; Menu_Changed = 1; }
	

    /*
	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);// & ~np_timercontrol_cont_mask;	// Stop Timer

	timer_rotary_busy->np_timerperiodh = timerrotPeriod >> 16;									// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = timerrotPeriod & 0xffff;									// Set Low Register of Timer
	*/


    ButtonChanged = 0;
    RoteryReady = 0;
    DrawSignals_Needed = 0;
    UserIface_active = 0;
	Menu_Popup_visible =0;

    acq_ready->np_pioedgecapture = 0;
    //acq_ready->np_piointerruptmask = 0x01;

    //config_changed = true;  							// TMW changed (set in comments)
    //AMDFlash::Write_Config_Flash();

    //SetupADC();										// TMW changed (set in comments)

 //   if (TriggerOffsetChanged == true) SetupADC();
 //   TriggerOffsetChanged = false;

    //if ((MenuStatus[10][2] == 1) && (ROLLMODE_STARTED == true)) return;
          /*
    if (Continius)
    {
        LED_ON[12] = 1;
        LED_ON[13] = 0;
        Send_LED();

        //if ((adc_started == false) && (OneShotRestart == false)) Start_Record();
        if (OneShotRestart == false) Start_Record();
    }   */

   	//if ((MenuStatus[10][2] == 1) && (ROLLMODE_STARTED == false)) DoEnableTimer2Interrupt();

}

void Hardware::ResetTimer(void)	// Reset Timer
{
	long timerVal;
	long timerPeriod;

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);// & ~np_timercontrol_cont_mask;	// Stop Timer
	timer_rotary_busy->np_timerstatus = 0;								// write anything to clear the IRQ
		
	timer_rotary_busy->np_timerperiodh = timerrotPeriod >> 16;			// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = timerrotPeriod & 0xffff;		// Set Low Register of Timer

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer

}

void Hardware::SetSwitches(char channel, int voltage)
{
	bool DoNothing = 0;
	short dat_buf = 0;
	short CalcBufInt = 0;	
	long adr_buf = 0x00000000;
	long outbuf = 0x00000000;
				
	switch(voltage)
	{
		case -1 :
		{
			switch(channel)
			{
				case 1 : dat_buf = SwitchesCH1;break;
				case 2 : dat_buf = SwitchesCH2;break;
				case 3 : dat_buf = SwitchesCH3;break;
				case 4 : dat_buf = SwitchesCH4;break;
				case 5 : dat_buf = SwitchesTB;break;				
			}	
			break;		
		}			
	
		case 0 : dat_buf = 0x0015; break;
		case 1 : dat_buf = 0x0015; break;
		case 2 : dat_buf = 0x0015; break;
		case 3 : dat_buf = 0x0015; break;
		case 4 : dat_buf = 0x0055; break;
		case 5 : dat_buf = 0x00C5; break;
		case 6 : dat_buf = 0x0019; break;
		case 7 : dat_buf = 0x0059; break;
		case 8 : dat_buf = 0x00C9; break;
		case 9 : dat_buf = 0x001A; break;
		case 10 : dat_buf = 0x005A; break;
		case 11 : dat_buf = 0x00CA; break;
	}

	switch(channel)
	{
		case 1:
		{
			adr_buf = 0x70000000;		// channel 1 = address 7 (hardware)

            // Set AC Bits
            dat_buf = dat_buf & 0xF0DF;

	        if (MenuStatus[1][0] == 8) dat_buf = dat_buf | 0x0100;
            if (MenuStatus[2][0] == 8) dat_buf = dat_buf | 0x0200;
            if (MenuStatus[3][0] == 8) dat_buf = dat_buf | 0x0400;
            if (MenuStatus[4][0] == 8) dat_buf = dat_buf | 0x0800;	

            // BW Limit
            if (MenuStatus[1][1] == 241) dat_buf = dat_buf | 0x0020;

			SwitchesCH1 = dat_buf;
			
			VoltageChangedCh1 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH1, (adr_buf | SwitchesCH1));
#endif			
			break;	
		}
		case 2:
		{
			adr_buf = 0x50000000;		// channel 2 = address 5 (hardware)
						
			dat_buf = dat_buf & 0xFFDF;
			if (MenuStatus[2][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH2 = dat_buf;
            			
			VoltageChangedCh2 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH2, (adr_buf | SwitchesCH2));
#endif			
			break;	
		}
		case 3:
		{
			adr_buf = 0x10000000;		// channel 3 = address 4 (hardware)
					
			dat_buf = dat_buf & 0xFFDF;
			if (MenuStatus[3][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH3 = dat_buf;
            			
			VoltageChangedCh3 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH3, (adr_buf | SwitchesCH3));
#endif			
			break;	
		}
		case 4:
		{
			adr_buf = 0x30000000;		// channel 4 = address 3 (hardware)
				
            dat_buf = dat_buf & 0xFFDF;	
			if (MenuStatus[4][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH4 = dat_buf;
            			
			VoltageChangedCh4 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH4, (adr_buf | SwitchesCH4));
#endif			
			break;	
		}		
		case 5:
		{
			adr_buf = 0x20000000;		// trigger channel = address 2 (hardware)
			
			SwitchesTB = voltage;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesTB, (adr_buf | SwitchesTB));
#endif			
			break;	
		}				
	}

	switch(channel)
	{
		case 1: outbuf = adr_buf | SwitchesCH1; break;
		case 2: outbuf = adr_buf | SwitchesCH2; break;
		case 3: outbuf = adr_buf | SwitchesCH3; break;
		case 4: outbuf = adr_buf | SwitchesCH4; break;
		case 5: outbuf = adr_buf | SwitchesTB; break;		
		case 6: outbuf = 0xFFFFFFFF; break;		
		case 7: outbuf = 0x00000000; break;				
	}	
#ifdef _Debug_		
    if (Debug_Mode) printf("outbuf1 : %x\n", outbuf);
#endif       		
    serdata->np_piodata = outbuf;//TurnBits(outbuf);
	
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
		
	nr_delay(15);

	switch(channel)
	{
		case 1: outbuf = (adr_buf | SwitchesCH1) & 0xFFFFFFF0; break;
		case 2: outbuf = (adr_buf | SwitchesCH2) & 0xFFFFFFF0; break;
		case 3: outbuf = (adr_buf | SwitchesCH3) & 0xFFFFFFF0; break;
		case 4: outbuf = (adr_buf | SwitchesCH4) & 0xFFFFFFF0; break;
	}		
#ifdef _Debug_
    if (Debug_Mode) printf("outbuf2 : %x\n", outbuf);
#endif
    if ((channel > 0) && (channel < 5))
    {
        serdata->np_piodata = outbuf;//TurnBits(outbuf);	
	
	   serstartsw->np_piodata = 1;
	   serstartsw->np_piodata = 0;	

	   nr_delay(15);
    }
#ifdef _Debug_	
	if (Debug_Mode)
    {
	    switch(channel)
	    {	
		    case 1: printf("Switches : %x , erg : %x\n", SwitchesCH1, (adr_buf | SwitchesCH1) & 0xFFFFFFF0); break;
		    case 2: printf("Switches : %x , erg : %x\n", SwitchesCH2, (adr_buf | SwitchesCH2) & 0xFFFFFFF0); break;
		    case 3: printf("Switches : %x , erg : %x\n", SwitchesCH3, (adr_buf | SwitchesCH3) & 0xFFFFFFF0); break;
		    case 4: printf("Switches : %x , erg : %x\n", SwitchesCH4, (adr_buf | SwitchesCH4) & 0xFFFFFFF0); break;
		    case 5: printf("Switches : %x , erg : %x\n", SwitchesTB, (adr_buf | SwitchesTB) & 0xFFFFFFFF); break;
	    }
    }
#endif					
//	nr_delay(1);
		
	switch(channel)
	{	
		case 1: SwitchesCH1Old = SwitchesCH1; break;
		case 2: SwitchesCH2Old = SwitchesCH2; break;
		case 3: SwitchesCH3Old = SwitchesCH3; break;
		case 4: SwitchesCH4Old = SwitchesCH4; break;
	}
}

void Hardware::SetDacOffset(char channel)
{
	long CalcBufInt = 0;	
	long BufInt = 0;
	long BufInt2 = 0;	
	long outbuf = 0x00000000;		


	switch(channel)
	{
		case 1 :	//if (CH1_DAC_Offset != CH1_DAC_OffsetOld)
					{
						BufInt = CH1_DAC_Offset;
						BufInt2 = (0x00310000 | (BufInt * 4));


						// Bei gelegenheit gegen Turnbits tauschen
						outbuf = (0x60000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 2 :	//if (CH2_DAC_Offset != CH2_DAC_OffsetOld)
					{
						BufInt = CH2_DAC_Offset;
						BufInt2 = (0x00300000 | (BufInt * 4));						

                        outbuf = (0x60000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 3 :	//if (CH3_DAC_Offset != CH3_DAC_OffsetOld)
					{
						BufInt = CH3_DAC_Offset;
						BufInt2 = (0x00310000 | (BufInt * 4));	
						
                        outbuf = (0x40000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 4 :	//if (CH4_DAC_Offset != CH4_DAC_OffsetOld)
					{
						BufInt = CH4_DAC_Offset;
						BufInt2 = (0x00300000 | (BufInt * 4));						

                        outbuf = (0x40000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
	}											
#ifdef _Debug_
	if (Debug_Mode) printf("ch : %d cb : %x bi : %x bi2 : %x  ob : %x \n", channel, CalcBufInt, BufInt, BufInt2, outbuf);
#endif
}

void Hardware::SetCHDacOffset(char channel)
{
	switch(channel)
	{
		case 1 : 	//if (CH1_DAC_1 != CH1_DAC_1Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH1_DAC_1 | 0x0600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	

						nr_delay(1);
					}

					//if (CH1_DAC_2 != CH1_DAC_2Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH1_DAC_2 | 0x1600; //0x0E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
										
					//if (CH1_DAC_3 != CH1_DAC_3Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH1_DAC_3 | 0x1E00; //0x1600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
				
					//if (CH1_DAC_4 != CH1_DAC_4Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH1_DAC_4 | 0x2600; //0x1E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);	
					}
					
					break;														
															
		case 2 : 	//if (CH2_DAC_1 != CH2_DAC_1Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH2_DAC_1 | 0x0E00; //0x2600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}	
						
					//if (CH2_DAC_2 != CH2_DAC_2Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH2_DAC_2 | 0x3E00; //0x2E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}				

					//if (CH2_DAC_3 != CH2_DAC_3Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH2_DAC_3 | 0x3600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
						
					//if (CH2_DAC_4 != CH2_DAC_4Old)
				 	{
						serdata->np_piodata = 0x80000000 | CH2_DAC_4 | 0x2E00; //0x3E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
										
					break;

		case 3 : 	//if (CH3_DAC_1 != CH3_DAC_1Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH3_DAC_1 | 0x0600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	

						nr_delay(1);		
					}			

					//if (CH3_DAC_2 != CH3_DAC_2Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH3_DAC_2 | 0x0E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
										
					//if (CH3_DAC_3 != CH3_DAC_3Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH3_DAC_3 | 0x1600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
				
					//if (CH3_DAC_4 != CH3_DAC_4Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH3_DAC_4 | 0x1E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);	
					}
					
					break;														
															
		case 4 : 	//if (CH4_DAC_1 != CH4_DAC_1Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH4_DAC_1 | 0x2600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);	
					}
						
					//if (CH4_DAC_2 != CH4_DAC_2Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH4_DAC_2 | 0x2E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}				

					//if (CH4_DAC_3 != CH4_DAC_3Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH4_DAC_3 | 0x3600;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
						
					//if (CH4_DAC_4 != CH4_DAC_4Old)
				 	{
						serdata->np_piodata = 0x90000000 | CH4_DAC_4 | 0x3E00;

						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
						
						nr_delay(1);
					}
										
					break;					
					
	}	
}

void Hardware::SetupADC(void)
{
	mode->np_piodata = 0x01;
		
	if (triggering == 0) WRITEADC(1, (ctrl_reg | 0x0001) + (adc_ctrl_reg << 16));																		
	else if(triggering == 1) WRITEADC(1, ctrl_reg + (adc_ctrl_reg << 16));
	else WRITEADC(1, (ctrl_reg & 0xFFFE) + (adc_ctrl_reg << 16));					

	WRITEADC(1, timebase_reg);
	
	WRITEADC(1, pre_reg + (channel_Adr_add << 16));
    	
	WRITEADC(1, trg_val_CHI_reg + (trg_val_CHII_reg << 8) + (trig_range_reg << 16));
	WRITEADC(1, (0xFFFFFFFF - trig_holdoff_reg));    	
	WRITEADC(1, trig_width_reg + (GridColor_Val << 26));
	WRITEADC(1, adc_change12_reg);
	
	WRITEADC(1, adc_ctr12_reg);

	mode->np_piodata = 0x00;
						
	if (NumberOfChannels == 4)
	{
        mode->np_piodata = 0x01;
                            				
        if(triggering == 3) WRITEADC(3, ctrl_reg + (adc_ctrl_reg << 16));
        else WRITEADC(3, (ctrl_reg & 0xFFFE) + (adc_ctrl_reg << 16));

        WRITEADC(3, timebase_reg);
	
        WRITEADC(3, pre_reg + (channel_Adr_add2 << 16));
	
        WRITEADC(3, trg_val_CHIII_reg + (trg_val_CHIV_reg << 8) + (trig_range_reg << 16));	
        WRITEADC(3, (0xFFFFFFFF - trig_holdoff_reg));
        WRITEADC(3, trig_width_reg + (GridColor_Val << 26));
        WRITEADC(3, adc_change34_reg);

        WRITEADC(3, adc_ctr12_reg);

        mode->np_piodata = 0x00;
    }
#ifdef _Debug_	
	if (Debug_Mode) printf("ctr %x actr %x tb %x pr %x tv1 %x tv2 %x tv1 %x tv2 %x trr %x trw %x cha %x adcch12 %x adcch34 %x adcctr12 %x adcctr34 %x\n", ctrl_reg, adc_ctrl_reg, timebase_reg, pre_reg, trg_val_CHI_reg, trg_val_CHII_reg, trg_val_CHIII_reg, trg_val_CHIV_reg, trig_range_reg, trig_width_reg, channel_Adr_add, adc_change12_reg, adc_change34_reg, adc_ctr12_reg, adc_ctr34_reg);
#endif
}

void Hardware::WRITEADC(unsigned char which, unsigned long value)
{	
	switch(which)
	{
		case 1 :
				asm("		
						MOV		%r0,%i1											; Address of Buffer
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 2 :
				asm("		
						MOV		%r0,%i1											; Address of Buffer
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 3 :
				asm("		
						MOV		%r0,%i1											; Address of Buffer
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 4 :
				asm("		
						MOV		%r0,%i1											; Address of Buffer
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
			
						ST		[%l0], %r0		
					");	
				break;
	}
}

unsigned long Hardware::READADC(unsigned char which)
{
	switch(which)
	{
		case 1 :
				asm("		
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0
					");	
				break;
		case 2 :
				asm("		
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 3 :
				asm("		
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 4 :
				asm("		
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
	}
}	

void Hardware::PREPARE_READADC(unsigned char correct1, unsigned char correct2, unsigned char correct3, unsigned char correct4, unsigned int count)
{
    asm("
            MOV		%r3, %i0
            MOV		%r4, %i1
            MOV		%r5, %i2
            MOV		%r6, %i3
            MOV		%r7, %i4
        ");
}
/*
void Hardware::READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{
    asm("
            MOV		%l1, %r7               ; set address offset memory 2

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow                ; jump to slow tb configuration
            NOP                   									

            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x0001)
            ADDI    %l4, %lo(0x0001);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x0002)
            ADDI    %l5, %lo(0x0002);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x0003)
            ADDI    %l6, %lo(0x0003);

            BR      lpr_channel
            NOP

        lpr_slow:
            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x1000)
            ADDI    %l4, %lo(0x1000);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x2000)
            ADDI    %l5, %lo(0x2000);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x3000)
            ADDI    %l6, %lo(0x3000);

      lpr_channel:

            CMPI    %i0, 0x01               ; Is it channel 1
            IFS     cc_z
            BR      lpr1ch1
            NOP

            CMPI    %i0, 0x02               ; Is it channel 2
            IFS     cc_z
            BR      lpr1ch2
            NOP

            CMPI    %i0, 0x03               ; Is it channel 3
            IFS     cc_z
            BR      lpr1ch3
            NOP

            CMPI    %i0, 0x04               ; Is it channel 4
            IFS     cc_z
            BR      lpr1ch4
            NOP

        lpr1ch1:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI	%l0,%lo(0x00A00000)
            PFX		%xhi(0x00A00000)
            MOVHI	%l0,%xlo(0x00A00000)
            BR      lpr1
            NOP

        lpr1ch2:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI	%l0,%lo(0x00A00010)
            PFX		%xhi(0x00A00010)
            MOVHI	%l0,%xlo(0x00A00010)
            BR      lpr1
            NOP

        lpr1ch3:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI	%l0,%lo(0x00A00020)
            PFX		%xhi(0x00A00020)
            MOVHI	%l0,%xlo(0x00A00020)
            BR      lpr1
            NOP

        lpr1ch4:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI	%l0,%lo(0x00A00030)
            PFX		%xhi(0x00A00030)
            MOVHI	%l0,%xlo(0x00A00030)
                       						                       		
        lpr1:
            LD		%l2, [%l0]
            NOT     %l2	
                       						
            ; start mem 1			
            MOV		%r0, %l2  							

            EXT8S	%r0, 0
						
            IFRZ      %i2                 ; inverting
            BR        lpr1s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr1i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr1s
            NOP								
						
        lpr1i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(0)
            MOVI      %r2, %lo(0)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr1s:
      						
            IFRZ      %i4                 ; is average = 0
            BR        lpr1e
            NOP						
	
            ; start averaging

            LD        %l7, [%i1]          ; save old value
            EXT8D     %l7, %i1            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr1a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr1e
            NOP	
						
        lpr1a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr1e:							
            SUB     %r0, %r3	

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%i1], %r0          					
												
            ; start mem 2		
            MOV		%r0, %l2  							

            EXT8S	%r0, 1
						
            IFRZ      %i2                 ; inverting
            BR        lpr2s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr2i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr2s
            NOP								
						
        lpr2i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr2s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr2e
            NOP						
	
            ; start averaging

            LD        %l7, [%l4]          ; save old value
            EXT8D     %l7, %l4            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr2a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr2e
            NOP	
						
        lpr2a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr2e:							
			SUB     %r0, %r4
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l4], %r0

            ; start mem 3								
            MOV     %r0, %l2  							

            EXT8S	%r0, 2
						
            IFRZ    %i2                 ; inverting
            BR      lpr3s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr3i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr3s
            NOP								
						
        lpr3i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr3s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr3e
            NOP						
	
            ; start averaging

            LD        %l7, [%l5]          ; save old value
            EXT8D     %l7, %l5            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr3a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr3e
            NOP	
						
        lpr3a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr3e:							
            SUB     %r0, %r5

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%l5], %r0
						
            ; start mem 4								
            MOV		%r0, %l2  							

            EXT8S	%r0, 3
						
            IFRZ      %i2                 ; inverting
            BR        lpr4s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr4i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)	; (0) ???	
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr4s
            NOP								
						
        lpr4i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr4s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr4e
            NOP						
	
            ; start averaging

            LD        %l7, [%l6]          ; save old value
            EXT8D     %l7, %l6            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr4a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr4e
            NOP	
						
        lpr4a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr4e:							
			SUB     %r0, %r6
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l6], %r0

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow_ac             ; jump to slow address calculaten
            NOP
						
            ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter
            ADDI   %l4, 4                            ; Add Address Counter
            ADDI   %l5, 4                            ; Add Address Counter
            ADDI   %l6, 4                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP	

            BR     lprend
            NOP	


        lpr_slow_ac:
            ; calc new adresses
            ADDI   %i1, 1                            ; Add Address Counter
            ADDI   %l4, 1                            ; Add Address Counter
            ADDI   %l5, 1                            ; Add Address Counter
            ADDI   %l6, 1                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP

        lprend:					
							
    ");
}
*/

/* Test Plain
void Hardware::READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{
    asm("
            MOV		%l1, %r7               ; set address offset memory 2

            PFX     %hi(0x00917440)         ; load address channel
            MOVI	%l0,%lo(0x00917440)
            PFX		%xhi(0x00917440)
            MOVHI	%l0,%xlo(0x00917440)

        lpr1:
            LD		%l2, [%l0]
            MOV		%r0, %l2  							
            ST      [%i1], %r0          					

            ADDI   %l0, 4                            ; Add Address Counter
            ADDI   %i1, 4                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP	
					
							
    ");
}
*/
/**
void Hardware::READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{
    asm("
            MOV		%l1, %r7               ; set address offset memory 2

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow                ; jump to slow tb configuration
            NOP                   									

            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x0001)
            ADDI    %l4, %lo(0x0001);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x0002)
            ADDI    %l5, %lo(0x0002);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x0003)
            ADDI    %l6, %lo(0x0003);

            BR      lpr_channel
            NOP

        lpr_slow:
            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x1000)
            ADDI    %l4, %lo(0x1000);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x2000)
            ADDI    %l5, %lo(0x2000);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x3000)
            ADDI    %l6, %lo(0x3000);

      lpr_channel:


            PFX     %hi(0x00917440)         ; load address channel
            MOVI	%l0,%lo(0x00917440)
            PFX		%xhi(0x00917440)
            MOVHI	%l0,%xlo(0x00917440)


                       						                       		
        lpr1:
            LD		%l2, [%l0]
            NOT     %l2	
                       						
            ; start mem 1			
            MOV		%r0, %l2  							

            EXT8S	%r0, 0
        					
            SUB     %r0, %r3	

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%i1], %r0          					
												
            ; start mem 2		
            MOV		%r0, %l2  							

            EXT8S	%r0, 1
            						
			SUB     %r0, %r4
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l4], %r0

            ; start mem 3								
            MOV     %r0, %l2  							

            EXT8S	%r0, 2
												
            SUB     %r0, %r5

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%l5], %r0
						
            ; start mem 4								
            MOV		%r0, %l2  							

            EXT8S	%r0, 3
											
			SUB     %r0, %r6
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l6], %r0


            ADDI   %l0, 4                            ; Add Address Counter

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow_ac             ; jump to slow address calculaten
            NOP
						
            ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter
            ADDI   %l4, 4                            ; Add Address Counter
            ADDI   %l5, 4                            ; Add Address Counter
            ADDI   %l6, 4                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP	

            BR     lprend
            NOP	


        lpr_slow_ac:
            ; calc new adresses
            ADDI   %i1, 1                            ; Add Address Counter
            ADDI   %l4, 1                            ; Add Address Counter
            ADDI   %l5, 1                            ; Add Address Counter
            ADDI   %l6, 1                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP

        lprend:					
							
    ");
}
**/


void Hardware::READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{
    asm("
                     PFX	%hi(0xFEFEFEFE)                   ; Set MASK
                     MOVI	%r10,%lo(0xFEFEFEFE)
                     PFX	%xhi(0xFEFEFEFE)
                     MOVHI	%r10,%xlo(0xFEFEFEFE)

           MOV		%l1, %r7               ; set address offset memory 2

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow                ; jump to slow tb configuration
            NOP                   									

            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x0001)
            ADDI    %l4, %lo(0x0001);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x0002)
            ADDI    %l5, %lo(0x0002);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x0003)
            ADDI    %l6, %lo(0x0003);

            BR      lpr_channel
            NOP

        lpr_slow:
            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x1000)
            ADDI    %l4, %lo(0x1000);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x2000)
            ADDI    %l5, %lo(0x2000);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x3000)
            ADDI    %l6, %lo(0x3000);

      lpr_channel:


            PFX     %hi(0x00917440)         ; load address channel
            MOVI	%l0,%lo(0x00917440)
            PFX		%xhi(0x00917440)
            MOVHI	%l0,%xlo(0x00917440)


                       						                       		
        lpr1:
            LD		%l2, [%l0]
            NOT     %l2	
            ;AND		%l2,%r10
           						
            ; start mem 1			
            MOV		%r0, %l2  							

            EXT8S	%r0, 0
						
            IFRZ      %i2                 ; inverting
            BR        lpr1s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr1i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr1s
            NOP								
						
        lpr1i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(0)
            MOVI      %r2, %lo(0)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr1s:
      						
            IFRZ      %i4                 ; is average = 0
            BR        lpr1e
            NOP						
	
            ; start averaging

            LD        %l7, [%i1]          ; save old value
            EXT8D     %l7, %i1            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr1a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr1e
            NOP	
						
        lpr1a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr1e:							
            SUB     %r0, %r3	

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%i1], %r0          					
												
            ; start mem 2		
            MOV		%r0, %l2  							

            EXT8S	%r0, 1
						
            IFRZ      %i2                 ; inverting
            BR        lpr2s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr2i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr2s
            NOP								
						
        lpr2i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr2s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr2e
            NOP						
	
            ; start averaging

            LD        %l7, [%l4]          ; save old value
            EXT8D     %l7, %l4            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr2a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr2e
            NOP	
						
        lpr2a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr2e:							
			SUB     %r0, %r4
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l4], %r0

            ; start mem 3								
            MOV     %r0, %l2  							

            EXT8S	%r0, 2
						
            IFRZ    %i2                 ; inverting
            BR      lpr3s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr3i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr3s
            NOP								
						
        lpr3i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr3s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr3e
            NOP						
	
            ; start averaging

            LD        %l7, [%l5]          ; save old value
            EXT8D     %l7, %l5            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr3a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr3e
            NOP	
						
        lpr3a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr3e:							
            SUB     %r0, %r5

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            FILL8	%r0, %r0
            ST8D	[%l5], %r0
						
            ; start mem 4								
            MOV		%r0, %l2  							

            EXT8S	%r0, 3
						
            IFRZ      %i2                 ; inverting
            BR        lpr4s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr4i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)	; (0) ???	
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr4s
            NOP								
						
        lpr4i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr4s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr4e
            NOP						
	
            ; start averaging

            LD        %l7, [%l6]          ; save old value
            EXT8D     %l7, %l6            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr4a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr4e
            NOP	
						
        lpr4a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr4e:							
			SUB     %r0, %r6
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)			
            			
            FILL8	%r0, %r0
            ST8D	[%l6], %r0


            ADDI   %l0, 4                            ; Add Address Counter

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow_ac             ; jump to slow address calculaten
            NOP
						
            ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter
            ADDI   %l4, 4                            ; Add Address Counter
            ADDI   %l5, 4                            ; Add Address Counter
            ADDI   %l6, 4                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP	

            BR     lprend
            NOP	


        lpr_slow_ac:
            ; calc new adresses
            ADDI   %i1, 1                            ; Add Address Counter
            ADDI   %l4, 1                            ; Add Address Counter
            ADDI   %l5, 1                            ; Add Address Counter
            ADDI   %l6, 1                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP

        lprend:					
							
    ");
}

void Hardware::READADC_ALL2(unsigned char which, unsigned long *DataArray1, unsigned int count)
{
    asm("
            CMPI    %i0, 0x01               ; Is it channel 1
            IFS     cc_z
            BR      lpr1ch1n
            NOP

            CMPI    %i0, 0x02               ; Is it channel 2
            IFS     cc_z
            BR      lpr1ch2n
            NOP

            CMPI    %i0, 0x03               ; Is it channel 3
            IFS     cc_z
            BR      lpr1ch3n
            NOP

            CMPI    %i0, 0x04               ; Is it channel 4
            IFS     cc_z
            BR      lpr1ch4n
            NOP

        lpr1ch1n:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI	%l0,%lo(0x00A00000)
            PFX		%xhi(0x00A00000)
            MOVHI	%l0,%xlo(0x00A00000)
            BR      lpr1n
            NOP

        lpr1ch2n:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI	%l0,%lo(0x00A00010)
            PFX		%xhi(0x00A00010)
            MOVHI	%l0,%xlo(0x00A00010)
            BR      lpr1n
            NOP

        lpr1ch3n:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI	%l0,%lo(0x00A00020)
            PFX		%xhi(0x00A00020)
            MOVHI	%l0,%xlo(0x00A00020)
            BR      lpr1n
            NOP

        lpr1ch4n:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI	%l0,%lo(0x00A00030)
            PFX		%xhi(0x00A00030)
            MOVHI	%l0,%xlo(0x00A00030)
                       						                       		
        lpr1n:
            LD		%l2, [%l0]
                       								
            MOV		%r0, %l2  	

            ST  	[%i1], %r0
						
            ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter
                        	
            SUBI   %i2, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1n	
            NOP

							
    ");
}

unsigned char Hardware::EXTRACTADCVAL(unsigned char which, unsigned long value)
{
	switch(which)
	{
		case 1 :
				asm("		
						MOV		%r0,%i1
						EXT8S	%r0,3
						MOV		%i0, %r0					
					");	
				break;
		case 2 :
				asm("		
						MOV		%r0,%i1
						EXT8S	%r0,2
						MOV		%i0, %r0						
					");	
				break;
		case 3 :
				asm("		
						MOV		%r0,%i1
						EXT8S	%r0,1
						MOV		%i0, %r0
					");	
				break;
		case 4 :
				asm("		
						MOV		%r0,%i1
						EXT8S	%r0,0
						MOV		%i0, %r0
					");	
				break;
	}												
}

void Hardware::DoEnableADCInterrupt(void)							// Enable ADC service routine
{
	acq_ready->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	acq_ready->np_piodirection = 0;									// set bit to input
	acq_ready->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_data_acq_interrupt_irq,ISR_ADC_INT,(int)acq_ready);		// Install ISR for ADC
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt enabled.\n"); 							// print on console
#endif
}

void Hardware::DoDisableADCInterrupt(void)							// Disable ADC service routine
{
	
	nr_installuserisr(na_data_acq_interrupt_irq,0,0); 				// Install empty routine for adc irq
	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt disabled.\n"); 							// print on console
#endif	
}

void Hardware::ISR_ADC_INT(int context)						// ADC interrupt subroutine
{
    long buffer;
    int ix2;

    tc_test_var2++;

    adc_started = false;

	acq_ready->np_pioedgecapture = 0;

    ADC_Data_Available = 1;
}

int Hardware::Read_IRQ(void)
{
    return acq_ready->np_piodata;
}

void Hardware::Handle_ADC(void)						// ADC interrupt subroutine
{
    int chk_calc = 0;
    unsigned char chk_sum = 0;
    unsigned long ldataa = 0;
    unsigned long lzeroa = 0;
    unsigned long ldiva = 0;
    unsigned long loffseta = 0;
    unsigned long ltempa = 0;
    unsigned long ldatab = 0;
    unsigned long lzerob = 0;
    unsigned long ldivb = 0;
    unsigned long loffsetb = 0;
    unsigned long ltempb = 0;
    unsigned long loffset = 0;
    unsigned long loffset_neg_tag = 0;
    unsigned long lprefix = 0;
    int bufdata = 0;
//out_test->np_piodata = 0x01;	// Testbit+++++++++++++++++++++++
	volatile long buffer_addr = 0;	
	volatile long buffer_peak = 0;	
	volatile long buffer_witten = 0;	
	volatile long buffer_long = 0;	
	volatile long buffer_adradd = 0;
	
	int channel_trig = 0;
	long ix, ix2, ix3, enddata = 0;

    //if (screen_sel != screen_sel_old) return;

	if (UserIface_active) return;
	
	
	if (ADC_Data_Available == 0) return;
    ADC_Data_Available = 0;
    
    if (Signal_Loaded) return;

    signal_zoomed1 = false;
    signal_zoomed2 = false;
    signal_zoomed3 = false;
    signal_zoomed4 = false;

	data_adr->np_piodata = 0x01;

    CH1_Zero_Offset = 0;
    CH2_Zero_Offset = 0;
    CH3_Zero_Offset = 0;
    CH4_Zero_Offset = 0;
//out_test->np_piodata = 0x00;	// Testbit+++++++++++++++++++++++		
	if ((Selected_Trigger_Source == 3) || (Selected_Trigger_Source == 4))	
	{
		buffer_addr = READADC(3);
		buffer_peak = READADC(3);
	}
	else
	{
		buffer_addr = READADC(1);
		buffer_peak = READADC(1);
	}
	
	AutoFreeRun = false;
	
#ifdef _Debug_	
	if ((Debug_Mode) && (ADC_Debug_Mode)) printf("Peak %x \n", buffer_peak);
#endif

    if ((buffer_addr & 0x00001000) == 0x00001000)
    {
        if ((buffer_addr & 0x00000FFF) == 0x00000000)
        {
            // buffer_witten = (buffer_addr & 0x00000FFF) + ((pre_reg - 8) >> 1);
            if (Selected_Timebase < 9) buffer_witten = (buffer_addr & 0x00000FFF) + ((pre_reg - 8) >> 1);
            else buffer_witten = (buffer_addr & 0x00000FFF) + ((pre_reg - 8));
        }
        else
        {
            //buffer_witten = pre_reg >> 1;
            if (Selected_Timebase < 9) buffer_witten = pre_reg >> 1;
            else buffer_witten = pre_reg;
        }

        AutoFreeRun = true;
        
        //printf("Auto Free Run   RA : %4x  RW : %4x\n", buffer_addr, buffer_witten);
    }
    else if (Selected_Timebase < 7) buffer_witten = ((buffer_addr & 0x0FFF) - (pre_reg >> 1)) & 0x00000FFF;
    else buffer_witten = ((buffer_addr & 0x0FFF) - pre_reg) & 0x00000FFF;
   	 	
   	channel_trig = (buffer_addr & 0xC000) >> 14;
#ifdef _Debug_   	
   	if (Debug_Mode) printf("ChannelTrig %d\n", channel_trig);
#endif   	

#ifdef _Debug_
    if ((Debug_Mode) && (ADC_Debug_Mode)) printf("RTA : %x  WTA : %x PreReg %x\n", buffer_addr, buffer_witten, pre_reg);
#endif

    if (triggering)
    {
        buffer_long1 = buffer_witten;
        buffer_long2 = buffer_witten;
        buffer_long3 = buffer_witten;
        buffer_long4 = buffer_witten;
        buffer_addi = buffer_addr;
    }
    else
    {
        buffer_long1 = 0;
        buffer_long2 = 0;
        buffer_long3 = 0;
        buffer_long4 = 0;
        buffer_addi = 0;
    }

    if (NumberOfChannels < 4)
    {				
		if ((triggering != 0) || (Selected_Trigger_Source == 5))
		{
            WRITEADC(1, buffer_witten);
            WRITEADC(2, buffer_witten);
#ifdef _Debug_
			if ((Debug_Mode) && (ADC_Debug_Mode)) printf("Wr Tr ADR %x \n", buffer_witten);
#endif			
		}   /*
		else if (MenuStatus[10][2] == 1) // Rollmode
		{
			WRITEADC(1, buffer_adradd);
			WRITEADC(2, buffer_adradd);		
		}     */
		else
		{
			WRITEADC(1, ram_adress_reg + buffer_adradd);
			WRITEADC(2, ram_adress_reg + buffer_adradd);
         //   printf("Write FreeRun Address 0x00 \n");
		}
    }
    else
    {				
		if ((triggering != 0) || (Selected_Trigger_Source == 5))
		{		
            WRITEADC(1, buffer_witten);
            WRITEADC(2, buffer_witten);
            WRITEADC(3, buffer_witten);
            WRITEADC(4, buffer_witten);
#ifdef _Debug_
			if ((Debug_Mode) && (ADC_Debug_Mode)) printf("Wr Tr ADR %x \n", buffer_witten);
#endif			
		}          /*
		else if (MenuStatus[10][2] == 1) // Rollmode
		{
			WRITEADC(1, buffer_adradd);
			WRITEADC(2, buffer_adradd);		
			WRITEADC(3, buffer_adradd);
			WRITEADC(4, buffer_adradd);					
		}		     */
		else
		{
			WRITEADC(1, ram_adress_reg + buffer_adradd);
			WRITEADC(2, ram_adress_reg + buffer_adradd);
			WRITEADC(3, ram_adress_reg + buffer_adradd);
			WRITEADC(4, ram_adress_reg + buffer_adradd);
		//	printf("Write FreeRun Address 0x00 \n");
		}
    }
	
	data_adr->np_piodata = 0x00;
	
	
	if (Channel_1_Active == 1)
	{	
        ReadOut_Signal(1, buffer_addr & 0x3FFF, buffer_long1);
        ///if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate[0]);
        ///if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate_delayed[0]);

        //if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1[0]);
	}
	
	if (Channel_2_Active == 1)
	{	
        ReadOut_Signal(2, buffer_addr & 0x3FFF, buffer_long2);
        ///if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2_Intpolate[0]);

        //if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2[0]);
	}	
	
	if (NumberOfChannels > 2)
	{	
        if (Channel_3_Active == 1)
        {	
            ReadOut_Signal(3, buffer_addr & 0x3FFF, buffer_long3);
            //if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL3[0], &SIGNAL3_Intpolate[0]);
        }         	
	
	    if (Channel_4_Active == 1)
	    {		   	
            ReadOut_Signal(4, buffer_addr & 0x3FFF, buffer_long4);
            //if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc, &SIGNAL_IntBuf[0], &SIGNAL4[0], &SIGNAL4_Intpolate[0]);
        }
	}	

	if (Channel_Math_Active == 1)
	{
        // offset fehlt
        // loffsetb 0 = 24 1 = 24000 2 = 24000000 3 = 24000000000

        if (MenuStatus[26][2] == 1)
        {
            if (Math_Off_Mul_Value < 0)
            {
                loffseta = abs((int) Math_Off_Mul_Value);
                loffset_neg_tag = 1;
            }
            else loffseta = (int)  Math_Off_Mul_Value;

            if (Math_Off_Mul_Expo == 0) loffsetb = 2;
            else if (Math_Off_Mul_Expo == 1) loffsetb = 3;
            else if (Math_Off_Mul_Expo == 2) loffsetb = 4;
            else if (Math_Off_Mul_Expo == -1) loffsetb = 3;
            else if (Math_Off_Mul_Expo == -2) loffsetb = 4;

//            if (Debug_Mode) printf("Val : %f Expo %d\n", Math_Off_Mul_Value, Math_Off_Mul_Expo);
        }
        else if (MenuStatus[26][3] == 1)
        {
            if (Math_Off_Sub_Value < 0)
            {
                loffseta = abs((int) Math_Off_Sub_Value);
                loffset_neg_tag = 1;
            }
            else loffseta = (int) Math_Off_Sub_Value;

            if (Math_Off_Sub_Expo == 0) loffsetb = 0;
            else if (Math_Off_Sub_Expo == 1) loffsetb = 1;
            else if (Math_Off_Sub_Expo == -1) loffsetb = 1;

//            if (Debug_Mode) printf("Val : %f Expo %d\n", Math_Off_Sub_Value, Math_Off_Sub_Expo);
        }
        else if (MenuStatus[26][4] == 1)
        {
            if (Math_Off_Add_Value < 0)
            {
                loffseta = abs((int) Math_Off_Add_Value);
                loffset_neg_tag = 1;
            }
            else loffseta = (int) Math_Off_Add_Value;

            if (Math_Off_Add_Expo == 0) loffsetb = 0;
            else if (Math_Off_Add_Expo == 1) loffsetb = 1;
            else if (Math_Off_Add_Expo == -1) loffsetb = 1;

//            if (Debug_Mode) printf("Val : %f Expo %d\n", Math_Off_Add_Value, Math_Off_Add_Expo);
        }
        else
        {
            loffseta = 1;
            loffsetb = 0;
        }

        lzeroa = ((ZeroLevelCH1 + 59) >> 1) << 8;
        ldiva = voltage_relevat[MenuStatus[1][3] - 104][Selected_Voltage_CH1 - 3] << 16;

        ltempa = lzeroa | ldiva | (loffseta << 21);

        lzerob = ((ZeroLevelCH2 + 59) >> 1) << 8;
        ldivb = voltage_relevat[MenuStatus[2][3] - 104][Selected_Voltage_CH2 - 3] << 16;

        ltempb = lzerob | ldivb | (loffsetb << 21);

        if (loffset_neg_tag == false) ltempb = ltempb | 0x80000000;

        if (Debug_Mode) printf("tempa : %8x tempb %8x\n", ltempa, ltempb);
  	
        if ((MenuStatus[26][1] == 1) && ((Channel_1_Active) || (Channel_2_Active)))                 // fft
        {
		//BF change activate FFT           
 		if (UserIface_active_2 == false)
                  Do_FFT();
                 // return;
		//BF change end
        }	
        else if ((MenuStatus[26][2] == 1) && ((Channel_1_Active) && (Channel_2_Active)))           // multiply
        {
            if (math_mul_scale == 166)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x020D, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 167)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x020E, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 168)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x020F, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 169)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0210, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 170)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0211, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 171)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0212, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 172)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0213, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 173)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0214, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 174)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0215, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 175)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0216, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 176)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0217, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 177)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0218, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 178)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0219, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 179)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x021A, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 180)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x021B, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_mul_scale == 181)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x021C, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
        }
        else if ((MenuStatus[26][3] == 1) && ((Channel_1_Active) && (Channel_2_Active)))            // subtract
        {
            if (math_sub_scale == 153)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0000, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 154)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0001, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 155)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0002, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 156)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0003, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 157)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0004, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 158)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0005, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 159)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0006, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 160)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0007, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 161)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0008, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 162)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0009, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 163)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x000A, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 164)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x000B, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_sub_scale == 165)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x000C, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
        }
        else if ((MenuStatus[26][4] == 1) && ((Channel_1_Active) && (Channel_2_Active)))            // add
        {
            if (math_add_scale == 153)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0400, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 154)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0401, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 155)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0402, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 156)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0403, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 157)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0404, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 158)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0405, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 159)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0406, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 160)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0407, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 161)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0408, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 162)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x0409, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 163)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x040A, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 164)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x040B, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
            else if (math_add_scale == 165)
            {
                for (ix2 = 10; ix2 < 16384; ix2++)
                {
                    bufdata = nm_math_pfx(0x040C, ltempa | SIGNAL1[ix2], ltempb | SIGNAL2[ix2 + 10]);
                    if ((bufdata & 0xF00) == 0x300) bufdata = 0;
                    else if ((bufdata & 0xF00) == 0xA00) bufdata = 255;
                    SIGNALM[ix2] = (bufdata & 0xFF);
                }
            }
        }      /*
        else if (MenuStatus[26][5] == 1)            // free
        {
            for (ix2 = 0; ix2 < 16384; ix2++)
            {
                SIGNALM[ix2] = (unsigned char) ((int) 127 + (((int) SIGNAL1[ix2] - ((ZeroLevelCH1 + (int) 60) >> 1)) - ((int) SIGNAL2[ix2] - ((ZeroLevelCH2 + (int) 60) >> 1))));
            }
        }    */
    }
    


    //if ((Selected_Timebase < 7) && ((Selected_Trigger_Source > 0) && (Selected_Trigger_Source < 5)) && (MenuStatus[10][2] == 0) && (AutoFreeRun == false))
    if ((Selected_Timebase < 7) && ((Selected_Trigger_Source > 0) && (Selected_Trigger_Source < 5)) && (AutoFreeRun == false))
    {
        //Trigger_Offset_Calc = 30 - ((Trigger_Offset_Pos + 30) - FindTrigger(Selected_Trigger_Source, MenuStatus[14][0] - 2, Trigger_Offset_Pos + 30));
        //Trigger_Offset_Calc = 5 - (((int)((float) Trig_Pos_Mem / ZFT_float) + 50) - FindTrigger(Selected_Trigger_Source, MenuStatus[14][0] - 2, (int)((float) Trig_Pos_Mem / ZFT_float) + 50));

        Trigger_Offset_Calc = 15 - ((Trig_Pos_Mem + 50) - FindTrigger(Selected_Trigger_Source, MenuStatus[14][0] - 2, Trig_Pos_Mem + 50));
    }
    else  Trigger_Offset_Calc = -15;

    //printf("TOC %d\n", Trigger_Offset_Calc);

    if (triggering == 0) Trigger_Offset_Calc = 0;

	if (Channel_1_Active == 1)
	{	
		if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc + CH1OffsetX, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate[0]);
		if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc + CH1OffsetX, &SIGNAL_IntBuf[0], &SIGNAL1[0], &SIGNAL1_Intpolate_delayed[0]);
	}
	
	if (Channel_2_Active == 1)
	{	
		if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc + CH2OffsetX, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2_Intpolate[0]);
		if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc + CH2OffsetX, &SIGNAL_IntBuf[0], &SIGNAL2[0], &SIGNAL2_Intpolate_delayed[0]);
	}	
	//4-Channel Version
	if (NumberOfChannels > 2)
	{	
		if (Channel_3_Active == 1)
		{	
			if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc + CH3OffsetX, &SIGNAL_IntBuf[0], &SIGNAL3[0], &SIGNAL3_Intpolate[0]);
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc + CH3OffsetX, &SIGNAL_IntBuf[0], &SIGNAL3[0], &SIGNAL3_Intpolate_delayed[0]);
		}         	
		
		if (Channel_4_Active == 1)
		{		   	
			if (Selected_Timebase < 4) Display::PreInterpolate(Selected_Timebase, FirStartCH + Trigger_Offset_Calc + CH4OffsetX, &SIGNAL_IntBuf[0], &SIGNAL4[0], &SIGNAL4_Intpolate[0]);
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) Display::PreInterpolate(dmode_Selected_Timebase, FirStartCH_delayed + Trigger_Offset_Calc + CH4OffsetX, &SIGNAL_IntBuf[0], &SIGNAL4[0], &SIGNAL4_Intpolate_delayed[0]);
		}
	}	



	// Submit Data to USB Client
	if (USB_Data_Requested) enddata = 511;
	else enddata = 75;

    if (USB_Data_Trans)
    {
	   if (USB_SendAllData) enddata = 511;
	   else enddata = 75;
	
	   USB_Data_Requested = true;
    }
	
	if ((USB_Data_Requested) && (Transfer_man_data))
	{
        //printf("ba : %x bp : %x bw : %x\n", buffer_addr, buffer_peak, buffer_witten);		
		
		

		
	
		if ((Channel_1_Active == 1) && (USB_OnlyTrigger == false))
		{

			send_buffer[0] = 101;								// Kennung Data
			//send_buffer[1] = 1;									// Kennung Channel
			
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                chk_calc = 0;
                
                for (ix = 0; ix < 32; ix++)
                {	
                	chk_calc += SIGNAL1[(ix2 * 32) + ix];
                	send_buffer[3 + ix] = SIGNAL1[(ix2 * 32) + ix];
				}
                
				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
				SendData(send_buffer);
				
				//printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
				nr_delay(10);
			}	
		}
		
		if ((Channel_2_Active == 1) && (USB_OnlyTrigger == false))
		{
			send_buffer[0] = 102;								// Kennung Data
			//send_buffer[1] = 2;									// Kennung Channel
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
				
				chk_calc = 0;
				
                for (ix = 0; ix < 32; ix++)
                {	
                	chk_calc += SIGNAL2[(ix2 * 32) + ix];
                	send_buffer[3 + ix] = SIGNAL2[(ix2 * 32) + ix];
				}              

				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
				
				SendData(send_buffer);
				nr_delay(10);
			}	
		}
		
		if (NumberOfChannels > 2)
		{
			if ((Channel_3_Active == 1) && (USB_OnlyTrigger == false))
			{
				send_buffer[0] = 103;								// Kennung Data
				//send_buffer[1] = 3;									// Kennung Channel
				
                for (ix2 = 0; ix2 <= enddata; ix2++)
                {
                    ix3 = ix2 * 32;

				    send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				    send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
				
				    chk_calc = 0;
                    for (ix = 0; ix < 32; ix++)
                    {	
                        chk_calc += SIGNAL3[(ix2 * 32) + ix];
                        send_buffer[3 + ix] = SIGNAL3[(ix2 * 32) + ix];
				    }	
				
				    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));				
				
				    SendData(send_buffer);
				    nr_delay(10);
                }
			}
			
			if ((Channel_4_Active == 1) && (USB_OnlyTrigger == false))
			{		
				send_buffer[0] = 104;								// Kennung Data
				//send_buffer[1] = 4;									// Kennung Channel
				
                for (ix2 = 0; ix2 <= enddata; ix2++)
                {
                    ix3 = ix2 * 32;

				    send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				    send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
				
				    chk_calc = 0;
                    for (ix = 0; ix < 32; ix++)
                    {	
                        chk_calc += SIGNAL4[(ix2 * 32) + ix];
                        send_buffer[3 + ix] = SIGNAL4[(ix2 * 32) + ix];
				    }	
				
				    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                    				
				    SendData(send_buffer);
				    nr_delay(10);
                }
			}		
			
	
		}

		
		if ((Channel_Math_Active == 1) && (USB_OnlyTrigger == false))
		{

			send_buffer[0] = 105;								// Kennung Data
			//send_buffer[1] = 1;									// Kennung Channel
			
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                chk_calc = 0;	
                for (ix = 0; ix < 32; ix++)
                {	
                    chk_calc += SIGNALM[(ix2 * 32) + ix];
                    send_buffer[3 + ix] = SIGNALM[(ix2 * 32) + ix];
				}	
				
				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
				SendData(send_buffer);
				
				//printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
				nr_delay(10);
			}	
		}
		
		send_buffer[0] = 100;								// Kennung Data
//		send_buffer[1] = 0;									// Kennung Datablock

		send_buffer[2] = (unsigned char) (buffer_addr & 0x000000FF);
		send_buffer[3] = (unsigned char) ((buffer_addr & 0x0000FF00) >> 8);
        send_buffer[4] = (unsigned char) ((buffer_addr & 0x00FF0000) >> 16);
        send_buffer[5] = (unsigned char) ((buffer_addr & 0xFF000000) >> 24);

		send_buffer[6] = (unsigned char) (buffer_peak & 0x000000FF);
		send_buffer[7] = (unsigned char) ((buffer_peak & 0x0000FF00) >> 8);
        send_buffer[8] = (unsigned char) ((buffer_peak & 0x00FF0000) >> 16);
        send_buffer[9] = (unsigned char) ((buffer_peak & 0xFF000000) >> 24);

		send_buffer[10] = (unsigned char) (buffer_witten & 0x000000FF);
		send_buffer[11] = (unsigned char) ((buffer_witten & 0x0000FF00) >> 8);
        send_buffer[12] = (unsigned char) ((buffer_witten & 0x00FF0000) >> 16);
        send_buffer[13] = (unsigned char) ((buffer_witten & 0xFF000000) >> 24);
        send_buffer[14] = (unsigned char) Selected_Timebase;
        send_buffer[15] = (unsigned char) SIGNALFaktor_idx;
		
        chk_calc = 0;	
        for (ix = 0; ix < 32; ix++)
        {	
            chk_calc += send_buffer[3 + ix];
        }	
				
        send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
        send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));		
		
		SendData(send_buffer);
		nr_delay(10);		
        		
		if (USB_OnlyTrigger == false)
		{
            SendCtrlBlock();
            nr_delay(50);			
            SendCtrlBlock3();		
            nr_delay(50);	
            SendCtrlBlock2();		
            nr_delay(50);
        }

        //if (MenuStatus[17][2] == 144) MenuStatus[17][2] = 143;	
        //Menu_Changed = 1;		

//		reset_watchdog->np_piodata = 0x01;							// Enable WatchDog
		
		USB_Data_Requested = false;
	}
    	

	if (SingleMode == 1)
	{
	    Single_Restart = 0;

		// Run/Stop LED red
		LED_ON[12] = 0;
		LED_ON[13] = 1;			
        	
		// Single Mode LED green
		LED_ON[14] = 0;
		LED_ON[15] = 0;				
		Send_LED();		
	}

	
//    if ((QM_Enabled) && (QM_Type[0] > 0)) Display::CALCQMDATA();	
	

#ifdef _Debug_	
	if ((ADC_Debug_Mode) && (Debug_Mode)) printf("ADC IRQ handled %d\n", triggering);
#endif
//    if ((SingleMode == false) && (Continius) && (OneShotRestart == false) && (UserIface_active == false)) Start_Record();

	if ((Search_Hidden == 0) && (Search_Mode)) DrawSignals_Needed = 0;
	else
    {
        //if (MenuStatus[10][2] == 0)
        {
            DrawSignals_Needed = 1;
        } /*
        else
        {
            ROLLMODE_BUFFVALUE_CH1 = SIGNAL1[200];
            ROLLMODE_BUFFVALUE_CH2 = SIGNAL2[200];
            ROLLMODE_BUFFVALUE_CH3 = SIGNAL3[200];
            ROLLMODE_BUFFVALUE_CH4 = SIGNAL4[200];
            ROLLMODE_BUFFVALUE_CHM = SIGNALM[200];
            ROLLMODE_Value_rec = true;

            Start_Record();
        }   */
    }

    if (Search_Mode)
    {
        Search_Step++;
        DrawSignals_Needed = 1;	
        //Start_Record();
    }
    
    if (Search_Step == 40) Search_Step = 99;
    //Search_Step = 0;           		
    //Search_Mode = true;
    /*
    if (Search_Step == 4)
    {
        if ((Search_Mode) || (Search_Auto)) Search_Step = 5;	
    }
    */


}

void Hardware::ReadOut_Signal(char channel, unsigned long adr_read, unsigned long adr_written)
{
    int ix, ix2, ix3, enddata;
    int chk_calc = 0;
    int buffer_int = 0;
	long buffer_long = 0;
	unsigned char buffer_byte1 = 0;
	unsigned char buffer_byte2 = 0;
	unsigned char buffer_byte3 = 0;	
	unsigned char buffer_byte4 = 0;	
	
	float interpolation_steps = 0;
	unsigned char interpolation_cnt = 2;
	
	unsigned int interpolation_start = 0;
	unsigned int interpolation_1 = 0;
	unsigned int interpolation_2 = 0;
	unsigned int interpolation_3 = 0;
	unsigned int interpolation_int = 0;
	
	float interpolation_start_float = 0;
	float interpolation_start_div = 0;
	
	unsigned int read_out_count = 0x1000;

	//if (MenuStatus[10][2] == 1) read_out_count = 0x100;
               	
	switch(channel)
	{	
        case 1 :
        {
            buffer_long = READADC(1);    // Read correction
            buffer_long = READADC(1);

            READADC_ALL2(1, &readout_sigbuf[0], read_out_count);
               	   	
            // Get new Signal Data
            if (Selected_Timebase < 7)
            {
                PREPARE_READADC(Voltage_Offset[0][0], Voltage_Offset[0][1],Voltage_Offset[0][2], Voltage_Offset[0][3], read_out_count);

                tc_test_var2 = 0;

                if (MenuStatus[0][1] == 1) READADC_ALL(1, &SIGNAL1[0], MenuStatus[1][2] - 240, (ZeroLevelCH1 + 64) >> 1, 1, 1);
                else READADC_ALL(1, &SIGNAL1[0], MenuStatus[1][2] - 240, (ZeroLevelCH1 + 64) >> 1, 0, 1);

//                printf("TC: %d\n", tc_test_var2);

            }
            else
            {

                PREPARE_READADC(Voltage_Offset[0][0], Voltage_Offset[0][1],Voltage_Offset[0][2], Voltage_Offset[0][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(1, &SIGNAL1[0], MenuStatus[1][2] - 240, (ZeroLevelCH1 + 64) >> 1, 1, 0);
                else READADC_ALL(1, &SIGNAL1[0], MenuStatus[1][2] - 240, (ZeroLevelCH1 + 64) >> 1, 0, 0);

            }
                 
            if (((USB_Data_Requested) || (USB_Data_Trans)) && (Transfer_man_data == false))
            {
                // Submit Data to USB Client
                if (USB_Data_Requested) enddata = 511;
                else enddata = 75;

                if (USB_Data_Trans)
                {
                    if (USB_SendAllData) enddata = 511;
                    else enddata = 75;
	
                    USB_Data_Requested = true;
                }

                if (USB_OnlyTrigger == false)
                {

                    send_buffer[0] = 100 + channel;								// Kennung Data	
			
                    for (ix2 = 0; ix2 <= enddata; ix2++)
                    {
                        ix3 = ix2 * 32;

                        send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
                        send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                        chk_calc = 0;	
                        for (ix = 0; ix < 32; ix++)
                        {	
                            chk_calc += readout_sigbuf_char[(ix2 * 32) + ix];
                            send_buffer[3 + ix] = readout_sigbuf_char[(ix2 * 32) + ix];
                        }	
				
                        send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
                        send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
                        SendData(send_buffer);
				
                        //printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
                        nr_delay(10);
                    }
                }	
            }    

            break;
        }

        case 2 :
        {
            buffer_long = READADC(2);    // Read correction
            buffer_long = READADC(2);
               	
            READADC_ALL2(2, &readout_sigbuf[0], read_out_count);                      	
			                         	   	
            // Get new Signal Data
            if (Selected_Timebase < 7)
            {
                PREPARE_READADC(Voltage_Offset[1][0], Voltage_Offset[1][1],Voltage_Offset[1][2], Voltage_Offset[1][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(2, &SIGNAL2[0], MenuStatus[2][2] - 240, (ZeroLevelCH2 + 64) >> 1, 1, 1);
                else READADC_ALL(2, &SIGNAL2[0], MenuStatus[2][2] - 240, (ZeroLevelCH2 + 64) >> 1, 0, 1);

            }
            else
            {
                PREPARE_READADC(Voltage_Offset[1][0], Voltage_Offset[1][1],Voltage_Offset[1][2], Voltage_Offset[1][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(2, &SIGNAL2[0], MenuStatus[2][2] - 240, (ZeroLevelCH2 + 64) >> 1, 1, 0);
                else READADC_ALL(2, &SIGNAL2[0], MenuStatus[2][2] - 240, (ZeroLevelCH2 + 64) >> 1, 0, 0);

            }
               
            if (((USB_Data_Requested) || (USB_Data_Trans)) && (Transfer_man_data == false))
            {
                // Submit Data to USB Client
                if (USB_Data_Requested) enddata = 511;
                else enddata = 75;

                if (USB_Data_Trans)
                {
                    if (USB_SendAllData) enddata = 511;
                    else enddata = 75;
	
                    USB_Data_Requested = true;
                }

                if (USB_OnlyTrigger == false)
                {

                    send_buffer[0] = 100 + channel;								// Kennung Data	
			
                    for (ix2 = 0; ix2 <= enddata; ix2++)
                    {
                        ix3 = ix2 * 32;

                        send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
                        send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                        chk_calc = 0;	
                        for (ix = 0; ix < 32; ix++)
                        {	
                            chk_calc += readout_sigbuf_char[(ix2 * 32) + ix];
                            send_buffer[3 + ix] = readout_sigbuf_char[(ix2 * 32) + ix];
                        }	
				
                        send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
                        send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
                        SendData(send_buffer);
				
                        //printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
                        nr_delay(10);
                    }
                }	
            }
            

            break;
        }

        case 3 :
        {
            buffer_long = READADC(3);    // Read correction
            buffer_long = READADC(3);
            buffer_long = READADC(3);    // Read correction
             
            READADC_ALL2(3, &readout_sigbuf[0], read_out_count);
				
            if (((USB_Data_Requested) || (USB_Data_Trans)) && (Transfer_man_data == false))
            {
                // Submit Data to USB Client
                if (USB_Data_Requested) enddata = 511;
                else enddata = 75;

                if (USB_Data_Trans)
                {
                    if (USB_SendAllData) enddata = 511;
                    else enddata = 75;
	
                    USB_Data_Requested = true;
                }

                if (USB_OnlyTrigger == false)
                {

                    send_buffer[0] = 100 + channel;								// Kennung Data	
			
                    for (ix2 = 0; ix2 <= enddata; ix2++)
                    {
                        ix3 = ix2 * 32;

                        send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
                        send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                        chk_calc = 0;	
                        for (ix = 0; ix < 32; ix++)
                        {	
                            chk_calc += readout_sigbuf_char[(ix2 * 32) + ix];
                            send_buffer[3 + ix] = readout_sigbuf_char[(ix2 * 32) + ix];
                        }	
				
                        send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
                        send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
                        SendData(send_buffer);
				
                        //printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
                        nr_delay(10);
                    }
                }	
            }
                                  	
            // Get new Signal Data
            if (Selected_Timebase < 7)
            {
                PREPARE_READADC(Voltage_Offset[2][0], Voltage_Offset[2][1],Voltage_Offset[2][2], Voltage_Offset[2][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(3, &SIGNAL3[0], MenuStatus[3][2] - 240, (ZeroLevelCH3 + 64) >> 1, 1, 1);
                else READADC_ALL(3, &SIGNAL3[0], MenuStatus[3][2] - 240, (ZeroLevelCH3 + 64) >> 1, 0, 1);

            }
            else
            {
                PREPARE_READADC(Voltage_Offset[2][0], Voltage_Offset[2][1],Voltage_Offset[2][2], Voltage_Offset[2][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(3, &SIGNAL3[0], MenuStatus[3][2] - 240, (ZeroLevelCH3 + 64) >> 1, 1, 0);
                else READADC_ALL(3, &SIGNAL3[0], MenuStatus[3][2] - 240, (ZeroLevelCH3 + 64) >> 1, 0, 0);

            }

            break;
        }
        case 4 :
        {
            buffer_long = READADC(4);    // Read correction
            buffer_long = READADC(4);
            buffer_long = READADC(4);
            
            READADC_ALL2(4, &readout_sigbuf[0], read_out_count);
			
            if (((USB_Data_Requested) || (USB_Data_Trans)) && (Transfer_man_data == false))
            {
                // Submit Data to USB Client
                if (USB_Data_Requested) enddata = 511;
                else enddata = 75;

                if (USB_Data_Trans)
                {
                    if (USB_SendAllData) enddata = 511;
                    else enddata = 75;
	
                    USB_Data_Requested = true;
                }

                if (USB_OnlyTrigger == false)
                {

                    send_buffer[0] = 100 + channel;								// Kennung Data	
			
                    for (ix2 = 0; ix2 <= enddata; ix2++)
                    {
                        ix3 = ix2 * 32;

                        send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
                        send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
                        chk_calc = 0;	
                        for (ix = 0; ix < 32; ix++)
                        {	
                            chk_calc += readout_sigbuf_char[(ix2 * 32) + ix];
                            send_buffer[3 + ix] = readout_sigbuf_char[(ix2 * 32) + ix];
                        }	
				
                        send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
                        send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
                        SendData(send_buffer);
				
                        //printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
                        nr_delay(10);
                    }
                }	
            }
                                           	   	
            // Get new Signal Data
            if (Selected_Timebase < 7)
            {
                PREPARE_READADC(Voltage_Offset[3][0], Voltage_Offset[3][1],Voltage_Offset[3][2], Voltage_Offset[3][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(4, &SIGNAL4[0], MenuStatus[4][2] - 240, (ZeroLevelCH4 + 64) >> 1, 1, 1);
                else READADC_ALL(4, &SIGNAL4[0], MenuStatus[4][2] - 240, (ZeroLevelCH4 + 64) >> 1, 0, 1);

            }
            else
            {
                PREPARE_READADC(Voltage_Offset[3][0], Voltage_Offset[3][1], Voltage_Offset[3][2], Voltage_Offset[3][3], read_out_count);

                if (MenuStatus[0][1] == 1) READADC_ALL(4, &SIGNAL4[0], MenuStatus[4][2] - 240, (ZeroLevelCH4 + 64) >> 1, 1, 0);
                else READADC_ALL(4, &SIGNAL4[0], MenuStatus[4][2] - 240, (ZeroLevelCH4 + 64) >> 1, 0, 0);
            }

            break;
        }                                                    	
	}

}


void Hardware::Do_Gen_Signal(void)	
{
    float wert;
    float grad;
    int icnt;

#ifdef _Debug_FFT_
    printf("starting generate signal\n");
#endif
    for(icnt = 0; icnt <= FFT_LENGTH; icnt++)
    {
        grad = (float) (icnt);
        
        if (((int)(grad * 0.015625) %2) == 0) wert = -1.0; // 0.03125
        else wert = 1.0;
               
	//BF change ->reactivated
        fft_values[icnt] = wert;
        //BF change end
        SIGNAL1[icnt] = ((unsigned char) ((wert * 30) + 128));
       // printf( "%d\n", (int) wert );
    }
#ifdef _Debug_FFT_
    printf("generate signal ready\n");
#endif
}

            /*
void Hardware::FFT2_init(void)
{
}

void Hardware::FFT2_do_fft(void)
{
}

void Hardware::FFT2_do_ifft(void)
{
}

void Hardware::FFT2_rescale(void)
{
}

bool Hardware::FFT2_is_pow2(long x)
{
    assert(x > 0);
    
    return ((x & -x) == x);
}

int Hardware::FFT2_get_next_pow2(long x)
{
    int p = 0;
    
    --x;

    while ((x & ~0xFFFFL) != 0)
    {
        p += 16;
        x >>= 16;
    }
    while ((x & ~0xFL) != 0)
    {
        p += 4;
        x >>= 4;
    }
    while (x > 0)
    {
        ++p;
        x >>= 1;
    }
    
    return(p);
}
   */
	
int Hardware::FindTrigger(unsigned char channel, unsigned char negativ, int TriggerPos)
{
    int ix, foundat = 0, range = 50;
    int tl_buf = 0;

    unsigned char neg_buf = negativ;
    
    // if channel inverted
    if (MenuStatus[channel][2] == 241)
    {
        if (negativ) negativ = 0;
        else negativ = 1;
    }

    switch(channel)
    {
        case 1 : tl_buf = (Trigger_Pos_CH1 + 64) >> 1; break;
        case 2 : tl_buf = (Trigger_Pos_CH2 + 64) >> 1; break;
        case 3 : tl_buf = (Trigger_Pos_CH3 + 64) >> 1; break;
        case 4 : tl_buf = (Trigger_Pos_CH4 + 64) >> 1; break;
    }

    if (negativ)
    {
        switch(channel)
        {
            case 1 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL1[ix] > tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 2 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL2[ix] > tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 3 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL3[ix] > tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 4 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL4[ix] > tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
        }
    }
    else
    {
        switch(channel)
        {
            case 1 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL1[ix] < tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 2 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL2[ix] < tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 3 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL3[ix] < tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
            case 4 :
            {
                foundat = TriggerPos;
                for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
                {
                    if (SIGNAL4[ix] < tl_buf)
                    {
                        foundat = ix;
                        break;
                    }
                }
                break;
            }
        }
    }

    return foundat;
}


//Auto scale
int Hardware::AutoScale(void)
{
    int result = 0;

    triggering_bak   = triggering;
    ctrl_reg_bak     = ctrl_reg;
    adc_ctrl_reg_bak = adc_ctrl_reg;

    Channel_1_Active_bak = Channel_1_Active;
    Channel_2_Active_bak = Channel_2_Active;
    Channel_3_Active_bak = Channel_3_Active;
    Channel_4_Active_bak = Channel_4_Active;

    Selected_Timebase_bak  = Selected_Timebase;
    SIGNALFaktor_idx_bak   = SIGNALFaktor_idx;
    SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
    timebase_reg_bak       = timebase_reg;
    Display_Timebase_bak   = Display_Timebase;
    Continius_bak          = Continius;
    SingleMode_bak         = SingleMode;

    Selected_Voltage_CH1_bak = Selected_Voltage_CH1;
    Selected_Voltage_CH2_bak = Selected_Voltage_CH2;
    Selected_Voltage_CH3_bak = Selected_Voltage_CH3;
    Selected_Voltage_CH4_bak = Selected_Voltage_CH4;   	

    ZeroLevelCH1_bak = ZeroLevelCH1;
    ZeroLevelCH2_bak = ZeroLevelCH2;
    ZeroLevelCH3_bak = ZeroLevelCH3;
    ZeroLevelCH4_bak = ZeroLevelCH4;

    Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
    Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
    Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
    Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;

    Trigger_Pos_CH1_bak = Trigger_Pos_CH1;	
    Trigger_Pos_CH2_bak = Trigger_Pos_CH2;
    Trigger_Pos_CH3_bak = Trigger_Pos_CH3;
    Trigger_Pos_CH4_bak = Trigger_Pos_CH4;

    Timebase_Offset_Pos_bak = Timebase_Offset_Pos;
    Trigger_Offset_Pos_bak  = Trigger_Offset_Pos;

    AC_CH1_bak = MenuStatus[1][0];
    AC_CH2_bak = MenuStatus[2][0];
    AC_CH3_bak = MenuStatus[3][0];
    AC_CH4_bak = MenuStatus[4][0];
    
    Invert_CH1_bak = MenuStatus[1][2];
    Invert_CH2_bak = MenuStatus[2][2];
    Invert_CH3_bak = MenuStatus[3][2];
    Invert_CH4_bak = MenuStatus[4][2];

    MAINMODE_bak = MenuStatus[10][0];
    //ROLLMODE_bak = MenuStatus[10][2];
    ROLLMODESTARTED_bak = ROLLMODE_STARTED;

    Acquire_bak_0 = MenuStatus[0][0];
    Acquire_bak_1 = MenuStatus[0][1];
    
    AUTOMODE_bak = MenuStatus[12][0];
			
    Stop_Record();			
    AutoTimerOff = true;
    Search_Mode  = true;

    DoDisableUARTInterrupt();
    DoDisableADCInterrupt();
    DoDisableKeyInterrupt();
    DoDisableRotInterrupt();

    ADC_Data_Available = 0;
	acq_ready->np_pioedgecapture = 0;
	
    MenuStatus[12][0] = 93;
    MenuPopupStatus[9][0] = 3;
    MenuPopupStatus[9][1] = 2;

    // Averaging off			
    MenuStatus[0][1] = 0;
    MenuStatus[0][0] = 1;
			

    // All AC
    MenuStatus[1][0] = 7;
    MenuStatus[2][0] = 7;
    MenuStatus[3][0] = 7;
    MenuStatus[4][0] = 7;
    
    // All invert off
    MenuStatus[1][2] = 240;
    MenuStatus[2][2] = 240;
    MenuStatus[3][2] = 240;
    MenuStatus[4][2] = 240;



    Selected_Timebase  = 4;                                         //  50 nS
    SIGNALFaktor_idx   = 0;                                         // zoom factor 1 = 50 nS
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = tb_value[Selected_Timebase];
    Display_Timebase = 4;                                          // Displayed timebase is 50 ns

    triggering    = 0;								
    ctrl_reg      = 0x0087;							            // Trigger_Master / Trigger_INT / Free Run
    adc_ctrl_reg &= 0xFFF0;						                    // Disable Trigger sources

    pre_reg = 0x006C;
    Trigger_Offset_Pos  = 353;
    Timebase_Offset_Pos = -300;
    
  // TMW complete changed (2-Channel Version)

    Virtual_ZeroLevelCH1 = 0;
    CH1_Zero_Offset      = 0;

    Virtual_ZeroLevelCH2 = 0;
    CH2_Zero_Offset      = 0;

    Rotary_Steps = 0;
    ON_Zero_Channel_1();
    Rotary_Steps = 0;
    ON_Zero_Channel_2();
	
  	if ( NumberOfChannels == 4) // TMW complete changed (4-Channel Version)
 	{
		Virtual_ZeroLevelCH3 = 0;
    		CH3_Zero_Offset      = 0;
    		Virtual_ZeroLevelCH4 = 0;
    		CH4_Zero_Offset      = 0;

    		Rotary_Steps = 0;
    		ON_Zero_Channel_3();
    		Rotary_Steps = 0;
    		ON_Zero_Channel_4();
	}
 
    Trigger_Pos_CH1 = ZeroLevelCH1;
    Trigger_Pos_CH2 = ZeroLevelCH2;
    Trigger_Pos_CH3 = ZeroLevelCH3;
    Trigger_Pos_CH4 = ZeroLevelCH4;

    if (Channel_1_Active) result = FindTimebase(1);
    else if (Channel_2_Active) result = FindTimebase(2);
    else if (Channel_3_Active) result = FindTimebase(3);
    else if (Channel_4_Active) result = FindTimebase(4);

  // TMW complete changed (2-Channel Version)

    Virtual_ZeroLevelCH1 = 0;                                
    CH1_Zero_Offset      = 0;                                     

    Virtual_ZeroLevelCH2 = 0;                                
    CH2_Zero_Offset      = 0;                                       

    Rotary_Steps = 0;
    ON_Zero_Channel_1();
    Rotary_Steps = 0;
    ON_Zero_Channel_2();
	
  	if ( NumberOfChannels == 4) // TMW complete changed (4-Channel Version)
 	{
		Virtual_ZeroLevelCH3 = 0;                                
		CH3_Zero_Offset      = 0;                                     
	
		Virtual_ZeroLevelCH4 = 0;                                
		CH4_Zero_Offset      = 0;                                       
	
		Rotary_Steps = 0;
		ON_Zero_Channel_3();
		Rotary_Steps = 0;
		ON_Zero_Channel_4();
	}
 
    Trigger_Pos_CH1 = ZeroLevelCH1;
    Trigger_Pos_CH2 = ZeroLevelCH2;
    Trigger_Pos_CH3 = ZeroLevelCH3;
    Trigger_Pos_CH4 = ZeroLevelCH4;

			
    if (Channel_1_Active) FindVoltage(1);
    if (Channel_2_Active) FindVoltage(2);

    if (NumberOfChannels > 2)
    {
        if (Channel_3_Active) FindVoltage(3);
        if (Channel_4_Active) FindVoltage(4);
    }


    			
    AutoTimerOff = false;
    Search_Mode  = false;

    triggering = triggering_bak;
    ctrl_reg = ctrl_reg_bak;
    adc_ctrl_reg = adc_ctrl_reg_bak;

    Continius = Continius_bak;
    SingleMode = SingleMode_bak;
    UserIface_active = 0;
/*
    Trigger_Pos_CH1 = Trigger_Pos_CH1_bak;
    Trigger_Pos_CH2 = Trigger_Pos_CH2_bak;
    Trigger_Pos_CH3 = Trigger_Pos_CH3_bak;
    Trigger_Pos_CH4 = Trigger_Pos_CH4_bak;
*/


  	if ( NumberOfChannels == 2) // TMW complete changed (2-Channel Version)
	{
		if (Channel_2_Active)
			Virtual_ZeroLevelCH1 = -1 * GRID_HEIGHT / 4; 	//-96; BF
		else
			Virtual_ZeroLevelCH1 = 0;
		
		CH1_Zero_Offset = 0;
	
		if (Channel_1_Active)
			Virtual_ZeroLevelCH2 = GRID_HEIGHT / 4;		//96; BF
		else
			Virtual_ZeroLevelCH2 = 0;
		
		CH2_Zero_Offset = 0;
	
		Rotary_Steps = 0;
		if (Channel_1_Active)
		{
			ON_Zero_Channel_1();
			Trigger_Pos_CH1 = ZeroLevelCH1 - 5;
		
			SetDacOffset(1);
			SetCHDacOffset(1);
		}
	
		Rotary_Steps = 0;
		if (Channel_2_Active)
		{
			ON_Zero_Channel_2();
			Trigger_Pos_CH2 = ZeroLevelCH2 - 5;
		
			SetDacOffset(2);
			SetCHDacOffset(2);
		}
    	}
  	else // TMW complete changed (4-Channel Version)
	{
       		Virtual_ZeroLevelCH1 = -120;           
       		CH1_Zero_Offset = 0;                                       
       		if (Channel_1_Active)
       		{
       			Rotary_Steps = 0;
            		ON_Zero_Channel_1();
            		Trigger_Pos_CH1 = ZeroLevelCH1 - 5;

            		SetDacOffset(1);
            		SetCHDacOffset(1);
        	}
       	
		Virtual_ZeroLevelCH2 = -24;           
       		CH2_Zero_Offset = 0;                                       
       		if (Channel_2_Active)
       		{
       			Rotary_Steps = 0;
            		ON_Zero_Channel_2();
            		Trigger_Pos_CH2 = ZeroLevelCH2 - 5;

            		SetDacOffset(2);
            		SetCHDacOffset(2);
        	}
			
		Virtual_ZeroLevelCH3 = 72;           
       		CH3_Zero_Offset = 0;                                       
       		if (Channel_3_Active)
       		{
       			Rotary_Steps = 0;
           	 	ON_Zero_Channel_3();
            		Trigger_Pos_CH3 = ZeroLevelCH3 - 5;

           		SetDacOffset(3);
           		SetCHDacOffset(3);
        	}
			
		Virtual_ZeroLevelCH4 = 168;           
       		CH4_Zero_Offset = 0;                                       
       		if (Channel_4_Active)
       		{
       			Rotary_Steps = 0;
            		ON_Zero_Channel_4();
            		Trigger_Pos_CH4 = ZeroLevelCH4 - 5;

            		SetDacOffset(4);
            		SetCHDacOffset(4);
        	}

	}


    acq_ready->np_pioedgecapture = 0;

    DoEnableRotInterrupt();
    DoEnableKeyInterrupt();
    DoEnableADCInterrupt();
    DoEnableUARTInterrupt();

    Recalc_Vars();

    UpdateTrigger(35);

    TimebaseChanged = 1;
    TimeOffsetChanged = 1;
    TriggerLevelChanged = 1;
    TriggerModeChanged = 1;
    TriggerWayChanged = 1;
    VoltageChangedCh1 = 1;									// Was Voltage changed
    VoltageChangedCh2 = 1;									// Was Voltage changed
    VoltageChangedCh3 = 1;									// Was Voltage changed
    VoltageChangedCh4 = 1;									// Was Voltage changed          		
		
    Display::StatusUpdate();


/* TMW 	if (Memory_Window_visible)
	{
        Display::DRAWMEMORY(0, 0, 1);
    } TMW*/

    if (Cursor_Enabled)
    {
        Display::CALCCURSORDATA();
        Menu_Changed = 1;
        CursorChanged = 4;
    }

    if (QM_Enabled)
    {
        Display::CALCQMDATA();
        Menu_Changed = 1;
    }

    Display::DRAW_ALL_CURSOR();

    LED_ON[12] = 1;
    LED_ON[13] = 0;

    LED_ON[14] = 0;
    LED_ON[15] = 0;

    Send_LED();

    nr_delay(10);

    SetupADC();

    Start_Record();

//    RemovePlane |= 0x1F;
 //   ClearPlanes();

    return 0;
}

int Hardware::FindTimebase(char channel)
{
    volatile int ix, result, max_cnt, cnt = 0, cnt2 = 0;
    volatile int buf_int = 0;
    volatile long buf_long = 0;

    volatile unsigned char buf_byte = 0;
    volatile unsigned char buf_byte2 = 0;

    int max_tb = 22;

#ifdef _Debug_FindTimebase_
    printf("Start FTB Channel %d\n", channel);
#endif

    switch(channel)
    {
        case 1: serdata->np_piodata = 0x70000015; break;
        case 2: serdata->np_piodata = 0x50000015; break;
        case 3: serdata->np_piodata = 0x10000015; break;
        case 4: serdata->np_piodata = 0x30000015; break;
    }


	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(20);



    Selected_Timebase = 4;                                          //  50 nS
    SIGNALFaktor_idx = 0;                                           // zoom factor 1 = 50 nS
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = tb_value[Selected_Timebase];
    Display_Timebase = 4;                                          // Displayed timebase is 50 ns

    triggering = 0;								
    ctrl_reg = 0x0087;							                    // Trigger_Master / Trigger_INT / Free Run
    adc_ctrl_reg &= 0xFFF0;						                    // Disable Trigger sources

    SetupADC();

    result = 0;

    max_cnt = 0;

    if (MenuStatus[23][1] == 240) max_tb = 16;
			
    while ((result < 15) || (result > 50))
    {
        max_cnt++;

        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off

        while (acq_ready->np_piodata == 0x01) {}

        data_adr->np_piodata = 0x01;

        buf_long = READADC(1);
        buf_long = READADC(1);

        WRITEADC(1, ram_adress_reg);
        WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            WRITEADC(3, ram_adress_reg);
            WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;   	

        switch(channel)
        {
            case 1 : ReadOut_Signal(1, 0, 0); break;
            case 2 : ReadOut_Signal(2, 0, 0); break;
            case 3 : ReadOut_Signal(3, 0, 0); break;
            case 4 : ReadOut_Signal(4, 0, 0); break;
        }

        result = 0;
        buf_byte = 0;
        cnt = 0;

        buf_int = (int) ZFT_float;

        if (buf_int <= 0) buf_int = 1;

        switch(channel)
        {
            case 1 :
            {
                buf_min = 255;
                buf_max = 0;

                for (ix = 50; ix < 650; ix++)
                {
                    buf_byte = SIGNAL1[ix * buf_int];
                    buf_arr[cnt++] = buf_byte;
                    if (buf_min < buf_byte) buf_min = buf_byte;
                    if (buf_max > buf_byte) buf_max = buf_byte;
                }

                buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);

                for (ix = 3; ix < 596; ix++)
                {
                    if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
                    if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
                }
#ifdef _Debug_FindTimebase_

                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                break;
            }

            case 2 :
            {
                buf_min = 255;
                buf_max = 0;

                for (ix = 50; ix < 650; ix++)
                {
                    buf_byte = SIGNAL2[ix * buf_int];
                    buf_arr[cnt++] = buf_byte;
                    if (buf_min < buf_byte) buf_min = buf_byte;
                    if (buf_max > buf_byte) buf_max = buf_byte;
                }

                buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);

                for (ix = 1; ix < 599; ix++)
                {
                    if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
                    if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
                }
#ifdef _Debug_FindTimebase_


                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                break;
            }

            case 3 :
            {
                buf_min = 255;
                buf_max = 0;

                for (ix = 50; ix < 650; ix++)
                {
                    buf_byte = SIGNAL3[ix * buf_int];
                    buf_arr[cnt++] = buf_byte;
                    if (buf_min < buf_byte) buf_min = buf_byte;
                    if (buf_max > buf_byte) buf_max = buf_byte;
                }

                buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);

                for (ix = 1; ix < 599; ix++)
                {
                    if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
                    if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
                }
#ifdef _Debug_FindTimebase_


                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                break;
            }

            case 4 :
            {
                buf_min = 255;
                buf_max = 0;

                for (ix = 50; ix < 650; ix++)
                {
                    buf_byte = SIGNAL4[ix * buf_int];
                    buf_arr[cnt++] = buf_byte;
                    if (buf_min < buf_byte) buf_min = buf_byte;
                    if (buf_max > buf_byte) buf_max = buf_byte;
                }

                buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);

                for (ix = 1; ix < 599; ix++)
                {
                    if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
                    if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
                }
#ifdef _Debug_FindTimebase_

                for (cnt2 = 0; cnt2 < 35; cnt2++)
                {
                    printf("%2d : %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n", cnt, buf_arr[(cnt * 16) + 0], buf_arr[(cnt * 16) + 1], buf_arr[(cnt * 16) + 2], buf_arr[(cnt * 16) + 3], buf_arr[(cnt * 16) + 4], buf_arr[(cnt * 16) + 5], buf_arr[(cnt * 16) + 6], buf_arr[(cnt * 16) + 7], buf_arr[(cnt * 16) + 8], buf_arr[(cnt * 16) + 9], buf_arr[(cnt * 16) + 10], buf_arr[(cnt * 16) + 11], buf_arr[(cnt * 16) + 12], buf_arr[(cnt * 16) + 13], buf_arr[(cnt * 16) + 14], buf_arr[(cnt * 16) + 15]);
                }

                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                break;
            }
        }
	
        if (result < 15)
        {
            Selected_Timebase_Old = Selected_Timebase;

            if ((Selected_Timebase < 4) && (SIGNALFaktor_idx == 0)) Selected_Timebase++;
            else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx < 4)) SIGNALFaktor_idx++;
            else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx < 2)) SIGNALFaktor_idx++;
            else if (Selected_Timebase < max_tb) Selected_Timebase++;

            if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
            {
                if (Selected_Timebase_Old == 6)
                {
                    Selected_Timebase = 9;
                    SIGNALFaktor_idx = 2;
                }
            }

            if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
            {
                if (Selected_Timebase_Old == 9)
                {
                    Selected_Timebase = 6;
                    SIGNALFaktor_idx = 4;
                }
            }

            timebase_reg = tb_value[Selected_Timebase];
            
            if (Selected_Timebase > 7) adc_change12_reg |= 0x01000000;
            else adc_change12_reg &= 0xFEFFFFFF;
            
            SetupADC();
        }

        if (result > 50)
        {
            Selected_Timebase_Old = Selected_Timebase;

            if ((Selected_Timebase > 4) && (SIGNALFaktor_idx == 4)) Selected_Timebase--;
            else if (SIGNALFaktor_idx > 0) SIGNALFaktor_idx--;
            else if ((Selected_Timebase > 2) && (SIGNALFaktor_idx == 0)) Selected_Timebase--;

            if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
            {
                if (Selected_Timebase_Old == 6)
                {
                    Selected_Timebase = 9;
                    SIGNALFaktor_idx = 2;
                }
            }

            if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
            {
                if (Selected_Timebase_Old == 9)
                {
                    Selected_Timebase = 6;
                    SIGNALFaktor_idx = 4;
                }
            }

			if ( Selected_Timebase <4 )
				Selected_Timebase =4;

            timebase_reg = tb_value[Selected_Timebase];
            
            if (Selected_Timebase > 7) adc_change12_reg |= 0x01000000;
            else adc_change12_reg &= 0xFEFFFFFF;
            
            SetupADC();

            if ((Selected_Timebase == 2) && (SIGNALFaktor_idx == 0)) result = 25;   // set break condition
        }


        if (Selected_Timebase == max_tb) result = 25;   // set break condition
        if (max_cnt == 25) result = 25;   // set break condition
    }

    Display_Timebase = Selected_Timebase + SIGNALFaktor_idx;

    Stop_Record();

    serdata->np_piodata = 0x700000CA;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(50);

    serdata->np_piodata = 0x500000CA;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(50);
	
	if (NumberOfChannels != 2)
	{
        serdata->np_piodata = 0x100000CA;
	    serstartsw->np_piodata = 1;
	    serstartsw->np_piodata = 0;
	    nr_delay(50);

        serdata->np_piodata = 0x300000CA;
	    serstartsw->np_piodata = 1;
	    serstartsw->np_piodata = 0;
	    nr_delay(50);	
    }
	
    nr_delay(300);

    return result;
}

int Hardware::FindVoltage(char channel)
{
    int ix, ix2, buf_int, volt = 12;
    long buf_long = 0;
    volatile unsigned char buf_byte = 0;

    int deltaV = 100;
    int topV = 40;
    int bottomV = 220;

    int posmin = 0, posmax = 0;

#ifdef _Debug_FindVoltage_
    printf("Start Channel %d\n", channel);
#endif

        			
    while (1)
    {
        if (volt > 3)
        {
            volt--;
#ifdef _Debug_FindVoltage_
            printf("decrement volt %d\n", volt);
#endif
        }
        else break;

        topV = 30;
        bottomV = 226;

                /*
        if ((Channel_1_Active) && (Channel_2_Active))
        {
            if (channel == 1)
            {
                topV = 30;
                bottomV = 128;
            }
            else
            {
                topV = 128;
                bottomV = 226;
            }
        }     */

        SetSwitches(channel, volt);

#ifdef _Debug_FindVoltage_
            printf("switches set\n");
#endif
/*
        Selected_Timebase = 15;                                          //  50 nS
        SIGNALFaktor_idx = 2;                                           // zoom factor 1 = 50 nS
//        Selected_Timebase = 4;                                          //  50 nS
//        SIGNALFaktor_idx = 0;                                           // zoom factor 1 = 50 nS
        SIGNAL_StartFr_idx = 0;                                         // running. so 0

        SIGNAL_StartFr_idx = 0;                                         // running. so 0

        timebase_reg = tb_value[Selected_Timebase];
        Display_Timebase = 17;                                          // Displayed timebase is 50 ns
//        Display_Timebase = 4;                                          // Displayed timebase is 50 ns
*/
        triggering = 0;								
        ctrl_reg = 0x0087;							                    // Trigger_Master / Trigger_INT / Free Run
        adc_ctrl_reg &= 0xFFF0;						                    // Disable Trigger sources

        pre_reg = 0x002D;
        Trigger_Offset_Pos = 162;

        if (Display_Timebase == 4)
        {
            pre_reg = 0x002D;
            Trigger_Offset_Pos = 162;
        }
        else if (Display_Timebase == 5)
        {
            pre_reg = 0x003C;
            Trigger_Offset_Pos = 162;
        }
        else if (Display_Timebase == 6)
        {
            pre_reg = 0x0055;
            Trigger_Offset_Pos = 262;
        }
        else if (Display_Timebase == 7)
        {
            pre_reg = 0x00A1;
            Trigger_Offset_Pos = 560;
        }
        else if (Display_Timebase == 8)
        {
            pre_reg = 0x0120;
            Trigger_Offset_Pos = 1075;
        }
        else if (Display_Timebase == 9)
        {
            pre_reg = 0x0120;
            Trigger_Offset_Pos = 1075;
        }
        else if (Display_Timebase == 10)
        {
            pre_reg = 0x0120;
            Trigger_Offset_Pos = 1075;
        }
        else if (Display_Timebase > 10)
        {
            pre_reg = 0x0110;
            Trigger_Offset_Pos = 252;
        }

        SetupADC();


#ifdef _Debug_FindVoltage_
            printf("Setup ADC - start record ctrl %x  pre %x  trig %d   irq %d\n", ctrl_reg, pre_reg, triggering, acq_ready->np_piodata);
#endif

        // first reag
        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off	

        while (acq_ready->np_piodata == 0x01) {}

#ifdef _Debug_FindVoltage_
            printf("Data received\n");
#endif

        data_adr->np_piodata = 0x01;

        buf_long = READADC(1);
        buf_long = READADC(1);

        WRITEADC(1, ram_adress_reg);
        WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            WRITEADC(3, ram_adress_reg);
            WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;

#ifdef _Debug_FindVoltage_
            printf("Start read out\n");
#endif         	

        switch(channel)
        {
            case 1 : ReadOut_Signal(1, 0, 0); break;
            case 2 : ReadOut_Signal(2, 0, 0); break;
            case 3 : ReadOut_Signal(3, 0, 0); break;
            case 4 : ReadOut_Signal(4, 0, 0); break;
        }

        buf_int = (int) ZFT_float;

        if (buf_int <= 0) buf_int = 1;


        switch(channel)
        {
            case 1 :
            {

                buf_min = 255;
                buf_max = 0;

#ifdef _Debug_FindVoltage_
                printf("acquire data\n");
#endif
                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL1[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
            case 2 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL2[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
            case 3 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL3[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }


                break;
            }
            case 4 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL4[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
        }

#ifdef _Debug_FindVoltage_
        printf("Min %d  Max %d  Volt %d \n", buf_min, buf_max, volt);

        for (ix2 = (posmin - 1); ix2 < (posmin + 10); ix2++) printf("S1[%3d] : %d\n", ix2, buf_arr[ix2]);
#endif
        if ((buf_min > topV) && (buf_max < bottomV) && (abs(buf_max - buf_min) > 40)) break;
    }
#ifdef _Debug_FindVoltage_
    printf("Res : Min %d  Max %d  Volt %d \n", buf_min, buf_max, volt);
#endif

	
    switch(channel)
    {
        case 1 : Selected_Voltage_CH1 = volt; SetSwitches(1, Selected_Voltage_CH1); VoltageChangedCh1 = 1; Display::DRAWSTATUS(1, 0); Rotary_Steps = 0; ON_Zero_Channel_1();break;											// Draw Voltage Channel 1
        case 2 : Selected_Voltage_CH2 = volt; SetSwitches(2, Selected_Voltage_CH2); VoltageChangedCh2 = 1; Display::DRAWSTATUS(2, 0); Rotary_Steps = 0; ON_Zero_Channel_2();break;											// Draw Voltage Channel 2
        case 3 : Selected_Voltage_CH3 = volt; SetSwitches(3, Selected_Voltage_CH3); VoltageChangedCh3 = 1; Display::DRAWSTATUS(3, 0); Rotary_Steps = 0; ON_Zero_Channel_3();break;											// Draw Voltage Channel 3
        case 4 : Selected_Voltage_CH4 = volt; SetSwitches(4, Selected_Voltage_CH4); VoltageChangedCh4 = 1; Display::DRAWSTATUS(4, 0); Rotary_Steps = 0; ON_Zero_Channel_4();break;											// Draw Voltage Channel 4

    }
    Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel

#ifdef _Debug_FindVoltage_
    printf("Ready FV\n");
#endif
}

void Hardware::FindSlope(void)
{
	long buf_long = 0, buf_long1 = 0;
	int cnt = 0;
	// Only two channels so far
	
    Hardware::DoDisableUARTInterrupt();
    Hardware::DoDisableADCInterrupt();
    Hardware::DoDisableKeyInterrupt();
    Hardware::DoDisableRotInterrupt();

    Stop_Record();


    AutoTimerOff = true;    	
/*	
    Display::DRAWROUNDBUTTON(230, 180, 220, 80, 0, 0);
    Display::TEXTOUTxvbig("For startup calibration", 247, 192, 1, UI_Plane2);
    Display::TEXTOUTxvbig("remove all input lines.", 247, 212, 1, UI_Plane2);
    Display::TEXTOUTxvbig("Press any key to continue.", 247, 232, 1, UI_Plane2);

  //  printf("Press a key\n");

	key_reset->np_piodata = 0;										// Reset Keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;
	key_int->np_pioedgecapture = 0;									// clear IRQ conditions	
*/	
 //   while (key_int->np_pioedgecapture == 0) {};

//   printf("Yes, a key\n");
	
	// Backup old
    triggering_bak = triggering;
    ctrl_reg_bak = ctrl_reg;
    adc_ctrl_reg_bak = adc_ctrl_reg;
    adc_change12_reg_bak = adc_change12_reg;
    adc_change34_reg_bak = adc_change34_reg;

    Selected_Timebase_bak = Selected_Timebase;
    SIGNALFaktor_idx_bak = SIGNALFaktor_idx;
    SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
    timebase_reg_bak = timebase_reg;
    Display_Timebase_bak = Display_Timebase;
    Continius_bak = Continius;
    SingleMode_bak = SingleMode;

    Selected_Voltage_CH1_bak = Selected_Voltage_CH1;
    Selected_Voltage_CH2_bak = Selected_Voltage_CH2;
    Selected_Voltage_CH3_bak = Selected_Voltage_CH3;
    Selected_Voltage_CH4_bak = Selected_Voltage_CH4;   	

    ZeroLevelCH1_bak = ZeroLevelCH1;
    ZeroLevelCH2_bak = ZeroLevelCH2;
    ZeroLevelCH3_bak = ZeroLevelCH3;
    ZeroLevelCH4_bak = ZeroLevelCH4;

    Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
    Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
    Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
    Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;


    Channel1_Zero_Sign_Offset_1_bak = Channel1_Zero_Sign_Offset_1;	
    Channel1_Zero_Sign_Offset_2_bak = Channel1_Zero_Sign_Offset_2;
    Channel1_Zero_Sign_Offset_3_bak = Channel1_Zero_Sign_Offset_3;

    Channel2_Zero_Sign_Offset_1_bak = Channel2_Zero_Sign_Offset_1;	
    Channel2_Zero_Sign_Offset_2_bak = Channel2_Zero_Sign_Offset_2;
    Channel2_Zero_Sign_Offset_3_bak = Channel2_Zero_Sign_Offset_3;

    Channel3_Zero_Sign_Offset_1_bak = Channel3_Zero_Sign_Offset_1;	
    Channel3_Zero_Sign_Offset_2_bak = Channel3_Zero_Sign_Offset_2;
    Channel3_Zero_Sign_Offset_3_bak = Channel3_Zero_Sign_Offset_3;

    Channel4_Zero_Sign_Offset_1_bak = Channel4_Zero_Sign_Offset_1;	
    Channel4_Zero_Sign_Offset_2_bak = Channel4_Zero_Sign_Offset_2;
    Channel4_Zero_Sign_Offset_3_bak = Channel4_Zero_Sign_Offset_3;
	
	// set test data
	
    Channel1_Zero_Sign_Offset_1 = 0;	
    Channel1_Zero_Sign_Offset_2 = 0;
    Channel1_Zero_Sign_Offset_3 = 0;

    Channel2_Zero_Sign_Offset_1 = 0;	
    Channel2_Zero_Sign_Offset_2 = 0;
    Channel2_Zero_Sign_Offset_3 = 0;

    Channel3_Zero_Sign_Offset_1 = 0;	
    Channel3_Zero_Sign_Offset_2 = 0;
    Channel3_Zero_Sign_Offset_3 = 0;

    Channel4_Zero_Sign_Offset_1 = 0;	
    Channel4_Zero_Sign_Offset_2 = 0;
    Channel4_Zero_Sign_Offset_3 = 0;	

    ZeroLevelCH1 = GRID_HEIGHT / 2;
    Virtual_ZeroLevelCH1 = 0;                                 // Virtual ZeroLevel
    CH1_Zero_Offset = 0;                                        // Shift offset when stopped

    ZeroLevelCH2 = GRID_HEIGHT / 2;
    Virtual_ZeroLevelCH2 = 0;                                 // Virtual ZeroLevel
    CH2_Zero_Offset = 0;                                        // Shift offset when stopped

    Rotary_Steps = 0;
    Hardware::ON_Zero_Channel_1();

    nr_delay(100);

    Rotary_Steps = 0;
    Hardware::ON_Zero_Channel_2();

    Hardware::SetSwitches(1, 11);

    nr_delay(100);

    Hardware::SetSwitches(2, 11);    	

    nr_delay(100);

    Selected_Timebase  = 4;                                          //  50 nS
    SIGNALFaktor_idx   = 0;                                           // zoom factor 1 = 50 nS
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = tb_value[Selected_Timebase];
    Display_Timebase = 4;                                          // Displayed timebase is 50 ns

    HoldOff_Value = 0;
    triggering = 0;								
    //ctrl_reg &= 0xC0FF;							// Clear Pulse and HoldOff bits
    ctrl_reg = 0x0087;							                    // Trigger_Master / Trigger_INT / Free Run
    adc_ctrl_reg &= 0x0100;						                    // Disable Trigger sources
	                     	

    // test generator settings
    adc_change12_reg = 0x30000000;                //  Bit 28 - TestGenerator  - Filter
    adc_change34_reg = 0x10000000;                //  Bit 28 - TestGenerator
    SwitchesCH2 = 0x66DA;                       // TestCounter CH I - IV + 5V Channel II
					
    Hardware::SetSwitches(2, -1);


    la_pulse->np_piodata = 0x01;				//stop record Port On
    la_pulse->np_piodata = 0x00;				//stop record Port Off	
                             																						
    Hardware::SetupADC();
    nr_delay(100);
    Hardware::SetupADC();

    // Run as long not found


//    Hardware::READADC(1);

    acq_ready->np_pioedgecapture = 0;
    acq_ready->np_piodata = 0x00;

 //   while ((buf_long & 0x1000) == 0)
    {
        // first reag
        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off

        //printf("slope started\n");	

        while (acq_ready->np_piodata == 0x01)
        {
//#ifdef _Debug_
            //printf("1\n");
            nr_delay(500);
/*
            Hardware::SetupADC();
            start_acq->np_piodata = 0x01;				//start record Port On
            start_acq->np_piodata = 0x00;				//start record Port Off	
*/
            cnt++;
            if (cnt == 20)
            {
//                printf("Slope stoped");
                break;
            }
//#endif
        }


        data_adr->np_piodata = 0x01;

        buf_long  = Hardware::READADC(1);
        buf_long1 = Hardware::READADC(1);

        Hardware::WRITEADC(1, ram_adress_reg);
        Hardware::WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            Hardware::WRITEADC(3, ram_adress_reg);
            Hardware::WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;

        ReadOut_Signal(1, buf_long, 0);
        ReadOut_Signal(2, buf_long, 0);
        if (NumberOfChannels > 2)
        {
            ReadOut_Signal(3, buf_long, 0);
            ReadOut_Signal(4, buf_long, 0);
        }
#ifdef _Debug_
        printf("bl %04x bl1 %08x\n", buf_long, buf_long1);
#endif
    }

    la_gate->np_piodata = 0x00;
    slope_value = la_data->np_piodata;


    // restore old
    triggering = triggering_bak;
    ctrl_reg = ctrl_reg_bak;
    adc_ctrl_reg = adc_ctrl_reg_bak;

    Continius = Continius_bak;
    SingleMode = SingleMode_bak;
    UserIface_active = 0;

    SwitchesCH2 &= 0x00FF;
    adc_change12_reg = adc_change12_reg_bak;
    adc_change34_reg = adc_change34_reg_bak;

    Selected_Timebase = Selected_Timebase_bak;
    SIGNALFaktor_idx = SIGNALFaktor_idx_bak;
    SIGNAL_StartFr_idx = SIGNAL_StartFr_idx_bak;
    timebase_reg = timebase_reg_bak;
    Display_Timebase = Display_Timebase_bak;

    Selected_Voltage_CH1 = Selected_Voltage_CH1_bak;
    Selected_Voltage_CH2 = Selected_Voltage_CH2_bak;
    Selected_Voltage_CH3 = Selected_Voltage_CH3_bak;
    Selected_Voltage_CH4 = Selected_Voltage_CH4_bak;   	

    ZeroLevelCH1 = ZeroLevelCH1_bak;
    ZeroLevelCH2 = ZeroLevelCH2_bak;
    ZeroLevelCH3 = ZeroLevelCH3_bak;
    ZeroLevelCH4 = ZeroLevelCH4_bak;

    Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_bak;
    Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_bak;
    Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_bak;
    Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_bak;

    Channel1_Zero_Sign_Offset_1 = Channel1_Zero_Sign_Offset_1_bak;	
    Channel1_Zero_Sign_Offset_2 = Channel1_Zero_Sign_Offset_2_bak;
    Channel1_Zero_Sign_Offset_3 = Channel1_Zero_Sign_Offset_3_bak;

    Channel2_Zero_Sign_Offset_1 = Channel2_Zero_Sign_Offset_1_bak;	
    Channel2_Zero_Sign_Offset_2 = Channel2_Zero_Sign_Offset_2_bak;
    Channel2_Zero_Sign_Offset_3 = Channel2_Zero_Sign_Offset_3_bak;

    Channel3_Zero_Sign_Offset_1 = Channel3_Zero_Sign_Offset_1_bak;	
    Channel3_Zero_Sign_Offset_2 = Channel3_Zero_Sign_Offset_2_bak;
    Channel3_Zero_Sign_Offset_3 = Channel3_Zero_Sign_Offset_3_bak;

    Channel4_Zero_Sign_Offset_1 = Channel4_Zero_Sign_Offset_1_bak;	
    Channel4_Zero_Sign_Offset_2 = Channel4_Zero_Sign_Offset_2_bak;
    Channel4_Zero_Sign_Offset_3 = Channel4_Zero_Sign_Offset_3_bak;

    Hardware::UpdateTrigger(33);

    Rotary_Steps = 0;
    Hardware::ON_Zero_Channel_1();
    Rotary_Steps = 0;
    Hardware::ON_Zero_Channel_2();

    Hardware::SetSwitches(1, Selected_Voltage_CH1);
    Hardware::SetSwitches(2, Selected_Voltage_CH2);


/*
    Display::DRAWROUNDBUTTON(230, 180, 220, 80, 0, 1);
    Display::TEXTOUTxvbig("For startup calibration", 247, 192, 0, UI_Plane2);
    Display::TEXTOUTxvbig("remove all input lines.", 247, 212, 0, UI_Plane2);
    Display::TEXTOUTxvbig("Press any key to continue.", 247, 232, 0, UI_Plane2);	
*/
    AutoTimerOff = false;    	

    Hardware::DoEnableRotInterrupt();
    Hardware::DoEnableKeyInterrupt();
    Hardware::DoEnableADCInterrupt();
    Hardware::DoEnableUARTInterrupt();	
#ifdef _Debug_
    printf("Slope : %x\n", slope_value);
#endif
}

/*

int Hardware::FindTimebase(char channel)
{
    int ix, result, cnt = 0;
    int buf_int = 0;
    float buf_float = 0;
    long buf_long = 0;
    long buf_long2 = 0;

    char buf_byte = 0;
    char buf_byte2 = 0;

    int zl_buf = 0;

    switch(channel)
    {
        case 1 : zl_buf = (ZeroLevelCH1 + 64) >> 1; break;
        case 2 : zl_buf = (ZeroLevelCH2 + 64) >> 1; break;
        case 3 : zl_buf = (ZeroLevelCH3 + 64) >> 1; break;
        case 4 : zl_buf = (ZeroLevelCH4 + 64) >> 1; break;
    }

    result = 0;
			
    while ((result < 30) || (result > 60))
    {
        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off	

        while (acq_ready->np_piodata == 0x01) {}

        data_adr->np_piodata = 0x01;

        buf_long = READADC(1);
        buf_long = READADC(1);

        WRITEADC(1, ram_adress_reg);
        WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            WRITEADC(3, ram_adress_reg);
            WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;
	
        for (cnt = 0; cnt < 25; cnt++)
        {
            switch(channel)
            {
                case 1 : buf_long = READADC(1); break;
                case 2 : buf_long = READADC(2); break;
                case 3 : buf_long = READADC(3); break;
                case 4 : buf_long = READADC(4); break;
            }
        }	
	
        switch(channel)
        {
            case 1 : buf_long = READADC(1) ^ 0xFFFFFFFF; break;
            case 2 : buf_long = READADC(2) ^ 0xFFFFFFFF; break;
            case 3 : buf_long = READADC(3) ^ 0xFFFFFFFF; break;
            case 4 : buf_long = READADC(4) ^ 0xFFFFFFFF; break;
        }

        buf_byte = (buf_long & 0xFF);
	
//        buf_int = (int) ZFT_float;
 //     if (buf_int < 1) buf_int = 1;

        printf("stb %d  %d\n", Selected_Timebase, SIGNALFaktor_idx);
        printf("st %d\n", SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float));
        printf("sp %d\n", SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float));
	
        result = 0;

        for (ix = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float); ix < SIG_Start_Stop[ZIT_short][1] + (int)((float) Timebase_Offset_Pos * OFT_float); ix++)
        {
            switch(channel)
            {
                case 1 : buf_long2 = READADC(1) ^ 0xFFFFFFFF; break;
                case 2 : buf_long2 = READADC(2) ^ 0xFFFFFFFF; break;
                case 3 : buf_long2 = READADC(3) ^ 0xFFFFFFFF; break;
                case 4 : buf_long2 = READADC(4) ^ 0xFFFFFFFF; break;
            }
            buf_byte2 = (buf_long2 & 0xFF);

            if ((buf_byte < zl_buf) && (buf_byte2 > zl_buf))
            {
                result++;
            }

            buf_byte = buf_byte2;
        }

        printf("FTB %d\n", result);
			
        if (result < 30)
        {
            if ((Selected_Timebase < 4) && (SIGNALFaktor_idx == 0)) Selected_Timebase++;
            else if (SIGNALFaktor_idx < 4) SIGNALFaktor_idx++;
            else if (Selected_Timebase < 31) Selected_Timebase++;

            timebase_reg = tb_value[Selected_Timebase];
            SetupADC();
        }

        if (result > 60)
        {
            if ((Selected_Timebase > 4) && (SIGNALFaktor_idx == 4)) Selected_Timebase--;
            else if (SIGNALFaktor_idx > 0) SIGNALFaktor_idx--;
            else if ((Selected_Timebase > 2) && (SIGNALFaktor_idx == 0)) Selected_Timebase--;

            timebase_reg = tb_value[Selected_Timebase];
            SetupADC();
        }
    }

    return result;
}

*/

void Hardware::DoEnableReadVSyncInterrupt(void)						// Enable ReadVSync service routine
{

	read_vsync->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	read_vsync->np_piodirection = 0;								// set bit to input
	read_vsync->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_read_vsync_irq,ISR_ReadVSync_INT,(int)read_vsync);		// Install ISR for ReadVSync
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("read_vsync interrupt enabled.\n"); 					// print on console
#endif	

}

void Hardware::DoDisableReadVSyncInterrupt(void)					// Disable ReadVSync service routine
{
	nr_installuserisr(na_read_vsync_irq,0,0); 						// Install empty routine for ReadVSync irq
	read_vsync->np_piointerruptmask = 0x00;							// disable all IRQs
}

void Hardware::ISR_ReadVSync_INT(int context)						// ReadVSync interrupt subroutine
{
    tc_test_var2++;
	VSync_Needed = 1;	
	vs_counter++;
	read_vsync->np_pioedgecapture = 0;								// clear IRQ conditions	

#ifdef _Debug_IRQ_
	//if (Debug_Mode) printf("read_vsync interrupt enabled.\n"); 					// print on console
#endif		
}

void Hardware::TransferPlanes(void)
{
    int cnt;

    if (VSync_Needed == 0) return;
    if (MenuPopupActive > -1) return;

    if (UpdateMarkerPlane) TransferPlanes_asm_persistant(0x008CABE4, 0x009D9DF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
    UpdateMarkerPlane = false;

    if (UpdateMenuTextPlane)
    {
        TransferDataPlane_asm_persistant(0x008DBB24, 0x00970F30);
    }
    UpdateMenuTextPlane = false;

    if (Splash_drawed) return;
    
    //printf("ClearPlane : %x  started : %d MenuStatus[1][2]x : %d \n", ClearPlane, adc_started, MenuStatus[1][2]);

	//reset_watchdog->np_piodata = 0x00;								// Disable WatchDog 	   	
      	   	
    if (MenuStatus[5][0] == 240)
    {
        switch(ClearPlane)
        {
            case 0x01 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x02 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x03 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2); break;
            case 0x04 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	
            case 0x05 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;
            case 0x06 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;	
            case 0x07 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3); break;
            case 0x08 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x09 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;
            case 0x0A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
            case 0x0B : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3); break;
            case 0x0C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
            case 0x0D : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;
            case 0x0E : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;

            case 0x0F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x10 : TransferPlanes_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	
            case 0x11 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
            case 0x12 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;	
            case 0x13 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3); break;	
            case 0x14 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
            case 0x15 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;	
            case 0x16 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;

            case 0x17 :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x18 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;		
            case 0x19 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		
            case 0x1A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		

            case 0x1B :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;	

            case 0x1D :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1E :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                break;
            }  		
        }
    }
    else
    {	
        switch(ClearPlane)
        {
            case 0x01 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x02 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x03 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2);break;
            case 0x04 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	
            case 0x05 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;
            case 0x06 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;
            case 0x07 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3);break;
            case 0x08 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;                               		
            case 0x09 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0B : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);break;
            case 0x0C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0D : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;
            case 0x0E : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;

            case 0x0F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x10 : TransferPlanes_asm_persistant(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x11 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x12 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x13 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);break;
            case 0x14 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x15 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;
            case 0x16 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x17 :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x18 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;                              		
            case 0x19 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;     		
            case 0x1A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x1B :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x1D :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1E :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
                if (MenuStatus[5][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                break;
            }
        }
    }

     /*
	// pixel error correction
	if ((ClearPlane & 0x01) == 0x01)
    {
    //    for (cnt = 20; cnt < 480; cnt++) Buffer_Plane1[cnt * 20] = Buffer_Plane1[cnt * 20] << 2;	
        	
    }

    for (cnt = 20; cnt < 480; cnt++)
    {
        if ((ClearPlane & 0x01) == 0x01) Channel_Plane1[cnt * 20] = Channel_Plane1[cnt * 20] << 2;
        if ((ClearPlane & 0x02) == 0x02) Channel_Plane2[cnt * 20] = Channel_Plane2[cnt * 20] << 2;
        if ((ClearPlane & 0x04) == 0x04) Channel_Plane3[cnt * 20] = Channel_Plane3[cnt * 20] << 2;
        if ((ClearPlane & 0x08) == 0x08) Channel_Plane4[cnt * 20] = Channel_Plane4[cnt * 20] << 2;
        if ((ClearPlane & 0x10) == 0x10) Channel_Math_Plane[cnt * 20] = Channel_Math_Plane[cnt * 20] << 2;

    }
    */

	if (Splash_drawed == false)
	{
        if (init_done) Display::DRAWSIGNS();//DRAWSIGNS();

        if (Menu_Changed) Display::UpdateMenu();
    }

	ClearPlane &= 0xE0;	
    VSync_Needed = 0;
    	
	//reset_watchdog->np_piodata = 0x01;								// Enable WatchDog	
	
	/////if ((adc_started == false) && (SingleMode == false) && (Continius) && (OneShotRestart == false) && (UserIface_active == false)&& (ROLLMODE_STARTED == false)) Hardware::Start_Record();
}

void Hardware::ClearPlanes(void)
{
//	reset_watchdog->np_piodata = 0x00;								// Disable WatchDog
	
    if (Channel_1_Active == 1) DrawPlane |= 0x01;	
    if (Channel_2_Active == 1) DrawPlane |= 0x02;
    if (Channel_Math_Active == 1) DrawPlane |= 0x10;

    if (NumberOfChannels > 2)
    {
        if (Channel_3_Active == 1) DrawPlane |= 0x04;
        if (Channel_4_Active == 1) DrawPlane |= 0x08;
    }
#ifdef _Debug_
    printf("we clear\n");
#endif       	
    ClearPlane = DrawPlane | RemovePlane;
    DrawPlane = 0;
   	   	
	switch(ClearPlane)
	{
	    case 0x01 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
            break;
		}
	    case 0x02 :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
            break;
		}
	    case 0x03 :
	    {  	
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2);
            break;
		}
	    case 0x04 :
	    {
            TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
            break;	
		}
	    case 0x05 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);
            break;
		}
	    case 0x06 :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);
            break;	
		}
	    case 0x07 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3);
            break;
		}	
        case 0x08 :
	    {
            TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
            break;
		}                                        		
        case 0x09 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);
            break;
		}
        case 0x0A :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);
            break;	
		}
        case 0x0B :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);
            break;
		}
        case 0x0C :
	    {
            TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);
            break;	
		}
        case 0x0D :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
            break;
		}
        case 0x0E :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
            break;
		}
        case 0x0F :
	    {
            TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
            break;
		}     	
	    case 0x10 :
	    {
            TransferPlanes_clear_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
            break;	
		}
	    case 0x11 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
            break;
		}
	    case 0x12 :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
            break;	
		}
	    case 0x13 :
	    {  	
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);
            break;	
		}
	    case 0x14 :
	    {
            TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
            break;
		}
	    case 0x15 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
            break;	
		}
	    case 0x16 :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
            break;
		}
	    case 0x17 :
	    {
            TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
            break;		
		}
        case 0x18 :
	    {
            TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
            break;		
		}                                        		
        case 0x19 :
	    {
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
            break;		
		}               		
        case 0x1A :
	    {
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
            break;		
		}
        case 0x1B :
	    {
            TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);	
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
            break;		
		}
        case 0x1C :
	    {
            TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
            break;	
		}
        case 0x1D :
	    {
            TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
            break;
		}
        case 0x1E :
	    {
            TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
            TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
            break;	
		}           		
        case 0x1F :
	    {
            TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
            TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
            break;
		}		
	}	
	
	if (init_done) Display::DRAWSIGNS();

	ClearPlane &= 0xE0;	
    	
//	reset_watchdog->np_piodata = 0x01;								// Enable WatchDog	
}

void Hardware::TransferDataPlane_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1)
{
	asm("
            PFX	    %hi(1460)                         ; Set Counter
            MOVI	%l1,%lo(1460)

            loopmtpp1:
            LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
            ST     [%i1], %l0                        ; Store it to Plane
                                                               	
            ADDI   %i0, 4                            ; Add Address Counter
            ADDI   %i1, 4	
	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     loopmtpp1
            NOP 	
        ");
}

void Hardware::TransferPlane_Set_Buffer_Adr(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2)
{
    asm("
            MOV		%r4,%i0	
            MOV		%r5,%i1

            MOV		%r6,%i2
            MOV		%r7,%i3
        ");
}

void Hardware::TransferPlanes_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp3
                    NOP 	
                ");
            break;
        }

	    case 4 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                    ST     [%r6], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    looptpp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)
	
                    looptpp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)
	
                    looptpp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    looptpp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    looptpp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_clear_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc1:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc2:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc3:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc4:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(7740)                         ; Set Counter
                    MOVI	%l1,%lo(7740)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc5:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane

                    ST     [%r6], %l2                        ; Clear Buffer
                    ST     [%r7], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::Planes_clear_asm(unsigned long Buffer_Adr1)
{
	asm("
            PFX	    %hi(7740)                         ; Set Counter
            MOVI	%l1,%lo(7740)

            PFX	    %hi(0)                            ; Set Clear register
            MOVI	%l2,%lo(0)
            PFX	    %xhi(0)
            MOVHI	%l2,%xlo(0)	
	
        looptpcc1:
            ST     [%i0], %l2                        ; Clear Buffer

            ADDI   %i0, 4                            ; Add Address Counter
	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     looptpcc1
            NOP 	
        ");
}

void Hardware::Planes_clear_asm_all(unsigned char count, unsigned long Buffer_Adr1, unsigned long Buffer_Adr2, unsigned long Buffer_Adr3, unsigned long Buffer_Adr4, unsigned long Buffer_Adr5)
{
    switch(count)
    {
        case 1 :
        {
	       asm("
                PFX	    %hi(7740)                         ; Set Counter
                MOVI	%l1,%lo(7740)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc21:
                ST     [%i1], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc21
                NOP 	
            ");
            break;
        }
        case 2 :
        {
	       asm("
                PFX	    %hi(7740)                         ; Set Counter
                MOVI	%l1,%lo(7740)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc22:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc22
                NOP 	
            ");
            break;
        }
        case 3 :
        {
	       asm("
                PFX	    %hi(7740)                         ; Set Counter
                MOVI	%l1,%lo(7740)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc23:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc23
                NOP 	
            ");
            break;
        }
        case 4 :
        {
	       asm("
                PFX	    %hi(7740)                         ; Set Counter
                MOVI	%l1,%lo(7740)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc24:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc24
                NOP 	
            ");
            break;
        }
        case 5 :
        {
	       asm("
                PFX	    %hi(7740)                         ; Set Counter
                MOVI	%l1,%lo(7740)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc25:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer
                ST     [%i5], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
                ADDI   %i5, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc25
                NOP 	
            ");
            break;
        }
    }
}

void Hardware::DoEnableLogicAnalyserInterrupt(void)						// Enable service routine
{
	la_interrupt->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	la_interrupt->np_piodirection = 0x00;								// set all bits to input
	la_interrupt->np_piointerruptmask = 0x01;							// enable Button IRQs
	la_interrupt->np_piodata = 0;

	nr_installuserisr(na_la_interrupt_irq,ISR_LogicAnalyser,(int)la_interrupt);	// Install ISR for parallel I/Os

#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nLogicAnalyser interrupt enabled.\n"); 						// print on console
#endif	
}
	
void Hardware::DoDisableLogicAnalyserInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_la_interrupt_irq,0,0); 				// Install empty routine for pio irq
	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
}


void Hardware::ISR_LogicAnalyser(int context)
{
	char la_data_cnt;
	
	tc_test_var2++;

	la_gate->np_piodata = 0x01;
	
	for (la_data_cnt = 0; la_data_cnt < 32; la_data_cnt++)
	{
		la_pulse->np_piodata = 0x01;
		
		LogicData[la_data_cnt] = la_data-> np_piodata;
		
		la_pulse->np_piodata = 0x00;		
	}	
	
	la_gate->np_piodata = 0x00;
	
    la_interrupt->np_pioedgecapture = 0; 								// clear IRQ conditions		

	//if (USB_Data_Trans == 1)
	{
		send_buffer[0] = 3;						// Command Write Data
		send_buffer[1] = 20;
		send_buffer[2] = 1;
		
		SendData(send_buffer);	
	}
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nLogicAnalyser interrupt received\n");
#endif	
}

/****************************************************************************/
/* clear: zeroize a FIR delay line                                          */
/****************************************************************************/
void clear(int ntaps, SAMPLE z[])
{
    int ii;
    for (ii = 0; ii < ntaps; ii++) {
        z[ii] = 0;
    }
}

/****************************************************************************
* fir_basic: Does the basic FIR algorithm: store input sample, calculate
* output sample, move delay line
*****************************************************************************/
SAMPLE fir_basic(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[])
{
    int ii;
    SAMPLE accum;

    /* store input at the beginning of the delay line */
    z[0] = input;

    /* calc FIR */
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += h[ii] * z[ii];
    }

    /* shift delay line */
    for (ii = ntaps - 2; ii >= 0; ii--) {
        z[ii + 1] = z[ii];
    }

    return accum;
}

/****************************************************************************
* fir_circular: This function illustrates the use of "circular" buffers
* in FIR implementations.  The advantage of circular buffers is that they
* alleviate the need to move data samples around in the delay line (as
* was done in all the functions above).  Most DSP microprocessors implement
* circular buffers in hardware, which allows a single FIR tap can be
* calculated in a single instruction.  That works fine when programming in
* assembly, but since C doesn't have any constructs to represent circular
* buffers, you need to "fake" them in C by adding an extra "if" statement
* inside the FIR calculation, even if the DSP processor provides hardware to
* implement them without overhead.
*****************************************************************************/
SAMPLE fir_circular(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[],
                    int *p_state)
{
    int ii, state;
    SAMPLE accum;

    state = *p_state;               /* copy the filter's state to a local */

    /* store input at the beginning of the delay line */
    z[state] = input;
    if (++state >= ntaps) {         /* incr state and check for wrap */
        state = 0;
    }

    /* calc FIR and shift data */
    accum = 0;
    for (ii = ntaps - 1; ii >= 0; ii--) {
        accum += h[ii] * z[state];
        if (++state >= ntaps) {     /* incr state and check for wrap */
            state = 0;
        }
    }

    *p_state = state;               /* return new state to caller */

    return accum;
}

/****************************************************************************
* fir_shuffle: This is like fir_basic, except that data is shuffled by
* moving it _inside_ the calculation loop.  This is similar to the MACD
* instruction on TI's fixed-point processors
*****************************************************************************/
SAMPLE fir_shuffle(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[])
{
    int ii;
    SAMPLE accum;

    /* store input at the beginning of the delay line */
    z[0] = input;

    /* calc FIR and shift data */
    accum = h[ntaps - 1] * z[ntaps - 1];
    for (ii = ntaps - 2; ii >= 0; ii--) {
        accum += h[ii] * z[ii];
        z[ii + 1] = z[ii];
    }

    return accum;
}

/****************************************************************************
* fir_split: This splits the calculation into two parts so the circular
* buffer logic doesn't have to be done inside the calculation loop
*****************************************************************************/
SAMPLE fir_split(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[],
                 int *p_state)
{
    int ii, end_ntaps, state = *p_state;
    SAMPLE accum;
    SAMPLE const *p_h;
    SAMPLE *p_z;

    /* setup the filter */
    accum = 0;
    p_h = h;

    /* calculate the end part */
    p_z = z + state;
    *p_z = input;
    end_ntaps = ntaps - state;
    for (ii = 0; ii < end_ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    /* calculate the beginning part */
    p_z = z;
    for (ii = 0; ii < state; ii++) {
        accum += *p_h++ * *p_z++;
    }

    /* decrement the state, wrapping if below zero */
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       /* return new state to caller */

    return accum;
}

/****************************************************************************
* fir_double_z: double the delay line so the FIR calculation always
* operates on a flat buffer
*****************************************************************************/
SAMPLE fir_double_z(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[],
            int *p_state)
{
    SAMPLE accum;
    int ii, state = *p_state;
    SAMPLE const *p_h, *p_z;

    /* store input at the beginning of the delay line as well as ntaps more */
    z[state] = z[state + ntaps] = input;

    /* calculate the filter */
    p_h = h;
    p_z = z + state;
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    /* decrement state, wrapping if below zero */
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       /* return new state to caller */

    return accum;
}

/****************************************************************************
* fir_double_h: uses doubled coefficients (supplied by caller) so that the
* filter calculation always operates on a flat buffer.
*****************************************************************************/
SAMPLE fir_double_h(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[],
                    int *p_state)
{
    SAMPLE accum;
    int ii, state = *p_state;
    SAMPLE const *p_h, *p_z;

    /* store input at the beginning of the delay line */
    z[state] = input;

    /* calculate the filter */
    p_h = h + ntaps - state;
    p_z = z;
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    /* decrement state, wrapping if below zero */
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       /* return new state to caller */

    return accum;
}

/****************************************************************************
* main: This provides a simple test suite for the functions above.  An
* impulse is fed into each filter implementation, so the output should be
* the "impulse response", that is, the coefficients of the filter.  You
* should see some zeroes, followed by the "coefficents" below, followed by a
* few more zeroes.
*****************************************************************************/
int Hardware::TestFir(void)
{
    static const SAMPLE h[NTAPS] = { 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2 };
    static SAMPLE h2[2 * NTAPS];
    static SAMPLE z[2 * NTAPS];
    static SAMPLE imp[IMP_SIZE];

    SAMPLE output;
    int ii, state;

    /* make impulse input signal */
    clear(IMP_SIZE, imp);


    imp[0]  = 0.0;
    imp[1]  = 0.0;
    imp[2]  = 1.0;
    imp[3]  = 2.0;
    imp[4]  = 3.0;
    imp[5]  = 4.0;
    imp[6]  = 5.0;
    imp[7]  = 4.0;
    imp[8]  = 3.0;
    imp[9]  = 2.0;
    imp[10] = 1.0;
    imp[11] = 0.0;
    imp[12] = -1.0;
    imp[13] = -2.0;
    imp[14] = -3.0;
    imp[15] = -4.0;
    imp[16] = -5.0;
    imp[17] = -4.0;
    imp[18] = -3.0;
    imp[19] = -2.0;
    imp[20] = -1.0;
    imp[21] = 0.0;
    imp[22] = 1.0;
    imp[23] = 2.0;
    imp[24] = 3.0;
    imp[25] = 4.0;
    imp[26] = 5.0;
    imp[27] = 4.0;
    imp[28] = 3.0;
    imp[29] = 2.0;
    imp[30] = 1.0;
    imp[31] = 0.0;
    imp[32] = 0.0;
/*
    imp[0]  = 0.0;
    imp[1]  = 0.0;
    imp[2]  = 0.0;
    imp[3]  = 0.0;
    imp[4]  = 0.0;
    imp[5]  = 0.0;
    imp[6]  = 0.0;
    imp[7]  = 0.0;
    imp[8]  = 0.0;
    imp[9]  = 0.0;
    imp[10] = 0.0;
    imp[11] = 0.0;
    imp[12] = 0.0;
    imp[13] = 0.0;
    imp[14] = 0.0;
    imp[15] = 0.0;
    imp[16] = 0.0;
    imp[17] = 0.0;
    imp[18] = 0.0;
    imp[19] = 0.0;
    imp[20] = 0.0;
*/
/*
    imp[0]  = 0.0;
    imp[1]  = 0.0;
    imp[2]  = 0.0;
    imp[3]  = 0.0;
    imp[4]  = 0.0;
    imp[5]  = 0.0;
    imp[6]  = 0.0;
    imp[7]  = 0.0;
    imp[8]  = 0.0;
    imp[9]  = 0.0;
    imp[10] = 0.0;
    imp[11] = 0.0;
    imp[12] = 0.0;
    imp[13] = 0.0;
    imp[14] = 0.0;
    imp[15] = 0.0;
    imp[16] = 0.0;
    imp[17] = 0.0;
    imp[18] = 0.0;
    imp[19] = 0.0;
    imp[20] = 0.0;
*/

    /* create a SAMPLEd h */
    for (ii = 0; ii < NTAPS; ii++) {
        h2[ii] = h2[ii + NTAPS] = h[ii];
    }

    /* test FIR algorithms */

    printf("Testing fir_basic:\n   ");
    clear(NTAPS, z);
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_basic(imp[ii], NTAPS, h, z);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_shuffle:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_shuffle(imp[ii], NTAPS, h, z);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_circular:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_circular(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_split:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_split(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_double_z:\n   ");
    clear(2 * NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_double_z(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_double_h:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_double_h(imp[ii], NTAPS, h2, z, &state);
        printf("%3.1lf ", (double) output);
    }

    #ifdef WIN32
        printf("\n\nHit any key to continue.");
        getch();
    #endif

    return 0;
}

//############################################################################################################################
/* BF */
// Build trigonometric tables for FFT

void Hardware::Build_Trigo_Tables(void)
{
	//Speicher auf dem Stack reservieren
	int z,l,i,r,ct,buff; 	//,ar,v, la;
	int d[LEVEL];	//Number of butterfly levels

	//Struktur vom Typ div_t erzeugen
	div_t s_div;

	for(i=0;i < FFT_LENGTH;i++)  			// {sin und cos-Tabelle anlegen}
	{
		sin_tab[i] = sin(i*2*PI/FFT_LENGTH);
		cos_tab[i] = cos(i*2*PI/FFT_LENGTH);
	}

	//Bit-Reversal- Tabelle bit_rev[0..] anlegen
	for(i=0 ;i < FFT_LENGTH; i++)
	{
		z=i;
		//Dezimal-Index in Dualzahl umwandeln
		for(ct=0 ;ct < LEVEL; ct++)
		{
			s_div = div(z,2);
			d[ct] = (int)s_div.rem;		// den Rest ins Feld
			z     = (int)s_div.quot;	// den Quotienten nach z
		}
		//Bit-Revers anordnen
		s_div = div(LEVEL,2);
		for(ct=0 ;ct < (int)s_div.quot; ct++)
		{
			buff  = d[ct];
			d[ct] = d[LEVEL-ct-1];
			d[LEVEL-ct-1] = buff;
		}
		
		//Bit-Revers anordnen Zeitoptimiert mit Festwert
//		for(int buff,j=0;j<5;j++) 	        // 5 = LEVEL/radix  => x=div(LEVEL,2) => x.quot=5
//		{
//			buff 	     = d[j];
//			d[j] 	     = d[LEVEL-j-1];
//			d[LEVEL-j-1] = buff;
//		}

		//Umsortierten Index zurückwandeln in Dezimalzahl
		r = 0;
		for(ct=0 ;ct < LEVEL; ct++)
		{
			r = r + (1<<ct) * d[ct];
		}
		//umsortierter Index
		bit_rev[i] = r;

	}//Ende Bit-Reversal-Tabelle




}

//############################################################################################################################
/* BF */
//Calculate fast fourier transformation to get spectral analyzis of time signal. Trigonometric tables have to be build first.
//To get a periodic approximation the time signal has to be processed with a window function. The simplest case is a 
//rectangle window, which has no good  results because of missing side line suppression.

void Hardware::Do_FFT(void)
{
	int icnt;
		//Speicher auf dem Stack reservieren
	int   z,l,i,j,la,r,ar,v;
	float z1,z2,z3,z4,xr,xi,yr,yi;
	int d[LEVEL];      		// Inhalt: LEVEL-1  {Umwandlung}

#ifdef _Debug_FFT_
    printf("starting fft\n");
#endif

//+++++++++++++++++++++++++++++++++++++++++++++++
// get time signal and make a window overlay
//+++++++++++++++++++++++++++++++++++++++++++++++






//+++++++++++++++++++++++++++++++++++++++++++++++
//             calculate FFT
//+++++++++++++++++++++++++++++++++++++++++++++++
	
	//sort timevalues bitreversal
	for(i=0;i<FFT_LENGTH;i++)
	{
		freq_re[i]=SIGNAL1[bit_rev[i]];
		freq_im[i]=0;
	}



	//calculate complex spectral values (butterflies)
	for(l=1;l<=LEVEL;l++)
	{
		for(i=0;i<=((1<<(LEVEL-l))-1);i++)
		{
			for(j=0;j<=((1<<(l-1))-1);j++)
			{
				r = j + i* (1 << l);
				ar= j * (FFT_LENGTH >> l);
				v = 1 << (l-1);
				
				z1 = cos_tab[ar] * freq_re[r+v];
				z2 = cos_tab[ar] * freq_im[r+v];
				z3 = sin_tab[ar] * freq_re[r+v];
				z4 = sin_tab[ar] * freq_im[r+v];
				xr = freq_re[r] + z1 + z4;
				xi = freq_im[r] - z3 + z2;
				yr = freq_re[r] - z1 - z4;
				yi = freq_im[r] + z3 - z2;
				freq_re[r] = xr;
				freq_im[r] = xi;
				freq_re[r+v] = yr;
				freq_im[r+v] = yi;
			}
		}
	}



// copy and scale FFT to math-signal
	for (icnt = 0; icnt < 600; icnt++)
	 SIGNALM[icnt] = 1;
	 //SIGNALM[icnt] = FFTOffsetY;


	//Nur von der Hälfte der Frequenzpunkte den Betrag bilden,
	//da das halbe Spektrum gespiegelt ist
	for (i=0;i <= FFT_LENGTH/2+1;i++)
	{
		z1=freq_re[i]/FFT_LENGTH;
		z2=freq_im[i]/FFT_LENGTH;
		z3=(float)sqrt(pow((double)z1,2) + pow((double)z2,2));
		SIGNALM[i] = (char)z3;	// Betrag des Spektrums
	}






#ifdef _Debug_FFT_
    printf("copy fft to math ready \n");
    printf("fft ready\n");
#endif
}





