
#ifndef hardware_t_h
#define hardware_t_h

#include "nios.h"

class Hardware
{
public:	
	static void Init(void);	
    									// Init the WatchDog
	static void Reset_the_Watchdog(void);				// Resets the WatchDog
//	static void Restart_Record(void);				// Restart Recording
	static void Start_Record(void);                                 // Restart Recording	
	static void Stop_Record(void);				        // Stop Recording	
	static void Read_Version(void);                                 // Read out the hardware version
	static void Setup_Vars(void);					// Setup Variables with standart Values
	static void Setup_Hardware(void);				// Setup the Hardware
	static void Setup_Interrupts(void);                             // Setup the Interrupts
	static void Set_Vars_Default(void);                             // Set Vars to default values
	static char SearchZero(char channel, char level, int *DAC_Offset, int *ZeroSign);
    	static char SearchZeros(void);                                	// Search Signals for correct difference
//	static void GenerateFLASH(void);				// Generate FLASH content

//	Keyboard functions	
	static void DoEnableKeyInterrupt(void);				// Declare Enable PIO ISR
	static void DoDisableKeyInterrupt(void);			// Declare Disable PIO ISR
	static void ISR_KEY(int context);				// Declare Button Interrupt subroutine
	static void Buttonhandler(int MenuKey, char Pushedlong);	// Button Handler
	static void F1_Btnhandler(void);				// Button Handler for function button
	static void F2_Btnhandler(void);				// Button Handler for function button
	static void F3_Btnhandler(void);				// Button Handler for function button
	static void F4_Btnhandler(void);				// Button Handler for function button
	static void F5_Btnhandler(void);				// Button Handler for function button
	static void F6_Btnhandler(void);				// Button Handler for function button

	static char MenuButtonCheck(char BtnNr);			// Check the Menu Buttons (pushed) returns 1 if found one
	static void MenuPopupStep(int MenuPopupNr, short *MenuStatusNr, short *MenuStatusNr2, short *MenuStatusNr3, int DrawMenuNr, int start, char dir); //Updates Menupopup
	static void UpdateChannel(int channel, char active);		// Update all channel depended vars
	static void UpdateTrigger(char nr);				// Update the trigger modus
	
	static void Set_LED(int LED);					// Set LED On
	static void Reset_LED(int LED);					// Set LED Off
	static void Clear_LED(void);					// Clear all LED�s
	static void Send_LED(void);					// Send Shift Value for LED�s to Keyboard

	static void DoEnableRotInterrupt(void);				// Declare Enable PIO ISR
	static void DoDisableRotInterrupt(void);			// Declare Disable PIO ISR
	static void ISR_ROT(int context);				// Declare Button Interrupt subroutine
	static void Rotary_Interface(void);                             // Handle the Rotary Interupt
	static void ON_Rotary_Position(void);                           // Handle the Position Wheel
	static void ON_Trigger_Level(void);                             // Handle Trigger Level
	static void ON_Main_Wheel(void);                                // Handle
	static void ON_Timebase(void);                                  // Handle
	static void Recalc_Vars(void);                                  // Recalc ZFT...
	static void Recalc_Trigger(void);                               // Recalc pre_reg and Trigger Pos on Display
   	static void ON_Voltage_Channel_1(void);                         // Handle	
	static void ON_Zero_Channel_1(void);                            // Handle
	static void ON_Voltage_Channel_2(void);                         // Handle
	static void ON_Zero_Channel_2(void);                            // Handle
	static void ON_Voltage_Channel_3(void);                         // Handle
	static void ON_Zero_Channel_3(void);                            // Handle
	static void ON_Voltage_Channel_4(void);                         // Handle
	static void ON_Zero_Channel_4(void);                            // Handle
	static void Voltage_Zoom(unsigned char *OrgData, unsigned char *ZoomData, int NewVoltage, int OldVoltage, int ZeroLevel);

	static void Keyboard_Interface(void);                           // Handle the Keyboard Interupt
                    	
	static void HandleMainWheel(char Direction);			        // Main Wheel Handler
	static void DoEnableRotReadyInterrupt(void);					// Declare Enable PIO ISR
	static void DoDisableRotReadyInterrupt(void);					// Declare Disable PIO ISR
	static void ISR_ROTREADY(int context);							// Declare Button Interrupt subroutine

	static void DoEnableUARTInterrupt(void);						// Declare Enable UART2 ISR
	static void DoDisableUARTInterrupt(void);						// Declare Disable UART2 ISR
	static void ISR_UART(int context);								// Declare UART2 Interrupt subroutine
	
//**** Noch zu verbessern
	static void DoEnableUART2Interrupt(void);						// Declare Enable UART2 ISR
	static void DoDisableUART2Interrupt(void);						// Declare Disable UART2 ISR
	static void ISR_UART2(int context);								// Declare UART2 Interrupt subroutine
	static void InterpretUART(volatile unsigned char data[37]);		// Interpret the UART receiving
	static void SendData(volatile unsigned char Bytes[40]);			// Sends 37 Bytes to UART2	
	static void SendShot(void);					                    // Sends Screen Shot to PC	
	static void SendSWShot(void);					                    // Sends Screen Shot to PC		
	static void SendLayer(unsigned char LayerNr);					// Send a Layer through USB
	static void SendCtrlBlock(void);                                // Send the ctrl block through USB
	static void SendCtrlBlock2(void);                                // Send the ctrl block 2 through USB	
	static void SendCtrlBlock3(void);                                // Send the ctrl block 3 through USB		
//****
	static void DoEnableTimerInterrupt(void);						// Enable service routine
	static void DoDisableTimerInterrupt(void);						// Disable service routine
	static void Start_Timer1(void);						            // Start Timer1
	static void Stop_Timer1(void);						            // Stop Timer1
	static void ISR_TIMER(int context);								// Timer1 ISR for menu popups
	static void ResetTimer(void);									// Reset Timer

	static void DoEnableTimer2Interrupt(void);						// Enable service routine Timer2
	static void DoDisableTimer2Interrupt(void);						// Disable service routine Timer2
	static void ISR_TIMER2(int context);							// Timer2 ISR for menu popups
    static void Copy_in_asm(int cnt, unsigned char *DataArray_in, unsigned char *DataArray_out); // Copy the Roll Mode array 1 position
	static void DoEnableTimer3Interrupt(void);						// Enable service routine Timer3
	static void DoDisableTimer3Interrupt(void);						// Disable service routine Timer3
	static void ISR_TIMER3(int context);							// Timer3 ISR for menu popups

	static void SetSwitches(char channel, int voltage);				// Send Switches to ADCs
//**** Noch zu verbessern
	static void SetDacOffset(char channel);							// Set the DAC Offset of a Channel
	static void SetCHDacOffset(char channel);							// Set the DAC Offset of a Channel	
	static void SetupADC(void);										// Send Config Data to the ADCs
//****	
	static void WRITEADC(unsigned char which, unsigned long value);	// Write Value to ADC (which)
	static unsigned long READADC(unsigned char which);				// Read Value from ADC (which)
	
	static void PREPARE_READADC(unsigned char correct1, unsigned char correct2, unsigned char correct3, unsigned char correct4, unsigned int count); //Prepare registers for read_all
	static void READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed);
	static void READADC_ALL2(unsigned char which, unsigned long *DataArray1, unsigned int count);
	//static void READADC3_Average(unsigned char which, unsigned char *DataArray1, int AverageMax);
	static unsigned char EXTRACTADCVAL(unsigned char which, unsigned long value); 

	static void DoEnableADCInterrupt(void);							// Declare Enable ADC ISR
	static void DoDisableADCInterrupt(void);						// Declare Disable ADC ISR
	static void ISR_ADC_INT(int context);							// Declare ADC Interrupt subroutine
	static int Read_IRQ(void);                                      // red the status of the irq
	static void Handle_ADC(void);							        // Declare ADC Interrupt subroutine	
	static void ReadOut_Signal(char channel, unsigned long adr_read, unsigned long adr_written);
	static void Build_Trigo_Tables(void);
	static void Do_FFT(void);
	static void Do_Gen_Signal(void);	
	static void Do_Gen_Signal2(void);	

    	static int FindTrigger(unsigned char channel, unsigned char negativ, int TriggerPos);      // Search the Trigger
	static int AutoScale(void);                                       // Make Autoscale
	static int FindTimebase(char channel);                                       // Make Autoscale
	static int FindVoltage(char channel);                                       // Make Autoscale
	static void FindSlope(void);                                       // Make Autoscale	
	
	static void DoEnableReadVSyncInterrupt(void);					// Declare Enable ReadVSync ISR
	static void DoDisableReadVSyncInterrupt(void);					// Declare Disable ReadVSync ISR
	static void ISR_ReadVSync_INT(int context);						// Declare ReadVSync Interrupt subroutine

	static void TransferPlanes(void);                               // Transfer Backbuffer to Planes
	static void ClearPlanes(void);                               // Clears and Transfer Backbuffer to Planes
	static void TransferDataPlane_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1);
	static void TransferPlane_Set_Buffer_Adr(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2);
	static void TransferPlanes_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
    static void TransferPlanes_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
    static void TransferPlanes_clear_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count);
    static void Planes_clear_asm(unsigned long Buffer_Adr1);
	static void Planes_clear_asm_all(unsigned char count, unsigned long Buffer_Adr1, unsigned long Buffer_Adr2, unsigned long Buffer_Adr3, unsigned long Buffer_Adr4, unsigned long Buffer_Adr5);
    static void DoEnableLogicAnalyserInterrupt(void);	            // Declare Enable LogicAnalyser ISR
	static void DoDisableLogicAnalyserInterrupt(void);	            // Declare Disable LogicAnalyser ISR
	static void ISR_LogicAnalyser(int context);	                    // Declare LogicAnalyser Interrupt subroutine
	static int TestFir(void);
	
};



#endif //tc_classes_h
