/*
Developed by Oliver Gorzellik at Wittig Technologies AG (c) 2005-2007
Review partial by Thomas M. Wittig (TMW) from June 2008
TMW: "Some bugs found, not easy to understand software structure"
TMW: "All to be improved!!!"
-------------------------------------------------------------------------------------------------------------------------
Open source development
-------------------------------------------------------------------------------------------------------------------------
Author	:	Hayo.W (blueflash)
Sign	:	BF
Date	:	05.Nov.2008
version	:	1.2.BF.0.1

-------------------------------------------------------------------------------------------------------------------------
Open source development history
-------------------------------------------------------------------------------------------------------------------------
| 05.Nov.2008 | 1.2.BF.0.1   | New FFT implementation prototype - no function yet
| 06.Nov.2008 | 1.2.BF.0.5   | Changed grid division and size (from 600 x 384 to 600 x 400)
| 09.Nov.2008 | 1.2.BF.0.6   | New grid for XY-Mode, changed offsets and calculating values due to
|             |              | the new grid dimension and divisions. Replaced numeric values with
|             |              | global defined constants for better maintainance.
|             |              | Testing two different grid layouts (standard oszi with solid lines versus
|             |              | proprietary layout with dotted lines). Optional switching via menue maybe an idea.
| 10.Nov.2008 | 1.2.BF.0.7   | Fixed some offsets and test some other rotary timings
| 10.Nov.2008 | 1.2.BF.0.8   | Fixed some offsets and test some other rotary timings
| 10.Nov.2008 | 1.2.BF.0.9   | New Grid for delayed mode with dimension 600 x 400 - takes no effect because of loading
|             |              | the grid from flash
| 11.Nov.2008 | 1.2.BF.0.10  | Fixed some values in the grids and planes, direct draw of delayed grid - no flash load
| 11.Nov.2008 | 1.2.BF.0.11  | Draw new startscreen after setup default values, reactivated UIPlane3 in function
|             |              | ClearMenuItem()
| 12.Nov.2008 | 1.2.BF.0.12  | New button handler functions for function keys 1 - 6 in main button handler for better
|	      |              | readable structure.
|             |              | Test if grids are loaded from flash - switch off grid drawing
| 12.Nov.2008 | 1.2.BF.0.13  | No flashloading for the grids anymore, all grids are drawn directly
| 13.Nov.2008 | 1.2.BF.0.14  | Changed menu structure for switching Main/Delayed/XY mode, fixed failure in delayed grid
| 13.Nov.2008 | 1.2.BF.0.15  | Added LED test in Hardware init routine
| 14.Nov.2008 | 1.2.BF.0.16  | Fixed grid overwriting when popdown is called 
| 14.Nov.2008 | 1.2.BF.0.17  | Changed LED test, change some calculations in Cursor function to fix x-cursor offset,
|             |              | corrected Voltage offset due to new grid dimension,
| 14.Nov.2008 | 1.2.BF.0.18  | Corrected trigger cursor position in delayed window, added comments for better understanding
--------------------------------------------------------------------------------------------------------------------------
*/


#include "tc_vars.h"
// Constants


// Versions numbers
unsigned long tc_varstart =		0xAABBCCDD;		// Kennung Varstart
unsigned long tc_version = 		0x00000001;		// Factory version 	1 
unsigned long tc_subversion = 		0x00000002;		// Factory subversion 	2
unsigned long tc_dev_version = 		0x00000000;		// Developer version
unsigned long tc_dev_subversion = 	0x00000012;		// Developer subversion
unsigned long tc_hw_sw_version =	0x00000000;		// Type 		0 = W2012 1 = W2014 2 = W2022 3 = W2024
unsigned long tc_hw_version = 		0x00000000;		// Hardware version


unsigned long tc_model = 	     	0x00000000;		// 2012, 2022 ...
unsigned long tc_serial = 	     	0x00000000;		// 1
unsigned long tc_production_lot1 =   	0x00000020;		// E
unsigned long tc_production_lot2 =   	0x00000020;		// E
unsigned long tc_shipment_date =     	0x00000000;		// 2C7


const unsigned char  C_GROUND_SIGN	= (unsigned char) 134;
const unsigned char  C_MENU_SELECT_SIGN	= (unsigned char) 137;

const unsigned char Colors[7][3] = {	{0x0A, 0x0F, 0x2F}, 	// Yellow ( 10, 15, 47 )
					{0x28, 0x3C, 0x3E}, 	// Cyan	  ( 40, 60, 62 )
					{0x11, 0x23, 0x26}, 	// Purple ( 17, 35, 38 )
					{0x04, 0x08, 0x0C}, 	// Green  ( 4, 8, 12 )
					{0x01, 0x02, 0x03}, 	// Red	  ( 1, 2, 3 )
					{0x10, 0x20, 0x30}, 	// Blue	  ( 16, 32, 48 )	
	  				{0x00, 0x2A, 0x3F}}; 	// Black 0 , Gray , White 63 

const unsigned char clYellow 		= 0x2F;
const unsigned char clCyan   		= 0x3E;
const unsigned char clPurple 		= 0x26;
const unsigned char clGreen 		= 0x0C;
const unsigned char clRed    		= 0x03;
const unsigned char clBlue   		= 0x30;
const unsigned char clBlack  		= 0x00;
const unsigned char clGray   		= 0x2A;
const unsigned char clDarkGray   	= 0x15;
const unsigned char clWhite  		= 0x3F;	
const unsigned char clOrange 		= 0x0B;

const unsigned char clCHI    		= 0x0F;
const unsigned char clCHII   		= 0x0C;
const unsigned char clCHIII  		= 0x33;
const unsigned char clCHIV   		= 0x13;

const unsigned char clBackground 	= 0x00;
const unsigned char clFrame 		= 0x1A;//0x14;
const unsigned char clButton 		= 0x0A;//0x0C;

const unsigned char clCursor 		= 0x0B;

const unsigned char btnUnpushed		= 0x00;
const unsigned char btnPushed 		= 0x01;

const unsigned char btnDraw		= 0x00;
const unsigned char btnRemove 		= 0x01;

const unsigned long BitMasks[32] = {	0x7FFFFFFF, 0xBFFFFFFF, 0xDFFFFFFF, 0xEFFFFFFF,
					0xF7FFFFFF, 0xFBFFFFFF, 0xFDFFFFFF, 0xFEFFFFFF,
					0xFF7FFFFF, 0xFFBFFFFF, 0xFFDFFFFF, 0xFFEFFFFF,
					0xFFF7FFFF, 0xFFFBFFFF, 0xFFFDFFFF, 0xFFFEFFFF,
					0xFFFF7FFF, 0xFFFFBFFF, 0xFFFFDFFF, 0xFFFFEFFF,
					0xFFFFF7FF, 0xFFFFFBFF, 0xFFFFFDFF, 0xFFFFFEFF,
					0xFFFFFF7F, 0xFFFFFFBF, 0xFFFFFFDF, 0xFFFFFFEF,
					0xFFFFFFF7, 0xFFFFFFFB, 0xFFFFFFFD, 0xFFFFFFFE};
								
const unsigned long BitMasks2[32] = {	0x80000000, 0x40000000, 0x20000000, 0x10000000,
					0x08000000, 0x04000000, 0x02000000, 0x01000000,
					0x00800000, 0x00400000, 0x00200000, 0x00100000,
					0x00080000, 0x00040000, 0x00020000, 0x00010000,
					0x00008000, 0x00004000, 0x00002000, 0x00001000,
					0x00000800, 0x00000400, 0x00000200, 0x00000100,
					0x00000080, 0x00000040, 0x00000020, 0x00000010,
					0x00000008, 0x00000004, 0x00000002, 0x00000001};

// Constants
const int DrawOffsetX 		= GRID_XOFFS;				// Draw Offset from Left
const int DrawOffsetY 		= GRID_YOFFS;				// Draw Offset from Top
const int DrawXYOffsetX1 	= GRID_YOFFS + (GRID_XY / 2);		//59;	//?????	// Draw Offset from Top
const int DrawXYOffsetX2 	= GRID_XY_XOFFS + (GRID_XY / 2);	//541;	//?????	// Draw Offset from Left
const int SignalOffset 		= 256;					// Signal Offset , half Signal
//const int PreReg_Offset = 40;						// Signal Offset , half Signal
int PreReg_Offset 		= 35;					// Signal Offset , half Signal

const int FFTOffsetY = 224;				//?????		// Draw Offset from Left

const int CH1OffsetX = 0;						// Draw Offset from Left
const int CH2OffsetX = 0;	//10; BF				// Draw Offset from Left
const int CH3OffsetX = 0;						// Draw Offset from Left
const int CH4OffsetX = 0;						// Draw Offset from Left

// correction = SignalOffset - DrawOffset
const int correction = 18;  //18;					// Draw Correction for the Signals

const int timerAutoFreefirst = 12500000;				// Trigger Auto Timer 100 ms -> wird array der timebases
const int timerAutoFreefast  = 12500000;				// Trigger Auto Timer 10 ms

unsigned long timer_counter_value = 1;
unsigned long timer_counter_max   = 1;

int timer_reload_low  = 0;
int timer_reload_high = 0;

unsigned long timer_array_first[32]={ 12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                      12500000,
                                      25000000,
                                      50000000,
                                     125000000,
                                     250000000,
                                     500000000,
                                     125000000,
                                     250000000,
                                     500000000,
                                     125000000,
                                     250000000};
                                    
unsigned long timer_array_fast[32] = {1250000,
                                      2500000,
                                      5000000,
                                      1250000,
                                      2500000,
                                      5000000,
                                      1250000,
                                      2500000,
                                      5000000,
                                      1250000,
                                      2500000,
                                      5000000,
                                      1250000,
                                      2500000,
                                      5000000,
                                     12500000,
                                     25000000,
                                     50000000,
                                     12500000,
                                     25000000,
                                     50000000,
                                     12500000,
                                     25000000,
                                     50000000,
                                    125000000,
                                    250000000,
                                    500000000,
                                    125000000,
                                    250000000,
                                    500000000,
                                    125000000,
                                    250000000};
                                      

//const int timerAutoFreefirst = 1250000;							// Trigger Auto Timer 100 ms -> wird array der timebases
//const int timerAutoFreefast  = 125000;							// Trigger Auto Timer 10 ms

const int timerrotPeriod     = 25000000;	//25000000; BF					// Rotary change timer
const int timersecPeriod     = 12500000;	//12500000; BF					// Statusbar display time


const unsigned long tb_value[32] = {0xFFFFFFFF,		//	2 nS
                                    0xFFFFFFFF,		//	5 nS
                                    0xFFFFFFFF,		//	10 nS
                                    0xFFFFFFFF,		//	20 nS
                                    0xFFFFFFFF,		//	50 nS
				    0xFFFFFFFE,		//	100 nS
				    0xFFFFFFFD,		//	200 nS
				    0xFFFFFFFC,		//	500 nS
				    0xFFFFFFFB,		//	2 �S
				    0xFFFFFFFB,		//	2 �S
				    0xFFFFFFF3,		//	5 �S
				    0xFFFFFFE7,		//	10 �S
				    0xFFFFFFCE,		//	20 �S
				    0xFFFFFF83,		//	50 �S
				    0xFFFFFF06,		//	100 �S
				    0xFFFFFE0C,		//	200 �S
				    0xFFFFFB1E,		//	500 �S
				    0xFFFFF63C,		//	1 mS
				    0xFFFFEC78,		//	2 mS
				    0xFFFFCF2C,		//	5 mS
				    0xFFFF9E58,		//	10 mS
				    0xFFFF3CB0,		//	20 mS
				    0xFFFE17B8,		//	50 mS
                                    0xFFFC2F70,		//	100 mS
                                    0xFFF85EE0,		//	200 mS
                                    0xFFECED30,		//	500 mS
				    0xFFD9Da60,		//	1 S									
				    0xFFB3B4C0,		//	2 S
				    0xFF4143E0,		//	5 S
				    0xFFFFFFFF,		//	10 S
				    0xFFFFFFFF,		//	20 S
				    0xFFFFFFFF};	//	50 S
                                                    					
const unsigned int rollmode_value[9] = {  125000,	//500 mS
                                          250000,	//1 S
                                          500000,	//2 S
                                         1250000,	//5 S
                                         2500000,	//10 S
                                         5000000,	//20 S
                                        12500000,	//50 S
                                        25000000,	//100 S
                                        50000000};	//200 S

// BF CHANGED									
const unsigned int voltage_offsets[12] = {8192, 8192, 8192,
                                          8192, 7921, 7279,
                                          8192, 7921, 7279,
                                          8192, 7921, 7279};
/*
const unsigned int voltage_offsets[12] = {8096, 8096, 8096,
                                          8096, 7921, 7279,
                                          8096, 7921, 7279,
                                          8096, 7921, 7279};
*/ //BF END
const float voltage_factor[12] = {1.047, 1.047, 1.047,
                                  1.047, 2.021, 5.065,
                                  1.047, 2.021, 5.065,
                                  1.047, 2.021, 5.065};
                                                                             /*
const unsigned int voltage_relevat[21] = {      1,       2,       5,
                                               10,      20,      50,
                                              100,     200,     500,
                                             1000,    2000,    5000,
                                            10000,   20000,   50000,
                                           100000,  200000,  500000,
                                          1000000, 2000000, 5000000};      */
                                          
                              // Probe / Selected Voltage - 3
const unsigned int voltage_relevat[10][9] = {{  0,  1,  4,  5,  6,  9, 10, 11, 14},  // 1:1
                                             {  1,  3,  5,  6,  8, 10, 11, 13, 15},  // 1:2
                                             {  4,  5,  7,  9, 10, 12, 14, 15, 17},  // 1:5
                                             {  5,  6,  9, 10, 11, 14, 15, 16, 19},  // 1:10
                                             {  6,  8, 10, 11, 13, 15, 16, 18, 20},  // 1:20
                                             {  9, 10, 12, 14, 15, 17, 19, 20, 22},  // 1:50
                                             { 10, 11, 14, 15, 16, 19, 20, 21, 24},  // 1:100
                                             { 11, 13, 15, 16, 18, 20, 21, 23, 25},  // 1:200
                                             { 14, 15, 17, 19, 20, 22, 24, 25, 27},  // 1:500
                                             { 15, 16, 19, 20, 21, 24, 25, 26, 29}}; // 1:1000



const unsigned char GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};

const unsigned int Splash_Logo_PosX = 275;
const unsigned int Splash_Logo_PosY = 60;

const unsigned int Splash_Data_PosX = 200;
const unsigned int Splash_Data_PosY = 200;

const short SIG_Start_Stop[20][2]= {{  8042,  8342},      // 0 = 0,5    =>   300
                                    {  7892,  8492},      // 1 = 1      =>   600
                                    {  7592,  8792},      // 2 = 2      =>  1200
                                    {  7442,  8942},      // 3 = 2,5    =>  1500
                                    {  6992,  9392},      // 4 = 4      =>  2400
                                    {  6692,  9692},      // 5 = 5      =>  3000
                                    {  5192, 11192},      // 6 = 10     =>  6000
                                    {  2192, 14192},      // 7 = 20     => 12000
                                    {   692, 15692},      // 8 = 25     => 15000
                                    {  8117,  8267},      // 9 = 0,2    => 150
                                    
                                    {  1898,  2198},      // 10 = 0,5    =>   300
                                    {  1748,  2348},      // 11 = 1      =>   600
                                    {  1448,  2648},      // 12 = 2      =>  1200
                                    {  1298,  2798},      // 13 = 2,5    =>  1500
                                    {   848,  3248},      // 14 = 4      =>  2400
                                    {   548,  3548},      // 15 = 5      =>  3000
                                    {     0,     0},      // 16 = 10     =>  6000
                                    {     0,     0},      // 17 = 20     => 12000
                                    {     0,     0},      // 18 = 25     => 15000
                                    {  1973,  2123}};     // 19 = 0,2    => 150

const short SIG_Size[20]= {  300,
                             600,
                            1200,
                            1500,
                            2400,
                            3000,
                            6000,
                           12000,
                           15000,
                             150,
                             300,
                             600,
                            1200,
                            1500,
                            2400,
                            3000,
                            6000,
                            1200,
                            1500,
                             150};


const float Zoom_Faktor_Table[20] = { 0.4, 1, 2, 3, 4, 5, 10, 20, 25, 0.2,  0.4, 1, 2, 3, 4, 5, 10, 20, 25, 0.2};

float ZFT_float = 1;
float ZFT_float_old = 1;
float ZFT_float_dmode = 1;
float ZFT_float_dmode_old = 1;

const float Offset_Faktor_Table[20] = { 26.75, 26.30666, 25.30666, 24.80666, 23.3, 22.30666, 17.30666, 7.30666, 2.31, 27,   6.32666, 5.82666, 4.82666, 4.32666, 2.82666, 1.82666, 1, 1, 1, 6.57666};

float OFT_float = 26.30666;
float OFT_float_old = 26.30666;

const short Zoom_Index_Table[32][5] = {{  1,  3,  5,  6,  8},  //  0 = 2 ns
                                       {  1,  2,  4,  6,  7},  //  1 = 5 ns
                                       {  9,  0,  1,  2,  5},  //  2 = 10 ns
                                       {  0,  1,  3,  5,  6},  //  3 = 20 ns
                                       {  1,  2,  4,  6,  7},  //  4 = 50 ns
                                       {  1,  2,  5,  6,  7},  //  5 = 100 ns
                                       {  1,  3,  5,  6,  8},  //  6 = 200 ns
                                       { 11, 12, 14, 16, 17},  //  7 = 500 ns
                                       { 11, 12, 15, 16, 17},  //  8 = 1 �s
                                       { 11, 13, 15, 16, 18},  //  9 = 2 �s
                                       { 11, 12, 14, 16, 17},  // 10 = 5 �s
                                       { 11, 12, 15, 16, 17},  // 11 = 10 �s
                                       { 11, 13, 15, 16, 18},  // 12 = 20 �s
                                       { 11, 12, 14, 16, 17},  // 13 = 50 �s
                                       { 11, 12, 15, 16, 17},  // 14 = 100 �s
                                       { 11, 13, 15, 16, 18},  // 15 = 200 �s
                                       { 11, 12, 14, 16, 17},  // 16 = 500 �s
                                       { 11, 12, 15, 16, 17},  // 17 = 1 ms
                                       { 11, 13, 15, 16, 18},  // 18 = 2 ms
                                       { 11, 12, 14, 16, 17},  // 19 = 5 ms
                                       { 11, 12, 15, 16, 17},  // 20 = 10 ms
                                       { 11, 13, 15, 16, 18},  // 21 = 20 ms
                                       { 11, 12, 14, 16, 17},  // 22 = 50 ms
                                       { 11, 12, 15, 16, 17},  // 23 = 100 ms
                                       { 11, 13, 15, 16, 18},  // 24 = 200 ms
                                       { 11, 12, 14, 16, 17},  // 25 = 500 ms
                                       { 11, 12, 15, 16, 17},  // 26 = 1 s
                                       { 11, 13, 15, 16, 18},  // 27 = 2 s
                                       { 11, 12, 14, 16, 17},  // 28 = 5 s
                                       { 11, 12, 15, 16, 17},  // 29 = 10 s
                                       { 11, 13, 15, 16, 18},  // 30 = 20 s
                                       { 11, 12, 14, 16, 17}}; // 31 = 50 s
                                       
short ZIT_short = 1;
short ZIT_short_old = 1;
short ZIT_short_dmode = 1;
short ZIT_short_dmode_old = 1;
/*
const float PreTrigger_Offset_Table[32][5] = {{  20, 35, 60, 80, 80},  // 2 ns
                                              {  20, 35, 60, 80, 80},  // 5 ns
                                              {  20, 35, 60, 80, 80},  // 10 ns
                                              {  30, 35, 60, 80, 80},  // 20 ns
                                              {  28, 38, 68, 100, 130},  // 50 ns
                                              {  28, 38, 68, 100, 130},  // 100 ns
                                              {  20, 38, 68, 100, 130},  // 200 ns
                                              {  20, 35, 60, 80, 80},  // 500 ns
                                              {  20, 35, 60, 80, 80},  // 1 �s
                                              {  20, 35, 60, 80, 80},  // 2 �s
                                              {  20, 40, 60, 80, 80},  // 5 �s
                                              {  20, 40, 60, 80, 80},  // 10 �s
                                              {  20, 40, 60, 80, 80},  // 20 �s
                                              {  20, 40, 60, 80, 80},  // 50 �s
                                              {  20, 40, 60, 80, 80},  // 100 �s
                                              {  20, 40, 60, 80, 80},  // 200 �s
                                              {  20, 40, 60, 80, 80},  // 500 �s
                                              {  20, 40, 60, 80, 80},  // 1 ms
                                              {  20, 40, 60, 80, 80},  // 2 ms
                                              {  20, 40, 60, 80, 80},  // 5 ms
                                              {  20, 40, 60, 80, 80},  // 10 ms
                                              {  20, 40, 60, 80, 80},  // 20 ms
                                              {  20, 40, 60, 80, 80},  // 50 ms
                                              {  20, 40, 60, 80, 80},  // 100 ms
                                              {  20, 40, 60, 80, 80},  // 200 ms
                                              {  20, 40, 60, 80, 80},  // 500 ms
                                              {  20, 40, 60, 80, 80},  // 1 s
                                              {  20, 40, 60, 80, 80},  // 2 s
                                              {  20, 40, 60, 80, 80},  // 5 s
                                              {  20, 40, 60, 80, 80},  // 10 s
                                              {  20, 40, 60, 80, 80},  // 20 s
                                              {  20, 40, 60, 80, 80}}; // 50 s

*/
/*

const short SIG_Start_Stop[10][2]= {{  8042,  8342},      // 0 = 0,5    =>   300
                                    {  7892,  8492},      // 1 = 1      =>   600
                                    {  7592,  8792},      // 2 = 2      =>  1200
                                    {  7442,  8942},      // 3 = 2,5    =>  1500
                                    {  6992,  9392},      // 4 = 4      =>  2400
                                    {  6692,  9692},      // 5 = 5      =>  3000
                                    {  5192, 11192},      // 6 = 10     =>  6000
                                    {  2192, 14192},      // 7 = 20     => 12000
                                    {   692, 15692},      // 8 = 25     => 15000
                                    {  8117,  8267}};     // 9 = 0,2    => 150


const float Zoom_Faktor_Table[10] = { 0.4, 1, 2, 3, 4, 5, 10, 20, 25, 0.2};

const float Offset_Faktor_Table[10] = { 26.75, 26.30666, 25.30666, 24.80666, 23.3, 22.30666, 17.30666, 7.30666, 2.31, 27};

const short Zoom_Index_Table[32][5] = {{ 1, 3, 5, 6, 8},  // 2 ns
                                       { 1, 2, 4, 6, 7},  // 5 ns
                                       { 9, 0, 1, 2, 5},  // 10 ns
                                       { 0, 1, 3, 5, 6},  // 20 ns
                                       { 1, 2, 4, 6, 7},  // 50 ns
                                       { 1, 2, 5, 6, 7},  // 100 ns
                                       { 1, 3, 5, 6, 8},  // 200 ns
                                       { 1, 2, 4, 6, 7},  // 500 ns
                                       { 1, 2, 5, 6, 7},  // 1 �s
                                       { 1, 3, 5, 6, 8},  // 2 �s
                                       { 1, 2, 4, 6, 7},  // 5 �s
                                       { 1, 2, 5, 6, 7},  // 10 �s
                                       { 1, 3, 5, 6, 8},  // 20 �s
                                       { 1, 2, 4, 6, 7},  // 50 �s
                                       { 1, 2, 5, 6, 7},  // 100 �s
                                       { 1, 3, 5, 6, 8},  // 200 �s
                                       { 1, 2, 4, 6, 7},  // 500 �s
                                       { 1, 2, 5, 6, 7},  // 1 ms
                                       { 1, 3, 5, 6, 8},  // 2 ms
                                       { 1, 2, 4, 6, 7},  // 5 ms
                                       { 1, 2, 5, 6, 7},  // 10 ms
                                       { 1, 3, 5, 6, 8},  // 20 ms
                                       { 1, 2, 4, 6, 7},  // 50 ms
                                       { 1, 2, 5, 6, 7},  // 100 ms
                                       { 1, 3, 5, 6, 8},  // 200 ms
                                       { 1, 2, 4, 6, 7},  // 500 ms
                                       { 1, 2, 5, 6, 7},  // 1 s
                                       { 1, 3, 5, 6, 8},  // 2 s
                                       { 1, 2, 4, 6, 7},  // 5 s
                                       { 1, 2, 5, 6, 7},  // 10 s
                                       { 1, 3, 5, 6, 8},  // 20 s
                                       { 1, 2, 4, 6, 7}}; // 50 s
*/
/*                                                                                     // 0
const int Extern_Trigger_Values[29] = { 7,  9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 21, 22, 23, 24,
                                       25, 26, 27, 28, 29, 32, 35, 38, 41, 44, 49, 52, 57, 62};

const float Extern_Trigger_Strs[29] = {-10.0, -9.0, -8.0, -7.2, -6.4, -5.6, -4.8, -4.0, -3.2, -2.4, -1.6, -1.2, -0.8, -0.4, 0,
                                         0.4,  0.8,  1.2,  1.6,  2.4,  3.2,  4.0,  4.8,  5.6,  6.4,  7.2,  8.0,  9.0, 10.0};
*/

const int Extern_Trigger_Values[33] = {0x40, 0x44, 0x48, 0x4C, 0x50, 0x54, 0x58, 0x5C, 0x60, 0x64, 0x68, 0x6C, 0x70, 0x74, 0x78, 0x7C,
                                       0x80, 0x84, 0x88, 0x8C, 0x90, 0x94, 0x98, 0x9C, 0xA0, 0xA4, 0xA8, 0xAC, 0xB0, 0xB4, 0xB8, 0xBC, 0xC0};

const float Extern_Trigger_Strs[33] = {-2.5, -2.4, -2.2, -2.0, -1.8, -1.6, -1.5, -1.4, -1.3, -1.1, -1.0, -0.9, -0.8, -0.6, -0.4, -0.2,
                                        0.0,  0.2,  0.4,  0.6,  0.8,  0.9,  1.0,  1.1,  1.3,  1.4,  1.5,  1.6,  1.8,  2.0,  2.2,  2.4,  2.5};
                                         
unsigned long tc_test_var = 0x00000000;
unsigned long tc_test_var2 = 0x00000000;

// testdata

unsigned char DrawSignal = 1;

unsigned char keyboard_found = 0;
unsigned long slope_value = 0;

double Test_Slip = 192.0;
int Test_Range = 1;

bool Transfer_man_data = false;
/*
0 = undetected
1 = no keyboard
2 = Power on Boot
3 = Reset on Boot
4 = Keyboard detected
*/

unsigned long *prog_flash_adr;
unsigned long prog_flash_adress;
unsigned char prog_flash_length;
unsigned long prog_flash_offset;
unsigned char Flash_Read_Buffer[1024];
unsigned long Flash_Protect_Buffer[256];
	
volatile unsigned char config_loaded = false;
unsigned char init_done = false;
unsigned char config_changed = false;
unsigned char first_start = false;

unsigned char GridColorArrayPos = 3;
unsigned char GridColor_Val = 0x3F;
unsigned char GridColor_Val_Delayed = 0x15;
unsigned char GridColorArrayPos_Delayed = 2;

unsigned char WT_Logo_Color_Val = 0x31;		//0x10 / 0x21 / 0x31 

int TestInt = 0;
long TestLong = 0;

unsigned char Test_Mode      = false;
unsigned char ADC_Debug_Mode = false;     	// If true than printf ADC Debug information
unsigned char Debug_Mode     = false;         	// If true than printf Debug information
unsigned char Command_Mode   = false;         	// If true than printf Command information
unsigned char Calc_Mode      = true;
unsigned char ExtraTrg_Mode  = false;
volatile unsigned char Search_Mode = false;
volatile unsigned char Search_Auto = false;

bool screen_sel = 0;
bool screen_sel_old = 1;

unsigned char volt_filter_Mode = 0x00;        // CH1 Bit 0 / CH2 Bit 1 / CH3 Bit 2 / CH4 Bit 3
unsigned char m2k_filter_Mode = 0x00;        // CH1 Bit 0 / CH2 Bit 1 / CH3 Bit 2 / CH4 Bit 3
unsigned int zeros_filter_Mode = 0x0000;    // CH1 mem 1 Bit 0 / CH1 mem 2 Bit 1 / CH1 mem 3 Bit 2 / CH1 mem 4 Bit 3
                                            // CH2 mem 1 Bit 4 / CH2 mem 2 Bit 5 / CH2 mem 3 Bit 6 / CH2 mem 4 Bit 7 ...

unsigned int kill_adc = 0x0000;             // CH1 adc 1 Bit 0 / CH1 adc 2 Bit 1 / CH1 adc 3 Bit 2 / CH1 adc 4 Bit 3
                                            // CH2 adc 1 Bit 4 / CH2 adc 2 Bit 5 / CH2 adc 3 Bit 6 / CH2 adc 4 Bit 7 ...


unsigned char OneShotRestart = false;       // If set only one shot after restart.

unsigned char Splash_drawed = false;
unsigned char Splash_removed = false;

volatile unsigned char Search_Channel = 0;
volatile unsigned char Search_Step = 0;
volatile unsigned char Search_Bad_Sig_cnt = 0;
volatile unsigned char Search_Hidden = 0;

volatile unsigned char adc_started = false;
volatile unsigned char AutoFreeRun = false;
volatile unsigned char AutoSearchTrigger = false;
volatile unsigned char AutoTimerOff = false;

int Average_Max = 1;
int Average_Cnt = 0;

unsigned char Connect_Vals = true;

unsigned char signal_zoomed1 = false;
unsigned char signal_zoomed2 = false;
unsigned char signal_zoomed3 = false;
unsigned char signal_zoomed4 = false;

// Signals per Second
volatile unsigned long calc_counter = 0;
volatile unsigned int sps_counter = 0;
volatile unsigned int vs_counter = 0;

//Quick Logic
unsigned int ctrl_reg = 0x00A3;				//0x0003;
unsigned int adc_ctrl_reg = 0x01C0;			//0;
unsigned int adc_del_reg = 0;
unsigned int pre_reg = 0x0000;				//0x004C;
unsigned int trg_val_reg = 0x00A0;			//0;
unsigned int trg_hyst_reg = 0x0090;			//0;
unsigned int ext_trg_val_reg = 0x80;		//0;
unsigned int triggering = 0x00;				//2;
unsigned int channel_Adr_add = 0x0000;
unsigned int channel_Adr_add2 = 0x0000;

unsigned int trg_val_CHI_reg = 0x00A0;			//0;
unsigned int trg_val_CHII_reg = 0x00A0;			//0;
unsigned int trg_val_CHIII_reg = 0x00A0;			//0;
unsigned int trg_val_CHIV_reg = 0x00A0;			//0;

unsigned int trig_range_reg = 0;
unsigned int trig_width_reg = 0x0001;		//0;

unsigned long trig_holdoff_reg = 0x00000000;

volatile long buffer_addr = 0;	
volatile long buffer_peak = 0;	
volatile long buffer_witten = 0;	
volatile long buffer_long = 0;	
volatile long buffer_adradd = 0;
	
int HoldOff_Value = 0;
int HoldOff_Expo = 1;   //ns
int HoldOff_Steps = 40;

int Pulse11_Value = 16;
int Pulse11_Expo = 1;   //ns
int Pulse11_Steps = 8;

int Pulse12_Value = 8;
int Pulse12_Expo = 1;   //ns
int Pulse12_Steps = 8;

int Pulse21_Value = 16;
int Pulse21_Expo = 1;   //ns
int Pulse21_Steps = 8;

int Pulse22_Value = 16;
int Pulse22_Expo = 1;   //ns
int Pulse22_Steps = 8;

float Math_Off_Mul_Value = 10;
int Math_Off_Mul_Value_int = 10;
int Math_Off_Mul_Expo = 1;   //ns
float Math_Off_Mul_Steps = 1;

float Math_Off_Sub_Value = 10;
int Math_Off_Sub_Value_int = 10;
int Math_Off_Sub_Expo = 1;   //ns
float Math_Off_Sub_Steps = 1;

float Math_Off_Add_Value = 10;
int Math_Off_Add_Value_int = 10;
int Math_Off_Add_Expo = 1;   //ns
float Math_Off_Add_Steps = 1;

/*
int Math_Off_Mul_Value = 10;
int Math_Off_Mul_Expo = 1;   //ns
int Math_Off_Mul_Steps = 1;

int Math_Off_Sub_Value = 10;
int Math_Off_Sub_Expo = 1;   //ns
int Math_Off_Sub_Steps = 1;

int Math_Off_Add_Value = 10;
int Math_Off_Add_Expo = 1;   //ns
int Math_Off_Add_Steps = 1;
*/

unsigned long adc_change12_reg = 0x00000000;
unsigned long adc_change34_reg = 0x00000000;
unsigned long adc_ctr12_reg = 0x00000000;
unsigned long adc_ctr34_reg = 0x00000000;

unsigned long timebase_reg = 0xFFFFFFFF;	//0xFFFFFFF8;
unsigned long ram_adress_reg = 0;

unsigned int test_port_reg = 0;

// Backup Vars
unsigned int triggering_bak = 0;
unsigned int ctrl_reg_bak = 0;
unsigned int adc_ctrl_reg_bak = 0;
unsigned long timebase_reg_bak = 0;
unsigned int pre_reg_bak = 0;
unsigned int channel_Adr_add_bak = 0;
unsigned int trg_val_reg_bak = 0;
unsigned int trg_hyst_reg_bak = 0;
unsigned int trig_range_reg_bak = 0;
unsigned long trig_holdoff_reg_bak = 0;
unsigned int trig_width_reg_bak = 0;
unsigned char GridColor_Val_bak = 0;
unsigned long adc_change12_reg_bak = 0;
unsigned long adc_change34_reg_bak = 0;

char Selected_Voltage_CH1_bak = 0;
char Selected_Voltage_CH2_bak = 0;
char Selected_Voltage_CH3_bak = 0;
char Selected_Voltage_CH4_bak = 0;

int ZeroLevelCH1_bak = 0;
int ZeroLevelCH2_bak = 0;
int ZeroLevelCH3_bak = 0;
int ZeroLevelCH4_bak = 0;

int Virtual_ZeroLevelCH1_bak = 0;
int Virtual_ZeroLevelCH2_bak = 0;
int Virtual_ZeroLevelCH3_bak = 0;
int Virtual_ZeroLevelCH4_bak = 0;

int ZeroLevelCH1_cor_offset = 0;
int ZeroLevelCH2_cor_offset = 0;
int ZeroLevelCH3_cor_offset = 0;
int ZeroLevelCH4_cor_offset = 0;

int ZeroLevelCH1_XY_bak = 0;
int ZeroLevelCH2_XY_bak = 0;
int VZeroLevelCH1_XY_bak = 0;
int VZeroLevelCH2_XY_bak = 0;

int Trigger_Pos_CH1_bak = 0;										// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2_bak = 0;										// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3_bak = 0;										// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4_bak = 0;

int Timebase_Offset_Pos_bak = 0;
int Trigger_Offset_Pos_bak = 0;

int AC_CH1_bak = 0;
int AC_CH2_bak = 0;
int AC_CH3_bak = 0;
int AC_CH4_bak = 0;

int Invert_CH1_bak = 0;
int Invert_CH2_bak = 0;
int Invert_CH3_bak = 0;
int Invert_CH4_bak = 0;

int MAINMODE_bak = 0;
int ROLLMODE_bak = 0;
int ROLLMODESTARTED_bak = 0;

int AUTOMODE_bak = 0;

int Acquire_bak_0 = 0;
int Acquire_bak_1 = 0;

volatile int HistoMax_1 = 0;
volatile int HistoMax_2 = 0;	
volatile int HistoSt_1 = 0;
volatile int HistoSt_2 = 0;
volatile int HistoDiv = 0;

char  Selected_Timebase_bak;                                          	// 10 �S // 500 nS
short SIGNALFaktor_idx_bak;                                           	// zoom factor 1 = 10 �S
short SIGNAL_StartFr_idx_bak;                                         	// running. so 0

short draw_start  = 0;
short draw_stop   = 0;
short draw_offset = 0;
short draw_factor = 0;

short draw_dm_ixstart = 0;
short draw_dm_ixstop = 0;
short draw_dm_ixoffset = 0;
short draw_dm_ixfactor = 0;

//long timebase_reg_bak;                                      		// real timebase
char  Display_Timebase_bak;                                          	// Displayed timebase is 10 �s

char Continius_bak;
char SingleMode_bak;

int CH1_DAC_Offset_bak = 0;
int CH2_DAC_Offset_bak = 0;
int CH3_DAC_Offset_bak = 0;
int CH4_DAC_Offset_bak = 0;

int Channel1_Zero_Sign_Offset_1_bak = 0;
int Channel1_Zero_Sign_Offset_2_bak = 0;
int Channel1_Zero_Sign_Offset_3_bak = 0;

int Channel2_Zero_Sign_Offset_1_bak = 0;
int Channel2_Zero_Sign_Offset_2_bak = 0;
int Channel2_Zero_Sign_Offset_3_bak = 0;

int Channel3_Zero_Sign_Offset_1_bak = 0;
int Channel3_Zero_Sign_Offset_2_bak = 0;
int Channel3_Zero_Sign_Offset_3_bak = 0;

int Channel4_Zero_Sign_Offset_1_bak = 0;
int Channel4_Zero_Sign_Offset_2_bak = 0;
int Channel4_Zero_Sign_Offset_3_bak = 0;

char Channel_1_Active_bak = 0;
char Channel_2_Active_bak = 0;
char Channel_3_Active_bak = 0;
char Channel_4_Active_bak = 0;
char Channel_Math_Active_bak = 0;
char testtoggle =0;

int CH1_DAC_Offset = 8300;
int CH1_Zero_Offset = 0;
unsigned char CH1_DAC_1 = 204;
unsigned char CH1_DAC_2 = 204;
unsigned char CH1_DAC_3 = 255;
unsigned char CH1_DAC_4 = 204;

int CH2_DAC_Offset = 8400;
int CH2_Zero_Offset = 0;
unsigned char CH2_DAC_1 = 204;
unsigned char CH2_DAC_2 = 204;
unsigned char CH2_DAC_3 = 204;
unsigned char CH2_DAC_4 = 204;

int CH3_DAC_Offset = 8750;
int CH3_Zero_Offset = 0;
unsigned char CH3_DAC_1 = 204;
unsigned char CH3_DAC_2 = 204;
unsigned char CH3_DAC_3 = 204;
unsigned char CH3_DAC_4 = 204;

int CH4_DAC_Offset = 8225;
int CH4_Zero_Offset = 0;
unsigned char CH4_DAC_1 = 204;
unsigned char CH4_DAC_2 = 204;
unsigned char CH4_DAC_3 = 204;
unsigned char CH4_DAC_4 = 204;

int CH1_DAC_OffsetOld = 0;
unsigned char CH1_DAC_1Old = 0;
unsigned char CH1_DAC_2Old = 0;
unsigned char CH1_DAC_3Old = 0;
unsigned char CH1_DAC_4Old = 0;

int CH2_DAC_OffsetOld = 0;
unsigned char CH2_DAC_1Old = 0;
unsigned char CH2_DAC_2Old = 0;
unsigned char CH2_DAC_3Old = 0;
unsigned char CH2_DAC_4Old = 0;

int CH3_DAC_OffsetOld = 0;
unsigned char CH3_DAC_1Old = 0;
unsigned char CH3_DAC_2Old = 0;
unsigned char CH3_DAC_3Old = 0;
unsigned char CH3_DAC_4Old = 0;

int CH4_DAC_OffsetOld = 0;
unsigned char CH4_DAC_1Old = 0;
unsigned char CH4_DAC_2Old = 0;
unsigned char CH4_DAC_3Old = 0;
unsigned char CH4_DAC_4Old = 0;


int Channel1_1_ADC_Correction = 0;
int Channel1_2_ADC_Correction = 0;
int Channel1_3_ADC_Correction = 0;//256;
int Channel1_4_ADC_Correction = 0;

int Channel2_1_ADC_Correction = 0;
int Channel2_2_ADC_Correction = 0;
int Channel2_3_ADC_Correction = 0;//256;
int Channel2_4_ADC_Correction = 0;

int Channel3_1_ADC_Correction = 0;
int Channel3_2_ADC_Correction = 0;
int Channel3_3_ADC_Correction = 0;//256;
int Channel3_4_ADC_Correction = 0;

int Channel4_1_ADC_Correction = 0;
int Channel4_2_ADC_Correction = 0;
int Channel4_3_ADC_Correction = 0;//256;
int Channel4_4_ADC_Correction = 0;

char CH1_X_Offset_1 = 0;
char CH1_X_Offset_2 = 0;
char CH1_X_Offset_3 = 0;
char CH1_X_Offset_4 = 0;

char CH2_X_Offset_1 = 0;
char CH2_X_Offset_2 = 0;
char CH2_X_Offset_3 = 0;
char CH2_X_Offset_4 = 0;

char CH3_X_Offset_1 = 0;
char CH3_X_Offset_2 = 0;
char CH3_X_Offset_3 = 0;
char CH3_X_Offset_4 = 0;

char CH4_X_Offset_1 = 0;
char CH4_X_Offset_2 = 0;
char CH4_X_Offset_3 = 0;
char CH4_X_Offset_4 = 0;

int Channel1_Zero_Sign_Offset_1 = 0;
int Channel1_Zero_Sign_Offset_2 = 0;
int Channel1_Zero_Sign_Offset_3 = 0;
int Channel2_Zero_Sign_Offset_1 = 0;
int Channel2_Zero_Sign_Offset_2 = 0;
int Channel2_Zero_Sign_Offset_3 = 0;
int Channel3_Zero_Sign_Offset_1 = 0;
int Channel3_Zero_Sign_Offset_2 = 0;
int Channel3_Zero_Sign_Offset_3 = 0;
int Channel4_Zero_Sign_Offset_1 = 0;
int Channel4_Zero_Sign_Offset_2 = 0;
int Channel4_Zero_Sign_Offset_3 = 0;

int Rot_Time = 0;

int LED_ON[16];
int LED_Buf = 0;

int Display_Line_Adresses[480];
int Display_Line_Adresses2[480];

//int *Display_Line_Adresses = (int *) 0x008DCA74;
//int *Display_Line_Adresses2 = (int *) 0x008DCE34;

volatile unsigned char VSync_Needed = 0;
volatile unsigned char DrawSignals_Needed = 0;

volatile unsigned char uart2_buffer[64];
volatile unsigned char send_buffer[64];
volatile char uart2_count;

// For clearing Channel and Math Plane Bit 1 - 5
volatile unsigned char ClearPlane = 0x00;
volatile unsigned char DrawPlane = 0x00;
volatile unsigned char RemovePlane = 0x00;
volatile unsigned char ClearPhase = true;

volatile unsigned char UpdateMarkerPlane = true;
volatile unsigned char UpdateMenuTextPlane = true;

volatile int TestVar = 10;

// Rotary

volatile int Rotary_Direction = 0;
volatile int Rotary_Direction_mem = 0;
volatile int Rotary_Direction_mem_pulse = 1;
volatile int Rotary_Switch = 0;
volatile int Rotary_Steps = 1;
volatile int Rotary_Changed = 1;

volatile int Keyboard_mem = 0;
volatile char Keyboard_Changed = 0;

volatile char ADC_Data_Available = 0;
volatile char ADC_Data_Available_cnt = 1;

unsigned long TransPlane_Buffer_Adr1 = 0x00000000;
unsigned long TransPlane_Plane_Adr1 = 0x00000000;
unsigned long TransPlane_Buffer_Adr2 = 0x00000000;
unsigned long TransPlane_Plane_Adr2 = 0x00000000;

unsigned short SwitchesCH1;
unsigned short SwitchesCH2;
unsigned short SwitchesCH3;
unsigned short SwitchesCH4;
unsigned short SwitchesTB;

unsigned short SwitchesCH1Old;
unsigned short SwitchesCH2Old;
unsigned short SwitchesCH3Old;
unsigned short SwitchesCH4Old;
unsigned short SwitchesTBOld;

unsigned long *Buffer_Mark1Plane = (unsigned long *) 0x008CA5F4; //0x008D3BF4;
unsigned long *Buffer_UI2Plane = (unsigned long *) 0x008D3BF4;

unsigned char *SIGNAL_IntBuf = (unsigned char *) 0x008DD1F4;

int *SIGNAL1_Histo = (int *) 0x008DD320;   // double used for Rollmode. No Interpolation for rollmode
int *SIGNAL2_Histo = (int *) 0x008DD520;
int *SIGNAL3_Histo = (int *) 0x008DD720;
int *SIGNAL4_Histo = (int *) 0x008DD920;
int *SIGNALM_Histo = (int *) 0x008DDB20;

unsigned char *SIGNAL1_Intpolate = (unsigned char *) 0x008DDD20;   // double used for Rollmode. No Interpolation for rollmode
unsigned char *SIGNAL2_Intpolate = (unsigned char *) 0x008DE1D0;
unsigned char *SIGNAL3_Intpolate = (unsigned char *) 0x008DE680;
unsigned char *SIGNAL4_Intpolate = (unsigned char *) 0x008DEB30;
unsigned char *SIGNALM_Intpolate = (unsigned char *) 0x008DEFE0;

unsigned char *SIGNAL1_Intpolate_delayed = (unsigned char *) 0x008DF490;
unsigned char *SIGNAL2_Intpolate_delayed = (unsigned char *) 0x008DF940;
unsigned char *SIGNAL3_Intpolate_delayed = (unsigned char *) 0x008DFDF0;
unsigned char *SIGNAL4_Intpolate_delayed = (unsigned char *) 0x008E02A0;
unsigned char *SIGNALM_Intpolate_delayed = (unsigned char *) 0x008E0750;

unsigned char *SIGNAL1_IntBuf_YZoom = (unsigned char *) 0x008E0C00;
unsigned char *SIGNAL2_IntBuf_YZoom = (unsigned char *) 0x008E4C00;
unsigned char *SIGNAL3_IntBuf_YZoom = (unsigned char *) 0x008E8C00;
unsigned char *SIGNAL4_IntBuf_YZoom = (unsigned char *) 0x008ECC00;
unsigned char *SIGNALM_IntBuf_YZoom = (unsigned char *) 0x008F0C00;

// 0x008F4C00 - 0x00917440 frei = 0x00022840 = 141376
/* BF insert  memory for FFT (trigo-tables and fft-values) */
float *sin_tab = (float *) 0x008F4C00;		//1024 * 4 = 4096	//Sinus table
float *cos_tab = (float *) 0x008F5C00;		//1024 * 4 = 4096	//Cosinus table
float *freq_re = (float *) 0x008F6C00;		//1024 * 4 = 4096	//Frequency values real
float *freq_im = (float *) 0x008F6C00;		//1024 * 4 = 4096	//Frequency values imaginary
int   *bit_rev = (int *)   0x008F7C00;		//1024 * 2 = 2048	//Bitreversal table
//free from 0x008F8500
/* BF insert end */

unsigned long *readout_sigbuf = (unsigned long *) 0x00917440;
unsigned char *readout_sigbuf_char = (unsigned char *) 0x00917440;

unsigned char *SIGNAL1_SUM_MIN = (unsigned char *) 0x0091B440;
unsigned char *SIGNAL1_SUM_MAX = (unsigned char *) 0x0091B6A0;
unsigned char *SIGNAL2_SUM_MIN = (unsigned char *) 0x0091B900;
unsigned char *SIGNAL2_SUM_MAX = (unsigned char *) 0x0091BB60;
unsigned char *SIGNAL3_SUM_MIN = (unsigned char *) 0x0091BDC0;
unsigned char *SIGNAL3_SUM_MAX = (unsigned char *) 0x0091C020;
unsigned char *SIGNAL4_SUM_MIN = (unsigned char *) 0x0091C280;
unsigned char *SIGNAL4_SUM_MAX = (unsigned char *) 0x0091C4E0;
unsigned char *SIGNALM_SUM_MIN = (unsigned char *) 0x0091C740;
unsigned char *SIGNALM_SUM_MAX = (unsigned char *) 0x0091C9A0;


unsigned char *SIGNAL1 = (unsigned char *) 0x0091CC00; // je 16kB (0x4000)
unsigned char *SIGNAL2 = (unsigned char *) 0x00920C00;
unsigned char *SIGNAL3 = (unsigned char *) 0x00924C00;
unsigned char *SIGNAL4 = (unsigned char *) 0x00928C00;
unsigned char *SIGNALM = (unsigned char *) 0x0092CC00;

unsigned long *Buffer_PlaneM = (unsigned long *) 0x00930C00; // 38400b = 80b * 480 = 8b * 640 * 480
unsigned long *Buffer_Plane1 = (unsigned long *) 0x0093A200;
unsigned long *Buffer_Plane2 = (unsigned long *) 0x00943800;
unsigned long *Buffer_Plane3 = (unsigned long *) 0x0094CE00;
unsigned long *Buffer_Plane4 = (unsigned long *) 0x00956400;

/* with double screen
unsigned long *Buffer_Plane1 = (unsigned long *) 0x00930C00;
unsigned long *Buffer_Plane2 = (unsigned long *) 0x0093A200;
unsigned long *Buffer_Plane3 = (unsigned long *) 0x00943800;
unsigned long *Buffer_Plane4 = (unsigned long *) 0x0094CE00;
unsigned long *Buffer_PlaneM = (unsigned long *) 0x00956400;
*/

/*
unsigned long *Buffer_Plane1 = (unsigned long *) 0x0098E800;
unsigned long *Buffer_Plane2 = (unsigned long *) 0x00997E00;
unsigned long *Buffer_Plane3 = (unsigned long *) 0x009A1400;
unsigned long *Buffer_Plane4 = (unsigned long *) 0x009AAA00;
unsigned long *Buffer_PlaneM = (unsigned long *) 0x009B4000;
*/
unsigned long *Planes = (unsigned long *) 0x0095FA00;
unsigned long *UI_Plane1 = (unsigned long *) 0x0095FA00;
unsigned long *UI_Plane2 = (unsigned long *) 0x00969000;
unsigned long *UI_Plane3 = (unsigned long *) 0x00972600;
unsigned long *UI_Plane4 = (unsigned long *) 0x0097BC00;
unsigned long *UI_Plane5 = (unsigned long *) 0x00985200;

unsigned long *Channel_Plane1 = (unsigned long *) 0x0098E800;
unsigned long *Channel_Plane2 = (unsigned long *) 0x00997E00;
unsigned long *Channel_Plane3 = (unsigned long *) 0x009A1400;
unsigned long *Channel_Plane4 = (unsigned long *) 0x009AAA00;
unsigned long *Channel_Math_Plane = (unsigned long *) 0x009B4000;

unsigned long *Memory_Plane1 = (unsigned long *) 0x009BD600;
unsigned long *Memory_Plane2 = (unsigned long *) 0x009C6C00;
unsigned long *Memory_Plane3 = (unsigned long *) 0x009D0200;

unsigned long *Marker_Plane1 = (unsigned long *) 0x009D9800;
unsigned long *Marker_Plane2 = (unsigned long *) 0x009E2E00;

unsigned long *Grid_Plane = (unsigned long *) 0x009EC400;


long v_Buffer_PlaneM = 0x00930C00;
long v_Buffer_Plane1 = 0x0093A200;
long v_Buffer_Plane2 = 0x00943800;
long v_Buffer_Plane3 = 0x0094CE00;
long v_Buffer_Plane4 = 0x00956400;
/*
long v_Buffer_Plane1 = 0x00930C00;
long v_Buffer_Plane2 = 0x0093A200;
long v_Buffer_Plane3 = 0x00943800;
long v_Buffer_Plane4 = 0x0094CE00;
long v_Buffer_PlaneM = 0x00956400;
*/
long v_Channel_Plane1 = 0x0098E800;
long v_Channel_Plane2 = 0x00997E00;
long v_Channel_Plane3 = 0x009A1400;
long v_Channel_Plane4 = 0x009AAA00;
long v_Channel_Math_Plane = 0x009B4000;

//unsigned char SIGNALBUF[16384];

//unsigned char SIGNALBUF1[16384];
//unsigned char SIGNALBUF2[16384];
//unsigned char SIGNALBUF3[16384];
//unsigned char SIGNALBUF4[16384];
//unsigned char SIGNALBUFM[16384];

//unsigned long *Buffer_Mark1Plane = (unsigned long *) 0x009F5A00;
//unsigned long *Buffer_UI2Plane = (unsigned long *) 0x009F5A00;  // shared -> menu not in Signal Part

// test
unsigned long buffer_long1 = 0;
unsigned long buffer_long2 = 0;
unsigned long buffer_long3 = 0;
unsigned long buffer_long4 = 0;
unsigned long buffer_addi = 0;

short SIGNAL1_MIN = 0;
short SIGNAL1_MDL = 0;
short SIGNAL1_MAX = 0;
short SIGNAL1_BASE = 0;
short SIGNAL1_TOP = 0;
short SIGNAL1_AVG = 0;
short SIGNAL1_AVG_CNT = 0;
short SIGNAL1_THRES_LOW = 0;
short SIGNAL1_THRES_MDL = 0;
short SIGNAL1_THRES_UP = 0;

short SIGNAL1_THRES_PRE_POSITIV_1 = 0;
short SIGNAL1_THRES_LOW_POSITIV_1 = 0;
short SIGNAL1_THRES_MDL_POSITIV_1 = 0;
short SIGNAL1_THRES_UP_POSITIV_1 = 0;
short SIGNAL1_THRES_OVER_POSITIV_1 = 0;

short SIGNAL1_THRES_PRE_NEGATIV_1 = 0;
short SIGNAL1_THRES_LOW_NEGATIV_1 = 0;
short SIGNAL1_THRES_MDL_NEGATIV_1 = 0;
short SIGNAL1_THRES_UP_NEGATIV_1 = 0;
short SIGNAL1_THRES_OVER_NEGATIV_1 = 0;

short SIGNAL1_THRES_PRE_POSITIV_2 = 0;
short SIGNAL1_THRES_LOW_POSITIV_2 = 0;
short SIGNAL1_THRES_MDL_POSITIV_2 = 0;
short SIGNAL1_THRES_UP_POSITIV_2 = 0;
short SIGNAL1_THRES_OVER_POSITIV_2 = 0;

short SIGNAL1_THRES_PRE_NEGATIV_2 = 0;
short SIGNAL1_THRES_LOW_NEGATIV_2 = 0;
short SIGNAL1_THRES_MDL_NEGATIV_2 = 0;
short SIGNAL1_THRES_UP_NEGATIV_2 = 0;
short SIGNAL1_THRES_OVER_NEGATIV_2 = 0;

short SIGNAL1_THRES_PRE_POSITIV_LAST = 0;
short SIGNAL1_THRES_LOW_POSITIV_LAST = 0;
short SIGNAL1_THRES_MDL_POSITIV_LAST = 0;
short SIGNAL1_THRES_UP_POSITIV_LAST = 0;
short SIGNAL1_THRES_OVER_POSITIV_LAST = 0;

short SIGNAL1_THRES_PRE_NEGATIV_LAST = 0;
short SIGNAL1_THRES_LOW_NEGATIV_LAST = 0;
short SIGNAL1_THRES_MDL_NEGATIV_LAST = 0;
short SIGNAL1_THRES_UP_NEGATIV_LAST = 0;
short SIGNAL1_THRES_OVER_NEGATIV_LAST = 0;

short SIGNAL2_MIN = 0;
short SIGNAL2_MDL = 0;
short SIGNAL2_MAX = 0;
short SIGNAL2_BASE = 0;
short SIGNAL2_TOP = 0;
short SIGNAL2_AVG = 0;
short SIGNAL2_AVG_CNT = 0;
short SIGNAL2_THRES_LOW = 0;
short SIGNAL2_THRES_MDL = 0;
short SIGNAL2_THRES_UP = 0;

short SIGNAL2_THRES_PRE_POSITIV_1 = 0;
short SIGNAL2_THRES_LOW_POSITIV_1 = 0;
short SIGNAL2_THRES_MDL_POSITIV_1 = 0;
short SIGNAL2_THRES_UP_POSITIV_1 = 0;
short SIGNAL2_THRES_OVER_POSITIV_1 = 0;

short SIGNAL2_THRES_PRE_NEGATIV_1 = 0;
short SIGNAL2_THRES_LOW_NEGATIV_1 = 0;
short SIGNAL2_THRES_MDL_NEGATIV_1 = 0;
short SIGNAL2_THRES_UP_NEGATIV_1 = 0;
short SIGNAL2_THRES_OVER_NEGATIV_1 = 0;

short SIGNAL2_THRES_PRE_POSITIV_2 = 0;
short SIGNAL2_THRES_LOW_POSITIV_2 = 0;
short SIGNAL2_THRES_MDL_POSITIV_2 = 0;
short SIGNAL2_THRES_UP_POSITIV_2 = 0;
short SIGNAL2_THRES_OVER_POSITIV_2 = 0;

short SIGNAL2_THRES_PRE_NEGATIV_2 = 0;
short SIGNAL2_THRES_LOW_NEGATIV_2 = 0;
short SIGNAL2_THRES_MDL_NEGATIV_2 = 0;
short SIGNAL2_THRES_UP_NEGATIV_2 = 0;
short SIGNAL2_THRES_OVER_NEGATIV_2 = 0;

short SIGNAL2_THRES_PRE_POSITIV_LAST = 0;
short SIGNAL2_THRES_LOW_POSITIV_LAST = 0;
short SIGNAL2_THRES_MDL_POSITIV_LAST = 0;
short SIGNAL2_THRES_UP_POSITIV_LAST = 0;
short SIGNAL2_THRES_OVER_POSITIV_LAST = 0;

short SIGNAL2_THRES_PRE_NEGATIV_LAST = 0;
short SIGNAL2_THRES_LOW_NEGATIV_LAST = 0;
short SIGNAL2_THRES_MDL_NEGATIV_LAST = 0;
short SIGNAL2_THRES_UP_NEGATIV_LAST = 0;
short SIGNAL2_THRES_OVER_NEGATIV_LAST = 0;

short SIGNAL3_MIN = 0;
short SIGNAL3_MDL = 0;
short SIGNAL3_MAX = 0;
short SIGNAL3_BASE = 0;
short SIGNAL3_TOP = 0;
short SIGNAL3_AVG = 0;
short SIGNAL3_AVG_CNT = 0;
short SIGNAL3_THRES_LOW = 0;
short SIGNAL3_THRES_MDL = 0;
short SIGNAL3_THRES_UP = 0;

short SIGNAL3_THRES_PRE_POSITIV_1 = 0;
short SIGNAL3_THRES_LOW_POSITIV_1 = 0;
short SIGNAL3_THRES_MDL_POSITIV_1 = 0;
short SIGNAL3_THRES_UP_POSITIV_1 = 0;
short SIGNAL3_THRES_OVER_POSITIV_1 = 0;

short SIGNAL3_THRES_PRE_NEGATIV_1 = 0;
short SIGNAL3_THRES_LOW_NEGATIV_1 = 0;
short SIGNAL3_THRES_MDL_NEGATIV_1 = 0;
short SIGNAL3_THRES_UP_NEGATIV_1 = 0;
short SIGNAL3_THRES_OVER_NEGATIV_1 = 0;

short SIGNAL3_THRES_PRE_POSITIV_2 = 0;
short SIGNAL3_THRES_LOW_POSITIV_2 = 0;
short SIGNAL3_THRES_MDL_POSITIV_2 = 0;
short SIGNAL3_THRES_UP_POSITIV_2 = 0;
short SIGNAL3_THRES_OVER_POSITIV_2 = 0;

short SIGNAL3_THRES_PRE_NEGATIV_2 = 0;
short SIGNAL3_THRES_LOW_NEGATIV_2 = 0;
short SIGNAL3_THRES_MDL_NEGATIV_2 = 0;
short SIGNAL3_THRES_UP_NEGATIV_2 = 0;
short SIGNAL3_THRES_OVER_NEGATIV_2 = 0;

short SIGNAL3_THRES_PRE_POSITIV_LAST = 0;
short SIGNAL3_THRES_LOW_POSITIV_LAST = 0;
short SIGNAL3_THRES_MDL_POSITIV_LAST = 0;
short SIGNAL3_THRES_UP_POSITIV_LAST = 0;
short SIGNAL3_THRES_OVER_POSITIV_LAST = 0;

short SIGNAL3_THRES_PRE_NEGATIV_LAST = 0;
short SIGNAL3_THRES_LOW_NEGATIV_LAST = 0;
short SIGNAL3_THRES_MDL_NEGATIV_LAST = 0;
short SIGNAL3_THRES_UP_NEGATIV_LAST = 0;
short SIGNAL3_THRES_OVER_NEGATIV_LAST = 0;

short SIGNAL4_MIN = 0;
short SIGNAL4_MDL = 0;
short SIGNAL4_MAX = 0;
short SIGNAL4_BASE = 0;
short SIGNAL4_TOP = 0;
short SIGNAL4_AVG = 0;
short SIGNAL4_AVG_CNT = 0;
short SIGNAL4_THRES_LOW = 0;
short SIGNAL4_THRES_MDL = 0;
short SIGNAL4_THRES_UP = 0;

short SIGNAL4_THRES_PRE_POSITIV_1 = 0;
short SIGNAL4_THRES_LOW_POSITIV_1 = 0;
short SIGNAL4_THRES_MDL_POSITIV_1 = 0;
short SIGNAL4_THRES_UP_POSITIV_1 = 0;
short SIGNAL4_THRES_OVER_POSITIV_1 = 0;

short SIGNAL4_THRES_PRE_NEGATIV_1 = 0;
short SIGNAL4_THRES_LOW_NEGATIV_1 = 0;
short SIGNAL4_THRES_MDL_NEGATIV_1 = 0;
short SIGNAL4_THRES_UP_NEGATIV_1 = 0;
short SIGNAL4_THRES_OVER_NEGATIV_1 = 0;

short SIGNAL4_THRES_PRE_POSITIV_2 = 0;
short SIGNAL4_THRES_LOW_POSITIV_2 = 0;
short SIGNAL4_THRES_MDL_POSITIV_2 = 0;
short SIGNAL4_THRES_UP_POSITIV_2 = 0;
short SIGNAL4_THRES_OVER_POSITIV_2 = 0;

short SIGNAL4_THRES_PRE_NEGATIV_2 = 0;
short SIGNAL4_THRES_LOW_NEGATIV_2 = 0;
short SIGNAL4_THRES_MDL_NEGATIV_2 = 0;
short SIGNAL4_THRES_UP_NEGATIV_2 = 0;
short SIGNAL4_THRES_OVER_NEGATIV_2 = 0;

short SIGNAL4_THRES_PRE_POSITIV_LAST = 0;
short SIGNAL4_THRES_LOW_POSITIV_LAST = 0;
short SIGNAL4_THRES_MDL_POSITIV_LAST = 0;
short SIGNAL4_THRES_UP_POSITIV_LAST = 0;
short SIGNAL4_THRES_OVER_POSITIV_LAST = 0;

short SIGNAL4_THRES_PRE_NEGATIV_LAST = 0;
short SIGNAL4_THRES_LOW_NEGATIV_LAST = 0;
short SIGNAL4_THRES_MDL_NEGATIV_LAST = 0;
short SIGNAL4_THRES_UP_NEGATIV_LAST = 0;
short SIGNAL4_THRES_OVER_NEGATIV_LAST = 0;

short SIGNALM_MIN = 0;
short SIGNALM_MDL = 0;
short SIGNALM_MAX = 0;
short SIGNALM_BASE = 0;
short SIGNALM_TOP = 0;
short SIGNALM_AVG = 0;
short SIGNALM_AVG_CNT = 0;
short SIGNALM_THRES_LOW = 0;
short SIGNALM_THRES_MDL = 0;
short SIGNALM_THRES_UP = 0;

short SIGNALM_THRES_PRE_POSITIV_1 = 0;
short SIGNALM_THRES_LOW_POSITIV_1 = 0;
short SIGNALM_THRES_MDL_POSITIV_1 = 0;
short SIGNALM_THRES_UP_POSITIV_1 = 0;
short SIGNALM_THRES_OVER_POSITIV_1 = 0;

short SIGNALM_THRES_PRE_NEGATIV_1 = 0;
short SIGNALM_THRES_LOW_NEGATIV_1 = 0;
short SIGNALM_THRES_MDL_NEGATIV_1 = 0;
short SIGNALM_THRES_UP_NEGATIV_1 = 0;
short SIGNALM_THRES_OVER_NEGATIV_1 = 0;

short SIGNALM_THRES_PRE_POSITIV_2 = 0;
short SIGNALM_THRES_LOW_POSITIV_2 = 0;
short SIGNALM_THRES_MDL_POSITIV_2 = 0;
short SIGNALM_THRES_UP_POSITIV_2 = 0;
short SIGNALM_THRES_OVER_POSITIV_2 = 0;

short SIGNALM_THRES_PRE_NEGATIV_2 = 0;
short SIGNALM_THRES_LOW_NEGATIV_2 = 0;
short SIGNALM_THRES_MDL_NEGATIV_2 = 0;
short SIGNALM_THRES_UP_NEGATIV_2 = 0;
short SIGNALM_THRES_OVER_NEGATIV_2 = 0;

short SIGNALM_THRES_PRE_POSITIV_LAST = 0;
short SIGNALM_THRES_LOW_POSITIV_LAST = 0;
short SIGNALM_THRES_MDL_POSITIV_LAST = 0;
short SIGNALM_THRES_UP_POSITIV_LAST = 0;
short SIGNALM_THRES_OVER_POSITIV_LAST = 0;

short SIGNALM_THRES_PRE_NEGATIV_LAST = 0;
short SIGNALM_THRES_LOW_NEGATIV_LAST = 0;
short SIGNALM_THRES_MDL_NEGATIV_LAST = 0;
short SIGNALM_THRES_UP_NEGATIV_LAST = 0;
short SIGNALM_THRES_OVER_NEGATIV_LAST = 0;

volatile short ROLLMODE_OFFSET = 600;
volatile short ROLLMODE_POS = 0;
volatile short ROLLMODE_BUFFVALUE_CH1 = 0;
volatile short ROLLMODE_BUFFVALUE_CH2 = 0;
volatile short ROLLMODE_BUFFVALUE_CH3 = 0;
volatile short ROLLMODE_BUFFVALUE_CH4 = 0;
volatile short ROLLMODE_BUFFVALUE_CHM = 0;

volatile short ROLLMODE_CNT = 0;

volatile short ROLLMODE_TB = 0;

volatile char ROLLMODE_STARTED = false;
volatile char ROLLMODE_Value_rec = false;

// Vars for the zoom
volatile short SIGNAL_StartFr_idx = 0;
volatile short SIGNAL_OFFSET = 0;
volatile short SIGNALFaktor_idx = 0;
volatile short SIGNALFaktor_idx_Old = 0;

// Start vars for the zoom in delayed mode
volatile short dmode_SIGNAL_StartFr_idx = 0;
volatile short dmode_SIGNAL_OFFSET = 0;
volatile short dmode_SIGNALFaktor_idx = 0;

char dmode_Selected_Timebase;										// Selected Timebase

int dmode_Timebase_Offset_Pos_Old;
int dmode_Trigger_Offset_Pos_Old;

int dmode_Cursor_Vertical_Position1_Old;
int dmode_Cursor_Vertical_Position2_Old;

int dmode_QM_Vertical_Position1_Old;
int dmode_QM_Vertical_Position2_Old;

int dmode_Window_Offset_Pos;
int dmode_Window_Offset_Pos_Old;

float dmode_factor = 1.0;

int Cursor_Delayed_1 = 180;
int Cursor_Delayed_2 = 420;
int Cursor_Delayed_Size = 300;
int Cursor_Delayed_1_Old = 180;
int Cursor_Delayed_2_Old = 420;

// Multiplier Vars
volatile char multi_active = 1;
// K�nnen raus
/*
volatile int ch1_value;
volatile int ch1_factor = 0;
volatile int ch1_result;

volatile int ch2_value;
volatile int ch2_factor = 0;
volatile int ch2_result;

volatile int ch3_value;
volatile int ch3_factor = 0;
volatile int ch3_result;

volatile int ch4_value;
volatile int ch4_factor = 0;
volatile int ch4_result;  */
//

    unsigned char buf_arr[600];

    unsigned char buf_min = 255;
    unsigned char buf_max = 0;

int Voltage_Correction[4][12] = {{ 50, 50,  0, 50, 50,  0, 50, 50,  0, 50, 50,  0},
                                 { 50, 50,  0, 50, 50,  0, 50, 50,  0, 50, 50,  0},
                                 { 50, 50,  0, 50, 50,  0, 50, 50,  0, 50, 50,  0},
                                 { 50, 50,  0, 50, 50,  0, 50, 50,  0, 50, 50,  0}};

float Volt_Correct_float[4][12] = {{ 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0},
                                   { 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0},
                                   { 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0},
                                   { 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0, 1.50, 1.50,  0}};
                                 
int Voltage_Offset[4][4] = {{ 0, 0, 0, 0},
                            { 0, 0, 0, 0},
                            { 0, 0, 0, 0},
                            { 0, 0, 0, 0}};
                            
short FIR_Tabel[6][9]={{   0,   0,   0,   0, 256,   0,   0,   0,   0},
                       {   9, -12,  18, -34, 244,  48, -22,  14, -10},
                       {  16, -21,  30, -52, 211, 105, -42,  26, -19},
                       {  18, -23,  32, -54, 163, 163, -54,  32, -23},
                       {  15, -19,  26, -42, 105, 211, -52,  30, -21},
                       {   8, -10,  14, -22,  48, 244, -34,  18, -12}};
                       
short FIR_Tab_big[256][6][9];

char FirEnabledCH1 = 0;
char FirEnabledCH2 = 0;
char FirEnabledCH3 = 0;
char FirEnabledCH4 = 0;

short FirStartCH = 245;

short FirStartCH_delayed = 245;

char SmoothEnabledCH1 = 0;
char SmoothEnabledCH2 = 0;
char SmoothEnabledCH3 = 0;
char SmoothEnabledCH4 = 0;

// FFT Depended
long fft_length = 512;

float fft_values[512];
float fft_frequencies[512];
float fft_mag[512];
float fft_max = 0;

//float fft_window[3][512];

float fft_window[3][512] ={{ 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,

                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                             1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0},
                             
                           { 0.00000000, 0.00003765, 0.00015059, 0.00033881, 0.00060227, 0.00094094, 0.00135477, 0.00184369,
                             0.00240764, 0.00304651, 0.00376023, 0.00454868, 0.00541175, 0.00634929, 0.00736118, 0.00844726,
                             0.00960736, 0.01084131, 0.01214894, 0.01353002, 0.01498437, 0.01651176, 0.01811197, 0.01978474,
                             0.02152983, 0.02334698, 0.02523591, 0.02719634, 0.02922797, 0.03133049, 0.03350360, 0.03574696,

                             0.03806023, 0.04044307, 0.04289512, 0.04541601, 0.04800535, 0.05066277, 0.05338785, 0.05618019,
                             0.05903937, 0.06196495, 0.06495650, 0.06801357, 0.07113569, 0.07432240, 0.07757322, 0.08088765,
                             0.08426519, 0.08770535, 0.09120759, 0.09477140, 0.09839623, 0.10208154, 0.10582679, 0.10963139,
                             0.11349478, 0.11741637, 0.12139558, 0.12543181, 0.12952444, 0.13367286, 0.13787647, 0.14213459,

                             0.14644662, 0.15081188, 0.15522973, 0.15969950, 0.16422053, 0.16879211, 0.17341357, 0.17808422,
                             0.18280336, 0.18757026, 0.19238420, 0.19724448, 0.20215034, 0.20710108, 0.21209590, 0.21713409,
                             0.22221488, 0.22733751, 0.23250119, 0.23770516, 0.24294862, 0.24823081, 0.25355092, 0.25890812,
                             0.26430163, 0.26973066, 0.27519435, 0.28069189, 0.28622246, 0.29178521, 0.29737934, 0.30300397,

                             0.30865827, 0.31434140, 0.32005247, 0.32579067, 0.33155507, 0.33734486, 0.34315914, 0.34899703,
                             0.35485765, 0.36074015, 0.36664361, 0.37256718, 0.37850991, 0.38447094, 0.39044937, 0.39644432,
                             0.40245485, 0.40848005, 0.41451904, 0.42057094, 0.42663476, 0.43270963, 0.43879467, 0.44488889,
                             0.45099142, 0.45710135, 0.46321771, 0.46933964, 0.47546616, 0.48159638, 0.48772940, 0.49386424,

                             0.50000000, 0.50613576, 0.51227063, 0.51840359, 0.52453381, 0.53066039, 0.53678226, 0.54289865,
                             0.54900855, 0.55511111, 0.56120533, 0.56729037, 0.57336521, 0.57942909, 0.58548093, 0.59151995,
                             0.59754515, 0.60355568, 0.60955060, 0.61552906, 0.62149006, 0.62743282, 0.63335639, 0.63925982,
                             0.64514232, 0.65100300, 0.65684086, 0.66265517, 0.66844493, 0.67420936, 0.67994750, 0.68565857,

                             0.69134170, 0.69699603, 0.70262069, 0.70821476, 0.71377754, 0.71930814, 0.72480565, 0.73026937,
                             0.73569834, 0.74109191, 0.74644911, 0.75176919, 0.75705135, 0.76229483, 0.76749879, 0.77266252,
                             0.77778512, 0.78286588, 0.78790408, 0.79289895, 0.79784966, 0.80275553, 0.80761582, 0.81242973,
                             0.81719667, 0.82191575, 0.82658643, 0.83120787, 0.83577949, 0.84030050, 0.84477025, 0.84918815,

                             0.85355341, 0.85786539, 0.86212355, 0.86632711, 0.87047559, 0.87456822, 0.87860441, 0.88258362,
                             0.88650525, 0.89036864, 0.89417320, 0.89791846, 0.90160376, 0.90522861, 0.90879244, 0.91229463,
                             0.91573483, 0.91911232, 0.92242676, 0.92567760, 0.92886430, 0.93198645, 0.93504351, 0.93803507,
                             0.94096065, 0.94381982, 0.94661218, 0.94933724, 0.95199466, 0.95458400, 0.95710486, 0.95955694,

                             0.96193975, 0.96425307, 0.96649641, 0.96866953, 0.97077203, 0.97280365, 0.97476411, 0.97665304,
                             0.97847015, 0.98021525, 0.98188806, 0.98348826, 0.98501563, 0.98646998, 0.98785108, 0.98915869,
                             0.99039263, 0.99155277, 0.99263883, 0.99365073, 0.99458826, 0.99545133, 0.99623978, 0.99695349,
                             0.99759239, 0.99815631, 0.99864525, 0.99905908, 0.99939775, 0.99966121, 0.99984944, 0.99996233,

                             1.00000000, 0.99996233, 0.99984944, 0.99966121, 0.99939775, 0.99905908, 0.99864525, 0.99815631,
                             0.99759239, 0.99695349, 0.99623978, 0.99545133, 0.99458826, 0.99365073, 0.99263883, 0.99155277,
                             0.99039263, 0.98915869, 0.98785108, 0.98646998, 0.98501563, 0.98348826, 0.98188806, 0.98021525,
                             0.97847015, 0.97665304, 0.97476411, 0.97280365, 0.97077203, 0.96866953, 0.96649641, 0.96425307,

                             0.96193975, 0.95955694, 0.95710486, 0.95458400, 0.95199466, 0.94933724, 0.94661218, 0.94381982,
                             0.94096065, 0.93803507, 0.93504351, 0.93198645, 0.92886430, 0.92567760, 0.92242676, 0.91911232,
                             0.91573483, 0.91229463, 0.90879244, 0.90522861, 0.90160376, 0.89791846, 0.89417320, 0.89036864,
                             0.88650525, 0.88258362, 0.87860441, 0.87456822, 0.87047559, 0.86632711, 0.86212355, 0.85786539,

                             0.85355341, 0.84918815, 0.84477025, 0.84030050, 0.83577949, 0.83120787, 0.82658643, 0.82191575,
                             0.81719667, 0.81242973, 0.80761582, 0.80275553, 0.79784966, 0.79289895, 0.78790408, 0.78286588,
                             0.77778512, 0.77266252, 0.76749879, 0.76229483, 0.75705135, 0.75176919, 0.74644911, 0.74109191,
                             0.73569834, 0.73026937, 0.72480565, 0.71930814, 0.71377754, 0.70821476, 0.70262069, 0.69699603,

                             0.69134170, 0.68565857, 0.67994750, 0.67420936, 0.66844493, 0.66265517, 0.65684086, 0.65100300,
                             0.64514232, 0.63925982, 0.63335639, 0.62743282, 0.62149006, 0.61552906, 0.60955060, 0.60355568,
                             0.59754515, 0.59151995, 0.58548093, 0.57942909, 0.57336521, 0.56729037, 0.56120533, 0.55511111,
                             0.54900855, 0.54289865, 0.53678226, 0.53066039, 0.52453381, 0.51840359, 0.51227063, 0.50613576,

                             0.50000000, 0.49386424, 0.48772940, 0.48159638, 0.47546616, 0.46933964, 0.46321771, 0.45710135,
                             0.45099142, 0.44488889, 0.43879467, 0.43270963, 0.42663476, 0.42057094, 0.41451904, 0.40848005,
                             0.40245485, 0.39644432, 0.39044937, 0.38447094, 0.37850991, 0.37256718, 0.36664361, 0.36074015,
                             0.35485765, 0.34899703, 0.34315914, 0.33734486, 0.33155507, 0.32579067, 0.32005247, 0.31434140,

                             0.30865827, 0.30300397, 0.29737934, 0.29178521, 0.28622246, 0.28069189, 0.27519435, 0.26973066,
                             0.26430163, 0.25890812, 0.25355092, 0.24823081, 0.24294862, 0.23770516, 0.23250119, 0.22733751,
                             0.22221488, 0.21713409, 0.21209590, 0.20710108, 0.20215034, 0.19724448, 0.19238420, 0.18757026,
                             0.18280336, 0.17808422, 0.17341357, 0.16879211, 0.16422053, 0.15969950, 0.15522973, 0.15081188,

                             0.14644662, 0.14213459, 0.13787647, 0.13367286, 0.12952444, 0.12543181, 0.12139558, 0.11741637,
                             0.11349478, 0.10963139, 0.10582679, 0.10208154, 0.09839623, 0.09477140, 0.09120759, 0.08770535,
                             0.08426519, 0.08088765, 0.07757322, 0.07432240, 0.07113569, 0.06801357, 0.06495650, 0.06196495,
                             0.05903937, 0.05618019, 0.05338785, 0.05066277, 0.04800535, 0.04541601, 0.04289512, 0.04044307,

                             0.03806023, 0.03574696, 0.03350360, 0.03133049, 0.02922797, 0.02719634, 0.02523591, 0.02334698,
                             0.02152983, 0.01978474, 0.01811197, 0.01651176, 0.01498437, 0.01353002, 0.01214894, 0.01084131,
                             0.00960736, 0.00844726, 0.00736118, 0.00634929, 0.00541175, 0.00454868, 0.00376023, 0.00304651,
                             0.00240764, 0.00184369, 0.00135477, 0.00094094, 0.00060227, 0.00033881, 0.00015059, 0.00003765},
                             
                           { 0.00000000, 0.00003765, 0.00015059, 0.00033881, 0.00060227, 0.00094094, 0.00135477, 0.00184369,
                             0.00240764, 0.00304651, 0.00376023, 0.00454868, 0.00541175, 0.00634929, 0.00736118, 0.00844726,
                             0.00960736, 0.01084131, 0.01214894, 0.01353002, 0.01498437, 0.01651176, 0.01811197, 0.01978474,
                             0.02152983, 0.02334698, 0.02523591, 0.02719634, 0.02922797, 0.03133049, 0.03350360, 0.03574696,

                             0.03806023, 0.04044307, 0.04289512, 0.04541601, 0.04800535, 0.05066277, 0.05338785, 0.05618019,
                             0.05903937, 0.06196495, 0.06495650, 0.06801357, 0.07113569, 0.07432240, 0.07757322, 0.08088765,
                             0.08426519, 0.08770535, 0.09120759, 0.09477140, 0.09839623, 0.10208154, 0.10582679, 0.10963139,
                             0.11349478, 0.11741637, 0.12139558, 0.12543181, 0.12952444, 0.13367286, 0.13787647, 0.14213459,

                             0.14644662, 0.15081188, 0.15522973, 0.15969950, 0.16422053, 0.16879211, 0.17341357, 0.17808422,
                             0.18280336, 0.18757026, 0.19238420, 0.19724448, 0.20215034, 0.20710108, 0.21209590, 0.21713409,
                             0.22221488, 0.22733751, 0.23250119, 0.23770516, 0.24294862, 0.24823081, 0.25355092, 0.25890812,
                             0.26430163, 0.26973066, 0.27519435, 0.28069189, 0.28622246, 0.29178521, 0.29737934, 0.30300397,

                             0.30865827, 0.31434140, 0.32005247, 0.32579067, 0.33155507, 0.33734486, 0.34315914, 0.34899703,
                             0.35485765, 0.36074015, 0.36664361, 0.37256718, 0.37850991, 0.38447094, 0.39044937, 0.39644432,
                             0.40245485, 0.40848005, 0.41451904, 0.42057094, 0.42663476, 0.43270963, 0.43879467, 0.44488889,
                             0.45099142, 0.45710135, 0.46321771, 0.46933964, 0.47546616, 0.48159638, 0.48772940, 0.49386424,

                             0.50000000, 0.50613576, 0.51227063, 0.51840359, 0.52453381, 0.53066039, 0.53678226, 0.54289865,
                             0.54900855, 0.55511111, 0.56120533, 0.56729037, 0.57336521, 0.57942909, 0.58548093, 0.59151995,
                             0.59754515, 0.60355568, 0.60955060, 0.61552906, 0.62149006, 0.62743282, 0.63335639, 0.63925982,
                             0.64514232, 0.65100300, 0.65684086, 0.66265517, 0.66844493, 0.67420936, 0.67994750, 0.68565857,

                             0.69134170, 0.69699603, 0.70262069, 0.70821476, 0.71377754, 0.71930814, 0.72480565, 0.73026937,
                             0.73569834, 0.74109191, 0.74644911, 0.75176919, 0.75705135, 0.76229483, 0.76749879, 0.77266252,
                             0.77778512, 0.78286588, 0.78790408, 0.79289895, 0.79784966, 0.80275553, 0.80761582, 0.81242973,
                             0.81719667, 0.82191575, 0.82658643, 0.83120787, 0.83577949, 0.84030050, 0.84477025, 0.84918815,

                             0.85355341, 0.85786539, 0.86212355, 0.86632711, 0.87047559, 0.87456822, 0.87860441, 0.88258362,
                             0.88650525, 0.89036864, 0.89417320, 0.89791846, 0.90160376, 0.90522861, 0.90879244, 0.91229463,
                             0.91573483, 0.91911232, 0.92242676, 0.92567760, 0.92886430, 0.93198645, 0.93504351, 0.93803507,
                             0.94096065, 0.94381982, 0.94661218, 0.94933724, 0.95199466, 0.95458400, 0.95710486, 0.95955694,

                             0.96193975, 0.96425307, 0.96649641, 0.96866953, 0.97077203, 0.97280365, 0.97476411, 0.97665304,
                             0.97847015, 0.98021525, 0.98188806, 0.98348826, 0.98501563, 0.98646998, 0.98785108, 0.98915869,
                             0.99039263, 0.99155277, 0.99263883, 0.99365073, 0.99458826, 0.99545133, 0.99623978, 0.99695349,
                             0.99759239, 0.99815631, 0.99864525, 0.99905908, 0.99939775, 0.99966121, 0.99984944, 0.99996233,

                             1.00000000, 0.99996233, 0.99984944, 0.99966121, 0.99939775, 0.99905908, 0.99864525, 0.99815631,
                             0.99759239, 0.99695349, 0.99623978, 0.99545133, 0.99458826, 0.99365073, 0.99263883, 0.99155277,
                             0.99039263, 0.98915869, 0.98785108, 0.98646998, 0.98501563, 0.98348826, 0.98188806, 0.98021525,
                             0.97847015, 0.97665304, 0.97476411, 0.97280365, 0.97077203, 0.96866953, 0.96649641, 0.96425307,

                             0.96193975, 0.95955694, 0.95710486, 0.95458400, 0.95199466, 0.94933724, 0.94661218, 0.94381982,
                             0.94096065, 0.93803507, 0.93504351, 0.93198645, 0.92886430, 0.92567760, 0.92242676, 0.91911232,
                             0.91573483, 0.91229463, 0.90879244, 0.90522861, 0.90160376, 0.89791846, 0.89417320, 0.89036864,
                             0.88650525, 0.88258362, 0.87860441, 0.87456822, 0.87047559, 0.86632711, 0.86212355, 0.85786539,

                             0.85355341, 0.84918815, 0.84477025, 0.84030050, 0.83577949, 0.83120787, 0.82658643, 0.82191575,
                             0.81719667, 0.81242973, 0.80761582, 0.80275553, 0.79784966, 0.79289895, 0.78790408, 0.78286588,
                             0.77778512, 0.77266252, 0.76749879, 0.76229483, 0.75705135, 0.75176919, 0.74644911, 0.74109191,
                             0.73569834, 0.73026937, 0.72480565, 0.71930814, 0.71377754, 0.70821476, 0.70262069, 0.69699603,

                             0.69134170, 0.68565857, 0.67994750, 0.67420936, 0.66844493, 0.66265517, 0.65684086, 0.65100300,
                             0.64514232, 0.63925982, 0.63335639, 0.62743282, 0.62149006, 0.61552906, 0.60955060, 0.60355568,
                             0.59754515, 0.59151995, 0.58548093, 0.57942909, 0.57336521, 0.56729037, 0.56120533, 0.55511111,
                             0.54900855, 0.54289865, 0.53678226, 0.53066039, 0.52453381, 0.51840359, 0.51227063, 0.50613576,

                             0.50000000, 0.49386424, 0.48772940, 0.48159638, 0.47546616, 0.46933964, 0.46321771, 0.45710135,
                             0.45099142, 0.44488889, 0.43879467, 0.43270963, 0.42663476, 0.42057094, 0.41451904, 0.40848005,
                             0.40245485, 0.39644432, 0.39044937, 0.38447094, 0.37850991, 0.37256718, 0.36664361, 0.36074015,
                             0.35485765, 0.34899703, 0.34315914, 0.33734486, 0.33155507, 0.32579067, 0.32005247, 0.31434140,

                             0.30865827, 0.30300397, 0.29737934, 0.29178521, 0.28622246, 0.28069189, 0.27519435, 0.26973066,
                             0.26430163, 0.25890812, 0.25355092, 0.24823081, 0.24294862, 0.23770516, 0.23250119, 0.22733751,
                             0.22221488, 0.21713409, 0.21209590, 0.20710108, 0.20215034, 0.19724448, 0.19238420, 0.18757026,
                             0.18280336, 0.17808422, 0.17341357, 0.16879211, 0.16422053, 0.15969950, 0.15522973, 0.15081188,

                             0.14644662, 0.14213459, 0.13787647, 0.13367286, 0.12952444, 0.12543181, 0.12139558, 0.11741637,
                             0.11349478, 0.10963139, 0.10582679, 0.10208154, 0.09839623, 0.09477140, 0.09120759, 0.08770535,
                             0.08426519, 0.08088765, 0.07757322, 0.07432240, 0.07113569, 0.06801357, 0.06495650, 0.06196495,
                             0.05903937, 0.05618019, 0.05338785, 0.05066277, 0.04800535, 0.04541601, 0.04289512, 0.04044307,

                             0.03806023, 0.03574696, 0.03350360, 0.03133049, 0.02922797, 0.02719634, 0.02523591, 0.02334698,
                             0.02152983, 0.01978474, 0.01811197, 0.01651176, 0.01498437, 0.01353002, 0.01214894, 0.01084131,
                             0.00960736, 0.00844726, 0.00736118, 0.00634929, 0.00541175, 0.00454868, 0.00376023, 0.00304651,
                             0.00240764, 0.00184369, 0.00135477, 0.00094094, 0.00060227, 0.00033881, 0.00015059, 0.00003765}};


unsigned char *val_bytes = (unsigned char *) &fft_values[0];
unsigned char *freq_bytes = (unsigned char *) &fft_frequencies[0];

//FFTRealFixLen <12> fft_object; // 4096-point (2^12) FFT object constructed.
//FFTRealFixLen <9> fft_object; // 256-point (2^8) FFT object constructed.


short LogicData[32];

char USB_Connected = false;
char USB_Data_Trans;
char USB_SendAllData;
char USB_At_Startup = false;
char USB_OnlyTrigger;

char USB_Data_Requested = false;

volatile char Continius;
volatile char Signal_Loaded = 0;

volatile char SingleMode = 0;
volatile char Single_Restart = 0;

volatile char ButtonChanged = 0;
volatile char RoteryChanged = 0;
volatile char RoteryReady = 0;
volatile char UserIface_active = 0;
volatile char UserIface_active_2 = 0;
volatile char Menu_Popup_visible =0;

char DoDraw = 0;
char SavePointer = 1;

short led_status;									// Stores the LED Port Bits;
char ScreenShotActive;									// is 1 when sending screen shot

char PopUpPosition;
char IsPopuped;										// When it is Popuped it is 1, else 0
char PopupTimeCounter;									// Counter for Popup Pulldown

char TriggerLevelChanged = 1;								// Was Triggerlevel changed
char TriggerOffsetChanged = 1;								// Was Triggerlevel changed
char TriggerModeChanged = 1;								// Was Triggermode changed
char TriggerWayChanged = 1;								// Was Triggerway changed
char TimebaseChanged = 1;								// Was Timebase changed
char TimeOffsetChanged = 1;								// Was Time_Offset changed
char SIGNALFaktorChanged = 1;								// Was SIGNALFaktor changed

char TriggerLevelActive = 0;								// Is Triggerlevel selected ?
char TimeOffsetActive = 0;								// Is Time_Offset selected ?
char StatusbarChanged = 0;								// When 1 then is changed
char ZeroPopupChanged = 0;								// When 1 then is changed
char MenuPopupChanged = 0;								// When 1 then is changed
char MenuPopupActive = -1;								// Stores the actual Menupopup
char VoltageChangedCh1 = 1;								// Was Voltage changed
char VoltageChangedCh2 = 1;								// Was Voltage changed
char VoltageChangedCh3 = 1;								// Was Voltage changed
char VoltageChangedCh4 = 1;								// Was Voltage changed
char MenuPopupChanged2 = 0;								// Was MenuPopup changed
char MenuOnlyChanged = 0;								// When 1 then is changed 

char MenuItemChanged[6] = {0, 0, 0, 0, 0, 0};
char MenuItemPushed[6] = {0, 0, 0, 0, 0, 0};				// When Menuitem is pushed drawed
char MenuItemPushed_old[6] = {0, 0, 0, 0, 0, 0};			// When Menuitem is pushed drawed
char MenuStatusChanged = 0;									// When switching on/off a menu holds menunr
char MenuAktive = 1;                                        // When Menu was deaktive
char MenuAktive_old = 1;                                    // When Menu was deaktive
char EdgeToggle = 0;                                        // for switching between Holdoff and Probe
char PulseToggle = 1;                                       // for switching between smaller/bigger pulse width
char MathToggle = 0;                                        // for switching between Scale and Offset
char FFTToggle = 0;                                         // for switching between Scale and Offset

char VS_ZeroChangedCh1 = 1;									// Was Zero changed
char VS_ZeroChangedCh2 = 1;									// Was Zero changed
char VS_ZeroChangedCh3 = 1;									// Was Zero changed
char VS_ZeroChangedCh4 = 1;									// Was Zero changed
char VS_TrigLevelChanged = 1;								// Was Triggerlevel changed

int MenuPopupX;
int MenuPopupY;
int MenuPopupSizeX;
int MenuPopupSizeY;

char MenuStored;
char MenuActive;
char MenuActiveOld;
char MenuChanged;
int MenuTimeCounter;										// Counter for Menu Pulldown

char MenuItemCount;										// Store the count of the Menuitems
char MenuOldItemCount;										// Store the count of the old Menuitems


// New Menu Vars
char New_Menu = -1;
char Active_Menu = -1;
char Menu_Changed = -1;

//char Btns_Status[6] = {0, 0, 0, 0, 0, 0};	//BF not used
// 0 - No change
// 1 - To remove
// 2 - To remove text
// 3 - To draw
// 4 - To redraw text


int wheelchanged = 0;
int Rot_Summary = 0;                                        					// Stores the value from Rot speed Calculation

long Memory_Position;										// Store memory position

// Soweit sogut in default vars.

volatile char NumberOfChannels = 4;

char Channel_1_Active;										// Store the channel activity
char Channel_2_Active;										// Store the channel activity
char Channel_3_Active;										// Store the channel activity
char Channel_4_Active;										// Store the channel activity
char Channel_Math_Active;									// Store the math activity

char Channel_1_Active_Old;									// Store the channel activity
char Channel_2_Active_Old;									// Store the channel activity
char Channel_3_Active_Old;									// Store the channel activity
char Channel_4_Active_Old;									// Store the channel activity
char Channel_Math_Active_Old;									// Store the math activity

char Selected_Timebase;										// Selected Timebase 
char Selected_Timebase_Old;									// Selected Timebase
char Selected_Expand_Timebase; 									// Selected Expand Timebase
char Display_Timebase;										// Selected Shown Timebase
char Display_Timebase_Old;	     								// Selected Shown Timebase
char Display_Mode = 0;     									// Selected Normal or XY-Mode
//  0 - Normal , 1 = XY-Mode

int Timebase_Offset_Pos;									// Store the Timebase Offset Position in Pixel
int Timebase_Offset_Pos_Old;									// Store the old Timebase Offset Position in Pixel

volatile int Trigger_Offset_Pos;								// Store the Timebase Offset Position in Pixel
volatile int Trigger_Offset_Pos_Old;								// Store the old Timebase Offset Position in Pixel

volatile int Trigger_Offset_Calc;								// Store the Timebase Offset Position in Pixel


/** New Trigger Values**/
int Trig_Pos_Mem           = 300;                                     			// Store the Triggerposition in Memory
int Trig_Pos_Display       = 300;                                 			// Store the Triggerposition on Display
int Trig_Pos_Display_dmode = 300;                           				// Store the Triggerposition on Display in delayed mode
float Trig_Pos_Zoom        = 1.0;                                  			// Store the Triggerzoom factor
int Trig_Mem_Pos           = -300;                    					// Store the Trigger Memory Offset

int Trig_Pos_Mem_old           = 300;                                     		// Store the Triggerposition in Memory
int Trig_Pos_Display_old       = 300;                                 			// Store the Triggerposition on Display
int Trig_Pos_Display_dmode_old = 300;                           			// Store the Triggerposition on Display in delayed mode
float Trig_Pos_Zoom_old        = 1.0;                                  			// Store the Triggerzoom factor
int Trig_Mem_Pos_old           = -300;                                    		// Store the Trigger Memory Offset

// delayed fehlt noch


char TriggerWay;										// Stores the way to trigger
// 1 - Edge / 2 - Pulse / 3 - Pattern / 4 - More

char Selected_Trigger_Source;									// Stores the Channel who Trigger
char Selected_Trigger_Source_Old;								// Stores the Channel who Trigger Old
// 1 - 4 Channels / 5 - External / 6 - Line

char SelectedEdgeExtern;									// Store which extern is Selected
// 0 = Extern / 1 = Line

char TiggerLevelLine;										// If 1 then Draw Trigger Level Line
int Trigger_Pos_CH1;										// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2;										// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3;										// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4;										// Stores the Trigger Position on Channel 4
int Trigger_Pos_CHE;										// Stores the Trigger Position on External

int Trigger_Pos_CH1_Old;									// Stores the old Trigger Position on Channel 1
int Trigger_Pos_CH2_Old;									// Stores the old Trigger Position on Channel 2
int Trigger_Pos_CH3_Old;									// Stores the old Trigger Position on Channel 3
int Trigger_Pos_CH4_Old;									// Stores the old Trigger Position on Channel 4
int Trigger_Pos_CHE_Old;									// Stores the old Trigger Position on External

int Trigger_Pos_CH1_os = 0;									// Stores the Trigger Position on Channel 1 of the screen
int Trigger_Pos_CH2_os = 0;									// Stores the Trigger Position on Channel 2 of the screen
int Trigger_Pos_CH3_os = 0;									// Stores the Trigger Position on Channel 3 of the screen
int Trigger_Pos_CH4_os = 0;									// Stores the Trigger Position on Channel 4 of the screen
int Trigger_Pos_CHE_os = 0;									// Stores the Trigger Position on External of the screen

char SelectedChannel;
char SelectedChannelOld;

// ZeroLine in virtual screen with hight 0 - 16383 pixels 8192 is middle
int Virtual_ZeroLevelCH1;
int Virtual_ZeroLevelCH2;
int Virtual_ZeroLevelCH3;
int Virtual_ZeroLevelCH4;

// ZeroLine in screen with hight 0 - 383 pixels 192 is middle
int ZeroLevelCH1;
int ZeroLevelCH2;
int ZeroLevelCH3;
int ZeroLevelCH4;

int Virtual_ZeroLevelXYCH1;
int Virtual_ZeroLevelXYCH2;
int Virtual_ZeroLevelXYCH3;
int Virtual_ZeroLevelXYCH4;

int ZeroLevelCH1_Old;
int ZeroLevelCH2_Old;
int ZeroLevelCH3_Old;
int ZeroLevelCH4_Old;

volatile char Selected_Voltage_CH1;								// Selected Voltage_CH1
volatile char Selected_Voltage_CH1_Old;								// Selected Voltage_CH1
volatile char Selected_Voltage_CH2;								// Selected Voltage_CH2
volatile char Selected_Voltage_CH2_Old;								// Selected Voltage_CH2
volatile char Selected_Voltage_CH3;								// Selected Voltage_CH3
volatile char Selected_Voltage_CH3_Old;								// Selected Voltage_CH3
volatile char Selected_Voltage_CH4;								// Selected Voltage_CH4
volatile char Selected_Voltage_CH4_Old;								// Selected Voltage_CH4
volatile char Selected_TB;									// Selected TimeBase

volatile char Selected_ADCs_CH1;								// Selected ADC_CH1
volatile char Selected_ADCs_CH2;								// Selected ADC_CH2
volatile char Selected_ADCs_CH3;								// Selected ADC_CH3
volatile char Selected_ADCs_CH4;								// Selected ADC_CH4

char SelectedCursor;										// Which Cursor is selected
char SelectedCursorOld;										// Which Cursor was selected

char Cursor_Enabled;
char Cursor_Enabled_Old;
char CursorChanged;										// Was Cursor changed

char Cursor_XY_Selected;									// 0 = X selected, 1 = Y selected
char Cursor_XY_Selected_Old;									// 0 = X selected, 1 = Y selected

char Cursor_Both_Selected;
char Cursor_Both_Selected_Old;

char Cursor_Horizontal_Active; 									// 0 = Off
char Cursor_Horizontal_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long Cursor_Horizontal_Position_Real1;								// Store Real Cursor Position
long Cursor_Horizontal_Position_Real2;								// Store Real Cursor Position

long Cursor_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long Cursor_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char Cursor_Vertical_Active;									// 0 = Off
char Cursor_Vertical_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long Cursor_Vertical_Position_Real1;								// Store Real Cursor Position
long Cursor_Vertical_Position_Real2;								// Store Real Cursor Position

long Cursor_Vertical_Position1_Old;								// Store old Cursor vertical I position
long Cursor_Vertical_Position2_Old;								// Store old Cursor vertical II position

long Cursor_Vertical_Position_Real_XY_1;							// Store Real Cursor Position
long Cursor_Vertical_Position_Real_XY_2;							// Store Real Cursor Position

long Cursor_Vertical_Position_XY_1_Old;								// Store old Cursor vertical I position
long Cursor_Vertical_Position_XY_2_Old;								// Store old Cursor vertical II position

char Cursor_Data_Draw_Pos = 0;									// Stores the draw position of the cursor data
char Cursor_Data_First_Draw = 0;								// Is it draw first time ?

char QM_Enabled;
char QM_Enabled_Old;
char QM_Changed[3];										// Was quick measurment changed
char QM_Type[3];                                   					        // What type of measurment (look 1313 -> 52 ...
char QM_Type_Old[3];                                      					// What type of measurment (look 1313 -> 52 ...
char QM_Channel[3];                                         					// What channel is measured
char QM_Second_Channel[3];									// Fore delay / phase measurment
char QM_CHI_Edge[3];                                        					// Fore delay  measurment // 1 = positiv , 2 = negativ
char QM_CHII_Edge[3];                                       					// Fore delay  measurment // 1 = positiv , 2 = negativ

char BufPre[30];
char BufUnit[10];
char BufReturn[30];

char QM_V_A_Buf[1];
char QM_H_A_Buf[1];
    
char QM_Horizontal_Active; 									// 0 = Off
char QM_Horizontal_Active_Old;							     		// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Horizontal_Position_Real1;								// Store Real Cursor Position
long QM_Horizontal_Position_Real2;								// Store Real Cursor Position

long QM_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long QM_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char QM_Vertical_Active;									// 0 = Off
char QM_Vertical_Active_Old;									// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Vertical_Position_Real1;								// Store Real Cursor Position
long QM_Vertical_Position_Real2;								// Store Real Cursor Position

long QM_Vertical_Position1_Old;									// Store old Cursor vertical I position
long QM_Vertical_Position2_Old;									// Store old Cursor vertical II position

char Quick_Measure_Data_Draw_Pos = 0;								// Stores the draw position of the cursor data
char Quick_Measure_First_Draw = 0;								// Is it draw first time ?

char Quick_Measure_Threshold_btn_select;

//Memory Browser depended
char Memory_Window_visible = false;
int mb_window_start_old = 0;
int mb_window_stop_old = 0;
int mb_window_trigger_old = 0;
int mb_window_cursor1_old = 0;
int mb_window_cursor2_old = 0;

int math_mul_scale = 166;
int math_sub_scale = 153;
int math_add_scale = 153;

//Create FloatStr objects
FloatStr Pulse11;
FloatStr Pulse21;
FloatStr Pulse12;
FloatStr Pulse22;

FloatStr Cursor_Delta_X;	
FloatStr Cursor_Delta_1X;
FloatStr Cursor_Delta_XY_X;
FloatStr Cursor_Delta_Y;

FloatStr Cursor_Vertical_Pos_1_Str;
FloatStr Cursor_Vertical_Pos_2_Str;

FloatStr Cursor_Vertical_Pos_XY_1_Str;
FloatStr Cursor_Vertical_Pos_XY_2_Str;
	
FloatStr Cursor_Horizontal_Pos_1_Str;
FloatStr Cursor_Horizontal_Pos_2_Str;

FloatStr QM_Slot1;
FloatStr QM_Slot2;
FloatStr QM_Slot3;

FloatStr QM_Slot1_Value;
FloatStr QM_Slot2_Value;
FloatStr QM_Slot3_Value;

FloatStr QM_Threshold_lower;
FloatStr QM_Threshold_middle;
FloatStr QM_Threshold_upper;

FloatStr Math_Offset;

FloatStr Math_Offset_mul;
FloatStr Math_Offset_sub;
FloatStr Math_Offset_add;

// CursorData Buffer variables

int dcd_channel_buf = -1;
int dcd_volt_buf = -1;
int dcd_zero_buf = -1;
int dcd_voltmfactor_buf = -1;

int dcd_hz1_buf = -1;
int dcd_hz2_buf = -1;
int dcd_vz1_buf = -1;
int dcd_vz2_buf = -1;

double dcd_vfactor_buf = -1;
double voltoff1 = 0;	
double voltoff2 = 0;

int dcd_time_buf = -1;
double dcd_tfactor_buf = -1;

double timeoff1 = 0;	
double timeoff2 = 0;
FloatStr Zero_Level1_Str;
FloatStr Zero_Level2_Str;
FloatStr Zero_Level3_Str;
FloatStr Zero_Level4_Str;
// zerolevel buffer variables

int dzp_channel_buf = -1;
short dzp_fprobe_buf = -1;
char dzp_fselected_voltage_buf = -1;
double dzp_factor_buf = 0;
FloatStr Trigger_Level_Str;
FloatStr Trigger_ExtLevel_Str;
int ct_Selected_Trigger_Source_buf = -1;
int ct_volt_buf = -1;
int ct_voltmfactor_buf = -1;
double ct_vfactor_buf = -1;
double ct_vfactor2_buf = -1;
FloatStr Timebase_Offset_Str;  // unused
FloatStr Trigger_Offset_Str;
FloatStr HoldOff;

FloatStr FFT_Scale_Str;  // unused
FloatStr FFT_Offset_Str;

unsigned short MenuDef[32][3] = {{4, 39, 0x00},		// 00 ACQUIRE	
				 {5, 37, 0x2F},		// 01 CHANNEL 1
				 {5, 37, 0x3E},		// 02 CHANNEL 2
				 {5, 37, 0x26},		// 03 CHANNEL 3
				 {5, 37, 0x0C},		// 04 CHANNEL 4
				 {4, 47, 0x00},		// 05 DISPLAY
				 {2, 42, 0x00},		// 06 UTILITY
				 {6, 48, 0x00},		// 07 FILE
				 {6, 50, 0x00},		// 08 SAVE / RECALL
				 {1, 49, 0x00},		// 09 PRINT
				 {3, 45, 0x00},		// 10 TIMEBASE
				 {2, 24, 0x00},		// 11 DELAYED TIMEBASE
				 {6, 29, 0x00},		// 12 TRIGGER MODE
				 {6, 22, 0x00},		// 13 TRIGGER MODE EXTERNAL	
				 {4, 46, 0x00},		// 14 EDGE
				 {5, 98, 0x00},		// 15 Pulse Width
				 {6, 50, 0x00},		// 16 CURSOR X
				 {4, 50, 0x00},		// 17 Quick Print
				 {4, 50, 0x00},		// 18 Startup
				 {5, 50, 0x00},		// 19 Quick Measurment
				 {6, 45, 0x00},		// 20 QM Delay Settings
				 {6, 50, 0x00},		// 21 QM Phase Settings
				 {6, 50, 0x00},		// 22 QM Thresholds
				 {2, 50, 0x00},		// 23 Autoscale
				 {4, 50, 0x00},		// 24 Trigger Mode TV
				 {0, 50, 0x00},		// 25
				 {5, 50, 0x00},		// 26 Math
				 {6, 50, 0x00},		// 27 FFT Settings
				 {6, 50, 0x00},		// 28 More FFT Settings
				 {6, 50, 0x00},		// 29 Math Settings
				 {0, 50, 0x00},		// 30
				 {0, 50, 0x00}};	// 31

unsigned char MenuText[32][17] = {{"Acquire Menu"},				
				  {"Channel 1 Menu"},
				  {"Channel 2 Menu"},
				  {"Channel 3 Menu"},
				  {"Channel 4 Menu"},
				  {"Display Menu"},
				  {"Utility Menu"},
				  {"Service Menu"},
				  {"Save / Recall"},
				  {"Print Menu"},
				  {"Timebase"},
				  {""},
				  {"Trigger Mode"},
				  {"Trigger"},
				  {"Trigger Edge"},
				  {"Pulse Width"},		// Pulse Width
				  {"Cursor"},			// Cursor X
				  {"Quick Print"},		// Quick Print
				  {"Startup Menu"},		// Startup
				  {"Quick Measure"},		// Quick Measurment
				  {"Settings"},			// QM Settings
				  {"Settings"},	 		// QM Settings
				  {"Thresholds"},		// QM Thresholds
				  {"Pattern = "},		// Pattern
				  {"Trigger Mode TV"},		// Trigger Mode TV
				  {"Autoscale"},		// Autoscale
				  {"Math"},		 	// Math
				  {"FFT Settings"},	 	// FFT Settings
				  {"FFT Settings"},		// More FFT Settings
				  {"Math Settings"},		// Math Settings
				  {"N.A. "},			// 
				  {"N.A."}};			// 
						
								// Position MenuText 
								// Correction		 	
								// smaller = move right
								// bigger = move left

unsigned short MenuItemDef[32][6] ={{30,16, 0, 0, 0, 0},		// 00 ACQUIRE : Normal / Averaging / Avgs / Realtime
				    {11,21,30,26, 0, 0},		// 01 CHANNEL I   : Coupling / BW Limit / Invert / Probe / Units
				    {11,21,30,26, 0, 0},		// 02 CHANNEL II  : Coupling / BW Limit / Invert / Probe / Units
				    {11,21,30,26, 0, 0},		// 03 CHANNEL III : Coupling / BW Limit / Invert / Probe / Units
				    {11,21,30,26, 0, 0},		// 04 CHANNEL IV  : Coupling / BW Limit / Invert / Probe / Units
				    {27,32,36,23,23, 0},		// 05 Display : Persist / Clear Display / Grid / Vectors / Memory Browse
				    {20,27, 0, 0, 0, 0},		// 06 Utility : Calibrate Zero Lines / About Oscilloscope
				    {31,31,23,20, 0, 0},		// 07 Service : Start User Cal / Start Self Test / User Cal Status / RS-232 Setup
				    {30,29,29,22,32, 0},		// 08 Save / Recall : Memory / Save / Recall Trace / Default Setup /Clear Display
				    {28, 0, 0, 0, 0, 0},		// 09 Print
//				    {36,23,36,34, 0, 0},		// 10 Timebase : Main / Delayed / Roll / X - Y
				    {36,23,34, 0, 0, 0},		// 10 Timebase : Main / Delayed / X - Y
				    { 0, 0, 0, 0, 0, 0},		// 11
				    {22,13,16,26,26, 0},		// 12 Trigger Mode : Mode / Coupling / Reject / Holdoff / External Probe
				    { 0, 0, 0, 0, 0, 0},		// 13 Trigger Mode External : Probe
				    {26,11,15,19,26,22},		// 14 Trigger Edge : Rising / Falling // Trigger 1-4 // Extern / Line // TV CH1 // PreTrigger //  TMW added Default
				    {11,32,13,36,36, 0},		// 15 Pulse Width : Source / Pulse / Dir / Lower / Bigger
//				    {11, 0,13,36,36, 0},		// 15 Pulse Width : Source / Pulse / Dir / Lower / Bigger
				    {11,41,41,41,41,35},		// 16 Cursor X : Source, X1, X2, Y1, Y2, X1X2/Y1Y2
				    {22,25,25,25, 0, 0},		// 17 Quick Print : Printer / BMP / JPEG / XLS
				    {24,32,32,16, 0, 0},		// 18 Startup
				    {11,34,23,31,20,12},		// 19 Quick Measurment : Source, Select, Measure Delay, Clear Meas, Settings, Thresholds
				    {11,26,11,26,18,16},		// 20 QM Settings Delay : Source, Edge, Source, Edge, Measure Delay
				    {11, 0,11, 0,18,16},		// 21 QM Settings Phase : Source, Edge, Source, Edge, Measure Delay
				    {11,11,36,36,36,16},		// 22 QM Thresholds : Source , Type, Lower, Middle, Upper
				    {31,25, 0, 0, 0, 0},		// 23 Autoscale : Undo / Search Slow
				    {31,22,21,31,28, 0},		// 24 Trigger Mode TV : Mode, Pos / Neg , Standard, Mode, Count
				    { 0, 0, 0, 0, 0, 0},		// 25
				    {21,33,31,31,31, 0},		// 26 Math
				    {16,16, 0, 0, 0,31},		// 27 FFT Settings
				    { 0, 0, 0, 0, 0,16},		// 28 More FFT Settings
				    {32,27, 0, 0, 0,16},		// 29 Math Settings
				    { 0, 0, 0, 0, 0, 0},		// 30
				    { 0, 0, 0, 0, 0, 0}};		//


unsigned char MenuItem151[16] = {Space, Space, Space, Space, Space, Pos_Pulse, Space, Space, Space, Space};
								
unsigned char MenuItem[32][6][16] = {{{"Normal"},{"Averaging"},{""},{""},{""},{""}},					// ACQUIRE
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ["},{"{  Units"},{""}},		// CHANNEL 1
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe \\"},{"{  Units"},{""}},		// CHANNEL 2
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ]"},{"{  Units"},{""}},		// CHANNEL 3
				     {{"{Coupling"},{"BW Limit"},{"Invert"},{"Probe ^"},{"{  Units"},{""}},		// CHANNEL 4
				     {{"Persist"},{"Clear"},{"Grid"},{"Vectors"},{"Browse"},{""}},	    		// DISPLAY
				     {{"Calibrate"},{"About"},{""},{""},{""},{""}},					// Utility
				     {{"Start"},{"Start"},{"User Cal"},{"RS-232"},{""},{""}},				// Service Menu
				     {{"Memory"},{"Save"},{"Recall"},{"Default"},{"Clear"},{""}},	                // Save / Recall
				     {{"Cancel"},{""},{""},{""},{"{"},{""}},						// 	
//				     {{"Main"},{"Delayed"},{"Roll"},{"X - Y"},{""},{""}},				// Timebase
				     {{"Main"},{"Delayed"},{"X - Y"},{""},{""},{""}},					// Timebase
				     {{""},{""},{""},{""},{""},{""}},
				     {{"{   Mode"},{"{ Coupling"},{"{ Reject"},{"Holdoff"},{"Probe `"},{""}},           // Triggert Mode
				     {{""},{""},{""},{""},{""},{""}},							//
				     {{"}         ~"},{"{ Source"},{"{    Ext"},{"{ TV  ["},{"PreTrig"},{"Default"}},	// Edge TMW added  Default
//				     {{"{ Source"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"@ t"}}, 		// Pulse Width
				     {{"{ Source"},{Space, Space, Space, Space, Pos_Pulse, Space, Space, Space, Space, Space},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"@ t"}}, // Pulse Width
				     {{"{  Source"},{"X1"},{"X2"},{"Y1"},{"Y2"},{"X1   X2"}}, 				// Cursor X
				     {{"Print to"},{"Save to"},{"Save to"},{"Save to"},{""},{""}}, 			//
				     {{"Getting"},{"Using"},{"About"},{"Language"},{""},{""}}, 				// Startup
				     {{"{ Source"},{"Select:"},{"Measure"},{"Clear"},{"Setting"},{"Thresholds"}},	// Quick Measurment
				     {{"{ Source1"},{"}        ~"},{"{ Source2"},{"}        ~"},{"Measure"},{""}},	// Quick Measurment Delay Settings
				     {{"{ Source1"},{""},{"{ Source2"},{""},{"Measure"},{""}},		                // Quick Measurment Phase Settings
				     {{"{ Source"},{"{ Type"},{"Lower"},{"Middle"},{"Upper"},{""}},			// Quick Measurment Thresholds
				     {{"Undo"},{"Slow TB"},{""},{""},{""},{""}},				        // Autoscale
				     {{"Mode"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{"Standard"},{"Mode"},{""},{""}},	// Trigger Mode TV
				     {{""},{""},{""},{""},{""},{""}},//
				     {{"Settings"},{"FFT"},{"1  *  2"},{"1  -  2"},{"1  +  2"},{""}},  			// Math	
				     {{"{ Source"},{" Window"},{""},{"{"},{""},{""}},			                // FFT Settings
				     {{""},{""},{""},{""},{""},{""}},
				     {{"Scale"},{"Offset"},{""},{""},{""},{""}},					// Math Settings
				     {{""},{""},{""},{""},{""},{""}},	
				     {{""},{""},{""},{""},{""},{""}}};													//

unsigned char MenuEdgeBufText[7] = 	{"{     "};


					// [MenuData] //Offse		
unsigned short MenuDataDef[193] = {36, 43, 21, 61,						//   0
				   41, 41, 								//   4
				   19, 36, 36, 							//   6
				   36, 36, 								//   9
				   36, 36, 								//  11
				   36, 36, 36, 36, 36, 					//  13
				   22, 16,  8, 							//  18
				   23, 23, 23,							//  21
				   25, 23, 23,							//  24
				   50, 46, 46, 46, 33,					//  27
				   23, 24, 26,							//  32
				   31, 18, 26,							//  35
				   21, 21, 28, 27,						//  38
				   15, 15, 15,							//  42
				   15, 35, 15, 15,						//  45
				   40, 15, 17,							//  49
				   16, 18, 29, 26,						//  52
				   14, 18, 18,							//  56
				   18, 21, 16,							//  59
				   26, 28, 17,							//  62
				   32, 32, 24, 24,						//  65
				   0,  0,  0,  0,						//  69
				   0,									//  73
				   46, 46, 46, 46, 43, 43, 43,			//  74
				   40, 40, 40, 36, 36,					//  81
				   30, 30, 30,							//  86
				   24, 24,								//  89
				   28, 									//  91
				   16, 31, 26,							//  92
				   40, 40, 20, 20,						//  95
				   30, 30,								//  99
				   31, 31, 31,							// 101
				   31, 31, 31,							// 104
				   31, 31, 31,							// 107
				   31, 31, 31, 31,						// 110
				   31, 31, 26, 31, 31,					// 114
				   26, 26, 26,							// 119
				   26, 26, 16,							// 122
				   16, 10,  4,							// 125
				   31, 26, 26, 26, 21,					// 128
				   41, 37, 36, 33, 31,					// 133
				   45, 41, 41, 41, 21,					// 138
				   31, 25, 29, 29, 36,	                // 143
				   23, 36, 29, 36, 36,	                // 148	
				   33, 32, 32, 31, 30,	                // 153	
				   30, 42, 41, 41, 39,	                // 158	
				   38, 38, 36, 34, 33,	                // 163	
				   33, 32, 31, 31, 25,	                // 168	
				   24, 24, 40, 39, 39,	                // 173	
				   35, 34, 34, 32, 21,	                // 178	
				   20, 21, 29, 36, 36,	                // 183	
				   23, 36, 29, 36, 36};	                // 188	
		
				   // [MenuStausNr] [L�nge]
char MenuData[193][16] =  {"   ", {Menu_Select}, {Menu_Select}, {Menu_Select},
						   "On", "Off", 								// 4
						   "Ground", "AC", "DC", 						// 6
						   "20MHz", "100MHz", 							// 9
					     	   "2 x 2", "12 x 12", 							// 11
						   "128KB", "32KB", "8KB", "1KB", "X - Y",		// 13
						   "Started", "Quick Help", "Oscilloscope", 	// 18
						   "English", "Deutsch", "Chinese",				// 21
						   "Normal", "Binary", "Hex",					// 24
						   "1", "2", "3", "4", "Math", 					// 27
						   "Left", "Center", "Right",					// 32
						   "Delay", "Measure", "Display",				// 35
						   "User Cal", "Self Test", "Status", "Recall",	// 38
						   "INTERN_0", "INTERN_1", "INTERN_2",			// 42
						   "Character", "Y1   Y2", "Autoscale", "",		// 45
						   "%", "Absolute", "Zero Lines",		        // 49
						   "Average", "Delay", "Duty Cycle", "Fall Time",// 52
						   "Freqency", "Maximum", "Minimum", 		    // 56
						   "Peak-Peak", "Period", "Phase",			    // 59
						   "Rise Time", "RMS", "+ Width",               // 62
						   "- Width", "", "", "",		                // 65
						   "", "", "", "",	                            // 69
						   "",							             	// 73
						   "1", "2", "4", "8", "16", "32", "64",		// 74
						   "128", "256", "512", "1024", "2048",			// 81
						   "4096", "8192", "16384",						// 86
						   "Ext", "Line", 								// 89
						   "<None>", 									// 91
						   "Auto Level", "Auto", "Normal",				// 92
						   "DC", "AC", "LF Reject", "HF Reject",		// 95
						   "Volts", "Amps",								// 99
						   "0.1 : 1", "0.2 : 1", "0.5 : 1",				// 101
						   "1 : 1", "2 : 1", "5 : 1",			   	    // 104
						   "10 : 1", "20 : 1", "50 : 1",				// 107
						   "100 : 1", "200 : 1", "500 : 1", "1000 : 1",	// 110
						   "NTSC", "PAL", "SECAM", "PAL-M",	"Generic", 	// 114
						   "Field 1", "Field 2", "All Fields", 			// 119
						   "All Lines", "Vertical", "Line: Field 1",	// 122
						   "Line: Field 2", "Line: Altern.", "Count:Vertic.",	// 125   "Line:Alternate", "Count:Vertical"
						   "9600", "19200", "38400", "56700", "115000",	// 128								
						   "0 %", "33 %", "66 %", "100 %", "",			// 133
						   "1", "2", "3", "4", "External",				// 138	
                           			   "Start", "Cancel", "Setup", "Trace", "Busy", // 143
                           			   "Printer", "BMP", "JPEG", "XLS", "PDF",      // 148
						   "10mV", "20mV", "50mV", "100mV", "200mV",	// 153
						   "500mV", "1V", "2V", "5V", "10V",		    // 158
						   "20V", "50V", "100V", "1mV�", "2mV�",		// 163
						   "5mV�", "10mV�", "20mV�", "50mV�", "100mV�",	// 168
						   "200mV�", "500mV�", "1V�", "2V�", "5V�",		// 173
						   "10V�", "20V�", "50V�", "100V�", "Rectangle",// 178
						   "Hanning", "Flat-Top", "", "", "",			// 183
						   "", "", "", "", ""};				            // 188
						   
					// [MenuNr][ItemNr]			
short MenuStatus[32][6] = {{   1,   0,   0,   0,   0,   0}, 	//  0 Acquire
			   {   8, 240, 240, 104,   0,   0}, 	//  1 Channel 1
			   {   8, 240, 240, 104,   0,   0}, 	//  2 Channel 2
			   {   8, 240, 240, 104,   0,   0}, 	//  3 Channel 3
			   {   8, 240, 240, 104,   0,   0}, 	//  4 Channel 4
			   { 240,  37, 136, 241, 180,   0}, 	//  5 Display
			   {  51,  20,   0,   0,   0,   0}, 	//  6 Utility
			   {  38,  39,  40, 242,   0,   0}, 	//  7 Service
			   {   0,   0, 146, 145,  37,   0}, 	//  8 Save / Recall
			   {   0,   0,   0,   0,   0,   0}, 	//  9 
			   {   1,   0,   0,   0,   0,   0}, 	// 10 Main / Delayed
			   {   0,   0,   0,   0,   0,   0}, 	// 11
			   {  93,  95,  97,   0, 104,   0}, 	// 12 Trigger Mode / Coupling
			   {   0,   0,   0,   0,   0,   0}, 	// 13
			   {   2, 138,   0,   0,   0, 145}, 	// 14 Edge //TMW added 145; print "Setup"						
			   { 138,   1,   3,   0,   0,   0}, 	// 15 Pulse Width
//			   { 138,   2,   3,   0,   0,   0}, 	// 15 Pulse Width						
			   {  27,   0,   0,   0,   0,  46}, 	// 16 Cursor X
			   { 248, 149, 150, 151,   0,   0}, 	// 17 Quick Print
			   {  18,  19,  20,  21,   0,   0},	// 18 Startup
			   {  27,  52,  52,  36, 244, 242},	// 19 Quick Measurment
			   {  27,   2,  28,   2,  52, 243},	// 20 QM Delay Settings
			   {  27,   0,  28,   0,  52, 243},	// 21 QM Phase Settings						
			   {  27,  49,   0,   0,   0, 243}, 	// 22 QM Thresholds										
			   {  47, 241,   0,   0,   0,   0},	// 23 Autoscale
			   {  93,   2, 114, 119,   0,   0},	// 24 Trigger Mode TV
			   {   0,   0,   0,   0,   0,   0},	// 25 
			   { 242,   0,   0,   1,   0,   0},	// 26 Math
			   { 138, 182,   0,   0,   0, 243},	// 27 FFT Settings
 			   {   0,   0,   0,   0,   0, 243}, 	// 28
			   {   0,   0,   0,   0,   0, 243}, 	// 29 Math Settings
			   {   0,   0,   0,   0,   0,   0}, 	// 30 
			   {   0,   0,   0,   0,   0,   0}}; 	// 31 

/*
	"On", "Off", 						// 4
	"Ground", "DC", "AC", 					// 6
	"20MHz", "100MHz", 					// 9
	"2 x 2", "12 x 12", 					// 11
	"128KB", "32KB", "8KB", "1KB", "X - Y",			// 13
	"Started", "Quick Help", "Oscilloscope", 		// 18
	"English", "Deutsch", "Chinese",			// 21
	"Normal", "Binary", "Hex",				// 24
	"1", "2", "3", "4", "Math", 				// 27
	"Left", "Center", "Right",				// 32
	"Delay", "Meas", "Display",				// 35
	"User Cal", "Self Test", "Status", "Recall",		// 38
	"INTERN_0", "INTERN_1", "INTERN_2",			// 42
	"Character", "Y1 Y2", "", "",				// 45
	"%", "Absolute", "",					// 49
	"Amplitude", "Average", "Base", "Counter", 		// 52 
	"Delay", "Duty Cycle", "Fall Time", 			// 56
	"Freqency", "Maximum", "Minimum",			// 59
	"Overshoot", "Peak-Peak", "Period",			// 62
	"Phase", "Preshoot", "Rise Time", "RMS",		// 65
	"Top", "+ Width", "- Width", "X at Max Y",		// 69
	"X at Min Y",						// 73
	"1", "2", "4", "8", "16", "32", "64",			// 74
	"128", "256", "512", "1024", "2048",			// 81
	"4096", "8192", "16383",				// 86
	"Ext", "Line", 						// 89
	"<None>", 						// 91
	"Auto Level", "Auto", "Normal",				// 92
	"DC", "AC", "LF Reject", "TV",				// 95
	"Volts", "Amps",					// 99
	"0.1 : 1", "0.2 : 1", "0.5 : 1",			// 101
	"1.0 : 1", "2.0 : 1", "5.0 : 1",			// 104
	"10 : 1", "20 : 1", "50 : 1",				// 107
	"100 : 1", "200 : 1", "500 : 1", "1000 : 1",		// 110
	"NTSC", "PAL", "PAL-M", "SECAM",	"Generic", 	// 114
	"Field 1", "Field 2", "All Fields", 			// 119
	"Vertical", "All Lines", "Line: Field 1",		// 122
	"Line: Field 2", "Line: Altern.", "Count:Vertic.",	// 125
	"Line:Alternate", "Count:Vertical"
	"9600", "19200", "38400", "56700", "115000",		// 128
	"Setup", "Trace", "", "", "",				// 133
	"1", "2", "3", "4", "External",				// 138	
	"Start", "Cancel", "Setup", "Trace", "Busy", 		// 143
	"Printer", "BMP", "JPEG", "XLS", "PDF",      		// 148
	"Small TB", "", "", "", ""};				// 153
*/								
								
								// 240 Unchecked Checkbox
								// 241 Checked Checkbox
								// 242 Menu Down Arrow
								// 243 Menu Up Arrow
								// 244 Menu Down Arrow Grayed
								// 245 Menu Up Arrow Grayed
								// 246 Menu Grayed
								// 247 Sub Menu
								// QM und Cursor Source wenn Math erste 0 = 1

// 0 = Not Availble / 1 = Deactive (grayed) / 2 = Active / 3 = Selected
short MenuPopupStatus[31][22] = {{ 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  0
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  1 Cursor Source
				 { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  2 (empty)
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  3 Quick Measurement Source
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  4 Quick Measurement Select
				 { 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  5 Quick Measurement Delay Settings Source1
				 { 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  6 Quick Measurement Delay Settings Source2
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  7 Pulse Width Source
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  8 Trigger Edge External Source
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  9 Trigger Mode
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 10 Trigger Mode Coupling
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 11 Trigger Mode External TV
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 12 Trigger Mode Reject
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 13 Channel 1
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 14 Channel 2
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 15 Channel 3
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 16 Channel 4
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 17 Probe Channel 1
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 18 Probe Channel 2
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 19 Probe Channel 3
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 20 Probe Channel 4
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 21 Trigger Mode TV Mode Standard
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 22 Trigger Mode TV Mode Mode
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 23 Save / Recall Memory
				 { 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 24 Quick Measurement Phase Settings Source1
				 { 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 25 Quick Measurement Phase Settings Source2
				 { 3, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 26 Quick Measurement Threshold Source
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 27 Quick Measurement Threshold (Percent , Absolute)
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 28 Trigger Source
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 29 FFT Source
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}; 	// 30 FFT Window

									//Pos // ItemCount
unsigned short MenuPopupDef[31][2] =	{{0, 5},
				       	 {0, 4},
					 {3, 3},
				 	 {0, 4},
					 {1, 14},
					 {0, 5},
					 {2, 5},
					 {0, 5},
					 {2, 3},
					 {0, 2},
					 {1, 2},
					 {3, 2},
					 {2, 2},
					 {0, 3},
					 {0, 3},
					 {0, 3},
					 {0, 3},
					 {4, 2},
					 {4, 2},
					 {4, 2},
					 {4, 2},
					 {2, 3},
					 {3, 4},
					 {0, 4},
					 {0, 5},
					 {2, 5},
					 {0, 5},
					 {1, 2},
					 {1, 4},
					 {0, 4},
					 {1, 3}};

									// Caption	/ Items ->
char MenuPopupText[31][23][20] =  {{{"Baud"}, {"9600"}, {"19200"}, {"38400"}, {"56700"}, {"115000"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, 	{""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Time Reference"}, {"Left"}, {"Center"}, {"Right"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Select Measurement"}, {"Average"}, {"Delay"}, {"Duty Cycle"}, {"Fall Time"}, {"Freqency"}, {"Maximum"}, {"Minimum"}, {"Peak-Peak"}, {"Period"}, {"Phase"}, {"Rise Time"}, {"RMS"}, {"+ Width"}, {"- Width"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"External"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"Ext LF Rej"}, {"Ext HF Rej"}, {"Line"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Mode"}, {"Auto"}, {"Normal"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Coupling"}, {"DC"}, {"AC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"TV  ["}, {"Vert Sync"}, {"Comp Sync"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Reject"}, {"LF Reject"}, {"HF reject"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Coupling"}, {"Ground"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Units"}, {"Volt"}, {"Amps"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Units"}, {"Volt"}, {"Amps"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Units"}, {"Volt"}, {"Amps"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Units"}, {"Volt"}, {"Amps"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Standard"}, {"NTSC"}, {"PAL"}, {"SECAM"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Mode"}, {"Field 1"}, {"Field 2"}, {"All Fields"}, {"All Lines"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Type"}, {"Persent"}, {"Absolute"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},
				   {{"Windows"}, {"Rectangle"}, {"Hanning"}, {"Flat-Top"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}}};

                            	
//char SampleRateData[15][10] = {"4.00kSa/s", "10.0kSa/s", "20.0kSa/s", "40.0kSa/s", "100kSa/s", "200kSa/s", "400kSa/s", "1.00MSa/s", "2.00MSa/s", "4.00MSa/s", "10.0MSa/s", "20.0MSa/s", "25.0MSa/s", "100MSa/s", "200MSa/s"};

char Stringlist[1][32] = {"Sample Rate = "};
	
	
char PatternStatus[5] = {3, 3, 3, 3, 3};
																
// Kann warscheinlich weg
unsigned short TriggerDataDef[11] = {60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60};

unsigned char TriggerData[11][12] = {"+ Extern", "- Extern", "+ LF Reject", "-LF Reject", "+ HF Reject", "- HF Reject", 
								     "+ Line", "- Line", "TV VS", "TV Odd", "TV Even"};
		
unsigned short TimebaseDataDef[34] = {10, 10,  7,  6,  6,  2,  1,  1,
							  	 	  11, 10, 10,  7,  6,  6,  2,  1,  1,
							  	 	  10,  9,  9,  5,  4,  4,  1,  0,  0,
							 	 	  12, 11, 11,  8,  7,  7,  3,  3};

unsigned char TimebaseData[34][10] = 	{{'2', S_nS, S_Slash},
					 {'5', S_nS, S_Slash},
					 {'1', '0', S_nS, S_Slash},
					 {'2', '0', S_nS, S_Slash},
					 {'5', '0', S_nS, S_Slash},
					 {'1', '0', '0', S_nS, S_Slash},
					 {'2', '0', '0', S_nS, S_Slash},
					 {'5', '0', '0', S_nS, S_Slash},
					 {'1', S_uS, S_Slash},
					 {'2', S_uS, S_Slash},
					 {'5', S_uS, S_Slash},
					 {'1', '0', S_uS, S_Slash},
					 {'2', '0', S_uS, S_Slash},
					 {'5', '0', S_uS, S_Slash},
					 {'1', '0', '0', S_uS, S_Slash},
					 {'2', '0', '0', S_uS, S_Slash},
					 {'5', '0', '0', S_uS, S_Slash},
					 {'1', S_mS, S_Slash},
					 {'2', S_mS, S_Slash},
					 {'5', S_mS, S_Slash},
					 {'1', '0', S_mS, S_Slash},
					 {'2', '0', S_mS, S_Slash},
					 {'5', '0', S_mS, S_Slash},
					 {'1', '0', '0', S_mS, S_Slash},
					 {'2', '0', '0', S_mS, S_Slash},
					 {'5', '0', '0', S_mS, S_Slash},
					 {'1', S_S, S_Slash},
					 {'2', S_S, S_Slash},
					 {'5', S_S, S_Slash},
					 {'1', '0', S_S, S_Slash},
					 {'2', '0', S_S, S_Slash},
					 {'5', '0', S_S, S_Slash},
					 {'1', '0', '0', S_S, S_Slash},
					 {'2', '0', '0', S_S, S_Slash}};
		
unsigned short SampleRateDataDef[34] = {10, 10, 10, 10, 10,  0,  0,  0,		
                                        10, 10, 10, 10, 10, 10,  0,  0,
                                         0, 10, 10, 10, 10, 10, 10,  0,
                                         0,  0, 10, 10, 10, 10, 10, 10, 10, 10};
		
unsigned char SampleRateData[34][11] = {{"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"500 MSa/s "}, {"250 MSa/s "}, {"100 MSa/s "},
                                        {"50 MSa/s "}, {"25 MSa/s "}, {"10 MSa/s "}, {"5 MSa/s "}, {"2.5 MSa/s "}, {"1 MSa/s "}, {"500 kSa/s "}, {"250 kSa/s "},
                                        {"100 kSa/s "}, {"50 kSa/s "}, {"25 kSa/s "}, {"10 kSa/s "}, {"5 kSa/s "}, {"2.5 kSa/s "}, {"1 kSa/s "}, {"500 Sa/s "},
                                        {"250 Sa/s "}, {"100 Sa/s "}, {"50 Sa/s "}, {"25 Sa/s "}, {"10 Sa/s "}, {"5 Sa/s "}, {"2.5 Sa/s "}, {"1 Sa/s "}, {"1 Sa/s "}, {"1 Sa/s "}};
		
const short TimebaseData_Matrix[34][5][10] = {{{'2', S_nS, S_Slash}, {'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}},                             // 2 ns
                                              {{'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}},                   // 5 ns
                                              {{'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}},         // 10 ns
                                              {{'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}},    // 20 ns
                                              {{'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}},         // 50 ns
                                              {{'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}},              // 100 ns
                                              {{'2', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}},                                  // 200 ns
                                              {{'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}},                             // 500 ns
                                              {{'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}},                                  // 1 �s
                                              {{'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}},                             // 2 �s
                                              {{'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}},                   // 5 �s
                                              {{'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}},         // 10 �s
                                              {{'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}},    // 20 �s
                                              {{'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}},         // 50 �s
                                              {{'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}},              // 100 �s
                                              {{'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}},                        // 200 �s
                                              {{'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}},                             // 500 �s
                                              {{'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}},                                  // 1 ms
                                              {{'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}},                             // 2 ms
                                              {{'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}},                   // 5 ms
                                              {{'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}},         // 10 ms
                                              {{'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}},    // 20 ms
                                              {{'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}},          // 50 ms
                                              {{'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}},                // 100 ms
                                              {{'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}},                           // 200 ms
                                              {{'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}},                                 // 500 ms
                                              {{'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}},                                       // 1 s
                                              {{'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}},                                  // 2 s
                                              {{'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}},                        // 5 s
                                              {{'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}},              // 10 s
                                              {{'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}},         // 20 s
                                              {{'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}}, // 50 s

                                              {{'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, {'2', '0', '0', '0', S_S, S_Slash}},         // 100 s
                                              {{'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, {'2', '0', '0', '0', S_S, S_Slash}, {'4', '0', '0', '0', S_S, S_Slash}}}; // 200 s

const float Timebase_Delayed_Factor_Matrix[34][5] = {{          2,            5,           10,           20,            50},
                                                     {          5,           10,           20,           50,           100},
                                                     {         10,           20,           50,          100,           200},
                                                     {         20,           50,          100,          200,           500},
                                                     {         50,          100,          200,          500,          1000},
                                                     {        100,          200,          500,         1000,          2000},
                                                     {        200,          500,         1000,         2000,          5000},
                                                     {        500,         1000,         2000,         5000,         10000},
                                                     {       1000,         2000,         5000,        10000,         20000},
                                                     {       2000,         5000,        10000,        20000,         50000},
                                                     {       5000,        10000,        20000,        50000,        100000},
                                                     {      10000,        20000,        50000,       100000,        200000},
                                                     {      20000,        50000,       100000,       200000,        500000},
                                                     {      50000,       100000,       200000,       500000,       1000000},
                                                     {     100000,       200000,       500000,      1000000,       2000000},
                                                     {     200000,       500000,      1000000,      2000000,       5000000},
                                                     {     500000,      1000000,      2000000,      5000000,      10000000},
                                                     {    1000000,      2000000,      5000000,     10000000,      20000000},
                                                     {    2000000,      5000000,     10000000,     20000000,      50000000},
                                                     {    5000000,     10000000,     20000000,     50000000,     100000000},
                                                     {   10000000,     20000000,     50000000,    100000000,     200000000},
                                                     {   20000000,     50000000,    100000000,    200000000,     500000000},
                                                     {   50000000,    100000000,    200000000,    500000000,    1000000000},
                                                     {  100000000,    200000000,    500000000,   1000000000,    2000000000},
                                                     {  200000000,    500000000,   1000000000,   2000000000,    5000000000},
                                                     {  500000000,   1000000000,   2000000000,   5000000000,   10000000000},
                                                     { 1000000000,   2000000000,   5000000000,  10000000000,   20000000000},
                                                     { 2000000000,   5000000000,  10000000000,  20000000000,   50000000000},
                                                     { 5000000000,  10000000000,  20000000000,  50000000000,  100000000000},
                                                     {10000000000,  20000000000,  50000000000, 100000000000,  200000000000},
                                                     {20000000000,  50000000000, 100000000000, 200000000000,  500000000000},
                                                     {50000000000, 100000000000, 200000000000, 500000000000, 1000000000000},// nachfolgende noch anpassen
                                                     {50000000000, 100000000000, 200000000000, 500000000000, 1000000000000},
                                                     {50000000000, 100000000000, 200000000000, 500000000000, 1000000000000}};

// Kann warscheinlich weg
const unsigned short VoltageDataDef[11] = {57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};

const char VoltageData[11][5] =  {{S_uV, S_Slash}, {S_mV, S_Slash}, {S_V, S_Slash}, {S_kV, S_Slash},
	 						      {S_uA, S_Slash}, {S_mA, S_Slash}, {S_A, S_Slash}, {S_kA, S_Slash},
							      {}, {}, {}};
							      
const float Voltage_Value_Matrix[12][13] = {{0.0001, 0.0002, 0.0005, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1},
                                            {0.0002, 0.0004, 0.001, 0.002, 0.004, 0.01, 0.02, 0.04, 0.1, 0.2, 0.4, 1, 2},
                                            {0.0005, 0.001, 0.0025, 0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1, 2.5, 5},
                                            {0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1, 2, 5, 10},
                                            {0.002, 0.004, 0.01, 0.02, 0.04, 0.1, 0.2, 0.4, 1, 2, 4, 10, 20},
                                            {0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1, 2.5, 5, 10, 25, 50},
                                            {0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1, 2, 5, 10, 20, 50, 100},
                                            {0.02, 0.04, 0.1, 0.2, 0.4, 1, 2, 4, 10, 20, 40, 100, 200},
                                            {0.05, 0.1, 0.25, 0.5, 1, 2.5, 5, 10, 25, 50, 100, 250, 500},
                                            {0.1, 0.2, 0.5, 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000},
                                            {0.2, 0.4, 1, 2, 4, 10, 20, 40, 100, 200, 400, 1000, 2000},
                                            {0.5, 1, 2.5, 5, 10, 25, 50, 100, 250, 500, 1000, 2500, 5000}};


                                 
//FONT 10x9 BITMAPS ...........................................................
unsigned char FONT10X9[100][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
								  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!)
								
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;34 (") 
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;35 (#) #
						
        						 {0xF8,0x03,0x18,0x00,0x60,0x00,0x80,0x01,0x60,0x00,0x18,0x00,0xF8,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;36 ($) kleines gro�es M
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;37 (%) 
								
        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;38 (&) �
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;39 (')
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;41  ) 
								
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) 
						
        						 {0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						
		   						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;44 (,)
						
		        				 {0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -
						
        						 {0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;46 (.) .
						
        						 {0x00,0x03,0xE0,0x00,0x1C,0x00,0x03,0x00,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
						
        						 {0xFE,0x01,0xFF,0x03,0x01,0x02,0x01,0x02,0xFF,0x03,0xFE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;48 (0) 0
						
		        				 {0x0C,0x00,0x06,0x00,0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;49 (1) 1
						
        						 {0x02,0x03,0x83,0x03,0xE1,0x02,0x71,0x02,0x3F,0x02,0x0E,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;50 (2) 2
						
        						 {0x02,0x01,0x03,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;51 (3) 3
											
        						 {0xC0,0x00,0xB0,0x00,0x8C,0x00,0xFF,0x03,0xFF,0x03,0x80,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;52 (4) 4
						
		        				 {0x1C,0x01,0x1F,0x03,0x0B,0x02,0x09,0x02,0xF9,0x03,0xF1,0x01,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;53 (5) 5
								
        						 {0xFC,0x01,0xFE,0x03,0x11,0x02,0x11,0x02,0xF3,0x03,0xE2,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;54 (6) 6
						
        						 {0x01,0x00,0x81,0x03,0xF1,0x03,0x7D,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;55 (7) 7
						
        						 {0xEE,0x01,0xFF,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;56 (8) 8
						
		        				 {0x1E,0x01,0x3F,0x03,0x21,0x02,0x21,0x02,0xFF,0x01,0xFE,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;57 (9) 9
						
        						 {0x18,0x03,0x18,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;58 (:) :
						
        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   ;59 (;) Menu Hacken
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;60 (<)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;61 (=) 
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;62 (>)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;63 (?)
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;64 (@) 
						
        						 {0x00,0x03,0xE0,0x03,0xFC,0x00,0x9F,0x00,0x83,0x00,0x9F,0x00,0xFC,0x00,
						  		  0xE0,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;66 (B) B
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x01,0x02,0x03,0x03,
						  		  0x02,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x03,0xFF,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,0xFC,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0x01,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x00,0x11,0x00,0x11,0x00,0x01,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;70 (F) F
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x21,0x02,0x21,0x02,0xE3,0x03,
						  		  0xE2,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;71 (G) G
						
		        				 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;73 (I) I
						
        						 {0x80,0x01,0x80,0x03,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x03,0xFF,0x03,0x30,0x00,0x1C,0x00,0xFE,0x00,0xE3,0x03,0x01,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x03,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x03,0xFF,0x03,0x0F,0x00,0xFC,0x01,0x80,0x03,0xFC,0x01,0x0F,0x00,
						  		  0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x03,0xFF,0x03,0x0E,0x00,0x38,0x00,0xE0,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;78 (N) N
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x21,0x00,0x3F,0x00,0x1E,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;80 (P) P
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x81,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x61,0x00,0xFF,0x01,0x9E,0x03,
						  		  0x00,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x0E,0x01,0x1F,0x03,0x39,0x02,0x31,0x02,0x71,0x02,0xE3,0x03,0xC2,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x01,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x1F,0x00,0xFC,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xFC,0x00,
						  		  0x1F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x03,0x00,0x7F,0x00,0xFC,0x03,0x80,0x03,0xF8,0x03,0x7F,0x00,0x07,0x00,
						  		  0x7F,0x00,0xF8,0x03,0x80,0x03,0xFC,0x03,0x7F,0x00,0x03,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x03,0x87,0x03,0xFC,0x00,0x78,0x00,0xFC,0x00,0x87,0x03,0x03,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x03,0x00,0x07,0x00,0x1C,0x00,0xF8,0x03,0xF8,0x03,0x1C,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x01,0x03,0x81,0x03,0xE1,0x02,0x79,0x02,0x1D,0x02,0x07,0x02,0x03,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e
						
        						 {0x90,0x01,0xC8,0x03,0x68,0x02,0x28,0x02,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x03,0xFF,0x03,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0x18,0x03,0x10,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xFF,0x03,0xFF,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xF0,0x01,0xF8,0x03,0x48,0x02,0x48,0x02,0x78,0x03,0x70,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x08,0x00,0xFE,0x03,0xFF,0x03,0x09,0x00,0x01,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xF0,0x09,0xF8,0x13,0x08,0x12,0x10,0x11,0xF8,0x1F,0xF8,0x0F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x03,0xFB,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x10,0x00,0x10,0xFB,0x1F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x03,0xFF,0x03,0x60,0x00,0xF0,0x01,0x98,0x03,0x08,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF8,0x03,0x10,0x00,
						  		  0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x1F,0xF8,0x1F,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xF8,0x1F,0xF8,0x1F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x03,0xF8,0x03,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x30,0x01,0x78,0x03,0x68,0x02,0xC8,0x02,0xD8,0x03,0x90,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x08,0x00,0xFC,0x01,0xFE,0x03,0x08,0x02,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;117 (u)  u

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;118 (v)  v

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x80,0x03,0xF0,0x01,0x38,0x00,0xF0,0x01,
						  		  0x80,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;119 (w)  w

        						 {0x18,0x03,0xB8,0x03,0xE0,0x00,0xE0,0x00,0xB8,0x03,0x18,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;120 (x)  x

        						 {0x18,0x10,0xF8,0x10,0xE0,0x1F,0x00,0x1F,0xE0,0x07,0xF8,0x00,0x18,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;121 (y)  y

        						 {0x08,0x03,0xC8,0x03,0xE8,0x02,0x38,0x02,0x18,0x02,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;122 (z)  z 
						
        						 {0x10,0x00,0x18,0x00,0xFC,0x01,0xFE,0x01,0xFC,0x01,0x18,0x00,0x10,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;123 ({)  Big Arrow Up

        						 {0x20,0x00,0x60,0x00,0xFE,0x00,0xFE,0x01,0xFE,0x00,0x60,0x00,0x20,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;124 (|)  Big Arrow Down

        						 {0x20,0x00,0x30,0x00,0x38,0x00,0xFD,0x00,0x39,0x01,0x31,0x02,0x21,0x04,
						  		  0x01,0x04,0x01,0x04,0x01,0x04,0x01,0x04,0x02,0x02,0x04,0x01,0xF8,0x00}, //   ;125 (})  Cycle Arrow

								 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;126 (~) 
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;127 (�)
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;128
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;129
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;130
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}};//    ;131
						
//FONT 12x9 BITMAPS ...........................................................
unsigned char FONT12X9[120][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0xFF,0x0D,0xFF,0x0D,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!) !
								
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;34 (") "
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;35 (#) #
						
        						 {0xF0,0x0F,0xF0,0x0F,0xF0,0x00,0xC0,0x07,0x00,0x0E,0xC0,0x07,0xF0,0x00,
						  		  0xF0,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;36 ($) kleines gro�es M f�r Main Timebase
						
		        				 {0x0E,0x00,0x1F,0x00,0x11,0x00,0x1F,0x06,0x8E,0x07,0xE0,0x01,0x78,0x00,
						  		  0x9E,0x03,0xC7,0x07,0x41,0x04,0xC0,0x07,0x80,0x03,0x00,0x00,0x00,0x80}, //   ;37 (%) %
								
        						 {0xF8,0x7F,0xF8,0x7F,0x00,0x04,0x00,0x0C,0x00,0x06,0xF8,0x0F,0xF8,0x0F,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;38 (&) �
						
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;39 (') '
						
        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x01,0x40,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x01,0x40,0x0F,0x78,0xFE,0x3F,0xF0,0x07,0x00,0x00,0x00,0x80,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;41  ) 

        						 {0x50,0x00,0x50,0x00,0x38,0x00,0x50,0x00,0x50,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) *
						
        						 {0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						
		   						 {0x00,0x4C,0x00,0x3C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;44 (,) ,
						
		        				 {0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -

        						 {0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;46 (.) .
						
        						 {0x00,0x00,0x00,0x0E,0xF8,0x0F,0xFF,0x01,0x07,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
					
        						 {0xFC,0x03,0xFE,0x07,0x07,0x0E,0x03,0x0C,0x03,0x0C,0x07,0x0E,0xFE,0x07,
						  		  0xFC,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;48 (0) 0
						
		        				 {0x18,0x00,0x0C,0x00,0x06,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;49 (1) 1
						
        						 {0x0C,0x0C,0x0E,0x0E,0x07,0x0F,0x83,0x0D,0xC3,0x0D,0xE3,0x0C,0x7E,0x0C,
						  		  0x1C,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;50 (2) 2
						
        						 {0x04,0x03,0x06,0x07,0x03,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xFF,0x07,
						  		  0xCE,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;51 (3) 3
											
        						 {0x80,0x03,0xC0,0x03,0x70,0x03,0x38,0x03,0x0E,0x03,0xFF,0x0F,0xFF,0x0F,
						  		  0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;52 (4) 4
						
		        				 {0x78,0x03,0x7F,0x07,0x3F,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xE3,0x07,
								  0xC0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;53 (5) 5
								
        						 {0xF8,0x01,0xFE,0x07,0x67,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0C,0xE7,0x07,
						  		  0xC6,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;54 (6) 6
						
        						 {0x03,0x00,0x03,0x00,0x03,0x0F,0xE3,0x0F,0xFB,0x01,0x1F,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;55 (7) 7
						
        						 {0x9C,0x03,0xFE,0x07,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0xFE,0x07,
						  		  0x9C,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;56 (8) 8
						
		        				 {0x3C,0x06,0x7E,0x0E,0xE3,0x0C,0xC3,0x0C,0xC3,0x0C,0x67,0x0E,0xFE,0x07,
						  		  0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;57 (9) 9
						
        						 {0x00,0x00,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;58 (:) :
														
        						 {0x18,0x4C,0x18,0x3C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;59 (;) ;
						
		        				 {0x40,0x00,0xE0,0x00,0xE0,0x00,0xB0,0x01,0xB0,0x01,0x18,0x03,0x18,0x03,
								  0x0C,0x06,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;60 (<) <
						
        						 {0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,
						  		  0xB0,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;61 (=) =
						
        						 {0x0C,0x06,0x18,0x03,0x18,0x03,0xB0,0x01,0xB0,0x01,0xE0,0x00,0xE0,0x00,
						  		  0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;62 (>) >
						
        						 {0x18,0x00,0x1C,0x00,0x0E,0x00,0x86,0x1B,0xC6,0x1B,0xE6,0x00,0x7C,0x00,
						  		  0x38,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;63 (?) ?

		        				 {0x00,0x0C,0x00,0x0F,0xC0,0x0F,0xF0,0x0C,0x3C,0x0C,0x0F,0x0C,0x3C,0x0C,
								  0xF0,0x0C,0xC0,0x0F,0x00,0x0F,0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;64 (@) Delta
						
        						 {0x00,0x08,0x00,0x0F,0xE0,0x07,0xF8,0x01,0x9E,0x01,0x86,0x01,0x9E,0x01,
						  		  0xF8,0x01,0xE0,0x07,0x00,0x0F,0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0xFF,0x0C,0xDE,0x07,0x80,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;66 (B) B
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x07,0x0E,0x0E,0x07,0x04,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0x63,0x0C,0x63,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,
						  		  0x03,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;70 (F) F
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0xC3,0x0C,0xC3,0x0C,
						  		  0xC7,0x0E,0xCE,0x07,0xC4,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;71 (G) G
						
		        				 {0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
						  		  0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;73 (I) I
						
        						 {0x00,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0E,0xFF,0x07,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x00,0x60,0x00,0x30,0x00,0x78,0x00,0xEC,0x01,
						  		  0x86,0x07,0x03,0x0E,0x01,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0F,0x00,0xFC,0x00,0xE0,0x07,0x00,0x0F,0xE0,0x07,
						  		  0xFC,0x00,0x0F,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0E,0x00,0x1C,0x00,0x70,0x00,0xE0,0x00,0x80,0x03,
						  		  0x00,0x07,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;78 (N) N
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x77,0x00,
						  		  0x3E,0x00,0x1C,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;80 (P) P
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0D,0x03,0x0F,0x03,0x06,
						  		  0x06,0x0E,0xFE,0x1F,0xF8,0x11,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0xE3,0x00,0xE3,0x01,
						  		  0xB7,0x07,0x3E,0x0F,0x1C,0x0C,0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x1C,0x03,0x3E,0x07,0x33,0x0E,0x73,0x0C,0x63,0x0C,0x63,0x0C,0xE7,0x0E,
						  		  0xCE,0x07,0x8C,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x0F,0xFF,0x0F,0x03,0x00,
						  		  0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x03,0xFF,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0E,0xFF,0x07,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
						  		  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x1F,0x00,0xFE,0x00,0xE0,0x0F,0x00,0x0F,0xF8,0x0F,0xFF,0x00,0x07,0x00,
						  		  0xFF,0x00,0xF8,0x0F,0x00,0x0F,0xE0,0x0F,0xFC,0x01,0x1F,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x0C,0x07,0x0E,0x9E,0x07,0xF8,0x01,0xF0,0x00,0xF8,0x01,0x9E,0x07,
						  		  0x07,0x0E,0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x07,0x00,0x1E,0x00,0x38,0x00,0xE0,0x0F,0xE0,0x0F,0x38,0x00,0x1E,0x00,
						  		  0x07,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x03,0x0E,0x83,0x0F,0xC3,0x0D,0xF3,0x0C,0x3B,0x0C,0x1F,0x0C,0x07,0x0C,
						  		  0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						         /*
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								 */
								 {0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_)  _

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e

        						 {0x30,0x07,0xB8,0x0F,0x98,0x0D,0xD8,0x0C,0xD8,0x0C,0xF8,0x07,0xF0,0x0F,
						  		  0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0x30,0x06,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xFF,0x0F,
						  		  0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xE0,0x03,0xF0,0x07,0xD8,0x0E,0xD8,0x0C,0xD8,0x0C,0xF0,0x06,0xE0,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x18,0x00,0xFE,0x0F,0xFF,0x0F,0x1B,0x00,0x1B,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xE0,0x33,0xF0,0x77,0x38,0x6E,0x18,0x6C,0x18,0x6C,0x30,0x66,0xF8,0x7F,
						  		  0xF8,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x0F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x60,0x00,0x60,0xFB,0x7F,0xFB,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x01,0xE0,0x00,0xF0,0x03,0x18,0x0F,0x08,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,
						  		  0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x7F,0xF8,0x7F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xF8,0x7F,
						  		  0xF8,0x7F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x70,0x06,0xF8,0x0E,0xD8,0x0C,0xD8,0x0D,0x98,0x0D,0xB8,0x0F,0x30,0x07,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x18,0x00,0xFE,0x07,0xFF,0x0F,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x07,0xF8,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x06,0xF8,0x0F,
						  		  0xF8,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;117 (u)  u

        						 {0x38,0x00,0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;118 (v)  v

        						 {0x18,0x00,0xF8,0x01,0xE0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xE0,0x0F,0xF8,0x01,0x18,0x00,0x00,0x00}, //   	;119 (w)  w

        						 {0x18,0x0C,0x38,0x0E,0xF0,0x07,0xC0,0x01,0xF0,0x07,0x38,0x0E,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;120 (x)  x

        						 {0x18,0x00,0x78,0x60,0xE0,0x63,0x80,0x7F,0x00,0x3E,0x80,0x0F,0xE0,0x03,
						  		  0x78,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;121 (y)  y

        						 {0x18,0x0C,0x18,0x0F,0x98,0x0F,0xD8,0x0D,0xF8,0x0C,0x78,0x0C,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;122 (z)  z 
								
								 {0x80,0x00,0xC0,0x00,0xE0,0x00,0xF0,0x00,0xF8,0x00,0xF0,0x00,0xE0,0x00,
								  0xC0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;123 ({)  	Arrow Up
								
								 {0x08,0x00,0x18,0x00,0x38,0x00,0x78,0x00,0xF8,0x00,0x78,0x00,0x38,0x00,
								  0x18,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;124 (|)  	Arrow Down

        						 {0x00,0x08,0x00,0x08,0xC0,0x08,0xF0,0x08,0xFF,0x0F,0xF1,0x00,0xC1,0x00,
								  0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;125 (})  	Rising Edge
					
								 {0x01,0x00,0x01,0x00,0x31,0x00,0xF1,0x00,0xFF,0x0F,0xF0,0x08,0x30,0x08,
								  0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;126 (~)	Falling Edge

        						 {0x00,0x78,0xF0,0x7F,0xFF,0x07,0x0F,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;127 (DEL) / for per Division
								
		        				 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x02,0x7C,0x01,0x60,0x7F,0x7C,0x7F,0x1F,
								  0x02,0x03,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x80}, //   	;128 (�)  milli Volt per Division
															
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
								  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;129 (?)  Volt per Division
								
        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7E,0x32,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;130 (�) ns per Division
						
        						 {0x00,0x00,0x00,0x00,0x7F,0xC4,0x7F,0xDB,0x10,0xDB,0x1F,0xDB,0x1F,0x23,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;131 (�)  �s per Division								

        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7F,0x32,
								  0x02,0x00,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;132 (�) ms per Division
						
        						 {0x00,0x00,0xC0,0x04,0xE0,0x0D,0xA0,0x09,0x20,0x0B,0x60,0x0F,0x40,0x06,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;133 (�)  s per Division								

        						 {0x20,0x00,0xA0,0x00,0xB8,0x02,0xA8,0x00,0x28,0x00,0x08,0x00,0x7F,0x00,
								  0x3E,0x00,0x1C,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80},//    	;134 (�) Ground Sign

        						 {0x00,0x00,0xC0,0x00,0xE0,0x01,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;135 (�) List Count Dot

        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x41,0x41,0x60,0x03,0x70,0x07,0x60,0x03,
								  0x41,0x41,0x0F,0x78,0xFE,0x7F,0xF0,0x07,0x00,0x00,0x00,0x80,0x00,0x80}, //	;136 (�) Channel Zerolevel Symbol

        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   	;137 (�) Menu Hacken

        						 {0x00,0x30,0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x03,0x00,
								  0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x80}, //   	;138 (�) positive Pulse

        						 {0x03,0x00,0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,
								  0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80}, //   	;139 (�) negative Pulse

        						 {0x80,0x00,0xC0,0x01,0xC0,0x01,0x60,0x03,0x60,0x03,0x30,0x06,0x30,0x06,
								  0x18,0x0C,0x18,0x0C,0x0C,0x18,0x0C,0x18,0x04,0x10,0x00,0x00,0x00,0x80}, //   	;140 (�) gro�es kleiner als
								
        						 {0x04,0x10,0x0C,0x18,0x0C,0x18,0x18,0x0C,0x18,0x0C,0x30,0x06,0x30,0x06,
								  0x60,0x03,0x60,0x03,0xC0,0x01,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x80},// 	;141 (?) gro�es gr��er als

        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x00,0x60,0x03,0x7F,0x1F,0x7F,0x7C,
								  0x40,0x60,0x20,0x7C,0x7F,0x1F,0x7F,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;142 (�) � Volt per Division
								
        						 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x1C,0x7C,0x36,0x60,0x63,0x7C,0x41,0x1F,
								  0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;143 (?) kilo Volt per Division
								
        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x30,0x60,0x3C,0x7F,0x0F,0x7F,0x0B,
								  0x40,0x0F,0x20,0x3C,0x7F,0x30,0x7F,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;144 (?) � Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x02,0x0F,0x01,0x0B,0x7F,0x0F,0x7F,0x3C,
								  0x02,0x30,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;145 (�) milli Ampere per Division
								
        						 {0x00,0x10,0x00,0x1E,0xC0,0x0F,0xF8,0x03,0x3E,0x03,0x06,0x03,0x3E,0x03,
								  0xF8,0x03,0xC0,0x0F,0x00,0x1E,0x00,0x10,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;146 (�) Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x1C,0x0F,0x36,0x0B,0x63,0x0F,0x41,0x3C,
								  0x00,0x30,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;147 (�) kilo Ampere per Division

        						 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
								  0xF3,0x1F,0xE0,0x0F,0xC0,0x07,0x80,0x03,0x00,0x01,0x00,0x00,0x00,0x80}, //    ;148 (�) Trigger Sign

        						 {0x08,0x00,0x0C,0x00,0x0E,0x00,0xFF,0x01,0xFF,0x01,0x0E,0x00,0x0C,0x00,
								  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;149 (�) Overvoltage
								
        						 {0x20,0x00,0x60,0x00,0xE0,0x00,0xFF,0x01,0xFF,0x01,0xE0,0x00,0x60,0x00,
								  0x20,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;150 (�) Undervoltage

        						 {0xC6,0x00,0xE7,0x00,0xF3,0x00,0xFB,0x00,0xDF,0x00,0xCE,0x00,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								      /*
        						 {0x66,0x00,0x73,0x00,0x7B,0x00,0x6F,0x00,0x66,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								     */
                                  /*
        						 {0x42,0x00,0x61,0x00,0x51,0x00,0x49,0x00,0x46,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								 */
								  
								  //    ;152 (�)
								  //    ;153 (�)
								  //    ;154 (�)
								  //    ;155 (�)
								  //    ;156 (�)
								  //    ;157 (?)
								  //    ;158 (�)
								  //    ;159 (�)
								  //    ;160 ( )

unsigned char bitbmBigArrowUp[] = { 32, 13,
						   		    0x00, 0x01, 0x00, 0x00,
						   		    0x00, 0x07, 0xC0, 0x00,
						   		    0x00, 0x1F, 0xF0, 0x00,
						   		    0x00, 0x7F, 0xFC, 0x00,
						   		    0x01, 0xFF, 0xFF, 0x00,
						   		    0x07, 0xFF, 0xFF, 0xC0, 
						   		    0x1F, 0xFF, 0xFF, 0xF0,
						   		    0x7F, 0xFF, 0xFF, 0xFC, 
						   		    0x00, 0x07, 0xC0, 0x00, 
						   		    0x00, 0x07, 0xC0, 0x00, 
						   		    0x00, 0x0F, 0xE0, 0x00,
						   		    0x00, 0x1F, 0xF0, 0x00,
						   		    0x00, 0x3F, 0xF8, 0x00};
					

unsigned char bitbmBigArrowDown[] = { 32, 13,
							 		  0x00, 0x3F, 0xF8, 0x00, 
							 		  0x00, 0x1F, 0xF0, 0x00, 
							 		  0x00, 0x0F, 0xE0, 0x00, 
							 		  0x00, 0x07, 0xC0, 0x00, 
							 		  0x00, 0x07, 0xC0, 0x00, 
							 		  0x7F, 0xFF, 0xFF, 0xFC, 
							 		  0x1F, 0xFF, 0xFF, 0xF0, 
							 		  0x07, 0xFF, 0xFF, 0xC0, 
							 		  0x01, 0xFF, 0xFF, 0x00, 
							 		  0x00, 0x7F, 0xFC, 0x00, 
							 		  0x00, 0x1F, 0xF0, 0x00, 
							 		  0x00, 0x07, 0xC0, 0x00, 
							 		  0x00, 0x01, 0x00, 0x00};
						
unsigned char bitbmCycleArrow[] = { 16, 14,
						   		    0x00, 0x60, 
						   		    0x10, 0x70, 
						   		    0x10, 0x18, 
						   		    0x38, 0x0C, 
						   		    0x38, 0x06, 
						   		    0x7C, 0x06, 
						   		    0x7C, 0x06, 
						   		    0xFE, 0x06, 
						   		    0xFE, 0x06, 
						   		    0x38, 0x06, 
						   		    0x38, 0x0C, 
						   		    0x1C, 0x18, 
						   		    0x07, 0xF0, 
						   		    0x01, 0xE0};
						
unsigned char bitbmSelectCycleArrow[] = { 24, 14, 
										  0x00, 0x06, 0x00, 
										  0x10, 0x17, 0x00, 
										  0x10, 0x11, 0x80, 
										  0x38, 0x38, 0xC0, 
										  0x38, 0x38, 0x60, 
										  0x7C, 0x7C, 0x60, 
										  0x7C, 0x7C, 0x60, 
										  0xFE, 0xFE, 0x60, 
										  0xFE, 0xFE, 0x60, 
										  0x38, 0x00, 0x60, 
										  0x38, 0x00, 0xC0, 
										  0x1C, 0x01, 0x80, 
										  0x07, 0xFF, 0x00, 
										  0x01, 0xFE, 0x00};
										
unsigned char bitbmTimebaseOffset[] = { 16, 12, 
										0x07, 0xFF, 
										0x07, 0xFF, 
										0x07, 0xFF, 
										0x07, 0x00, 
										0x07, 0x00, 
										0x07, 0x00, 
										0x7F, 0xF0, 
										0x3F, 0xE0, 
										0x1F, 0xC0, 
										0x0F, 0x80, 
										0x07, 0x00, 
										0x02, 0x00};
										
unsigned char bitbmSubMenu[] = { 40, 13, 
								 0x00, 0x00, 0x00, 0x10, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0xEF, 0x7C, 0xE7, 0x9F, 0xC0, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x10, 0x00};						
						
unsigned char bitbmCH1[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x03, 0x00,
								0x05, 0x00,
								0x01, 0x00,
								0x01, 0x00,						
								0x01, 0x10,
								0x01, 0x18,
								0x00, 0x1C,
								0x03, 0xFE,
								0x02, 0x1C,
								0x0F, 0x98,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};
								
unsigned char bitbmCH1_gnd[] = { 16, 21,
								0x00, 0x00,
								0x00, 0x20,
								0x00, 0x60,
								0x00, 0xA0,
								0x00, 0x20,
								0x00, 0x20,						
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
								
unsigned char bitbmCH1_XY[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x10,
								0x02, 0x38,
								0x06, 0x7C,
								0x0A, 0xFE,
								0x02, 0x10,						
								0x02, 0x10,
								0x02, 0x10,
								0x02, 0x7C,
								0x00, 0x00,
								0x00, 0x38,
								0x00, 0x00,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};								

unsigned char bitbmCH2[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x01, 0x00,
								0x02, 0x00,						
								0x04, 0x10,
								0x0F, 0x98,
								0x00, 0x1C,
								0x03, 0xFE,
								0x02, 0x1C,
								0x0F, 0x98,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};
								
unsigned char bitbmCH2_gnd[] = { 16, 21,
								0x00, 0x00,
								0x01, 0xE0,
								0x00, 0x10,
								0x00, 0x10,
								0x00, 0x20,
								0x00, 0x40,						
								0x08, 0x80,
								0x19, 0xF0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

unsigned char bitbmCH3[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x03, 0x00,
								0x00, 0x80,						
								0x08, 0x90,
								0x07, 0x98,
								0x00, 0x1C,
								0x03, 0xFE,
								0x02, 0x1C,
								0x0F, 0x98,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};
								
unsigned char bitbmCH3_gnd[] = { 16, 21,
								0x00, 0x00,
								0x00, 0xE0,
								0x01, 0x10,
								0x00, 0x10,
								0x00, 0x60,
								0x00, 0x10,						
								0x09, 0x10,
								0x18, 0xE0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								

unsigned char bitbmCH4[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x80,
								0x02, 0x80,
								0x04, 0x80,
								0x08, 0x80,
								0x0F, 0xC0,						
								0x00, 0x90,
								0x00, 0x98,
								0x00, 0x1C,
								0x03, 0xFE,
								0x02, 0x1C,
								0x0F, 0x98,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};
								
unsigned char bitbmCH4_gnd[] = { 16, 21,
								0x00, 0x00,
								0x00, 0x60,
								0x00, 0xA0,
								0x01, 0x20,
								0x02, 0x20,
								0x03, 0xF0,						
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
						
unsigned char bitbmMin[] = { 16, 16,
								0x01, 0x00,
								0x01, 0x00,
								0x03, 0x80,
								0x03, 0x80,
								0x07, 0xC0,
								0x07, 0xC0,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
                                						
unsigned char bitbmMax[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x07, 0xC0,
								0x07, 0xC0,
								0x03, 0x80,
								0x03, 0x80,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

								
unsigned char bitbmTrigger[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x10,
								0x7C, 0x18,
								0x10, 0x1C,
								0x17, 0xFE,
								0x10, 0x1C,
								0x10, 0x18,
								0x10, 0x10,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

unsigned char bitbmTrigAVG[] = { 16, 16,
								0x00, 0x10,
								0x03, 0xA0,
								0x04, 0x40,
								0x08, 0xA0,
								0x09, 0x20,
								0x0A, 0x20,
								0x04, 0x40,
								0x0B, 0x80,
								0x10, 0x00,
								0x00, 0x10,
								0x7C, 0x18,
								0x10, 0x1C,
								0x17, 0xFE,
								0x10, 0x1C,
								0x10, 0x18,
								0x10, 0x10};
                                                                						
unsigned char bitbmCoppAC[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
								
unsigned char bitbmCoppDC[] = { 16, 29,
/* Mit DC Text
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
*/
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x10, 0x00, 
								0x30, 0x00, 							
								0x70, 0x00, 
								0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
								
unsigned char bitbmCoppInv[] = { 16, 29,
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x10, 0x00, 
								 0x30, 0x00, 
								 0x70, 0x00, 
								 0xFF, 0xC0,
								 0x70, 0x00,
								 0x30, 0x00,
								 0x10, 0x00,
								 0x00, 0x00,
								 0x00, 0x00,
								 0x00, 0x00,
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
								 0x00, 0x00, 
                                 0x59, 0x42,
								 0x59, 0x42,
								 0x55, 0x42,
								 0x55, 0x24,
								 0x55, 0x24,
								 0x55, 0x24,
								 0x53, 0x24,
								 0x53, 0x18,                                 								
								 0x00, 0x00};								
/*								
unsigned char bitbmCoppLimit[] = { 16, 29,
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x10, 0x00, 
								   0x30, 0x00, 
								   0x70, 0x00, 
								   0xFF, 0xC0, 
								   0x70, 0x00, 
								   0x31, 0x00, 
								   0x12, 0x80, 
								   0x04, 0x40, 
								   0x04, 0x40, 
								   0x08, 0x20, 
								   0x08, 0x20, 
								   0x00, 0x11, 
								   0x00, 0x11, 
								   0x00, 0x0A, 
								   0x00, 0x04,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00};	                                   																						
*/
unsigned char bitbmCoppLimit[] = { 16, 29,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x10, 0x00,
								   0x30, 0x00,
								   0x70, 0x00,
								   0xFF, 0xC0,
								   0x70, 0x00,
								   0x37, 0x22,
								   0x14, 0xA2,
								   0x04, 0xA2,
								   0x07, 0xAA,
								   0x04, 0xAA,
								   0x04, 0xAA,
								   0x04, 0x94,
								   0x07, 0x14,								
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00};								
                                   						
unsigned char bitbmCoppACInv[] = { 16, 29,
								   0x01, 0x06, 
								   0x02, 0x89, 
								   0x02, 0x90, 
								   0x02, 0x90, 
								   0x04, 0x50, 
								   0x07, 0xD0, 
								   0x14, 0x49, 
								   0x34, 0x46, 
								   0x70, 0x00, 
								   0xFF, 0xC0,
								   0x70, 0x00,
								   0x30, 0x00,
								   0x10, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00,
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
								   0x00, 0x00, 
                                   0x59, 0x42,
								   0x59, 0x42,
								   0x55, 0x42,
								   0x55, 0x24,
								   0x55, 0x24,
								   0x55, 0x24,
								   0x53, 0x24,
								   0x53, 0x18,                                 								
								   0x00, 0x00};                                   						
						
unsigned char bitbmCoppACLimit[] = { 16, 29,
									 0x01, 0x06, 
									 0x02, 0x89, 
									 0x02, 0x90, 
									 0x02, 0x90, 
									 0x04, 0x50, 
									 0x07, 0xD0, 
									 0x14, 0x49, 
									 0x34, 0x46, 
									 0x70, 0x00, 
									 0xFF, 0xC0, 
									 0x70, 0x00, 
									 0x37, 0x22,
								     0x14, 0xA2,
								     0x04, 0xA2,
								     0x07, 0xAA,
							 	     0x04, 0xAA,
								     0x04, 0xAA,
								     0x04, 0x94,
								     0x07, 0x14,								
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,
								     0x00, 0x00,                                 								
								     0x00, 0x00};								
						
unsigned char bitbmCoppInvLimit[] = { 16, 29,
									  0x00, 0x00, 
									  0x00, 0x00, 
									  0x00, 0x00, 
									  0x00, 0x00, 
									  0x00, 0x00, 
									  0x00, 0x00, 
									  0x10, 0x00, 
									  0x30, 0x00, 
									  0x70, 0x00, 
									  0xFF, 0xC0,
									  0x70, 0x00,
									  0x37, 0x22,
								      0x14, 0xA2,
								      0x04, 0xA2,
								      0x07, 0xAA,
								      0x04, 0xAA,
								      0x04, 0xAA,
								      0x04, 0x94,
								      0x07, 0x14,								
								      0x00, 0x00,
								      0x59, 0x42,
								      0x59, 0x42,
								      0x55, 0x42,
								      0x55, 0x24,
								      0x55, 0x24,
								      0x55, 0x24,
								      0x53, 0x24,
								      0x53, 0x18,                                 								
								      0x00, 0x00};								
								
														
unsigned char bitbmCoppFull[] = { 16, 29,
								  0x01, 0x06, 
								  0x02, 0x89, 
								  0x02, 0x90, 
								  0x02, 0x90, 
								  0x04, 0x50, 
								  0x07, 0xD0, 
								  0x14, 0x49, 
								  0x34, 0x46, 
								  0x70, 0x00, 
								  0xFF, 0xC0,
								  0x70, 0x00,
								  0x37, 0x22,
								  0x14, 0xA2,
								  0x04, 0xA2,
								  0x07, 0xAA,
								  0x04, 0xAA,
								  0x04, 0xAA,
								  0x04, 0x94,
								  0x07, 0x14,								
								  0x00, 0x00,
								  0x59, 0x42,
								  0x59, 0x42,
								  0x55, 0x42,
								  0x55, 0x24,
								  0x55, 0x24,
								  0x55, 0x24,
								  0x53, 0x24,
								  0x53, 0x18,
								  0x00, 0x00};								
							
unsigned char bitbmStopTrigger[] = { 24, 17,
										0x00, 0x7F, 0x00,
										0x00, 0x80, 0x80,
										0x01, 0x7F, 0x40,
										0x02, 0xFF, 0xA0,
										0x05, 0xFF, 0xD0,
										0x0B, 0xFF, 0xE8,
										0x14, 0x8B, 0x34,
										0x15, 0xD5, 0x54,
										0x14, 0xD5, 0x34,
										0x16, 0xD5, 0x74,
										0x14, 0xDB, 0x74,
										0x0B, 0xFF, 0xE8,
										0x05, 0xFF, 0xD0,
										0x02, 0xFF, 0xA0,
										0x01, 0x7F, 0x40,
										0x00, 0x80, 0x80,
										0x00, 0x7F, 0x00};
										
unsigned char bitbmStopTrigger_stop[] = { 24, 5,
										0x03, 0x74, 0xE0,
										0x02, 0x2A, 0xA0,
										0x03, 0x2A, 0xE0,
										0x01, 0x2A, 0x80,
										0x03, 0x24, 0x80};										
                                                                    	
unsigned char bitbmWTAG[] =    {88, 87,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
								0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xC0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xF0, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xF8, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFC, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFE, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0x80,
								0x00, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0x03, 0x81, 0xFF, 0xFF, 0xC0,
								0x01, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0xFF, 0xFF, 0xC0,
								0x03, 0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xE0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xF0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0xFF, 0xFF, 0xF0,
								0x0F, 0xFF, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0x7F, 0xFF, 0xF0,
								0x0F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFC, 0x7F, 0xF8, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFC, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x7F, 0xFF, 0xFC,
								0x3F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xC7, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
								0x7F, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE3, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x1F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF1, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0xFF, 0xF8,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFF, 0x1F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x0F, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x07, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x07, 0xFF, 0xFF, 0x87, 0xF8, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x03, 0xFF, 0xFF, 0x83, 0xF0, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xC0,
								0x01, 0xFF, 0xFF, 0x81, 0xE0, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x80,
								0x01, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x7F, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x3F, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x1F, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x0F, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x01, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00};





// ===========================================================
// Parameters for Each Peripheral, Excerpted From The PTF File



// ------------------
// Parameters for altera_nios named cpu

// CPU_Architecture     = nios_32             
// mstep                = 1                   
// multiply             = 0                   
// rom_decoder          = 1                   
// wvalid_wr            = 0                   
// num_regs             = 256                 
// do_generate          = 1                   
// include_debug        = 0                   
// include_trace        = 0                   
// reset_slave          = boot_monitor_rom/s1 
// reset_offset         = 0x0                 
// vecbase_slave        = ext_ram/s1          
// vecbase_offset       = 0x03ff00            
// support_interrupts   = 1                   
// implement_forward_b1 = 0                   
// support_rlc_rrc      = 0                   
// advanced             = 1                   
// CONSTANTS            = 
// mainmem_slave        = ext_ram/s1          
// datamem_slave        = ext_ram/s1          
// maincomm_slave       = uart1/s1            
// debugcomm_slave      = uart2_debug/s1      
// germs_monitor_id     = std_32_2.0          


// ------------------
// Parameters for altera_avalon_onchip_memory named boot_monitor_rom

// Writeable              = 0     
// Size_Value             = 1     
// Size_Multiple          = 1024  
// Contents               = blank 
// Shrink_to_fit_contents = 0     
// CONTENTS               = srec  


// ------------------
// Parameters for altera_avalon_uart named uart1

// baud             = 115200   
// data_bits        = 8        
// fixed_baud       = 1        
// parity           = N        
// stop_bits        = 2        
// use_cts_rts      = 0        
// use_eop_register = 0        
// sim_true_baud    = 0        
// sim_char_stream  = g40000\n 


// ------------------
// Parameters for altera_avalon_pio named seven_seg_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named speed_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_timer named timer1

// always_run           = 0     
// fixed_period         = 0     
// snapshot             = 1     
// period               = 1     
// period_units         = msec  
// reset_output         = 0     
// timeout_pulse_output = 0     
// mult                 = 0.001 


// ------------------
// Parameters for altera_avalon_pio named led_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named button_pio

// has_tri   = 0    
// has_out   = 0    
// has_in    = 1    
// edge_type = ANY  
// irq_type  = EDGE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named lcd_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named direction_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_uart named uart2_debug

// baud             = 115200 
// data_bits        = 8      
// fixed_baud       = 1      
// parity           = N      
// stop_bits        = 1      
// use_cts_rts      = 0      
// use_eop_register = 0      
// sim_true_baud    = 0      
// sim_char_stream  = 


// ------------------
// Parameters for altera_nios_dev_board_sram32 named ext_ram

// sram_memory_size  = 256  
// sram_memory_units = 1024 
// sram_data_width   = 32   
// CONTENTS          = srec 


// ------------------
// Parameters for altera_nios_dev_board_flash named ext_flash

// CONTENTS = srec 


// end of file


