/*
 * W2000A Screenshot Utility v0.2,
 * companion to firmware patch
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <err.h>

#define MAXPLANES	16

/*
 * XXX: Please note:
 *      This is _not_ 100% identical to the actual
 *      output seen on the DSO.  For example:
 *      The math channel is drawn _over_
 *      the browse bar.  Put the Math channel
 *      behind UI in the planeorder to witness
 *      the actual output.
 */
static const int planeorder[] = {
	1,			/* Grid */
	7, 8, 9, 10, 		/* Channels 1-4 */
				/* XXX: Red Arrow and Stop-Sign in UI on 10/Channel4? */
	11,			/* Math Channel */
	15, 16,			/* Cursors and Trigger Mark */
	4, 5, 6, 2, 3,		/* UI */
	12, 13, 14,		/* Not yet determined */
	0
};

static const int planecolours[][3] = {
/* Grid_Plane */	{ 0x3F, 0x3F, 0x3F }, /* dark gray */
/* UI_Plane1 */		{ 0xFB, 0xFB, 0xFB }, /* dark white */
/* UI_Plane2 */		{ 0x00, 0x00, 0x00 }, /* black */
/* UI_Plane3 */		{ 0xFF, 0xFD, 0xEE }, /* yellow tinted white */
/* UI_Plane4 */		{ 0xE6, 0xE6, 0x83 }, /* beige-ish yellow */
/* UI_Plane5 */		{ 0x7E, 0x7E, 0x7E }, /* gray */
/* Channel_Plane1 */	{ 0xFF, 0xFF, 0x00 }, /* yellow */
/* Channel_Plane2 */	{ 0x90, 0xEE, 0x90 }, /* light green */
/* Channel_Plane3 */	{ 0x32, 0xAB, 0xFF }, /* light blue */
/* Channel_Plane4 */	{ 0xFF, 0x00, 0x00 }, /* red */
/* Channel_Math_Plane */{ 0xFF, 0x96, 0xF6 }, /* pink */
/* Memory_Plane1 */	{ 0x00, 0x00, 0x00 }, /* n.y.d. */
/* Memory_Plane2 */	{ 0x00, 0x00, 0x00 }, /* n.y.d. */
/* Memory_Plane3 */	{ 0x00, 0x00, 0x00 }, /* n.y.d. */
/* Marker_Plane1 */	{ 0xFF, 0x67, 0x00 }, /* orange-red */
/* Marker_Plane2 */	{ 0xFF, 0x67, 0x00 }, /* orange-red */
			{ 0x00, 0x00, 0x00 }  /* don't remove this! */
};

static unsigned char pixmaps[MAXPLANES][640*480];
static char fnamprefix[256];
static int rdplanes;

static void
usage(void)
{

	(void)fprintf(stderr,
			"Usage:\n"
			"w2000a-screenshot [-h] [-f prefix]\n"
			" -h\t\tthis help\n"
			" -f prefix\toutput file\n"
			"\n"
			"Input is read from stdin, diagnostics and\n"
			"status messages are directed to stderr.\n"
			"\n"
			"Output is written to \"[prefix]_dd.pgm\", with\n"
			"\"dd\" as the two digit plane sequence number.\n"
			"Prefix defaults to \"screenshot\".\n"
			"\n"
			"Planes are coloured and combined in \"[prefix].ppm\".\n");
	exit(1);
}

static void
retrieve(void)
{
	FILE *fp;
	char fnam[256];
	int r, pnum, rd, total, ppos;
	unsigned char c, l, b;
	int i;

	(void)fprintf(stderr, "* Waiting for Screenshot...\n");

	l = 0;
	while ((r = read(0, &c, 1)) > 0) {
		if (c == 255 && l == 'S')
			break;
		l = c;
	}
	if (r <= 0)
		exit(1);

	(void)fprintf(stderr, "* Found Screenshot Start Marker\n");

	total = 0;
	rdplanes = 0;
	for (pnum = 0; pnum < MAXPLANES; pnum++) {
		(void)fprintf(stderr, "  - Receiving Plane #%.2d...\n", pnum+1);

		(void)snprintf(fnam, sizeof(fnam), "%s_%.2d.pgm", fnamprefix, pnum+1);
		if ((fp = fopen(fnam, "w+")) == NULL)
			err(1, "fopen(%s, w+) failed", fnam);

		(void)fprintf(fp, "P5\n640 480\n255\n");

		rd = 0;
		ppos = 0;
		while (read(0, &c, 1) > 0) {
			rd++;
			if (rd % 100 == 0)
				(void)fprintf(stderr, "\r    %d bytes...", rd);
			if (c == 255)
				break;
			b = 0x00;
			if (c & (1 << 7))
				b = 0xff;
			c &= ~(1 << 7);

			for (i = 0; i < c; i++) {
				pixmaps[pnum][ppos++] = b;
				(void)fputc(b, fp);
			}
		}
		total += rd;
		rdplanes++;

		(void)fprintf(stderr, "\r    Read %d bytes.\n", rd);

		if (fclose(fp) != 0)
			err(1, "fclose(%s) failed", fnam);

		if (read(0, &c, 1) > 0) {
			if (c == 'E') {
				(void)fprintf(stderr, "* End of Transmission\n");
				break;
			} else if (c == 0xFF)
				(void)fprintf(stderr, "    (another plane follows)\n");
		} else {
			(void)fprintf(stderr, "* Short read, ignoring\n");
			break;
		}
	}

	(void)fprintf(stderr, "* Total bytes transferred: %d\n", total);
}

static void
combine(void)
{
	FILE *fp;
	char fnam[256];
	int ppos, i, plane, colour;

	(void)fprintf(stderr, "* Combining...\n");

	(void)snprintf(fnam, sizeof(fnam), "%s.ppm", fnamprefix);
	if ((fp = fopen(fnam, "w+")) == NULL)
		err(1, "fopen(%s, w+) failed", fnam);

	(void)fprintf(fp, "P6\n640 480\n255\n");

	for (ppos = 0; ppos < 640*480; ppos++) {
		colour = MAXPLANES; /* default colour, black */
		for (i = 0; i < MAXPLANES && i < rdplanes; i++) {
			plane = planeorder[i] - 1;
			if (pixmaps[plane][ppos] == 0xFF)
				colour = plane;
		}
		(void)fputc(planecolours[colour][0], fp);
		(void)fputc(planecolours[colour][1], fp);
		(void)fputc(planecolours[colour][2], fp);
	}

	if (fclose(fp) != 0)
		err(1, "fclose(%s) failed", fnam);

	(void)fprintf(stderr, "* Done\n");
}

int
main(int argc, char **argv)
{
	int ch;

	(void)snprintf(fnamprefix, sizeof(fnamprefix), "screenshot");
	while ((ch = getopt(argc, argv, "f:h")) != -1) {
		switch (ch) {
		case 'f':
			(void)snprintf(fnamprefix, sizeof(fnamprefix), "%s", optarg);
			break;
		case 'h':
		default:
			usage();
			/* NOTREACHED */
		}
	}

	retrieve();
	combine();

	return 0;
}
