#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/atomic.h>
#include <stdint.h>
#include "aladin.h"
#include "main.h"
#include "uart.h"
#include "globals.h"
#include "eeprom.h"

void aladin_fsm(void) {
	static uint8_t cnt;
	int tmp;

	switch(aladin_state) {
		case idle_s:
			cnt = 0; aladin_connect = 0; aladin_error = 0; rx_error = 0; UART_RXC_ISR_OFF; UART_UDRE_ISR_OFF;	 			
			switch (aladin_cmd) {
				case download_cmd: aladin_state = download_sync_s; UART_RXC_ISR_ON; break;
				case upload_cmd:   aladin_state = upload_start_s; break;
				default: break;
			}
			break;

		case download_sync_s:
			if (aladin_cmd == idle_cmd) {
				aladin_state = idle_s;
			} else if (aladin_sync) {
				timeout = 150;
				aladin_state = download_s;
			}
			break;

		case download_s:
			// UART RX data is stored in ISR
			if (timeout == 0) {
				aladin_error = 1;
				aladin_state = download_error_s;
			} else if (rx_error) {
				aladin_error = 2;
				aladin_state = download_error_s;
			} else {
				if (id==2048) {
					aladin_state = download_success_s;
				}
			}
			break;

		case download_error_s:
			if (aladin_cmd == idle_cmd) {
				aladin_state = idle_s;
			}
			break;

		case download_success_s:
			if (aladin_cmd == idle_cmd) {
				aladin_state = idle_s;
			}
			break;

		case upload_start_s:
			flag_sync = 0;
			while(!(flag_sync == 1 && READ_TXD));	// wait for rising edge of TXD
			UART_TXD_ON;
			aladin_state = upload_sync_s;
			break;

		case upload_sync_s:
			if (UART_UDRE) {
				cnt++;
				UDR0 = 0x55;
				if (cnt == 3) {
					id = 0;
					eeprom_start_read(block_up<<11);
					UART_UDRE_ISR_ON;
					aladin_state = upload_s;
				}		
			}
			break;

		case upload_s:
			// UART data feed in ISR
			ATOMIC_BLOCK(ATOMIC_RESTORESTATE) {
				tmp = id;
			}
			if (tmp==2048) {
				UART_UDRE_ISR_OFF;
				timeout = 50;
				CS_HIGH;			// end EEPROM read access
				aladin_state = upload_done_s;
			}
			break;
				
		case upload_done_s:
			if (timeout == 0) {
				UART_TXD_OFF;
				if (aladin_cmd == idle_cmd) {
					aladin_state = idle_s;
				}
			}
			break;
	}
}
