#include <avr/io.h>
#include <stdint.h>
#include "aladin.h"
#include "main.h"
#include "misc.h"
#include "eeprom.h"

void eeprom_chip_erase(void) {

	CS_LOW;
	spi_io(CMD_WREN);		// write enable	
	CS_HIGH;

	CS_LOW;
	spi_io(CMD_CE);			// chip erase
	CS_HIGH;
}

void eeprom_page_erase(uint16_t adr) {

	CS_LOW;
	spi_io(CMD_WREN);		// write enable	
	CS_HIGH;

	CS_LOW;
	spi_io(CMD_PE);			// chip erase
	spi_io(adr>>8);
	spi_io(adr & 0xFF);
	CS_HIGH;
}

void eeprom_start_read(uint16_t adr) {
	
	CS_LOW;
	spi_io(CMD_READ);
	spi_io(adr>>8);
	spi_io(adr & 0xFF);
}

uint8_t eeprom_read(void) {
	return spi_io(0);
}

void eeprom_start_write(uint16_t adr) {

	CS_LOW;
	spi_io(CMD_WREN);		// write enable	
	CS_HIGH;

	CS_LOW;
	spi_io(CMD_WRITE);
	spi_io(adr>>8);
	spi_io(adr & 0xFF);
}

void eeprom_write_block(uint8_t *ptr, uint8_t cnt) {

	for ( ; cnt > 0; cnt--) spi_io(*ptr++);
}


