#ifndef EEPROM_H
#define EEPROM_H

#define CMD_READ 	0x03		// read
#define CMD_WRITE 	0x02		// write
#define CMD_WREN	0x06		// write enable
#define CMD_WRDI	0x04		// write disable
#define CMD_RDSR	0x05		// read status register
#define CMD_WRSR	0x01		// write status register
#define CMD_PE		0x42		// page erase
#define CMD_SE		0xD8		// sector erase
#define CMD_CE		0xC7		// chip erase
#define CMD_RDID	0xAB		// release from deep power down and read signature
#define CMD_DPD		0xB9		// deep power down

void eeprom_chip_erase(void);			// clear whole eeprom, chip erase 10ms max.
void eeprom_page_erase(uint16_t adr);
void eeprom_start_read(uint16_t adr);
void eeprom_start_write(uint16_t adr);
void eeprom_write_block(uint8_t *ptr, uint8_t cnt);
uint8_t eeprom_read(void);

#endif
