#ifndef GLOBALS_H
#define GLOBALS_H

#include "aladin.h"
#include "menu.h"

extern volatile uint8_t flag100ms;			// itself
extern volatile uint8_t flag1s;				// itself
extern volatile uint8_t flag_sync;			// 100Hz edge
extern volatile uint8_t timeout;			// timout for download
extern volatile uint8_t rx_error;			// UART rx error
extern volatile uint8_t cntFE;				// UART frame error counter
extern volatile uint8_t aladin_sync;		// 3x 0x55 sync pattern found
extern volatile aladin_t aladin_state;		// itself
extern volatile uint8_t aladin_connect;		// dive computer idle pulse detected
extern volatile int16_t id;					// data index, used for buffer access and progress indication
extern volatile int16_t debug;
extern volatile uint8_t key_state;          // debounced and inverted key state:
extern volatile uint8_t key_press;          // key press detect
extern volatile uint8_t key_rpt;            // key long press and repeat
extern menu_state_t menu_state;				// itself
extern aladin_cmd_t aladin_cmd;				// what to do?
extern uint8_t aladin_error;
extern uint8_t block_up, block_down;		// block number for up and download

#endif
