#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <stdint.h>
#include "main.h"
#include "misc.h"
#include "globals.h"
#include "eeprom.h"

// f = F_TIMER

ISR(TIMER1_COMPA_vect) {
	static uint8_t cnt100ms, cnt10ms;
	static uint16_t cnt1s;
 	static uint8_t ct0 = 0xFF, ct1 = 0xFF, rpt;
  	uint8_t i;

	cnt100ms++;
	if (cnt100ms == F_TIMER/10) {
		cnt100ms=0;
		flag100ms = 1;
	}

	cnt1s++;
	if (cnt1s == F_TIMER) {
		cnt1s = 0;
		flag1s = 1;
		// a simple frequency counter
		// idle signal of aladin dive computer is a 128Hz square wave, should be very pecise, derived from XO
		if (cntFE > 124 && cntFE < 132) aladin_connect = 1; else aladin_connect = 0;
		cntFE = 0; 
	}

	TOGGLE_TXD;
	flag_sync = 1;
 
 	cnt10ms = !cnt10ms;
	if (cnt10ms) {			// F_TIMER/2 stuff

		// key debounce 
	  	i = key_state ^ ~KEY_PIN;                       // key changed ?
	  	ct0 = ~( ct0 & i );                             // reset or count ct0
	  	ct1 = ct0 ^ (ct1 & i);                          // reset or count ct1
	  	i &= ct0 & ct1;                                 // count until roll over ?
	  	key_state ^= i;                                 // then toggle debounced state
	  	key_press |= key_state & i;                     // 0->1: key press detect
 
	  	if ( (key_state & REPEAT_MASK) == 0 ) {         // check repeat function
	     	rpt = REPEAT_START;                         // start delay
	  	}
	  	if ( --rpt == 0 ) {
	    	rpt = REPEAT_NEXT;                          // repeat delay
	    	key_rpt |= key_state & REPEAT_MASK;
	  	}

		if (timeout) timeout--;
	}
}


ISR(USART_UDRE_vect) {

	UDR0 = eeprom_read();
	id++;
}

ISR(USART_RX_vect) {	
	uint8_t uart_state, uart_data;
	static uint8_t i, cnt_sync, cnt_buffer, cnt_page;
	static uint8_t buffer[16];

	uart_state = UCSR0A;
	uart_data = UDR0;

	if (uart_state & (1<<FE0)) {
		if (uart_data == 0) cntFE++;
		if (aladin_state == download_s && !rx_error) {
			rx_error = 1;
			debug = id;
		}	
		cnt_sync = 0;
		aladin_sync = 0;
	} else {
		if (aladin_state == download_s) {
			// collect 16 bytes in buffer before eeprom access
			buffer[i++] = uart_data;
			id++;
			if (i==16) {	// buffer full
				i = 0;
				if (cnt_buffer == 0) {
					eeprom_start_write((block_down<<11) + cnt_page * 128);
				}
				eeprom_write_block(buffer, 16);
				cnt_buffer++;
				if (cnt_buffer == 8) {		// full page
					CS_HIGH;				// complete page write access
					cnt_buffer = 0;
					cnt_page++;
				}
			}
		} else {		
			if (uart_data == 0x55) {
				cnt_sync++;
				timeout = 3;
				if (cnt_sync == 3) {
					aladin_sync = 1;
					id = 0;
					i  = 0;
					cnt_buffer = 0;
					cnt_page   = 0;
				}
			} else {
				cnt_sync = 0;
				aladin_sync = 0;
			}
		}
	}
}
