/*
 * Memo Mouse replacement for UWATEC Aladin Pro Ultra dive computer
 *
 * simply copy the full 2050 byte data frame from the Aladin to EEPROM
 * and replay it when connected to the PC
 * no need for protocol decoding
 * The only drawback. All single data pakets must be uploaded to the PC manually
 * There is no such thing as free lunch.
 *
 * ATmega88A@7,3728MHz
 */

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h>
#include <stdint.h>
#include "main.h"
#include "menu.h"
#include "misc.h"
#include "globals.h"
#include "lcd.h"

int main(void) {
	// init IO
	
	DDRB = (1<<PB5) | (1<<PB3) | (1<<PB2);		// SPI
	PORTB = (1<<PB1) | (1<<PB0);				// internal pull uos for unused IOs
	DDRD = 0xFE;								// TXD / idle clock and LCD outputs
	PORTD = 0;
	CS_HIGH;
	DDRC  = 0;
	PORTC = 0xFF;								// key inputs, internal pull ups

	// init SPI
	// Master, MSB first, Prescaler /16

	SPCR = (1<<SPE) | (1<<MSTR) | (1<<SPR0);
	
	// init UART

	UCSR0B = (1<<RXEN0);
    UBRR0H = UBRR_VAL >> 8;
    UBRR0L = UBRR_VAL & 0xFF;

	lcd_init();

	// timer 1
	// mode 4, CTC, prescaler 8
	TCCR1A  = 0;
	TCCR1B  = (1<<WGM12) | (1<<CS11);
	OCR1A   = PERIOD;
	TIMSK1 |= (1<<OCIE1A);

	block_down = find_free_block();
	sei();
	
	/*
	// crc test
	for (int i=0; i<10; i++) {
		check_crc(i);
		timeout = 128;
		while(timeout);
	}
	while(1);
	*/

	while(1) {	
		if (!(aladin_state == download_sync_s && aladin_connect)) {
			set_sleep_mode(SLEEP_MODE_IDLE);
			sleep_mode();
		}
		aladin_fsm();
		if (flag100ms) {
			flag100ms = 0;
			menu_fsm();			
		}
	}
}

