#ifndef MAIN_H
#define MAIN_H

#define F_TIMER 	 		256		// Hz
#define CS_LOW		 		PORTB  &= ~(1<<PB2)
#define CS_HIGH		  		PORTB  |=  (1<<PB2)
#define TOGGLE_TXD	 		PIND    =  (1<<PD1)
#define READ_TXD			(PIND & (1<<PD1))
#define UART_TXD_ON  		UCSR0B |=  (1<<TXEN0)
#define UART_TXD_OFF 		UCSR0B &= ~(1<<TXEN0)
#define UART_RXC_ISR_ON		UCSR0B |=  (1<<RXCIE0)
#define UART_RXC_ISR_OFF	UCSR0B &= ~(1<<RXCIE0)
#define UART_UDRE_ISR_ON	UCSR0B |=  (1<<UDRIE0)
#define UART_UDRE_ISR_OFF	UCSR0B &= ~(1<<UDRIE0)

#define MAX_BLOCK		32		// max number of 2kB data blocks in external EEPROM

#define UART_BAUD_RATE 19200L

// don't change below, will be calculated

#define UBRR_VAL  ((F_CPU+UART_BAUD_RATE*8)/(UART_BAUD_RATE*16)-1)
#define BAUD_REAL (F_CPU/(16*(UBRR_VAL+1)))
#define BAUD_ERROR ((BAUD_REAL*1000)/UART_BAUD_RATE)    // error in promille + 1000

#if ((BAUD_ERROR<985) || (BAUD_ERROR>1015))
#error Systematic baud error above 1.5% which is too high!
#endif

#define PERIOD ((F_CPU / (F_TIMER * 8))-1)

#if (PERIOD >65535)
#error F_TIMER too low! 
#endif

#endif
