#include <avr/io.h>
#include <avr/pgmspace.h>
#include "uart.h"

// einzelnes Byte vom UART lesen

uint8_t uart_getc(void) {
	while(!UART_RXC);
	return UART_UDR;
}

// einzelnes Byte an UART senden

void uart_putc(uint8_t data) {
	while(!UART_UDRE);
	UART_UDR=data;
}

// String aus dem Flash an UART senden

void uart_puts_P(PGM_P data) {
	uint8_t tmp;

	while((tmp=pgm_read_byte(data))){
		uart_putc(tmp);
		data++;
	}
}

// String aus dem RAM an UART senden

void uart_puts(char* data) {
	uint8_t tmp;

	while((tmp=*data++)){
		uart_putc(tmp);
	}
}
