#include <lpc214x.h>
#include "viclowlevel.h"

#define FOSC	14745600

#define PAD1_ON		IOCLR0 = (1<<10)
#define PAD1_OFF	IOSET0 = (1<<10)
#define PAD1_FLASH (IOPIN0&(1<<10)?(IOCLR0=(1<<10)):(IOSET0=(1<<10)))

#define PAD2_ON		IOCLR0 = (1<<11)
#define PAD2_OFF	IOSET0 = (1<<11)
#define PAD2_FLASH (IOPIN0&(1<<11)?(IOCLR0=(1<<11)):(IOSET0=(1<<11)))


int main(void);
void system_init(void);
void tc1_isr(void);
void timer1_init(void);

volatile unsigned char main_update_flag = 0;
volatile long wait = 0;
volatile unsigned long timer_counter = 0;

void system_init(void)
{
	PLLCFG = (4-1)|((2-1)<<5);
	PLLCON = 0x01;
	PLLFEED = 0xAA;
	PLLFEED = 0x55;
	while (!(PLLSTAT & (1<<10)));
	PLLCON = (1<<0) | (1<<1);
	PLLFEED = 0xAA;
	PLLFEED = 0x55;
	MAMCR = 0;
	MAMTIM = 3;
	MAMCR = 2;
	VPBDIV = 4;
}



int main(void)
{
	system_init();

	IODIR0 |= (1<<10);
	IODIR0 |= (1<<11);

	PAD1_ON;
	PAD2_ON;

	enableIRQ();

	timer1_init();

	for(wait=0; wait < 3200000; wait++)
		asm volatile("nop");


	while (1)
	{

		if(main_update_flag)
		{
			PAD1_FLASH;

			main_update_flag = 0;
		}


	}
	return 0;
}





void __attribute__ ((interrupt("IRQ"))) tc1_isr(void)
{
	T1IR = (1<<0);
	PAD2_FLASH;
	
	volatile unsigned char test;
	timer_counter++;
	test++;


	if(!(timer_counter % 20)) // 32 = i.O.  20 = seltsam
	{
		main_update_flag=1;
	}


	VICVectAddr = 0;

}




void timer1_init(void)
{

	T1MR0 = (FOSC / 20) -1;

	T1MCR = (1<<0) | (1<<1);

	T1TCR = (1<<0);

	VICVectAddr0 = (unsigned long)tc1_isr;

	VICVectCntl0 = (1<<5) | 5;

	VICIntEnable = (1<<5);

}


