

#include "hardware_t.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
//#include "math.h"

// Class Display
// Public Functions
void Display::Init(void)											// Init Display Subroutine
{

	unsigned long *flash_address;
	int x, result = 0;
#ifdef _Debug_	
	if (Debug_Mode) printf("Starting Init Display \n");
#endif			
	Pulse11.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	Pulse12.Init(0.000000008, 0.000000008, 0.000524000, 0.000000008, 2, 3, "", "", "s");
	Pulse21.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	Pulse22.Init(0.000000016, 0.000000016, 0.268435448, 0.000000008, 2, 3, "", "", "s");
	
        switch(Pulse11_Expo)
        {
            case 1:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse11.Write_Value((float) Pulse11_Value / (float) 1000);
                break;
            }
        }
        Pulse11.RenderText();

        switch(Pulse12_Expo)
        {
            case 1:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                break;
            }
        }
        Pulse12.RenderText();

        switch(Pulse21_Expo)
        {
            case 1:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse21.Write_Value((float) Pulse21_Value / (float) 1000);
                break;
            }
        }
        Pulse21.RenderText();

        switch(Pulse22_Expo)
        {
            case 1:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000000);
                break;
            }
            case 2:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000);
                break;
            }
            case 3:
            {
                Pulse22.Write_Value((float) Pulse22_Value / (float) 1000);
                break;
            }
        }
        Pulse22.RenderText();	

	// init normal cursor data display
	Cursor_Delta_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "@X = ", "s");
	Cursor_Delta_1X.Init(0.00000001, 0.00000001, 10, 0.000000005, 3, 5, "", "1/@X = ", "Hz");
	Cursor_Delta_XY_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	Cursor_Vertical_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "s");
	Cursor_Vertical_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "s");

	Cursor_Vertical_Pos_XY_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Vertical_Pos_XY_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");

	// init FFT cursor data display
	FFT_Cursor_Delta_X.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "@X = ", "Hz");
	FFT_Cursor_Delta_1X.Init(0.00000001, 0.00000001, 10, 0.000000005, 3, 5, "", "1/@X = ", "s");
	FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");

	FFT_Cursor_Vertical_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");
	FFT_Cursor_Vertical_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");

	FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");

	// init QM-data display
	QM_Slot1.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Freq(@) :", "");
	QM_Slot2.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Pk-Pk(@) :", "");
	QM_Slot3.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Pk-Pk(@) :", "");	

//	QM_Slot1_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "Hz");
//	QM_Slot2_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
//	QM_Slot3_Value.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");	

	QM_Threshold_lower.Init(30, 5, 100, 1, 0, 3, "", "", "%");
	QM_Threshold_middle.Init(50, 5, 100, 1, 0, 3, "", "", "%");
	QM_Threshold_upper.Init(70, 5, 100, 1, 0, 3, "", "", "%");
	
//BF del	Math_Offset.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	
	Math_Offset_mul.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_add.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_sub.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");

	Zero_Level1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(1) = ", "V");
	Zero_Level2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(2) = ", "V");
	Zero_Level3_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(3) = ", "V");
	Zero_Level4_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "Ch(4) = ", "V");
	
	Trigger_Level_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");
	Trigger_ExtLevel_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "V");	
	Trigger_Offset_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "s");	
	
	Timebase_Offset_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 3, "", "", "s");

	HoldOff.Init(0.00000004, 0.00000004, 300, 0.00000004, 2, 5, "", "", "s");  // start 10 ns , min 10 ns, max 274 s, steps 8 ns , 2 afterdot, 4 maxlength, '' Text, '' PreText, 'S' Unit
	
	//BF obsolete FFT_Scale_Str.Init(0.00000004, 0.00000004, 300, 0.00000004, 2, 5, "", "", "dBV/");
	//BF obsolete FFT_Offset_Str.Init(0.00000004, 0.00000004, 300, 0.00000004, 2, 5, "", "", "dBV");
	
	switch(HoldOff_Expo)
	{
		case 1:
		{
			HoldOff.Write_StepSize(0.00000004);
			HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000000);
			break;
		}
		case 2:
		{
			HoldOff.Write_StepSize(0.0000001);
			HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000);
			break;
		}
		case 3:
		{
			HoldOff.Write_StepSize(0.001);
			HoldOff.Write_Value((float) HoldOff_Value / (float) 1000);
			break;
		}
		case 4:
		{
			HoldOff.Write_StepSize(1);
			HoldOff.Write_Value((float) HoldOff_Value);
			break;
		}
	}

	HoldOff.RenderText();	
	if (HoldOff_Value) trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
	else trig_holdoff_reg = 0x00000000;
		
		
	QM_Threshold_lower.Write_Value(20);	
	QM_Threshold_lower.RenderText();
	
	QM_Threshold_middle.Write_Value(50);	
	QM_Threshold_middle.RenderText();
	
	QM_Threshold_upper.Write_Value(80);	
	QM_Threshold_upper.RenderText();   	

	
	//Math_Offset_mul.Write_StepSize(1);
	Math_Offset_mul.Write_Value((float)((float)Math_Mul_Offset / (float)50000) );
	Math_Offset_mul.RenderText();
	//Math_Offset_sub.Write_StepSize(1);
	Math_Offset_sub.Write_Value((float)((float)Math_Sub_Offset / (float)50000) );
	Math_Offset_sub.RenderText();
	//Math_Offset_add.Write_StepSize(1);
	Math_Offset_add.Write_Value((float)((float)Math_Add_Offset / (float)50000) );
	Math_Offset_add.RenderText();
 

/*BF del
	if (config_loaded == false)
	{
//#ifdef _Debug_	
		printf("Generating Flash\n");
//#endif			
		// Generate Logo
				
		// Clear All Planes
		for (x = 0; x < 153600; x++) Planes[x] = 0;		

        	dma->np_piodata = 1;						// enable DMA Transfer
	   	dma->np_piodata = 0;

		//Generate_FLASH();
		
	    	// Write Config to Flash
	   	config_changed = true;
	    	AMDFlash::Write_Config_Flash();		
//#ifdef _Debug_		
		printf("Flash Generated\n");
		
		//printf("Resetting Hardware\n");		
//#endif		
		// Reset
//		Hardware::Reset_the_Watchdog();
		config_loaded = true;
		nr_delay(3000);
	}
*/	

	
    // execute config functions

//BF del not used	CALCTIMEBASE();
	
	CALCTRIGGER();
	CALCPRETRIGGER();
	
	if(FFT_Mode != FFT_OFF)
	FFT_CalcCursorData();
	else
	CALCCURSORDATA();

	CALCQMDATA();
#ifdef _Debug_
//	printf("Init : df : %f c1 : %d c2 : %d cs %d st %d sfi %d dst %d dsfi %d dwop %d\n", dmode_factor, Cursor_Delayed_1, Cursor_Delayed_2, Cursor_Delayed_Size, Selected_Timebase, SIGNALFaktor_idx, dmode_Selected_Timebase, dmode_SIGNALFaktor_idx, dmode_Window_Offset_Pos);
#endif	
	Hardware::Send_LED();
	
	if (Channel_1_Active) Hardware::UpdateChannel(1, 1);
	else
    {
        Hardware::UpdateChannel(1, 0);
        Channel_1_Active_Old = 1;
        VoltageChangedCh1 = 1;
    }

	if (Channel_2_Active) Hardware::UpdateChannel(2, 1);
	else
    {
        Hardware::UpdateChannel(2, 0);
        Channel_2_Active_Old = 1;
        VoltageChangedCh2 = 1;
    }

	if (Channel_3_Active) Hardware::UpdateChannel(3, 1);
	else
    {
        Hardware::UpdateChannel(3, 0);
        Channel_3_Active_Old = 1;
        VoltageChangedCh3 = 1;
    }

	if (Channel_4_Active) Hardware::UpdateChannel(4, 1);
	else
    {
        Hardware::UpdateChannel(4, 0);
        Channel_4_Active_Old = 1;
        VoltageChangedCh4 = 1;
    }

	Rotary_Steps = 0;
	Hardware::ON_Zero_Channel_1();
	Hardware::SetSwitches(1, Selected_Voltage_CH1);
	Hardware::SetDacOffset(1);
	Hardware::SetCHDacOffset(1);
	
	Rotary_Steps = 0;
	Hardware::ON_Zero_Channel_2();
	Hardware::SetSwitches(2, -1); // zwecks andere daten -switches2 in config
	Hardware::SetDacOffset(2);
	Hardware::SetCHDacOffset(2);
	
	if (NumberOfChannels > 2)
	{
        	Rotary_Steps = 0;
        	Hardware::ON_Zero_Channel_3();
		Hardware::SetSwitches(3, Selected_Voltage_CH3);
		Hardware::SetDacOffset(3);
		Hardware::SetCHDacOffset(3);
		
		Rotary_Steps = 0;
		Hardware::ON_Zero_Channel_4();
		Hardware::SetSwitches(4, Selected_Voltage_CH4);
		Hardware::SetDacOffset(4);
		Hardware::SetCHDacOffset(4);
	}
		
		
	data_adr->np_piodata = ram_adress_reg;	

//	printf("Math aktiv %d - %d\n", Channel_Math_Active, NumberOfChannels);
	
	if (Channel_Math_Active == 1)
	{
		if (NumberOfChannels == 2)
		{
		//if (MenuPopupStatus[1][2] == 1) MenuPopupStatus[1][2] = 2;
		//if (MenuPopupStatus[3][2] == 1) MenuPopupStatus[3][2] = 2;
		}
		else
		{
		//if (MenuPopupStatus[1][4] == 1) MenuPopupStatus[1][4] = 2;
		//if (MenuPopupStatus[3][4] == 1) MenuPopupStatus[3][4] = 2;
		}
	}

	DRAW_SPLASH(true);
	
	//ColorDemo2();	

	// Draw Startscreen
	DrawInitialScreen();
	
	TimebaseChanged     = 1;
	TimeOffsetChanged   = 1;
	TriggerLevelChanged = 1;
	TriggerModeChanged  = 1;
	TriggerWayChanged   = 1;

	StatusUpdate();
	
	CursorChanged = 3;
	Cursor_Data_First_Draw = 1;
	DRAWCURSORDATA(0);
	
	Quick_Measure_First_Draw = 1;
	DRAWQMDATA(0); 	
	
	DRAW_ALL_CURSOR();
#ifdef _Debug_    		
	if (Debug_Mode) printf("Flash Drawed\n");					
#endif

 /* TMW    if (MenuStatus[5][4] == 241) DRAWMEMORY(0, 1, 1);  TMW */  		//BF memory browse		
	
	// must be set bevor SetupADC						
	init_done   = true;	
	first_start = true;
	Hardware::UpdateTrigger(30);
	first_start = false; 	
	
	serdata->np_piodata = ext_trg_val_reg;

	serstartpwm->np_piodata = 1;
	serstartpwm->np_piodata = 0;	
	
	
		/*
	send_buffer[0] = 3;						// Command Write Data
	send_buffer[1] = 0;
						
	Hardware::SendData(send_buffer);	
	*/

}

//##########################################################################################################################################################

void Display::DRAW_SPLASH(unsigned char remove)
{
	unsigned long x;
	char BufText[80];
	char BufText2[80];	
	char BufText3[80];	
	char BufText4[80];
	unsigned char Grid_Color_Buff = GridColor_Val;
	

        printf("Draw Splash\r\n");

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}	
	
	GridColor_Val = WT_Logo_Color_Val;
	Hardware::SetupADC();
	
	sprintf(BufText, "%1i.%1i.BF.%1i.%1i beta", tc_version, tc_subversion, tc_dev_version, tc_dev_subversion);
	sprintf(BufText2, "%X.%c%c", tc_hw_version, tc_production_lot1, tc_production_lot2);
	sprintf(BufText3, "%06d%02d%1X%1X", tc_serial, ((tc_shipment_date & 0x0000FF00) >> 8), ((tc_shipment_date & 0x000000F0) >> 4), (tc_shipment_date & 0x0000000F));	
	sprintf(BufText4, "W%04dA", tc_model);
	
	// Muß auch ins flash
		
        //TEXTOUTvbig("Developed by", Splash_Data_PosX + 28, Splash_Data_PosY - 20, 1, UI_Plane1);		
   	TEXTOUTxvbig("Hayo W. (BlueFlash)", Splash_Logo_PosX - 14, Splash_Data_PosY - 20, 1, UI_Plane1);	
	
	TEXTOUTvbig("Model : ", Splash_Data_PosX + 28, Splash_Data_PosY + 50, 1, UI_Plane1);
	TEXTOUTvbig(BufText4, Splash_Data_PosX + 148, Splash_Data_PosY + 50, 1, UI_Plane1);	
		
	TEXTOUTvbig("Hardware Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 70, 1, UI_Plane1);
	TEXTOUTvbig(BufText2, Splash_Data_PosX + 148, Splash_Data_PosY + 70, 1, UI_Plane1);		
	TEXTOUTvbig("Software Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 90, 1, UI_Plane1);
	TEXTOUTvbig(BufText, Splash_Data_PosX + 148, Splash_Data_PosY + 90, 1, UI_Plane1);	
		
	TEXTOUTvbig("Serial Number : ", Splash_Data_PosX + 28, Splash_Data_PosY + 110, 1, UI_Plane1);
	TEXTOUTvbig(BufText3, Splash_Data_PosX + 148, Splash_Data_PosY + 110, 1, UI_Plane1);	 	
		
	TEXTOUTvbig("No Rights Reserved _ 2009", Splash_Data_PosX + 236, Splash_Data_PosY + 250, 1, UI_Plane1);

	AMDFlash::copy_flash_to_plane(WTAG_Logo_Half_Flash, UI_Plane5);
	AMDFlash::copy_flash_to_plane(WTAG_Logo, Grid_Plane);

	Splash_drawed = true;
	
	// Clear Buffer Planes
	for (x = 0; x < 9600; x++)
	{
		Buffer_Plane1[x] = 0;
		Buffer_Plane2[x] = 0;
		Buffer_Plane3[x] = 0;
		Buffer_Plane4[x] = 0;
		Buffer_PlaneM[x] = 0;
		//Buffer_UI2Plane[x] = 0;		 is in marker 1
		Buffer_Mark1Plane[x] = 0;
	}

	dma->np_piodata = 1;											// enable DMA Transfer
	dma->np_piodata = 0;    	
    	
	if (remove)
	{
		//BF del Hardware::Setup_Interrupts();  		
		Search_Auto = true;
		//Hardware::SearchZeros();
		
		nr_delay(2000);	
	
		REMOVE_SPLASH();
		Splash_drawed = false;
	}

	if (Splash_drawed == false)
	{
		New_Menu = 14;
	
		Menu_Changed = 1;
    		UpdateMenuTextPlane = true;	
	}
	printf("Draw Splash finished\r\n");	

}

//##########################################################################################################################################################

void Display::REMOVE_SPLASH(void)
{
	unsigned long x;
	char BufText[80];
	char BufText2[80];	
	char BufText3[80];	
	char BufText4[80];
	
	sprintf(BufText, "%1i.%1i.BF.%1i.%1i beta", tc_version, tc_subversion, tc_dev_version, tc_dev_subversion);
	sprintf(BufText2, "%X.%c%c", tc_hw_version, tc_production_lot1, tc_production_lot2);
	sprintf(BufText3, "%06d%02d%1X%1X", tc_serial, ((tc_shipment_date & 0x0000FF00) >> 8), ((tc_shipment_date & 0x000000F0) >> 4), (tc_shipment_date & 0x0000000F));	
	sprintf(BufText4, "W%04dA", tc_model);
		
	// Clear Buffer Planes
	for (x = 0; x < 9600; x++)
	{
		Buffer_Plane1[x] = 0;
		Buffer_Plane2[x] = 0;
		Buffer_Plane3[x] = 0;
		Buffer_Plane4[x] = 0;
		Buffer_PlaneM[x] = 0;
		//Buffer_UI2Plane[x] = 0;		 is in marker 1
		Buffer_Mark1Plane[x] = 0;
	}

	for (x = 0; x < 9600; x++)
	{
		UI_Plane5[x] = 0;
	}	  	
			
	BITBITMAP(bitbmWTAG, Splash_Logo_PosX, Splash_Logo_PosY, 0, Grid_Plane);
			
	//TEXTOUTvbig("Developed by", Splash_Data_PosX + 28, Splash_Data_PosY - 20, 0, UI_Plane1);		
	TEXTOUTxvbig("Hayo W. (BlueFlash)", Splash_Logo_PosX - 14, Splash_Data_PosY - 20, 0, UI_Plane1);
	
	TEXTOUTvbig("Model : ", Splash_Data_PosX + 28, Splash_Data_PosY + 50, 0, UI_Plane1);
	TEXTOUTvbig(BufText4, Splash_Data_PosX + 148, Splash_Data_PosY + 50, 0, UI_Plane1);	
		
	TEXTOUTvbig("Hardware Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 70, 0, UI_Plane1);
	TEXTOUTvbig(BufText2, Splash_Data_PosX + 148, Splash_Data_PosY + 70, 0, UI_Plane1);		
	
	TEXTOUTvbig("Software Version : ", Splash_Data_PosX + 28, Splash_Data_PosY + 90, 0, UI_Plane1);
	TEXTOUTvbig(BufText, Splash_Data_PosX + 148, Splash_Data_PosY + 90, 0, UI_Plane1);	
		
	TEXTOUTvbig("Serial Number : ", Splash_Data_PosX + 28, Splash_Data_PosY + 110, 0, UI_Plane1);
	TEXTOUTvbig(BufText3, Splash_Data_PosX + 148, Splash_Data_PosY + 110, 0, UI_Plane1);	 	
		
	TEXTOUTvbig("No Rights Reserved _ 2009", Splash_Data_PosX + 236, Splash_Data_PosY + 250, 0, UI_Plane1);		
			
	GridColor_Val = GridColorArray[GridColorArrayPos];
	Hardware::SetupADC();
#ifdef _Debug_	
	if (Debug_Mode) printf("Remove Splash finished\n");	
#endif	
	Splash_removed = true;
}

//##########################################################################################################################################################

void Display::DrawInitialScreen(void)
{
	unsigned long lX;

	//Top area above the grid
	for (lX = TOP_PLANE_MIN; lX < TOP_PLANE_MAX; lX++)
	{
		Buffer_UI2Plane[lX] = *(UI_Plane2_Flash + lX);
		UI_Plane3[lX] = *(UI_Plane3_Flash + lX);
	}


// BF delete old cursors and markers
	//Grid area
	for (lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{
		Buffer_Mark1Plane[lX] = 0;
		Marker_Plane1[lX] = 0;

	}	

	//Bottom area
	for (lX = BOTT_PLANE_MIN; lX < BOTT_PLANE_MAX; lX++)
	{
		UI_Plane1[lX] = *(UI_Plane1_Flash + lX);
		Buffer_UI2Plane[lX] = *(UI_Plane2_Flash + lX);		
		UI_Plane3[lX] = *(UI_Plane3_Flash + lX);
		UI_Plane4[lX] = *(UI_Plane4_Flash + lX);
		UI_Plane5[lX] = *(UI_Plane5_Flash + lX);
	}

	//------------------------------------------------------------------------------
	//Draw Grids		//BF
	//------------------------------------------------------------------------------
	if (XY_Mode)								//Check if XY-mode
	GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw XY grid into gridplane
	else if (MenuStatus[MENU_TIMEBASE][1] == 1) 				//delayed mode
	GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);
	else if (FFT_Mode != FFT_OFF) 						// FFT mode
	GRIDFFT(GRID_XOFFS_FFT, GRID_YOFFS_FFT, Grid_Plane);			// Draw FFT grid into gridplane
	else 									//main mode
	GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw main grid into gridplane
	
	
	//Print text into the top area
	StatusUpdate();

	if (FFT_Mode != FFT_OFF)
	FFT_DrawStatus();

/*BF del
	if (Channel_1_Active == 1)
	{
		TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);							// Draw Voltage Text
//		TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);							// Draw Voltage Text
	}
	if (Channel_2_Active == 1)
	{
		TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);							// Draw Voltage Text
//		TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);							// Draw Voltage Text
	}
	if (Channel_3_Active == 1)
	{
	//BF ??	DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);						// Button	
		TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);							// Draw Voltage Text
//		TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);							// Draw Voltage Text
	}
	if (Channel_4_Active == 1)
	{
	//BF ??	DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);						// Button			
		TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);							// Draw Voltage Text
//		TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);							// Draw Voltage Text
	}
*/

}

void Display::RefreshScreen(void)
{
	unsigned long lX;

// BF delete old cursors and markers
	//Grid area
	for (lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{
		Buffer_Mark1Plane[lX] = 0;
		Marker_Plane1[lX] = 0;
	}	

	if(FFT_Mode == FFT_OFF)
	{	
		//if (MenuPopupActive > -1)
		//nr_delay(1000);
	

		int xa = 19 * 20;		// Ypos * 20
		int xo = 16;	//512 / 32;	// Xpos / 32
	
		for (int Ct = 0; Ct < 400 ; Ct++)	// Ysize = 110
		{			
			*(UI_Plane1 + xo + xa)     = 0;	// Xsize + 1 (+32), + 2 (+ 2*32)...
			*(UI_Plane1 + xo + xa + 1) = 0;
			*(UI_Plane1 + xo + xa + 2) = 0;
			*(UI_Plane1 + xo + xa + 3) = 0;
	
			*(UI_Plane2 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane2 + xo + xa + 1) = 0;
			*(UI_Plane2 + xo + xa + 2) = 0;
			*(UI_Plane2 + xo + xa + 3) = 0;
	
			*(UI_Plane3 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane3 + xo + xa + 1) = 0;
			*(UI_Plane3 + xo + xa + 2) = 0;
			*(UI_Plane3 + xo + xa + 3) = 0;
	
			*(UI_Plane4 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane4 + xo + xa + 1) = 0;
			*(UI_Plane4 + xo + xa + 2) = 0;
			*(UI_Plane4 + xo + xa + 3) = 0;
	
			*(UI_Plane5 + xo + xa)     = 0;	// Xsize + 1 , + 2 ...
			*(UI_Plane5 + xo + xa + 1) = 0;
			*(UI_Plane5 + xo + xa + 2) = 0;
			*(UI_Plane5 + xo + xa + 3) = 0;
	
			xa += 20;
		}

/*
		for (lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
		{
			//delete FFT-status area
			UI_Plane1[lX] = 0;
			UI_Plane2[lX] = 0;
			UI_Plane3[lX] = 0;
			UI_Plane4[lX] = 0;
			UI_Plane5[lX] = 0;
		}	
*/
	}	

	//------------------------------------------------------------------------------
	//Draw Grids		//BF
	//------------------------------------------------------------------------------
	if (XY_Mode)								// Check if XY-mode
	GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw XY grid into gridplane
	else if (MenuStatus[MENU_TIMEBASE][1] == 1) 				// delayed mode
	GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);
	else if (FFT_Mode != FFT_OFF) 						// FFT mode
	GRIDFFT(GRID_XOFFS_FFT, GRID_YOFFS_FFT, Grid_Plane);			// Draw FFT grid into gridplane
	else 									// main mode
	GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);				// Draw main grid into gridplane
	

	VoltageChangedCh1 = 1;	
	VoltageChangedCh2 = 1;	
	if(NumberOfChannels == 4)
	{
		VoltageChangedCh3 = 1;	
		VoltageChangedCh4 = 1;	
	}	

	//Print text into the top area
	StatusUpdate();

	if (FFT_Mode != FFT_OFF)
	FFT_DrawStatus();

}
//##########################################################################################################################################################
//BF -> draw rectangle??
void Display::DRAWP(int x, int y, int dx, int dy, char set, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int bitbuf;
	int intbuf;
	long BitMaskBuf;
	
	int ctx, cty;
		
	intbuf = (x >> 5);	
	
	bit = (x - (intbuf << 5));
	bitbuf = bit;
		
	for (cty = y; cty < (y + dy); cty++)
	{
		bit = bitbuf;
		if (set == 1) BitMaskBuf = BitMasks2[bit];
		else BitMaskBuf = BitMasks[bit];
		
		pos = (cty * 20) + intbuf;
				
		for (ctx = dx; ctx > 0; ctx--)
		{
			if (set == 1)
			{
				*(planeaddress + pos) = *(planeaddress + pos) | BitMaskBuf;
				BitMaskBuf >>= 1;
			}
			else
			{
				*(planeaddress + pos) = *(planeaddress + pos) & BitMaskBuf;
				BitMaskBuf >>= 1;
				BitMaskBuf |= 0x80000000;				
			}			
		
			bit++;
			
			if (bit > 31)
			{
				bit = 0;
				pos++;
				if (set == 1) BitMaskBuf = 0x80000000;
				else BitMaskBuf = 0x7FFFFFFF;
			}
		}		
	}	
}
//##########################################################################################################################################################

void Display::PIXELP(int x, int y, char set, unsigned long *planeaddress)
{
	int pos;
	int bit;
	int intbuf;
	
	intbuf = x >> 5;	
	pos = Display_Line_Adresses[y] + intbuf;		
	bit = x - (intbuf << 5);
	
	if (set == 1) *(planeaddress + pos) |= BitMasks2[bit];
	else *(planeaddress + pos) &= BitMasks[bit];
}
//##########################################################################################################################################################
// BF complete new routine with Bresenham algorithm
void Display::DRAWLINEP(int x1, int y1, int x2, int y2, char set, unsigned long *plane)	// Draw a Line
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 <= x2; x1++)	{ PIXELP( x1, y1, set, plane); }
		else
		for(; x2 <= x1; x2++)	{ PIXELP( x2, y1, set, plane); }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 <= y2; y1++)	{ PIXELP( x1, y1, set, plane); }
		else
		for(; y2 <= y1; y2++)	{ PIXELP( x1, y2, set, plane); }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ PIXELP( x1, y1, set, plane); }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	PIXELP( x1, y1, set, plane);
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			PIXELP( x1, y1, set, plane);
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			PIXELP( x1, y1, set, plane);
		}
		return;
        }

}
//##########################################################################################################################################################
// BF not needed any more
/*
void Display::DRAWZEROLINE(int y, char set, unsigned long *plane)
{

    int pos, cnt;

    pos = Display_Line_Adresses[y + 20];

    if (set) *(plane + pos) |= 0x00000FFF;
    else *(plane + pos) &= 0xFFF00000;

    for (cnt = 1; cnt < 19; cnt++)
    {
        if (set) *(plane + pos + cnt) = 0xFFFFFFFF;
        else *(plane + pos + cnt) = 0x00000000;
    }

    if (set) *(plane + pos + 19) |= 0xFFE00000;
    else *(plane + pos + 19) &= 0x001FFFFF;

}
*/
//##########################################################################################################################################################

void Display::TEXTOUTvbig(char *String, int x, int y, char set, unsigned long *layer)	// Draw Text at Pos X / Y with Color and BackColor (FF = Transparent)
{
	int Buf, Ct, Ctt, Bit;
	int count;
	
	count = strlen(String);

	// Start drawing background
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Calculate the correction for the background
	{
		Buf = String[Ct] - 32;							// get the letter
		
		for (Ctt = 0;Ctt < 14; Ctt++)						// test the Bytes of the letter (x size)
		{
			if (FONT10X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;		// if itŽs size small than the minimum size 0x80 signals it
		}
	}	
	
	//Draw Background	
//	if (backcolor != 0xFF) DRAWP(x - 3, y - 4, (14 * count) + 5 - Bit, 18, backcolor, layer);	// Text background (0xFF transparent) (Lettercount * Minimumsize) - Lettersize correktion
	
	//Start drawing letters
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Letterloop
	{
		Buf = String[Ct] - 32;							// get the letter
		
		for (Ctt = 0;Ctt < 14; Ctt++)						// Letterbyteloop
		{		
			if (FONT10X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;	// if Letterbyte = 0x80 the end of the letter is reached and the next letter not move forward
			else
			{
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y, set, layer);			// If Bit 0 set Pixel 0 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 1, set, layer);		// If Bit 1 set Pixel 1 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 2, set, layer);		// If Bit 2 set Pixel 2 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 3, set, layer);		// If Bit 3 set Pixel 3 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 4, set, layer);		// If Bit 4 set Pixel 4 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 5, set, layer);		// If Bit 5 set Pixel 5 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 6, set, layer);		// If Bit 6 set Pixel 6 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2)] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 7, set, layer);		// If Bit 7 set Pixel 7 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 8, set, layer);		// If Bit 8 set Pixel 8 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 9, set, layer);		// If Bit 9 set Pixel 9 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 10, set, layer);		// If Bit 10 set Pixel 10 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 11, set, layer);		// If Bit 11 set Pixel 11 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 12, set, layer);		// If Bit 12 set Pixel 12 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 13, set, layer);		// If Bit 13 set Pixel 13 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 14, set, layer);		// If Bit 14 set Pixel 14 in the Row is drawed in the color
				if ((FONT10X9[Buf][(Ctt * 2) + 1] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 15, set, layer);	// If Bit 15 set Pixel 15 in the Row is drawed in the color
			}							
		}
	}
}
//##########################################################################################################################################################

void Display::TEXTOUTxvbig(char *String, int x, int y, char set, unsigned long *layer)	// Draw Text at Pos X / Y with Color and BackColor (FF = Transparent)
{
	int Ct, Ctt, Bit;
	int count;
	unsigned char Buf;
	
	count = strlen(String);
	
	// Start drawing background
	Bit = 0;									// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)							// Calculate the correction for the background
	{
		Buf = String[Ct] - 32;							// get the letter
				
		for (Ctt = 0;Ctt < 14; Ctt++)						// test the Bytes of the letter (x size)
		{
			if (FONT12X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;		// if it's size small than the minimum size 0x80 signals it		
		}
	}	
	
	//Draw Background	
//	if (backcolor != 0xFF) DRAWP(x - 3, y - 3, (14 * count) + 5 - Bit, 19, backcolor, layer);	// Text background (0xFF transparent) (Lettercount * Minimumsize) - Lettersize correktion
	
	//Start drawing letters
	Bit = 0;													// Correction Counter for different letter size (e.g. i or w)
	
	for (Ct = 0;Ct < count; Ct++)								// Letterloop
	{
		Buf = String[Ct] - 32;								// get the letter
		for (Ctt = 0;Ctt < 14; Ctt++)							// Letterbyteloop
		{
			if (FONT12X9[Buf][(Ctt * 2) + 1] == 0x80) Bit++;	// if Letterbyte = 0x80 the end of the letter is reached and the next letter not move forward
			else
			{
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y, set, layer);					// If Bit 0 set Pixel 0 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 1, set, layer);				// If Bit 1 set Pixel 1 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 2, set, layer);				// If Bit 2 set Pixel 2 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 3, set, layer);				// If Bit 3 set Pixel 3 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 4, set, layer);				// If Bit 4 set Pixel 4 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 5, set, layer);				// If Bit 5 set Pixel 5 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 6, set, layer);				// If Bit 6 set Pixel 6 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2)] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 7, set, layer);				// If Bit 7 set Pixel 7 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x01) == 1) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 8, set, layer);			// If Bit 8 set Pixel 8 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x02) == 2) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 9, set, layer);			// If Bit 9 set Pixel 9 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x04) == 4) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 10, set, layer);			// If Bit 10 set Pixel 10 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x08) == 8) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 11, set, layer);			// If Bit 11 set Pixel 11 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x10) == 16) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 12, set, layer);		// If Bit 12 set Pixel 12 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x20) == 32) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 13, set, layer);		// If Bit 13 set Pixel 13 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x40) == 64) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 14, set, layer);		// If Bit 14 set Pixel 14 in the Row is drawed in the color
				if ((FONT12X9[Buf][(Ctt * 2) + 1] & 0x80) == 128) PIXELP(x + Ctt + (Ct * 14) - Bit, y + 15, set, layer);		// If Bit 15 set Pixel 15 in the Row is drawed in the color
			}								
		}
	}
}
//##########################################################################################################################################################

void Display::BITBITMAP(unsigned char *pointer, int x, int y, unsigned char set, unsigned long *layer)	// Draw two color bitmap
{
	int cc, cx, cy, pos;
	unsigned char ccmask;

	int sizex = (int) pointer[0] / 8;
	int sizey = pointer[1];


	pos = 2;

	for (cy = 0; cy < sizey; cy++)
	{
		for (cx = 0; cx < sizex; cx++)
		{
			ccmask = 0x80;			
			
			for (cc = 0; cc < 8; cc++)
			{			
				if ((pointer[pos] & ccmask) == ccmask)
				{
					PIXELP(x + cc + (cx * 8), y + cy, set, layer);
				}
				ccmask = ccmask >> 1;
			}
			pos++;			
		}
	}
}
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension GRID_WIDTH 600 x 400)
void Display::GRID(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	
	
	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	


	//---------------------------------------------------------------------------------------------
	// Horizontal (X) division from left to right - 12 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for (lX = x; lX < (x + GRID_WIDTH + 1); lX ++)
	{
		//draw top and bottom edge lines and middle line, 
		PIXELP(lX, y - 1, 1, layer);				// Top Line
		PIXELP(lX, y + GRID_HEIGHT + 1, 1, layer);		// Bottom Line
		//print every second point 
		if ((lX - x)%2 == 0) {
			PIXELP(lX, y + GRID_HEIGHT / 2, 1, layer);	// Middle Line
		}	
		
		
		//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
		if( ((lX - x)%10 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0) )
		{
			//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
			PIXELP(lX, y + 0, 1, layer);
			PIXELP(lX, y + 2, 1, layer);
			//Middle top 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 3, 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 1, 1, layer);
			//Middle bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_HEIGHT / 2) + 1, 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT / 2) + 3, 1, layer);
			//Bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + GRID_HEIGHT - 2, 1, layer);
			PIXELP(lX, y + GRID_HEIGHT, 1, layer);
		}	

		//Main division - 50 pixel for one division
		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_WIDTH - 5) && ((lX - x) != (GRID_WIDTH / 2)))
		{
			//Top line division
			PIXELP(lX, y + 1, 1, layer);
			PIXELP(lX, y + 3, 1, layer);
			PIXELP(lX, y + 5, 1, layer);
			//Middle line top division
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 6), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 4), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) - 2), 1, layer);
			//Middle line bottom division
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 2), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 4), 1, layer);
			PIXELP(lX, y + ((GRID_HEIGHT / 2) + 6), 1, layer);
			//Bottom line division
			PIXELP(lX, y + (GRID_HEIGHT - 5), 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT - 3), 1, layer);
			PIXELP(lX, y + (GRID_HEIGHT - 1), 1, layer);

			//Grid lines vertical - grid width modulo 50 = 12 lines with one point every 10th pixel
			if (dotted_grid)
				for (lY = y + 10; lY < (y + GRID_HEIGHT - 5); lY += 10)	//dotted line
				{ PIXELP(lX, lY, 1, layer); }
			else
				for (lY = y; lY < (y + GRID_HEIGHT); lY ++)		//solid line
				{ PIXELP(lX, lY, 1, layer); }
		}	
		
	}
	
	//---------------------------------------------------------------------------------------------
	// Vertical (Y) division from top to bottom - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for(lY = y; lY < (y + GRID_HEIGHT + 1); lY++)
	{
		PIXELP(x - 1, lY, 1, layer);				// Left side line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);		// Right side line	
		// one point every second pixel
		if ((lY - y)%2 == 0) 
		{
			PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);	// Vertical middle line
		}	

		//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
		if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)) && ((lY - y)%50 != 0) )
		{
			//Left side 2 pixel line for 5 subdivisions
			PIXELP(x + 0, lY, 1, layer);
			PIXELP(x + 2, lY, 1, layer);
			//Middle left side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer);
			//Middle right side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer);
			//Right side 2 pixel line for 5 subdivisions
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer);
			PIXELP(x + GRID_WIDTH, lY, 1, layer);
		}		
		

		// Vertical main division 400 : 50 = 8 squares high
		if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)))
		{
			// Left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + 1, lY, 1, layer);
			PIXELP(x + 3, lY, 1, layer);
			PIXELP(x + 5, lY, 1, layer);
			// Middle left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer);
			// Middle right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer);
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer);
			// Right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer);
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer);
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer);

			//Gridlines horizontal - grid height modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
				for (lX = x + 10 ; lX < (x + GRID_WIDTH - 5); lX += 10)	//dotted line
				{ PIXELP(lX, lY, 1, layer); }
			else
				for (lX = x; lX < (x + GRID_WIDTH); lX ++)	//solid line
				{ PIXELP(lX, lY, 1, layer); } 
		}		
	}
	
	//Gridlines horizontal - for 10% - 90% rise time determination with one point every 25th pixel
	lY = y + 75;		//90%
	//for (lX = x ; lX < (x + GRID_WIDTH); lX += 25)
	for (lX = x ; lX < (x + GRID_WIDTH); lX += 10)
	{	
		if (((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)))
		{
			//PIXELP(lX - 3, lY, 1, layer);
			PIXELP(lX, lY, 1, layer);
			//PIXELP(lX + 3, lY, 1, layer);
		}
	}

	lY = y + GRID_HEIGHT - 75;	//10%
	//for (lX = x ; lX < (x + GRID_WIDTH); lX += 25)
	for (lX = x ; lX < (x + GRID_WIDTH); lX += 10)
	{	
		if (((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)))
		{
			//PIXELP(lX - 3, lY, 1, layer);
			PIXELP(lX, lY, 1, layer);
			//PIXELP(lX + 3, lY, 1, layer);
		}
	}

	PIXELP(x - 1, y - 1, 1, layer); 				// Left top corner
	PIXELP(x + GRID_WIDTH + 1, y - 1, 1, layer); 			// Right top corner
	PIXELP(x - 1, y + GRID_HEIGHT + 1, 1, layer); 			// Left bottom corner
	PIXELP(x + GRID_WIDTH + 1, y + GRID_HEIGHT + 1, 1, layer); 	// Right bottom corner
}
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension GRID_WIDTH 600 x 200 x 2)
void Display::GRIDDELAYED(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	unsigned long by = y + (GRID_HEIGHT / 2);	
	

	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	
	
	
	//Horizontal line drawing
	for(lX = x; lX < (x + GRID_WIDTH + 1); lX++)	//lX += 2)
	{
		PIXELP(lX, y - 1, 1, layer);										// Top Line
		PIXELP(lX, y + (GRID_HEIGHT / 4), 1, layer);								// Middle Line
		PIXELP(lX, y + ((GRID_HEIGHT / 2) + 1), 1, layer);							// Bottom Line
		
		
		if (((lX - x)%10 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0))
		{
			PIXELP(lX, y + 0, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, y + 2, 1, layer);									// 10 er Dots Top Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 3, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 2, 1, layer);						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2), 1, layer); 							// 10 er Dots Bottom Line
	
		}		

		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)))
		{

			PIXELP(lX, y + 1, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, y + 3, 1, layer); 									// 10 er Dots Top Line	
			PIXELP(lX, y + 5, 1, layer); 									// 10 er Dots Top Line	
			
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 6, 1, layer); 						// 10 er Dots Middle Line	
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) - 2, 1, layer);						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, y + (GRID_HEIGHT / 4) + 6, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 5, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 3, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, y + (GRID_HEIGHT / 2) - 1, 1, layer); 						// 10 er Dots Bottom Line	

			//Draw vertical line on every main X-division
			for(lY = (y + 5); lY < (y + (GRID_HEIGHT / 2)); lY += 5)	// 10 BF ???
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}
		
	}
	
	//Vertical line drawing
	for(lY = y; lY < (y + ((GRID_HEIGHT / 2) + 1)); lY++)	//lY += 2) 
	{
		PIXELP(x - 1, lY, 1, layer);										// Left Line
		PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);								// Middle Line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);								// Right Line
		
		if (((lY - y)%5 == 0) && ((lY - y) > 2) && ((lY - y) < ((GRID_HEIGHT / 2) - 2)) && ((lY - y) != (GRID_HEIGHT / 4)) && ((lY - y)%25 != 0))
		{
			PIXELP(x + 0, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 2, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH, lY, 1, layer); 								// 10 er Dots Right Line
		}		
		
		if (((lY - y)%25 == 0) && ((lY - y) > 2) && ((lY - y) < ((GRID_HEIGHT / 2) - 2)) && ((lY - y) != (GRID_HEIGHT / 4)))
		{

			PIXELP(x + 1, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 3, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 5, lY, 1, layer); 									// 10 er Dots Left Line
			
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer); 						// 10 er Dots Middle Line	
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer); 							// 10 er Dots Right Line	
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer); 							// 10 er Dots Right Line

			//Draw horizontal line on every main Y-division
			for (lX = (x + 10); lX < (x + GRID_WIDTH); lX += 10)
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}		
	}
	
	PIXELP(x - 1, y - 1, 1, layer); 										// Left Top corner
	PIXELP(x + GRID_WIDTH + 1, y - 1, 1, layer);									// Right Top corner
	PIXELP(x - 1, y + ((GRID_HEIGHT / 2) + 1), 1, layer); 								// Left Bottom corner
	PIXELP(x + GRID_WIDTH + 1, y + ((GRID_HEIGHT / 2) + 1), 1, layer); 						// Right Bottom corner

	//-----------------------------------	
	// 	Delayed Part
	//-----------------------------------
	// Horizontal drawing
	for (lX = x; lX < (x + GRID_WIDTH + 1);	lX++)	//lX += 2)
	{
		PIXELP(lX, by - 1, 1, layer);										// Top Line
		PIXELP(lX, by + (GRID_HEIGHT / 4), 1, layer);								// Middle Line
		PIXELP(lX, by + ((GRID_HEIGHT / 2) + 1), 1, layer);							// Bottom Line
		
		
		if (((lX - x)%10 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)) && ((lX - x)%50 != 0))
		{
			PIXELP(lX, by + 0, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 2, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 1, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 3, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 2, 1, layer);						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2), 1, layer); 							// 10 er Dots Bottom Line
	
		}		

		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < (GRID_WIDTH - 5)) && ((lX - x) != (GRID_WIDTH / 2)))
		{

			PIXELP(lX, by + 1, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 3, 1, layer); 									// 10 er Dots Top Line
			PIXELP(lX, by + 5, 1, layer); 									// 10 er Dots Top Line
			
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 6, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) - 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 2, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 4, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(lX, by + (GRID_HEIGHT / 4) + 6, 1, layer); 						// 10 er Dots Middle Line
			
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 5, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 3, 1, layer); 						// 10 er Dots Bottom Line
			PIXELP(lX, by + (GRID_HEIGHT / 2) - 1, 1, layer);						// 10 er Dots Bottom Line	

			//Draw vertical line on every main X-division
			for (lY = (by + 5); lY < (by + (GRID_HEIGHT / 2)); lY += 5)	//10  BF ??
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}
		
	}
	
	//Vertical drawing
	for	(lY = by; lY < (by + ((GRID_HEIGHT / 2) + 1)); lY++) 	//lY += 2)
	{
		PIXELP(x - 1, lY, 1, layer);										// 2 er Dots Left Line
		PIXELP(x + (GRID_WIDTH / 2), lY, 1, layer);								// 2 er Dots Middle Line
		PIXELP(x + GRID_WIDTH + 1, lY, 1, layer);								// 2 er Dots Right Line		
		
		if (((lY - by)%5 == 0) && ((lY - by) > 2) && ((lY - by) < ((GRID_HEIGHT / 2) - 2)) && ((lY - by) != (GRID_HEIGHT / 4)) && ((lY - by)%25 != 0))
		{
			PIXELP(x + 0, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 2, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 1, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 1, lY, 1, layer);							// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 3, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 2, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH, lY, 1, layer); 								// 10 er Dots Right Line
		}		
		
		if (((lY - by)%25 == 0) && ((lY - by) > 2) && ((lY - by) < ((GRID_HEIGHT / 2) - 2)) && ((lY - by) != (GRID_HEIGHT / 4)))
		{

			PIXELP(x + 1, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 3, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + 5, lY, 1, layer); 									// 10 er Dots Left Line
			PIXELP(x + (GRID_WIDTH / 2) - 6, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) - 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 2, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 4, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + (GRID_WIDTH / 2) + 6, lY, 1, layer); 						// 10 er Dots Middle Line
			PIXELP(x + GRID_WIDTH - 5, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 3, lY, 1, layer); 							// 10 er Dots Right Line
			PIXELP(x + GRID_WIDTH - 1, lY, 1, layer); 							// 10 er Dots Right Line

			//Draw horizontal line on every main Y-division
			for (lX = (x + 10); lX < (x + GRID_WIDTH); lX += 10)
			{
				PIXELP(lX, lY, 1, layer); 								// 50 er Dots
			}
		}		
	}
	
	PIXELP(x - 1, by - 1, 1, layer); 										// Left Top corner
	PIXELP(x + GRID_WIDTH + 1, by - 1, 1, layer); 									// Right Top corner
	PIXELP(x - 1, by + ((GRID_HEIGHT / 2) + 1), 1, layer); 								// Left Bottom corner
	PIXELP(x + GRID_WIDTH + 1, by + ((GRID_HEIGHT / 2) + 1), 1, layer); 						// Right Bottom corner
/*
	for (lX = x; lX < (x + GRID_WIDTH + 1); lX ++)
	{
		PIXELP(lX, by - 1, 1, layer);										// Top Line
		PIXELP(lX, by + 0, 1, layer);										// Middle Line
		PIXELP(lX, by + 1, 1, layer);										// Bottom Line
    	}
*/
}	//Grid delayed end
//##########################################################################################################################################################

// BF changed (complete grid changed, new subdivisions and new grid dimension 400 x 400)
void Display::GRIDXY(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;

	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	


	//---------------------------------------------------------------------------------------------
	// Horizontal (X) division from left to right - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for (lX = x; lX < (x + GRID_XY + 1); lX ++)
	{
		//draw top and bottom edge lines and middle line, 
		PIXELP(lX, y - 1, 1, layer);			// Top Line
		PIXELP(lX, y + GRID_XY + 1, 1, layer);		// Bottom Line
		//print every second point 
		if ((lX - x)%2 == 0) {
			PIXELP(lX, y + GRID_XY / 2, 1, layer);	// Middle Line
		}	
		
		
		//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
		if( ((lX - x)%10 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_XY - 5)) && ((lX - x) != (GRID_XY / 2)) && ((lX - x)%50 != 0) )
		{
			//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
			PIXELP(lX, y + 0, 1, layer);
			PIXELP(lX, y + 2, 1, layer);
			//Middle top 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_XY / 2) - 3, 1, layer);
			PIXELP(lX, y + (GRID_XY / 2) - 1, 1, layer);
			//Middle bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + (GRID_XY / 2) + 1, 1, layer);
			PIXELP(lX, y + (GRID_XY / 2) + 3, 1, layer);
			//Bottom 2 pixel line for 5 subdivisions
			PIXELP(lX, y + GRID_XY - 2, 1, layer);
			PIXELP(lX, y + GRID_XY, 1, layer);
		}	

		//Main division - 50 pixel for one divisin
		if (((lX - x)%50 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_XY - 5) && ((lX - x) != (GRID_XY / 2)))
		{
			//Top line division
			PIXELP(lX, y + 1, 1, layer);
			PIXELP(lX, y + 3, 1, layer);
			PIXELP(lX, y + 5, 1, layer);
			//Middle line top division
			PIXELP(lX, y + ((GRID_XY / 2) - 6), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) - 4), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) - 2), 1, layer);
			//Middle line bottom division
			PIXELP(lX, y + ((GRID_XY / 2) + 2), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) + 4), 1, layer);
			PIXELP(lX, y + ((GRID_XY / 2) + 6), 1, layer);
			//Bottom line division
			PIXELP(lX, y + (GRID_XY - 5), 1, layer);
			PIXELP(lX, y + (GRID_XY - 3), 1, layer);
			PIXELP(lX, y + (GRID_XY - 1), 1, layer);

			//Grid lines vertical - grid width modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
			for (lY = y + 10; lY < (y + GRID_XY - 5); lY += 10)	//dotted line
			{ PIXELP(lX, lY, 1, layer); }
			else
			for (lY = y; lY < (y + GRID_XY); lY ++)		//solid line
			{ PIXELP(lX, lY, 1, layer); }
		}	
		
	}
	
	//---------------------------------------------------------------------------------------------
	// Vertical (Y) division from top to bottom - 8 main divs and 5 sub divs
	//---------------------------------------------------------------------------------------------
	for(lY = y; lY < (y + GRID_XY + 1); lY++)
	{
		PIXELP(x - 1, lY, 1, layer);				// Left side line
		PIXELP(x + GRID_XY + 1, lY, 1, layer);			// Right side line	
		// one point every second pixel
		if ((lY - y)%2 == 0) 
		{
			PIXELP(x + (GRID_XY / 2), lY, 1, layer);	// Vertical middle line
		}	

		//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
		if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_XY - 5)) && ((lY - y) != (GRID_XY / 2)) && ((lY - y)%50 != 0) )
		{
			//Left side 2 pixel line for 5 subdivisions
			PIXELP(x + 0, lY, 1, layer);
			PIXELP(x + 2, lY, 1, layer);
			//Middle left side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_XY / 2) - 3, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 1, lY, 1, layer);
			//Middle right side 2 pixel line for 5 subdivisions
			PIXELP(x + (GRID_XY / 2) + 1, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 3, lY, 1, layer);
			//Right side 2 pixel line for 5 subdivisions
			PIXELP(x + GRID_XY - 2, lY, 1, layer);
			PIXELP(x + GRID_XY, lY, 1, layer);
		}		
		

		// Vertical main division 400 : 50 = 8 squares high
		if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_XY - 5)) && ((lY - y) != (GRID_XY / 2)))
		{
			// Left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + 1, lY, 1, layer);
			PIXELP(x + 3, lY, 1, layer);
			PIXELP(x + 5, lY, 1, layer);
			// Middle left side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_XY / 2) - 6, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 4, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) - 2, lY, 1, layer);
			// Middle right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + (GRID_XY / 2) + 2, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 4, lY, 1, layer);
			PIXELP(x + (GRID_XY / 2) + 6, lY, 1, layer);
			// Right side 3 pixel line for 8 divisions a 50 pixel
			PIXELP(x + GRID_XY - 5, lY, 1, layer);
			PIXELP(x + GRID_XY - 3, lY, 1, layer);
			PIXELP(x + GRID_XY - 1, lY, 1, layer);

			//Gridlines horizontal - grid height modulo 50 = 8 lines with one point every 10th pixel
			if (dotted_grid)
			for (lX = x + 10 ; lX < (x + GRID_XY - 5); lX += 10)	//dotted line
			{ PIXELP(lX, lY, 1, layer); }
			else
			for (lX = x; lX < (x + GRID_XY); lX ++)		//solid line
			{ PIXELP(lX, lY, 1, layer); }
		}		
	}

	//Corners
	PIXELP(x - 1, y - 1, 1, layer); 			// Left top corner
	PIXELP(x + GRID_XY + 1, y - 1, 1, layer); 		// Right top corner
	PIXELP(x - 1, y + GRID_XY + 1, 1, layer); 		// Left bottom corner
	PIXELP(x + GRID_XY + 1, y + GRID_XY + 1, 1, layer); 	// Right bottom corner
}
//##########################################################################################################################################################

// BF new grid for FFT function with dimension 512 x 400
void Display::GRIDFFT(unsigned long x, unsigned long y, unsigned long *layer) 		// Draw Grid subroutine
{
	unsigned long lX;
	unsigned long lY;
	
	// Clear Gridplane
	for(lX =  GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{ layer[lX] = 0; }	

	// grid for linear division
	if(FFT_Mode == FFT_MAGN || FFT_Mode == FFT_REAL || FFT_Mode == FFT_IMAG || FFT_Mode == FFT_REIM || FFT_Mode == FFT_PHAS)
	{
		//---------------------------------------------------------------------------------------------
		// Horizontal lines (X) division from left to right - 12 main divs and 5 sub divs
		//---------------------------------------------------------------------------------------------
		for (lX = x; lX < (x + GRID_WIDTH_FFT + 1); lX ++)
		{
			//draw top and bottom edge lines and middle line, 
			PIXELP(lX, y-1, 1, layer);				// Top Line
			PIXELP(lX, y + GRID_HEIGHT_FFT + 1, 1, layer);		// Bottom Line
			
			
			//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
			if( ((lX - x)%16 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_WIDTH_FFT - 5)) && ((lX - x) != (GRID_WIDTH_FFT / 2)) && ((lX - x)%64 != 0) )
			{
				//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
				PIXELP(lX, y + 0, 1, layer);
				PIXELP(lX, y + 2, 1, layer);
			}	
	
			//Main division - 64 pixel for one division
			if (((lX - x)%64 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_WIDTH_FFT - 5))
			{
				//Top line division
				PIXELP(lX, y + 1, 1, layer);
				PIXELP(lX, y + 3, 1, layer);
				PIXELP(lX, y + 5, 1, layer);
	
				//Grid lines vertical - grid width modulo 64 = 8 lines 
				if (dotted_grid)
					for (lY = y + 10; lY < (y + GRID_HEIGHT_FFT - 5); lY += 10)	//dotted line with one point every 10th Y-pixel
					{ PIXELP(lX, lY, 1, layer); }
				else
					for (lY = y; lY < (y + GRID_HEIGHT_FFT); lY ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); }
			}	
			
		}
		
		//---------------------------------------------------------------------------------------------
		// Vertical lines (Y) division from top to bottom - 8 main divs and 5 sub divs
		//---------------------------------------------------------------------------------------------
		for(lY = y; lY < (y + GRID_HEIGHT_FFT + 1); lY++)
		{
			PIXELP(x-1, lY, 1, layer);				// Left side line
			PIXELP(x + GRID_WIDTH_FFT + 1, lY, 1, layer);		// Right side line	
	
			//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
			if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5)) && ((lY - y) != (GRID_HEIGHT / 2)) && ((lY - y)%50 != 0) )
			{
				//Left side 2 pixel line for 5 subdivisions
				PIXELP(x + 0, lY, 1, layer);
				PIXELP(x + 2, lY, 1, layer);
	
				//Right side 2 pixel line for 5 subdivisions
				PIXELP(x + GRID_WIDTH_FFT - 2, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT, lY, 1, layer);
			}		
	
	
			// Vertical main division 400 : 50 = 8 squares high
			if (((lY - y)%50 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT_FFT - 5)) )
			{
				// Left side 3 pixel line for 8 divisions a 50 pixel
				PIXELP(x + 1, lY, 1, layer);
				PIXELP(x + 3, lY, 1, layer);
				PIXELP(x + 5, lY, 1, layer);
	
				// Right side 3 pixel line for 8 divisions a 50 pixel
				PIXELP(x + GRID_WIDTH_FFT - 5, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT - 3, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT - 1, lY, 1, layer);
	
				//Gridlines horizontal - grid height modulo 50 = 8 lines 
				if (dotted_grid)
					for (lX = x + 16 ; lX < (x + GRID_WIDTH_FFT - 5); lX += 16)	//dotted line with one point every 16th X-pixel
					{ PIXELP(lX, lY, 1, layer); }
				else
					for (lX = x; lX < (x + GRID_WIDTH_FFT); lX ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); } 
			}		
		}
	}
	else if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)	// grid for logarithmic division
	{
		//---------------------------------------------------------------------------------------------
		// Horizontal lines (X) division from left to right - 12 main divs and 5 sub divs
		//---------------------------------------------------------------------------------------------
		for (lX = x; lX < (x + GRID_WIDTH_FFT + 1); lX ++)
		{
			//draw top and bottom edge lines and middle line, 
			PIXELP(lX, y-1, 1, layer);				// Top Line
			PIXELP(lX, y + GRID_HEIGHT_FFT + 1, 1, layer);		// Bottom Line
			
			
			//draw subdivisions every 10th pixel - one square is 50 pixel wide and has 5 subdivisions
			if( ((lX - x)%16 == 0)&&((lX - x) > 5) && ((lX - x) < (GRID_WIDTH_FFT - 5)) && ((lX - x) != (GRID_WIDTH_FFT / 2)) && ((lX - x)%64 != 0) )
			{
				//Top 2 pixel line for 5 subdivisions (every 10th x-pixel)
				PIXELP(lX, y + 0, 1, layer);
				PIXELP(lX, y + 2, 1, layer);
			}	
	
			//Main division - 64 pixel for one division
			if (((lX - x)%64 == 0) && ((lX - x) > 5) && ((lX - x) < GRID_WIDTH_FFT - 5))
			{
				//Top line division
				PIXELP(lX, y + 1, 1, layer);
				PIXELP(lX, y + 3, 1, layer);
				PIXELP(lX, y + 5, 1, layer);
	
				//Grid lines vertical - grid width modulo 64 = 8 lines 
				if (dotted_grid)
					for (lY = y + 10; lY < (y + GRID_HEIGHT_FFT - 5); lY += 10)	//dotted line with one point every 10th Y-pixel
					{ PIXELP(lX, lY, 1, layer); }
				else
					for (lY = y; lY < (y + GRID_HEIGHT_FFT); lY ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); }
			}	
			
		}
		
		//---------------------------------------------------------------------------------------------
		// Vertical lines (Y) division from top to bottom - 8 main divs and 5 sub divs
		//---------------------------------------------------------------------------------------------
		for(lY = y; lY < (y + GRID_HEIGHT_FFT + 1); lY++)
		{
			PIXELP(x-1, lY, 1, layer);				// Left side line
			PIXELP(x + GRID_WIDTH_FFT + 1, lY, 1, layer);		// Right side line	
	
			//draw subdivisions every 10th pixel - one square is 50 pixel high and has 5 subdivisions
			//if ( ((lY - y)%10== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5) ) && ((lY - y) != (GRID_HEIGHT / 2)) && ((lY - y)%50 != 0) )
			if ( ((lY - y)%8== 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT - 5) ) && ((lY - y)%80 != 0) )
			{
				//Left side 2 pixel line for 10 subdivisions
				PIXELP(x + 0, lY, 1, layer);
				PIXELP(x + 2, lY, 1, layer);
	
				//Right side 2 pixel line for 10 subdivisions
				PIXELP(x + GRID_WIDTH_FFT - 2, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT, lY, 1, layer);
			}		
	
	
			// Vertical main division 400 : 80 = 8 squares high
			if (((lY - y)%80 == 0) && ((lY - y) > 5) && ((lY - y) < (GRID_HEIGHT_FFT - 5)) )
			{
				// Left side 3 pixel line for 8 divisions a 50 pixel
				PIXELP(x + 1, lY, 1, layer);
				PIXELP(x + 3, lY, 1, layer);
				PIXELP(x + 5, lY, 1, layer);
	
				// Right side 3 pixel line for 8 divisions a 50 pixel
				PIXELP(x + GRID_WIDTH_FFT - 5, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT - 3, lY, 1, layer);
				PIXELP(x + GRID_WIDTH_FFT - 1, lY, 1, layer);
	
				//Gridlines horizontal - grid height modulo 80 = 5 lines 
				if (dotted_grid)
					for (lX = x + 16 ; lX < (x + GRID_WIDTH_FFT - 5); lX += 16)	//dotted line with one point every 16th X-pixel
					{ PIXELP(lX, lY, 1, layer); }
				else
					for (lX = x; lX < (x + GRID_WIDTH_FFT); lX ++)			//solid line
					{ PIXELP(lX, lY, 1, layer); } 
			}		
		}
	}

	PIXELP(x - 1, y - 1, 1, layer); 					// Left top corner
	PIXELP(x + GRID_WIDTH_FFT + 1, y - 1, 1, layer); 			// Right top corner
	PIXELP(x - 1, y + GRID_HEIGHT_FFT + 1, 1, layer); 			// Left bottom corner
	PIXELP(x + GRID_WIDTH_FFT + 1, y + GRID_HEIGHT_FFT + 1, 1, layer); 	// Right bottom corner


	
}
//##########################################################################################################################################################
// BF changed 
void Display::StatusUpdate(void)
{
	//BF if ((Channel_1_Active == 0) && (Channel_1_Active_Old == 1) && (VoltageChangedCh1 == 1))
	if ((Channel_1_Active == 0)  && (VoltageChangedCh1 == 1))
	{
		DRAWP(6, 4, 6, 10, 0, Channel_Plane1);								// Clear Channel Text	
//		DRAWP(6, 4, 6, 10, 0, Buffer_Plane1);								// Clear Channel Text	
		DRAWP(3, 0, 68, 18, 0, UI_Plane2);								// Clear Text

		DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnRemove);						// Button
		
	}
	//BF else if ((Channel_1_Active == 1) && (Channel_1_Active_Old == 0) && (VoltageChangedCh1 == 1))
	else if ((Channel_1_Active == 1) && (VoltageChangedCh1 == 1))
	{
		DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);						// Button
		TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);							// Draw Voltage Text
//		TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);							// Draw Voltage Text
		
		//VoltageChangedCh1 = 1;

	}
	
	//BF if ((Channel_2_Active == 0) && (Channel_2_Active_Old == 1) && (VoltageChangedCh2 == 1))
	if ((Channel_2_Active == 0) && (VoltageChangedCh2 == 1))
	{
		DRAWP(82, 4, 6, 10, 0, Channel_Plane2);								// Clear Channel Text	
//		DRAWP(82, 4, 6, 10, 0, Buffer_Plane2);								// Clear Channel Text	
		DRAWP(79, 0, 68, 18, 0, UI_Plane2);								// Clear Text

		DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnRemove);						// Button
				

	}
	//BF else if ((Channel_2_Active == 1) && (Channel_2_Active_Old == 0) && (VoltageChangedCh2 == 1))
	else if ((Channel_2_Active == 1) && (VoltageChangedCh2 == 1))
	{
		DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);						// Button
		TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);							// Draw Voltage Text
//		TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);							// Draw Voltage Text
		
		//VoltageChangedCh2 = 1;
		
	}
	
	if (NumberOfChannels > 2)
	{
		//BF if ((Channel_3_Active == 0) && (Channel_3_Active_Old == 1) && (VoltageChangedCh3 == 1))
		if ((Channel_3_Active == 0) && (VoltageChangedCh3 == 1))
		{
			DRAWP(158, 4, 6, 10, 0, Channel_Plane3);							// Clear Channel Text	
	//		DRAWP(158, 4, 6, 10, 0, Buffer_Plane3);								// Clear Channel Text	
			DRAWP(155, 0, 68, 18, 0, UI_Plane2);								// Clear Text
	
			DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnRemove);						// Button
			
		}
		//BF else if ((Channel_3_Active == 1) && (Channel_3_Active_Old == 0) && (VoltageChangedCh3 == 1))
		else if ((Channel_3_Active == 1) && (VoltageChangedCh3 == 1))
		{
			DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);						// Button
			TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);							// Draw Voltage Text		
			//TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);							// Draw Voltage Text		
			
			//VoltageChangedCh3 = 1;
			
			//DRAWZERO(3, 0);										// Draw Zero Marker	
		}
		
		//BF if ((Channel_4_Active == 0) && (Channel_4_Active_Old == 1) && (VoltageChangedCh4 == 1))
		if ((Channel_4_Active == 0) && (VoltageChangedCh4 == 1))
		{
			DRAWP(234, 4, 6, 10, 0, Channel_Plane4);							// Clear Channel Text	
			//BF DRAWP(234, 4, 6, 10, 0, Buffer_Plane4);							// Clear Channel Text	
			DRAWP(231, 0, 68, 18, 0, UI_Plane2);								// Clear Text
	
			DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnRemove);						// Button
			
			//REMOVEZERO(4);										// Remove Zero Marker		
		}
		//BF else if ((Channel_4_Active == 1) && (Channel_4_Active_Old == 0) && (VoltageChangedCh4 == 1))
		else if ((Channel_4_Active == 1) && (VoltageChangedCh4 == 1))
		{
			DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);						// Button		
			TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);							// Draw Voltage Text		
			//TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);							// Draw Voltage Text		
			
			//VoltageChangedCh4 = 1;
			
			//DRAWZERO(4, 0);	
		}
    	}			
	
	// Update Statusbar
	if ((Channel_1_Active == 1) && (VoltageChangedCh1 == 1)) DRAWSTATUS(1, 0);					// Draw Voltage Channel 1
	if ((Channel_2_Active == 1) && (VoltageChangedCh2 == 1)) DRAWSTATUS(2, 0);					// Draw Voltage Channel 2
	if (NumberOfChannels > 2)
	{
		if ((Channel_3_Active == 1) && (VoltageChangedCh3 == 1)) DRAWSTATUS(3, 0);				// Draw Voltage Channel 3
		if ((Channel_4_Active == 1) && (VoltageChangedCh4 == 1)) DRAWSTATUS(4, 0);				// Draw Voltage Channel 4		
	}
	
	if (TimebaseChanged == 1) DRAWSTATUS(0, 0);									// Draw Timebase
	if (TimeOffsetChanged == 1) DRAWSTATUS(5, 0);									// Draw Timebase Offset
	if (TriggerLevelChanged == 1) DRAWSTATUS(6, 0);									// Draw Trigger Level
	if (TriggerModeChanged == 1) DRAWSTATUS(7, 0);									// Draw Auto	
	if (TriggerWayChanged == 1) DRAWSTATUS(8, 0);									// Draw Trigger way	

/*	
	if (Selected_Trigger_Source != Selected_Trigger_Source_Old)
	{
		DRAWZEROS();		
	}	
*/	
	MenuTimeCounter = 0;	
}
//##########################################################################################################################################################

void Display::DRAWSTATUS(int Which, int isChanging)
{
	unsigned char xe = 0;
	unsigned char xf = 0;	
	unsigned short Buffer = 0;
	char BufferText[17];
	char BufferText2[17];
#ifdef _Debug_	
    printf("DS %d iC %d\n", Which, isChanging);
#endif			
	switch(Which)
	{
		// Timebase
		case 0:
		{
			if (MenuStatus[10][1] == 1) // Delayed Mode
			{
				// If One statusbutton aktive and not the timebase -> remove it
				if ((isChanging == 1) && (StatusbarChanged > 0))
				{
						if (StatusbarChanged != 11) Display::RemoveStatusBtn();
						Hardware::ResetTimer();							// Reset the Timer
				}	
								
				if ((isChanging == 1) && (StatusbarChanged == 0))
				{
				DRAWROUNDBUTTON(326, 0, 64, 20, btnUnpushed, btnDraw);					// Draw Button	
						//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
						StatusbarChanged = 11;
				}
		
				DRAWP(333, 0, 132, 18, 0, UI_Plane2);								// Clear First            (406, 0
		
				sprintf(BufferText, "");
				for (xe = 0; xe < 10; xe++)
				{
						BufferText[xe] = TimebaseData_Matrix[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx][xe];	
				}
				TEXTOUTxvbig(BufferText, 335 + TimebaseDataDef[dmode_Selected_Timebase], 2, 1, UI_Plane2);	// Draw Menu Text
					
				sprintf(BufferText, "");
				for (xe = 0; xe < 10; xe++)
				{
					BufferText[xe] = TimebaseData_Matrix[Selected_Timebase][SIGNALFaktor_idx][xe];	
				}
				TEXTOUTxvbig(BufferText, 413 + TimebaseDataDef[Selected_Timebase], 2, 1, UI_Plane2);		// Draw Menu Text
			}  /*
			else if (MenuStatus[10][2] == 1) // Roll Mode
			{
				// If One statusbutton aktive and not the timebase -> remove it
				if ((isChanging == 1) && (StatusbarChanged > 0))
				{
						if (StatusbarChanged != 10) Display::RemoveStatusBtn();
						Hardware::ResetTimer();							// Reset the Timer
				}	
								
				if ((isChanging == 1) && (StatusbarChanged == 0))
				{
				DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnDraw);								// Draw Button	
			//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
						StatusbarChanged = 10;
				}
		
				DRAWP(333, 0, 132, 18, 0, UI_Plane2);								// Clear First            (406, 0
			*/  /*
				sprintf(BufferText, "");
				for (xe = 0; xe < 10; xe++)
				{
						BufferText[xe] = SampleRateData[Selected_Timebase][xe];	// Offset to Text in MenuBlock 0x00200000
				}
				TEXTOUTxvbig(BufferText, 335 + SampleRateDataDef[Selected_Timebase], 2, 1, UI_Plane2);					// Draw Menu Text
					*/  /*
				sprintf(BufferText, "");
				for (xe = 0; xe < 10; xe++)
				{
				BufferText[xe] = TimebaseData[25 + ROLLMODE_TB][xe];	// Offset to Text in MenuBlock 0x00200000
				}
				TEXTOUTxvbig(BufferText, 413 + TimebaseDataDef[25 + ROLLMODE_TB], 2, 1, UI_Plane2);					// Draw Menu Text
			}	*/			
			else // Main Mode
			{
				// If One statusbutton aktive and not the timebase -> remove it
				if ((isChanging == 1) && (StatusbarChanged > 0))
				{
						if (StatusbarChanged != 10) Display::RemoveStatusBtn();
						Hardware::ResetTimer();										// Reset the Timer
				}	
								
				if ((isChanging == 1) && (StatusbarChanged == 0))
				{
				DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnDraw);						// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
						StatusbarChanged = 10;
				}
		
				DRAWP(333, 0, 132, 18, 0, UI_Plane2);								// Clear First            (406, 0
		
				sprintf(BufferText, "");
				for (xe = 0; xe < 11; xe++)
				{
					BufferText[xe] = SampleRateData[Selected_Timebase][xe];	// Offset to Text in MenuBlock 0x00200000
				}
				TEXTOUTxvbig(BufferText, 335 + SampleRateDataDef[Selected_Timebase], 2, 1, UI_Plane2);					// Draw Menu Text
					
				sprintf(BufferText, "");
				for (xe = 0; xe < 10; xe++)
				{
				BufferText[xe] = TimebaseData_Matrix[Selected_Timebase][SIGNALFaktor_idx][xe];	// Offset to Text in MenuBlock 0x00200000
				}
				TEXTOUTxvbig(BufferText, 413 + TimebaseDataDef[Selected_Timebase], 2, 1, UI_Plane2);					// Draw Menu Text
			}
								
			
            		TimebaseChanged = 0;
			
			break;
		}
			
		// Voltage CH 1	
		case 1:
		{	
			CALCVOLTAGE(1, &BufferText[0]);											// Calculate Text

			if ((isChanging == 1) && (StatusbarChanged > 0))
			{
				if (StatusbarChanged != 1) Display::RemoveStatusBtn();
				Hardware::ResetTimer();												// Reset the Timer
			}
					
			if ((isChanging == 1) && (StatusbarChanged == 0))
			{
				DRAWROUNDBUTTON(15, 0, 64, 20, btnUnpushed, btnDraw);						// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
				StatusbarChanged = 1;
			}

			DRAWP(16, 0, 62, 18, 0, UI_Plane2);						// Clear First
								
			TEXTOUTxvbig(BufferText, 24, 2, 1, UI_Plane2);					// Draw Voltage Text
			
			VoltageChangedCh1 = 0;
			
			break;
		}
		
		// Voltage CH 2	
		case 2:
		{
			CALCVOLTAGE(2, &BufferText[0]);							// Calculate Text
			
			if ((isChanging == 1) && (StatusbarChanged > 0))
			{
				if (StatusbarChanged != 2) Display::RemoveStatusBtn();
				Hardware::ResetTimer();							// Reset the Timer
			}
			
			if ((isChanging == 1) && (StatusbarChanged == 0))
			{
				DRAWROUNDBUTTON(91, 0, 64, 20, btnUnpushed, btnDraw);			// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
				StatusbarChanged = 2;
			}	
	
			DRAWP(92, 0, 61, 18, 0, UI_Plane2);											// Clear First
			
			TEXTOUTxvbig(BufferText, 100, 2, 1, UI_Plane2);					// Draw Voltage Text

			VoltageChangedCh2 = 0;
			
			break;
		}

		// Voltage CH 3	
		case 3:
		{
			CALCVOLTAGE(3, &BufferText[0]);											// Calculate Text

			if ((isChanging == 1) && (StatusbarChanged > 0))
			{
				if (StatusbarChanged != 3) Display::RemoveStatusBtn();
				Hardware::ResetTimer();												// Reset the Timer
			}	
			
			if ((isChanging == 1) && (StatusbarChanged == 0))
			{
				DRAWROUNDBUTTON(167, 0, 64, 20, btnUnpushed, btnDraw);			// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
				StatusbarChanged = 3;
			}	

			DRAWP(174, 0, 55, 18, 0, UI_Plane2);								// Clear First
		
			TEXTOUTxvbig(BufferText, 176, 2, 1, UI_Plane2);					// Draw Voltage Text

			VoltageChangedCh3 = 0;
			
			break;
		}
		
		// Voltage CH 4
		case 4:
		{
			CALCVOLTAGE(4, &BufferText[0]);											// Calculate Text

			if ((isChanging == 1) && (StatusbarChanged > 0))
			{
				if (StatusbarChanged != 4) Display::RemoveStatusBtn();
				Hardware::ResetTimer();										// Reset the Timer
			}	
			
			if ((isChanging == 1) && (StatusbarChanged == 0))
			{
				DRAWROUNDBUTTON(243, 0, 64, 20, btnUnpushed, btnDraw);						// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
				StatusbarChanged = 4;
			}

			DRAWP(244, 0, 65, 18, 0, UI_Plane2);									// Clear First

			TEXTOUTxvbig(BufferText, 252, 2, 1, UI_Plane2);								// Draw Voltage Text

			VoltageChangedCh4 = 0;
			
			break;
		}	
		
		// Timebase Offset  // Muß noch upgedated werden
		case 5:
		{

			
	//		if (isChanging == 1) DRAWROUNDBUTTON(330, 0, 76, 20, btnUnpushed, btnDraw);			// Button
	//		else
//			DRAWP(338, 0, 62, 18, 0, UI_Plane2);									// Clear First
			
            		Display::DRAW_ALL_CURSOR();			
            			
			TimeOffsetChanged = 0;

    			
			break;
		}		
		
		// Trigger Level
		case 6:
		{		
			DRAWP(560, 0, 79, 18, 0, UI_Plane2);									// Clear First
            		
			//if (triggering == 0) return;
			if (MenuStatus[14][3] == 1) return;       // Ext Trig TV Ch1
			if (MenuPopupStatus[8][2] == 3) return;   // Ext Trig Line

			CALCTRIGGER();												// Calculate Text
            /*
			if (((isChanging == 1) && (StatusbarChanged > 0)) || (MenuStatus[10][2] == 1))
			{
				if (StatusbarChanged != 6) Display::RemoveStatusBtn();
				Hardware::ResetTimer();										// Reset the Timer
			}	
          	*/		
			//if ((isChanging == 1) && (StatusbarChanged == 0) && (MenuStatus[10][2] == 0))
			if ((isChanging == 1) && (StatusbarChanged == 0))
			{
				DRAWROUNDBUTTON(558, 0, 82, 20, btnUnpushed, btnDraw);						// Draw Button	
				//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
				StatusbarChanged = 6;
			}		
				
			//if (MenuStatus[10][2] == 0)
			{
				if (MenuStatus[14][2] == 1) TEXTOUTxvbig(Trigger_ExtLevel_Str.Read_Text(), 567, 2, 1, UI_Plane2);	// Draw Voltage Text
				else TEXTOUTxvbig(Trigger_Level_Str.Read_Text(), 567, 2, 1, UI_Plane2);					// Draw Voltage Text
			}
					
		
			TriggerLevelChanged = 0;
			
			break;
		}	
		
		// Trigger Auto
		case 7:
		{
			if (Continius)
			{	
				BITBITMAP(bitbmStopTrigger, 464, 0, 1, UI_Plane3);           // Muß eventuell ins Flash
				BITBITMAP(bitbmStopTrigger_stop, 464, 6, 0, UI_Plane1);           // Muß eventuell ins Flash
				//DRAWP(464, 0, 50, 18, 1, UI_Plane3);								// Clear First
				DRAWP(464, 0, 50, 18, 0, UI_Plane2);								// Clear First
				DRAWP(464, 0, 50, 18, 0, Channel_Plane4);								// Clear First
				DRAWP(464, 0, 50, 18, 0, Buffer_Plane4);								// Clear First
					
				//if (MenuStatus[10][2] == 1) sprintf(BufferText, "Free");
				//else
				if (MenuStatus[12][0] == 93) sprintf(BufferText, "Auto");
				else sprintf(BufferText, "Norm");
					
							
				TEXTOUTxvbig(BufferText, 471, 2, 1, UI_Plane2);					// Draw Voltage Text		
			}
			else
			{
				DRAWP(464, 0, 50, 18, 0, UI_Plane2);								// Clear First
				//DRAWP(464, 0, 50, 18, 0, UI_Plane3);								// Clear First
				//DRAWP(464, 0, 50, 18, 0, UI_Plane4);								// Clear First
				BITBITMAP(bitbmStopTrigger, 464, 0, 0, UI_Plane3);              // Muß eventuell ins Flashen vom Flash beim starten
				BITBITMAP(bitbmStopTrigger, 464, 0, 1, Channel_Plane4);           // Muß eventuell ins Flashen vom Flash beim starten
				BITBITMAP(bitbmStopTrigger, 464, 0, 1, Buffer_Plane4);           // Muß eventuell ins Flashen vom Flash beim starten
				BITBITMAP(bitbmStopTrigger_stop, 464, 6, 1, UI_Plane1);           // Muß eventuell ins Flashen vom Flash beim starten
		
		
			}
			
			TriggerModeChanged = 0;
			
			break;
		}
		
		// Trigger Way
		case 8:
		{
			DRAWP(517, 0, 40, 18, 0, UI_Plane2);									// Clear First
#ifdef _Debug_			
			printf("TW %d MS[14][1] %d MS[14][2] %d MS[14][3] %d STS %d SEE %d\n", TriggerWay, MenuStatus[14][1], MenuStatus[14][2], MenuStatus[14][3], Selected_Trigger_Source, SelectedEdgeExtern);
#endif
			switch(TriggerWay)
			{
				case 1:	
				{
					if (MenuStatus[14][1] == 138)
					{
						xe = '1';
						xf = ' ';
						Selected_Trigger_Source = 1;
					}					
					else if (MenuStatus[14][1] == 139)
					{
						xe = '2';
						xf = ' ';
						Selected_Trigger_Source = 2;
					}
					else if (MenuStatus[14][1] == 140)
					{
						xe = '3';
						xf = ' ';
						Selected_Trigger_Source = 3;
					}
                    			else if (MenuStatus[14][1] == 141)
					{
						xe = '4';
						xf = ' ';
						Selected_Trigger_Source = 4;
					}
					
                    			if ((MenuStatus[14][2] == 1) && (SelectedEdgeExtern == 0) && (MenuPopupStatus[8][0] == 3))
					{
						xe = 'X';
						xf = 'L';
						Selected_Trigger_Source = 5;
					}
					
                    			if ((MenuStatus[14][2] == 1) && (SelectedEdgeExtern == 0) && (MenuPopupStatus[8][1] == 3))
					{
						xe = 'X';
						xf = 'H';
						Selected_Trigger_Source = 5;
					}					
					
                    			if ((MenuStatus[14][2] == 1) && (SelectedEdgeExtern == 1) && (MenuPopupStatus[8][2] == 3))
					{
						xe = 'L';
						xf = ' ';
						Selected_Trigger_Source = 6;
					}
					
                    			if ((MenuStatus[14][3] == 1) && (SelectedEdgeExtern == 2))
					{
						xe = 'T';
						xf = 'V';
						Selected_Trigger_Source = 6;
					}

					// if channel who triggers is inverted
					if (MenuStatus[(MenuStatus[14][1] - 137)][2] == 241)
					{					
						switch(MenuStatus[14][0])
						{
							case 2:	sprintf(BufferText, "~ %c%c", xe, xf); break;
							case 3:	sprintf(BufferText, "} %c%c", xe, xf); break;			
						}	
					}
					else
					{					
						switch(MenuStatus[14][0])
						{
							case 2:	sprintf(BufferText, "} %c%c", xe, xf); break;
							case 3:	sprintf(BufferText, "~ %c%c", xe, xf); break;			
						}	
					}
                    
					break;	
                    		
				}
							
				case 2:
				{				
					switch(MenuStatus[15][0])
					{
						case 138 : xe = '1'; Selected_Trigger_Source = 1; break;
						case 139 : xe = '2'; Selected_Trigger_Source = 2; break;
						case 140 : xe = '3'; Selected_Trigger_Source = 3; break;
						case 141 : xe = '4'; Selected_Trigger_Source = 4; break;
						case 142 : xe = 'X'; Selected_Trigger_Source = 5; break;
					}
					/*				
					switch(MenuStatus[15][1])
					{
						case 2:	sprintf(BufferText, "%c %c", 138, xe); break;
						case 3:	sprintf(BufferText, "%c %c", 139, xe); break;			
					}	
                    */					
					sprintf(BufferText, "%c %c", 138, xe);
					
					break;
				}
				
				case 3:  // Kann raus
				{				
					switch(MenuStatus[23][0])
					{
						case 138 : xe = '1'; Selected_Trigger_Source = 1; break;
						case 139 : xe = '2'; Selected_Trigger_Source = 2; break;
						case 140 : xe = '3'; Selected_Trigger_Source = 3; break;
						case 141 : xe = '4'; Selected_Trigger_Source = 4; break;
						case 142 : xe = 'X'; Selected_Trigger_Source = 5; break;
					}
									
					sprintf(BufferText, "Pat %c", xe);
						
					break;
				}						
			}
			
			
			//if (MenuStatus[10][2] == 0)
			{            	
                		TEXTOUTxvbig(BufferText, 520, 2, 1, UI_Plane2);					// Draw Triggerway Text
            		}			
			TriggerWayChanged = 0;
			
			break;
		}				
	}
}		
//##########################################################################################################################################################

void Display::RemoveStatusBtn(void)
{
	switch(StatusbarChanged)
	{
		case 1:
		{
			DRAWROUNDBUTTON(15, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 2:
		{
			DRAWROUNDBUTTON(91, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 3:
		{
			DRAWROUNDBUTTON(167, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 4:
		{
			DRAWROUNDBUTTON(243, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}	

		case 6:
		{
			DRAWROUNDBUTTON(558, 0, 82, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}			
		case 10: // Timebase
		{
			DRAWROUNDBUTTON(404, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}
		case 11: // Timebase Delayed
		{
			DRAWROUNDBUTTON(326, 0, 64, 20, btnUnpushed, btnRemove);						// Remove Button
			break;
		}							
		
	}

	StatusbarChanged = 0;	
}
//##########################################################################################################################################################
// BF drawing menu buttons on the screen
void Display::UpdateMenu(void)
{
    	int cnt;
	char BufferText[20];
	//char MenuAktMem;

	char Btns_to_remove[6] = {0, 0, 0, 0, 0, 0};           //remove the button + text
	char Btns_to_remove_text[6] = {0, 0, 0, 0, 0, 0};      //remove the text
	char Btns_to_draw[6] = {0, 0, 0, 0, 0, 0};             //draw button
	char Btns_to_redraw[6] = {0, 0, 0, 0, 0, 0};           //draw text


#ifdef _Debug_
    printf("UpdateMenu\n");
#endif
	//printf("\rWe are here and NewMenu is %d Active_Menu is %d MenuAktive is %d\r\n", New_Menu, Active_Menu, MenuAktive);

	if (Splash_removed)
	{
		for (cnt = 0; cnt < 6; cnt++)
		{
			if (MenuItemDef[New_Menu][cnt] != 0)
			{ Btns_to_draw[cnt] = 1; Btns_to_redraw[cnt] = 1; MenuItemPushed[cnt] = 0; MenuItemPushed_old[cnt] = 0;}
		}
		Splash_removed = false;
	}
	// Check if Menu changed
	else if (New_Menu != Active_Menu)
	{
		MenuAktive = 1;
	
		//BF del if (((New_Menu == 17) && (USB_Connected == false))) MenuAktive = 0; // Grayed menus

		for (cnt = 0; cnt < 6; cnt++)
		{
			if (MenuItemDef[Active_Menu][cnt] != 0)
			{
				if (MenuItemDef[New_Menu][cnt] == 0)
				{	Btns_to_remove[cnt] = 1; }
				else
				{
					Btns_to_draw[cnt] = 1;
					Btns_to_remove_text[cnt] = 1;
					Btns_to_redraw[cnt] = 1;
				}
			}
			else
			{
				if (MenuItemDef[New_Menu][cnt] != 0)
				{ Btns_to_draw[cnt] = 1; Btns_to_redraw[cnt] = 1; }
			}
		}		
	}
	else	//BF New Menu = Active Menu
	{
		//BF del if (((New_Menu ==  MENU_QUICKPRINT) && (USB_Connected == false))) MenuAktive = 0; // Grayed menus

		for (cnt = 0; cnt < 6; cnt++)
		{
			//if (((MenuAktive != MenuAktive_old) || (MenuItemChanged[cnt] == 1)) && (MenuItemDef[New_Menu][cnt] != 0))
			if (MenuItemDef[Active_Menu][cnt] != 0)
			{
				//BF if ((MenuItemPushed[cnt]) || (MenuItemPushed_old[cnt]))
				//if (MenuItemPushed[cnt])
				//{
				        //Btns_to_remove[cnt] = 1;
					Btns_to_redraw[cnt] = 1;
					Btns_to_remove_text[cnt] = 1;
					Btns_to_draw[cnt]   = 1;
					//MenuItemPushed_old[cnt] = 0;
					//printf("\rButton pushed %d\r\n", cnt);
			/*	}
				else
				{
					
					Btns_to_redraw[cnt] = 1;
					Btns_to_draw[cnt]   = 1;
					Btns_to_remove_text[cnt] = 1;
					//printf("\rButton redraw %d\r\n", cnt);
				}
			*/	//Btns_to_draw[cnt]   = 1;
				//Btns_to_redraw[cnt] = 1;
			}
		}
	}

	for (cnt = 0; cnt < 6; cnt++)
    	{
        	if (Btns_to_remove[cnt] == 1)      Display::ClearMenuItemAsm(cnt, 34560, 44);
        	if (Btns_to_draw[cnt] == 1)        Display::DrawMenuItemButton(cnt, 1, MenuItemPushed[cnt]);
          	if (Btns_to_remove_text[cnt] == 1) Display::ClearMenuItemTextAsm(cnt, 35040, 32);
		if (Btns_to_redraw[cnt] == 1)      Display::DrawMenuItem(New_Menu, cnt, MenuAktive, 0);
 	} 
	
	if (Cursor_Enabled) DRAWCURSORDATA(0);
	//if (QM_Enabled) CALCQMDATA();
	
	MenuAktive_old      = MenuAktive;
	Active_Menu         = New_Menu;
	Menu_Changed        = 0;
	UpdateMenuTextPlane = true;
	VSync_Needed        = 1;	
}
//##########################################################################################################################################################

void Display::ClearMenuAsm(long start, long count)
{
    asm(" 	
	         PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	         MOVI	%r3,%lo(0x0095FA00)
	         PFX	%xhi(0x0095FA00)
	         MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
             PFX	%hi(0x00969000)                   ; Set UI2 Address
             MOVI	%r4,%lo(0x00969000)
             PFX	%xhi(0x00969000)
             MOVHI	%r4,%xlo(0x00969000)*/
	
/*	
             PFX	%hi(0x009F5A00)                   ; Set UI2 Address
             MOVI	%r4,%lo(0x009F5A00)
             PFX	%xhi(0x009F5A00)
             MOVHI	%r4,%xlo(0x009F5A00)
*/
             PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
             MOVI	%r4,%lo(0x008D3BF4)
             PFX	%xhi(0x008D3BF4)
             MOVHI	%r4,%xlo(0x008D3BF4)

             PFX	%hi(0x00972600)                   ; Set UI3 Address
             MOVI	%r5,%lo(0x00972600)
             PFX	%xhi(0x00972600)
             MOVHI	%r5,%xlo(0x00972600)	
	
             PFX	%hi(0x0097BC00)                   ; Set UI4 Address
             MOVI	%r6,%lo(0x0097BC00)
             PFX	%xhi(0x0097BC00)
             MOVHI	%r6,%xlo(0x0097BC00)                     	

             PFX	%hi(0x00985200)                   ; Set UI5 Address
             MOVI	%r7,%lo(0x00985200)
             PFX	%xhi(0x00985200)
             MOVHI	%r7,%xlo(0x00985200)	
	
             PFX	%hi(0x009AAA00)                   ; Set CH4 Address
             MOVI	%r8,%lo(0x009AAA00)
             PFX	%xhi(0x009AAA00)
             MOVHI	%r8,%xlo(0x009AAA00)

             ADD    %r3, %i0                          ; Add Address Counter
             ADD    %r4, %i0
             ADD    %r5, %i0
             ADD    %r6, %i0
             ADD    %r7, %i0
             ADD    %r8, %i0

             MOV    %r1, %i1	

             PFX	%hi(0)                            ; Set Clear register
             MOVI	%r2,%lo(0)
             PFX	%xhi(0)
             MOVHI	%r2,%xlo(0)	

             PFX	%hi(0xFFFFFFFF)                            ; Set Clear register
             MOVI	%r9,%lo(0xFFFFFFFF)
             PFX	%xhi(0xFFFFFFFF)
             MOVHI	%r9,%xlo(0xFFFFFFFF)	
	
             loopCM:
             ST     [%r3], %r2                        ; Clear Buffer
             ST     [%r4], %r2                        ; Clear Buffer
             ST     [%r5], %r9                        ; Clear Buffer
             ST     [%r6], %r2                        ; Clear Buffer
             ST     [%r7], %r2                        ; Clear Buffer
             ST     [%r8], %r2                        ; Clear Buffer
                                          	
             ADDI   %r3, 4                            ; Add Address Counter
             ADDI   %r4, 4
             ADDI   %r5, 4
             ADDI   %r6, 4
             ADDI   %r7, 4
             ADDI   %r8, 4	

             SUBI   %r1, 1                            ; Decrement Line Counter
             SKPS   cc_z
             BR     loopCM
             NOP 	
        ");

   // UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::ClearMenuItemAsm(long which, long start, long count)
{
    switch(which)
    {
        case 0 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0x0001FFFF)                   ; Set MASK
                     MOVI	%r10,%lo(0x0001FFFF)
                     PFX	%xhi(0x0001FFFF)
                     MOVHI	%r10,%xlo(0x0001FFFF)

                     PFX	%hi(0xFFFE0000)                   ; Set MASK
                     MOVI	%r11,%lo(0xFFFE0000)
                     PFX	%xhi(0xFFFE0000)
                     MOVHI	%r11,%xlo(0xFFFE0000)   	


                     loopCMI0:

                     ;// UI 1
                     MOV    %L0, %r3

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     ST     [%L0], %r9                        ; Clear Buffer
                     STP    [%L0, 1], %r9                     ; Clear Buffer
                     STP    [%L0, 2], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 4
                     MOV    %L0, %r6

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI0
                     NOP 	
                ");
            break;
        }

        case 1 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
	
/*
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)

                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFF0000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFF0000)
                     PFX	%xhi(0xFFFF0000)
                     MOVHI	%r10,%xlo(0xFFFF0000)

                     PFX	%hi(0x0000FFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x0000FFFF)
                     PFX	%xhi(0x0000FFFF)
                     MOVHI	%r11,%xlo(0x0000FFFF)             	

                     PFX	%hi(0x000003FF)                   ; Set MASK
                     MOVI	%r12,%lo(0x000003FF)
                     PFX	%xhi(0x000003FF)
                     MOVHI	%r12,%xlo(0x000003FF)

                     PFX	%hi(0xFFFFFC00)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFFFC00)
                     PFX	%xhi(0xFFFFFC00)
                     MOVHI	%r13,%xlo(0xFFFFFC00)             	
	
                     loopCMI1:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r9                     ; Clear Buffer
                     STP    [%L0, 5], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI1
                     NOP 	
                 ");
            break;
        }

        case 2 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFFF80)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFFF80)
                     PFX	%xhi(0xFFFFFF80)
                     MOVHI	%r10,%xlo(0xFFFFFF80)

                     PFX	%hi(0x0000007F)                   ; Set MASK
                     MOVI	%r11,%lo(0x0000007F)
                     PFX	%xhi(0x0000007F)
                     MOVHI	%r11,%xlo(0x0000007F)             	

                     loopCMI2:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer


                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     STP    [%L0, 7], %r9                     ; Clear Buffer
                     STP    [%L0, 8], %r9                     ; Clear Buffer
                     STP    [%L0, 9], %r9                     ; Clear Buffer

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer
                     STP    [%L0, 9], %r2                     ; Clear Buffer
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI2
                     NOP 	
                 ");
            break;
        }

        case 3 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0x00FFFFFF)                   ; Set MASK
                     MOVI	%r10,%lo(0x00FFFFFF)
                     PFX	%xhi(0x00FFFFFF)
                     MOVHI	%r10,%xlo(0x00FFFFFF)

                     PFX	%hi(0xFF000000)                   ; Set MASK
                     MOVI	%r11,%lo(0xFF000000)
                     PFX	%xhi(0xFF000000)
                     MOVHI	%r11,%xlo(0xFF000000)             	
	
                     loopCMI3:

                     ;// UI 1
                     MOV    %L0, %r3

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     STP    [%L0, 10], %r9                      ; Clear Buffer
                     STP    [%L0, 11], %r9                     ; Clear Buffer
                     STP    [%L0, 12], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 4
                     MOV    %L0, %r6

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     STP    [%L0, 10], %r2                      ; Clear Buffer
                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI3
                     NOP 	
                ");
            break;
        }

        case 4 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFE00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFE00000)
                     PFX	%xhi(0xFFE00000)
                     MOVHI	%r10,%xlo(0xFFE00000)

                     PFX	%hi(0x001FFFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x001FFFFF)
                     PFX	%xhi(0x001FFFFF)
                     MOVHI	%r11,%xlo(0x001FFFFF)             	

                     PFX	%hi(0x00007FFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x00007FFF)
                     PFX	%xhi(0x00007FFF)
                     MOVHI	%r12,%xlo(0x00007FFF)

                     PFX	%hi(0xFFFF8000)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFF8000)
                     PFX	%xhi(0xFFFF8000)
                     MOVHI	%r13,%xlo(0xFFFF8000)             	
	
                     loopCMI4:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r9                    ; Clear Buffer
                     STP    [%L0, 15], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI4
                     NOP 	
                 ");

            break;
        }

        case 5 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFF000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFF000)
                     PFX	%xhi(0xFFFFF000)
                     MOVHI	%r10,%xlo(0xFFFFF000)

                     PFX	%hi(0x00000FFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x00000FFF)
                     PFX	%xhi(0x00000FFF)
                     MOVHI	%r11,%xlo(0x00000FFF)             	

                     loopCMI5:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer


                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     STP    [%L0, 17], %r9                    ; Clear Buffer
                     STP    [%L0, 18], %r9                    ; Clear Buffer
                     STP    [%L0, 19], %r9                    ; Clear Buffer

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
                     STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer
                     STP    [%L0, 19], %r2                    ; Clear Buffer
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMI5
                     NOP 	
                 ");
            break;
        }
    }
    //UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::ClearMenuItemTextAsm(long which, long start, long count)
{
    switch(which)
    {
        case 0 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFC00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFC00000)
                     PFX	%xhi(0xFFC00000)
                     MOVHI	%r10,%xlo(0xFFC00000)

                     PFX	%hi(0x003FFFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x003FFFFF)
                     PFX	%xhi(0x003FFFFF)
                     MOVHI	%r11,%xlo(0x003FFFFF)

                     PFX	%hi(0x003FFFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x003FFFFF)
                     PFX	%xhi(0x003FFFFF)
                     MOVHI	%r12,%xlo(0x003FFFFF)

                     PFX	%hi(0xFFC00000)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFC00000)
                     PFX	%xhi(0xFFC00000)
                     MOVHI	%r13,%xlo(0xFFC00000)                                	
	
                     loopCMIT0:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 0], %r0                     ; Store it back


                     STP    [%L0, 1], %r9                     ; Clear Buffer
                     STP    [%L0, 2], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
 	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 4
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r9                     ; Clear Buffer
                     STP    [%L0, 2], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
                     STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 0]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 0], %r0                     ; Store it back

                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     ST     [%L0], %r2                        ; Clear Buffer
                     STP    [%L0, 1], %r2                     ; Clear Buffer
                     STP    [%L0, 2], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT0
                     NOP 	
                ");
            break;
        }

        case 1 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFE000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFE000)
                     PFX	%xhi(0xFFFFE000)
                     MOVHI	%r10,%xlo(0xFFFFE000)

                     PFX	%hi(0x00001FFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x00001FFF)
                     PFX	%xhi(0x00001FFF)
                     MOVHI	%r11,%xlo(0x00001FFF)             	

                     PFX	%hi(0x00001FFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x00001FFF)
                     PFX	%xhi(0x00001FFF)
                     MOVHI	%r12,%xlo(0x00001FFF)

                     PFX	%hi(0xFFFFE000)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFFE000)
                     PFX	%xhi(0xFFFFE000)
                     MOVHI	%r13,%xlo(0xFFFFE000)             	
	
                     loopCMIT1:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back

                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r9                     ; Clear Buffer
                     STP    [%L0, 5], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r9                     ; Clear Buffer
                     STP    [%L0, 5], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 3]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 3], %r0                     ; Store it back
	
                     STP    [%L0, 4], %r2                     ; Clear Buffer
                     STP    [%L0, 5], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT1
                     NOP 	
                 ");
            break;
        }

        case 2 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFFFE0)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFFFE0)
                     PFX	%xhi(0xFFFFFFE0)
                     MOVHI	%r10,%xlo(0xFFFFFFE0)

                     PFX	%hi(0x0000001F)                   ; Set MASK
                     MOVI	%r11,%lo(0x0000001F)
                     PFX	%xhi(0x0000001F)
                     MOVHI	%r11,%xlo(0x0000001F)

                     PFX	%hi(0x0000000F)                   ; Set MASK
                     MOVI	%r12,%lo(0x0000000F)
                     PFX	%xhi(0x0000000F)
                     MOVHI	%r12,%xlo(0x0000000F)

                     PFX	%hi(0xFFFFFFF0)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFFFFF0)
                     PFX	%xhi(0xFFFFFFF0)
                     MOVHI	%r13,%xlo(0xFFFFFFF0)                                	

                     loopCMIT2:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back
	
                     STP    [%L0, 7], %r9                     ; Clear Buffer
                     STP    [%L0, 8], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back


                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r9                     ; Clear Buffer
                     STP    [%L0, 8], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back

	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back

	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 6]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 6], %r0                     ; Store it back

                     STP    [%L0, 7], %r2                     ; Clear Buffer
                     STP    [%L0, 8], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 9]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 9], %r0                     ; Store it back

	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT2
                     NOP 	
                 ");
            break;
        }

        case 3 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xF1000000)                   ; Set MASK
                     MOVI	%r10,%lo(0xF1000000)
                     PFX	%xhi(0xF1000000)
                     MOVHI	%r10,%xlo(0xF1000000)

                     PFX	%hi(0x07FFFFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x07FFFFFF)
                     PFX	%xhi(0x07FFFFFF)
                     MOVHI	%r11,%xlo(0x07FFFFFF)

                     PFX	%hi(0x07FFFFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x07FFFFFF)
                     PFX	%xhi(0x07FFFFFF)
                     MOVHI	%r12,%xlo(0x07FFFFFF)

                     PFX	%hi(0xF8000000)                   ; Set MASK
                     MOVI	%r13,%lo(0xF8000000)
                     PFX	%xhi(0xF8000000)
                     MOVHI	%r13,%xlo(0xF8000000)                                 	
	
                     loopCMIT3:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r9                     ; Clear Buffer
                     STP    [%L0, 12], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 4
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r9                     ; Clear Buffer
                     STP    [%L0, 12], %r9                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 10]                     ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 10], %r0                     ; Store it back

                     STP    [%L0, 11], %r2                     ; Clear Buffer
                     STP    [%L0, 12], %r2                     ; Clear Buffer

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT3
                     NOP 	
                ");
            break;
        }

        case 4 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFE00000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFE00000)
                     PFX	%xhi(0xFFE00000)
                     MOVHI	%r10,%xlo(0xFFE00000)

                     PFX	%hi(0x001FFFFF)                   ; Set MASK
                     MOVI	%r11,%lo(0x001FFFFF)
                     PFX	%xhi(0x001FFFFF)
                     MOVHI	%r11,%xlo(0x001FFFFF)             	

                     PFX	%hi(0x0003FFFF)                   ; Set MASK
                     MOVI	%r12,%lo(0x0003FFFF)
                     PFX	%xhi(0x0003FFFF)
                     MOVHI	%r12,%xlo(0x0003FFFF)

                     PFX	%hi(0xFFFC0000)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFC0000)
                     PFX	%xhi(0xFFFC0000)
                     MOVHI	%r13,%xlo(0xFFFC0000)             	
	
                     loopCMIT4:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back

                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r9                    ; Clear Buffer
                     STP    [%L0, 15], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r9                    ; Clear Buffer
                     STP    [%L0, 15], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 13]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 13], %r0                    ; Store it back
	
                     STP    [%L0, 14], %r2                    ; Clear Buffer
                     STP    [%L0, 15], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT4
                     NOP 	
                 ");

            break;
        }

        case 5 :
        {
            asm(" 	
	                 PFX	%hi(0x0095FA00)                   ; Set UI1 Address
	                 MOVI	%r3,%lo(0x0095FA00)
	                 PFX	%xhi(0x0095FA00)
	                 MOVHI	%r3,%xlo(0x0095FA00)	
	                                              /*
	                 PFX	%hi(0x00969000)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x00969000)
	                 PFX	%xhi(0x00969000)
	                 MOVHI	%r4,%xlo(0x00969000)*/
/*	
	                 PFX	%hi(0x009F5A00)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x009F5A00)
	                 PFX	%xhi(0x009F5A00)
	                 MOVHI	%r4,%xlo(0x009F5A00)	
*/
	                 PFX	%hi(0x008D3BF4)                   ; Set UI2 Address
	                 MOVI	%r4,%lo(0x008D3BF4)
	                 PFX	%xhi(0x008D3BF4)
	                 MOVHI	%r4,%xlo(0x008D3BF4)
	
                     PFX	%hi(0x00972600)                   ; Set UI3 Address
                     MOVI	%r5,%lo(0x00972600)
                     PFX	%xhi(0x00972600)
                     MOVHI	%r5,%xlo(0x00972600)	
	
                     PFX	%hi(0x0097BC00)                   ; Set UI4 Address
                     MOVI	%r6,%lo(0x0097BC00)
                     PFX	%xhi(0x0097BC00)
                     MOVHI	%r6,%xlo(0x0097BC00)                     	

                     PFX	%hi(0x00985200)                   ; Set UI5 Address
                     MOVI	%r7,%lo(0x00985200)
                     PFX	%xhi(0x00985200)
                     MOVHI	%r7,%xlo(0x00985200)	
	
                     PFX	%hi(0x009AAA00)                   ; Set CH4 Address
                     MOVI	%r8,%lo(0x009AAA00)
                     PFX	%xhi(0x009AAA00)
                     MOVHI	%r8,%xlo(0x009AAA00)

                     ADD    %r3, %i1                          ; Add Address Counter
                     ADD    %r4, %i1
                     ADD    %r5, %i1
                     ADD    %r6, %i1
                     ADD    %r7, %i1
                     ADD    %r8, %i1

                     MOV    %r1, %i2

                     PFX	%hi(0)                            ; Set Clear register
                     MOVI	%r2,%lo(0)
                     PFX	%xhi(0)
                     MOVHI	%r2,%xlo(0)	

                     PFX	%hi(0xFFFFFFFF)                   ; Set Clear register
                     MOVI	%r9,%lo(0xFFFFFFFF)
                     PFX	%xhi(0xFFFFFFFF)
                     MOVHI	%r9,%xlo(0xFFFFFFFF)	

                     PFX	%hi(0xFFFFC000)                   ; Set MASK
                     MOVI	%r10,%lo(0xFFFFC000)
                     PFX	%xhi(0xFFFFC000)
                     MOVHI	%r10,%xlo(0xFFFFC000)

                     PFX	%hi(0x000003FF)                   ; Set MASK
                     MOVI	%r11,%lo(0x000003FF)
                     PFX	%xhi(0x000003FF)
                     MOVHI	%r11,%xlo(0x000003FF)

                     PFX	%hi(0x000001FF)                   ; Set MASK
                     MOVI	%r12,%lo(0x000001FF)
                     PFX	%xhi(0x000001FF)
                     MOVHI	%r12,%xlo(0x000001FF)

                     PFX	%hi(0xFFFFFE00)                   ; Set MASK
                     MOVI	%r13,%lo(0xFFFFFE00)
                     PFX	%xhi(0xFFFFFE00)
                     MOVHI	%r13,%xlo(0xFFFFFE00)                                  	

                     loopCMIT5:

                     ;// UI 1
                     MOV    %L0, %r3

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back

                     ;// UI 2
                     MOV    %L0, %r4

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back
	
                     ;// UI 3
                     MOV    %L0, %r5

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back
	
                     STP    [%L0, 17], %r9                    ; Clear Buffer
                     STP    [%L0, 18], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back

                     ;// UI  4	
                     MOV    %L0, %r6

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r11                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r9                    ; Clear Buffer
                     STP    [%L0, 18], %r9                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     OR     %r0, %r13                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back
	
                     ;// UI 5
                     MOV    %L0, %r7

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back
	
                     ;// CH 4
                     MOV    %L0, %r8

                     LDP    %r0, [%L0, 16]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r10                         ; Mask Data
	                 STP    [%L0, 16], %r0                    ; Store it back

                     STP    [%L0, 17], %r2                    ; Clear Buffer
                     STP    [%L0, 18], %r2                    ; Clear Buffer

                     LDP    %r0, [%L0, 19]                    ; Load Buffer Data to %r0  	
                     AND    %r0, %r12                         ; Mask Data
	                 STP    [%L0, 19], %r0                    ; Store it back
	

                     PFX	%hi(80)                                          	
                     ADDI   %r3, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r4, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r5, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r6, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r7, %lo(80)                      ; Add Address Counter
                     PFX	%hi(80)                                          	
                     ADDI   %r8, %lo(80)                      ; Add Address Counter

                     SUBI   %r1, 1                            ; Decrement Line Counter
                     SKPS   cc_z
                     BR     loopCMIT5
                     NOP 	
                 ");
            break;
        }
    }
   // UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DrawMenuItemButton(int ItemNr, unsigned char active, unsigned char pushed)
{
	int ispacer = 0;
	
	//if ((Active_Menu == 15) && (ItemNr == 1)) return; // for pulse width
	
	// Get Menuitem Pos
	switch(ItemNr)
	{
		case 0:
		{
			ispacer = 8;
			break;
		}
		case 1:
		{
			ispacer = 113;
			break;
		}
		case 2:
		{
			ispacer = 218;
			break;
		}
		case 3:
		{
			ispacer = 323;
			break;
		}
		case 4:
		{
			ispacer = 428;
			break;
		}
		case 5:
		{
			ispacer = 533;
			break;
		}
	}									
			
	// Draw Button Frame
	DRAWROUNDBUTTON(ispacer - 3, 432, 106, 46, pushed, btnDraw);	
}
//##########################################################################################################################################################

void Display::DrawMenuItem(int MenuNr,int ItemNr, unsigned char active, unsigned char pushed)
{
	int ispacer = 0;
	int xe, textcorr = 0;
	char BufferText[17];	
	char BufferText2[17];	
	
	//if ((MenuNr == 15) && (ItemNr == 1)) return; // For Pulse Width button 1 remove
	
	// Get Menuitem Pos
	switch(ItemNr)
	{
		case 0:
		{
			ispacer = 8;
			break;
		}
		case 1:
		{
			ispacer = 113;
			break;
		}
		case 2:
		{
			ispacer = 218;
			break;
		}
		case 3:
		{
			ispacer = 323;
			break;
		}
		case 4:
		{
			ispacer = 428;
			break;
		}
		case 5:
		{
			ispacer = 533;
			break;
		}
	}	
	
	
	
	// Get the Items Caption Text	
	for (xe = 0; xe < 16; xe++)
	{
        	if ((MenuNr == 15) && (ItemNr == 3) && (MenuStatus[15][2] == 3)) BufferText[xe] = MenuItem[MenuNr][ItemNr + 1][xe]; //change items
		else if ((MenuNr == 15) && (ItemNr == 4) && (MenuStatus[15][2] == 3)) BufferText[xe] = MenuItem[MenuNr][ItemNr + 1][xe]; // delta t
		//else if ((MenuNr == 15) && (ItemNr == 1)) BufferText[xe] = MenuItem151[xe]; // delta t		
		else BufferText[xe] = MenuItem[MenuNr][ItemNr][xe];
	}
	
	if ((MenuStatus[MenuNr][ItemNr] > 243) && (MenuStatus[MenuNr][ItemNr] < 247))
	{
		// Draw Items Caption Text
		TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5);		// Draw Menu Text		
		TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane);	// Draw Menu Text	
	}
	else
	{	
	
	    //if ((MenuNr == 15) && (ItemNr == 1)) TEXTOUTxvbig(BufferText, ispacer + 22, 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
	    //else
        if ((MenuNr == 15) && ((ItemNr == 3) || (ItemNr == 4)))
        {
            if (ItemNr == 3)
            {
                if (MenuStatus[15][2] == 1)
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 	// Draw Menu Data Text
                }
                else if (MenuStatus[15][2] == 2)
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
                }
                else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1))
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
                }
                else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2))
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 	// Draw Menu Data Text
                }
            }

            if (ItemNr == 4)
            {
                if (MenuStatus[15][2] == 2)
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 	// Draw Menu Data Text
                }
                else if (MenuStatus[15][2] == 1)
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
                }
                else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2))
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
                }
                else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1))
                {
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
                    TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5); 	// Draw Menu Data Text
                }
            }
        }
        else
        {	
            if (active)
            {
                // Draw Items Caption Text	
                TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, Buffer_UI2Plane);	// Draw Menu Text	
            }
            else
            {
                // Draw Items Caption Text
                TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 1, UI_Plane5);		// Draw Menu Text		
                TEXTOUTxvbig(BufferText, ispacer + MenuItemDef[MenuNr][ItemNr], 438, 0, Buffer_UI2Plane);	// Draw Menu Text
            }
        }
    }
	
	switch(MenuNr)
	{
		// Acquire
		//case 0:
		//{
			//if (ItemNr == 2) DrawMenuArrowCycle(ispacer + 6, active);	//Button 3
			//break;
		//}
		
		// Channels Probe
		case 1:
		case 2:
		case 3:
		case 4:						
		{
			if (ItemNr == 3) DrawMenuArrowCycle(ispacer + 6, active);	
			break;
		}	
		
		// Display
		case 5:
		{
			if (ItemNr == 2) DrawMenuArrowCycle(ispacer + 6, active);	
			break;
		}	
		
		// Save / Recall
		case 8:
		{
			if (ItemNr == 0)
            {
                DrawMenuArrowCycle(ispacer + 6, active);
                sprintf(BufferText, "%d", SavePointer);		
                TEXTOUTxvbig(BufferText, ispacer + 46, 455, 1, Buffer_UI2Plane);					// Draw memory Text
			}
            	
			break;
		}		

		// Trigger Mode
		case 12:
		{
			if (ItemNr == 3)
			{
				if (EdgeToggle == 0) DrawMenuArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 6, 0);
				
                if (HoldOff_Value) TEXTOUTxvbig(HoldOff.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
				else TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 1, Buffer_UI2Plane); 		// Draw Menu Data Text	
				
				// grayed "off"
				//TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 0, Buffer_UI2Plane);
				//TEXTOUTxvbig(MenuData[5], ispacer + 36, 455, 1, UI_Plane5);
			}
			if (ItemNr == 4)
			{
				if (EdgeToggle == 1) DrawMenuArrowCycle(ispacer + 6, active);
				else DrawMenuArrowCycle(ispacer + 6, 0);
			}			
			break;
		}
		
		// Trigger Edge PreTrigger
		case 14:
		{
			if (ItemNr == 4)
            {
                DrawMenuArrowCycle(ispacer + 6, active);	
                TEXTOUTxvbig(Trigger_Offset_Str.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text	
            }
			break;
		}
        			
		// Pulse Width
		case 15:
		{		
			if (ItemNr == 3)
			{
				if (MenuStatus[15][2] == 1) DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[15][2] == 2) DrawMenuArrowCycle(ispacer + 6, active);
				else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1)) DrawMenuArrowCycle(ispacer + 6, active);			
				else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2)) DrawMenuArrowCycle(ispacer + 6, 0);
			}

			if (ItemNr == 4)
			{
				if (MenuStatus[15][2] == 2)
				DrawMenuArrowCycle(ispacer + 6, 0);
				else if (MenuStatus[15][2] == 1) DrawMenuArrowCycle(ispacer + 6, active);
				else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2)) DrawMenuArrowCycle(ispacer + 6, active);			
				else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1)) DrawMenuArrowCycle(ispacer + 6, 0);
			}            			

			if (MenuStatus[15][2] != 3)
			{
				if (ItemNr == 3)
				{
					if (MenuStatus[15][2] == 1)
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 	// Draw Menu Data Text
					}
					else if (MenuStatus[15][2] == 2)
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1))
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
					}
					else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2))
					{
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse21.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 	// Draw Menu Data Text
					}
               			 }

				if (ItemNr == 4)
				{
					if (MenuStatus[15][2] == 2)
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 	// Draw Menu Data Text
					}
					else if (MenuStatus[15][2] == 1)
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text
					}
					else if ((MenuStatus[15][2] == 3) && (PulseToggle == 2))
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane); 	// Draw Menu Data Text			
					}
					else if ((MenuStatus[15][2] == 3) && (PulseToggle == 1))
					{
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 0, Buffer_UI2Plane); 	// Draw Menu Data Text
						TEXTOUTxvbig(Pulse22.Read_Text(), ispacer + 26, 455, 1, UI_Plane5); 	// Draw Menu Data Text
					}
                		}

			}
			else
			{
				if (ItemNr == 3)
				{
					TEXTOUTxvbig(Pulse11.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
				}
				if (ItemNr == 4)
				{
					TEXTOUTxvbig(Pulse12.Read_Text(), ispacer + 26, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
				}
			}
			break;
		}	
		//---------------------------------------------------------------------------
		// BF display cursour data -> added new data for FFT
		//---------------------------------------------------------------------------
		case 16:
		{
			switch(ItemNr)
			{
				case 1:
				{
					if (Cursor_Vertical_Active == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (XY_Mode)
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else if(FFT_Mode != FFT_OFF)
					{
						if (active)	
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
				
				case 2:
				{
					if (Cursor_Vertical_Active == 2) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (XY_Mode)
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_XY_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);
						}					
					}
					else if(FFT_Mode != FFT_OFF)
					{
						if (active)	
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)	
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Vertical_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}

				case 3:
				{
					if (Cursor_Horizontal_Active == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if(FFT_Mode != FFT_OFF)
					{
						if (active)
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Horizontal_Pos_1_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
						
				case 4:
				{
					if (Cursor_Horizontal_Active == 2) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if(FFT_Mode != FFT_OFF)
					{
						if (active)
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(FFT_Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					else	//normal mode
					{
						if (active)
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	
						}
						else
						{
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(Cursor_Horizontal_Pos_2_Str.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	
						}
					}
					break;
				}
				
				case 5:
				{
					if (Cursor_Vertical_Active == 4)
					{
						DrawMenuArrowCycle(ispacer + 6, active);
						DrawMenuArrowCycle2(ispacer + 6, 0);
					}
					else if (Cursor_Horizontal_Active == 4)
					{
						DrawMenuArrowCycle(ispacer + 6, 0);
						DrawMenuArrowCycle2(ispacer + 6, active);
					}
					else
					{
						DrawMenuArrowCycle(ispacer + 6, 0);
						DrawMenuArrowCycle2(ispacer + 6, 0);
					}					
				}				
			}
			break;
		}

		// Quick Measure
		case 19:
		{
			if (ItemNr == 1 ) DrawMenuBiggerArrowCycle(ispacer + 6, active);	
			break;
		}
			
		// Quick Measurment Threshold
		case 22:
		{
			if (ItemNr == 2)
			{
				if (Quick_Measure_Threshold_btn_select == 1) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_lower.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
					if (ItemNr == 3)
			{
				if (Quick_Measure_Threshold_btn_select == 2) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_middle.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
					if (ItemNr == 4)
			{
				if (Quick_Measure_Threshold_btn_select == 3) DrawMenuArrowCycle(ispacer + 6, active);	
				else DrawMenuArrowCycle(ispacer + 6, 0);	
		
				TEXTOUTxvbig(QM_Threshold_upper.Read_Text(), ispacer + 36, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			break;
		}

//	BF not needed in new FFT -> causes text failure in Window button!!!

		// FFT Settings		
		case 27:		
		{
/*
			if (ItemNr == 1)
			{
				if (FFTToggle == 0)
					DrawMenuArrowCycle(ispacer + 6, active);	
				else 
					DrawMenuArrowCycle(ispacer + 6, 0);	
				
				TEXTOUTxvbig(FFT_Scale_Str.Read_Text(), ispacer + 8, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
			}
			if (ItemNr == 2)
			{
				if (FFTToggle == 1)
					DrawMenuArrowCycle(ispacer + 6, active);	
				else 
					DrawMenuArrowCycle(ispacer + 6, 0);
				
				 TEXTOUTxvbig(FFT_Offset_Str.Read_Text(), ispacer + 10, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text	
			}
*/


			break;
		}	//BF changed end



		// Math Channel Settings
		case 29:
		{
			switch(ItemNr)
			{
				case 0:
				{
					if (MathToggle == 0) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
                        if (MenuStatus[26][2] == 1)	TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + MenuDataDef[math_mul_scale], 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][3] == 1) TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + MenuDataDef[math_sub_scale], 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][4] == 1) TEXTOUTxvbig(MenuData[math_add_scale], ispacer + MenuDataDef[math_add_scale], 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
					}
					else
					{
						if (MenuStatus[26][2] == 1)	
						{
							TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + 16, 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(MenuData[math_mul_scale], ispacer + 16, 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[26][3] == 1)	
						{
							TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + 16, 455, 0, Buffer_UI2Plane);
							TEXTOUTxvbig(MenuData[math_sub_scale], ispacer + 16, 455, 1, UI_Plane5);	
						}
						else if (MenuStatus[26][4] == 1)	
						{
							TEXTOUTxvbig(MenuData[math_add_scale], ispacer + 16, 455, 0, Buffer_UI2Plane);	
							TEXTOUTxvbig(MenuData[math_add_scale], ispacer + 16, 455, 1, UI_Plane5);
						}
					}

					break;
				}			
			
				case 1:
				{
					if (MathToggle == 1) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
                        if (MenuStatus[26][2] == 1)	TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][3] == 1) TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][4] == 1) TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
					}
					else
					{
                        if (MenuStatus[26][2] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
                        else if (MenuStatus[26][3] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
                        else if (MenuStatus[26][4] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 16, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
					}

					break;
				}
				
				case 2:
				{
					if (1 == 0) DrawMenuArrowCycle(ispacer + 6, active);
					else DrawMenuArrowCycle(ispacer + 6, 0);
					
					if (active)
					{
                        if (MenuStatus[26][2] == 1)	TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][3] == 1) TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
                        else if (MenuStatus[26][4] == 1) TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 1, Buffer_UI2Plane);	// Draw Menu Data Text
					}
					else
					{
                        if (MenuStatus[26][2] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_mul.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
                        else if (MenuStatus[26][3] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_sub.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
                        else if (MenuStatus[26][4] == 1)	
                        {
                            TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 0, Buffer_UI2Plane);	// Draw Menu Data Text
                            TEXTOUTxvbig(Math_Offset_add.Read_Text(), ispacer + 20, 455, 1, UI_Plane5);	// Draw Menu Data Text												
                        }
					}
					break;
				}
            }
            break;
        }        	
	}
	
	// Text Correction for Pulse Width Item 2
	if ((MenuNr == 15) && (ItemNr == 2))
	{
		if (MenuStatus[MenuNr][ItemNr] == 2) textcorr = -9;
		else if (MenuStatus[MenuNr][ItemNr] == 3) textcorr = 8;
	}	

	if (MenuStatus[MenuNr][ItemNr] < 240)
	{
		if (active)
		{
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 1, Buffer_UI2Plane);				// Draw Menu Data Text
		}
		else
		{
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 0, Buffer_UI2Plane);				// Draw Menu Data Text
			TEXTOUTxvbig(MenuData[MenuStatus[MenuNr][ItemNr]], ispacer + MenuDataDef[MenuStatus[MenuNr][ItemNr]] + textcorr, 455, 1, UI_Plane5);				// Draw Menu Data Text			
		}		
	}
	else if ((MenuStatus[MenuNr][ItemNr] > 239) && (MenuStatus[MenuNr][ItemNr] < 242)) DrawMenuCheckBox(ispacer + 46, 457, MenuStatus[MenuNr][ItemNr] - 240, active);  	// Draw a Checkbox
	else if ((MenuStatus[MenuNr][ItemNr] > 241) && (MenuStatus[MenuNr][ItemNr] < 244)) DrawMenuArrow(ispacer + 31, MenuStatus[MenuNr][ItemNr] - 242, active);			// Draw a Arrow
	else if ((MenuStatus[MenuNr][ItemNr] > 243) && (MenuStatus[MenuNr][ItemNr] < 246)) DrawMenuArrow(ispacer + 31, MenuStatus[MenuNr][ItemNr] - 244, 0);			    // Draw a Arrow Grayed	
	else if (MenuStatus[MenuNr][ItemNr] == 247) DrawSubMenuArrow(ispacer + 31, active);																					// Draw a SubArrow	
#ifdef _Debug_	
	printf("MNr %d  INr %d : %d\n", MenuNr, ItemNr, MenuStatus[MenuNr][ItemNr]);
#endif	
	MenuItemChanged[ItemNr] = 0;
//	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::ClearMenuItem(int ItemNr)				// Clear a Menuitem            Überarbeiten mit Assembler Funktion
{
	int xa, Ct;
	
	switch(ItemNr)
	{
		case 0:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{			
				*(UI_Plane1 + xa) = 0;
				*(UI_Plane1 + xa + 1) = 0;
				*(UI_Plane1 + xa + 2) = 0;
				*(UI_Plane1 + xa + 3) = *(UI_Plane1 + xa + 3) & 0x0007FFFF;			
				*(Buffer_UI2Plane + xa) = 0;
				*(Buffer_UI2Plane + xa + 1) = 0;
				*(Buffer_UI2Plane + xa + 2) = 0;
				*(Buffer_UI2Plane + xa + 3) = *(Buffer_UI2Plane + xa + 3) & 0x0007FFFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa) = 0;
				*(UI_Plane3 + xa + 1) = 0;
				*(UI_Plane3 + xa + 2) = 0;
				*(UI_Plane3 + xa + 3) = *(UI_Plane3 + xa + 3) & 0x0007FFFF;
				// BF end
				*(UI_Plane4 + xa) = 0;
				*(UI_Plane4 + xa + 1) = 0;
				*(UI_Plane4 + xa + 2) = 0;
				*(UI_Plane4 + xa + 3) = *(UI_Plane4 + xa + 3) & 0x0007FFFF;
				*(UI_Plane5 + xa) = 0;
				*(UI_Plane5 + xa + 1) = 0;
				*(UI_Plane5 + xa + 2) = 0;
				*(UI_Plane5 + xa + 3) = *(UI_Plane5 + xa + 3) & 0x0007FFFF;
				xa += 20;
			}
			break;
		}
		case 1:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 3) = *(UI_Plane1 + xa + 3) & 0xFFFF0000;
				*(UI_Plane1 + xa + 4) = 0;
				*(UI_Plane1 + xa + 5) = 0;
				*(UI_Plane1 + xa + 6) = *(UI_Plane1 + xa + 6) & 0x000003FF;								
				*(Buffer_UI2Plane + xa + 3) = *(Buffer_UI2Plane + xa + 3) & 0xFFFF0000;
				*(Buffer_UI2Plane + xa + 4) = 0;
				*(Buffer_UI2Plane + xa + 5) = 0;
				*(Buffer_UI2Plane + xa + 6) = *(Buffer_UI2Plane + xa + 6) & 0x000003FF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 3) = *(UI_Plane3 + xa + 3) & 0xFFFF0000;
				*(UI_Plane3 + xa + 4) = 0;
				*(UI_Plane3 + xa + 5) = 0;
				*(UI_Plane3 + xa + 6) = *(UI_Plane3 + xa + 6) & 0x000003FF;
				// BF end
				*(UI_Plane4 + xa + 3) = *(UI_Plane4 + xa + 3) & 0xFFFF0000;
				*(UI_Plane4 + xa + 4) = 0;
				*(UI_Plane4 + xa + 5) = 0;
				*(UI_Plane4 + xa + 6) = *(UI_Plane4 + xa + 6) & 0x000003FF;
				*(UI_Plane5 + xa + 3) = *(UI_Plane5 + xa + 3) & 0xFFFF0000;
				*(UI_Plane5 + xa + 4) = 0;
				*(UI_Plane5 + xa + 5) = 0;
				*(UI_Plane5 + xa + 6) = *(UI_Plane5 + xa + 6) & 0x000003FF;
				xa += 20;
			}
			break;
		}
		case 2:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 6) = *(UI_Plane1 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane1 + xa + 7) = 0;
				*(UI_Plane1 + xa + 8) = 0;
				*(UI_Plane1 + xa + 9) = 0;
				*(Buffer_UI2Plane + xa + 6) = *(Buffer_UI2Plane + xa + 6) & 0xFFFFFF00;
				*(Buffer_UI2Plane + xa + 7) = 0;
				*(Buffer_UI2Plane + xa + 8) = 0;
				*(Buffer_UI2Plane + xa + 9) = 0;	
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 6) = *(UI_Plane3 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane3 + xa + 7) = 0;
				*(UI_Plane3 + xa + 8) = 0;
				*(UI_Plane3 + xa + 9) = 0;
				// BF end
				*(UI_Plane4 + xa + 6) = *(UI_Plane4 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane4 + xa + 7) = 0;
				*(UI_Plane4 + xa + 8) = 0;
				*(UI_Plane4 + xa + 9) = 0;
				*(UI_Plane5 + xa + 6) = *(UI_Plane5 + xa + 6) & 0xFFFFFF00;
				*(UI_Plane5 + xa + 7) = 0;
				*(UI_Plane5 + xa + 8) = 0;
				*(UI_Plane5 + xa + 9) = 0;
				xa += 20;
			}
			break;
		}
		case 3:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 10) = 0;
				*(UI_Plane1 + xa + 11) = 0;
				*(UI_Plane1 + xa + 12) = 0;
				*(UI_Plane1 + xa + 13) = *(UI_Plane1 + xa + 13) & 0x00FFFFFF;
				*(Buffer_UI2Plane + xa + 10) = 0;
				*(Buffer_UI2Plane + xa + 11) = 0;
				*(Buffer_UI2Plane + xa + 12) = 0;
				*(Buffer_UI2Plane + xa + 13) = *(Buffer_UI2Plane + xa + 13) & 0x00FFFFFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 10) = 0;
				*(UI_Plane3 + xa + 11) = 0;
				*(UI_Plane3 + xa + 12) = 0;
				*(UI_Plane3 + xa + 13) = *(UI_Plane3 + xa + 13) & 0x00FFFFFF;
				// BF end
				*(UI_Plane4 + xa + 10) = 0;
				*(UI_Plane4 + xa + 11) = 0;
				*(UI_Plane4 + xa + 12) = 0;
				*(UI_Plane4 + xa + 13) = *(UI_Plane4 + xa + 13) & 0x00FFFFFF;
				*(UI_Plane5 + xa + 10) = 0;
				*(UI_Plane5 + xa + 11) = 0;
				*(UI_Plane5 + xa + 12) = 0;
				*(UI_Plane5 + xa + 13) = *(UI_Plane5 + xa + 13) & 0x00FFFFFF;
				xa += 20;
			}
			break;
		}
		case 4:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 13) = *(UI_Plane1 + xa + 13) & 0xFF000000;
				*(UI_Plane1 + xa + 14) = 0;
				*(UI_Plane1 + xa + 15) = 0;
				*(UI_Plane1 + xa + 16) =  *(UI_Plane1 + xa + 16) & 0x00007FFF;
				*(Buffer_UI2Plane + xa + 13) = *(Buffer_UI2Plane + xa + 13) & 0xFF000000;
				*(Buffer_UI2Plane + xa + 14) = 0;
				*(Buffer_UI2Plane + xa + 15) = 0;
				*(Buffer_UI2Plane + xa + 16) =  *(Buffer_UI2Plane + xa + 16) & 0x00007FFF;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 13) = *(UI_Plane3 + xa + 13) & 0xFF000000;
				*(UI_Plane3 + xa + 14) = 0;
				*(UI_Plane3 + xa + 15) = 0;
				*(UI_Plane3 + xa + 16) =  *(UI_Plane3 + xa + 16) & 0x00007FFF;
				// BF end
				*(UI_Plane4 + xa + 13) = *(UI_Plane4 + xa + 13) & 0xFF000000;
				*(UI_Plane4 + xa + 14) = 0;
				*(UI_Plane4 + xa + 15) = 0;
				*(UI_Plane4 + xa + 16) =  *(UI_Plane4 + xa + 16) & 0x00007FFF;
				*(UI_Plane5 + xa + 13) = *(UI_Plane5 + xa + 13) & 0xFF000000;
				*(UI_Plane5 + xa + 14) = 0;
				*(UI_Plane5 + xa + 15) = 0;
				*(UI_Plane5 + xa + 16) =  *(UI_Plane5 + xa + 16) & 0x00007FFF;
				xa += 20;
			}
			break;
		}
		case 5:
		{
			xa = 432 * 20;

			for (Ct = 0; Ct < 44; Ct++)
			{
				*(UI_Plane1 + xa + 16) = *(UI_Plane1 + xa + 16) & 0xFFFFC000;
				*(UI_Plane1 + xa + 17) = 0;
				*(UI_Plane1 + xa + 18) = 0;
				*(UI_Plane1 + xa + 19) = 0;
				*(Buffer_UI2Plane + xa + 16) = *(Buffer_UI2Plane + xa + 16) & 0xFFFFC000;
				*(Buffer_UI2Plane + xa + 17) = 0;
				*(Buffer_UI2Plane + xa + 18) = 0;
				*(Buffer_UI2Plane + xa + 19) = 0;
				// BF reactivated UI_Plane3
				*(UI_Plane3 + xa + 16) = *(UI_Plane3 + xa + 16) & 0xFFFFC000;
				*(UI_Plane3 + xa + 17) = 0;
				*(UI_Plane3 + xa + 18) = 0;
				*(UI_Plane3 + xa + 19) = 0;
				// BF end
				*(UI_Plane4 + xa + 16) = *(UI_Plane4 + xa + 16) & 0xFFFFC000;
				*(UI_Plane4 + xa + 17) = 0;
				*(UI_Plane4 + xa + 18) = 0;
				*(UI_Plane4 + xa + 19) = 0;
				*(UI_Plane5 + xa + 16) = *(UI_Plane5 + xa + 16) & 0xFFFFC000;
				*(UI_Plane5 + xa + 17) = 0;
				*(UI_Plane5 + xa + 18) = 0;
				*(UI_Plane5 + xa + 19) = 0;
				xa += 20;
			}
			break;
		}
	}	
 //   UpdateMenuTextPlane = true;								
}
//##########################################################################################################################################################

void Display::DRAWMENUPOPUP(int PopupNr)
{
	int x, xe, y;
	int pos = 0;

	int posx = 0;
	int sizex = 0;
	int posy = 0;
	int sizey = 0;
	int count = 0;	
	int button = 0;
	
	char BufferText[22];
	char BufferText2[22];	
		
	button = MenuPopupDef[PopupNr][0];
	count  = MenuPopupDef[PopupNr][1];
	
	posx = (button * 100) + 15;
	sizey = (count * 17) + 37;
	posy = 420 - sizey;

	if ((PopupNr == 4) || (PopupNr == 22)) sizex = 150;
	else sizex = 120;

	MenuPopupX = posx - 2;
	MenuPopupY = posy;
	MenuPopupSizeX = sizex + 4;
	MenuPopupSizeY = sizey + 15;

	// Clear


	if (MenuPopupActive != PopupNr)
	{
		DRAWP(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane1); //sizey = 5	
		DRAWP(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane2);
		DRAWP(posx - 1, posy, sizex + 2, sizey, 0, UI_Plane5);		
	
		DRAWROUNDBUTTON(posx - 3, posy, sizex + 6, sizey + 3, btnUnpushed, btnDraw);
		DRAWMENUBUTTONSELECT(button);		

		//Draw Popup Caption
		sprintf(BufferText, "");
		for (xe = 0; xe < 20; xe++)
		{
			BufferText[xe] = MenuPopupText[PopupNr][0][xe];
		}
		TEXTOUTxvbig(BufferText, posx + 5, posy + 5, 1, UI_Plane2);					// Draw Menu Text
		
		// Div Line
		DRAWP(posx + 2, posy + 20, sizex - 4, 1, 1, UI_Plane5);
		DRAWP(posx + 2, posy + 21, sizex - 4, 1, 1, UI_Plane1);	
		
		for (x = 0;x < count;x++)
		{
			sprintf(BufferText, "");
			for (xe = 0; xe < 20; xe++)
			{
				BufferText[xe] = MenuPopupText[PopupNr][x + 1][xe];
			}
		
			if (MenuPopupStatus[PopupNr][x] == 1)
			{
	//			TEXTOUTxvbig(BufferText, posx + 25, posy + 28 + (x * 17), 0, UI_Plane2);	// Draw Popup Item Text
				TEXTOUTxvbig(BufferText, posx + 25, posy + 28 + (x * 17), 1, UI_Plane5);	// Draw Popup Item Text	
			}
			else if (MenuPopupStatus[PopupNr][x] == 2)
			{
				TEXTOUTxvbig(BufferText, posx + 25, posy + 28 + (x * 17), 1, UI_Plane2);	// Draw Popup Item Text
			}
			else if (MenuPopupStatus[PopupNr][x] == 3)
			{
				sprintf(BufferText2, "%c  %s", Menu_Select, BufferText);
				TEXTOUTxvbig(BufferText2, posx + 5, posy + 28 + (x * 17), 1, UI_Plane2);	// Draw Popup Item Text		
			}			
		}
	}
	else
	{
		DRAWP(posx + 4, posy + 27, 15, sizey - 35, 0, UI_Plane2);
		
		for (x = 0;x < count;x++)
		{		
			if (MenuPopupStatus[PopupNr][x] == 3)
			{
				sprintf(BufferText2, "%c", Menu_Select);
				TEXTOUTxvbig(BufferText2, posx + 5, posy + 28 + (x * 17), 1, UI_Plane2);	// Draw Popup Item Text		
			}
		}
	}		
		
	MenuPopupChanged = 1;
	MenuPopupActive  = PopupNr;	
	
//	MenuTimeCounter = 0;
	//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
}
//##########################################################################################################################################################

void Display::DRAWMENUPOPDOWN(void)
{
	int x, y;
	int posy = 0;
	int sizey = 0;
	int count = 0;	
	int xa, xo, Ct;	

	// Clean Up the Popup
	xa = MenuPopupY * 20;
	xo = MenuPopupX / 32;

	for (Ct = 0; Ct < MenuPopupSizeY - 5; Ct++)
	{			
		*(UI_Plane1 + xo + xa)     = 0;
		*(UI_Plane1 + xo + xa + 1) = 0;
		*(UI_Plane1 + xo + xa + 2) = 0;
		*(UI_Plane1 + xo + xa + 3) = 0;
		*(UI_Plane1 + xo + xa + 4) = 0;
		*(UI_Plane1 + xo + xa + 5) = 0;

		*(Buffer_UI2Plane + xo + xa)     = 0;
		*(Buffer_UI2Plane + xo + xa + 1) = 0;
		*(Buffer_UI2Plane + xo + xa + 2) = 0;
		*(Buffer_UI2Plane + xo + xa + 3) = 0;
		*(Buffer_UI2Plane + xo + xa + 4) = 0;
		*(Buffer_UI2Plane + xo + xa + 5) = 0;

		*(UI_Plane2 + xo + xa)     = 0;
		*(UI_Plane2 + xo + xa + 1) = 0;
		*(UI_Plane2 + xo + xa + 2) = 0;
		*(UI_Plane2 + xo + xa + 3) = 0;
		*(UI_Plane2 + xo + xa + 4) = 0;
		*(UI_Plane2 + xo + xa + 5) = 0;
/* BF del to avoid overwriting of grid 
		*(UI_Plane3 + xo + xa)     = 0;
		*(UI_Plane3 + xo + xa + 1) = 0;
		*(UI_Plane3 + xo + xa + 2) = 0;
		*(UI_Plane3 + xo + xa + 3) = 0;
		*(UI_Plane3 + xo + xa + 4) = 0;
		*(UI_Plane3 + xo + xa + 5) = 0;
 BF end*/
		*(UI_Plane4 + xo + xa)     = 0;
		*(UI_Plane4 + xo + xa + 1) = 0;
		*(UI_Plane4 + xo + xa + 2) = 0;
		*(UI_Plane4 + xo + xa + 3) = 0;
		*(UI_Plane4 + xo + xa + 4) = 0;
		*(UI_Plane4 + xo + xa + 5) = 0;

		*(UI_Plane5 + xo + xa)     = 0;
		*(UI_Plane5 + xo + xa + 1) = 0;
		*(UI_Plane5 + xo + xa + 2) = 0;
		*(UI_Plane5 + xo + xa + 3) = 0;
		*(UI_Plane5 + xo + xa + 4) = 0;
		*(UI_Plane5 + xo + xa + 5) = 0;
		xa += 20;
	}
	
/* BF del because no repair is needed when lines above are commented out
	// Repaire Menu Down
//	xa = 407 * 20;
	xa = BOTT_PLANE_MIN;
	for (Ct = 0; Ct < 23; Ct++)
	{			
		*(UI_Plane3 + xo + xa)     = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 1) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 2) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 3) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 4) = 0xFFFFFFFF;
		*(UI_Plane3 + xo + xa + 5) = 0xFFFFFFFF;
		xa += 20;
	}	
BF end */

	if (MenuPopupActive == 4)
    	{
		// Repaire Top Menu
		xa = 9 * 20;
		for (Ct = 0; Ct < 9; Ct++)
		{			
			*(UI_Plane3 + xo + xa)     = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 1) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 2) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 3) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 4) = 0xFFFFFFFF;
			*(UI_Plane3 + xo + xa + 5) = 0xFFFFFFFF;
			xa += 20;
		}

	/* TMW  if (MenuStatus[5][4] == 241)	//Units
		{
		Display::DRAWMEMORY(0, 1, 1);
		} TMW*/
	
	//        Channel_2_Active = 1;
		VoltageChangedCh1 = 1;
		VoltageChangedCh2 = 1;
	
		Channel_1_Active_Old = 0;
		Channel_2_Active_Old = 0;
	
		if (NumberOfChannels > 2)
		{
		//            Channel_3_Active = 1;
			VoltageChangedCh3 = 1;
		
		//            Channel_4_Active = 1;
			VoltageChangedCh4 = 1;
		
			Channel_3_Active_Old = 0;
			Channel_4_Active_Old = 0;
		}
	
		StatusUpdate();
    	}
	

	MenuPopupActive = -1;
	MenuPopupChanged = 0;
	New_Menu = Active_Menu;
    	Menu_Changed = 1;

	// Repaire Menu	
	if (Cursor_Enabled)
	{
		CursorChanged = 3;
		Cursor_Data_First_Draw = true;
		DRAWCURSORDATA(0);
	}
	if (QM_Enabled)
	{
		Quick_Measure_First_Draw = true;
		DRAWQMDATA(0);
	}
	
  
//    Hardware::TransferDataPlane_asm_persistant(0x008DBB24, 0x00970F30);
//    UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DRAWMENUBUTTONSELECT(int buttonnr)
{
	int x, y, c, posx = 0;
	posx = 40 + (buttonnr * 100);
	
	c = 21;	
	for (y = 0; y < 10; y++)
	{
		for (x = 0; x < c; x++)
		{
			if (x == 0) PIXELP(posx + y + x, 420 + y, 1, UI_Plane5);				//clBlack
			else if (x == (c - 1)) PIXELP(posx + y + x, 420 + y, 1, UI_Plane5);
			else PIXELP(posx + y + x, 420 + y, 1, UI_Plane4);		
			PIXELP(posx + y + x, 420 + y, 0, UI_Plane2);
		}
		c--;
		c--;
	}	
 }
//##########################################################################################################################################################
//BF  added workaround for wrong UI_Plane1 transfer	
void Display::DRAWROUNDBUTTON(int posx, int posy, int sizex, int sizey, unsigned char pushed, unsigned char remove)
{
	char set;
	unsigned long *iplane;	
	int x, y, c;
	
	pushed = 0;	// BF test
	
	if (remove) set = 0;
	else set = 1;		
		
	// Upper side
	// Left Edge
	c = 8;
	for (y = 1; y < 7; y++)
	{
		if (y < 6) c--;	
		for (x = c; x < 9; x++)
		{
			if ((y == 1) && (pushed == 0)) iplane = UI_Plane1;
			else if ((y == 1) && (pushed == 1)) iplane = UI_Plane5;
			else if ((x == c) && (pushed == 0)) iplane = UI_Plane1;
			else if ((x == c) && (pushed == 1)) iplane = UI_Plane5;
			else iplane = UI_Plane4;
			
			PIXELP(posx + x, posy + y, set, iplane);
		}
	}

/*BF  del -> workaround for wrong UI_Plane1 transfer	
	if (pushed) iplane = UI_Plane5;
	else iplane = UI_Plane1;	
	
	// Upper Middle
	DRAWP(posx + 9, posy, sizex - 18, 1, set, iplane);		// TopLine
*/
	if ((posx+sizex) > 607)	//BF workaround for wrong UI_Plane1 transfer	
	{
		DRAWLINEP(posx + 9, posy, posx + sizex - 9, posy, set, UI_Plane4);	// top line
		DRAWLINEP(posx + 9, posy, 607, posy, set, UI_Plane1);			// top line

	}	
	else
	DRAWLINEP(posx + 9, posy, posx + sizex - 9, posy, set, UI_Plane1);		// top line


	// Middle Block
	DRAWP(posx + 9, posy + 1, sizex - 18, 6, set, UI_Plane4);

	// Right Edge
	c = 1;
	for (y = 1; y < 7; y++)
	{
		if (y < 6) c++;	
		for (x = 0; x < c; x++)
		{	
			if ((y == 1) && (pushed == 0)) 
			{ if ((posx+sizex) > 607) iplane = UI_Plane4;	else iplane = UI_Plane1; }	//BF workaround for wrong UI_Plane1 transfer	
			else if ((y == 1) && (pushed == 1)) iplane = UI_Plane5;
			else if ((x == (c - 1)) && (pushed == 0))		
			{ if ((posx+sizex) > 607) iplane = UI_Plane4;	else iplane = UI_Plane1; }	//BF workaround for wrong UI_Plane1 transfer	
			else if ((x == (c - 1)) && (pushed == 1)) iplane = UI_Plane5;
			else iplane = UI_Plane4;
			
			PIXELP(posx + (sizex - 9) + x, posy + y, set, iplane);
		}
	}		

	// Middle Block
	DRAWP(posx + 3, posy + 7, sizex - 6, sizey - 16, set, UI_Plane4);

	// Sidelines
	if (pushed)
	{
		DRAWP(posx + 2, posy + 7, 1, sizey - 16, set, UI_Plane5);
		DRAWP(posx + sizex - 3, posy + 7, 1, sizey - 16, set, UI_Plane1);
	}
	else
	{
		DRAWP(posx + 2, posy + 7, 1, sizey - 16, set, UI_Plane1);
		DRAWP(posx + sizex - 3, posy + 7, 1, sizey - 16, set, UI_Plane5);
	}

	// Down
	// Left Edge
	c = 3;
	for (y = 0; y < 6; y++)
	{
		if (y > 1) c++;	
		for (x = c; x < 9; x++)
		{		
			if ((y == 5) && (pushed == 0)) iplane = UI_Plane5;
			else if ((y == 5) && (pushed == 1)) iplane = UI_Plane1;
			else if ((x == c) && (pushed == 0)) iplane = UI_Plane5;
			else if ((x == c) && (pushed == 1)) iplane = UI_Plane1;
			else iplane = UI_Plane4;			
			
			PIXELP(posx + x, posy + (sizey - 9) + y, set, iplane);
		}
	}

	if (pushed) iplane = UI_Plane1;
	else iplane = UI_Plane5;
	
	// Lower Middle
	DRAWP(posx + 9, posy + (sizey - 9) + 6, sizex - 18, 1, set, iplane);	// BottomLine

	// Middle Block
	DRAWP(posx + 9, posy + (sizey - 9), sizex - 18, 6, set, UI_Plane4);

	// Right Edge
	c = 6;
	for (y = 0; y < 6; y++)
	{
		if (y > 1) c--;	
		for (x = 0; x < c; x++)
		{		
			if ((y == 5) && (pushed == 0)) iplane = UI_Plane5;
			else if ((y == 5) && (pushed == 1)) iplane = UI_Plane1;
			else if ((x == (c - 1)) && (pushed == 0)) iplane = UI_Plane5;
			else if ((x == (c - 1)) && (pushed == 1)) iplane = UI_Plane1;
			else iplane = UI_Plane4;						
			
			PIXELP(posx + (sizex - 9) + x, posy + (sizey - 9) + y, set, iplane);
		}
	}
}
//##########################################################################################################################################################

void Display::DRAWSQUAREBUTTON(int posx, int posy, int sizex, int sizey, unsigned char pushed, unsigned char remove)
{
	char set;
	unsigned long *iplane;			
		
	if (remove) set = 0;
	else set = 1;
	
	// Left Edge	
	if (pushed) iplane = UI_Plane5;
	else iplane = UI_Plane1;
	
	PIXELP(posx + 1, posy + 2, set, iplane);
	PIXELP(posx + 2, posy + 1, set, iplane);
	
	PIXELP(posx + 2, posy + 2, !set, UI_Plane3);	
	
	// Upper Middle
	DRAWP(posx + 3, posy, sizex - 6, 1, set, iplane);					// TopLine

	// Middle Block
	DRAWP(posx + 3, posy + 1, sizex - 6, 2, !set, UI_Plane3);				// Middle Block	
	
	// Right Edge		
	PIXELP(posx + (sizex - 3), posy + 1, set, iplane);
	PIXELP(posx + (sizex - 3) + 1, posy + 2, set, iplane);
	PIXELP(posx + (sizex - 3), posy + 2, !set, UI_Plane3);
	
	// Middle Block
	DRAWP(posx + 1, posy + 3, sizex - 2, sizey - 6, !set, UI_Plane3); //1
	
	// Sidelines
	if (pushed)
	{
		DRAWP(posx, posy + 3, 1, sizey - 6, set, UI_Plane5);
		DRAWP(posx + sizex - 1, posy + 3, 1, sizey - 6, set, UI_Plane1);
	}
	else
	{
		DRAWP(posx, posy + 3, 1, sizey - 6, set, UI_Plane1);
		DRAWP(posx + sizex - 1, posy + 3, 1, sizey - 6, set, UI_Plane5);
	}
		
	if (pushed) iplane = UI_Plane1;
	else iplane = UI_Plane5;
			
	// Down
	// Left Edge	
	PIXELP(posx + 1, posy + (sizey - 3), set, iplane);
	PIXELP(posx + 2, posy + (sizey - 3) + 1, set, iplane);
	PIXELP(posx + 2, posy + (sizey - 3), !set, UI_Plane3);

	// Lower Middle
	DRAWP(posx + 3, posy + (sizey - 1), sizex - 6, 1, set, iplane);	// Bottom Line

	DRAWP(posx + 3, posy + (sizey - 3), sizex - 6, 2, !set, UI_Plane3);		// Middle Block //1

	// Right Edge
	PIXELP(posx + (sizex - 3) + 1, posy + (sizey - 3), set, iplane);
	PIXELP(posx + (sizex - 3), posy + (sizey - 3) + 1, set, iplane);
	PIXELP(posx + (sizex - 3), posy + (sizey - 3), !set, UI_Plane3);
}
//##########################################################################################################################################################

void Display::DrawMenuCheckBox(int posx, int posy, char checked, char active)			// Draw a Checkbox in menu
{
	if (checked)
	{	
		DRAWLINEP(posx, posy, posx + 10, posy, 1, UI_Plane5);
		DRAWLINEP(posx + 1, posy + 10, posx + 11, posy + 10, 1, UI_Plane1);
		DRAWLINEP(posx, posy + 1, posx, posy + 10, 1, UI_Plane5);				
		DRAWLINEP(posx + 10, posy, posx + 10, posy + 10, 1, UI_Plane1);
		
		if (active) DRAWP(posx + 2, posy + 2, 7, 7, 1, Buffer_UI2Plane);								// Checkbox Filling Black
		else
		{
			DRAWP(posx + 2, posy + 2, 7, 7, 1, UI_Plane5);										// Checkbox Filling Gray
		}
	}
	else
	{
		DRAWLINEP(posx, posy, posx + 10, posy, 1, UI_Plane1);	
		DRAWLINEP(posx + 1, posy + 10, posx + 11, posy + 10, 1, UI_Plane5);
		DRAWLINEP(posx, posy + 1, posx, posy + 10, 1, UI_Plane1);		
		DRAWLINEP(posx + 10, posy, posx + 10, posy + 10, 1, UI_Plane5);					
		
		DRAWP(posx + 2, posy + 2, 7, 7, 0, Buffer_UI2Plane);								// Checkbox Filling
		DRAWP(posx + 2, posy + 2, 7, 7, 0, UI_Plane5);								// Checkbox Filling

	}	
    UpdateMenuTextPlane = true;		
}
//##########################################################################################################################################################

void Display::DrawMenuArrow(int posx, int updn, int active)					// Draw Sub-Menu Arrow
{	
	if (updn == 0)  // Down
	{
		BITBITMAP(bitbmBigArrowDown, posx, 455, active, Buffer_UI2Plane);
		BITBITMAP(bitbmBigArrowDown, posx, 455, !active, UI_Plane5);
	}
	else			// Up , it is always displayed without Text -> 10 Dots heigher
	{
		BITBITMAP(bitbmBigArrowUp, posx, 445, active, Buffer_UI2Plane);
		BITBITMAP(bitbmBigArrowUp, posx, 445, !active, UI_Plane5);
	}	
	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DrawMenuArrowCycle(int posx, int active)						// Draw the knob turn cycle
{
	if (active)
	{
		BITBITMAP(bitbmCycleArrow, posx, 438, 1, Channel_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 438, 1, Buffer_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 438, 0, UI_Plane3);
		BITBITMAP(bitbmCycleArrow, posx, 438, 0, UI_Plane4);		
	}
	else BITBITMAP(bitbmCycleArrow, posx, 438, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawMenuArrowCycle2(int posx, int active)						// Draw the knob turn cycle
{
	if (active)
	{
		BITBITMAP(bitbmCycleArrow, posx, 455, 1, Channel_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 455, 1, Buffer_Plane4);
		BITBITMAP(bitbmCycleArrow, posx, 455, 0, UI_Plane3);
		BITBITMAP(bitbmCycleArrow, posx, 455, 0, UI_Plane4);		
	}
	else BITBITMAP(bitbmCycleArrow, posx, 455, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawMenuBiggerArrowCycle(int posx, int active)					// Draw the knob turn cycle with popup arrow
{
	if (active)
	{
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, Channel_Plane4);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, Buffer_Plane4);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 0, UI_Plane3);
		BITBITMAP(bitbmSelectCycleArrow, posx, 438, 0, UI_Plane4);
	}
	else BITBITMAP(bitbmSelectCycleArrow, posx, 438, 1, UI_Plane5);
}
//##########################################################################################################################################################

void Display::DrawSubMenuArrow(int posx, int active)						// Draw the sub menu arrow
{
	if (active)  BITBITMAP(bitbmSubMenu, posx, 458, 1, Buffer_UI2Plane);
	else BITBITMAP(bitbmSubMenu, posx, 458, 1, UI_Plane5);
	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################

void Display::DRAW_ALL_CURSOR(void)								// Draw the Cursors
{
	int c;
    	int BufVal1 = 0;
    	int BufVal2 = 0;
    	int BufVal3 = 0;
    	int BufVal4 = 0;
    	int BufVal5 = 0;
    	int BufVal6 = 0;
	int vert_cursor_max = GRID_HEIGHT + 1;		// BF
	
	int horz_cursor_start = 0;
	int horz_cursor_stop = GRID_WIDTH;		// BF
	
	long Cursor_Vertical_Position1 = 0;							// Store Cursor vertical I position
	long Cursor_Vertical_Position2 = 0;							// Store Cursor vertical II position
		
	long Cursor_Horizontal_Position1 = 0;							// Store Cursor horizontal I position
	long Cursor_Horizontal_Position2 = 0;							// Store Cursor horizontal II position
	
	long QM_Vertical_Position1 = 0;
	long QM_Vertical_Position2 = 0;
	
	long QM_Horizontal_Position1 = 0;
	long QM_Horizontal_Position2 = 0;
	int lXOffs = GRID_XOFFS;
	


	if (Splash_drawed) return;
	
	if (MenuStatus[MENU_TIMEBASE][1] == 1) vert_cursor_max = (GRID_HEIGHT / 2) - 2;  //BF 190;
	
	// New Trigger Position
	BufVal1 = Trig_Pos_Display + DrawOffsetX;
	BufVal2 = Trig_Pos_Display_dmode + DrawOffsetX;
	
	if (BufVal2 > (GRID_WIDTH - 1 + DrawOffsetX)) BufVal2 = GRID_WIDTH - 1 + DrawOffsetX;
	if (BufVal2 < (DrawOffsetX - 2)) BufVal2 = DrawOffsetX - 2;
	
	if (MenuStatus[MENU_TIMEBASE][1] == 0) BufVal2 = 0;
	
	//printf("BV1 : %5d BV2 : %5d\n", BufVal1, BufVal2);

	if (BufVal1 != Trig_Pos_Display_old || FFT_Mode != FFT_OFF)
	{
		// Remove Trigger Offset
		if (Trig_Pos_Display_old <= (DrawOffsetX - 2))
		{
			DRAWLINEP(Trig_Pos_Display_old + 0, 26, Trig_Pos_Display_old + 11, 26, 0, Buffer_Mark1Plane);
			
			DRAWLINEP(Trig_Pos_Display_old + 1, 25, Trig_Pos_Display_old + 1, 28, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old + 2, 24, Trig_Pos_Display_old + 2, 29, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old + 3, 23, Trig_Pos_Display_old + 3, 30, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old + 4, 22, Trig_Pos_Display_old + 4, 31, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old + 5, 21, Trig_Pos_Display_old + 5, 32, 0, Buffer_Mark1Plane);
		}
		else if (Trig_Pos_Display_old >= (GRID_WIDTH - 1 + DrawOffsetX))
		{
			DRAWLINEP(Trig_Pos_Display_old - 10, 26, Trig_Pos_Display_old + 2, 26, 0, Buffer_Mark1Plane);
		
			DRAWLINEP(Trig_Pos_Display_old - 1, 25, Trig_Pos_Display_old - 1, 28, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 2, 24, Trig_Pos_Display_old - 2, 29, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 3, 23, Trig_Pos_Display_old - 3, 30, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 4, 22, Trig_Pos_Display_old - 4, 31, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 5, 21, Trig_Pos_Display_old - 5, 32, 0, Buffer_Mark1Plane);
		}
		else
		{
			DRAWLINEP(Trig_Pos_Display_old - 3, 21, Trig_Pos_Display_old + 4, 21, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 3, 22, Trig_Pos_Display_old + 4, 22, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 3, 23, Trig_Pos_Display_old + 4, 23, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 3, 24, Trig_Pos_Display_old + 4, 24, 0, Buffer_Mark1Plane);
		
			DRAWLINEP(Trig_Pos_Display_old - 3, 25, Trig_Pos_Display_old + 4, 25, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 2, 26, Trig_Pos_Display_old + 3, 26, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_old - 1, 27, Trig_Pos_Display_old + 2, 27, 0, Buffer_Mark1Plane);
			PIXELP(Trig_Pos_Display_old, 28, 0, Buffer_Mark1Plane);
		
			DRAWLINEP(Trig_Pos_Display_old - 3, 21, Trig_Pos_Display_old + 4, 21, 0, Marker_Plane1);
			DRAWLINEP(Trig_Pos_Display_old - 3, 22, Trig_Pos_Display_old + 4, 22, 0, Marker_Plane1);
			DRAWLINEP(Trig_Pos_Display_old - 3, 23, Trig_Pos_Display_old + 4, 23, 0, Marker_Plane1);
			DRAWLINEP(Trig_Pos_Display_old - 3, 24, Trig_Pos_Display_old + 4, 24, 0, Marker_Plane1);
		
			DRAWLINEP(Trig_Pos_Display_old - 3, 25, Trig_Pos_Display_old + 4, 25, 0, Marker_Plane1);
			DRAWLINEP(Trig_Pos_Display_old - 2, 26, Trig_Pos_Display_old + 3, 26, 0, Marker_Plane1);
			DRAWLINEP(Trig_Pos_Display_old - 1, 27, Trig_Pos_Display_old + 2, 27, 0, Marker_Plane1);
			PIXELP(Trig_Pos_Display_old, 28, 0, Marker_Plane1);
		
			DRAWLINEP(Trig_Pos_Display_old - 2, 22, Trig_Pos_Display_old + 3, 22, 0, UI_Plane2);
			DRAWLINEP(Trig_Pos_Display_old, 22, Trig_Pos_Display_old, 27, 0, UI_Plane2);
		}
	}
    
	if (BufVal2 != Trig_Pos_Display_dmode_old || FFT_Mode != FFT_OFF)
	{
		if (Trig_Pos_Display_dmode_old <= (DrawOffsetX - 2))
		{
			DRAWLINEP(Trig_Pos_Display_dmode_old + 0, 227, Trig_Pos_Display_dmode_old + 11, 227, 0, Buffer_Mark1Plane);
		
			DRAWLINEP(Trig_Pos_Display_dmode_old + 1, 226, Trig_Pos_Display_dmode_old + 1, 229, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old + 2, 225, Trig_Pos_Display_dmode_old + 2, 230, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old + 3, 224, Trig_Pos_Display_dmode_old + 3, 231, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old + 4, 223, Trig_Pos_Display_dmode_old + 4, 232, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old + 5, 222, Trig_Pos_Display_dmode_old + 5, 233, 0, Buffer_Mark1Plane);
		}
		else if (Trig_Pos_Display_dmode_old >= (GRID_WIDTH - 1 + DrawOffsetX))
		{
			DRAWLINEP(Trig_Pos_Display_dmode_old - 10, 227, Trig_Pos_Display_dmode_old + 1, 227, 0, Buffer_Mark1Plane);
		
			DRAWLINEP(Trig_Pos_Display_dmode_old - 1, 226, Trig_Pos_Display_dmode_old - 1, 229, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 2, 225, Trig_Pos_Display_dmode_old - 2, 230, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 3, 224, Trig_Pos_Display_dmode_old - 3, 231, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 4, 223, Trig_Pos_Display_dmode_old - 4, 232, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 5, 222, Trig_Pos_Display_dmode_old - 5, 233, 0, Buffer_Mark1Plane);
		}
		else
		{
			// Remove Trigger sign in delayed window
			DRAWLINEP(Trig_Pos_Display_dmode_old - 5, 222, Trig_Pos_Display_dmode_old + 6, 222, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 4, 223, Trig_Pos_Display_dmode_old + 5, 223, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 3, 224, Trig_Pos_Display_dmode_old + 4, 224, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 2, 225, Trig_Pos_Display_dmode_old + 3, 225, 0, Buffer_Mark1Plane);
			DRAWLINEP(Trig_Pos_Display_dmode_old - 1, 226, Trig_Pos_Display_dmode_old + 2, 226, 0, Buffer_Mark1Plane);
			PIXELP(Trig_Pos_Display_dmode_old, 227, 0, Buffer_Mark1Plane);
		}
	}


	for (c = DrawOffsetY; c < ((GRID_HEIGHT / 2) + 1 + DrawOffsetY); c++)
	{
		// Remove vertical Cursor first	
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		// Remove vertical quick measurement cursor
		*(Buffer_Mark1Plane + (QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		// Remove delayed cursor		
		*(Buffer_Mark1Plane + (Cursor_Delayed_1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Delayed_2_Old / 32) + (c * 20)) = 0;
	}		
       		
	for (c = ((GRID_HEIGHT / 2) + 1 + DrawOffsetY); c < (GRID_HEIGHT + 2 + DrawOffsetY); c++)
	{	
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (dmode_Cursor_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (dmode_Cursor_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	
		*(Buffer_Mark1Plane + (dmode_QM_Vertical_Position1_Old / 32) + (c * 20)) = 0;
		*(Buffer_Mark1Plane + (dmode_QM_Vertical_Position2_Old / 32) + (c * 20)) = 0;
	}

	for (c = 0; c < 20; c++)
	{
		// Remove horizontal cursor first	
		*(Buffer_Mark1Plane + (Cursor_Horizontal_Position1_Old * 20) + c) = 0;
		*(Buffer_Mark1Plane + (Cursor_Horizontal_Position2_Old * 20) + c) = 0;	
	
		// Remove horizontal quick measurement cursor
		*(Buffer_Mark1Plane + (QM_Horizontal_Position1_Old * 20) + c) = 0;
		*(Buffer_Mark1Plane + (QM_Horizontal_Position2_Old * 20) + c) = 0;	
	
		// Remove horizontal cursor first	
		*(Buffer_Mark1Plane + ((Cursor_Horizontal_Position1_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
		*(Buffer_Mark1Plane + ((Cursor_Horizontal_Position2_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;	
	
		// Remove horizontal quick measurement cursor
		*(Buffer_Mark1Plane + ((QM_Horizontal_Position1_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
		*(Buffer_Mark1Plane + ((QM_Horizontal_Position2_Old + (GRID_HEIGHT / 2) + 1) * 20) + c) = 0;
	}
	
	// Everything removed - start drawing

	// Draw Tigger sign in main window
	// Draw the filled Triangle for Offset Position
	if (XY_Mode == 0 && FFT_Mode == FFT_OFF)	//Main mode
	{

		if (BufVal1 <= (DrawOffsetX - 2))
		{
			BufVal1 = DrawOffsetX - 2;
		
			DRAWLINEP(BufVal1 + 0, 26, BufVal1 + 11, 26, 1, Buffer_Mark1Plane);
		
			DRAWLINEP(BufVal1 + 1, 25, BufVal1 + 1, 28, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 + 2, 24, BufVal1 + 2, 29, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 + 3, 23, BufVal1 + 3, 30, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 + 4, 22, BufVal1 + 4, 31, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 + 5, 21, BufVal1 + 5, 32, 1, Buffer_Mark1Plane);
	
		}
		else if (BufVal1 >= (GRID_WIDTH - 1 + DrawOffsetX))
		{
			BufVal1 = GRID_WIDTH - 1 + DrawOffsetX;
		
			DRAWLINEP(BufVal1 - 10, 26, BufVal1 + 1, 26, 1, Buffer_Mark1Plane);
		
			DRAWLINEP(BufVal1 - 1, 25, BufVal1 - 1, 28, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 2, 24, BufVal1 - 2, 29, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 3, 23, BufVal1 - 3, 30, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 4, 22, BufVal1 - 4, 31, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 5, 21, BufVal1 - 5, 32, 1, Buffer_Mark1Plane);
	
		}
		else
		{
			DRAWLINEP(BufVal1 - 3, 21, BufVal1 + 4, 21, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 3, 22, BufVal1 + 4, 22, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 3, 23, BufVal1 + 4, 23, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 3, 24, BufVal1 + 4, 24, 1, Buffer_Mark1Plane);
		
			DRAWLINEP(BufVal1 - 3, 25, BufVal1 + 4, 25, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 2, 26, BufVal1 + 3, 26, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal1 - 1, 27, BufVal1 + 2, 27, 1, Buffer_Mark1Plane);
			PIXELP(BufVal1, 28, 1, Buffer_Mark1Plane);
		
			DRAWLINEP(BufVal1 - 3, 21, BufVal1 + 4, 21, 1, Marker_Plane1);
			DRAWLINEP(BufVal1 - 3, 22, BufVal1 + 4, 22, 1, Marker_Plane1);
			DRAWLINEP(BufVal1 - 3, 23, BufVal1 + 4, 23, 1, Marker_Plane1);
			DRAWLINEP(BufVal1 - 3, 24, BufVal1 + 4, 24, 1, Marker_Plane1);
		
			DRAWLINEP(BufVal1 - 3, 25, BufVal1 + 4, 25, 1, Marker_Plane1);
			DRAWLINEP(BufVal1 - 2, 26, BufVal1 + 3, 26, 1, Marker_Plane1);
			DRAWLINEP(BufVal1 - 1, 27, BufVal1 + 2, 27, 1, Marker_Plane1);
			PIXELP(BufVal1, 28, 1, Marker_Plane1);
		
			DRAWLINEP(BufVal1 - 2, 22, BufVal1 + 3, 22, 1, UI_Plane2);
			DRAWLINEP(BufVal1, 22, BufVal1, 27, 1, UI_Plane2);
		}

		//Trigger_Offset_Pos_Old = BufVal1; // Save actual position	
		Trig_Pos_Display_old = BufVal1; // Save actual position	

#ifdef _Debug_
//        if (Debug_Mode) printf("trof %d trofold %d bufval %d tof %d st %d sfi %d dmst %d dmsfi %d dwop %d df %f  cd1 %d cd2 %d  vc1 %d vc2 %d \n", Trigger_Offset_Pos, Trigger_Offset_Pos_Old, BufVal1, Timebase_Offset_Pos, Selected_Timebase, SIGNALFaktor_idx, dmode_Selected_Timebase, dmode_SIGNALFaktor_idx, dmode_Window_Offset_Pos, dmode_factor, Cursor_Delayed_1, Cursor_Delayed_2, Cursor_Vertical_Position_Real1, Cursor_Vertical_Position_Real2);
#endif        		
        	//--------------------------------------------------
		// Draw Trigger in delayed window
		//--------------------------------------------------
		if (MenuStatus[MENU_TIMEBASE][1] == 1)
		{

#ifdef _Debug_
//            if (Debug_Mode) printf("TrOfPo %d bv : %d dWOP %d df %f cd1 %d SS %d\n", Trigger_Offset_Pos, BufVal1, dmode_Window_Offset_Pos, dmode_factor, Cursor_Delayed_1, SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float));
#endif

			DRAWLINEP(BufVal2 - 5, 222, BufVal2 + 6, 222, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal2 - 4, 223, BufVal2 + 5, 223, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal2 - 3, 224, BufVal2 + 4, 224, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal2 - 2, 225, BufVal2 + 3, 225, 1, Buffer_Mark1Plane);
			DRAWLINEP(BufVal2 - 1, 226, BufVal2 + 2, 226, 1, Buffer_Mark1Plane);
			PIXELP(BufVal2, 227, 1, Buffer_Mark1Plane);

			//dmode_Trigger_Offset_Pos_Old = BufVal2;
			Trig_Pos_Display_dmode_old = BufVal2;
		
			// draw delayed cursor
			BufVal1 = Cursor_Delayed_1 + DrawOffsetX;
			BufVal2 = Cursor_Delayed_2 + DrawOffsetX;
		
			if (BufVal1 > (GRID_WIDTH + DrawOffsetX)) BufVal1 = GRID_WIDTH + DrawOffsetX;
			if (BufVal1 < DrawOffsetX) BufVal1 = DrawOffsetX;
			if (BufVal2 > (GRID_WIDTH + DrawOffsetX)) BufVal2 = GRID_WIDTH + DrawOffsetX;
			if (BufVal2 < DrawOffsetX) BufVal2 = DrawOffsetX;

			for (c = 0; c < ((GRID_HEIGHT / 2) + 1); c++)
			{			
				if (c % 2 == 0) PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				if ((c + 1) % 2 == 0) PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
			}
		
			Cursor_Delayed_1_Old = BufVal1;
			Cursor_Delayed_2_Old = BufVal2;
        	}
    	}

	//-----------------------------
	// Draw Cursor
	//-----------------------------
	if (Cursor_Enabled)
	{

		//------------------------------------------------------------------------------------------
		//	limit cursor position  						BF changed
		//------------------------------------------------------------------------------------------

		// vertical
		if (XY_Mode)	//XY-Mode
		{
			Cursor_Vertical_Position1 = Cursor_Vertical_Position_Real_XY_1;
			Cursor_Vertical_Position2 = Cursor_Vertical_Position_Real_XY_2;

			if (Cursor_Vertical_Position1 < 0) Cursor_Vertical_Position1 = 0;
			else if (Cursor_Vertical_Position1 > GRID_XY) Cursor_Vertical_Position1 = GRID_XY;	
			
			if (Cursor_Vertical_Position2 < 0) Cursor_Vertical_Position2 = 0;
			else if (Cursor_Vertical_Position2 > GRID_XY) Cursor_Vertical_Position2 = GRID_XY;

			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position1 + GRID_XY_XOFFS;
			BufVal2 = Cursor_Vertical_Position2 + GRID_XY_XOFFS;

		}	
		else if (FFT_Mode != FFT_OFF)	//FFT
		{
			Cursor_Vertical_Position1 = Cursor_Vertical_Position_Real1;
			Cursor_Vertical_Position2 = Cursor_Vertical_Position_Real2;

			//Cursor_Vertical_Position1 = Cursor_Vertical_Position_Real1;
			if (Cursor_Vertical_Position1 > GRID_WIDTH_FFT) Cursor_Vertical_Position1 = GRID_WIDTH_FFT;
			else if (Cursor_Vertical_Position1 < 0) Cursor_Vertical_Position1 = 0;	
			
			//Cursor_Vertical_Position2 = Cursor_Vertical_Position_Real2;
			if (Cursor_Vertical_Position2 > GRID_WIDTH_FFT) Cursor_Vertical_Position2 = GRID_WIDTH_FFT;
			else if (Cursor_Vertical_Position2 < 0) Cursor_Vertical_Position2 = 0;

			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position1 + GRID_XOFFS_FFT;
			BufVal2 = Cursor_Vertical_Position2 + GRID_XOFFS_FFT;

		}
		else	//main + delayed timebase cursor
		{
			Cursor_Vertical_Position1 = (int) (((float) Cursor_Vertical_Position_Real1 - ((float) SIG_Start_Stop[ZIT_short][0] + ((float) Timebase_Offset_Pos * OFT_float))) / ZFT_float);
			Cursor_Vertical_Position2 = (int) (((float) Cursor_Vertical_Position_Real2 - ((float) SIG_Start_Stop[ZIT_short][0] + ((float) Timebase_Offset_Pos * OFT_float))) / ZFT_float);

			//Cursor_Vertical_Position1 = Cursor_Vertical_Position_Real1;
			if (Cursor_Vertical_Position1 > GRID_WIDTH) Cursor_Vertical_Position1 = GRID_WIDTH;
			else if (Cursor_Vertical_Position1 < 0) Cursor_Vertical_Position1 = 0;	
			
			//Cursor_Vertical_Position2 = Cursor_Vertical_Position_Real2;
			if (Cursor_Vertical_Position2 > GRID_WIDTH) Cursor_Vertical_Position2 = GRID_WIDTH;
			else if (Cursor_Vertical_Position2 < 0) Cursor_Vertical_Position2 = 0;

			//Absolute position for X1 and X2 cursor
			BufVal1 = Cursor_Vertical_Position1 + GRID_XOFFS;
			BufVal2 = Cursor_Vertical_Position2 + GRID_XOFFS;

		}	

		// horizontal
		Cursor_Horizontal_Position1 = Cursor_Horizontal_Position_Real1;
		if (Cursor_Horizontal_Position1 > GRID_HEIGHT) Cursor_Horizontal_Position1 = GRID_HEIGHT;
		else if (Cursor_Horizontal_Position1 < 0) Cursor_Horizontal_Position1 = 0;
			
		Cursor_Horizontal_Position2 = Cursor_Horizontal_Position_Real2;
		if (Cursor_Horizontal_Position2 > GRID_HEIGHT) Cursor_Horizontal_Position2 = GRID_HEIGHT;
		else if (Cursor_Horizontal_Position2 < 0) Cursor_Horizontal_Position2 = 0;
	



/* BFTEST must be checked becouse of wrong Cursorposition */

		if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
		{
			BufVal3 = ((int)((float) (Cursor_Vertical_Position1 - Cursor_Delayed_1) * dmode_factor) + (int) ((float) Cursor_Delayed_1 * ZFT_float) +
			 SIG_Start_Stop[ZIT_short][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) -
				((int) ((float) dmode_Window_Offset_Pos * ZFT_float) + SIG_Start_Stop[ZIT_short_dmode][0] + 
				(int) ((float) Timebase_Offset_Pos * OFT_float)) + DrawOffsetX;
				

			if (BufVal3 > (GRID_WIDTH + DrawOffsetX)) BufVal3 = (GRID_WIDTH + DrawOffsetX);
			if (BufVal3 < DrawOffsetX) BufVal3 = DrawOffsetX;
		
			BufVal4 = ((int)((float) (Cursor_Vertical_Position2 - Cursor_Delayed_1) * dmode_factor) + (int) ((float) Cursor_Delayed_1 * ZFT_float) +
			 SIG_Start_Stop[ZIT_short][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) -
				((int) ((float) dmode_Window_Offset_Pos * ZFT_float) + SIG_Start_Stop[ZIT_short_dmode][0] + 
				(int) ((float) Timebase_Offset_Pos * OFT_float)) + DrawOffsetX;
		
		
			if (BufVal4 > (GRID_WIDTH + DrawOffsetX)) BufVal4 = (GRID_WIDTH + DrawOffsetX);
			if (BufVal4 < DrawOffsetX) BufVal4 = DrawOffsetX;
		}
/* BF end	*/

		// Draw New Vertical Cursor
		switch(Cursor_Vertical_Active)
		{
			// Cursor 1 is active
			case 1:
			{
		
			if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
			{
				//Cursor upper window in delayed grid
				for (c = 0; c < vert_cursor_max; c++)
				{
					PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
					if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
				//Cursor lower window in delayed grid
				for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
				{
					PIXELP(BufVal3, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
					if (c %10 == 0) DRAWP(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
			}
			else	//Not delayed
			{
				//Main Grid full height
				for (c = 0; c < vert_cursor_max; c++)
				{
					PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
					if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
			}
			break;
		}
		// Cursor 2 is active
		case 2:
		{
			if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
	
				for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
				{
					if (c %10 == 0) DRAWP(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					PIXELP(BufVal4, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
			}
			else
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
			}
                	break;
            	}	
		// None Cursor is active
		case 3:
		{
			if (MenuStatus[MENU_TIMEBASE][1] == 1)
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					if ((c + 4) %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
	
			for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)
				{
					if (c %10 == 0) DRAWP(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					if ((c + 4) %10 == 0) DRAWP(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
			}
			else
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
					if ((c + 4) %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
				}
			}
			break;
		}	
		// Both Cursor are active
		case 4:
		{
			if (MenuStatus[MENU_TIMEBASE][1] == 1)
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane);
					PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
	
				for (c = ((GRID_HEIGHT / 2) + 2); c < (GRID_HEIGHT + 1); c++)	// BF +1????
				{
					PIXELP(BufVal3, c + DrawOffsetY, 1, Buffer_Mark1Plane);
					PIXELP(BufVal4, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
			}
			else
			{
				for (c = 0; c < vert_cursor_max; c++)
				{
					PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane);
					PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
				}
			}
			break;
		}			
	}//switch end
		
	Cursor_Vertical_Position1_Old = BufVal1;
	Cursor_Vertical_Position2_Old = BufVal2;
	dmode_Cursor_Vertical_Position1_Old = BufVal3;
	dmode_Cursor_Vertical_Position2_Old = BufVal4;
	Cursor_Vertical_Active_Old = Cursor_Vertical_Active;

        if (MenuStatus[MENU_TIMEBASE][1] == 1)
        {
		BufVal1 = (Cursor_Horizontal_Position1 >> 1) + DrawOffsetY;
		BufVal2 = (Cursor_Horizontal_Position2 >> 1) + DrawOffsetY;	
        }
        else
        {
		BufVal1 = Cursor_Horizontal_Position1 + DrawOffsetY;
		BufVal2 = Cursor_Horizontal_Position2 + DrawOffsetY;	
        }

/*BF del
        if (XY_Mode == 1)	//X-Y Mode
        {
		horz_cursor_start = DrawXYOffsetX1;
		horz_cursor_stop = DrawXYOffsetX2 - 5;
        }
        else
        {
		horz_cursor_start = 0;
		horz_cursor_stop = GRID_WIDTH;
        }
*/



	//--------------------------------------------------------------------------------------
	//BF new horizontal cursor dimension for FFT and XY due to the variing grid width
	//--------------------------------------------------------------------------------------
	
	if (XY_Mode)			// XY
	{
		lXOffs = GRID_XY_XOFFS;
		horz_cursor_start = 0;
		horz_cursor_stop = GRID_XY - 4;
	
	}
	else if(FFT_Mode != FFT_OFF)	// FFT
	{
		lXOffs = GRID_XOFFS_FFT;
		horz_cursor_start = 0;
		horz_cursor_stop = GRID_WIDTH_FFT - 4;
	
	}
	else				// main + delayed
	{
		lXOffs = GRID_XOFFS;
		horz_cursor_start = 0;
		horz_cursor_stop = GRID_WIDTH - 4;
	}

        // Draw New Horizontal Cursor
        switch(Cursor_Horizontal_Active)
        {
            // Cursor 1 is active
            case 1:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        PIXELP(c + lXOffs, BufVal1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);

                        PIXELP(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else	//not delayed
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        PIXELP(c + lXOffs, BufVal1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // Cursor 2 is active
            case 2:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2, 1, Buffer_Mark1Plane);			

                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), 1, Buffer_Mark1Plane);	
                    }
                }
                else	//not delayed
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2, 1, Buffer_Mark1Plane);			
                    }
                }
                break;
            }
            // None Cursor is active
            case 3:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);

                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, 6, 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else	//not delayed
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + lXOffs, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
            // Both Cursor are active
            case 4:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        PIXELP(c + lXOffs, BufVal1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2, 1, Buffer_Mark1Plane);

                        PIXELP(c + lXOffs, BufVal1 + (GRID_HEIGHT / 2) + 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2 + (GRID_HEIGHT / 2) + 1, 1, Buffer_Mark1Plane);
                    }
                }
                else	//not delayed
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        PIXELP(c + lXOffs, BufVal1, 1, Buffer_Mark1Plane);
                        PIXELP(c + lXOffs, BufVal2, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }					
		}
		
		Cursor_Horizontal_Position1_Old = BufVal1;
		Cursor_Horizontal_Position2_Old = BufVal2;
		Cursor_Horizontal_Active_Old = Cursor_Horizontal_Active;
	}	
	
	// Draw quick measurment cursor
    if (QM_Enabled)
    {
        QM_Vertical_Position1 = QM_Vertical_Position_Real1;
        if (QM_Vertical_Position1 > GRID_WIDTH) QM_Vertical_Position1 = GRID_WIDTH;
        else if (QM_Vertical_Position1 < 0) QM_Vertical_Position1 = 0;	
	
        QM_Vertical_Position2 = QM_Vertical_Position_Real2;
        if (QM_Vertical_Position2 > GRID_WIDTH) QM_Vertical_Position2 = GRID_WIDTH;
        else if (QM_Vertical_Position2 < 0) QM_Vertical_Position2 = 0;	
	
        QM_Horizontal_Position1 = QM_Horizontal_Position_Real1;
        if (QM_Horizontal_Position1 > GRID_HEIGHT) QM_Horizontal_Position1 = GRID_HEIGHT;
        else if (QM_Horizontal_Position1 < 0) QM_Horizontal_Position1 = 0;
		
        QM_Horizontal_Position2 = QM_Horizontal_Position_Real2;
        if (QM_Horizontal_Position2 > GRID_HEIGHT) QM_Horizontal_Position2 = GRID_HEIGHT;
        else if (QM_Horizontal_Position2 < 0) QM_Horizontal_Position2 = 0;		
	
        if (XY_Mode == 1)
        {
            if (QM_Vertical_Position1 < DrawXYOffsetX1) QM_Vertical_Position1 = DrawXYOffsetX1;
            else if (QM_Vertical_Position1 > DrawXYOffsetX2) QM_Vertical_Position1 = DrawXYOffsetX2;	
	
            if (QM_Vertical_Position2 < DrawXYOffsetX1) QM_Vertical_Position2 = DrawXYOffsetX1;
            else if (QM_Vertical_Position2 > DrawXYOffsetX2) QM_Vertical_Position2 = DrawXYOffsetX2;
        }		
	
        BufVal1 = QM_Vertical_Position1 + DrawOffsetX - 2;// + 18;
        BufVal2 = QM_Vertical_Position2 + DrawOffsetX - 2;// + 18;

        if (MenuStatus[MENU_TIMEBASE][1] == 1)
        {
            BufVal3 = ((int)((float) (QM_Vertical_Position1 - Cursor_Delayed_1) * dmode_factor) + (int) ((float) Cursor_Delayed_1 * ZFT_float) + SIG_Start_Stop[ZIT_short][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) -
                ((int) ((float) dmode_Window_Offset_Pos * ZFT_float) + SIG_Start_Stop[ZIT_short_dmode][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) + DrawOffsetX;

            if (BufVal3 > (GRID_WIDTH + DrawOffsetX)) BufVal3 = (GRID_WIDTH + DrawOffsetX);
            if (BufVal3 < DrawOffsetX) BufVal3 = DrawOffsetX;

            BufVal4 = ((int)((float) (QM_Vertical_Position2 - Cursor_Delayed_1) * dmode_factor) + (int) ((float) Cursor_Delayed_1 * ZFT_float) + SIG_Start_Stop[ZIT_short][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) -
                ((int) ((float) dmode_Window_Offset_Pos * ZFT_float) + SIG_Start_Stop[ZIT_short_dmode][0] + (int) ((float) Timebase_Offset_Pos * OFT_float)) + DrawOffsetX;

            if (BufVal4 > (GRID_WIDTH + DrawOffsetX)) BufVal4 = (GRID_WIDTH + DrawOffsetX);
            if (BufVal4 < DrawOffsetX) BufVal4 = DrawOffsetX;
        }

        // Draw New Vertical Cursor
        switch(QM_Vertical_Active)
        {
            // Cursor 1 is active
            case 1:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
                        if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        PIXELP(BufVal3, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
                        if (c %10 == 0) DRAWP(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane); 		
                        if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // Cursor 2 is active
            case 2:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                        PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                    }
                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        if (c %10 == 0) DRAWP(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                        PIXELP(BufVal4, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
            // None Cursor is active
            case 3:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }

                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        if (c %10 == 0) DRAWP(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
            // Both Cursor are active
            case 4:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                        PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                    }

                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        PIXELP(BufVal3, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                        PIXELP(BufVal4, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        PIXELP(BufVal1, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                        PIXELP(BufVal2, c + DrawOffsetY, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
            // only Cursor 1 is active
            case 5:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }

                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        if (c %10 == 0) DRAWP(BufVal3, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal1, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // only Cursor 2 is active
            case 6:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }

                    for (c = (GRID_HEIGHT / 2) + 2; c < (GRID_HEIGHT + 1); c++)	// BF +1??
                    {
                        if (c %10 == 0) DRAWP(BufVal4, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = 0; c < vert_cursor_max; c++)
                    {
                        if (c %10 == 0) DRAWP(BufVal2, c + DrawOffsetY, 1, 6, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
		}
		
		QM_Vertical_Position1_Old = BufVal1;
		QM_Vertical_Position2_Old = BufVal2;
		dmode_QM_Vertical_Position1_Old = BufVal3;
		dmode_QM_Vertical_Position2_Old = BufVal4;
		QM_Vertical_Active_Old = QM_Vertical_Active;

        if (XY_Mode == 1)	//X-Y mode
        {
            horz_cursor_start = DrawXYOffsetX1;
            horz_cursor_stop = DrawXYOffsetX2;
        }
        else
        {
            horz_cursor_start = 0;
            horz_cursor_stop = GRID_WIDTH;
        }
        // Draw New Horizontal Cursor
        if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
        {
            //BufVal1 = (QM_Horizontal_Position1 >> 1) + DrawOffsetY;
           // BufVal2 = (QM_Horizontal_Position2 >> 1) + DrawOffsetY;
                    /*
            if (multi_active)
            {
                BufVal1 = (int (float (QM_Horizontal_Position1) * ZeroScaleFactor[0][Selected_Voltage_CH1]) >> 1) + DrawOffsetY;
                BufVal2 = (int (float (QM_Horizontal_Position2) * ZeroScaleFactor[0][Selected_Voltage_CH1]) >> 1) + DrawOffsetY;

//                BufVal1 = (nm_mult(QM_Horizontal_Position1 - 128, Voltage_Correction[0][Selected_Voltage_CH1]) >> 1) + DrawOffsetY;
//                BufVal2 = (nm_mult(QM_Horizontal_Position2 - 128, Voltage_Correction[0][Selected_Voltage_CH1]) >> 1) + DrawOffsetY;
            }
            else  */
            {
                BufVal1 = (QM_Horizontal_Position1 >> 1) + DrawOffsetY;
                BufVal2 = (QM_Horizontal_Position2 >> 1) + DrawOffsetY;
            }
        }
        else
        {             /*
            if (multi_active)           //QM_Horizontal_Position_Real1
            {
                BufVal1 = int (float (QM_Horizontal_Position1) * ZeroScaleFactor[0][Selected_Voltage_CH1]) + DrawOffsetY;
                BufVal2 = int (float (QM_Horizontal_Position2) * ZeroScaleFactor[0][Selected_Voltage_CH1]) + DrawOffsetY;
            }
            else        */
            {
                BufVal1 = QM_Horizontal_Position1 + DrawOffsetY;
                BufVal2 = QM_Horizontal_Position2 + DrawOffsetY;
            }
        }

        switch(QM_Horizontal_Active)
        {
            // Cursor 1 is active
            case 1:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        PIXELP(c + DrawOffsetX, BufVal1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);

                        PIXELP(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        PIXELP(c + DrawOffsetX, BufVal1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // Cursor 2 is active
            case 2:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2, 1, Buffer_Mark1Plane);			

                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2 * ((GRID_HEIGHT / 2) + 1), 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2, 1, Buffer_Mark1Plane);			
                    }
                }
                break;
            }
            // None Cursor is active
            case 3:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);

                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        if ((c + 4) %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }	
            // Both Cursor are active
            case 4:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        PIXELP(c + DrawOffsetX, BufVal1, 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2, 1, Buffer_Mark1Plane);

                        PIXELP(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        PIXELP(c + DrawOffsetX, BufVal1, 1, Buffer_Mark1Plane);
                        PIXELP(c + DrawOffsetX, BufVal2, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // only Cursor 1 is active
            case 5:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal1, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }
            // only Cursor 2 is active
            case 6:
            {
                if (MenuStatus[MENU_TIMEBASE][1] == 1)	//Delayed
                {
                    for (c = 0; c < GRID_WIDTH; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2 + ((GRID_HEIGHT / 2) + 1), 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                else
                {
                    for (c = horz_cursor_start; c < horz_cursor_stop; c++)
                    {
                        if (c %10 == 0) DRAWP(c + DrawOffsetX, BufVal2, 6, 1, 1, Buffer_Mark1Plane);
                    }
                }
                break;
            }                					
		}
		
		QM_Horizontal_Position1_Old = BufVal1;
		QM_Horizontal_Position2_Old = BufVal2;
		QM_Horizontal_Active_Old = QM_Horizontal_Active;
	}	                         	
		
    Cursor_Enabled_Old = Cursor_Enabled;
	QM_Enabled_Old = QM_Enabled;
	
    UpdateMarkerPlane = true;    		
}
//##########################################################################################################################################################

void Display::DRAWMEMORY(char remove, char firstdraw, char redraw)
{
    int intbuf = 0;
    int pos_wst = 0;
    int pos_wsp = 0;
    int pos_to = 0;

    if (remove)
    {
        DRAWP(104, 33, 430, 19, 0, UI_Plane1);									// Clear First	
        DRAWP(104, 33, 430, 19, 0, UI_Plane2);									// Clear First	
        DRAWP(104, 33, 430, 19, 0, UI_Plane4);									// Clear First	
        DRAWP(104, 33, 430, 19, 0, UI_Plane5);									// Clear First	
        DRAWP(104, 33, 430, 19, 0, Marker_Plane2);								// Clear First	
	DRAWP(104, 33, 430, 19, 0, Buffer_Mark1Plane);								// Clear First	

        Memory_Window_visible = false;
    }

    if (firstdraw)
    {
        Memory_Window_visible = true;

        DRAWROUNDBUTTON(106, 33, 430, 19, btnUnpushed, btnDraw);						// Draw Button	
        DRAWP(116, 35, 410, 13, 1, UI_Plane2);									// Clear First	

        // Testen welche genau
        //DRAWP(116, 30, 410, 13, 0, UI_Plane3);								// Clear First	
        DRAWP(116, 35, 410, 13, 0, UI_Plane4);									// Clear First	

        DRAWP(116, 35, 410, 13, 0, Marker_Plane2);								// Clear First
    }

    if (redraw)
    {
        Memory_Window_visible = true;

        if (Selected_Timebase < 7)
        {
            pos_wst = (int) (MemWinStart / 40) + 116;
            pos_wsp = (int) ((MemWinStart + SIG_Size[ZIT_short]) / 40) + 116;

            pos_to = (int) (Trig_Pos_Mem / 40) + 116;
        }
        else
        {
            pos_wst = (int) (MemWinStart / 10) + 116;
            pos_wsp = (int) ((MemWinStart + SIG_Size[ZIT_short]) / 10) + 116;

            pos_to = (int) (Trig_Pos_Mem / 10) + 116;
        }
        //BF del if (Selected_Timebase < 4) FirStartCH = MemWinStart + 40;
        
        // Remove
        // Window Start Pos
       // if (pos_wst != mb_window_start_old)
        {
            DRAWLINEP(mb_window_start_old, 36, mb_window_start_old, 47, 0, UI_Plane5);
            DRAWLINEP(mb_window_start_old, 36, mb_window_start_old, 47, 1, UI_Plane2);
        }

        // Window Stop Pos
      //  if (pos_wsp != mb_window_stop_old)
        {
            DRAWLINEP(mb_window_stop_old, 36, mb_window_stop_old, 47, 0, UI_Plane5);
            DRAWLINEP(mb_window_stop_old, 36, mb_window_stop_old, 47, 1, UI_Plane2);
        }

        // Trigger Pos
      //  if (pos_to != mb_window_trigger_old)
        {
//            DRAWLINEP(pos_to, 34, pos_to, 39, 0, Buffer_Mark1Plane);
//            DRAWLINEP(pos_to - 2, 34, pos_to + 3, 34, 0, Buffer_Mark1Plane);
            DRAWLINEP(mb_window_trigger_old, 39, mb_window_trigger_old, 44, 0, Marker_Plane2);
            DRAWLINEP(mb_window_trigger_old - 2, 39, mb_window_trigger_old + 3, 39, 0, Marker_Plane2);
            DRAWLINEP(mb_window_trigger_old, 39, mb_window_trigger_old, 44, 1, UI_Plane2);
            DRAWLINEP(mb_window_trigger_old - 2, 39, mb_window_trigger_old + 3, 39, 1, UI_Plane2);

            if (mb_window_trigger_old < 119)
            {
                DRAWP(113, 39, 3, 5, 0, Marker_Plane2);
                DRAWP(113, 39, 3, 5, 0, UI_Plane2);
            }
            if (mb_window_trigger_old > 522)
            {
                PIXELP(526, 39, 0, Marker_Plane2);
                PIXELP(526, 39, 0, UI_Plane2);
            }
        }


        // Redraw

        // Window Start Pos
        DRAWLINEP(pos_wst, 36, pos_wst, 47, 1, UI_Plane5);
        DRAWLINEP(pos_wst, 36, pos_wst, 47, 0, UI_Plane2);
        mb_window_start_old = pos_wst;

        // Window Stop Pos
        DRAWLINEP(pos_wsp, 36, pos_wsp, 47, 1, UI_Plane5);
        DRAWLINEP(pos_wsp, 36, pos_wsp, 47, 0, UI_Plane2);
        mb_window_stop_old = pos_wsp;

        // Trigger Pos
        DRAWLINEP(pos_to, 39, pos_to, 44, 1, Marker_Plane2);
        DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 1, Marker_Plane2);
        DRAWLINEP(pos_to, 39, pos_to, 44, 0, UI_Plane2);
        DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 0, UI_Plane2);
        DRAWLINEP(pos_to, 39, pos_to, 44, 0, UI_Plane5);
        DRAWLINEP(pos_to - 2, 39, pos_to + 3, 39, 0, UI_Plane5);
        mb_window_trigger_old = pos_to;
    }

    //UpdateMarkerPlane = true;
}
//##########################################################################################################################################################
// BF added FFT cursor data, new two step logic
void Display::DRAWCURSORDATA(char dir)
{
	int posx = 0;
	int posy = 0;
	
	if (!CRS_Delta) return;	

	if (MenuPopupActive > -1) return;
		
	if (dir == 0)
	{	
			
		for (posy = 408 * 20; posy < 428 * 20; posy+=20)
		{
			for (posx = 0; posx < 13; posx++) *(Buffer_UI2Plane + posy + posx) = 0;		// delete Text		
		}	
	
		for (posy = 408 * 20; posy < 428 * 20; posy+=20)
		{
			for (posx = 14; posx < 20; posx++) *(Buffer_UI2Plane + posy + posx) = 0;	// delete Text		
		}	

		if (Cursor_Enabled)
		{
			//draw buttons
			DRAWROUNDBUTTON(1, 408, 214, 23, btnUnpushed, btnDraw);						// Button left
			DRAWROUNDBUTTON(426, 408, 214, 23, btnUnpushed, btnDraw);					// Button right	
			if (!XY_Mode) DRAWROUNDBUTTON(214, 408, 214, 23, btnUnpushed, btnDraw);				// Button middle
	
			// print text on screen
			if (XY_Mode)
			{
				TEXTOUTxvbig(Cursor_Delta_XY_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
			}
			else if (FFT_Mode != FFT_OFF)
			{
				TEXTOUTxvbig(FFT_Cursor_Delta_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(FFT_Cursor_Delta_1X.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(FFT_Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
			}
			else	// normal mode
			{
				TEXTOUTxvbig(Cursor_Delta_X.Read_Text(), 20, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
				TEXTOUTxvbig(Cursor_Delta_1X.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
				TEXTOUTxvbig(Cursor_Delta_Y.Read_Text(), 440, 412, 1, Buffer_UI2Plane);			// Draw Cursor Text	
			}
	
		}
		
		Cursor_Data_First_Draw = 0;
		Cursor_Data_Draw_Pos = 0;
		CursorChanged = 0;
	}
	else
	{
		// Es fehlt noch das löschen der Textebene
		
		if (Cursor_Data_First_Draw)
		{
			DRAWROUNDBUTTON(398, 231, 214, 23, btnUnpushed, btnDraw);					// Button
			DRAWROUNDBUTTON(398, 256, 214, 23, btnUnpushed, btnDraw);					// Button
			DRAWROUNDBUTTON(398, 281, 214, 23, btnUnpushed, btnDraw);					// Button		
		}
		
//		TEXTOUTxvbig(Cursor_Delta_X.Read_Text(), 412, 235, 1, UI_Plane4);		// Draw Cursor Text
//		TEXTOUTxvbig(Cursor_Delta_1X.Read_Text(), 412, 260, 1, UI_Plane4);		// Draw Cursor Text
//		TEXTOUTxvbig(Cursor_Delta_Y.Read_Text(), 412, 285, 1, UI_Plane4);		// Draw Cursor Text	
		
		Cursor_Data_First_Draw = 0;
		Cursor_Data_Draw_Pos = 1;
	}

    UpdateMenuTextPlane = true;	
}
//##########################################################################################################################################################

void Display::DRAWQMDATA(char dir)
{
	int posx = 0;
	int posy = 0;
	
	if (MenuPopupActive > -1) return;
	
	if (dir == 0)
	{			
		if (Quick_Measure_First_Draw)
		{
            // remove the cursor data
            for (posx = 408 * 20; posx < 430 * 20; posx++)
            {
                *(UI_Plane1 + posx) = 0;	// delete
                *(Buffer_UI2Plane + posx) = 0;	// delete Text				
                *(UI_Plane4 + posx) = 0;	// delete
                *(UI_Plane5 + posx) = 0;	// delete
            }
        }
        else		
        {
            if (QM_Changed[0] == 1)
            {
                for (posy = 408 * 20; posy < 428 * 20; posy+=20)
                {
                    for (posx = 0; posx < 6; posx++) *(Buffer_UI2Plane + posy + posx) = 0;	// delete Text		
                }
            }
            if (QM_Changed[1] == 1)
            {
                for (posy = 408 * 20; posy < 428 * 20; posy+=20)
                {
                    for (posx = 6; posx < 13; posx++) *(Buffer_UI2Plane + posy + posx) = 0;	// delete Text		
                }
            }
            if (QM_Changed[2] == 1)     // Muß größe des löschbereichs noch getestet werden
            {
                for (posy = 408 * 20; posy < 428 * 20; posy+=20)
                {
                    for (posx = 14; posx < 19; posx++) *(Buffer_UI2Plane + posy + posx) = 0;	// delete Text		
                }
            }
		}

        if (QM_Enabled)
        {		
            if (Quick_Measure_First_Draw)
            {
                if (QM_Type[0] > 0) DRAWROUNDBUTTON(1, 408, 214, 23, btnUnpushed, btnDraw);					// Button
                if (QM_Type[1] > 0) DRAWROUNDBUTTON(214, 408, 214, 23, btnUnpushed, btnDraw);					// Button
                if (QM_Type[2] > 0) DRAWROUNDBUTTON(426, 408, 214, 23, btnUnpushed, btnDraw);					// Button	
            }
	
            if (QM_Type[0] > 0) TEXTOUTxvbig(QM_Slot1.Read_Text(), 20, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
            if (QM_Type[1] > 0) TEXTOUTxvbig(QM_Slot2.Read_Text(), 230, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
            if (QM_Type[2] > 0) TEXTOUTxvbig(QM_Slot3.Read_Text(), 440, 412, 1, Buffer_UI2Plane);		// Draw Cursor Text	
        }
		
		Quick_Measure_First_Draw = 0;
		Quick_Measure_Data_Draw_Pos = 0;
		if (QM_Type[0] > 0) QM_Changed[0] = 0;
		if (QM_Type[1] > 0) QM_Changed[1] = 0;
		if (QM_Type[2] > 0) QM_Changed[2] = 0;
	}
	else
	{
		// Es fehlt noch das löschen der Textebene
		
		if (Cursor_Data_First_Draw)
		{
			DRAWROUNDBUTTON(398, 231, 214, 23, btnUnpushed, btnDraw);					// Button
			DRAWROUNDBUTTON(398, 256, 214, 23, btnUnpushed, btnDraw);					// Button
			DRAWROUNDBUTTON(398, 281, 214, 23, btnUnpushed, btnDraw);					// Button		
		}
		
//		TEXTOUTxvbig(QM_Slot1.Read_Text(), 412, 235, 1, UI_Plane4);		// Draw Cursor Text
//		TEXTOUTxvbig(QM_Slot2.Read_Text(), 412, 260, 1, UI_Plane4);		// Draw Cursor Text
//		TEXTOUTxvbig(QM_Slot3.Read_Text(), 412, 285, 1, UI_Plane4);		// Draw Cursor Text	
		
		Quick_Measure_First_Draw = 0;
		Quick_Measure_Data_Draw_Pos = 1;
		if (QM_Type[0] > 0) QM_Changed[0] = 0;
		if (QM_Type[1] > 0) QM_Changed[1] = 0;
		if (QM_Type[2] > 0) QM_Changed[2] = 0;
	}    	
/* ???	
    QM_Type_Old[0] = QM_Type[0];
    QM_Type_Old[1] = QM_Type[1];
    QM_Type_Old[2] = QM_Type[2];	
 */
    UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################
//BF changed due to new grid dimension and replaced switch against indexed array fetched
void Display::CALCCURSORDATA(void)  								// channel = source im cursor menu
{
	int buf_int = 0;	
		
	//BF del char doit = 0;	
	int volt = 0;		
	int zero = 0;		
	int voltmfactor = 0;
	float vfactor  = 0;	
	float vfactor2 = 0;	
	float voltoff  = 0;		
	
	int time = 0;
	float tfactor = 0;
	float timeoff = 0;			
	
	char BufferText[10];
	
	int channel = MenuStatus[16][0] - 26;
			
	switch(channel)
	{
	 	case 1:	// TMW comment added: case 1 means Cursor Source 1 set (use CH1 voltage)
		{				
			volt = Selected_Voltage_CH1;
			zero = ZeroLevelCH1;
			voltmfactor = MenuStatus[1][3];
			break;
		}
		case 2: // TMW comment added: case 2 means Cursor Source 2 set (use CH2 voltage)
		{				
			volt = Selected_Voltage_CH2;
			zero = ZeroLevelCH2;
			voltmfactor = MenuStatus[2][3];
			break;
		}
		case 3: // TMW comment added: case 3 means Cursor Source 3 set (use CH3 voltage)
		{				
			volt = Selected_Voltage_CH3;
			zero = ZeroLevelCH3;
			voltmfactor = MenuStatus[3][3];
			break;
		}
		case 4: // TMW comment added: case 4 means Cursor Source 4 set (use CH4 voltage)
		{				
			volt = Selected_Voltage_CH4;
			zero = ZeroLevelCH4;
			voltmfactor = MenuStatus[4][3];
			break;	
		}
	}
	

	switch(volt)
	{
		case 0 : vfactor = 20; break;
		case 1 : vfactor = 40; break;
		case 2 : vfactor = 100; break;
		case 3 : vfactor = 200; break;
		case 4 : vfactor = 400; break;
		case 5 : vfactor = 1000; break;
		case 6 : vfactor = 2000; break;
		case 7 : vfactor = 4000; break;
		case 8 : vfactor = 10000; break;
		case 9 : vfactor = 20000; break;
		case 10 : vfactor = 40000; break;
		case 11 : vfactor = 100000; break;
	}
	
	vfactor = vfactor / 1000000;

	switch(voltmfactor)
	{
		case 101: vfactor2 = 0.1; break;	
		case 102: vfactor2 = 0.2; break;
		case 103: vfactor2 = 0.5; break;
		case 104: vfactor2 = 1; break;
		case 105: vfactor2 = 2; break;
		case 106: vfactor2 = 5; break;
		case 107: vfactor2 = 10; break;
		case 108: vfactor2 = 20; break;
		case 109: vfactor2 = 50; break;
		case 110: vfactor2 = 100; break;
		case 111: vfactor2 = 200; break;
		case 112: vfactor2 = 500; break;
		case 113: vfactor2 = 1000; break;
	}	
	vfactor = vfactor * vfactor2;
	
	buf_int = zero - Cursor_Horizontal_Position_Real1;
	
	voltoff =  (float)buf_int * vfactor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	voltoff1 = voltoff;

	Cursor_Horizontal_Pos_1_Str.Write_Value(voltoff);
	Cursor_Horizontal_Pos_1_Str.RenderText();
		
	
	buf_int = zero - Cursor_Horizontal_Position_Real2;	
	
	voltoff =  (float)buf_int * vfactor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	voltoff2 = voltoff;

	Cursor_Horizontal_Pos_2_Str.Write_Value(voltoff);
	Cursor_Horizontal_Pos_2_Str.RenderText();	
	

	if (voltoff1 > voltoff2) voltoff = voltoff1 - voltoff2;
	else voltoff = voltoff2 - voltoff1;
	if (voltoff < 0) voltoff = -voltoff;

			
        if (XY_Mode)
        {			
            	sprintf(BufferText, "@Y = ");
        }
        else
        {			
		switch(channel)
		{
			case 1: sprintf(BufferText, "@Y [ = "); break;
			case 2: sprintf(BufferText, "@Y \\ = "); break;
			case 3: sprintf(BufferText, "@Y ] = "); break;
			case 4: sprintf(BufferText, "@Y ^ = "); break;
			case 5: sprintf(BufferText, "@Y(M) = "); break;
		}
        }
		
	Cursor_Delta_Y.Write_PreText(BufferText);
	Cursor_Delta_Y.Write_Value(voltoff);
	Cursor_Delta_Y.RenderText();				
	
	
	// für xy mode
	buf_int = Cursor_Vertical_Position_Real_XY_1 - 300;
	
	voltoff =  (float)buf_int * vfactor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	voltoff1 = voltoff;

	Cursor_Vertical_Pos_XY_1_Str.Write_Value(voltoff);
	Cursor_Vertical_Pos_XY_1_Str.RenderText();
		
	
	buf_int = Cursor_Vertical_Position_Real_XY_2 - 300;	
	
	voltoff =  (float)buf_int * vfactor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	voltoff2 = voltoff;

	Cursor_Vertical_Pos_XY_2_Str.Write_Value(voltoff);
	Cursor_Vertical_Pos_XY_2_Str.RenderText();	
	
	if (voltoff1 > voltoff2) voltoff = voltoff1 - voltoff2;
	else voltoff = voltoff2 - voltoff1;
	if (voltoff < 0) voltoff = -voltoff;

	sprintf(BufferText, "@X = ");

	
	Cursor_Delta_XY_X.Write_PreText(BufferText);
	Cursor_Delta_XY_X.Write_Value(voltoff);
	Cursor_Delta_XY_X.RenderText();				


	// BF -> changed to indexed array fetch!!
	tfactor = TimeBaseFactor[Display_Timebase] / 1000000 / ZFT_float;


    buf_int = (int) (((float) Cursor_Vertical_Position_Real1 - ((float) SIG_Start_Stop[ZIT_short][0] + ((float) Timebase_Offset_Pos * OFT_float))) );// / ZFT_float);	
	

	timeoff =  (float)buf_int * tfactor;  // Mitte ist 300
	timeoff1 = timeoff;
		
	Cursor_Vertical_Pos_1_Str.Write_Value(timeoff);
	Cursor_Vertical_Pos_1_Str.RenderText();	
		

    buf_int = (int) (((float) Cursor_Vertical_Position_Real2 - ((float) SIG_Start_Stop[ZIT_short][0] + ((float) Timebase_Offset_Pos * OFT_float))) ); /// ZFT_float);		


	timeoff =  (float)buf_int * tfactor;  // Mitte ist 300
	timeoff2 = timeoff;

	Cursor_Vertical_Pos_2_Str.Write_Value(timeoff);	
	Cursor_Vertical_Pos_2_Str.RenderText();	
		
	
	if (timeoff1 > timeoff2) timeoff = timeoff1 - timeoff2;
	else timeoff = timeoff2 - timeoff1;
	if (timeoff < 0) timeoff = -timeoff;
	
	Cursor_Delta_X.Write_Value(timeoff);	
	Cursor_Delta_X.RenderText();
	
	timeoff = 1 / timeoff;
	Cursor_Delta_1X.Write_Value(timeoff);
	Cursor_Delta_1X.RenderText();
	
}
//##########################################################################################################################################################
// BF -> Quick Measure completely redesigned by Stefan
void Display::CALCQMDATA(void)
{
 //BF	#define _Debug_QM_
	
    float BufVal = 1;

    int step=0, ixs=0, ixss=0, cnt=0, mid_buf = 0;
    int off_buf = 0;
    short PBuf;

    short thres_low = (int) QM_Threshold_lower.Read_Value();
    short thres_mdl = (int) QM_Threshold_middle.Read_Value();
    short thres_up = (int) QM_Threshold_upper.Read_Value();

    short SIGNAL_THRES_PRE_POSITIV = -1;
    short SIGNAL_THRES_LOW_POSITIV = -1;
    short SIGNAL_THRES_MDL_POSITIV = -1;
    short SIGNAL_THRES_UP_POSITIV = -1;
    short SIGNAL_THRES_OVER_POSITIV = -1;

    short SIGNAL_THRES_PRE_NEGATIV = -1;
    short SIGNAL_THRES_LOW_NEGATIV = -1;
    short SIGNAL_THRES_MDL_NEGATIV = -1;
    short SIGNAL_THRES_UP_NEGATIV = -1;
    short SIGNAL_THRES_OVER_NEGATIV = -1;

	unsigned char *LPSIGNAL = 0;
	int channel=0;
    // muß überarbeitet werden
    //rot_int->np_piointerruptmask = 0x00;
    //key_int->np_piointerruptmask = 0x00;
	

#ifdef _Debug_QM_
    if (Debug_Mode)
    {
        printf("QM ixs %d ixss %d\n", ixs, ixss);
        printf("QM_TYPE[0] %d QM_TYPE[1] %d QM_TYPE[2] %d\n", QM_Type[0], QM_Type[1], QM_Type[2]);
        printf("QM_Channel[0] %d QM_Channel[1] %d QM_Channel[2] %d\n", QM_Channel[0], QM_Channel[1], QM_Channel[2]);
    }
#endif

    if (QM_Type[0] == 2)
    {
        QM_Second_Channel[0] = MenuStatus[20][2] - 26;
        QM_CHI_Edge[0] = MenuStatus[20][1] - 1;            // 1 = positiv , 2 = negativ
        QM_CHII_Edge[0] = MenuStatus[20][3] - 1;
    }
    else if (QM_Type[0] == 10)
    {
        QM_Second_Channel[0] = MenuStatus[20][2] - 26;
    }
    else QM_Second_Channel[0] = 0;

    if (QM_Type[1] == 2)
    {
        QM_Second_Channel[1] = MenuStatus[20][2] - 26;
        QM_CHI_Edge[1] = MenuStatus[20][1] - 1;            // 1 = positiv , 2 = negativ
        QM_CHII_Edge[1] = MenuStatus[20][3] - 1;
    }
    else if (QM_Type[1] == 10)
    {
        QM_Second_Channel[1] = MenuStatus[20][2] - 26;
    }
    else QM_Second_Channel[1] = 0;

    if (QM_Type[2] == 2)
    {
        QM_Second_Channel[2] = MenuStatus[20][2] - 26;
        QM_CHI_Edge[2] = MenuStatus[20][1] - 1;            // 1 = positiv , 2 = negativ
        QM_CHII_Edge[2] = MenuStatus[20][3] - 1;
    }
    else if (QM_Type[2] == 10)
    {
        QM_Second_Channel[2] = MenuStatus[20][2] - 26;
    }
    else QM_Second_Channel[2] = 0;


    // Max = Top Screen - positiv Voltage
    // Min = Bottom Screen - negativ Voltage
	
	ixs=MemWinStart+Trigger_Offset_Calc;//left edge in mem
	//printf("ixs: %d, memSTart: %d\n",ixs,MemWinStart);
	ixss=ixs+GRID_WIDTH*draw_factor;
	
	step=draw_factor;
	if (step==0)
		step=1;
	//if (ixss>


	for (channel=1;channel<=4;channel++){
		SIGNAL_AVG_CNT[channel-1] = 0;
		SIGNAL_AVG[channel-1] = 0;
			
		if ((QM_Channel[0] == channel) || (QM_Channel[1] == channel) || (QM_Channel[2] == channel) || (QM_Second_Channel[0] == channel) || (QM_Second_Channel[1] == channel) || (QM_Second_Channel[2] == channel))
		{
        SIGNAL_MAX[channel-1] = 255;
        SIGNAL_MIN[channel-1] = 0;
		
		switch(channel){
			case 1:
				LPSIGNAL=SIGNAL1;
				break;
			case 2:
				LPSIGNAL=SIGNAL2;
				break;
			case 3:
				LPSIGNAL=SIGNAL3;
				break;
			case 4:
				LPSIGNAL=SIGNAL4;
				break;
		}
		
        for (cnt = 0; cnt < 256; cnt++) SIGNAL_Histo[cnt+(channel-1)*256] = 0;
//*******************************************************************************************
		for (cnt = ixs; cnt < ixss; cnt+=step)
		{
			SIGNAL_Histo[LPSIGNAL[cnt]+(channel-1)*256]++;

			if (SIGNAL_MAX[channel-1] > LPSIGNAL[cnt]) SIGNAL_MAX[channel-1] = LPSIGNAL[cnt];
			if (SIGNAL_MIN[channel-1] < LPSIGNAL[cnt]) SIGNAL_MIN[channel-1] = LPSIGNAL[cnt];
		}
        

        if (SIGNAL_MAX[channel-1] > SIGNAL_MIN[channel-1])
        {
            PBuf = SIGNAL_MAX[channel-1];
            SIGNAL_MAX[channel-1] = SIGNAL_MIN[channel-1];
            SIGNAL_MIN[channel-1] = PBuf;
        }
		#ifdef _Debug_QM_
		//printf("channel: %d SIGNAL_MAX[channel-1] %d, SIGNAL_MIN[channel-1] %d, ixs %d, ixss %d\n",channel,SIGNAL_MAX[channel-1],SIGNAL_MIN[channel-1],ixs,ixss);
		#endif


        SIGNAL_MDL[channel-1] = (SIGNAL_MIN[channel-1] + SIGNAL_MAX[channel-1]) >> 1;

        SIGNAL_TOP[channel-1] = 0;
        SIGNAL_BASE[channel-1] = 0;
        PBuf = 0;

        mid_buf = (int) ((SIGNAL_MIN[channel-1] + SIGNAL_MAX[channel-1]) / 2);

        for (cnt = 0; cnt < mid_buf; cnt++)
        {
            if (SIGNAL_Histo[cnt+(channel-1)*256] > PBuf)
            {
                PBuf = SIGNAL_Histo[cnt+(channel-1)*256];
                SIGNAL_TOP[channel-1] = cnt;
            }
        }

        PBuf = 0;

        for (cnt = 255; cnt > mid_buf; cnt--)
        {
            if (SIGNAL_Histo[cnt+(channel-1)*256] > PBuf)
            {
                PBuf = SIGNAL_Histo[cnt+(channel-1)*256];
                SIGNAL_BASE[channel-1] = cnt;
            }
        }

        if (SIGNAL_TOP[channel-1] > SIGNAL_BASE[channel-1])
        {
            PBuf = SIGNAL_TOP[channel-1];
            SIGNAL_TOP[channel-1] = SIGNAL_BASE[channel-1];
            SIGNAL_BASE[channel-1] = PBuf;
        }

        SIGNAL_THRES_UP[channel-1]  = (short) (SIGNAL_BASE[channel-1] - (((float) thres_up / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
        SIGNAL_THRES_MDL[channel-1] = (short) (SIGNAL_BASE[channel-1] - (((float) thres_mdl / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
        SIGNAL_THRES_LOW[channel-1] = (short) (SIGNAL_BASE[channel-1] - (((float) thres_low / 100) * (SIGNAL_BASE[channel-1] - SIGNAL_TOP[channel-1])));
#ifdef _Debug_QM_
        if (Debug_Mode)
        {
            printf("1 : tl %d tm %d tu %d\n", thres_low, thres_mdl, thres_up);
            printf("1 : THR2L %d THR2M %d THR2U %d \n", SIGNAL_THRES_LOW[channel-1], SIGNAL_THRES_MDL[channel-1], SIGNAL_THRES_UP[channel-1]);
            printf("1 : Top %d Base %d \n", SIGNAL_TOP[channel-1], SIGNAL_BASE[channel-1]);
            printf("1 : Min %d Mdl %d Max %d\n", SIGNAL_MIN[channel-1], SIGNAL_MDL[channel-1], SIGNAL_MAX[channel-1]);
        }
#endif
		SIGNAL_THRES_PRE_POSITIV_1[channel-1] = -1;
        SIGNAL_THRES_LOW_POSITIV_1[channel-1] = -1;
        SIGNAL_THRES_MDL_POSITIV_1[channel-1] = -1;
        SIGNAL_THRES_UP_POSITIV_1[channel-1] = -1;
        SIGNAL_THRES_OVER_POSITIV_1[channel-1] = -1;

        SIGNAL_THRES_PRE_NEGATIV_1[channel-1] = -1;
        SIGNAL_THRES_LOW_NEGATIV_1[channel-1] = -1;
        SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = -1;
        SIGNAL_THRES_UP_NEGATIV_1[channel-1] = -1;
        SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = -1;

        SIGNAL_THRES_PRE_POSITIV_2[channel-1] = -1;
        SIGNAL_THRES_LOW_POSITIV_2[channel-1] = -1;
        SIGNAL_THRES_MDL_POSITIV_2[channel-1] = -1;
        SIGNAL_THRES_UP_POSITIV_2[channel-1] = -1;
        SIGNAL_THRES_OVER_POSITIV_2[channel-1] = -1;

        SIGNAL_THRES_PRE_NEGATIV_2[channel-1] = -1;
        SIGNAL_THRES_LOW_NEGATIV_2[channel-1] = -1;
        SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = -1;
        SIGNAL_THRES_UP_NEGATIV_2[channel-1] = -1;
        SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = -1;

        SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = -1;
        SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = -1;
        SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = -1;
        SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = -1;
        SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = -1;

       
            for (cnt = ixs; cnt < ixss; cnt+=step)
            {
                if ((SIGNAL_THRES_MDL_POSITIV_1[channel-1] != 1) && (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] != -1))
                {
                    SIGNAL_AVG[channel-1] += (LPSIGNAL[cnt] - SIGNAL_THRES_MDL[channel-1]);
                    SIGNAL_AVG_CNT[channel-1]++;
                }

                if (SIGNAL_THRES_UP_POSITIV_1[channel-1] == -1)
                {
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_PRE_POSITIV_1[channel-1] = cnt;
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_1[channel-1] = cnt;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_1[channel-1] = cnt;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1))
                    {
                        SIGNAL_THRES_PRE_POSITIV_1[channel-1] = cnt ;
                        SIGNAL_THRES_LOW_POSITIV_1[channel-1] = -1;
                    }
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_1[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_1[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_1[channel-1] == -1)) SIGNAL_THRES_UP_POSITIV_1[channel-1] = cnt ;
                }
                if (SIGNAL_THRES_LOW_NEGATIV_1[channel-1] == -1)
                {
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = cnt ;
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_1[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_1[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1))
                    {
                        SIGNAL_THRES_OVER_NEGATIV_1[channel-1] = cnt ;
                        SIGNAL_THRES_UP_NEGATIV_1[channel-1] = -1;
                    }
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_1[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_1[channel-1] == -1)) SIGNAL_THRES_LOW_NEGATIV_1[channel-1] = cnt ;
                }
                if ((SIGNAL_THRES_UP_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] == -1))
                {
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_PRE_POSITIV_2[channel-1] = cnt ;
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_2[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_POSITIV_2[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1))
                    {
                        SIGNAL_THRES_PRE_POSITIV_2[channel-1] = cnt ;
                        SIGNAL_THRES_LOW_POSITIV_2[channel-1] = -1;
                    }
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_2[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_POSITIV_2[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] == -1)) SIGNAL_THRES_UP_POSITIV_2[channel-1] = cnt ;
                }
                if ((SIGNAL_THRES_LOW_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] == -1))
                {
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = cnt ;
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_2[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_UP_NEGATIV_2[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1))
                    {
                        SIGNAL_THRES_OVER_NEGATIV_2[channel-1] = cnt ;
                        SIGNAL_THRES_UP_NEGATIV_2[channel-1] = -1;
                    }
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_MDL_NEGATIV_2[channel-1] = cnt ;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] == -1)) SIGNAL_THRES_LOW_NEGATIV_2[channel-1] = cnt ;
                }


                if ((SIGNAL_THRES_UP_POSITIV_1[channel-1] != -1) && (SIGNAL_THRES_UP_POSITIV_2[channel-1] != -1))
                {
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_PRE_POSITIV = cnt ;
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_PRE_POSITIV != -1) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_LOW_POSITIV = cnt ;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_PRE_POSITIV != -1) && (SIGNAL_THRES_LOW_POSITIV == -1)) SIGNAL_THRES_LOW_POSITIV = cnt ;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1))
                    {
                        SIGNAL_THRES_PRE_POSITIV = cnt ;
                        SIGNAL_THRES_LOW_POSITIV = -1;
                    }
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1)) SIGNAL_THRES_MDL_POSITIV = cnt ;
                    else if ((LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_LOW_POSITIV != -1) && (SIGNAL_THRES_MDL_POSITIV == -1)) SIGNAL_THRES_MDL_POSITIV = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_MDL_POSITIV != -1) && (SIGNAL_THRES_UP_POSITIV == -1))
                    {
                        SIGNAL_THRES_UP_POSITIV = cnt ;

                        SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] = SIGNAL_THRES_PRE_POSITIV;
                        SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] = SIGNAL_THRES_LOW_POSITIV;
                        SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] = SIGNAL_THRES_MDL_POSITIV;
                        SIGNAL_THRES_UP_POSITIV_LAST[channel-1] = SIGNAL_THRES_UP_POSITIV;
                        SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] = SIGNAL_THRES_OVER_POSITIV;

                        SIGNAL_THRES_PRE_POSITIV = -1;
                        SIGNAL_THRES_LOW_POSITIV = -1;
                        SIGNAL_THRES_MDL_POSITIV = -1;
                        SIGNAL_THRES_UP_POSITIV = -1;
                        SIGNAL_THRES_OVER_POSITIV = -1;
                    }
                }


                if ((SIGNAL_THRES_LOW_NEGATIV_1[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] != -1))
                {
                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_OVER_NEGATIV = cnt ;
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_MDL[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV != -1) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_UP_NEGATIV = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_UP[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_OVER_NEGATIV != -1) && (SIGNAL_THRES_UP_NEGATIV == -1)) SIGNAL_THRES_UP_NEGATIV = cnt ;

                    if ((LPSIGNAL[cnt] < SIGNAL_THRES_UP[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1))
                    {
                        SIGNAL_THRES_OVER_NEGATIV = cnt ;
                        SIGNAL_THRES_UP_NEGATIV = -1;
                    }
                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] < SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1)) SIGNAL_THRES_MDL_NEGATIV = cnt ;
                    else if ((LPSIGNAL[cnt] > SIGNAL_THRES_MDL[channel-1]) && (LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_UP_NEGATIV != -1) && (SIGNAL_THRES_MDL_NEGATIV == -1)) SIGNAL_THRES_MDL_NEGATIV = cnt ;

                    if ((LPSIGNAL[cnt] > SIGNAL_THRES_LOW[channel-1]) && (SIGNAL_THRES_MDL_NEGATIV != -1) && (SIGNAL_THRES_LOW_NEGATIV == -1))
                    {
                        SIGNAL_THRES_LOW_NEGATIV = cnt ;

                        SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = SIGNAL_THRES_PRE_NEGATIV;
                        SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = SIGNAL_THRES_LOW_NEGATIV;
                        SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = SIGNAL_THRES_MDL_NEGATIV;
                        SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = SIGNAL_THRES_UP_NEGATIV;
                        SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = SIGNAL_THRES_OVER_NEGATIV;

                        SIGNAL_THRES_PRE_NEGATIV = -1;
                        SIGNAL_THRES_LOW_NEGATIV = -1;
                        SIGNAL_THRES_MDL_NEGATIV = -1;
                        SIGNAL_THRES_UP_NEGATIV = -1;
                        SIGNAL_THRES_OVER_NEGATIV = -1;
                    }
                }

                /*if ((SIGNAL_THRES_UP_POSITIV_2[channel-1] != -1) && (SIGNAL_THRES_LOW_NEGATIV_2[channel-1] != -1))
                {
                    break;
                } */
            }

            if (SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_PRE_POSITIV_LAST[channel-1] = SIGNAL_THRES_PRE_POSITIV_2[channel-1];
            if (SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_LOW_POSITIV_LAST[channel-1] = SIGNAL_THRES_LOW_POSITIV_2[channel-1];
            if (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_MDL_POSITIV_LAST[channel-1] = SIGNAL_THRES_MDL_POSITIV_2[channel-1];
            if (SIGNAL_THRES_UP_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_UP_POSITIV_LAST[channel-1] = SIGNAL_THRES_UP_POSITIV_2[channel-1];
            if (SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] == -1) SIGNAL_THRES_OVER_POSITIV_LAST[channel-1] = SIGNAL_THRES_OVER_POSITIV_2[channel-1];

            if (SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_PRE_NEGATIV_LAST[channel-1] = SIGNAL_THRES_PRE_NEGATIV_2[channel-1];
            if (SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1] = SIGNAL_THRES_LOW_NEGATIV_2[channel-1];
            if (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1] = SIGNAL_THRES_MDL_NEGATIV_2[channel-1];
            if (SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_UP_NEGATIV_LAST[channel-1] = SIGNAL_THRES_UP_NEGATIV_2[channel-1];
            if (SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] == -1) SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1] = SIGNAL_THRES_OVER_NEGATIV_2[channel-1];

#ifdef _Debug_QM_
            if (Debug_Mode)
            {
                printf("1 : ixs %d ixss %d tpud1 %d tpl1 %d tpm1 %d tpu1 %d\n", ixs, ixss, SIGNAL_THRES_PRE_POSITIV_1[channel-1], SIGNAL_THRES_LOW_POSITIV_1[channel-1], SIGNAL_THRES_MDL_POSITIV_1[channel-1], SIGNAL_THRES_UP_POSITIV_1[channel-1]);
                printf("1 : ixs %d ixss %d tnov1 %d tnl1 %d tnm1 %d tnu1 %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_1[channel-1], SIGNAL_THRES_LOW_NEGATIV_1[channel-1], SIGNAL_THRES_MDL_NEGATIV_1[channel-1], SIGNAL_THRES_UP_NEGATIV_1[channel-1]);
                printf("1 : ixs %d ixss %d tpud2 %d tpl2 %d tpm2 %d tpu2 %d\n", ixs, ixss, SIGNAL_THRES_PRE_POSITIV_2[channel-1], SIGNAL_THRES_LOW_POSITIV_2[channel-1], SIGNAL_THRES_MDL_POSITIV_2[channel-1], SIGNAL_THRES_UP_POSITIV_2[channel-1]);
                printf("1 : ixs %d ixss %d tnov2 %d tnl2 %d tnm2 %d tnu2 %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_2[channel-1], SIGNAL_THRES_LOW_NEGATIV_2[channel-1], SIGNAL_THRES_MDL_NEGATIV_2[channel-1], SIGNAL_THRES_UP_NEGATIV_2[channel-1]);
                printf("1 : ixs %d ixss %d tpovl %d tpll %d tpml %d tpul %d \n", ixs, ixss, SIGNAL_THRES_OVER_POSITIV_LAST[channel-1], SIGNAL_THRES_LOW_POSITIV_LAST[channel-1], SIGNAL_THRES_MDL_POSITIV_LAST[channel-1], SIGNAL_THRES_UP_POSITIV_LAST[channel-1]);
                printf("1 : ixs %d ixss %d tnovl %d tnll %d tnml %d tnul %d \n", ixs, ixss, SIGNAL_THRES_OVER_NEGATIV_LAST[channel-1], SIGNAL_THRES_LOW_NEGATIV_LAST[channel-1], SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1], SIGNAL_THRES_UP_NEGATIV_LAST[channel-1]);
            }
#endif
}	
	}

       
		


   
    QM_V_A_Buf[0] = 0;
    QM_H_A_Buf[0] = 0;

    if (QM_Type[0] > 0)
    {
        BufVal = Measure(0, (char) QM_Channel[0], (char) QM_Type[0], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);

        QM_Slot1.Write_Value(BufVal);
        QM_Slot1.Write_Unit(BufUnit);
#ifdef _Debug_QM_
//        printf("qm1 val : %f  unit : %s type : %d\n", BufVal, BufUnit, QM_Type[0]);
#endif

        //if (QM_Type[0] != QM_Type_Old[0])
        {
            QM_Slot1.Write_PreText(BufPre);
        }

        QM_Slot1.RenderText();

        QM_Changed[0] = 1;
    }

    if (QM_Type[1] > 0)
    {
        BufVal = Measure(1, (char) QM_Channel[1], (char) QM_Type[1], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);

        QM_Slot2.Write_Value(BufVal);
        QM_Slot2.Write_Unit(BufUnit);

        //if (QM_Type[1] != QM_Type_Old[1])
        {
            QM_Slot2.Write_PreText(BufPre);
        }

        QM_Slot2.RenderText();

        QM_Changed[1] = 1;
    }

    if (QM_Type[2] > 0)
    {
        BufVal = Measure(2, (char) QM_Channel[2], (char) QM_Type[2], &BufPre[0], &BufUnit[0], &BufReturn[0], &QM_V_A_Buf[0], &QM_H_A_Buf[0]);

        QM_Slot3.Write_Value(BufVal);
        QM_Slot3.Write_Unit(BufUnit);

        //if (QM_Type[2] != QM_Type_Old[2])
        {

            QM_Slot3.Write_PreText(BufPre);
        }

        QM_Slot3.RenderText();

        QM_Changed[2] = 1;
    }

    QM_Vertical_Active = QM_V_A_Buf[0];
    QM_Horizontal_Active = QM_H_A_Buf[0];

    Display::DRAW_ALL_CURSOR();
    Display::DRAWQMDATA(0);	

    //rot_int->np_piointerruptmask = 0x01;						
    //key_int->np_piointerruptmask = 0x01;    		
	//#undef _Debug_QM_
}
//##########################################################################################################################################################
// BF -> Measure changed by Stefan due to the changes in QM
float Display::Measure(char nr, char channel, char type, char *pretext, char *unittext, char *returntext, char *qm_vertical_active, char *qm_horizontal_active)
{
	float return_val = 0;
	int ixs, ixss, cnt, zero_buf = 0, off_buf = 0;

	char buf_text[30];
	char selectedVoltage=0,selectedVoltageSecondChannel=0;
	short s_max = 0;
	short s_mdl = 0;	
	short s_min = 0;
	short s_max_raw = 0;
	short s_mdl_raw = 0;	
	short s_min_raw = 0;	
	short s_top = 0;	
	short s_base = 0;

	short s_avg = 0;
	short s_avg_cnt = 0;    	
	
	short s_sec_mdl = 0;
	short s_sec_mdl_raw = 0;	
	
	short s_thres_up_negativ_1 = 0;
	short s_thres_up_positiv_1 = 0;

	short s_thres_low_negativ_1 = 0;
	short s_thres_low_positiv_1 = 0;

	short s_thres_mdl_negativ_1 = 0;
	short s_thres_mdl_positiv_1 = 0;

	short s_thres_mdl_negativ_2 = 0;
	short s_thres_mdl_positiv_2 = 0;

	short s_thres_mdl_negativ_last = 0;
	short s_thres_mdl_positiv_last = 0;	
    	
	short s_thres_sec_mdl_negativ_1 = 0;
	short s_thres_sec_mdl_positiv_1 = 0;

	short s_thres_sec_mdl_negativ_2 = 0;
	short s_thres_sec_mdl_positiv_2 = 0;	
	
   	
	short P1 = 0;
	short P2 = 0;
	short P3 = 0;
	short PBuf = 0;
	
	if (draw_factor==0)
		return 0;
	
	ixs=MemWinStart+Trigger_Offset_Calc;//left edge in mem
	ixss=ixs+GRID_WIDTH*draw_factor;
	

	switch(QM_Second_Channel[nr])
	{
		case 1:
			selectedVoltageSecondChannel=Selected_Voltage_CH1;
			break;
		case 2:
			selectedVoltageSecondChannel=Selected_Voltage_CH2;
			break;
		case 3:
			selectedVoltageSecondChannel=Selected_Voltage_CH3;
			break;
		case 4:
			selectedVoltageSecondChannel=Selected_Voltage_CH4;
			break;
		
	}
	// Prpare for delay measurment
	if ((type == 3) || (type == 12))
	{

			s_thres_sec_mdl_negativ_1 = SIGNAL_THRES_MDL_NEGATIV_1[QM_Second_Channel[nr]];
			s_thres_sec_mdl_positiv_1 = SIGNAL_THRES_MDL_POSITIV_1[QM_Second_Channel[nr]];
			s_thres_sec_mdl_negativ_2 = SIGNAL_THRES_MDL_NEGATIV_2[QM_Second_Channel[nr]];
			s_thres_sec_mdl_positiv_2 = SIGNAL_THRES_MDL_POSITIV_2[QM_Second_Channel[nr]];
	
			s_sec_mdl = (int)((float)(SIGNAL_MDL[channel-1]-ADC_ZERO)*scale_factor[selectedVoltageSecondChannel])+GRID_HEIGHT/2;
			s_sec_mdl_raw = SIGNAL_MDL[channel-1];
	
		
	}	
		
	switch(channel)
	{
		case 1:
			selectedVoltage=Selected_Voltage_CH1;
			zero_buf=ZeroLevelCH1;
			break;
		case 2:
			selectedVoltage=Selected_Voltage_CH2;
			zero_buf=ZeroLevelCH2;
			break;
		case 3:
			selectedVoltage=Selected_Voltage_CH3;
			zero_buf=ZeroLevelCH3;
			break;
		case 4:
			selectedVoltage=Selected_Voltage_CH4;
			zero_buf=ZeroLevelCH4;
			break;
		
	}
		s_max = (int)((float)(SIGNAL_MAX[channel-1]-ADC_ZERO)*scale_factor[selectedVoltage])+GRID_HEIGHT/2;
		s_mdl = (int)((float)(SIGNAL_MDL[channel-1]-ADC_ZERO)*scale_factor[selectedVoltage])+GRID_HEIGHT/2;;
		s_min = (int)((float)(SIGNAL_MIN[channel-1]-ADC_ZERO )*scale_factor[selectedVoltage])+GRID_HEIGHT/2;
		
		s_max_raw = SIGNAL_MAX[channel-1];
		s_mdl_raw = SIGNAL_MDL[channel-1];
		s_min_raw = SIGNAL_MIN[channel-1];
		
		s_top = (int)((float)(SIGNAL_TOP[channel-1]-ADC_ZERO )*scale_factor[selectedVoltage])+GRID_HEIGHT/2;
		s_base = (int)((float)(SIGNAL_BASE[channel-1]-ADC_ZERO)*scale_factor[selectedVoltage])+GRID_HEIGHT/2;
	
		s_avg = SIGNAL_AVG[channel-1];
		s_avg_cnt = SIGNAL_AVG_CNT[channel-1];
	
		s_thres_up_negativ_1 = (SIGNAL_THRES_UP_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_up_positiv_1 = (SIGNAL_THRES_UP_POSITIV_1[channel-1]-ixs)/draw_factor;
	
		s_thres_low_negativ_1 = (SIGNAL_THRES_LOW_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_low_positiv_1 = (SIGNAL_THRES_LOW_POSITIV_1[channel-1]-ixs)/draw_factor;
	
		s_thres_mdl_negativ_1 = (SIGNAL_THRES_MDL_NEGATIV_1[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_1 = (SIGNAL_THRES_MDL_POSITIV_1[channel-1]-ixs)/draw_factor;
	
		s_thres_mdl_negativ_2 = (SIGNAL_THRES_MDL_NEGATIV_2[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_2 = (SIGNAL_THRES_MDL_POSITIV_2[channel-1]-ixs)/draw_factor;
	
		s_thres_mdl_negativ_last = (SIGNAL_THRES_MDL_NEGATIV_LAST[channel-1]-ixs)/draw_factor;
		s_thres_mdl_positiv_last = (SIGNAL_THRES_MDL_POSITIV_LAST[channel-1]-ixs)/draw_factor;
	
		//printf("channel: %d, s_thres_mdl_positiv_1: %d, SIGNAL_THRES_MDL_POSITIV_1[channel-1]: %d, ixs: %d, draw_factor: %d trigger_offset: %d\n",channel,s_thres_mdl_positiv_1,SIGNAL_THRES_MDL_POSITIV_1[channel-1],ixs,draw_factor,Trigger_Offset_Calc);
/*
		case 5:
		{
		off_buf = 0;
		zero_buf = 128;
		s_max = (SIGNALM_MAX << 1) - 64 + off_buf;
		s_mdl = (SIGNALM_MDL << 1) - 64 + off_buf;
		s_min = (SIGNALM_MIN << 1) - 64 + off_buf;
		s_max_raw = SIGNALM_MAX;
		s_mdl_raw = SIGNALM_MDL;
		s_min_raw = SIGNALM_MIN;
		s_top = (SIGNALM_TOP << 1) - 64 + off_buf;
		s_base = (SIGNALM_BASE << 1) - 64 + off_buf;
	
		s_avg = SIGNALM_AVG;
		s_avg_cnt = SIGNALM_AVG_CNT;
	
		s_thres_up_negativ_1 = SIGNALM_THRES_UP_NEGATIV_1;
		s_thres_up_positiv_1 = SIGNALM_THRES_UP_POSITIV_1;
	
		s_thres_low_negativ_1 = SIGNALM_THRES_LOW_NEGATIV_1;
		s_thres_low_positiv_1 = SIGNALM_THRES_LOW_POSITIV_1;
	
		s_thres_mdl_negativ_1 = SIGNALM_THRES_MDL_NEGATIV_1;
		s_thres_mdl_positiv_1 = SIGNALM_THRES_MDL_POSITIV_1;
	
		s_thres_mdl_negativ_2 = SIGNALM_THRES_MDL_NEGATIV_2;
		s_thres_mdl_positiv_2 = SIGNALM_THRES_MDL_POSITIV_2;
	*/

	


	switch(type)
	{
		case 1:    // Average
		{
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_mdl_negativ_last;
	
		QM_Horizontal_Position_Real1 = int (float (s_avg) / float (s_avg_cnt)) + s_mdl;
	
		//return_val = MEASUREVOLTAGE(channel, (int) (zero_buf - QM_Horizontal_Position_Real1), unittext);
		return_val = MEASUREVOLTAGE(channel, (int) (zero_buf - QM_Horizontal_Position_Real1));
		sprintf(unittext, "V");
	
		qm_horizontal_active[0] = 5;
		qm_vertical_active[0] = 3;
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Average [ = "); break;
			case 2 : sprintf(pretext, "Average \\ = "); break;
			case 3 : sprintf(pretext, "Average ] = "); break;
			case 4 : sprintf(pretext, "Average ^ = "); break;
			case 5 : sprintf(pretext, "Average (M) = "); break;
		}
	
		break;
		}
		case 2:  // Delay - Done
		{
		QM_Horizontal_Position_Real1 = s_mdl;
		QM_Horizontal_Position_Real2 = s_sec_mdl;
	
		if ((QM_CHI_Edge[nr] == 1) && (QM_CHII_Edge[nr] == 1))
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
		}
		else if ((QM_CHI_Edge[nr] == 1) && (QM_CHII_Edge[nr] == 2))
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
			QM_Vertical_Position_Real2 = s_thres_sec_mdl_negativ_1;
		}
		else if ((QM_CHI_Edge[nr] == 2) && (QM_CHII_Edge[nr] == 1))
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
			QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
		}
		else if ((QM_CHI_Edge[nr] == 2) && (QM_CHII_Edge[nr] == 2))
		{
			QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
			QM_Vertical_Position_Real2 = s_thres_sec_mdl_negativ_1;
		}
	
		//return_val = MEASURETIME(1, (int) (QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1), unittext);
		return_val = MEASURETIME(1, (int) (QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1));
		sprintf(unittext, "s");
	
		qm_horizontal_active[0] = 3;
		qm_vertical_active[0] = 3;
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Delay [ = "); break;
			case 2 : sprintf(pretext, "Delay \\ = "); break;
			case 3 : sprintf(pretext, "Delay ] = "); break;
			case 4 : sprintf(pretext, "Delay ^ = "); break;
			case 5 : sprintf(pretext, "Delay (M) = "); break;
		}
	
		break;
		}
		case 3:  // Duty Cycle - Done
		{
	
		QM_Horizontal_Position_Real1 = s_mdl;
	
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
	
		qm_horizontal_active[0] = 5;
		qm_vertical_active[0] = 3;
	
		if (s_thres_mdl_negativ_1 > s_thres_mdl_positiv_1) return_val = (100 / (float (s_thres_mdl_positiv_2) - float (s_thres_mdl_positiv_1))) * (float (s_thres_mdl_negativ_1) - float (s_thres_mdl_positiv_1));
		else return_val = (100 / (float (s_thres_mdl_positiv_2) - float (s_thres_mdl_positiv_1))) * (float (s_thres_mdl_negativ_2) - float (s_thres_mdl_positiv_1));
	
		sprintf(unittext, "%%");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "DutyCycle [ = "); break;
			case 2 : sprintf(pretext, "DutyCycle \\ = "); break;
			case 3 : sprintf(pretext, "DutyCycle ] = "); break;
			case 4 : sprintf(pretext, "DutyCycle ^ = "); break;
			case 5 : sprintf(pretext, "DutyCycle (M) = "); break;
		}
	
		break;
		}
		case 4:  // Fall Time - Done
		{
		QM_Vertical_Position_Real1 = s_thres_up_negativ_1;
		QM_Vertical_Position_Real2 = s_thres_low_negativ_1;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(1, (int) abs(s_thres_low_negativ_1 - s_thres_up_negativ_1), unittext);
		return_val = MEASURETIME(1, (int) abs(s_thres_low_negativ_1 - s_thres_up_negativ_1));
		sprintf(unittext, "s");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "FallTime [ = "); break;
			case 2 : sprintf(pretext, "FallTime \\ = "); break;
			case 3 : sprintf(pretext, "FallTime ] = "); break;
			case 4 : sprintf(pretext, "FallTime ^ = "); break;
			case 5 : sprintf(pretext, "FallTime (M) = "); break;
		}
	
		break;
		}
		case 5:  // Frequency - Done
		{
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(2, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1), unittext);
		return_val = MEASURETIME(2, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1));
		sprintf(unittext, "Hz");
	
		//printf("schafft er nicht!\r\n");
				int temp = (int) return_val * 100;
		sprintf(buf_text, "=%d.%2d", temp/100, temp%100);
		//printf("DOCH!\r\n");
	
		if (buf_text[0] == 'I') return_val = 0.0;
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Freq [ = "); break;
			case 2 : sprintf(pretext, "Freq \\ = "); break;
			case 3 : sprintf(pretext, "Freq ] = "); break;
			case 4 : sprintf(pretext, "Freq ^ = "); break;
			case 5 : sprintf(pretext, "Freq (M) = "); break;
		}
	
		break;
		}
		case 6:   // Maximum - Done
		{
		QM_Horizontal_Position_Real1 = s_max;
		QM_Horizontal_Position_Real2 = s_min;
	
		qm_horizontal_active[0] = 5;
		qm_vertical_active[0] = 0;
	
		//return_val = MEASUREVOLTAGE(channel, (int) abs(s_max - zero_buf), unittext);
		return_val = MEASUREVOLTAGE(channel, (int) abs(s_max - zero_buf));
	
		sprintf(unittext, "V");
	
		if (s_max > zero_buf) return_val = 0 - return_val;         // Verbesserbar. - Werte direkt verarbeiten
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Max [ = "); break;
			case 2 : sprintf(pretext, "Max \\ = "); break;
			case 3 : sprintf(pretext, "Max ] = "); break;
			case 4 : sprintf(pretext, "Max ^ = "); break;
			case 5 : sprintf(pretext, "Max (M) = "); break;
		}
		break;
		}
		case 7:  // Minimum - Done
		{
		QM_Horizontal_Position_Real1 = s_max;
		QM_Horizontal_Position_Real2 = s_min;
	
		qm_horizontal_active[0] = 6;
		qm_vertical_active[0] = 0;
	
		//return_val = MEASUREVOLTAGE(channel, (int) abs(s_min - zero_buf), unittext);
		return_val = MEASUREVOLTAGE(channel, (int) abs(s_min - zero_buf));
	
		sprintf(unittext, "V");
	
		if (s_min > zero_buf) return_val = 0 - return_val;          // Verbesserbar. - Werte direkt verarbeiten
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Min [ = "); break;
			case 2 : sprintf(pretext, "Min \\ = "); break;
			case 3 : sprintf(pretext, "Min ] = "); break;
			case 4 : sprintf(pretext, "Min ^ = "); break;
			case 5 : sprintf(pretext, "Min (M) = "); break;
		}
	
		break;
		}
		case 8:   // Peak-Peak - Done
		{
		QM_Horizontal_Position_Real1 = s_max;
		QM_Horizontal_Position_Real2 = s_min;
	
		qm_horizontal_active[0] = 3;
		qm_vertical_active[0] = 0;
	
		//return_val = MEASUREVOLTAGE(channel, (int) (s_min - s_max), unittext);
		return_val = MEASUREVOLTAGE(channel, (int) (s_min - s_max));
		sprintf(unittext, "V");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Pk-Pk [ = "); break;
			case 2 : sprintf(pretext, "Pk-Pk \\ = "); break;
			case 3 : sprintf(pretext, "Pk-Pk ] = "); break;
			case 4 : sprintf(pretext, "Pk-Pk ^ = "); break;
			case 5 : sprintf(pretext, "Pk-Pk (M) = "); break;
		}
	
		break;
		}
		case 9:   // Period - Done
		{
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(1, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1), unittext);
		return_val = MEASURETIME(1, (int) abs(s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1));
		sprintf(unittext, "s");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Period [ = "); break;
			case 2 : sprintf(pretext, "Period \\ = "); break;
			case 3 : sprintf(pretext, "Period ] = "); break;
			case 4 : sprintf(pretext, "Period ^ = "); break;
			case 5 : sprintf(pretext, "Period (M) = "); break;
		}
	
		break;
		}
		case 10:  // Phase - Done
		{
		QM_Horizontal_Position_Real1 = s_mdl;
		QM_Horizontal_Position_Real2 = s_sec_mdl;
	
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_sec_mdl_positiv_1;
	
		return_val = ((float) (s_thres_sec_mdl_positiv_1 - s_thres_mdl_positiv_1) / (float) (s_thres_mdl_positiv_2 - s_thres_mdl_positiv_1)) * 360;
	
		qm_horizontal_active[0] = 3;
		qm_vertical_active[0] = 3;
	
		sprintf(unittext, "Deg");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "Phase [ = "); break;
			case 2 : sprintf(pretext, "Phase \\ = "); break;
			case 3 : sprintf(pretext, "Phase ] = "); break;
			case 4 : sprintf(pretext, "Phase ^ = "); break;
			case 5 : sprintf(pretext, "Phase (M) = "); break;
		}
	
		break;
		}
		case 11:  // Rise Time - Done
		{
		QM_Vertical_Position_Real1 = s_thres_low_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_up_positiv_1;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(1, (int) abs(s_thres_up_positiv_1 - s_thres_low_positiv_1), unittext);
		return_val = MEASURETIME(1, (int) abs(s_thres_up_positiv_1 - s_thres_low_positiv_1));
		sprintf(unittext, "s");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "RiseTime [ = "); break;
			case 2 : sprintf(pretext, "RiseTime \\ = "); break;
			case 3 : sprintf(pretext, "RiseTime ] = "); break;
			case 4 : sprintf(pretext, "RiseTime ^ = "); break;
			case 5 : sprintf(pretext, "RiseTime (M) = "); break;
		}
	
		break;
		}
		case 12:  // RMS
		{
		///QM_Horizontal_Position_Real1 = zero_buf - (int (float (zero_buf - s_max) / 1.414));
		QM_Horizontal_Position_Real1 = (int (float (zero_buf - s_max) / 1.414));
	
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		QM_Vertical_Position_Real2 = s_thres_mdl_positiv_last;
	
		qm_horizontal_active[0] = 5;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASUREVOLTAGE(channel, (int) abs(QM_Horizontal_Position_Real1 - zero_buf), unittext);
		///return_val = MEASUREVOLTAGE(channel, (int) abs(QM_Horizontal_Position_Real1 - zero_buf));
		return_val = MEASUREVOLTAGE(channel, (int) abs(QM_Horizontal_Position_Real1));
		sprintf(unittext, "V");
	
		if (QM_Horizontal_Position_Real1 > zero_buf) return_val = 0 - return_val;         // Verbesserbar. - Werte direkt verarbeiten
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "RMS [ = "); break;
			case 2 : sprintf(pretext, "RMS \\ = "); break;
			case 3 : sprintf(pretext, "RMS ] = "); break;
			case 4 : sprintf(pretext, "RMS ^ = "); break;
			case 5 : sprintf(pretext, "RMS (M) = "); break;
		}
	
		break;
		}
		case 13:  // + Width - Done
		{
		QM_Vertical_Position_Real1 = s_thres_mdl_positiv_1;
		if (s_thres_mdl_positiv_1 < s_thres_mdl_negativ_1) QM_Vertical_Position_Real2 = s_thres_mdl_negativ_1;
		else QM_Vertical_Position_Real2 = s_thres_mdl_negativ_2;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - s_thres_mdl_positiv_1), unittext);
		return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - s_thres_mdl_positiv_1));
		sprintf(unittext, "s");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "+Width [ = "); break;
			case 2 : sprintf(pretext, "+Width \\ = "); break;
			case 3 : sprintf(pretext, "+Width ] = "); break;
			case 4 : sprintf(pretext, "+Width ^ = "); break;
			case 5 : sprintf(pretext, "+Width (M) = "); break;
		}
	
		break;
		}
		case 14:  // - Width - Done
		{
		QM_Vertical_Position_Real1 = s_thres_mdl_negativ_1;
		if (s_thres_mdl_negativ_1 < s_thres_mdl_positiv_1) QM_Vertical_Position_Real2 = s_thres_mdl_positiv_1;
		else QM_Vertical_Position_Real2 = s_thres_mdl_positiv_2;
	
		qm_horizontal_active[0] = 0;
		qm_vertical_active[0] = 3;
	
		//return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1), unittext);
		return_val = MEASURETIME(1, (int) abs(QM_Vertical_Position_Real2 - QM_Vertical_Position_Real1));
		sprintf(unittext, "s");
	
		switch(channel)
		{
			case 1 : sprintf(pretext, "-Width [ = "); break;
			case 2 : sprintf(pretext, "-Width \\ = "); break;
			case 3 : sprintf(pretext, "-Width ] = "); break;
			case 4 : sprintf(pretext, "-Width ^ = "); break;
			case 5 : sprintf(pretext, "-Width (M) = "); break;
		}
		break;
		}
	}
	return return_val;
}
//##########################################################################################################################################################

//float Display::MEASUREVOLTAGE(char channel, int points, char *UnitString)			// Calculate the Voltage String
float Display::MEASUREVOLTAGE(char channel, int points)						// Calculate the Voltage String
{
	short *fprobe = 0;
	short *funits = 0;	
	volatile char *fselected_voltage = 0;	
	
	char dim = 2;
	
	int cmpvar = 0;
	
	float sfactor = 0;
	float ffactor = 0;	
	float result = 0;	
	
	float floattempad;
	int inttempbd;
	int inttempad;
			
	int xe;
	
printf("Display::MEASUREVOLTAGE(char channel, int points)\r\n");

	switch (channel)
	{
		case 1:
		{
			fprobe = &MenuStatus[1][3];
			fselected_voltage = &Selected_Voltage_CH1;
			break;
		}	
		case 2:
		{
			fprobe = &MenuStatus[2][3];
			fselected_voltage = &Selected_Voltage_CH2;
			break;
		}
		case 3:
		{
			fprobe = &MenuStatus[3][3];
			fselected_voltage = &Selected_Voltage_CH3;
			break;
		}
		case 4:
		{
			fprobe = &MenuStatus[4][3];
			fselected_voltage = &Selected_Voltage_CH4;
			break;
		}		
		case 5:
		{
            		// Solange noch kein multiplizieren Channel 1 dominant
			fprobe = (short *) 104;
			if (MenuStatus[26][2] == 1) fselected_voltage = (volatile char *) math_mul_scale - 166;
			if (MenuStatus[26][3] == 1) fselected_voltage = (volatile char *) math_sub_scale - 150;
			if (MenuStatus[26][4] == 1) fselected_voltage = (volatile char *) math_add_scale - 150;
			break;
		}		
	}

	switch ((int) *fselected_voltage)
	{
		case 0:
		{
			sfactor = 0.001;
			break;
		}
		case 1:
		{
			sfactor = 0.002;
			break;
		}
		case 2:
		{
			sfactor = 0.005;
			break;
		}
		case 3:
		{
			sfactor = 0.01;
			break;
		}
		case 4:
		{
			sfactor = 0.02;
			break;
		}
		case 5:
		{
			sfactor = 0.05;
			break;
		}
		case 6:
		{
			sfactor = 0.1;
			break;
		}
		case 7:
		{
			sfactor = 0.2;
			break;
		}
		case 8:
		{
			sfactor = 0.5;
			break;
		}
		case 9:
		{
			sfactor = 1;
			break;
		}
		case 10:
		{
			sfactor = 2;
			break;
		}
		case 11:
		{
			sfactor = 5;
			break;
		}	             		
		case 12:
		{
			sfactor = 10;
			break;
		}
		case 13:
		{
			sfactor = 20;
			break;
		}
		case 14:
		{
			sfactor = 50;
			break;
		}
		case 15:
		{
			sfactor = 100;
			break;
		}                        		
	}
	
	switch ((int) *fprobe)
	{
		case 101:
		{
			ffactor = 0.1;
			break;
		}
		case 102:
		{
			ffactor = 0.2;
			break;
		}
		case 103:
		{
			ffactor = 0.5;
			break;
		}
		case 104:
		{
			ffactor = 1;
			break;
		}
		case 105:
		{
			ffactor = 2;
			break;
		}
		case 106:
		{
			ffactor = 5;
			break;
		}
		case 107:
		{
			ffactor = 10;
			break;
		}
		case 108:
		{
			ffactor = 20;
			break;
		}
		case 109:
		{
			ffactor = 50;
			break;
		}
		case 110:
		{
			ffactor = 100;
			break;
		}
		case 111:
		{
			ffactor = 200;
			break;
		}
		case 112:
		{
			ffactor = 500;
			break;
		}
		case 113:
		{
			ffactor = 1000;
			break;
		}
	}

	result = ((sfactor * ffactor) / 48) * points;	
	/*	
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result > 999)
	{
		result = result / 1000;
		dim++;
	}
	
	switch(dim)
	{
	   case 0 : sprintf(UnitString, "&V"); break;
	   case 1 : sprintf(UnitString, "mV"); break;
	   case 2 : sprintf(UnitString, "V"); break;
	   case 3 : sprintf(UnitString, "kV"); break;
    }
    */
    //sprintf(UnitString, "V");

#ifdef _Debug_QM_
    printf("MV dim %d  %s\n", dim, UnitString);
#endif

    return result;	
}
//##########################################################################################################################################################

float Display::MEASURETIME(char sec_hz, int points)
{
	int time = 0;
	
	float tfactor = 0;
	float timeoff = 0;

	char dim = 3;
		
	tfactor = TimeBaseFactor[Display_Timebase] / 1000000;
	
	//tfactor = tfactor / 1000000 / ZFT_float;
	
	timeoff = (float)(points) * tfactor;
	
	if (sec_hz == 1)
	{   /*
        if (timeoff < 1)
        {
            timeoff = timeoff * 1000;
            dim--;
        }
        if (timeoff < 1)
        {
            timeoff = timeoff * 1000;
            dim--;
        }
        if (timeoff < 1)
        {
            timeoff = timeoff * 1000;
            dim--;
        }
        	
        switch(dim)
        {
            case 0 : sprintf(UnitString, "ns"); break;
            case 1 : sprintf(UnitString, "&s"); break;
            case 2 : sprintf(UnitString, "ms"); break;
            case 3 : sprintf(UnitString, "s"); break;
        }	
        */
        //sprintf(UnitString, "s");

#ifdef _Debug_QM_
        printf("MT1 dim %d  %s\n", dim, UnitString);
#endif
    }
    else
	{
        timeoff = 1 / timeoff;
         /*
        if (timeoff > 999.99999)
        {
            timeoff = timeoff / 1000;
            dim--;
        }
        if (timeoff > 999.99999)
        {
            timeoff = timeoff / 1000;
            dim--;
        }
        if (timeoff > 999.99999)
        {
            timeoff = timeoff / 1000;
            dim--;
        }	
	    */    /*
        switch(dim)
        {
            case 0 : sprintf(UnitString, "GHz"); break;
            case 1 : sprintf(UnitString, "MHz"); break;
            case 2 : sprintf(UnitString, "kHz"); break;
            case 3 : sprintf(UnitString, "Hz"); break;
        }   */
        //sprintf(UnitString, "Hz");

#ifdef _Debug_QM_
        printf("MT2 dim %d  %s\n", dim, UnitString);	
#endif
    }

    return timeoff;
}
//##########################################################################################################################################################

void Display::CALCTRIGGER(void)
{
	int volt = 0;		
	int voltmfactor = 0;
	
	int tpos = 0;
	double vfactor = 0;	
	double vfactor2 = 0;	
	float voltoff = 0;
			
	switch(Selected_Trigger_Source)
	{
		case 1:
		{				
			volt = Selected_Voltage_CH1;
			voltmfactor = MenuStatus[1][3];
			tpos = ZeroLevelCH1 - Trigger_Pos_CH1;
			break;
		}
		case 2:
		{				
			volt = Selected_Voltage_CH2;
			voltmfactor = MenuStatus[2][3];
			tpos = ZeroLevelCH2 - Trigger_Pos_CH2;
			break;
		}
		case 3:
		{				
			volt = Selected_Voltage_CH3;
			voltmfactor = MenuStatus[3][3];
			tpos = ZeroLevelCH3 - Trigger_Pos_CH3;
			break;
		}
		case 4:
		{				
			volt = Selected_Voltage_CH4;
			voltmfactor = MenuStatus[4][3];
			tpos = ZeroLevelCH4 - Trigger_Pos_CH4;
			break;
		}
		case 5:
		{				
			volt = 7;
			voltmfactor = MenuStatus[12][4];
			tpos = Trigger_Pos_CHE - 15;
			break;
		}		
	}
	
	
	if (Selected_Trigger_Source == 5)
	{		
		switch(voltmfactor)
		{
			case 101: vfactor2 = 0.1; break;	
			case 102: vfactor2 = 0.2; break;
			case 103: vfactor2 = 0.5; break;
			case 104: vfactor2 = 1; break;
			case 105: vfactor2 = 2; break;
			case 106: vfactor2 = 5; break;
			case 107: vfactor2 = 10; break;
			case 108: vfactor2 = 20; break;
			case 109: vfactor2 = 50; break;
			case 110: vfactor2 = 100; break;
			case 111: vfactor2 = 200; break;
			case 112: vfactor2 = 500; break;
			case 113: vfactor2 = 1000; break;
		}
		
		voltoff = Extern_Trigger_Strs[Trigger_Pos_CHE] * vfactor2;
		
        Trigger_ExtLevel_Str.Write_Value(voltoff);	
        Trigger_ExtLevel_Str.RenderText();			
    }
    else
    {	  	
	
        if ((Selected_Trigger_Source != ct_Selected_Trigger_Source_buf) || (volt != ct_volt_buf) || (voltmfactor != ct_voltmfactor_buf))
        {	
            // Start calculate horizontal Data
				
            switch(volt)
            {
                case 0 : vfactor = 20.833333; break;
                case 1 : vfactor = 41.666666; break;
                case 2 : vfactor = 104.166666; break;
                case 3 : vfactor = 208.333333; break;
                case 4 : vfactor = 416.666666; break;
                case 5 : vfactor = 1041.666666; break;
                case 6 : vfactor = 2083.333333; break;
                case 7 : vfactor = 4166.666666; break;
                case 8 : vfactor = 10416.66666; break;
                case 9 : vfactor = 20833.33333; break;
                case 10 : vfactor = 41666.66666; break;
                case 11 : vfactor = 104166.6666; break;
            }
		
            vfactor = vfactor / 1000000;
		
            switch(voltmfactor)
            {
                case 101: vfactor2 = 0.1; break;	
                case 102: vfactor2 = 0.2; break;
                case 103: vfactor2 = 0.5; break;
                case 104: vfactor2 = 1; break;
                case 105: vfactor2 = 2; break;
                case 106: vfactor2 = 5; break;
                case 107: vfactor2 = 10; break;
                case 108: vfactor2 = 20; break;
                case 109: vfactor2 = 50; break;
                case 110: vfactor2 = 100; break;
                case 111: vfactor2 = 200; break;
                case 112: vfactor2 = 500; break;
                case 113: vfactor2 = 1000; break;
            }	
		
            ct_Selected_Trigger_Source_buf = Selected_Trigger_Source;
            ct_volt_buf = volt;
            ct_voltmfactor_buf = voltmfactor;
            ct_vfactor_buf = vfactor;
            ct_vfactor2_buf = vfactor2;			
        }
        else
        {
            vfactor = ct_vfactor_buf;
            vfactor2 = ct_vfactor2_buf;
        }

        voltoff = (float)(tpos) * vfactor;
        voltoff = voltoff * vfactor2;

        Trigger_Level_Str.Write_Value(voltoff);	
        Trigger_Level_Str.RenderText();	
    }	
}
//##########################################################################################################################################################
// BF fixed wrong pre trigger calculation. Calculation and timebase table changed.
// BF -> changed to indexed array fetch!!
void Display::CALCPRETRIGGER(void)
{
	float timeoff = 0;

	//timeoff = (float)(Trig_Pos_Mem - MemStartOffs) / SampleRate[Selected_Timebase];
	timeoff = (float)(Trig_Pos_Mem - MemStartOffs) / SampleRate[Display_Timebase];
	Trigger_Offset_Str.Write_Value(timeoff);
	Trigger_Offset_Str.RenderText();

}
//##########################################################################################################################################################
// BF -> changed to indexed array fetch!!
/* -> not used
void Display::CALCTIMEBASE(void)
{
	int time = 0;
	
	float tfactor = 0;
	float timeoff = 0;
		
	tfactor = TimeBaseFactor[Display_Timebase] / 1000000;
	
	timeoff = (float)(Timebase_Offset_Pos) * tfactor;  // Mitte ist 300
	
	Timebase_Offset_Str.Write_Value(timeoff);
	Timebase_Offset_Str.RenderText();
//BFTEST
/*
	printf("******************************************************************\r\n");
	printf("calculating timebase...\r\n");
	printf("timeoff = Timebase_Offset_Pos * tfactor  / 1000000\r\n\r\n");
	
	printf("Timeoffset          = "); floatprintf(timeoff); printf("\r\n");
	printf("Timebase_Offset_Pos = %d\r\n",Timebase_Offset_Pos);
	printf("tfactor             = "); floatprintf(tfactor); printf("\r\n");
	printf("******************************************************************\r\n");
*/
//}

//##########################################################################################################################################################

void Display::CALCVOLTAGE(char channel, char *String)				// Calculate the Voltage String
{
	short fprobe = 0;
	char fselected_voltage = 0;	
	
	char dim = 2;
	
	int cmpvar = 0;
	
	float sfactor = 0;
	float ffactor = 0;	
	float result = 0;	
	
	float floattempad;
	int inttempbd;
	int inttempad;
	
	char DimString[4];
		
	int xe;
	

	//BF set log dimension
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{
		sprintf(String, "10dBm/");
		return;
	}	


	switch (channel)
	{
		case 1:
		{
			fprobe = MenuStatus[1][3];
			fselected_voltage = Selected_Voltage_CH1;
			break;
		}	
		case 2:
		{
			fprobe = MenuStatus[2][3];
			fselected_voltage = Selected_Voltage_CH2;
			break;
		}
		case 3:
		{
			fprobe = MenuStatus[3][3];
			fselected_voltage = Selected_Voltage_CH3;
			break;
		}
		case 4:
		{
			fprobe = MenuStatus[4][3];
			fselected_voltage = Selected_Voltage_CH4;
			break;
		}
	}

	switch (fselected_voltage)
	{
		case 0:
		{
			sfactor = 0.001;
			break;
		}
		case 1:
		{
			sfactor = 0.002;
			break;
		}
		case 2:
		{	
			sfactor = 0.005;
			break;
		}
		case 3:
		{
			sfactor = 0.01;
			break;
		}
		case 4:
		{
			sfactor = 0.02;
			break;
		}
		case 5:
		{	
			sfactor = 0.05;
			break;
		}
		case 6:
		{
			sfactor = 0.1;
			break;
		}
		case 7:
		{
			sfactor = 0.2;
			break;
		}
		case 8:
		{
			sfactor = 0.5;
			break;
		}
		case 9:
		{
			sfactor = 1;
			break;
		}
		case 10:
		{
			sfactor = 2;
			break;
		}
		case 11:
		{
			sfactor = 5;
			break;
		}	
	}
	
	switch (fprobe)
	{
		case 101:
		{
			ffactor = 0.1;
			break;
		}
		case 102:
		{
			ffactor = 0.2;
			break;
		}
		case 103:
		{
			ffactor = 0.5;
			break;
		}
		case 104:
		{
			ffactor = 1;
			break;
		}
		case 105:
		{
			ffactor = 2;
			break;
		}
		case 106:
		{
			ffactor = 5;
			break;
		}
		case 107:
		{
			ffactor = 10;
			break;
		}
		case 108:
		{
			ffactor = 20;
			break;
		}
		case 109:
		{
			ffactor = 50;
			break;
		}
		case 110:
		{
			ffactor = 100;
			break;
		}
		case 111:
		{
			ffactor = 200;
			break;
		}
		case 112:
		{
			ffactor = 500;
			break;
		}
		case 113:
		{
			ffactor = 1000;
			break;
		}
	}

	if(FFT_Mode != FFT_OFF )
	sfactor /= 2;

	result = sfactor * ffactor;	
		
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result < 1)
	{
		result = result * 1000;
		dim--;
	}
	if (result > 500)
	{
		result = result / 1000;
		dim++;
	}

	//sprintf(DimString, "");
	for (xe = 0; xe < 3; xe++)
	{
		DimString[xe] = VoltageData[dim][xe];
	}
	DimString[3] = 0;	
	
	// Copy Float to Integer
	cmpvar = (int) result;
	
#ifdef _Debug_	
//	printf("Res %f cmpvar %f\n", result, (float) cmpvar);
#endif		
	// Compare if there is a after Dot integer
	if ((float) cmpvar == result)
    	{
        	sprintf(String, "%3d %s", cmpvar, DimString);
    	}
  /*
	else if ((((float) cmpvar + 0) - result) < 0.0001)
    {
        sprintf(String, "%3d %s", cmpvar + 0, DimString);
        printf("S2\n");
    }    */
	else
	{
		inttempbd = (int) result;
		floattempad = result - (float) inttempbd;
		
		inttempad = (int) (floattempad * (float) 10);
		
		if (inttempad == 9)
        {
            inttempad = 0;
            inttempbd++;
        }
		
		sprintf(String, "%3d.%1d %s", inttempbd, inttempad, DimString);
#ifdef _Debug_		
//		printf("Res %f inttempbd %d  inttempad %d\n", result, inttempbd, inttempad);
#endif		
	}	
}
//##########################################################################################################################################################
// BF removed lot of useless coding
void Display::DRAWSIGNS(void)
{
//	long Adr_Front_Old_1, Adr_Front_Old_2, Adr_Front_New_1, Adr_Front_New_2, Adr_Front_Old_3, Adr_Front_Old_4, Adr_Front_New_3, Adr_Front_New_4;
//	long Adr_Back_Old_1, Adr_Back_Old_2, Adr_Back_New_1, Adr_Back_New_2, Adr_Back_Old_3, Adr_Back_Old_4, Adr_Back_New_3, Adr_Back_New_4;
	long Adr_Front_New_1, Adr_Front_New_2, Adr_Front_New_3, Adr_Front_New_4;
	long Adr_Back_New_1, Adr_Back_New_2, Adr_Back_New_3, Adr_Back_New_4;
	unsigned char *signbuff = 0;

 
/* BF removed because of redundance
	if (MenuStatus[1][2] == 241)
        {
            Adr_Front_Old_1 = v_Channel_Plane1 + (((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane1 + (((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) + 13) * 80);
        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane1 + ((Trigger_Pos_CH1_Old + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane1 + ((Trigger_Pos_CH1_Old + 13) * 80);
        }

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
BF end	*/
        
	// for delayed mode	//BF?????
/*BF test
        if (MenuStatus[1][2] == 241)	//Inverted Signal	BF
        {
            Adr_Front_Old_1 = v_Channel_Plane1 + ((((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) >> 1) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane1 + ((((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) >> 1) + 13) * 80);
            Adr_Front_Old_3 = v_Channel_Plane1 + ((((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) >> 1) + 206) * 80);
            Adr_Front_Old_4 = v_Buffer_Plane1 + ((((ZeroLevelCH1_Old + (ZeroLevelCH1_Old - Trigger_Pos_CH1_Old)) >> 1) + 206) * 80);
        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane1 + (((Trigger_Pos_CH1_Old >> 1) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane1 + (((Trigger_Pos_CH1_Old >> 1) + 13) * 80);
            Adr_Front_Old_3 = v_Channel_Plane1 + (((Trigger_Pos_CH1_Old >> 1) + 206) * 80);
            Adr_Front_Old_4 = v_Buffer_Plane1 + (((Trigger_Pos_CH1_Old >> 1) + 206) * 80);
        }
*/
/*BF test
        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSign(Adr_Front_Old_3);
        RemoveZeroSign(Adr_Front_Old_4);
*/

    //}

/*BF test
    // Remove Channel 1 Zero
    if (XY_Mode)	//Check XY-Mode
    {
        //DrawZeroSignXY(ZeroLevelCH1_Old, 0);
    }
    else
    {
        Adr_Front_Old_1 = v_Channel_Plane1 + ((ZeroLevelCH1_Old + 11)* 80);
        Adr_Front_Old_2 = v_Buffer_Plane1 + ((ZeroLevelCH1_Old + 11) * 80);
        Adr_Back_Old_1 = v_Channel_Plane1 + ((ZeroLevelCH1_Old + 11)* 80);
        Adr_Back_Old_2 = v_Buffer_Plane1 + ((ZeroLevelCH1_Old + 11) * 80);

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

        // for delayed mode

        Adr_Front_Old_1 = v_Channel_Plane1 + (((ZeroLevelCH1_Old >> 1) + 11)* 80);
        Adr_Front_Old_2 = v_Buffer_Plane1 + (((ZeroLevelCH1_Old >> 1) + 11) * 80);
        Adr_Back_Old_1 = v_Channel_Plane1 + (((ZeroLevelCH1_Old >> 1) + 11)* 80);
        Adr_Back_Old_2 = v_Buffer_Plane1 + (((ZeroLevelCH1_Old >> 1) + 11) * 80);

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

        Adr_Front_Old_1 = v_Channel_Plane1 + (((ZeroLevelCH1_Old >> 1) + 204)* 80);
        Adr_Front_Old_2 = v_Buffer_Plane1 + (((ZeroLevelCH1_Old >> 1) + 204) * 80);
        Adr_Back_Old_1 = v_Channel_Plane1 + (((ZeroLevelCH1_Old >> 1) + 204)* 80);
        Adr_Back_Old_2 = v_Buffer_Plane1 + (((ZeroLevelCH1_Old >> 1) + 204) * 80);

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

    }
*/
	//----------------------------------
	// Draw Channel 1 Zero
	//----------------------------------

	//XY-Mode
	if ((Channel_1_Active) && (ZeroLevelCH1 > 0) && (ZeroLevelCH1 < 480) && (XY_Mode))
	{
		//DrawZeroSignXY(ZeroLevelCH1, 1);
		//ZeroLevelCH1_Old = ZeroLevelCH1;
	}

	//Main + Delayed Mode
    if ((Channel_1_Active) && (ZeroLevelCH1 > 0) && (ZeroLevelCH1 < (GRID_HEIGHT + 1)) && (XY_Mode == false) && FFT_Mode == FFT_OFF)
    {
        if (MenuStatus[10][1] == 1)	//Delayed Mode
        {
            Adr_Front_New_1 = v_Channel_Plane1 + (((ZeroLevelCH1 >> 1) + 11) * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + (((ZeroLevelCH1 >> 1) + 11) * 80);
            Adr_Back_New_1 = v_Channel_Plane1 + (((ZeroLevelCH1 >> 1) + 11) * 80);
            Adr_Back_New_2 = v_Buffer_Plane1 + (((ZeroLevelCH1 >> 1) + 11) * 80);

            Adr_Front_New_3 = v_Channel_Plane1 + (((ZeroLevelCH1 >> 1) + 204) * 80);
            Adr_Front_New_4 = v_Buffer_Plane1 + (((ZeroLevelCH1 >> 1) + 204) * 80);
            Adr_Back_New_3 = v_Channel_Plane1 + (((ZeroLevelCH1 >> 1) + 204) * 80);
            Adr_Back_New_4 = v_Buffer_Plane1 + (((ZeroLevelCH1 >> 1) + 204) * 80);

            DrawZeroSign(bitbmCH1, Adr_Front_New_1);
            DrawZeroSign(bitbmCH1, Adr_Front_New_2);
            DrawZeroSign(bitbmCH1, Adr_Front_New_3);
            DrawZeroSign(bitbmCH1, Adr_Front_New_4);

            if (MenuStatus[1][0] == 6)
            {
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
            }
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane1 + ((ZeroLevelCH1 + 11) * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + ((ZeroLevelCH1 + 11) * 80);
            Adr_Back_New_1 = v_Channel_Plane1 + ((ZeroLevelCH1 + 11) * 80);
            Adr_Back_New_2 = v_Buffer_Plane1 + ((ZeroLevelCH1 + 11) * 80);

            DrawZeroSign(bitbmCH1, Adr_Front_New_1);
            DrawZeroSign(bitbmCH1, Adr_Front_New_2);

            if (MenuStatus[1][0] == 6)
            {
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCH1_gnd, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 240) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] != 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[1][0] == 7) && (MenuStatus[1][1] == 241) && (MenuStatus[1][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
            }
        }

        ZeroLevelCH1_Old = ZeroLevelCH1;
    }
    else if ((Channel_1_Active) && (ZeroLevelCH1 == 0) && (XY_Mode == false) && FFT_Mode == FFT_OFF)      // muß für xy upgedatet werden
    {
        if (MenuStatus[10][1] == 1)
        {
            Adr_Front_New_1 = v_Channel_Plane1 + (20 * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + (20 * 80);
            Adr_Front_New_3 = v_Channel_Plane1 + (213 * 80);
            Adr_Front_New_4 = v_Buffer_Plane1 + (213 * 80);

            DrawZeroSign(bitbmMin, Adr_Front_New_1);
            DrawZeroSign(bitbmMin, Adr_Front_New_2);
            DrawZeroSign(bitbmMin, Adr_Front_New_3);
            DrawZeroSign(bitbmMin, Adr_Front_New_4);

            ZeroLevelCH1_Old = ZeroLevelCH1;
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane1 + (20 * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + (20 * 80);

            DrawZeroSign(bitbmMin, Adr_Front_New_1);
            DrawZeroSign(bitbmMin, Adr_Front_New_2);

            ZeroLevelCH1_Old = ZeroLevelCH1;
        }
    }
    else if ((Channel_1_Active) && (ZeroLevelCH1 == (GRID_HEIGHT + 1)) && (XY_Mode == false)  && FFT_Mode == FFT_OFF)   // muß für xy upgedatet werden
    {
        if (MenuStatus[10][1] == 1)
        {
            Adr_Front_New_1 = v_Channel_Plane1 + (203 * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + (203 * 80);
            Adr_Front_New_3 = v_Channel_Plane1 + (396 * 80);
            Adr_Front_New_4 = v_Buffer_Plane1 + (396 * 80);

            DrawZeroSign(bitbmMax, Adr_Front_New_1);
            DrawZeroSign(bitbmMax, Adr_Front_New_2);
            DrawZeroSign(bitbmMax, Adr_Front_New_3);
            DrawZeroSign(bitbmMax, Adr_Front_New_4);

            ZeroLevelCH1_Old = ZeroLevelCH1;
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane1 + (396 * 80);
            Adr_Front_New_2 = v_Buffer_Plane1 + (396 * 80);

            DrawZeroSign(bitbmMax, Adr_Front_New_1);
            DrawZeroSign(bitbmMax, Adr_Front_New_2);

            ZeroLevelCH1_Old = ZeroLevelCH1;
        }
    }

    // Draw Trigger Channel 1
    //if ((triggering) && (Selected_Trigger_Source == 1))
    if ((Selected_Trigger_Source == 1) && (XY_Mode == false) && FFT_Mode == FFT_OFF)
    {
        if (MenuStatus[10][1] == 1)
        {
            if (MenuStatus[1][2] == 241) // inverted
            {
                Adr_Front_New_1 = v_Channel_Plane1 + ((((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) >> 1) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane1 + ((((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) >> 1) + 13) * 80);
                Adr_Front_New_3 = v_Channel_Plane1 + ((((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) >> 1) + 206) * 80);
                Adr_Front_New_4 = v_Buffer_Plane1 + ((((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) >> 1) + 206) * 80);
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane1 + (((Trigger_Pos_CH1 >> 1) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane1 + (((Trigger_Pos_CH1 >> 1) + 13) * 80);
                Adr_Front_New_3 = v_Channel_Plane1 + (((Trigger_Pos_CH1 >> 1) + 206) * 80);
                Adr_Front_New_4 = v_Buffer_Plane1 + (((Trigger_Pos_CH1 >> 1) + 206) * 80);
            }
            
            if (MenuStatus[0][1] == 1)
            {
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
            }
            else
            {
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
            }
        }
        else
        {
            if (MenuStatus[1][2] == 241) // inverted
            {
                Adr_Front_New_1 = v_Channel_Plane1 + (((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane1 + (((ZeroLevelCH1 + (ZeroLevelCH1 - Trigger_Pos_CH1)) + 13) * 80);
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane1 + ((Trigger_Pos_CH1 + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane1 + ((Trigger_Pos_CH1 + 13) * 80);
            }
            
            if (MenuStatus[0][1] == 1)
            {
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
            }
            else
            {
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
            }
        }
        Trigger_Pos_CH1_Old = Trigger_Pos_CH1;
    }


	//------------------------------------------------------
	// Channel 2
	//------------------------------------------------------

/*BF del
    // Remove Trigger Channel 2
    //if (Selected_Trigger_Source_Old == 2)
    //{
        if (MenuStatus[2][2] == 241)
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + (((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + (((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) + 13) * 80);
        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + ((Trigger_Pos_CH2_Old + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + ((Trigger_Pos_CH2_Old + 13) * 80);
        }
*/
/*BF test
        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
*/
        // for delayed mode
/* BF test
        if (MenuStatus[2][2] == 241)
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + ((((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) >> 1) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + ((((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) >> 1) + 13) * 80);
            Adr_Front_Old_3 = v_Channel_Plane2 + ((((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) >> 1) + 206) * 80);
            Adr_Front_Old_4 = v_Buffer_Plane2 + ((((ZeroLevelCH2_Old + (ZeroLevelCH2_Old - Trigger_Pos_CH2_Old)) >> 1) + 206) * 80);
        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + (((Trigger_Pos_CH2_Old >> 1) + 13) * 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + (((Trigger_Pos_CH2_Old >> 1) + 13) * 80);
            Adr_Front_Old_3 = v_Channel_Plane2 + (((Trigger_Pos_CH2_Old >> 1) + 206) * 80);
            Adr_Front_Old_4 = v_Buffer_Plane2 + (((Trigger_Pos_CH2_Old >> 1) + 206) * 80);
        }
*/
/* BF test
        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSign(Adr_Front_Old_3);
        RemoveZeroSign(Adr_Front_Old_4);
*/

   // }

    // Remove Channel 2 Zero
  /*  if (XY_Mode)
    {
        Adr_Front_Old_1 = v_Channel_Plane2 + (ZeroLevelCH2_Old + 1360);
        Adr_Front_Old_2 = v_Buffer_Plane2 + (ZeroLevelCH2_Old + 1360);
        Adr_Back_Old_1 = v_Channel_Plane2 + (ZeroLevelCH2_Old + 1360);
        Adr_Back_Old_2 = v_Buffer_Plane2 + (ZeroLevelCH2_Old + 1360);

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);
    }
    else   
*/
/* BF test
    {
        if (XY_Mode)
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + ((ZeroLevelCH2_Old + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + ((ZeroLevelCH2_Old + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane2 + ((ZeroLevelCH2_Old + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane2 + ((ZeroLevelCH2_Old + 11) * 80);
        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane2 + ((ZeroLevelCH2_Old + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane2 + ((ZeroLevelCH2_Old + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane2 + ((ZeroLevelCH2_Old + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane2 + ((ZeroLevelCH2_Old + 11) * 80);
        }

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

        // for delayed mode

        Adr_Front_Old_1 = v_Channel_Plane2 + (((ZeroLevelCH2_Old >> 1) + 11)* 80);
        Adr_Front_Old_2 = v_Buffer_Plane2 + (((ZeroLevelCH2_Old >> 1) + 11) * 80);
        Adr_Back_Old_1 = v_Channel_Plane2 + (((ZeroLevelCH2_Old >> 1) + 11)* 80);
        Adr_Back_Old_2 = v_Buffer_Plane2 + (((ZeroLevelCH2_Old >> 1) + 11) * 80);


        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

        Adr_Front_Old_1 = v_Channel_Plane2 + (((ZeroLevelCH2_Old >> 1) + 204)* 80);
        Adr_Front_Old_2 = v_Buffer_Plane2 + (((ZeroLevelCH2_Old >> 1) + 204) * 80);
        Adr_Back_Old_1 = v_Channel_Plane2 + (((ZeroLevelCH2_Old >> 1) + 204)* 80);
        Adr_Back_Old_2 = v_Buffer_Plane2 + (((ZeroLevelCH2_Old >> 1) + 204) * 80);

        RemoveZeroSign(Adr_Front_Old_1);
        RemoveZeroSign(Adr_Front_Old_2);
        RemoveZeroSignBack(Adr_Back_Old_1);
        RemoveZeroSignBack(Adr_Back_Old_2);

    }
*/
    // Draw Channel 2 Zero
    if ((Channel_2_Active) && (ZeroLevelCH2 > 0) && (ZeroLevelCH2 < (GRID_HEIGHT + 1)) && FFT_Mode == FFT_OFF)
    {
        if (XY_Mode == false)    // nur zum ausblenden der zero bei XY
        {
        if (MenuStatus[10][1] == 1)
        {
            if (XY_Mode)
            {
                Adr_Front_New_1 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);

                Adr_Front_New_3 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Front_New_4 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Back_New_3 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Back_New_4 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 11) * 80);

                Adr_Front_New_3 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Front_New_4 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Back_New_3 = v_Channel_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
                Adr_Back_New_4 = v_Buffer_Plane2 + (((ZeroLevelCH2 >> 1) + 204) * 80);
            }

            DrawZeroSign(bitbmCH2, Adr_Front_New_1);
            DrawZeroSign(bitbmCH2, Adr_Front_New_2);
            DrawZeroSign(bitbmCH2, Adr_Front_New_3);
            DrawZeroSign(bitbmCH2, Adr_Front_New_4);

            if (MenuStatus[2][0] == 6)
            {
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
            }
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane2 + ((ZeroLevelCH2 + 11) * 80);
            Adr_Front_New_2 = v_Buffer_Plane2 + ((ZeroLevelCH2 + 11) * 80);
            Adr_Back_New_1 = v_Channel_Plane2 + ((ZeroLevelCH2 + 11) * 80);
            Adr_Back_New_2 = v_Buffer_Plane2 + ((ZeroLevelCH2 + 11) * 80);

            DrawZeroSign(bitbmCH2, Adr_Front_New_1);
            DrawZeroSign(bitbmCH2, Adr_Front_New_2);

            if (MenuStatus[2][0] == 6)
            {
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCH2_gnd, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 240) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 240))
            {
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] != 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
            }
            else if ((MenuStatus[2][0] == 7) && (MenuStatus[2][1] == 241) && (MenuStatus[2][2] == 241))
            {
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
            }
        }
        }

        ZeroLevelCH2_Old = ZeroLevelCH2;
    }
    else if ((Channel_2_Active) && (ZeroLevelCH2 == 0) && FFT_Mode == FFT_OFF )      // muß für xy upgedatet werden
    {
        if (MenuStatus[10][1] == 1)
        {
            Adr_Front_New_1 = v_Channel_Plane2 + (20 * 80);
            Adr_Front_New_2 = v_Buffer_Plane2 + (20 * 80);
            Adr_Front_New_3 = v_Channel_Plane2 + (213 * 80);
            Adr_Front_New_4 = v_Buffer_Plane2 + (213 * 80);

            DrawZeroSign(bitbmMin, Adr_Front_New_1);
            DrawZeroSign(bitbmMin, Adr_Front_New_2);
            DrawZeroSign(bitbmMin, Adr_Front_New_3);
            DrawZeroSign(bitbmMin, Adr_Front_New_4);

            ZeroLevelCH2_Old = ZeroLevelCH2;
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane2 + (20 * 80);
            Adr_Front_New_2 = v_Buffer_Plane2 + (20 * 80);

            DrawZeroSign(bitbmMin, Adr_Front_New_1);
            DrawZeroSign(bitbmMin, Adr_Front_New_2);

            ZeroLevelCH2_Old = ZeroLevelCH2;
        }
    }
    else if ((Channel_2_Active) && (ZeroLevelCH2 == (GRID_HEIGHT + 1))  && FFT_Mode == FFT_OFF)   // muß für xy upgedatet werden
    {
        if (MenuStatus[10][1] == 1)
        {
            Adr_Front_New_1 = v_Channel_Plane2 + (203 * 80);
            Adr_Front_New_2 = v_Buffer_Plane2 + (203 * 80);
            Adr_Front_New_3 = v_Channel_Plane2 + (396 * 80);
            Adr_Front_New_4 = v_Buffer_Plane2 + (396 * 80);

            DrawZeroSign(bitbmMax, Adr_Front_New_1);
            DrawZeroSign(bitbmMax, Adr_Front_New_2);
            DrawZeroSign(bitbmMax, Adr_Front_New_3);
            DrawZeroSign(bitbmMax, Adr_Front_New_4);

            ZeroLevelCH2_Old = ZeroLevelCH2;
        }
        else
        {
            Adr_Front_New_1 = v_Channel_Plane2 + (396 * 80);
            Adr_Front_New_2 = v_Buffer_Plane2 + (396 * 80);

            DrawZeroSign(bitbmMax, Adr_Front_New_1);
            DrawZeroSign(bitbmMax, Adr_Front_New_2);

            ZeroLevelCH2_Old = ZeroLevelCH2;
        }
    }

    // Draw Trigger Channel 2
    //if ((triggering) && (Selected_Trigger_Source == 2))
    if ((Selected_Trigger_Source == 2) && (XY_Mode == false) && FFT_Mode == FFT_OFF)
    {
        if (MenuStatus[10][1] == 1)
        {
            if (MenuStatus[2][2] == 241) // inverted
            {
                Adr_Front_New_1 = v_Channel_Plane2 + ((((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) >> 1) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + ((((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) >> 1) + 13) * 80);
                Adr_Front_New_3 = v_Channel_Plane2 + ((((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) >> 1) + 206) * 80);
                Adr_Front_New_4 = v_Buffer_Plane2 + ((((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) >> 1) + 206) * 80);
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane2 + (((Trigger_Pos_CH2 >> 1) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + (((Trigger_Pos_CH2 >> 1) + 13) * 80);
                Adr_Front_New_3 = v_Channel_Plane2 + (((Trigger_Pos_CH2 >> 1) + 206) * 80);
                Adr_Front_New_4 = v_Buffer_Plane2 + (((Trigger_Pos_CH2 >> 1) + 206) * 80);
            }

            if (MenuStatus[0][1] == 1)
            {
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
            }
            else
            {
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
            }
        }
        else
        {
            if (MenuStatus[2][2] == 241) // inverted
            {
                Adr_Front_New_1 = v_Channel_Plane2 + (((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + (((ZeroLevelCH2 + (ZeroLevelCH2 - Trigger_Pos_CH2)) + 13) * 80);
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane2 + ((Trigger_Pos_CH2 + 13) * 80);
                Adr_Front_New_2 = v_Buffer_Plane2 + ((Trigger_Pos_CH2 + 13) * 80);
            }

            if (MenuStatus[0][1] == 1)
            {
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
            }
            else
            {
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
            }
        }
        Trigger_Pos_CH2_Old = Trigger_Pos_CH2;
    }


	//4 Channel version
    if (NumberOfChannels > 2)
    {
       
	//------------------------------------------------------
	// Channel 3
	//------------------------------------------------------

/* BF test
	 // Remove Trigger Channel 3
        //if (Selected_Trigger_Source_Old == 3)
        {
            if (MenuStatus[3][2] == 241)
            {
                Adr_Front_Old_1 = v_Channel_Plane3 + (((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane3 + (((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) + 13) * 80);
            }
            else
            {
                Adr_Front_Old_1 = v_Channel_Plane3 + ((Trigger_Pos_CH3_Old + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane3 + ((Trigger_Pos_CH3_Old + 13) * 80);
            }
*/
/* BF test
            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
*/
            // for delayed mode
/* BF test
            if (MenuStatus[3][2] == 241)
            {
                Adr_Front_Old_1 = v_Channel_Plane3 + ((((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) >> 1) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane3 + ((((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) >> 1) + 13) * 80);
                Adr_Front_Old_3 = v_Channel_Plane3 + ((((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) >> 1) + 206) * 80);
                Adr_Front_Old_4 = v_Buffer_Plane3 + ((((ZeroLevelCH3_Old + (ZeroLevelCH3_Old - Trigger_Pos_CH3_Old)) >> 1) + 206) * 80);
            }
            else
            {
                Adr_Front_Old_1 = v_Channel_Plane3 + (((Trigger_Pos_CH3_Old >> 1) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane3 + (((Trigger_Pos_CH3_Old >> 1) + 13) * 80);
                Adr_Front_Old_3 = v_Channel_Plane3 + (((Trigger_Pos_CH3_Old >> 1) + 206) * 80);
                Adr_Front_Old_4 = v_Buffer_Plane3 + (((Trigger_Pos_CH3_Old >> 1) + 206) * 80);
            }
*/
/*BF test
            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSign(Adr_Front_Old_3);
            RemoveZeroSign(Adr_Front_Old_4);
*/
       // }
/* BF test
        // Remove Channel 3 Zero
        if (XY_Mode)
        {
            Adr_Front_Old_1 = v_Channel_Plane3 + (ZeroLevelCH3_Old + 1360);
            Adr_Front_Old_2 = v_Buffer_Plane3 + (ZeroLevelCH3_Old + 1360);
            Adr_Back_Old_1 = v_Channel_Plane3 + (ZeroLevelCH3_Old + 1360);
            Adr_Back_Old_2 = v_Buffer_Plane3 + (ZeroLevelCH3_Old + 1360);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane3 + ((ZeroLevelCH3_Old + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane3 + ((ZeroLevelCH3_Old + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane3 + ((ZeroLevelCH3_Old + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane3 + ((ZeroLevelCH3_Old + 11) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);


            // for delayed mode

            Adr_Front_Old_1 = v_Channel_Plane3 + (((ZeroLevelCH3_Old >> 1) + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane3 + (((ZeroLevelCH3_Old >> 1) + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane3 + (((ZeroLevelCH3_Old >> 1) + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane3 + (((ZeroLevelCH3_Old >> 1) + 11) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

            Adr_Front_Old_1 = v_Channel_Plane3 + (((ZeroLevelCH3_Old >> 1) + 204)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane3 + (((ZeroLevelCH3_Old >> 1) + 204) * 80);
            Adr_Back_Old_1 = v_Channel_Plane3 + (((ZeroLevelCH3_Old >> 1) + 204)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane3 + (((ZeroLevelCH3_Old >> 1) + 204) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

        }
*/
        // Draw Channel 3 Zero
        if (!XY_Mode && Channel_3_Active && (ZeroLevelCH3 > 0) && (ZeroLevelCH3 < (GRID_HEIGHT + 1)) && FFT_Mode == FFT_OFF)
//BF del	if (Channel_3_Active && (ZeroLevelCH3 > 0) && (ZeroLevelCH3 < (GRID_HEIGHT + 1)))
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane3 + (((ZeroLevelCH3 >> 1) + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + (((ZeroLevelCH3 >> 1) + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane3 + (((ZeroLevelCH3 >> 1) + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane3 + (((ZeroLevelCH3 >> 1) + 11) * 80);

                Adr_Front_New_3 = v_Channel_Plane3 + (((ZeroLevelCH3 >> 1) + 204) * 80);
                Adr_Front_New_4 = v_Buffer_Plane3 + (((ZeroLevelCH3 >> 1) + 204) * 80);
                Adr_Back_New_3 = v_Channel_Plane3 + (((ZeroLevelCH3 >> 1) + 204) * 80);
                Adr_Back_New_4 = v_Buffer_Plane3 + (((ZeroLevelCH3 >> 1) + 204) * 80);

                DrawZeroSign(bitbmCH3, Adr_Front_New_1);
                DrawZeroSign(bitbmCH3, Adr_Front_New_2);
                DrawZeroSign(bitbmCH3, Adr_Front_New_3);
                DrawZeroSign(bitbmCH3, Adr_Front_New_4);

                if (MenuStatus[3][0] == 6)
                {
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
                }
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane3 + ((ZeroLevelCH3 + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + ((ZeroLevelCH3 + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane3 + ((ZeroLevelCH3 + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane3 + ((ZeroLevelCH3 + 11) * 80);

                DrawZeroSign(bitbmCH3, Adr_Front_New_1);
                DrawZeroSign(bitbmCH3, Adr_Front_New_2);

                if (MenuStatus[3][0] == 6)
                {
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCH3_gnd, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 240) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] != 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[3][0] == 7) && (MenuStatus[3][1] == 241) && (MenuStatus[3][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                }
            }

            ZeroLevelCH3_Old = ZeroLevelCH3;
        }
        else if ((Channel_3_Active) && (ZeroLevelCH3 == 0) && FFT_Mode == FFT_OFF)      // muß für xy upgedatet werden
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane3 + (20 * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + (20 * 80);
                Adr_Front_New_3 = v_Channel_Plane3 + (213 * 80);
                Adr_Front_New_4 = v_Buffer_Plane3 + (213 * 80);

                DrawZeroSign(bitbmMin, Adr_Front_New_1);
                DrawZeroSign(bitbmMin, Adr_Front_New_2);
                DrawZeroSign(bitbmMin, Adr_Front_New_3);
                DrawZeroSign(bitbmMin, Adr_Front_New_4);

                ZeroLevelCH3_Old = ZeroLevelCH3;
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane3 + (20 * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + (20 * 80);

                DrawZeroSign(bitbmMin, Adr_Front_New_1);
                DrawZeroSign(bitbmMin, Adr_Front_New_2);

                ZeroLevelCH3_Old = ZeroLevelCH3;
            }
        }
        else if ((Channel_3_Active) && (ZeroLevelCH3 == (GRID_HEIGHT + 1)) && FFT_Mode == FFT_OFF)   // muß für xy upgedatet werden
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane3 + (203 * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + (203 * 80);
                Adr_Front_New_3 = v_Channel_Plane3 + (396 * 80);
                Adr_Front_New_4 = v_Buffer_Plane3 + (396 * 80);

                DrawZeroSign(bitbmMax, Adr_Front_New_1);
                DrawZeroSign(bitbmMax, Adr_Front_New_2);
                DrawZeroSign(bitbmMax, Adr_Front_New_3);
                DrawZeroSign(bitbmMax, Adr_Front_New_4);

                ZeroLevelCH3_Old = ZeroLevelCH3;
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane3 + (396 * 80);
                Adr_Front_New_2 = v_Buffer_Plane3 + (396 * 80);

                DrawZeroSign(bitbmMax, Adr_Front_New_1);
                DrawZeroSign(bitbmMax, Adr_Front_New_2);

                ZeroLevelCH3_Old = ZeroLevelCH3;
            }
        }


        // Draw Trigger Channel 3
        //if ((triggering) && (Selected_Trigger_Source == 3))
        if ((Selected_Trigger_Source == 3) && (XY_Mode == false) && FFT_Mode == FFT_OFF)
        {
            if (MenuStatus[10][1] == 1)
            {
                if (MenuStatus[3][2] == 241) // inverted
                {
                    Adr_Front_New_1 = v_Channel_Plane3 + ((((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) >> 1) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane3 + ((((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) >> 1) + 13) * 80);
                    Adr_Front_New_3 = v_Channel_Plane3 + ((((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) >> 1) + 206) * 80);
                    Adr_Front_New_4 = v_Buffer_Plane3 + ((((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) >> 1) + 206) * 80);
                }
                else
                {
                    Adr_Front_New_1 = v_Channel_Plane3 + (((Trigger_Pos_CH3 >> 1) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane3 + (((Trigger_Pos_CH3 >> 1) + 13) * 80);
                    Adr_Front_New_3 = v_Channel_Plane3 + (((Trigger_Pos_CH3 >> 1) + 206) * 80);
                    Adr_Front_New_4 = v_Buffer_Plane3 + (((Trigger_Pos_CH3 >> 1) + 206) * 80);
                }

                if (MenuStatus[0][1] == 1)
                {
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
                }
                else
                {
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
                }
            }
            else
            {
                if (MenuStatus[3][2] == 241) // inverted
                {
                    Adr_Front_New_1 = v_Channel_Plane3 + (((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane3 + (((ZeroLevelCH3 + (ZeroLevelCH3 - Trigger_Pos_CH3)) + 13) * 80);
                }
                else
                {
                    Adr_Front_New_1 = v_Channel_Plane3 + ((Trigger_Pos_CH3 + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane3 + ((Trigger_Pos_CH3 + 13) * 80);
                }

                if (MenuStatus[0][1] == 1)
                {
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                }
                else
                {
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                }
            }
            Trigger_Pos_CH3_Old = Trigger_Pos_CH3;
        }


	//------------------------------------------------------
	// Channel 4
	//------------------------------------------------------
/* BF test
        // Remove Trigger Channel 4
        //if (Selected_Trigger_Source_Old == 4)
        {
            if (MenuStatus[4][2] == 241)
            {
                Adr_Front_Old_1 = v_Channel_Plane4 + (((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane4 + (((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) + 13) * 80);
            }
            else
            {
                Adr_Front_Old_1 = v_Channel_Plane4 + ((Trigger_Pos_CH4_Old + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane4 + ((Trigger_Pos_CH4_Old + 13) * 80);
            }

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);

            // for delayed mode

            if (MenuStatus[4][2] == 241)
            {
                Adr_Front_Old_1 = v_Channel_Plane4 + ((((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) >> 1) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane4 + ((((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) >> 1) + 13) * 80);
                Adr_Front_Old_3 = v_Channel_Plane4 + ((((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) >> 1) + 206) * 80);
                Adr_Front_Old_4 = v_Buffer_Plane4 + ((((ZeroLevelCH4_Old + (ZeroLevelCH4_Old - Trigger_Pos_CH4_Old)) >> 1) + 206) * 80);
            }
            else
            {
                Adr_Front_Old_1 = v_Channel_Plane4 + (((Trigger_Pos_CH4_Old >> 1) + 13) * 80);
                Adr_Front_Old_2 = v_Buffer_Plane4 + (((Trigger_Pos_CH4_Old >> 1) + 13) * 80);
                Adr_Front_Old_3 = v_Channel_Plane4 + (((Trigger_Pos_CH4_Old >> 1) + 206) * 80);
                Adr_Front_Old_4 = v_Buffer_Plane4 + (((Trigger_Pos_CH4_Old >> 1) + 206) * 80);
            }

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSign(Adr_Front_Old_3);
            RemoveZeroSign(Adr_Front_Old_4);

        }

        // Remove Channel 4 Zero
        if (XY_Mode)
        {
            Adr_Front_Old_1 = v_Channel_Plane4 + (ZeroLevelCH4_Old + 1360);
            Adr_Front_Old_2 = v_Buffer_Plane4 + (ZeroLevelCH4_Old + 1360);
            Adr_Back_Old_1 = v_Channel_Plane4 + (ZeroLevelCH4_Old + 1360);
            Adr_Back_Old_2 = v_Buffer_Plane4 + (ZeroLevelCH4_Old + 1360);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

        }
        else
        {
            Adr_Front_Old_1 = v_Channel_Plane4 + ((ZeroLevelCH4_Old + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane4 + ((ZeroLevelCH4_Old + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane4 + ((ZeroLevelCH4_Old + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane4 + ((ZeroLevelCH4_Old + 11) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);


            // for delayed mode

            Adr_Front_Old_1 = v_Channel_Plane4 + (((ZeroLevelCH4_Old >> 1) + 11)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane4 + (((ZeroLevelCH4_Old >> 1) + 11) * 80);
            Adr_Back_Old_1 = v_Channel_Plane4 + (((ZeroLevelCH4_Old >> 1) + 11)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane4 + (((ZeroLevelCH4_Old >> 1) + 11) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

            Adr_Front_Old_1 = v_Channel_Plane4 + (((ZeroLevelCH4_Old >> 1) + 204)* 80);
            Adr_Front_Old_2 = v_Buffer_Plane4 + (((ZeroLevelCH4_Old >> 1) + 204) * 80);
            Adr_Back_Old_1 = v_Channel_Plane4 + (((ZeroLevelCH4_Old >> 1) + 204)* 80);
            Adr_Back_Old_2 = v_Buffer_Plane4 + (((ZeroLevelCH4_Old >> 1) + 204) * 80);

            RemoveZeroSign(Adr_Front_Old_1);
            RemoveZeroSign(Adr_Front_Old_2);
            RemoveZeroSignBack(Adr_Back_Old_1);
            RemoveZeroSignBack(Adr_Back_Old_2);

        }
*/
        // Draw Channel 4 Zero
	 if (!XY_Mode && Channel_4_Active && (ZeroLevelCH4 > 0) && (ZeroLevelCH4 < (GRID_HEIGHT + 1)) && FFT_Mode == FFT_OFF)
//BF del        if ((Channel_4_Active) && (ZeroLevelCH4 > 0) && (ZeroLevelCH4 < (GRID_HEIGHT + 1)))
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane4 + (((ZeroLevelCH4 >> 1) + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + (((ZeroLevelCH4 >> 1) + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane4 + (((ZeroLevelCH4 >> 1) + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane4 + (((ZeroLevelCH4 >> 1) + 11) * 80);

                Adr_Front_New_3 = v_Channel_Plane4 + (((ZeroLevelCH4 >> 1) + 204) * 80);
                Adr_Front_New_4 = v_Buffer_Plane4 + (((ZeroLevelCH4 >> 1) + 204) * 80);
                Adr_Back_New_3 = v_Channel_Plane4 + (((ZeroLevelCH4 >> 1) + 204) * 80);
                Adr_Back_New_4 = v_Buffer_Plane4 + (((ZeroLevelCH4 >> 1) + 204) * 80);

                DrawZeroSign(bitbmCH4, Adr_Front_New_1);
                DrawZeroSign(bitbmCH4, Adr_Front_New_2);
                DrawZeroSign(bitbmCH4, Adr_Front_New_3);
                DrawZeroSign(bitbmCH4, Adr_Front_New_4);

                if (MenuStatus[4][0] == 6)
                {
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_4);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_3);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_4);
                }
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane4 + ((ZeroLevelCH4 + 11) * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + ((ZeroLevelCH4 + 11) * 80);
                Adr_Back_New_1 = v_Channel_Plane4 + ((ZeroLevelCH4 + 11) * 80);
                Adr_Back_New_2 = v_Buffer_Plane4 + ((ZeroLevelCH4 + 11) * 80);

                DrawZeroSign(bitbmCH4, Adr_Front_New_1);
                DrawZeroSign(bitbmCH4, Adr_Front_New_2);

                if (MenuStatus[4][0] == 6)
                {
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCH4_gnd, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppDC, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppAC, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInv, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 240) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACInv, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 240))
                {
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppACLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] != 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppInvLimit, Adr_Back_New_2);
                }
                else if ((MenuStatus[4][0] == 7) && (MenuStatus[4][1] == 241) && (MenuStatus[4][2] == 241))
                {
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_1);
                    DrawZeroSignBack(bitbmCoppFull, Adr_Back_New_2);
                }
            }

            ZeroLevelCH4_Old = ZeroLevelCH4;
        }
        else if ((Channel_4_Active) && (ZeroLevelCH4 == 0) && FFT_Mode == FFT_OFF)      // muß für xy upgedatet werden
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane4 + (20 * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + (20 * 80);
                Adr_Front_New_3 = v_Channel_Plane4 + (213 * 80);
                Adr_Front_New_4 = v_Buffer_Plane4 + (213 * 80);

                DrawZeroSign(bitbmMin, Adr_Front_New_1);
                DrawZeroSign(bitbmMin, Adr_Front_New_2);
                DrawZeroSign(bitbmMin, Adr_Front_New_3);
                DrawZeroSign(bitbmMin, Adr_Front_New_4);

                ZeroLevelCH4_Old = ZeroLevelCH4;
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane4 + (20 * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + (20 * 80);

                DrawZeroSign(bitbmMin, Adr_Front_New_1);
                DrawZeroSign(bitbmMin, Adr_Front_New_2);

                ZeroLevelCH4_Old = ZeroLevelCH4;
            }
        }
        else if ((Channel_4_Active) && (ZeroLevelCH4 == (GRID_HEIGHT + 1)) && FFT_Mode == FFT_OFF)   // muß für xy upgedatet werden
        {
            if (MenuStatus[10][1] == 1)
            {
                Adr_Front_New_1 = v_Channel_Plane4 + (203 * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + (203 * 80);
                Adr_Front_New_3 = v_Channel_Plane4 + (396 * 80);
                Adr_Front_New_4 = v_Buffer_Plane4 + (396 * 80);

                DrawZeroSign(bitbmMax, Adr_Front_New_1);
                DrawZeroSign(bitbmMax, Adr_Front_New_2);
                DrawZeroSign(bitbmMax, Adr_Front_New_3);
                DrawZeroSign(bitbmMax, Adr_Front_New_4);

                ZeroLevelCH4_Old = ZeroLevelCH4;
            }
            else
            {
                Adr_Front_New_1 = v_Channel_Plane4 + (396 * 80);
                Adr_Front_New_2 = v_Buffer_Plane4 + (396 * 80);

                DrawZeroSign(bitbmMax, Adr_Front_New_1);
                DrawZeroSign(bitbmMax, Adr_Front_New_2);

                ZeroLevelCH4_Old = ZeroLevelCH4;
            }
        }

        // Draw Trigger Channel 4
        //if ((triggering) && (Selected_Trigger_Source == 4))
        if ((Selected_Trigger_Source == 4) && (XY_Mode == false) && FFT_Mode == FFT_OFF)
        {
            if (MenuStatus[10][1] == 1)
            {
                if (MenuStatus[4][2] == 241) // inverted
                {
                    Adr_Front_New_1 = v_Channel_Plane4 + ((((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) >> 1) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane4 + ((((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) >> 1) + 13) * 80);
                    Adr_Front_New_3 = v_Channel_Plane4 + ((((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) >> 1) + 206) * 80);
                    Adr_Front_New_4 = v_Buffer_Plane4 + ((((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) >> 1) + 206) * 80);
                }
                else
                {
                    Adr_Front_New_1 = v_Channel_Plane4 + (((Trigger_Pos_CH4 >> 1) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane4 + (((Trigger_Pos_CH4 >> 1) + 13) * 80);
                    Adr_Front_New_3 = v_Channel_Plane4 + (((Trigger_Pos_CH4 >> 1) + 206) * 80);
                    Adr_Front_New_4 = v_Buffer_Plane4 + (((Trigger_Pos_CH4 >> 1) + 206) * 80);
                }

                if (MenuStatus[0][1] == 1)
                {
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_3);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_4);
                }
                else
                {
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_3);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_4);
                }
            }
            else
            {
                if (MenuStatus[4][2] == 241) // inverted
                {
                    Adr_Front_New_1 = v_Channel_Plane4 + (((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane4 + (((ZeroLevelCH4 + (ZeroLevelCH4 - Trigger_Pos_CH4)) + 13) * 80);
                }
                else
                {
                    Adr_Front_New_1 = v_Channel_Plane4 + ((Trigger_Pos_CH4 + 13) * 80);
                    Adr_Front_New_2 = v_Buffer_Plane4 + ((Trigger_Pos_CH4 + 13) * 80);
                }

                if (MenuStatus[0][1] == 1)
                {
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigAVG, Adr_Front_New_2);
                }
                else
                {
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_1);
                    OverDrawZeroSign(bitbmTrigger, Adr_Front_New_2);
                }
            }
            Trigger_Pos_CH4_Old = Trigger_Pos_CH4;
        }
    }

    if (ZeroLevelCH1 < 5) TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);									// Draw Voltage Text
//    if (ZeroLevelCH1 < 5) TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);									// Draw Voltage Text
}
//##########################################################################################################################################################

void Display::RemoveZeroSign(long addressold)
{
    CLEAR2BYTE(addressold + 0x000);
    CLEAR2BYTE(addressold + 0x050);
    CLEAR2BYTE(addressold + 0x0A0);
    CLEAR2BYTE(addressold + 0x0F0);
    CLEAR2BYTE(addressold + 0x140);
    CLEAR2BYTE(addressold + 0x190);
    CLEAR2BYTE(addressold + 0x1E0);
    CLEAR2BYTE(addressold + 0x230);
    CLEAR2BYTE(addressold + 0x280);
    CLEAR2BYTE(addressold + 0x2D0);
    CLEAR2BYTE(addressold + 0x320);
    CLEAR2BYTE(addressold + 0x370);
    CLEAR2BYTE(addressold + 0x3C0);
    CLEAR2BYTE(addressold + 0x410);
    CLEAR2BYTE(addressold + 0x460);
    CLEAR2BYTE(addressold + 0x4B0);
}
//##########################################################################################################################################################

void Display::DrawZeroSign(unsigned char *sign, long addressnew)
{
    WRITE2BYTE(sign[2], sign[3], addressnew + 0x000);
    WRITE2BYTE(sign[4], sign[5], addressnew + 0x050);
    WRITE2BYTE(sign[6], sign[7], addressnew + 0x0A0);
    WRITE2BYTE(sign[8], sign[9], addressnew + 0x0F0);
    WRITE2BYTE(sign[10], sign[11], addressnew + 0x140);
    WRITE2BYTE(sign[12], sign[13], addressnew + 0x190);
    WRITE2BYTE(sign[14], sign[15], addressnew + 0x1E0);
    WRITE2BYTE(sign[16], sign[17], addressnew + 0x230);
    WRITE2BYTE(sign[18], sign[19], addressnew + 0x280);
    WRITE2BYTE(sign[20], sign[21], addressnew + 0x2D0);
    WRITE2BYTE(sign[22], sign[23], addressnew + 0x320);
    WRITE2BYTE(sign[24], sign[25], addressnew + 0x370);
    WRITE2BYTE(sign[26], sign[27], addressnew + 0x3C0);
    WRITE2BYTE(sign[28], sign[29], addressnew + 0x410);
    WRITE2BYTE(sign[30], sign[31], addressnew + 0x460);
    WRITE2BYTE(sign[32], sign[33], addressnew + 0x4B0);
}
//##########################################################################################################################################################

void Display::DrawZeroSignXY(int position, char set)
{
    int posiy = 20;

    DRAWLINEP(position + 80, posiy, position + 80, posiy + 6, set, Buffer_Plane1);

    DRAWLINEP(position + 80 - 1, posiy + 1, position + 80 + 2, posiy + 1, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 2, posiy + 2, position + 80 + 3, posiy + 2, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 3, posiy + 3, position + 80 + 4, posiy + 3, set, Buffer_Plane1);

    DRAWLINEP(position + 80 - 2, posiy + 6, position + 80 + 3, posiy + 6, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 1, posiy + 8, position + 80 + 2, posiy + 8, set, Buffer_Plane1);
    PIXELP(position + 80, posiy + 10, set, Buffer_Plane1);

    PIXELP(position + 80 - 7, posiy + 3, set, Buffer_Plane1);
    PIXELP(position + 80 - 6, posiy + 2, set, Buffer_Plane1);
    DRAWLINEP(position + 80 - 5, posiy + 1, position + 80 - 5, posiy + 7, set, Buffer_Plane1);
}
//##########################################################################################################################################################

void Display::OverDrawZeroSign(unsigned char *sign, long addressnew)
{
    OVERWRITE2BYTE(sign[2], sign[3], addressnew + 0x000);
    OVERWRITE2BYTE(sign[4], sign[5], addressnew + 0x050);
    OVERWRITE2BYTE(sign[6], sign[7], addressnew + 0x0A0);
    OVERWRITE2BYTE(sign[8], sign[9], addressnew + 0x0F0);
    OVERWRITE2BYTE(sign[10], sign[11], addressnew + 0x140);
    OVERWRITE2BYTE(sign[12], sign[13], addressnew + 0x190);
    OVERWRITE2BYTE(sign[14], sign[15], addressnew + 0x1E0);
    OVERWRITE2BYTE(sign[16], sign[17], addressnew + 0x230);
    OVERWRITE2BYTE(sign[18], sign[19], addressnew + 0x280);
    OVERWRITE2BYTE(sign[20], sign[21], addressnew + 0x2D0);
    OVERWRITE2BYTE(sign[22], sign[23], addressnew + 0x320);
    OVERWRITE2BYTE(sign[24], sign[25], addressnew + 0x370);
    OVERWRITE2BYTE(sign[26], sign[27], addressnew + 0x3C0);
    OVERWRITE2BYTE(sign[28], sign[29], addressnew + 0x410);
    OVERWRITE2BYTE(sign[30], sign[31], addressnew + 0x460);
    OVERWRITE2BYTE(sign[32], sign[33], addressnew + 0x4B0);
}
//##########################################################################################################################################################

void Display::RemoveZeroSignBack(long addressold)
{
    CLEAR2BYTEBACK(addressold + 0x04F);
    CLEAR2BYTEBACK(addressold + 0x09F);
    CLEAR2BYTEBACK(addressold + 0x0EF);
    CLEAR2BYTEBACK(addressold + 0x13F);
    CLEAR2BYTEBACK(addressold + 0x18F);
    CLEAR2BYTEBACK(addressold + 0x1DF);
    CLEAR2BYTEBACK(addressold + 0x22F);
    CLEAR2BYTEBACK(addressold + 0x27F);
    CLEAR2BYTEBACK(addressold + 0x2CF);
    CLEAR2BYTEBACK(addressold + 0x31F);
    CLEAR2BYTEBACK(addressold + 0x36F);
    CLEAR2BYTEBACK(addressold + 0x3BF);
    CLEAR2BYTEBACK(addressold + 0x40F);
    CLEAR2BYTEBACK(addressold + 0x45F);
    CLEAR2BYTEBACK(addressold + 0x4AF);
    CLEAR2BYTEBACK(addressold + 0x4FF);
    CLEAR2BYTEBACK(addressold + 0x54F);
    CLEAR2BYTEBACK(addressold + 0x59F);
    CLEAR2BYTEBACK(addressold + 0x5EF);
    CLEAR2BYTEBACK(addressold + 0x63F);
    CLEAR2BYTEBACK(addressold + 0x68F);
    CLEAR2BYTEBACK(addressold + 0x6DF);
    CLEAR2BYTEBACK(addressold + 0x72F);
    CLEAR2BYTEBACK(addressold + 0x77F);
    CLEAR2BYTEBACK(addressold + 0x7CF);
    CLEAR2BYTEBACK(addressold + 0x81F);
    CLEAR2BYTEBACK(addressold + 0x86F);
    CLEAR2BYTEBACK(addressold + 0x8BF);
    CLEAR2BYTEBACK(addressold + 0x90F);
}
//##########################################################################################################################################################

void Display::DrawZeroSignBack(unsigned char *sign, long addressnew)
{
    WRITE2BYTEBACK(sign[2], sign[3], addressnew + 0x04F);
    WRITE2BYTEBACK(sign[4], sign[5], addressnew + 0x09F);
    WRITE2BYTEBACK(sign[6], sign[7], addressnew + 0x0EF);
    WRITE2BYTEBACK(sign[8], sign[9], addressnew + 0x13F);
    WRITE2BYTEBACK(sign[10], sign[11], addressnew + 0x18F);
    WRITE2BYTEBACK(sign[12], sign[13], addressnew + 0x1DF);
    WRITE2BYTEBACK(sign[14], sign[15], addressnew + 0x22F);
    WRITE2BYTEBACK(sign[16], sign[17], addressnew + 0x27F);
    WRITE2BYTEBACK(sign[18], sign[19], addressnew + 0x2CF);
    WRITE2BYTEBACK(sign[20], sign[21], addressnew + 0x31F);
    WRITE2BYTEBACK(sign[22], sign[23], addressnew + 0x36F);
    WRITE2BYTEBACK(sign[24], sign[25], addressnew + 0x3BF);
    WRITE2BYTEBACK(sign[26], sign[27], addressnew + 0x40F);
    WRITE2BYTEBACK(sign[28], sign[29], addressnew + 0x45F);
    WRITE2BYTEBACK(sign[30], sign[31], addressnew + 0x4AF);
    WRITE2BYTEBACK(sign[32], sign[33], addressnew + 0x4FF);
    WRITE2BYTEBACK(sign[34], sign[35], addressnew + 0x54F);
    WRITE2BYTEBACK(sign[36], sign[37], addressnew + 0x59F);
    WRITE2BYTEBACK(sign[38], sign[39], addressnew + 0x5EF);
    WRITE2BYTEBACK(sign[40], sign[41], addressnew + 0x63F);
    WRITE2BYTEBACK(sign[42], sign[43], addressnew + 0x68F);
    WRITE2BYTEBACK(sign[44], sign[45], addressnew + 0x6DF);
    WRITE2BYTEBACK(sign[46], sign[47], addressnew + 0x72F);
    WRITE2BYTEBACK(sign[48], sign[49], addressnew + 0x77F);
    WRITE2BYTEBACK(sign[50], sign[51], addressnew + 0x7CF);
    WRITE2BYTEBACK(sign[52], sign[53], addressnew + 0x81F);
    WRITE2BYTEBACK(sign[54], sign[55], addressnew + 0x86F);
    WRITE2BYTEBACK(sign[56], sign[57], addressnew + 0x8BF);
    WRITE2BYTEBACK(sign[58], sign[59], addressnew + 0x90F);
}
//##########################################################################################################################################################

void Display::CLEAR2BYTE(long addressold)
{
    asm("
  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 2

  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 3
		");	
}
//##########################################################################################################################################################

void Display::WRITE2BYTE(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           FILL8	%r0, %i1             			
           ST8S		[%i2], %r0, 2
  				
           FILL8	%r0, %i0             			
           ST8S		[%i2], %r0, 3
		");	
}
//##########################################################################################################################################################

void Display::OVERWRITE2BYTE(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           LD       %r0, [%i2]
           EXT8S    %r0, 2
           OR       %r0, %i1
           FILL8	%r0, %r0
           ST8S		[%i2], %r0, 2

           LD       %r0, [%i2]
           EXT8S    %r0, 3
           OR       %r0, %i0
           FILL8	%r0, %r0             			
           ST8S		[%i2], %r0, 3
		");	
}
//##########################################################################################################################################################

void Display::CLEAR2BYTEBACK(long addressold)
{
    asm("
  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 0

  		   PFX      %hi(0x00)
  		   MOVI     %l1, %lo(0x00)
           FILL8	%r0, %l1				
           ST8S		[%i0], %r0, 1
		");	
}
//##########################################################################################################################################################

void Display::WRITE2BYTEBACK(unsigned char byte1, unsigned char byte2, long addressnew)
{
    asm("
           FILL8	%r0, %i1             			
           ST8S		[%i2], %r0, 0
  				
           FILL8	%r0, %i0             			
           ST8S		[%i2], %r0, 1
		");	
}
//##########################################################################################################################################################

void Display::DRAWZEROPOPUP(int channel)
{
	int x, y;
	int pos = 0;
	int volt = 0;
	
	
	float voltoff = 0;
	char voltstrn[20];
	char voltunit[3] = "uV";	
	
	unsigned char PixelBuffer;

	double factor = 0;
	double ffactor = 0;	
	
	short *fprobe = 0;
	int *fzeropos = 0;
	volatile char *fselected_voltage = 0;
	
	Hardware::ResetTimer();

	switch (channel)
	{
		case 1:
		{
			fprobe = &MenuStatus[1][3];
			fselected_voltage = &Selected_Voltage_CH1;
			fzeropos = &ZeroLevelCH1;			
			break;
		}	
		case 2:
		{
			fprobe = &MenuStatus[2][3];
			fselected_voltage = &Selected_Voltage_CH2;
			fzeropos = &ZeroLevelCH2;
			break;
		}
		case 3:
		{
			fprobe = &MenuStatus[3][3];
			fselected_voltage = &Selected_Voltage_CH3;
			fzeropos = &ZeroLevelCH3;
			break;
		}
		case 4:
		{
			fprobe = &MenuStatus[4][3];
			fselected_voltage = &Selected_Voltage_CH4;
			fzeropos = &ZeroLevelCH4;
			break;
		}
	}
	
	if ((channel != dzp_channel_buf) || (*fprobe != dzp_fprobe_buf) || (*fselected_voltage != dzp_fselected_voltage_buf))
	{								
		switch((int) *fselected_voltage)
		{
			case 0:	 factor = 20.833333; break;
			case 1:	 factor = 41.666666; break;
			case 2:	 factor = 104.166666; break;
			case 3:	 factor = 208.333333; break;
			case 4:	 factor = 416.666666; break;
			case 5:	 factor = 1041.666666; break;
			case 6:	 factor = 2083.33333; break;
			case 7:	 factor = 4166.66666; break;
			case 8:	 factor = 10416.6666; break;
			case 9:	 factor = 20833.3333; break;
			case 10: factor = 41666.6666; break;
			case 11: factor = 104166.66; break;																						
		}

		switch ((int) *fprobe)
		{
			case 101: ffactor = 10000000; break;
			case 102: ffactor = 5000000; break;
			case 103: ffactor = 2000000; break;
			case 104: ffactor = 1000000; break;
			case 105: ffactor = 500000; break;
			case 106: ffactor = 200000; break;
			case 107: ffactor = 100000; break;
			case 108: ffactor = 50000; break;
			case 109: ffactor = 20000; break;
			case 110: ffactor = 10000; break;
			case 111: ffactor = 5000; break;
			case 112: ffactor = 2000; break;
			case 113: ffactor = 1000; break;
		}
			
		factor = factor / ffactor;
		
		dzp_factor_buf = factor;
		dzp_channel_buf = channel;
		dzp_fprobe_buf = *fprobe;
		dzp_fselected_voltage_buf = *fselected_voltage;
	}
	else factor = dzp_factor_buf;
		
// BF del	voltoff =  (float)(*fzeropos - 0xC0) * factor;  // Mitte ist (GRID_HEIGHT / 2) (0xC0) =>  Mitte 128 (0x80) * 1.5
	
	voltoff =  (float)(*fzeropos - (GRID_HEIGHT / 2)) * factor;  // Mitte ist (GRID_HEIGHT / 2) BF
				
	switch (channel)
	{
		case 1:			
		{
			Zero_Level1_Str.Write_Value(voltoff);	
			Zero_Level1_Str.RenderText();
			break;
		}
		case 2:	
		{
			Zero_Level2_Str.Write_Value(voltoff);	
			Zero_Level2_Str.RenderText();
			break;
		}
		case 3:			
		{
			Zero_Level3_Str.Write_Value(voltoff);	
			Zero_Level3_Str.RenderText();
			break;
		}
		case 4:			
		{
			Zero_Level4_Str.Write_Value(voltoff);	
			Zero_Level4_Str.RenderText();
			break;
		}
	}	
	if (ZeroPopupChanged == 0)
	{
		//DRAWP(450, 51, 160, 22, 1, UI_Plane1);	
		//DRAWP(450, 51, 160, 22, 1, Buffer_UI2Plane);
		
		DRAWROUNDBUTTON(447, 51, 166, 25, btnUnpushed, btnDraw);
		
	}
	else DRAWP(460, 51, 150, 21, 0, UI_Plane2);
	
	ZeroPopupChanged = 1;		
	
	switch (channel)
	{
		case 1:	TEXTOUTxvbig(Zero_Level1_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 2:	TEXTOUTxvbig(Zero_Level2_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 3:	TEXTOUTxvbig(Zero_Level3_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text	
		case 4:	TEXTOUTxvbig(Zero_Level4_Str.Read_Text(), 460, 55, 1, UI_Plane2);break;	// Draw Zero Text
	}
	//timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer
}
//##########################################################################################################################################################

void Display::DRAWZEROPOPDOWN(void)
{
	char Ct;
	
	int xa = 50 * 20;
	
	for (Ct = 0; Ct < 24; Ct++)
	{			
		*(UI_Plane1 + xa + 14) = 0;
		*(UI_Plane1 + xa + 15) = 0; 
		*(UI_Plane1 + xa + 16) = 0; 
		*(UI_Plane1 + xa + 17) = 0; 
		*(UI_Plane1 + xa + 18) = 0; 
		*(UI_Plane1 + xa + 19) = *(UI_Plane1 + xa + 19) & 0x0000000F;

		*(Buffer_UI2Plane + xa + 14) = 0;
		*(Buffer_UI2Plane + xa + 15) = 0;
		*(Buffer_UI2Plane + xa + 16) = 0;
		*(Buffer_UI2Plane + xa + 17) = 0;
		*(Buffer_UI2Plane + xa + 18) = 0;
		*(Buffer_UI2Plane + xa + 19) = *(Buffer_UI2Plane + xa + 19) & 0x0000000F;

		*(UI_Plane3 + xa + 14) = 0;
		*(UI_Plane3 + xa + 15) = 0;
		*(UI_Plane3 + xa + 16) = 0;
		*(UI_Plane3 + xa + 17) = 0;
		*(UI_Plane3 + xa + 18) = 0;
		*(UI_Plane3 + xa + 19) = *(UI_Plane3 + xa + 19) & 0x0000000F;

		*(UI_Plane4 + xa + 14) = 0;
		*(UI_Plane4 + xa + 15) = 0;
		*(UI_Plane4 + xa + 16) = 0;
		*(UI_Plane4 + xa + 17) = 0;
		*(UI_Plane4 + xa + 18) = 0;
		*(UI_Plane4 + xa + 19) = *(UI_Plane4 + xa + 19) & 0x0000000F;

		*(UI_Plane5 + xa + 14) = 0;
		*(UI_Plane5 + xa + 15) = 0;
		*(UI_Plane5 + xa + 16) = 0;
		*(UI_Plane5 + xa + 17) = 0;
		*(UI_Plane5 + xa + 18) = 0;
		*(UI_Plane5 + xa + 19) = *(UI_Plane5 + xa + 19) & 0x0000000F;
		xa += 20;
	}	
	ZeroPopupChanged = 0;
	UpdateMenuTextPlane = true;
}
//##########################################################################################################################################################
//multiply signals
void Display::CalcMathMul(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{
	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;
	

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2];
		
		//and rescale
		if (lvalue1 > 0)
		lvalue1 /= math_voltage_factor[math_scale];
		else if (lvalue1 < 0)
		{lvalue1 *= -1;lvalue1 /= math_voltage_factor[math_scale]; lvalue1 *= -1;}
		
		if (lvalue2 > 0)
		lvalue2 /= math_voltage_factor[math_scale];
		else if (lvalue2 < 0)
		{lvalue2 *= -1;lvalue2 /= math_voltage_factor[math_scale]; lvalue2 *= -1;}
		
		//predivision
		lvalue1 *= predivisor[MenuStatus[1][3] - 104];
		lvalue2 *= predivisor[MenuStatus[2][3] - 104];

		//calculate math signal
		lbuffer = lvalue1 * lvalue2;
						
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}

		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	
	}


}
//##########################################################################################################################################################
//subtract signals
void Display::CalcMathSub(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{

	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104];
		
		//calculate math signal
		lbuffer = lvalue1 - lvalue2;
		
		//and rescale
		if (lbuffer > 0)
		lbuffer /= math_voltage_factor[math_scale];
		else if (lbuffer < 0)
		{lbuffer *= -1;lbuffer /= math_voltage_factor[math_scale]; lbuffer *= -1;}
		
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}
		
		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	}


}
//##########################################################################################################################################################
//add signals
void Display::CalcMathAdd(int start, int stop, int stepwidth ,unsigned char *SignalData1, unsigned char *SignalData2, unsigned char *MathData)
{
	int lix, lfactor;
	int lbuffer, lvalue1,lvalue2;

	for (lix = start; lix < stop  && !UI_request; lix+=stepwidth)
	//for (lix = draw_start + Trigger_Offset_Calc; lix < lstop && !UI_request; lix+=lfactor)
	{
		//convert to signed integer
		lvalue1 = SignalData1[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1]));
		lvalue2 = SignalData2[lix] - (ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2]));

		//scale signals
		lvalue1 = lvalue1 * math_voltage_factor[Selected_Voltage_CH1] * predivisor[MenuStatus[1][3] - 104];
		lvalue2 = lvalue2 * math_voltage_factor[Selected_Voltage_CH2] * predivisor[MenuStatus[2][3] - 104];
		
		//calculate math signal
		lbuffer = lvalue1 + lvalue2;

		//and rescale
		if (lbuffer > 0)
		lbuffer /= math_voltage_factor[math_scale];
		else if (lbuffer < 0)
		{ lbuffer *= -1;lbuffer /= math_voltage_factor[math_scale]; lbuffer *= -1;}
		
		//limiter
		if (lbuffer > (ADC_ZERO+1))
		{ lbuffer = (ADC_ZERO+1);}
		else if (lbuffer < -ADC_ZERO)
		{ lbuffer = -ADC_ZERO;}

		//convert to unsigned and save as char
		MathData[lix] = lbuffer + ADC_ZERO;
	}


}
//##########################################################################################################################################################
// BF Signal processing
void Display::ProcessSignalData(void)
{
	unsigned char *lp_sig1 = NULL;	//pointer to signal 1
	unsigned char *lp_sig2 = NULL;	//pointer to signal 2
	unsigned char *lp_sigM = NULL;	//pointer to math signal 

	int lix, lfactor, lcalcstop;

	if (UI_request && (USTB_Mode == USTB_OFF)) return;	

	// generate test signals
	//if(test_signal)
	//{ TestSignalGenerate(); }

//---------------------------------------------------------------------------------------
//		Calculate Window size for drawing
//---------------------------------------------------------------------------------------
	if (Selected_Timebase < 4) //BF 20ns + 10ns + 5ns + 2ns main mode - interpolated signal
	{
		draw_start = 0; //(short) MemWinStart + Trigger_Offset_Calc;
		//if (draw_start < 0) draw_start = 0;

		//BF not needed    draw_stop  = draw_start + GRID_WIDTH;
		draw_factor = 1;

		//set pointers to signals
		lp_sig1 = &SIGNAL1_Intpolate[0];
		lp_sig2 = &SIGNAL2_Intpolate[0];
		lp_sigM = &SIGNALM_Intpolate[0];
	}
	else if (FFT_Mode != FFT_OFF || USTB_Mode != USTB_OFF)
	{
		draw_start = 0;
		draw_factor = 1;
	}
	else //BF >= 50ns main mode - true signal
	{
		//BF draw_start = (short) MemWinStart + 40;
		draw_start = (short) MemWinStart + Trigger_Offset_Calc;

		if (draw_start < 0) draw_start = 0;
		
		//BF not needed    draw_stop = draw_start + SIG_Size[ZIT_short] - 1;
		draw_factor = (short) ZFT_float;
		
		//set pointers to signals
		lp_sig1 = &SIGNAL1[0];
		lp_sig2 = &SIGNAL2[0];
		lp_sigM = &SIGNALM[0];
	}


	if (MenuStatus[10][1] == 1)	//Delayed
	{
		if (dmode_Selected_Timebase < 4) //20ns + 10ns delayed mode  - interpolated signal
		{
			draw_dm_ixstart = 0;		//(short) MemWinStart + (dmode_Window_Offset_Pos * ZFT_float) + Trigger_Offset_Calc;
	
			draw_dm_ixfactor = (short) ZFT_float_dmode;	
	
			draw_dm_ixoffset = (short) ((float) dmode_Window_Offset_Pos * ZFT_float) + MemWinStart;
		}
		else	// >= 50ns delayed mode - true signal
		{
			draw_dm_ixstart = MemWinStart + (short)((float)(((GRID_WIDTH / 2) - (short) (Cursor_Delayed_Size / 2)) + dmode_Window_Offset_Pos) * ZFT_float);

			draw_dm_ixfactor = (short) ZFT_float_dmode;	
		}
		lfactor = 1;	//calculate all math values
	}	
	else //Main Mode
	{ lfactor = draw_factor; } 

	//width of calculating for math functions
	lcalcstop = draw_start + ((GRID_WIDTH + 30) * draw_factor);
	if (lcalcstop > 16383){lcalcstop = 16383;}

        //--------------------------------------------------------------------------------------
	//        		 ultra slow timebase mode (roll mode / shift mode)
	//--------------------------------------------------------------------------------------
	if (USTB_NewData)
	{
		unsigned char lchannelcnt = 0;
		//get number of active channels
		if (Channel_1_Active) lchannelcnt ++;	
		if (Channel_2_Active) lchannelcnt ++;	
		if (Channel_3_Active) lchannelcnt ++;	
		if (Channel_4_Active) lchannelcnt ++;	

		USTB_NewData = 0;

		//refresh rate 
		switch(Selected_Timebase)
		{
			case 24: USTB_Refresh += (30 / lchannelcnt);	break;	//1S/Div
			case 25: USTB_Refresh += (60 / lchannelcnt);	break;	//2S/Div
			case 26: USTB_Refresh += (600 / lchannelcnt);	break;	//5S/Div
			case 27: USTB_Refresh += 600;	break;	//10S/Div
			case 28: USTB_Refresh += 600;	break;	//20S/Div
			case 29: USTB_Refresh += 600;	break;	//50S/Div
			case 30: USTB_Refresh += 600;	break;	//100S/Div
			case 31: USTB_Refresh += 600;	break;	//200S/Div
		}

		//Check for time pointer overflow
		if(USTB_Roll_idx > GRID_WIDTH)
		USTB_Roll_idx = 0;


		if (USTB_Mode == USTB_ROLL)	//roll mode
		{
			if (Channel_1_Active)	
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL1[0], &SIGNAL1_USTB[0]); }

			if (Channel_2_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL2[0], &SIGNAL2_USTB[0]); }

			if (Channel_3_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL3[0], &SIGNAL3_USTB[0]); }

			if (Channel_4_Active)
			{ USTB_roll_signal(USTB_Roll_idx, &SIGNAL4[0], &SIGNAL4_USTB[0]); }

			//increment time pointer
			USTB_Roll_idx ++;
		}
		else if (USTB_Mode == USTB_SHIFT)	//shift mode
		{
			if (Channel_1_Active)	
			{ USTB_shift_signal(&SIGNAL1[0], &SIGNAL1_USTB[0]); }

			if (Channel_2_Active)
			{ USTB_shift_signal(&SIGNAL2[0], &SIGNAL2_USTB[0]); }

			if (Channel_3_Active)
			{ USTB_shift_signal(&SIGNAL3[0], &SIGNAL3_USTB[0]); }

			if (Channel_4_Active)
			{ USTB_shift_signal(&SIGNAL4[0], &SIGNAL4_USTB[0]); }
		}
	
	}

        //--------------------------------------------------------------------------------------
	//        	 Interpolation (time stretch) for timebase 20ns, 10ns (5ns)
	//--------------------------------------------------------------------------------------
	if(USTB_Mode == USTB_OFF && FFT_Mode == FFT_OFF)	
	{
		if (Channel_1_Active)
		{	
			if (Selected_Timebase < 4)
			{ Interpolate(Selected_Timebase, MemWinStart + Trigger_Offset_Calc, &SIGNAL1[0], &SIGNAL1_Intpolate[0]); }
			
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4)) //delayed mode
			{ Interpolate(dmode_Selected_Timebase, draw_dm_ixoffset, &SIGNAL1[0], &SIGNAL1_Intpolate_delayed[0]); }
		}
		
		if (Channel_2_Active)
		{	
			if (Selected_Timebase < 4)
			{ Interpolate(Selected_Timebase, MemWinStart + Trigger_Offset_Calc, &SIGNAL2[0], &SIGNAL2_Intpolate[0]); }
			
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))	//delayed mode
			{ Interpolate(dmode_Selected_Timebase, draw_dm_ixoffset, &SIGNAL2[0], &SIGNAL2_Intpolate_delayed[0]); }
		}	
		//4-Channel Version
		if (NumberOfChannels > 2)
		{	
			if (Channel_3_Active)
			{	
				if (Selected_Timebase < 4)
				{ Interpolate(Selected_Timebase, MemWinStart + Trigger_Offset_Calc, &SIGNAL3[0], &SIGNAL3_Intpolate[0]); }
				
				if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))	//delayed mode
				{ Interpolate(dmode_Selected_Timebase, draw_dm_ixoffset, &SIGNAL3[0], &SIGNAL3_Intpolate_delayed[0]); }
			}	
			
			if (Channel_4_Active)
			{		   	
				if (Selected_Timebase < 4)
				{ Interpolate(Selected_Timebase, MemWinStart + Trigger_Offset_Calc, &SIGNAL4[0], &SIGNAL4_Intpolate[0]); }
				
				if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))	//delayed mode
				{ Interpolate(dmode_Selected_Timebase, draw_dm_ixoffset, &SIGNAL4[0], &SIGNAL4_Intpolate_delayed[0]); }
			}
		}	

	}
	
	//---------------------------------------------------------------------------------------
	//				Noise suppression
	//---------------------------------------------------------------------------------------
		
	if (MenuStatus[MENU_ACQUIRE][2] && draw_factor > 1 && FFT_Mode == FFT_OFF && USTB_Mode == USTB_OFF)
	{
		int lstop = draw_start + (GRID_WIDTH * draw_factor) + draw_factor;
		int lmin;					//values to the left side
		int lmax;					//values to the right side
		int lsum;					//totals


		if (draw_factor == 2)
		{
			lmin = -1;
			lmax = 1;	

			for(int i=draw_start;i < lstop ;i+=draw_factor)		// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
				
					SIGNAL1[i] = (unsigned char)(lsum/3);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
				
					SIGNAL2[i] = (unsigned char)(lsum/3);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
				
					SIGNAL3[i] = (unsigned char)(lsum/3);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
				
					SIGNAL4[i] = (unsigned char)(lsum/3);	// calculate average
				}
			}

		}
		else if (draw_factor == 4 || draw_factor == 5)
		{
			lmin = -3;
			lmax = 4;
	
			for(int i=draw_start;i < lstop ;i+=draw_factor)		// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
					
					SIGNAL1[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
					
					SIGNAL2[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
					
					SIGNAL3[i] = (unsigned char)(lsum>>3);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
					
					SIGNAL4[i] = (unsigned char)(lsum>>3);	// calculate average
				}

			}
		}
		else if (draw_factor >= 10)
 		{
			lmin = -7;
			lmax = 8;
	
			for(int i=draw_start;i < lstop ;i+=draw_factor)	// go to next value
			{
				if (Channel_1_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL1[i+f];
					
					SIGNAL1[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_2_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL2[i+f];
					
					SIGNAL2[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_3_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL3[i+f];
					
					SIGNAL3[i] = (unsigned char)(lsum>>4);	// calculate average
				}
				if (Channel_4_Active)
				{
					lsum = 0;
					for(int f=lmin;f<=lmax;f++)		// add the values from the left and the right
					lsum += SIGNAL4[i+f];
					
					SIGNAL4[i] = (unsigned char)(lsum>>4);	// calculate average
				}
			}
		}

	}

	//---------------------------------------------------------------------------------------
	//				MATH functions
	//---------------------------------------------------------------------------------------
	
	if (Channel_Math_Active == 1)
	{

		//---------------------------------------------
		//         MATH function FFT
		//---------------------------------------------
		if (FFT_Mode != FFT_OFF)               	// fft
		{
			if(FFT_NewData)	// BF calculate spectrum
			{ 
				if(Channel_1_Active) FFT_CalcSpectrum(&SIGNAL1[0],&SPECTRUM[0]);
				else if(Channel_2_Active) FFT_CalcSpectrum(&SIGNAL2[0],&SPECTRUM[0]);
				else if(Channel_3_Active) FFT_CalcSpectrum(&SIGNAL3[0],&SPECTRUM[0]);
				else if(Channel_4_Active) FFT_CalcSpectrum(&SIGNAL4[0],&SPECTRUM[0]);
			}	
			
			return;
		}	

		//---------------------------------------------
		//         MATH function multiply
		//---------------------------------------------
		if ((MenuStatus[26][2] == 1) && ((Channel_1_Active) && (Channel_2_Active)))      		// multiply 
		{	
			//set global math scaling and offset for drawing routine
			math_scale = math_mul_scale - 166;
			Math_Offset = Math_Mul_Offset;
			
			//calculate main math signal
			CalcMathMul(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);
			
			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))
			{ CalcMathMul(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//multiply end

		//---------------------------------------------
		//         MATH function subtract
		//---------------------------------------------

		else if ((MenuStatus[26][3] == 1) && ((Channel_1_Active) && (Channel_2_Active)))            	// subtract
		{	
			//set global math scaling and offset for drawing routine
			math_scale = math_sub_scale - 150;
			Math_Offset = Math_Sub_Offset;
			
			//calculate main math signal
			CalcMathSub(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);

			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))
			{ CalcMathSub(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//subtract end

		//---------------------------------------------
		//         MATH function add
		//---------------------------------------------
		else if ((MenuStatus[26][4] == 1) && ((Channel_1_Active) && (Channel_2_Active)))            	// add
		{
			//set global math scaling and offset for drawing routine
			math_scale = math_add_scale - 150;
			Math_Offset = Math_Add_Offset;
			
			//calculate main math signal
			CalcMathAdd(draw_start, lcalcstop, lfactor, lp_sig1, lp_sig2, lp_sigM);

			//calculate delayed math signal
			if ((MenuStatus[10][1] == 1) && (dmode_Selected_Timebase < 4))
			{ CalcMathAdd(0, GRID_WIDTH+1, 1, &SIGNAL1_Intpolate_delayed[0], &SIGNAL2_Intpolate_delayed[0], &SIGNALM_Intpolate_delayed[0]); }
		}	//add end
/*
		else if (MenuStatus[26][5] == 1)            // free -> not available
		{
		for (ix2 = 0; ix2 < 16384; ix2++)
			{
				SIGNALM[ix2] = (unsigned char) ((int) 127 + (((int) SIGNAL1[ix2] - ((ZeroLevelCH1 + (int) 60) >> 1)) - ((int) SIGNAL2[ix2] - ((ZeroLevelCH2 + (int) 60) >> 1))));
			}
		}
*/


	}//Math End


} //Signal processing end 
//##########################################################################################################################################################
// BF Timebase 50ns is the fastest real timebase. For timebase 20nS, 10nS, 5nS and 2nS the additonal samples must be interpolated 
// BF replaced complete interpolation with a simplified routine
// BF new linear interpolation
void Display::Interpolate(int timebase, int start, unsigned char *SignalData, unsigned char *InterpolateResult)
{
    int ix,iy,incr;
	
	if (UI_request) return;	

	//printf("\r\ninterpolation start %d\r\n", start);	

	if(!test_sw2)
	{
		//printf("Linear interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 25);ix+=25,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 25, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 1)		// 5ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 10);ix+=10,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 10, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 2)		// 10ns 
		{
			for(ix=0,iy=start;ix < (GRID_WIDTH + 5);ix+=5,iy++)
			LinearInterpolation(ix, (int)SignalData[iy], ix + 5, (int)SignalData[iy+1], InterpolateResult);
		}
		else if (timebase == 3)		// 20ns 
		{
			for(ix=0,iy=start,incr=2;ix < (GRID_WIDTH + 25);ix+=incr,iy++)
			{
				//toggle increment
				if(incr == 2){incr = 3;}
				else{incr = 2;}

				LinearInterpolation(ix, (int)SignalData[iy], ix + incr, (int)SignalData[iy+1], InterpolateResult);
			}

		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }
	
	}
	else
	{
		int delta,rx;
		
		//printf("Simple interpolation on TB %d\r\n", timebase);

		if (timebase == 0)		// 2ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-25);ix++,rx+=25)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 25);ix++,rx+=25)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 24 values
				for (int j=1;j <= 24;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 25 -j ) ); }
			}
		}
		else if (timebase == 1)		// 5ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-10);ix++,rx+=10)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 10);ix++,rx+=10)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 9 values
				for (int j=1;j <= 9;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 10 -j ) ); }
			}
		}
		else if (timebase == 2)		// 10ns 
		{
			//for(ix=start,rx=0;rx < ((GRID_WIDTH * 2)-5);ix++,rx+=5)
			for(ix=start,rx=0;rx < (GRID_WIDTH + 5);ix++,rx+=5)
			{
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
				
				//interpolate the next 4 values
				for (int j=1;j <= 4;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( 5 -j ) ); }
			}
	
		}
		else if (timebase == 3)		// 20ns 
		{
			//for(ix=start,rx=0,incr=1;rx < ((GRID_WIDTH * 2)-3);ix++,rx+=(incr+1))
			for(ix=start,rx=0,incr=1;rx < (GRID_WIDTH + 3);ix++,rx+=(incr+1))
			{
				//toggle increment
				if(incr == 1){incr = 2;}
				else{incr = 1;}
	
				//copy original value
				InterpolateResult[rx] = SignalData[ix];
	
				//calc the difference between actual and next value
				delta = (SignalData[ix+1] - SignalData[ix]);
			
				//interpolate the next 1 - 2  values
				for (int j=1;j <= incr;j++)
				{ InterpolateResult[rx+j] = SignalData[ix] + (delta / ( incr + 1 -j ) ); }
			}
		}
		else
		{ printf("\r\nUnsupported timebase %d\r\n", timebase); }

	}
}
//##########################################################################################################################################################
// BF linear interpolation with Bresenham algorithm
void Display::LinearInterpolation(int x1, int y1, int x2, int y2, unsigned char *interpolation)
{
	
	//--------------------------------------------
	//special case horizontal line
	//--------------------------------------------
	if(y1 == y2)
	{
		if(x1 < x2)
		for(; x1 != x2; x1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; x2 != x1; x2++)	{ interpolation[x2] = (char)y1; }
		return;
	}	

	//--------------------------------------------
	//special case vertical line
	//--------------------------------------------
	else if(x1 == x2)
	{
		if(y1 < y2)
		for(; y1 != y2; y1++)	{ interpolation[x1] = (char)y1; }
		else
		for(; y2 != y1; y2++)	{ interpolation[x1] = (char)y2; }
		return;
	}	

	//-------------------------------------------------------------
	// Bresenham algorithm for drawing diagonal lines
	//-------------------------------------------------------------
	int dy = y2 - y1;
        int dx = x2 - x1;
        int stepx, stepy;

	//check if delta is positive or negative
	if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }

	//special case exact 45 degrees delta x / delta y = 1
	if (dx == dy)
	{
		//horizontal and vertical component increment constant with 1 
		if(x1 < x2) 
		{
			if(y1 < y2)
			{ 
				for(; x1 != x2; x1++, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1++, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			
		}
		else if(x1 > x2)
		{
			if(y1 < y2) 
			{
				for(; x1 != x2; x1--, y1++)
				{ interpolation[x1] = (char)y1; }
				return;
			}
			else if(y1 > y2)
			{
				for(; x1 != x2; x1--, y1--)
				{ interpolation[x1] = (char)y1; }
				return;
			}
		}
	}

	
        dy <<= 1;                              		// dy is now 2*dy
        dx <<= 1;                              		// dx is now 2*dx
	
	//set starting point
	interpolation[x1] = (char)y1;
	
	//---------------------------------------------
	//between horizontal and 45 degrees
	//---------------------------------------------
	if (dx > dy)
	{
		int fraction = dy - (dx >> 1);   	// same as 2*dy - dx
		while (x1 != x2) {
			if (fraction >= 0) {
			y1 += stepy;
			fraction -= dx;              	// same as fraction -= 2*dx
			}
			x1 += stepx;
			fraction += dy;          	// same as fraction -= 2*dy
			interpolation[x1] = (char)y1;
		}
        	return;
	}

	//---------------------------------------------
	//between vertical and 45 degrees
	//---------------------------------------------
	if (dx < dy)
	{
		int fraction = dx - (dy >> 1);
		while (y1 != y2) {
			if (fraction >= 0) {
			x1 += stepx;
			fraction -= dy;
			}
			y1 += stepy;
			fraction += dx;
			interpolation[x1] = (char)y1;
		}
		return;
        }

}
//##########################################################################################################################################################
//BF completely redesigned
void Display::DrawSignals(unsigned char on)	// Draw all active signals
{
	unsigned char *lp_Signal     = NULL;
	unsigned char *lp_SigIntpol  = NULL;
	unsigned char *lp_SigIntpDel = NULL;
	unsigned char lvector = 0;

	if(UI_request) return;   //if interrupt from user interface occured don't draw signals

	//set drawing planes
	DrawPlane = 0x00;
	if (Channel_1_Active == 1) DrawPlane |= 0x01;	
	if (Channel_2_Active == 1) DrawPlane |= 0x02;	
	if (Channel_3_Active == 1) DrawPlane |= 0x04;	
	if (Channel_4_Active == 1) DrawPlane |= 0x08;
	if (Channel_Math_Active == 1) DrawPlane |= 0x10;

	// if a menu popup is visible, do not write signals in planes
	if ( Menu_Popup_visible )
	{	
		ClearPlane = DrawPlane | RemovePlane;
		DrawPlane = 0;	
		return;
	}

	//set vector switch
	if (MenuStatus[MENU_DISPLAY][3] == 240)	//Display menu -> Vectors inactive
	{ lvector = 0; }
	else
	{ lvector = 1; }

	//BF refresh control for USTB
	if (USTB_Mode != USTB_OFF)
	{
		if (USTB_Refresh >= 600)
		USTB_Refresh = 0;
		else return;
	}

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                                     draw x/y signal
	//---------------------------------------------------------------------------------------------------------------------------------------	
	if (XY_Mode)
	{ 
		DrawPlane = 0x00;
		if (Channel_1_Active && Channel_2_Active && !UI_request)
		{
			if (Selected_Timebase < 4 || USTB_Mode != USTB_OFF) //Timebase 20nS & 10nS & 5nS & 2nS
			{ DRAWSIGNAL_XY( 1, 2, draw_start, &SIGNAL1_Intpolate[0], &SIGNAL2_Intpolate[0], on, lvector); }
			else
			{ DRAWSIGNAL_XY( 1, 2, draw_start, &SIGNAL1[0], &SIGNAL2[0], on, lvector); }
			
			DrawPlane |= 0x01;
		}
		
		if (Channel_3_Active && Channel_4_Active && !UI_request)
		{
			if (Selected_Timebase < 4 || USTB_Mode != USTB_OFF)  //Timebase 20nS & 10nS & 5nS & 2nS
			{ DRAWSIGNAL_XY( 3, 4, draw_start, &SIGNAL3_Intpolate[0], &SIGNAL4_Intpolate[0], on, lvector); }
			else
			{ DRAWSIGNAL_XY( 3, 4, draw_start, &SIGNAL3[0], &SIGNAL4[0], on, lvector); }

			DrawPlane |= 0x04;
		}

		ClearPlane = DrawPlane | RemovePlane;
        	DrawPlane = 0;

		return;
	}

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                                  draw f/y spectrum (FFT)
	//---------------------------------------------------------------------------------------------------------------------------------------	
	if (FFT_Mode != FFT_OFF)
	{ 
		if(FFT_NewData)
		{ 	
			DRAWSPECTRUM_FY(on); FFT_NewData = 0; 
			//DrawPlane =  0x10;
			ClearPlane = DrawPlane | RemovePlane;
        		DrawPlane = 0x00;
		}
		return;
	}

	//---------------------------------------------------------------------------------------------------------------------------------------	
	//                            draw time signal t/y of active channels one after another
	//---------------------------------------------------------------------------------------------------------------------------------------	

	for (unsigned char lv_channel = 1 ; lv_channel <= 5 ; lv_channel ++ )
	{
		if(UI_request) //if interrupt occured don't draw next signals
        	{ 
			ClearPlane = DrawPlane | RemovePlane;
        		DrawPlane  = 0;	
			//UI_request = 0;
			return;
		}

		switch (lv_channel)
		{
			case 1: if(Channel_1_Active)
				{ lp_Signal = &SIGNAL1[0]; lp_SigIntpol = &SIGNAL1_Intpolate[0]; lp_SigIntpDel = &SIGNAL1_Intpolate_delayed[0]; }
				else continue; break;
			case 2: if(Channel_2_Active)
				{ lp_Signal = &SIGNAL2[0]; lp_SigIntpol = &SIGNAL2_Intpolate[0]; lp_SigIntpDel = &SIGNAL2_Intpolate_delayed[0]; }
				else continue; break;
			case 3: if(Channel_3_Active)
				{ lp_Signal = &SIGNAL3[0]; lp_SigIntpol = &SIGNAL3_Intpolate[0]; lp_SigIntpDel = &SIGNAL3_Intpolate_delayed[0]; }
				else continue; break;
			case 4: if(Channel_4_Active)
				{ lp_Signal = &SIGNAL4[0]; lp_SigIntpol = &SIGNAL4_Intpolate[0]; lp_SigIntpDel = &SIGNAL4_Intpolate_delayed[0]; }
				else continue; break;
			case 5: if(Channel_Math_Active)
				{ lp_Signal = &SIGNALM[0]; lp_SigIntpol = &SIGNALM_Intpolate[0]; lp_SigIntpDel = &SIGNALM_Intpolate_delayed[0]; }
				else continue; break;
		}

		//-------------------------------------------------
		//draw T-Y time signal
		//-------------------------------------------------
		if (Selected_Timebase < 4) //Timebase 20nS & 10nS & 5nS -> interpolated timebases
		{
			//Draw main Signal (in delayed mode into top window (window = 1)
			DRAWSIGNAL_TY(lv_channel, 1, draw_factor, draw_start, lp_SigIntpol, on, lvector);

			if (MenuStatus[10][1] == 1)	//Delayed mode -> draw into bottom window (window = 2)
			{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lp_SigIntpDel, on, lvector); }
		}
		else if (Selected_Timebase >= 4 && USTB_Mode == USTB_OFF)	//Timebase 50nS - 200mS
		{
			//Draw main Signal (in delayed mode into top window (window = 1)
			//printf("\ndrawing in main mode with Timebase %d\n", Selected_Timebase);	

			DRAWSIGNAL_TY(lv_channel, 1, draw_factor, draw_start, lp_Signal, on, lvector);
			
			if (MenuStatus[10][1] == 1)	//Delayed mode -> draw into bottom window (window = 2)
			{
				if (dmode_Selected_Timebase < 4)	//delayed timebase 20ns & 10ns & 5 ns
				{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lp_SigIntpDel, on, lvector); }
				else					//delayed timebase >= 50ns
				{ DRAWSIGNAL_TY(lv_channel, 2, draw_dm_ixfactor, draw_dm_ixstart, lp_Signal, on, lvector); }
			}
		}
		else if (USTB_Mode != USTB_OFF)	//USTB mode timebase 1S - 200S
		{
			DRAWSIGNAL_TY(lv_channel, 1, 1, 0, lp_SigIntpol, on, lvector);
		}

	} //Channel loop end


        ClearPlane = DrawPlane | RemovePlane;
        DrawPlane = 0x00;	

	if ((QM_Enabled) && (QM_Type[0] > 0)) Display::CALCQMDATA();


}

//##########################################################################################################################################################
/* BF del not used
void Display::Clear_Flips(void)
{
    return;

    if (screen_sel == 0)
    {
        if (NumberOfChannels == 2) Hardware::Planes_clear_asm_all(3, 0x009311F0, 0x0093A7F0, 0x009569F0, 0x00000000, 0x00000000);
        else Hardware::Planes_clear_asm_all(5, 0x009311F0, 0x0093A7F0, 0x00943DF0, 0x0094D3F0, 0x009569F0);
    }
    else
    {
        if (NumberOfChannels == 2) Hardware::Planes_clear_asm_all(3, 0x0098EDF0, 0x009983F0, 0x009B45F0, 0x00000000, 0x00000000);
        else Hardware::Planes_clear_asm_all(5, 0x0098EDF0, 0x009983F0, 0x009A19F0, 0x009AAFF0, 0x009B45F0);
    }
    if (Debug_Mode) printf("clear flips\n");
} */
//##########################################################################################################################################################

/* BF del not used
//void Display::CopySignal(unsigned long *Buffer_Adr1, unsigned long *Plane_Adr1, unsigned long *Buffer_Adr2, unsigned long *Plane_Adr2, unsigned long *Buffer_Adr3, unsigned long *Plane_Adr3, unsigned char count)
void Display::CopySignal(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
    return;

	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)
	
                    loopcs2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)
	
                    loopcs3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(4096)                         ; Set Counter
                    MOVI	%l1,%lo(4096)

                    loopcs5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     loopcs5
                    NOP 	
                ");
            break;
        }
    }
}
*/

//##########################################################################################################################################################

// Draw Time Signal on T-Y axis		BF -> complete new drawing routine for all time signals incl. delayed signals
void Display::DRAWSIGNAL_TY(unsigned int channel, unsigned char windows, unsigned int timefactor, unsigned int ixstart, unsigned char *DisplayData, unsigned char on, unsigned char vector)
{
	int   ZeroLevel = 0;
//	int   alpha_cor = 0;
//	float beta_cor  = 1;

	unsigned long *plane = NULL;

	short P1 = 0;
	short P2 = 0;
	short P3 = 0;	

	short factor_buff = timefactor;	
	short display_min;
	short display_max;
	
	int   lix = 0; 			//signal index
	int   lposx = 0;		//grid position

	int lscale_int_factor = 1, lscale_shift_factor = 1;
	unsigned char ldmode = 0, lInterpol = 0;



/*
printf("\r\n-----------------------------------------------------------\r\n");
printf("channel                 = %d\r\n", channel);
printf("Selected_Timebase       = %d\r\n", Selected_Timebase);
printf("dmode_Selected_Timebase = %d\r\n", dmode_Selected_Timebase);
printf("factor                  = %d\r\n", factor);
printf("offset                  = %d\r\n", offset);
printf("Trigger_Offset_Calc     = %d\r\n", TOC_Buf);
printf("windows                 = %d\r\n", windows);
printf("on                      = %d\r\n", on);
printf("vector                  = %d\r\n", vector);
*/



	if (MenuStatus[10][1] == 1)	//Delayed mode
	ldmode = 1;
	else
	ldmode = 0;

	//----------------------------------------
	//set channel depending parameters
	//----------------------------------------
	if (channel == 1)
	{	
		plane = Buffer_Plane1;			// pointer to display layer
		//pix  = &SIGNAL1_SUM_MIN[0];		// pointer to signal buffer (1200 byte)
		//pix2 = &SIGNAL1_SUM_MAX[0];		// pointer to signal buffer (1200 byte)
		//ZeroLevel = ZeroLevelCH1 + GRID_YOFFS;	//without zero shift
		ZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//with zero shift the draw zero is in the middle of the grid
		
		//Calculate scaling factor
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH1];
		lscale_shift_factor = scale_shift_factor[ldmode][Selected_Voltage_CH1];

	}	

	if (channel == 2)
	{	
		plane = Buffer_Plane2;			//Channel_Plane2;
		//pix  = &SIGNAL2_SUM_MIN[0];
		//pix2 = &SIGNAL2_SUM_MAX[0];	
		//ZeroLevel = ZeroLevelCH2 + GRID_YOFFS;		
		ZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//with zero shift the draw zero is in the middle of the grid
		
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH2];
		lscale_shift_factor = scale_shift_factor[ldmode][Selected_Voltage_CH2];
 
	}
	
	if (channel == 3)
	{		
		plane = Buffer_Plane3;			//Channel_Plane3;
		//pix  = &SIGNAL3_SUM_MIN[0];
		//pix2 = &SIGNAL3_SUM_MAX[0];	
		//ZeroLevel = ZeroLevelCH3 + GRID_YOFFS;		
		ZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//with zero shift the draw zero is in the middle of the grid
		
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH3];
		lscale_shift_factor = scale_shift_factor[ldmode][Selected_Voltage_CH3];

	}
	
	if (channel == 4)
	{	
		plane = Buffer_Plane4;			//Channel_Plane4;
		//pix  = &SIGNAL4_SUM_MIN[0];
		//pix2 = &SIGNAL4_SUM_MAX[0];	
		//ZeroLevel = ZeroLevelCH4 + GRID_YOFFS;		
		ZeroLevel = (GRID_HEIGHT / 2) + GRID_YOFFS;	//with zero shift the draw zero is in the middle of the grid
		
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH4];
		lscale_shift_factor = scale_shift_factor[ldmode][Selected_Voltage_CH4];

	}		
	if (channel == 5)	//Math
	{	
		plane     = Buffer_PlaneM;			//Channel_Plane Math;
		//pix       = &SIGNALM_SUM_MIN[0];
		//pix2      = &SIGNALM_SUM_MAX[0];	
		
		if (Math_Offset < 0)
		{ Math_Offset *= -1;
		  ZeroLevel = GRID_YOFFS + (GRID_HEIGHT / 2) + (Math_Offset / math_voltage_div[math_scale]); }
		else
		{ ZeroLevel = GRID_YOFFS + (GRID_HEIGHT / 2) - (Math_Offset / math_voltage_div[math_scale]); }

//BF to check!!!!!!!!!!
		lscale_int_factor   = scale_int_factor[math_scale];
		lscale_shift_factor = scale_shift_factor[ldmode][math_scale];

//-------------------

	}


	//----------------------------------
	//Set drawing parameters
	//----------------------------------
	if (ldmode)	//Delayed mode
	{
		//scaling factor for delayed mode
		lscale_int_factor = 1;
				
		if (windows == 1)	//draw main signal into upper delayed grid area
		{
			ZeroLevel = ((ZeroLevel - GRID_YOFFS) >> 1) + GRID_YOFFS;
			
			display_min = GRID_YOFFS;
			display_max = ((GRID_HEIGHT >> 1) - 2) + GRID_YOFFS;
		}
		else	//draw delayed signal into bottom grid area
		{
			ZeroLevel = ((ZeroLevel - GRID_YOFFS) >> 1) + (GRID_HEIGHT / 2) + GRID_YOFFS;
			
			display_min = ((GRID_HEIGHT >> 1) + 2) + GRID_YOFFS;
			display_max = GRID_HEIGHT + GRID_YOFFS;
		}
	}
	else	//Main mode
	{
		display_min = GRID_YOFFS;
		display_max = GRID_HEIGHT + GRID_YOFFS;	
	}

	//factor (time factor) is the step width of the loop index and must be minimum 1
	if(timefactor <= 0)
	{ timefactor = 1; }


//--------------------------------------------------------------------------------------------------------
//                         Signal drawing with vector or points
//--------------------------------------------------------------------------------------------------------

	
	//-----------------------------------------------------------
	// pixel connection drawing routine - fastest drawing
	//-----------------------------------------------------------
	if(!draw_mode)
	{
		lposx = GRID_XOFFS;
		lix   = ixstart;	//get index offset
	
		if(vector)	
		{
			//Get ADC-value of starting point and calculate correction
			P2 = (short) (DisplayData[lix] - ADC_ZERO);
			lix += timefactor;
			P3 = (short) (DisplayData[lix] - ADC_ZERO);
			
			//scaling and Y-positioning of starting points
			//P2 = (short)(ZeroLevel + (P2 * lscale_int_factor) + (P2 >> lscale_shift_factor));
			//P3 = (short)(ZeroLevel + (P3 * lscale_int_factor) + (P3 >> lscale_shift_factor));

			if(lscale_int_factor == 1)
			{
				P2 = (short)(ZeroLevel + P2 + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + P3 + (P3 >> lscale_shift_factor));
			}
			else if(lscale_int_factor == 2)
			{
				P2 = (short)(ZeroLevel + (P2 << 1) + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + (P3 << 1) + (P3 >> lscale_shift_factor));
			}
			else 	// -> 3
			{
				P2 = (short)(ZeroLevel + P2 + (P2 << 1) + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + P3 + (P3 << 1) + (P3 >> lscale_shift_factor));
			}

			//limiter
			if (P2 > display_max) P2 = display_max;
			if (P2 < display_min) P2 = display_min;
			if (P3 > display_max) P3 = display_max;
			if (P3 < display_min) P3 = display_min;
		
			//draw signal
			for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
			{
				lposx++;
		
				P1 = P2;
				P2 = P3;		
				//get next ADC-value
				P3 = (short)(DisplayData[lix] - ADC_ZERO);
	
				//scaling and Y-positioning
				//P3 = (short)(ZeroLevel + (P3 * lscale_int_factor) + (P3 >> lscale_shift_factor));
				
				if(lscale_int_factor == 1)
				{ P3 = (short)(ZeroLevel + P3 + (P3 >> lscale_shift_factor)); }
				else if(lscale_int_factor == 2)
				{ P3 = (short)(ZeroLevel + (P3 << 1) + (P3 >> lscale_shift_factor)); }
				else 	// -> 3
				{ P3 = (short)(ZeroLevel + P3 + (P3 << 1) + (P3 >> lscale_shift_factor)); }

				//limiter
				if (P3 > display_max) P3 = display_max;
				if (P3 < display_min) P3 = display_min;
		
				//-----------------------------------------------------------
				//		Draw lines
				//-----------------------------------------------------------
				//Fall 1   ( 1 == 2 == 3 )
				if ((P1 == P2) && (P2 == P3))
				{ PIXELP(lposx, P1, on, plane); }
		
				//Fall 2   ( 1 < 2 < 3 )
				else if ((P1 < P2) && (P2 < P3))
				{ Connect_Pixels(lposx, P1, P2, 1, plane, on); }	
			
				//Fall 3   ( 1 > 2 > 3 )
				else if ((P1 > P2) && (P2 > P3))
				{ Connect_Pixels(lposx, P1, P2, 0, plane, on); }	
			
				//Fall 4   ( 1 < 2 = 3 )
				else if ((P1 < P2) && (P2 == P3))
				{ Connect_Pixels(lposx, P1, P2, 1, plane, on); }	
				
				//Fall 5   ( 1 > 2 = 3 )
				else if ((P1 > P2) && (P2 == P3))
				{ Connect_Pixels(lposx, P1, P2, 0, plane, on); }
				
				//Fall 6   ( 1 = 2 < 3 )
				else if ((P1 == P2) && (P2 < P3))
				{ PIXELP(lposx, P1, on, plane); }	
				
				//Fall 7   ( 1 = 2 > 3 )
				else if ((P1 == P2) && (P2 > P3))
				{ PIXELP(lposx, P1, on, plane); }	
			
				//Fall 8   ( 1 > 2 < 3 )
				else if ((P1 > P2) && (P2 < P3))
				{ Connect_Pixels(lposx, P1, P2, 0, plane, on); }	
				
				//Fall 9   ( 1 < 2 > 3 )
				else if ((P1 < P2) && (P2 > P3))
				{ Connect_Pixels(lposx, P1, P2, 1, plane, on); }	
				else //-> Fall 1
				{ PIXELP(lposx, P1, on, plane); }	
			}	
	
		}
		else
		{
		//+++++++++++++ draw only single points +++++++++++++
		//BF -> in interpolated TB drop the interpolated values

			if (Selected_Timebase == 3)
			lInterpol = 2;
			else if (Selected_Timebase == 2)
			lInterpol = 4;
			else if (Selected_Timebase == 1)
			lInterpol = 9;
			else if (Selected_Timebase == 0)
			lInterpol = 24;
			else
			lInterpol = 0;

			char ip;

			for (ip=0,lix += timefactor; (lposx - GRID_XOFFS) < (GRID_WIDTH-1); lix += timefactor, ip--)
			{
				lposx++;
		
				if (ip<=0)
				{
					if (lInterpol == 2)	//toggle faktor between 1 and 2 to simulate 1,5
					lInterpol = 1;
					if (lInterpol == 1)
					lInterpol = 2;
 
					ip = lInterpol;

					P1 = (short) (DisplayData[lix] - ADC_ZERO);
		
					//P1 = (short)(ZeroLevel + int(P1 * lscal_fact));	
					//BF new int scaling
					//P1 = (short)(ZeroLevel + (P1 * lscale_int_factor) + (P1 >> lscale_shift_factor));
					if(lscale_int_factor == 1)
					{ P1 = (short)(ZeroLevel + P1 + (P1 >> lscale_shift_factor)); }
					else if(lscale_int_factor == 2)
					{ P1 = (short)(ZeroLevel + (P1 << 1) + (P1 >> lscale_shift_factor)); }
					else 	// -> 3
					{ P1 = (short)(ZeroLevel + P1 + (P1 << 1) + (P1 >> lscale_shift_factor)); }
	
					if (P1 > display_max) P1 = display_max;
					if (P1 < display_min) P1 = display_min;
				
					PIXELP(lposx, P1, on, plane);
				}
			}
		}
	
	}


	//---------------------------------------------------------------------
	// Line drawing with standard line function - 
	// new line() function which is as fast as the pixel connection 
	// routine but shows more details
	//---------------------------------------------------------------------
	if(draw_mode)	
	{
		
		lposx = GRID_XOFFS;
		lix   = ixstart;	//get index offset
		if(vector)	
		{
		//+++++++++++++++++ draw signal as vector line ++++++++++++++++++
	
			//Get ADC-value of starting point and calculate correction
			P2 = (short) (DisplayData[lix] - ADC_ZERO);
			lix += timefactor;
			P3 = (short) (DisplayData[lix] - ADC_ZERO);
			
			//scaling and Y-positioning of starting points
			//P2 = (short)(ZeroLevel + (P2 * lscale_int_factor) + (P2 >> lscale_shift_factor));
			//P3 = (short)(ZeroLevel + (P3 * lscale_int_factor) + (P3 >> lscale_shift_factor));
			
			if(lscale_int_factor == 1)
			{
				P2 = (short)(ZeroLevel + P2 + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + P3 + (P3 >> lscale_shift_factor));
			}
			else if(lscale_int_factor == 2)
			{
				P2 = (short)(ZeroLevel + (P2 << 1) + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + (P3 << 1) + (P3 >> lscale_shift_factor));
			}
			else 	// -> 3
			{
				P2 = (short)(ZeroLevel + P2 + (P2 << 1) + (P2 >> lscale_shift_factor));
				P3 = (short)(ZeroLevel + P3 + (P3 << 1) + (P3 >> lscale_shift_factor));
			}
			
			//limiter
			if (P2 > display_max) P2 = display_max;
			if (P2 < display_min) P2 = display_min;
			if (P3 > display_max) P3 = display_max;
			if (P3 < display_min) P3 = display_min;

			//draw signal
			for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
			{
				lposx++;
		
				//P1 = P2;
				P2 = P3;		
				//get next ADC-value
				P3 = (short)(DisplayData[lix] - ADC_ZERO);
	
				//scaling and Y-positioning
				//P3 = (short)(ZeroLevel + (P3 * lscale_int_factor) + (P3 >> lscale_shift_factor));
				if(lscale_int_factor == 1)
				{ P3 = (short)(ZeroLevel + P3 + (P3 >> lscale_shift_factor)); }
				else if(lscale_int_factor == 2)
				{ P3 = (short)(ZeroLevel + (P3 << 1) + (P3 >> lscale_shift_factor)); }
				else 	// -> 3
				{ P3 = (short)(ZeroLevel + P3 + (P3 << 1) + (P3 >> lscale_shift_factor)); }

				//limiter
				if (P3 > display_max) P3 = display_max;
				if (P3 < display_min) P3 = display_min;
		
				//-----------------------------------------------------------
				//		Draw lines
				//-----------------------------------------------------------
				//DRAWLINEP(X1, Y1, X2, Y2, on, plane);
				DRAWLINEP(lposx, P2, lposx + 1, P3, on, plane);
			}

		}
		else
		{
		//+++++++++++++ draw only single points +++++++++++++
		//BF -> in interpolated TB drop the interpolated values

			if (Selected_Timebase == 3)
			lInterpol = 2;
			else if (Selected_Timebase == 2)
			lInterpol = 4;
			else if (Selected_Timebase == 1)
			lInterpol = 9;
			else if (Selected_Timebase == 0)
			lInterpol = 24;
			else
			lInterpol = 0;

			char ip;

			for (ip=0,lix += timefactor; (lposx - GRID_XOFFS) < (GRID_WIDTH-1); lix += timefactor, ip--)
			//for (lix += timefactor; (lposx - GRID_XOFFS) < GRID_WIDTH-1; lix += timefactor)
			{
				lposx++;
				
				if (ip<=0)
				{
					if (lInterpol == 2)	//toggle faktor between 1 and 2 to simulate 1,5
					lInterpol = 1;
					if (lInterpol == 1)
					lInterpol = 2;
 
					ip = lInterpol;

					P1 = (short) (DisplayData[lix] - ADC_ZERO);
					
					//scaling and Y-positioning
					//P1 = (short)(ZeroLevel + (P1 * lscale_int_factor) + (P1 >> lscale_shift_factor));
					if(lscale_int_factor == 1)
					{ P1 = (short)(ZeroLevel + P1 + (P1 >> lscale_shift_factor)); }
					else if(lscale_int_factor == 2)
					{ P1 = (short)(ZeroLevel + (P1 << 1) + (P1 >> lscale_shift_factor)); }
					else 	// -> 3
					{ P1 = (short)(ZeroLevel + P1 + (P1 << 1) + (P1 >> lscale_shift_factor)); }
	
					if (P1 > display_max) P1 = display_max;
					if (P1 < display_min) P1 = display_min;
				
					PIXELP(lposx, P1, on, plane);
				}
			}
		}

	}


}
//##########################################################################################################################################################
//BF complete new routine and interface
void Display::DRAWSIGNAL_XY(int channel_x, int channel_y, unsigned int start, unsigned char *signal_x, unsigned char *signal_y, unsigned char on, unsigned char vector)
{
	int lsix,ldix; //Signal index and draw index

    	int lX_Ampl1, lX_Ampl2;
	int lY_Ampl1, lY_Ampl2;

	int ZeroLevel_X, ZeroLevel_Y;
	int display_X_max = GRID_XY_XOFFS + GRID_XY - 1;
	int display_Y_max = GRID_YOFFS + GRID_XY - 1;
	int display_X_min = GRID_XY_XOFFS + 1;
	int display_Y_min = GRID_YOFFS + 1;
	
	int lX_scale_int_factor = 1, lX_scale_shift_factor = 1;
	int lY_scale_int_factor = 1, lY_scale_shift_factor = 1;

	unsigned long *lp_plane = NULL;

	
	if (channel_x == 1)
	{	
    		lp_plane = Buffer_Plane1;	//yellow
		//ZeroLevel_X = GRID_XY_XOFFS + ZeroLevelCH1; 
		//ZeroLevel_Y = GRID_YOFFS + ZeroLevelCH2;
	}
	else
	{
		lp_plane = Buffer_Plane3;	//blue
		//ZeroLevel_X = GRID_XY_XOFFS + ZeroLevelCH3; 
		//ZeroLevel_Y = GRID_YOFFS + ZeroLevelCH4;
	}

	ZeroLevel_X = GRID_XY_XOFFS + (GRID_XY / 2); 
	ZeroLevel_Y = GRID_YOFFS + (GRID_XY / 2);

	// calculate amplitude scaling factors for each Channel
	switch (channel_x)
	{	
		case 1: { lX_scale_int_factor = scale_int_factor[Selected_Voltage_CH1];
                          lX_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH1]; break;}
		case 2: { lX_scale_int_factor = scale_int_factor[Selected_Voltage_CH2];
			  lX_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH2]; break;}
		case 3: { lX_scale_int_factor = scale_int_factor[Selected_Voltage_CH3];
			  lX_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH3]; break;}
		case 4: { lX_scale_int_factor = scale_int_factor[Selected_Voltage_CH4];
			  lX_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH4]; break;}		
	}	
	switch (channel_y)
	{	
		case 1: { lY_scale_int_factor = scale_int_factor[Selected_Voltage_CH1];
			  lY_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH1];  break;}
		case 2: { lY_scale_int_factor = scale_int_factor[Selected_Voltage_CH2];
			  lY_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH2];  break;}
		case 3: { lY_scale_int_factor = scale_int_factor[Selected_Voltage_CH3];
			  lY_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH3];  break;}
		case 4: { lY_scale_int_factor = scale_int_factor[Selected_Voltage_CH4];
			  lY_scale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH4];  break;}		
	}	



	if (vector)	//draw vector lines
	{
		//initialize start values beginning with the second value because it will become the new starting point
		lsix = start;
		lX_Ampl2 = (int)(signal_x[lsix] - ADC_ZERO);
		lY_Ampl2 = (int)(signal_x[lsix] - ADC_ZERO);

		//scaling and positioning starting points
		lX_Ampl2 = (int)(ZeroLevel_X - (lX_Ampl2 * lX_scale_int_factor) - (lX_Ampl2 >> lX_scale_shift_factor));
		lY_Ampl2 = (int)(ZeroLevel_Y + (lY_Ampl2 * lY_scale_int_factor) + (lY_Ampl2 >> lY_scale_shift_factor));

		//limiter
		if (lX_Ampl2 > display_X_max) lX_Ampl2 = display_X_max;
		if (lY_Ampl2 > display_Y_max) lY_Ampl2 = display_Y_max;
		
		if (lX_Ampl2 < display_X_min) lX_Ampl2 = display_X_min;
		if (lY_Ampl2 < display_Y_min) lY_Ampl2 = display_Y_min;
		
		//now process the following values
		for (ldix = 0 , lsix += draw_factor;(ldix < GRID_WIDTH) && !UI_request;ldix++, lsix += draw_factor)
		{
			//the new start point is the old end point
			lX_Ampl1 = lX_Ampl2;
			lY_Ampl1 = lY_Ampl2;

			//read next X and Y value
			lX_Ampl2 = (int)(signal_x[lsix] - ADC_ZERO);
			lY_Ampl2 = (int)(signal_y[lsix] - ADC_ZERO);

			//scaling and positioning 
			lX_Ampl2 = (int)(ZeroLevel_X - (lX_Ampl2 * lX_scale_int_factor) - (lX_Ampl2 >> lX_scale_shift_factor));
			lY_Ampl2 = (int)(ZeroLevel_Y + (lY_Ampl2 * lY_scale_int_factor) + (lY_Ampl2 >> lY_scale_shift_factor));

			//limiter
			if (lX_Ampl2 > display_X_max) lX_Ampl2 = display_X_max;
			if (lY_Ampl2 > display_Y_max) lY_Ampl2 = display_Y_max;
			if (lX_Ampl2 < display_X_min) lX_Ampl2 = display_X_min;
			if (lY_Ampl2 < display_Y_min) lY_Ampl2 = display_Y_min;

			//DRAWLINEP(X1, Y1, X2, Y2, on, plane);
			DRAWLINEP(lX_Ampl1, lY_Ampl1, lX_Ampl2, lY_Ampl2, on, lp_plane);

		}
	}
	else	//draw single pixels
	{

		//now process the following values
		for (ldix = 0, lsix = start;(ldix < GRID_WIDTH) && !UI_request;ldix++, lsix += draw_factor)
		{
			//read next X and Y value
			lX_Ampl1 = (int)(signal_x[lsix] - ADC_ZERO);
			lY_Ampl1 = (int)(signal_y[lsix] - ADC_ZERO);

			//scaling and positioning 
			lX_Ampl1 = (int)(ZeroLevel_X - (lX_Ampl1 * lX_scale_int_factor) - (lX_Ampl1 >> lX_scale_shift_factor));
			lY_Ampl1 = (int)(ZeroLevel_Y + (lY_Ampl1 * lY_scale_int_factor) + (lY_Ampl1 >> lY_scale_shift_factor));

			//limiter
			if (lX_Ampl1 > display_X_max) lX_Ampl1 = display_X_max;
			if (lY_Ampl1 > display_Y_max) lY_Ampl1 = display_Y_max;
			if (lX_Ampl1 < display_X_min) lX_Ampl1 = display_X_min;
			if (lY_Ampl1 < display_Y_min) lY_Ampl1 = display_Y_min;

			PIXELP(lX_Ampl1, lY_Ampl1, on, lp_plane);

		}

	}

}
//##########################################################################################################################################################
//BF Draw spectral analysis
void Display::DRAWSPECTRUM_FY(unsigned char on)
{


	int   lZeroLevel     = GRID_HEIGHT_FFT + GRID_YOFFS_FFT + 1;	//gridline is zero -> no signal output
	int   lSignalStart   = GRID_HEIGHT_FFT + GRID_YOFFS_FFT;	//first pixel position
	unsigned long *plane = NULL;

	int   lY = 0;		//amplitude / y position
	int   li = 0; 		//signal index
	int   lX = 0;		//x position

	int lscale_int_factor = 1, lscale_shift_factor = 1;


//printf("\r\ndraw FFT\r\n");

	//----------------------------------------
	//set channel depending parameters
	//----------------------------------------

	//get scaling faktor of active channel
	if(Channel_1_Active)
	{ 	
		plane = Buffer_Plane1;		//Calculate scaling factor
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH1];
		lscale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH1];
	}
	if(Channel_2_Active)
	{ 
		plane = Buffer_Plane2;
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH2];
		lscale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH2];
 	}
	if(Channel_3_Active)
	{ 
		plane = Buffer_Plane3;
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH3];
		lscale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH3];
	 }
	if(Channel_4_Active)
	{ 
		plane = Buffer_Plane4;
		lscale_int_factor   = scale_int_factor[Selected_Voltage_CH4];
		lscale_shift_factor = scale_shift_factor[0][Selected_Voltage_CH4];
	 }

//----------------------------------------------------------------------------------------
//                   draw spectrum
//----------------------------------------------------------------------------------------
	
	lX = GRID_XOFFS_FFT;

	for (li = 0; (lX - GRID_XOFFS_FFT) < (GRID_WIDTH_FFT - 1); li ++)
	{
		lX++;

		//if(lscale_int_factor == 0)
		if(FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
		lY = lZeroLevel - SPECTRUM[li]; 	//without scaling - prescaled
		else
		{
			if(lscale_int_factor == 1)
			{ lY = lZeroLevel - (SPECTRUM[li] + (SPECTRUM[li] >> lscale_shift_factor)); }
			else if(lscale_int_factor == 2)
			{ lY = lZeroLevel - ((SPECTRUM[li] << 1) + (SPECTRUM[li] >> lscale_shift_factor)); }
			else 	// -> 3
			{ lY = lZeroLevel - (SPECTRUM[li] + (SPECTRUM[li] << 1) + (SPECTRUM[li] >> lscale_shift_factor)); }
		}	

		// limiter
		if (lY >= lZeroLevel) continue;
		if (lY < GRID_YOFFS_FFT) lY = GRID_YOFFS_FFT;
			
		// Draw line
		if(lSignalStart > lY)
		Connect_Pixels(lX, (short)lZeroLevel, (short)lY,  0, plane, on);
		else
		{ PIXELP(lX, (short)lY, on, plane); }	
		//DRAWLINEP(lX, lY, lX, lSignalStart, on, plane);
	}

}

//##########################################################################################################################################################
// BF this function draws vertical lines
// BF Attention!!! y and y2 must not be equal because in this case system crashes. The first point on vertical
// position y is not drawn -> this must be done via PIXELP()
void Display::Connect_Pixels(int x, short y, short y2, int dir, unsigned long *planeaddress, unsigned char on)
{
    if (on)
    {
        if (dir == 1)
        {
            asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i1                   ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS                ; Add Correction Value -> BF del no offset here!!

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV	%r4, %i4                       ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)                ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i2                   ; Load End Y to %r6

             SUB    %r6, %i1                       ; Get the Difference

             cp_loop1:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop1                       ; Jump to Loop
             NOP

            ");
        }
    	else
        {
            asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i2                       ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS                ; Add Correction Value BF del

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV	%r4, %i4                       ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)                ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i1                       ; Load End Y to %r6

             SUB    %r6, %i2                       ; Get the Difference

             cp_loop2:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop2                       ; Jump to Loop
             NOP

            ");
	   }		
    }
    else
    {
        if (dir == 1)
        {
            asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i1                       ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS                ; Add Correction Value BF del

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV	%r4, %i4                       ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x00000000)                ; Load bitmask
             MOVI	%r5,%lo(0x00000000)
             PFX	%xhi(0x00000000)
             MOVHI	%r5,%xlo(0x00000000)

             ;LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i2                       ; Load End Y to %r6

             SUB    %r6, %i1                       ; Get the Difference

             cp_loop01:

             ;LD     %r0, [%r4]                     ; Load Value from Memory
             MOV    %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop01                      ; Jump to Loop
             NOP

            ");
        }
    	else
        {
            asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i2                       ; Load Y to %r3

             ;ADDI   %r3, GRID_YOFFS                ; Add Correction Value BF del

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             MOV	%r4, %i4                       ; Load BufferAddress to %r4

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x00000000)                ; Load bitmask
             MOVI	%r5,%lo(0x00000000)
             PFX	%xhi(0x00000000)
             MOVHI	%r5,%xlo(0x00000000)

             ;LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i1                       ; Load End Y to %r6

             SUB    %r6, %i2                       ; Get the Difference

             cp_loop02:

             ;LD     %r0, [%r4]                     ; Load Value from Memory
             MOV    %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop02                      ; Jump to Loop
             NOP

            ");
        }		
    }
}
//##########################################################################################################################################################

void Display::Test_Pixels(int x, int y, int y2, int dir, unsigned long *planeaddress)
{
    asm("
             MOV	%r1, %i0                       ; Load X to %r1

             MOV	%r2, %i0                       ; Load X to %r2
             LSRI   %r2, 5                         ; Shift %r2 right 5 times to calculate wordoffset (x / 32)      Bitfilter
             LSLI   %r2, 2                         ; Shift %r2 left 2 times to calculate wordoffset (x / 32) * 4

             MOV	%r3, %i1                       ; Load Y to %r3

             MOV    %r4, %r3                       ; Save %r3 to %r4

             LSLI   %r3, 2                         ; Shift %r3 2 times to get Y * 4
             ADD    %r3, %r4                       ; Add %r4 to %r3 to get Y * 5
             LSLI   %r3, 4                         ; Shift %r3 4 times to get Y * 80

             ADD    %r3, %r2                       ; Add wordoffset to y offset address and store in %r3

             LSLI   %r2, 3                         ; Shift %r0 to get wordoffset without bit value

             SUB    %r1, %r2                       ; Subtract %r2 from %r1 to get Bitaddress stored in %r1

             ;MOV	%r4, %i4                       ; Load BufferAddress to %r4

             PFX	%hi(0x0093A200)                ; Load BufferAddress
             MOVI	%r4,%lo(0x0093A200)
             PFX	%xhi(0x0093A200)
             MOVHI	%r4,%xlo(0x0093A200)

             ADD    %r4, %r3                       ; Calculate Memoryaddress

             PFX	%hi(0x80000000)                ; Load bitmask
             MOVI	%r5,%lo(0x80000000)
             PFX	%xhi(0x80000000)
             MOVHI	%r5,%xlo(0x80000000)

             LSR    %r5, %r1                       ; Calculate Bit to set


             MOV	%r6, %i2                       ; Load End Y to %r6

             SUB    %r6, %i1                       ; Get the Difference

             cp_loop4:

             LD     %r0, [%r4]                     ; Load Value from Memory
             OR     %r0, %r5                       ; Set Calculated Bit
             ST     [%r4], %r0                     ; Store Back to Memory

             PFX    %hi(80)
             ADDI   %r4, %lo(80)                   ; Add 80 to Address

             SUBI   %r6, 1                         ; Decrement Y Counter
             SKPS   cc_z                           ; Test of Zero
             BR     cp_loop4                       ; Jump to Loop
             NOP

         ");
}

//##########################################################################################################################################################

// BF -> generate test signals on all channels
void Display::TestSignalGenerate(void)
{
	int ix, iy, tog, pw;
	int  lVirtual_Zero = 0;
	char lDCOffset     = 0;

	if (Channel_1_Active)	// draw rectangle signal
	{
		lVirtual_Zero = ADC_ZERO + (int)((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;
	
		// Signal 1 (Yellow)
		tog = 0;
		iy = lVirtual_Zero + 100;		//Amplitude

		if ( MenuStatus[MENU_CHANNEL1][0] == 8) 	//AC
		lDCOffset = 0;//-20;
		else if ( MenuStatus[MENU_CHANNEL1][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL1[ix] = lVirtual_Zero;
		}
		
		if ( MenuStatus[MENU_CHANNEL1][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++, pw++)
		{	
			//if (ix %200 == 0) 		//Pulswidth
			//if (ix %50 == 0) 		//Pulswidth
			if(pw==50)			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 73; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 72;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL1[ix] = (char)iy + lDCOffset;
		}	
	
	}

	if (Channel_2_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 2 (Green)
		tog = 0;	
		iy = lVirtual_Zero;
	
		if ( MenuStatus[MENU_CHANNEL2][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL2][0] == 7)	//DC
		lDCOffset = 20;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL2[ix] = lVirtual_Zero;
		}

		if ( MenuStatus[MENU_CHANNEL2][0] != 6)
		// calculate sinus signal
		for (ix = 0, iy = 0; (ix < 16384) && !UI_request; ix++, iy+=4)
		{
			if(iy >= 1024)
			iy = 0;

			SIGNAL2[ix] = lVirtual_Zero + (iSin1024[iy] >> 4);
		}
		
/*
		// calculate triangle signal
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %80 == 0)
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL2[ix] = (char)iy + lDCOffset;
		}	
*/	
	}

	if (NumberOfChannels == 2)
	return;

	if (Channel_3_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 3 (Purple)
		tog = 0;	
		iy = lVirtual_Zero + 25;
		
		if ( MenuStatus[MENU_CHANNEL3][0] == 8) 	//AC
		lDCOffset = -30;
		else if ( MenuStatus[MENU_CHANNEL3][0] == 7)	//DC
		lDCOffset = 0;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL3[ix] = lVirtual_Zero;
		}

		
		if ( MenuStatus[MENU_CHANNEL3][0] != 6)
		for (ix = 0, pw = 0; (ix < 16384) && !UI_request; ix++,pw++)
		{	
			//if (ix %150 == 0) 		//Pulswidth
			if (pw == 150) 			//Pulswidth
			{
				pw = 0;
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (tog == 0)
			{ iy = lVirtual_Zero - 25; }	//Amplitude
			else
			{ iy = lVirtual_Zero + 25;}	//Amplitude
	
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;
		
			SIGNAL3[ix] = (char)iy + lDCOffset;
		}	
	}

	if (Channel_4_Active)
	{
		lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4]);
		if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
		if (lVirtual_Zero < 0) lVirtual_Zero = 0;

		// Signal 4 (Red)
		tog = 0;	
		iy = lVirtual_Zero;
		
		
		if ( MenuStatus[MENU_CHANNEL4][0] == 8) 	//AC
		lDCOffset = 0;
		else if ( MenuStatus[MENU_CHANNEL4][0] == 7)	//DC
		lDCOffset = 25;
		else						//GND
		{
			for (ix = 0; (ix < 16384) && !UI_request; ix++)
			SIGNAL4[ix] = lVirtual_Zero;
		}
	
		if ( MenuStatus[MENU_CHANNEL4][0] != 6)
		for (ix = 0; (ix < 16384) && !UI_request; ix++)
		{
			if (ix %100 == 0)			//period
			{
				if (tog == 0) tog = 1;
				else tog = 0;
			}
			
			if (ix %2 == 0)	 			//Amplitude
			{
				if (tog == 0) iy++;
				else iy--;
			}
			if (iy > 255) iy = 255;	//Limiter
			if (iy < 0) iy = 0;

			SIGNAL4[ix] = (char)iy + lDCOffset;
		}	
	}
	if(FFT_Mode != FFT_OFF)
	FFT_NewData = 1;


}
//##########################################################################################################################################################

void Display::DrawColorDemoBox(int posx, int posy, int sizex, int sizey, unsigned long *planeaddress)							
{
    int x;

	for (x = 0; x <= sizex; x++)
	{
	   Connect_Pixels(posx + x, posy, posy + sizey, 1, planeaddress, 1);
    }
}
//##########################################################################################################################################################

void Display::ColorDemo(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}	


    // All Colors
	for (x = 0; x < 15; x++)
	{
	    DrawColorDemoBox(x * 40, 0, 39, 39, (unsigned long *) (0x0095FA00 + (x * 0x00009600)));
	}

    // UI Blocks
	for (x = 0; x < 5; x++)
	{
	    DrawColorDemoBox(x * 128, 40, 127, 37, (unsigned long *) (0x0095FA00 + (x * 0x00009600)));
	}
	
	// UI Mix 1
	DrawColorDemoBox(0, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(32, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(64, 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(96, 46, 32, 27, UI_Plane5);
	
	// UI Mix 2
	DrawColorDemoBox(128, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(160, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox((GRID_HEIGHT / 2), 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(224, 46, 32, 27, UI_Plane5);

	// UI Mix 3
	DrawColorDemoBox(256, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(288, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(320, 46, 32, 27, UI_Plane4);
	DrawColorDemoBox(352, 46, 32, 27, UI_Plane5);

	// UI Mix 4
	DrawColorDemoBox(GRID_HEIGHT, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(416, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(448, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(480, 46, 32, 27, UI_Plane5);

	// UI Mix 5
	DrawColorDemoBox(512, 46, 32, 27, UI_Plane1);
	DrawColorDemoBox(544, 46, 32, 27, UI_Plane2);
	DrawColorDemoBox(576, 46, 32, 27, UI_Plane3);
	DrawColorDemoBox(608, 46, 32, 27, UI_Plane4);
	
	// Channel 4 remix
	DrawColorDemoBox(0, 70, 639, 9, Channel_Plane4);
	
	
	Connect_Pixels(123, 210, 220, 1, UI_Plane1, 1);
	Connect_Pixels(123, 220, 230, 1, UI_Plane2, 1);
	Connect_Pixels(123, 230, 240, 1, UI_Plane3, 1);
	Connect_Pixels(123, 240, 250, 1, UI_Plane4, 1);
	Connect_Pixels(123, 250, 260, 1, UI_Plane5, 1);
	Connect_Pixels(123, 260, 270, 1, Channel_Plane1, 1);
	Connect_Pixels(123, 270, 280, 1, Channel_Plane2, 1);
	Connect_Pixels(123, 280, 290, 1, Channel_Plane3, 1);
	Connect_Pixels(123, 290, 300, 1, Channel_Plane4, 1);
	Connect_Pixels(123, 300, 310, 1, Channel_Math_Plane, 1);
	Connect_Pixels(123, 310, 320, 1, Memory_Plane1, 1);
	Connect_Pixels(123, 320, 330, 1, Memory_Plane2, 1);
	Connect_Pixels(123, 330, 340, 1, Memory_Plane3, 1);
	Connect_Pixels(123, 340, 350, 1, Marker_Plane1, 1);
	Connect_Pixels(123, 350, 360, 1, Marker_Plane2, 1);
	Connect_Pixels(123, 360, 370, 1, Grid_Plane, 1);
	
	DRAWLINEP(223, 210, 232, 210, 1, UI_Plane1);
	DRAWLINEP(223, 211, 232, 211, 1, UI_Plane2);
	DRAWLINEP(223, 212, 232, 212, 1, UI_Plane3);
	DRAWLINEP(223, 213, 232, 213, 1, UI_Plane4);
	DRAWLINEP(223, 214, 232, 214, 1, UI_Plane5);
	DRAWLINEP(223, 215, 232, 215, 1, Channel_Plane1);
	DRAWLINEP(223, 216, 232, 216, 1, Channel_Plane2);
	DRAWLINEP(223, 217, 232, 217, 1, Channel_Plane3);
	DRAWLINEP(223, 218, 232, 218, 1, Channel_Plane4);
	DRAWLINEP(223, 219, 232, 219, 1, Channel_Math_Plane);
	DRAWLINEP(223, 220, 232, 220, 1, Memory_Plane1);
	DRAWLINEP(223, 221, 232, 221, 1, Memory_Plane2);
	DRAWLINEP(223, 222, 232, 222, 1, Memory_Plane3);
	DRAWLINEP(223, 223, 232, 223, 1, Marker_Plane1);
	DRAWLINEP(223, 224, 232, 224, 1, Marker_Plane2);
	DRAWLINEP(223, 225, 232, 225, 1, Grid_Plane);
	
	
	
	
	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################
// BF color demo to check planes and colors
// BF -> UI_Plane1 has a shift error of 32 pixels to the right !!!!!!!!!!!!!!!!!!
// BF this error causes wrong lines at button drawing 
void Display::ColorDemo2(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}

	TEXTOUTxvbig("UI_Plane1", 40, 5, 1, UI_Plane1);				// white/grey
	TEXTOUTxvbig("UI_Plane2", 40, 20, 1, UI_Plane2);			// black
	TEXTOUTxvbig("UI_Plane3", 40, 35, 1, UI_Plane3);			// light yellow
	TEXTOUTxvbig("UI_Plane4", 40, 50, 1, UI_Plane4);			// yellow
	TEXTOUTxvbig("UI_Plane5", 40, 65, 1, UI_Plane5);			// dark grey
	TEXTOUTxvbig("Channel_Plane1", 40, 80, 1, Channel_Plane1);		// neon yellow
	TEXTOUTxvbig("Channel_Plane2", 40, 95, 1, Channel_Plane2);		// neon green
	TEXTOUTxvbig("Channel_Plane3", 40, 110, 1, Channel_Plane3);		// neon blue
	TEXTOUTxvbig("Channel_Plane4", 40, 125, 1, Channel_Plane4);		// neon red
	TEXTOUTxvbig("Channel_Math_Plane", 40, 140, 1, Channel_Math_Plane);	// neon pink
	TEXTOUTxvbig("Marker_Plane1", 40, 155, 1, Marker_Plane1);		// neon orange
	TEXTOUTxvbig("Marker_Plane2", 40, 170, 1, Marker_Plane2);		// neon orange
	TEXTOUTxvbig("Grid_Plane", 40, 185, 1, Grid_Plane);			// dark grey - white


	//----------------------------------------------------
	
	DRAWLINEP(0, 200, 639, 200, 1, UI_Plane1);
	DRAWLINEP(0, 205, 639, 205, 1, UI_Plane2);
	DRAWLINEP(0, 210, 639, 210, 1, UI_Plane3);
	DRAWLINEP(0, 215, 639, 215, 1, UI_Plane4);
	DRAWLINEP(0, 220, 639, 220, 1, UI_Plane5);

	DRAWLINEP(0, 225, 639, 225, 1, Channel_Plane1);
	DRAWLINEP(0, 230, 639, 230, 1, Channel_Plane2);
	DRAWLINEP(0, 235, 639, 235, 1, Channel_Plane3);
	DRAWLINEP(0, 240, 639, 240, 1, Channel_Plane4);
	DRAWLINEP(0, 245, 639, 245, 1, Channel_Math_Plane);

	DRAWLINEP(0, 250, 639, 250, 1, Marker_Plane1);
	DRAWLINEP(0, 255, 639, 255, 1, Marker_Plane2);

	DRAWLINEP(0, 260, 639, 260, 1, Grid_Plane); 	

	//----------------------------------------------------
	
	DRAWLINEP(0, 300, 603, 300, 1, UI_Plane1);
	DRAWLINEP(0, 305, 603, 305, 1, UI_Plane2);
	DRAWLINEP(0, 310, 603, 310, 1, UI_Plane3);
	DRAWLINEP(0, 315, 603, 315, 1, UI_Plane4);
	DRAWLINEP(0, 320, 603, 320, 1, UI_Plane5);

	DRAWLINEP(0, 325, 603, 325, 1, Channel_Plane1);
	DRAWLINEP(0, 330, 603, 330, 1, Channel_Plane2);
	DRAWLINEP(0, 335, 603, 335, 1, Channel_Plane3);
	DRAWLINEP(0, 340, 603, 340, 1, Channel_Plane4);
	DRAWLINEP(0, 345, 603, 345, 1, Channel_Math_Plane);

	DRAWLINEP(0, 350, 603, 350, 1, Marker_Plane1);
	DRAWLINEP(0, 355, 603, 355, 1, Marker_Plane2);

	DRAWLINEP(0, 360, 603, 360, 1, Grid_Plane); 	

	//----------------------------------------------------

	DRAWLINEP(33, 400, 639, 400, 1, UI_Plane1);
	DRAWLINEP(33, 405, 639, 405, 1, UI_Plane2);
	DRAWLINEP(33, 410, 639, 410, 1, UI_Plane3);
	DRAWLINEP(33, 415, 639, 415, 1, UI_Plane4);
	DRAWLINEP(33, 420, 639, 420, 1, UI_Plane5);

	DRAWLINEP(33, 425, 639, 425, 1, Channel_Plane1);
	DRAWLINEP(33, 430, 639, 430, 1, Channel_Plane2);
	DRAWLINEP(33, 435, 639, 435, 1, Channel_Plane3);
	DRAWLINEP(33, 440, 639, 440, 1, Channel_Plane4);
	DRAWLINEP(33, 445, 639, 445, 1, Channel_Math_Plane);

	DRAWLINEP(33, 450, 639, 450, 1, Marker_Plane1);
	DRAWLINEP(33, 455, 639, 455, 1, Marker_Plane2);

	DRAWLINEP(33, 460, 639, 460, 1, Grid_Plane); 	



/*
	DRAWLINEP(0, 150, 639, 150, 1, Memory_Plane1);
	DRAWLINEP(0, 155, 639, 155, 1, Memory_Plane2);
	DRAWLINEP(0, 160, 639, 160, 1, Memory_Plane3);
*/

	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################

void Display::ColorDemo3(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}
	
	PIXELP(0, 0, 1, UI_Plane1);
	PIXELP(16, 0, 1, UI_Plane1);
	PIXELP(1, 0, 1, UI_Plane2);
	PIXELP(17, 0, 1, UI_Plane2);
	PIXELP(2, 0, 1, UI_Plane3);
	PIXELP(18, 0, 1, UI_Plane3);
	PIXELP(3, 0, 1, UI_Plane4);
	PIXELP(19, 0, 1, UI_Plane4);
	PIXELP(4, 0, 1, UI_Plane5);
	PIXELP(20, 0, 1, UI_Plane5);
	
	PIXELP(5, 0, 1, Channel_Plane1);
	PIXELP(21, 0, 1, Channel_Plane1);
	PIXELP(6, 0, 1, Channel_Plane2);
	PIXELP(22, 0, 1, Channel_Plane2);
	PIXELP(7, 0, 1, Channel_Plane3);
	PIXELP(23, 0, 1, Channel_Plane3);
	PIXELP(8, 0, 1, Channel_Plane4);
	PIXELP(24, 0, 1, Channel_Plane4);
	PIXELP(9, 0, 1, Channel_Math_Plane);
	PIXELP(25, 0, 1, Channel_Math_Plane);        	
	
	PIXELP(10, 0, 1, Memory_Plane1);
	PIXELP(26, 0, 1, Memory_Plane1);   	
	PIXELP(11, 0, 1, Memory_Plane2);
	PIXELP(27, 0, 1, Memory_Plane2);   	
	PIXELP(12, 0, 1, Memory_Plane3);
	PIXELP(28, 0, 1, Memory_Plane3);   	
	
	PIXELP(13, 0, 1, Marker_Plane1);
	PIXELP(29, 0, 1, Marker_Plane1);   	
	PIXELP(14, 0, 1, Marker_Plane2);
	PIXELP(30, 0, 1, Marker_Plane2);
       	
	PIXELP(15, 0, 1, Grid_Plane);
	PIXELP(31, 0, 1, Grid_Plane);   	
	
	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################

void Display::ColorDemo5(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}

	// Clear test Plane
	for (x = 0; x < 9600; x++)
	{
        	Channel_Plane1[x] = 0;	
   		Buffer_Plane1[x] = 0;
	}
	
	DrawColorDemoBox(64, 64, 64, 64, Channel_Plane1);
	DrawColorDemoBox(172, 64, 64, 64, Buffer_Plane1);
	
    reset_watchdog->np_piodata = 0;
	
    screen_sel = 0;

	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################

void Display::ColorDemo6(void)
{
    int x;

	// Clear All Planes
	for (x = 0; x < 153600; x++)
	{
		Planes[x] = 0;		
	}

	// Clear test Plane
	for (x = 0; x < 9600; x++)
	{
        	Channel_Plane1[x] = 0;	
		Buffer_Plane1[x] = 0;
	}
	
	DrawColorDemoBox(64, 64, 64, 64, Channel_Plane1);
	DrawColorDemoBox(172, 64, 64, 64, Buffer_Plane1);
	
    reset_watchdog->np_piodata = 1;
	
    screen_sel = 1;

	// Stop the system
    while (1 != 0);
}
//##########################################################################################################################################################
// BF function for sending float values via printf() to RS232, resolving the problem of systemcrash in open source FW
// when using the printf() directly

void Display::floatprintf(float fvalue)
{
	long int pre, aft,factor;
	int i;
	
	if (fvalue == 0)
	{ printf("0.000"); return;}

	//calculating pre FP value
	pre = (long int)fvalue;
	if(pre == 0 && fvalue < 0)	//negativ
		printf("-%d.",pre);
	else
		printf("%d.",pre);
		
	//get leading zero
	if((fvalue - pre) != 0) //check if numbers after FP exist
	{
		for(factor = 10, i= 0 ;0 == (long int)((fvalue - pre) * factor) && i<11; factor*=10, i++)
		{ printf("0"); }
	}
	else
	{	
		printf("000");
		return;
	}
	
	//calc after FP value, minimum 3 numbers after FP
	aft = (long int)((fvalue - pre) * factor * 100);
	
	if(aft < 0)	//kill sign
	{ aft *= -1; }

	printf("%d",aft);

	if(i >= 11)
	printf("overflow");

}
//##########################################################################################################################################################
// BF function for USTB roll mode

void Display::USTB_Clear_Buffer(void)
{
	int lVirtual_Zero=0;
	int lChannel=0;

	USTB_Roll_idx = 0; //Set pointer to beginning

	//init buffers with ground signal
	for(lChannel = 1;lChannel <= 5;lChannel++)
	{
		switch(lChannel)
		{	
			case 1 :	//Channel 1
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL1_USTB[i] = (char)lVirtual_Zero;

				break;
			}
	
			case 2 :	//Channel 2
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL2_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 3 :	//Channel 3
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL3_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 4 :	//Channel 4
			{
				lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4]);
				if (lVirtual_Zero > 255) lVirtual_Zero = 255;	//Limiter
				if (lVirtual_Zero < 0) lVirtual_Zero = 0;
				
				for(int i=0;i<1200;i++) SIGNAL4_USTB[i] = (char)lVirtual_Zero;

				break;
			}

			case 5 :	//Channel math
			{				
				for(int i=0;i<1200;i++) SIGNALM_USTB[i] = ADC_ZERO;
				break;
			}
	
	
		}
	
	}

}
//##########################################################################################################################################################
// BF function for USTB roll mode

void Display::USTB_roll_signal(int Time_idx, unsigned char *DataArray_in, unsigned char *Signal)
{

	int lNew_Value=0;
	int lix;

	//calculate average value of ADC data array
	for (lix = 0; lix < 128; lix++)
	{ lNew_Value += DataArray_in[lix]; }

	lNew_Value = lNew_Value >> 7;

	//write new value to the current time position
	Signal[Time_idx] = (char)lNew_Value;

//	Signal[Time_idx] = DataArray_in[1];
	
}

//##########################################################################################################################################################
// BF function for USTB shift mode

void Display::USTB_shift_signal(unsigned char *DataArray_in, unsigned char *Signal)
{

	int lNew_Value=0;
	int lix;

	//calculate average value of ADC data array
	for (lix = 0; lix < 128; lix++)
	{ lNew_Value += DataArray_in[lix]; }

	lNew_Value = lNew_Value >> 7;
	
	//shift all value one position to the right
	for (lix = GRID_WIDTH;lix >= 0;lix--)
	{ Signal[lix+1] = Signal[lix]; }

	 //copy new value on the first position
	Signal[0] = (char)lNew_Value;

}

//##########################################################################################################################################################
/* BF */
// Build trigonometric tables for FFT
void Display::FFT_BuildTrigoTables(void)
{
	//Speicher auf dem Stack reservieren
	int z,l,i,r,ct,buff; 	//,ar,v, la;
	int d[FFT_Level];	//Number of butterfly levels

	//Struktur vom Typ div_t erzeugen
	div_t s_div;

/*
	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
	Display::TEXTOUTxvbig("Building trigonometric", 247, 192, 1, UI_Plane2);
	Display::TEXTOUTxvbig("tables.", 247, 212, 1, UI_Plane2);
	Display::TEXTOUTxvbig("Please wait a minute.", 247, 232, 1, UI_Plane2);
*/

/*
	// create sin() and cos() table as integer values
	for(i=0;i < FFT_Length;i++)  			
	{
		sin_tab[i] = (int)(FFT_INTFACT * sin(i*2*PI/FFT_Length));
		cos_tab[i] = (int)(FFT_INTFACT * cos(i*2*PI/FFT_Length));
	}
*/	
	// create window and trigonometric tables
	for(i=0,r=0 ;i < FFT_Length; i++)
	{
		sin_tab[i] = iSin1024[r];
		cos_tab[i] = iCos1024[r];

		win_tab[i] = FFT_Window[FFT_Windex][r];
	
		if (FFT_Length == FFT_512)
		r+=2;
		else
		r++;	
	}

	
	//Bit-Reversal- Tabelle bit_rev[0..] anlegen
	for(i=0 ;i < FFT_Length; i++)
	{
		z=i;
		//Dezimal-Index in Dualzahl umwandeln
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			s_div = div(z,2);
			d[ct] = (int)s_div.rem;		// den Rest ins Feld
			z     = (int)s_div.quot;	// den Quotienten nach z
		}
		//Bit-Revers anordnen
		s_div = div(FFT_Level,2);
		for(ct=0 ;ct < (int)s_div.quot; ct++)
		{
			buff  = d[ct];
			d[ct] = d[FFT_Level-ct-1];
			d[FFT_Level-ct-1] = buff;
		}
		
		//Bit-Revers anordnen Zeitoptimiert mit Festwert
//		for(int buff,j=0;j<5;j++) 	        // 5 = FFT_LEVEL/radix  => x=div(FFT_LEVEL,2) => x.quot=5
//		{
//			buff 	     = d[j];
//			d[j] 	     = d[FFT_LEVEL-j-1];
//			d[FFT_LEVEL-j-1] = buff;
//		}

		//Umsortierten Index zurückwandeln in Dezimalzahl
		r = 0;
		for(ct=0 ;ct < FFT_Level; ct++)
		{
			r = r + (1<<ct) * d[ct];
		}
		//umsortierter Index
		bit_rev[i] = r;

	}//Ende Bit-Reversal-Tabelle
/*	
	//Delete popup
	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
	Display::TEXTOUTxvbig("Building trigonometric", 247, 192, 0, UI_Plane2);
	Display::TEXTOUTxvbig("tables.", 247, 212, 0, UI_Plane2);
	Display::TEXTOUTxvbig("Please wait a minute.", 247, 232, 0, UI_Plane2);
*/
/*
	//check the values
	for(i=0;i < FFT_Length;i++)  			// {sin und cos-Tabelle prüfen}
	{
		//printf("SIN(x) = ");floatprintf((float)sin_tab[i]);
		//printf("COS(x) = ");floatprintf((float)cos_tab[i]);printf("\r\n");
		printf("SIN(x) =  %d\r\n",sin_tab[i]);
		printf("COS(x) =  %d\r\n",cos_tab[i]);

	}
	//check the values
//	for(Ii=0 ;Ii < FFT_LENGTH; Ii++)
//	printf("Bit reversal =  %d\r\n",bit_rev[Ii]);

*/

}

//##########################################################################################################################################################
/* BF */
// Calculate fast fourier transformation to get spectral analyzis of time signal. Trigonometric tables have to be build first.
// To get a periodic approximation, the time signal has to be processed with a window function. The simplest case is a 
// rectangle window, which has no side line suppression.
void Display::FFT_CalcSpectrum(unsigned char *Signal, int *Spectrum)
{
	// buffer for real and imaginary part of spectrum - sharing the memory with the signal interpolation
	int *freq_re = (int *)0x008DDD20;
	int *freq_im = (int *)0x008DF490;
	
	//Speicher auf dem Stack reservieren
	int l=0,i=0,j=0,r=0,ar=0,v=0;
	int Fz1=0,Fz2=0,Fz3=0,Fz4=0,Fxr=0,Fxi=0,Fyr=0,Fyi=0;
	int ScaleShiftFactor;  
	
	double logval;
    	//printf("starting fft\r\n");
	
	// set variable scaling
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	FFT_Scale = 3;
	else
	FFT_Scale = 2;

	ScaleShiftFactor = FFT_Level - FFT_Scale;

	//-----------------------------------------------
	// get time signal and make a window overlay
	//-----------------------------------------------

	//sort timevalues bitreversal
	for(i=0;i<FFT_Length;i++)
	{
		if(FFT_Windex == -1)
		freq_re[i] = (int)(Signal[bit_rev[i]] - ADC_ZERO);					// no window overlay -> rectangle
		else
		freq_re[i] =  (win_tab[bit_rev[i]] * (int)(Signal[bit_rev[i]] - ADC_ZERO)) >> 13;	// window overlay

		freq_im[i] = 0;

		//printf("freq_re[%d] = ",Ii);floatprintf(freq_re[Ii]);
		//printf("     freq_im[%d] = ",Ii);floatprintf(freq_im[Ii]);printf("\r\n");
	}

	//-----------------------------------------------
	//             calculate FFT
	//-----------------------------------------------

	//calculate complex spectral values (butterflies)
	for(l=1;(l<=FFT_Level) && !UI_request;l++)	// level loop
	{
		for(i=0;i<=((1<<(FFT_Level-l))-1) && !UI_request;i++)
		{
			for(j=0;j<=((1<<(l-1))-1);j++)
			{
				r = j + i* (1 << l);
				ar= j * (FFT_Length >> l);
				v = 1 << (l-1);
				
				Fz1 = (cos_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz2 = (cos_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fz3 = (sin_tab[ar] * freq_re[r+v]) >> 10;	//rescale from integer conversion
				Fz4 = (sin_tab[ar] * freq_im[r+v]) >> 10;	//rescale from integer conversion
				Fxr = freq_re[r] + Fz1 + Fz4;
				Fxi = freq_im[r] - Fz3 + Fz2;
				Fyr = freq_re[r] - Fz1 - Fz4;
				Fyi = freq_im[r] + Fz3 - Fz2;
				freq_re[r] = Fxr;
				freq_im[r] = Fxi;
				freq_re[r+v] = Fyr;
				freq_im[r+v] = Fyi;
			}
		}
	}


	//get half of the spectrum because spectrum is mirrored at the middle and calculate output
	for (i=0,j=0;i < (FFT_Length>>1);i++)
	{
		//downscale depending on FFT length
		freq_re[i] = freq_re[i] >> ScaleShiftFactor;
		freq_im[i] = freq_im[i] >> ScaleShiftFactor;

		switch(FFT_Mode)
		{
			case FFT_MAGN: 	// linear magnitude
			{
				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²

				// and square root
				for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
				r = (r + (v / r)) >> 1;
				
				break;
			}
			
			case FFT_PHAS: 	// linear phase
			{
				r = 10;
				//phase = arctan(imag / real)
				break;
			}

			case FFT_REAL: 	// linear real part
			{
				r = freq_re[i];
				
				break;
			}

			case FFT_IMAG: 	// linear imaginary part
			{
				r = freq_im[i];
				
				break;
			}

			case FFT_REIM: 	// linear real + imaginary
			{
				r = freq_re[i] + freq_im[i];
				
				break;
			}

			case FFT_PWSP: 	// power spectrum in dBm
			{
				//calc total value via power of two
				v = (freq_re[i]*freq_re[i]) + (freq_im[i]*freq_im[i]);	// v = Re² + IM²

				// and square root
				for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
				r = (r + (v / r)) >> 1;

				//limiter
				if (r < 0) r = 0;
				if (r > 480) r = 480;

				// calculate logarithm
				r = (int)iLog10[r];

/*
				//limiter
				if (r < 0) r = 0;
				if (r > 480) r = 480;

				// calculate power spectrum
				// ps = 20 * log10(magn / ref)		ref = 0.316 V = 323 / 1024
				
				r = (r * 323) >> 10;			//magn / ref
				
				r = (int)iLog10[r];			//20 * log10(magn / ref)
*/				
				break;			}

			case FFT_PWDN: 	// power density spectrum in dBm
			{
				// calculate power density spectrum
				// pd = ps - 10 * log10(ENBW * df)

				r = 10;
				
				break;
			}



		}

		//printf("freq_re[%d] = %d    ",i,freq_re[i]);
		//printf("freq_im[%d] = %d    ",i,freq_im[i]);	

		
		//printf("v = Re² + IM² = %d    ",v);
		

		//printf("r = sqrt(v) = %d",r);
		
		// scale to display size
		//r = r << 2;
		//printf("scale r = %d\r\n",r);	

		
		//map to 512 or 1024 values
		if(FFT_Length == FFT_1024 )
			Spectrum[i] = r;
		else
		{ 
			Spectrum[j] = r;
			Spectrum[j+1] = r;
			j+=2;
		 }	
		
	}

    	//printf("finished fft\r\n");


}

//##########################################################################################################################################################
/* BF */
// draw informations about FFT on right side of the screen
void Display::FFT_DrawStatus(void)
{

	float lValue = 0;
	int lTxtOffs = GRID_XOFFS_FFT + GRID_WIDTH_FFT + 9;


	
	// SET FFT cursor data display
	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{
		FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
		FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
		FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "dBm");
	}
	else
	{
		FFT_Cursor_Delta_Y.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
		FFT_Cursor_Horizontal_Pos_1_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
		FFT_Cursor_Horizontal_Pos_2_Str.Init(0.00000001, 0.00000001, 10, 0.000000005, 2, 4, "", "", "V");
	}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

			
/*
	//TEXTOUTxvbig(&string[0], GRID_XOFFS_FFT + GRID_WIDTH_FFT + 10, 40, 1,  Grid_Plane);	

	if (FFT_Mode == FFT_LOG)
	{
		TEXTOUTxvbig(" 0dB",    GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 25, 1,  Grid_Plane);	
		TEXTOUTxvbig("-10dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 95, 1,  Grid_Plane);	
		TEXTOUTxvbig("-20dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 175, 1,  Grid_Plane);	
		TEXTOUTxvbig("-30dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 255, 1,  Grid_Plane);
		TEXTOUTxvbig("-40dB",  GRID_XOFFS_FFT + GRID_WIDTH_FFT + 5, 335, 1,  Grid_Plane);	
	}
*/


	
/*
	int xa = 70 * 20;		// Ypos * 20
	int xo = 17;	//544 / 32;	// Xpos / 32

	for (int Ct = 0; Ct < 110 ; Ct++)	// Ysize = 110
	{			
		*(Grid_Plane + xo + xa)     = 0;// Xsize + 1 , +2 ...
		*(Grid_Plane + xo + xa + 1) = 0;
//		*(Grid_Plane + xo + xa + 2) = 0;
		xa += 20;
	}
*/

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	if(FFT_Layout)	// display variant with buttons
	{
		Display::DRAWROUNDBUTTON(516, 19, 124, 120, 0, 0);
		Display::DRAWROUNDBUTTON(516, 144, 124, 120, 0, 0);
		Display::DRAWROUNDBUTTON(516, 270, 124, 120, 0, 0);
	
		DRAWLINEP(519, 49, 638, 49, 1, UI_Plane2);	// time under line
		DRAWLINEP(519, 174, 638, 174, 1, UI_Plane2);	// frequency under line
		DRAWLINEP(519, 300, 638, 300, 1, UI_Plane2);	// magnitude under line
	
	
		//--------------------------------------
		//	time status area
		//--------------------------------------
		DRAWP(546, 55, 92, 70, 0, UI_Plane2);	// delete 
	
		// time header
		TEXTOUTxvbig("Time Source", lTxtOffs + 10, 28, 1, UI_Plane2);
	
		// source channel
		TEXTOUTxvbig("Ch :", lTxtOffs, 60, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[29][MenuStatus[27][0] - 137][0], lTxtOffs + 35, 60, 1, UI_Plane2);
	
		// FFT length
		TEXTOUTxvbig("Len:", lTxtOffs, 85, 1, UI_Plane2);
		TEXTOUTxvbig(&MenuPopupText[32][MenuStatus[27][3] - 82][0], lTxtOffs + 35, 85, 1, UI_Plane2);
		TEXTOUTxvbig("pts", lTxtOffs + 70, 85, 1, UI_Plane2);

		// time window
		TEXTOUTxvbig("Win:", lTxtOffs, 110, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[30][MenuStatus[27][1] - 192][0], lTxtOffs + 35, 110, 1, UI_Plane2);
	
	
		//--------------------------------------
		//	frequency status area
		//--------------------------------------
		DRAWP(546, 180, 92, 80, 0, UI_Plane2);	//delete 
	
		// frequency header
		TEXTOUTxvbig("Frequency", lTxtOffs + 21, 153, 1, UI_Plane2);	
	
		// calculate delta frequency
		lValue = (float)SampleRate[Display_Timebase] / (float)FFT_Length;	
		// start value , min value, max value, stepwidth , places afterdot, max places, Text, PreText, Unit
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "df : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 185, 1, UI_Plane2);	
	
		// calculate and display frequency per div
		lValue *= (float)(FFT_Length >> 4);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "div: ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 210, 1, UI_Plane2);	
	
		// calculate and display fmax 
		lValue = (float)(SampleRate[Display_Timebase] >> 1);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "fN : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 235, 1, UI_Plane2);	
	
	
	
		//--------------------------------------
		//	magnitude status area
		//--------------------------------------
		DRAWP(lTxtOffs+20, 278, 90, 18, 0, UI_Plane2);	//delete header
		DRAWP(lTxtOffs, 305, 110, 80, 0, UI_Plane2);	//delete lower part
	
		// magnitude header
		//TEXTOUTxvbig("Magnitude", lTxtOffs + 21, 279, 1, UI_Plane2);	
		TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs+21, 279, 1, UI_Plane2);	
		// FFT mode
		//TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs, 311, 1, UI_Plane2);	

		// linear - logarithmic
		if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
		TEXTOUTxvbig("Mag: log (dBm)", lTxtOffs, 311, 1, UI_Plane2);	
		else
		TEXTOUTxvbig("Mag: lin (Volt)", lTxtOffs, 311, 1, UI_Plane2);	

		//TEXTOUTxvbig("???: ????????", lTxtOffs, 336, 1, UI_Plane2);	

		//TEXTOUTxvbig("???: ????????", lTxtOffs, 362, 1, UI_Plane2);	

	}
	
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	else	// "black" display variant
	{
		//draw frame
		DRAWLINEP(516, 19, 638, 19, 1, Grid_Plane);	// time top line
		DRAWLINEP(516, 59, 638, 59, 1, Grid_Plane);	// time under line
	
		DRAWLINEP(516, 154, 638, 154, 1, Grid_Plane);	// frequency top line
		DRAWLINEP(516, 194, 638, 194, 1, Grid_Plane);	// frequency under line
	
		DRAWLINEP(516, 290, 638, 290, 1, Grid_Plane);	// magnitude top line
		DRAWLINEP(516, 330, 638, 330, 1, Grid_Plane);	// magnitude under line
	
		DRAWLINEP(638, 19, 638, 421, 1, Grid_Plane);	//right line
		DRAWLINEP(516, 421, 638, 421, 1, Grid_Plane);	//bottom line
	
		//--------------------------------------
		//delete time status area
		//--------------------------------------
		DRAWP(546, 70, 92, 70, 0, Grid_Plane);	
	
		// time header
		TEXTOUTxvbig("Time Source", lTxtOffs + 10, 33, 1, Grid_Plane);	
	
		// source channel
		TEXTOUTxvbig("Ch :", lTxtOffs, 75, 1, Grid_Plane);	
		TEXTOUTxvbig(&MenuPopupText[29][MenuStatus[27][0] - 137][0], lTxtOffs + 35, 75, 1, Grid_Plane);
	
		// FFT length
		TEXTOUTxvbig("Len:", lTxtOffs, 100, 1, Grid_Plane);
		TEXTOUTxvbig(&MenuPopupText[32][MenuStatus[27][3] - 82][0], lTxtOffs + 35, 100, 1, Grid_Plane);
		TEXTOUTxvbig("pts", lTxtOffs + 70, 100, 1, Grid_Plane);

		// time window
		TEXTOUTxvbig("Win:", lTxtOffs, 125, 1, Grid_Plane);	
		TEXTOUTxvbig(&MenuPopupText[30][MenuStatus[27][1] - 192][0], lTxtOffs + 35, 125, 1, Grid_Plane);



	
		//--------------------------------------
		//delete frequency status area
		//--------------------------------------
		DRAWP(546, 205, 92, 80, 0, Grid_Plane);	
	
	
		// frequency header
		TEXTOUTxvbig("Frequency", lTxtOffs + 21, 168, 1, Grid_Plane);	
	
		// calculate delta frequency
		lValue = (float)SampleRate[Display_Timebase] / (float)FFT_Length;	
		// start value , min value, max value, stepwidth , places afterdot, max places, Text, PreText, Unit
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "df : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 210, 1, Grid_Plane);	
	
		// calculate and display frequency per div
		lValue *= (float)(FFT_Length >> 4);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "div: ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 235, 1, Grid_Plane);	
	
		// calculate and display fmax 
		lValue = (float)(SampleRate[Display_Timebase] >> 1);
		FFT_Status_Str.Init(lValue, 1, 1, 1, 2, 5, "", "fN : ", "Hz");
		TEXTOUTxvbig(FFT_Status_Str.Read_Text(), lTxtOffs, 260, 1, Grid_Plane);	
	
		//--------------------------------------
		//delete magnitude status area
		//--------------------------------------
		DRAWP(lTxtOffs+20, 302, 90, 18, 0, Grid_Plane);		//delete header
		DRAWP(lTxtOffs, 340, 92, 80, 0, Grid_Plane);		//delete lower part
	
		// magnitude header
		//TEXTOUTxvbig("Magnitude", lTxtOffs + 21, 304, 1, Grid_Plane);	
		TEXTOUTxvbig(&MenuPopupText[31][FFT_Mode][0], lTxtOffs+21, 304, 1, Grid_Plane);	

		// linear - logarithmic
		if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
		TEXTOUTxvbig("Mag: log (dBm)", lTxtOffs, 346, 1, Grid_Plane);	
		else
		TEXTOUTxvbig("Mag: lin (Volt)", lTxtOffs, 346, 1, Grid_Plane);
	
		//TEXTOUTxvbig("???: ????????", lTxtOffs, 371, 1, Grid_Plane);	
		//TEXTOUTxvbig("???: ????????", lTxtOffs, 396, 1, Grid_Plane);	


	}

}

//##########################################################################################################################################################
//BF calculate cursor data for FFT
void Display::FFT_CalcCursorData(void)  								// channel = source im cursor menu
{
	int buf_int = 0;	
		
	//BF del char doit = 0;	
	int volt = 0;		
	int zero = 0;		
	int probe_idx = 0;
/*
	double vfactor  = 0;	
	double vfactor2 = 0;	
	double voltoff  = 0;		
*/
	float vfactor  = 0;	
	float probefact = 0;	
	float voltoff  = 0;		
	
	int time = 0;
/*
	double tfactor = 0;
	double timeoff = 0;			
*/	
	//float tfactor = 0;
	//float timeoff = 0;	

	float frequ1, frequ2;
	float dfrequ;

	char BufferText[10];
	
	int channel = MenuStatus[MENU_FFT][0] - 137;

	//printf("calculating FFT-cursor\r\n");
			
	switch(channel)
	{
	 	case 1:
		{				
			volt = Selected_Voltage_CH1;
			probe_idx = MenuStatus[1][3];
			break;
		}
		case 2:
		{				
			volt = Selected_Voltage_CH2;
			probe_idx = MenuStatus[2][3];
			break;
		}
		case 3:
		{				
			volt = Selected_Voltage_CH3;
			probe_idx = MenuStatus[3][3];
			break;
		}
		case 4:
		{				
			volt = Selected_Voltage_CH4;
			probe_idx = MenuStatus[4][3];
			break;	
		}
	}
	
	zero = GRID_HEIGHT_FFT + 1;

	if (FFT_Mode == FFT_PWSP || FFT_Mode == FFT_PWDN)
	{
		vfactor = 0.125;	// * probefact
	}
	else	//linear magnitude
	{
		switch(volt)
		{
			case 0 : vfactor = 0.00002; break;
			case 1 : vfactor = 0.00004; break;
			case 2 : vfactor = 0.0001; break;
			case 3 : vfactor = 0.0002; break;
			case 4 : vfactor = 0.0004; break;
			case 5 : vfactor = 0.001; break;
			case 6 : vfactor = 0.002; break;
			case 7 : vfactor = 0.004; break;
			case 8 : vfactor = 0.01; break;
			case 9 : vfactor = 0.02; break;
			case 10 : vfactor = 0.04; break;
			case 11 : vfactor = 0.1; break;
		}
	
		switch(probe_idx)	// probe predivision
		{
	//		case 101: probefact = 0.1; break;	//not used
	//		case 102: probefact = 0.2; break;	//not used
	//		case 103: probefact = 0.5; break;	//not used
			case 104: probefact = 1; break;
			case 105: probefact = 2; break;
			case 106: probefact = 5; break;
			case 107: probefact = 10; break;
			case 108: probefact = 20; break;
			case 109: probefact = 50; break;
			case 110: probefact = 100; break;
			case 111: probefact = 200; break;
			case 112: probefact = 500; break;
			case 113: probefact = 1000; break;
		}	
	
		vfactor = vfactor * probefact / 2;	// magnitude factor
	
	}

	buf_int = zero - Cursor_Horizontal_Position_Real1;
	//printf("Horizontal cursor 1 = %d",buf_int);	
	//printf(" | ");

	voltoff1 =  (float)buf_int * vfactor; 
	
	// display horizontal cursor Y1 data
	FFT_Cursor_Horizontal_Pos_1_Str.Write_Value(voltoff1);
	FFT_Cursor_Horizontal_Pos_1_Str.RenderText();
		
	
	buf_int = zero - Cursor_Horizontal_Position_Real2;	
	//printf("Horizontal cursor 2 = %d\r\n",buf_int);	

	voltoff2 =  (float)buf_int * vfactor; 
	
	// display horizontal cursor Y2 data
	FFT_Cursor_Horizontal_Pos_2_Str.Write_Value(voltoff2);
	FFT_Cursor_Horizontal_Pos_2_Str.RenderText();	
	

	if (voltoff1 > voltoff2)
	{ voltoff = voltoff1 - voltoff2; }
	else
	{ voltoff = voltoff2 - voltoff1; }
	
	if (voltoff < 0) voltoff = -voltoff;

		
	switch(channel)
	{
		case 1: sprintf(BufferText, "@Y [ = "); break;
		case 2: sprintf(BufferText, "@Y \\ = "); break;
		case 3: sprintf(BufferText, "@Y ] = "); break;
		case 4: sprintf(BufferText, "@Y ^ = "); break;
		//case 5: sprintf(BufferText, "@Y(M) = "); break;
	}

	// display delta cursor Y data
	FFT_Cursor_Delta_Y.Write_PreText(BufferText);
	FFT_Cursor_Delta_Y.Write_Value(voltoff);
	FFT_Cursor_Delta_Y.RenderText();				
	


	//------------------------------------------------------------------------------------
	//		Vertical cursors - frequency
	//------------------------------------------------------------------------------------
	// limiter
	if(Cursor_Vertical_Position_Real1 > GRID_WIDTH_FFT + 1) Cursor_Vertical_Position_Real1 = GRID_WIDTH_FFT + 1;
	if(Cursor_Vertical_Position_Real2 > GRID_WIDTH_FFT + 1) Cursor_Vertical_Position_Real2 = GRID_WIDTH_FFT + 1;
	//printf("Vertical cursor 1 = %d",Cursor_Vertical_Position_Real1);
	//printf(" | ");
	//printf("Vertical cursor 2 = %d\r\n",Cursor_Vertical_Position_Real2);


	// calculate delta frequency
	dfrequ =  (float)SampleRate[Display_Timebase] / 1024.0;	//(float)FFT_Length;	
	
	// calculate frequency of cursor 1 position
	frequ1 = dfrequ * (float)(Cursor_Vertical_Position_Real1 - 1);

	// display vertical cursor X1 data 
	FFT_Cursor_Vertical_Pos_1_Str.Write_Value(frequ1);
	FFT_Cursor_Vertical_Pos_1_Str.RenderText();	
	//printf("freq1 = ");floatprintf(frequ1);printf("\r\n");	

	// calculate frequency of cursor 2 position
	frequ2 = dfrequ * (float)(Cursor_Vertical_Position_Real2 - 1);

	// display vertical cursor X2 data 
	FFT_Cursor_Vertical_Pos_2_Str.Write_Value(frequ2);	
	FFT_Cursor_Vertical_Pos_2_Str.RenderText();	
	//printf("freq2 = ");floatprintf(frequ2);printf("\r\n");	
	
	// calculate delta cursor 1 - cursor 2
	if (frequ1 > frequ2) dfrequ = frequ1 - frequ2;
	else dfrequ = frequ2 - frequ1;
	if (dfrequ < 0) dfrequ = -dfrequ;
	
	// display delta
	FFT_Cursor_Delta_X.Write_Value(dfrequ);	
	FFT_Cursor_Delta_X.RenderText();
	
	// calculate and display 1/delta
	dfrequ = 1 / dfrequ;
	FFT_Cursor_Delta_1X.Write_Value(dfrequ);
	FFT_Cursor_Delta_1X.RenderText();
	
}

//##########################################################################################################################################################
// BF new screenshot function for black/white screenshots written by Niklas
// BF optimized by Falk
void	rle_enc(unsigned char c, int	init)
{
	static	unsigned short		llength;
	static	short	lastbyte;
	static unsigned short	maxlen=0xFEFE;
	unsigned	char	cout;

	if (init) {
		llength=0; lastbyte=-1;
		return; }
	if (c==lastbyte) {
		llength++;
		if (llength>maxlen) {
			putchar(0xFF);						//Escape
			putchar(llength>>8);  	//MSB
			putchar(llength); 	 		//LSB
			llength=0;
			lastbyte=-1;
			}
		}
	else {												//c != lastbyte
		if (llength > 0) {								//if llength > 0, write esc, LSB, MSB
			putchar(0xFF); 		 		//ESC
			putchar(llength>>8);		//MSB
			putchar(llength);			//LSB
			llength=0;
		}
		if (c==0xFF) { putchar(c);  }	//Escape
		putchar(c); 
		lastbyte=c;
		}
}
//##########################################################################################################################################################
// BF new screenshot function for black/white screenshots written by Niklas
// nevm
// BF optimized by Falk
void Display::SCREENSHOT_BW(void)
{
	int x, y;
	int	bitp=0;
	int bit, pos, offset;
	unsigned long *planes[] = {
		Grid_Plane,
		UI_Plane2, UI_Plane5, // UI_Plane1, UI_Plane3, UI_Plane4
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Channel_Math_Plane,
		Memory_Plane1, Memory_Plane2, Memory_Plane3,
		Marker_Plane1, Marker_Plane2,
		NULL
	};
	unsigned long *plane;
	int i, set, out=0;

	rle_enc(0,1);				//Initialize rle
	(void)putchar('\n');
	(void)putchar('S');			//Send start-of-transfer marker
	(void)putchar(0xFF);			//Send start-of-transfer marker
	(void)putchar(1);			//Send dumptye 1 monochrome


	for (y = 0; y < 480; y++) {
		for (x = 0; x < 640; x++) {
			offset = x >> 5;		// x div 32
			pos = Display_Line_Adresses[y] + offset;
			bit = x - (offset << 5);	// x - (offset mod 32)

			set = 0;
//Walk through planes but stop as soon as a pixel is set.
			for (i = 0; (plane = planes[i]) != NULL; i++) {
				if (*(plane + pos) & BitMasks2[bit]) {
					set=1;
					break;
				}
			}

/*********************************************************************
* Changed (dl3daz):
* shift bits into one byte for rle-encoding
*********************************************************************/
			if (set) out |= (1 << bitp);
			bitp++;
			if (bitp==8) {
			rle_enc(out,0);
				out=0;
				bitp=0; }
		}
	}
	rle_enc(0xFF,0);			//Send End-of-plane marker
	rle_enc('E',0);				//Send End-of-transfer-marker
	rle_enc('\n',0);

}

//##########################################################################################################################################################
// BF new screenshot function for colored screenshots written by Niklas
// nevm
// BF optimized by Falk
void Display::SCREENSHOT(void)
{
	short x, y;
	int bit, pos, offset;
	int	lastbyte,length,bitp=0;			//FW Last Byte, Number of same bytes
	unsigned long *planes[] = {
		Grid_Plane,
		UI_Plane1, UI_Plane2, UI_Plane3, UI_Plane4, UI_Plane5,
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Channel_Math_Plane,
		Memory_Plane1, Memory_Plane2, Memory_Plane3,	//BF -> not needed!!!
		Marker_Plane1, Marker_Plane2,
		NULL
	};
	unsigned long *plane;
	int i, set, out=0;

	rle_enc(0,1);					//Initialize rle
	(void)putchar('\n');
	(void)putchar('S');				//Send start-of-transfer marker
	(void)putchar(0xFF);				//Send start-of-transfer marker
	(void)putchar(0);				//Send dumptye 0 Color

	for (i = 0; (plane = planes[i]) != NULL; i++) {
		for (y = 0; y < 480; y++) {
			for (x = 0; x < 640; x++) {
				offset = x >> 5;		// x div 32
				pos = Display_Line_Adresses[y] + offset;
				bit = x - (offset << 5);	// x - (offset mod 32)
/*********************************************************************
* Changed (dl3daz):
* shift bits into one byte for rle-encoding
*********************************************************************/
				out |= (((*(plane + pos) & BitMasks2[bit]) ? 1 : 0) << bitp);
				bitp++;
				if (bitp==8) {
					rle_enc(out,0);
					out=0;
					bitp=0; }
			}
		}
		rle_enc(0xFF,0);	//Send End-of-plane marker
	}

	rle_enc('E',0);			//Send End-of-transfer-marker
	rle_enc('\n',0);
}

//##########################################################################################################################################################
// BF new .csv function for transmission of raw data written by Falk
void Display::DUMPCSV(void) {
	int	idx;
	rle_enc(0,1);
	(void)putchar('\n');
	(void)putchar('S');				//Send start-of-transfer marker
	(void)putchar(0xFF);				//Send start-of-transfer marker
	(void)putchar(2);				//Send dumptye 2 (CSV)
	for (idx = 0; idx < 16384; idx++) {
		putchar(SIGNAL1[idx]);
		putchar(SIGNAL2[idx]);
		putchar(SIGNAL3[idx]);
		putchar(SIGNAL4[idx]); }
	rle_enc('E',0);					//Send End-of-transfer-marker
	rle_enc('\n',0);
}
