#include "Arduino.h"
#include "general.h"

void initTimer()
{
  cli();

  //set WGM13 for PWM, phase and frequency correct
  TCCR1A = (1 << COM1A1);
  //CS10= prescaler none
  TCCR1B = (1 << WGM13);
  DDRB |= (1 << PB5);

  //set WGM13 for PWM, phase and frequency correct
  TCCR4A = (1 << COM4C1);
  //CS10= prescaler none
  TCCR4B = (1 << WGM43);
  DDRH |= (1 << PH5);

  sei();
}

void enableTimer_1o4(uint8_t timer)
{
  prozent = ((counter_Power + 1) * 5) / 100;
  periodendauer = wertVergleichsRegister[counter_Hertz];

  cli();
  if (timer == 0)
  {
    //Timer1_OVF_vect freigeben
    TIMSK1 |= (1 << TOIE1);
    TCCR1B |= (1 << CS10);//Prescaler auf Enable


    ICR1 = periodendauer;
    OCR1A = ((periodendauer / 2) - 1);

  }
  else if (timer == 1)
  {
    //Timer1_OVF_vect freigeben
    TIMSK4 |= (1 << TOIE4);
    TCCR4B |= (1 << CS40); //Prescaler auf Enable

    ICR4 = periodendauer;
    OCR4C = ((periodendauer / 2) - 1);
  }
  TIMSK5 |= (1 << OCIE5A);
  sei();
}

void disableTimer_1u4()
{
  cli();
  TCCR1B &= ~(1 << CS10);//Prescaler auf disable
  TIMSK1 &= ~(1 << TOIE1);//disable OVF Interrupt
  TCCR4B &= ~(1 << CS40); //Prescaler auf disable
  TIMSK4 &= ~(1 << TOIE4); //disable OVF Interrupt

  TIMSK5 &= ~(1 << OCIE5A);
  sei();
}
void signalErzeugung()
{
  if (richtung)
  { //abwärts
    if (aktuellerWert > 0)
    {
      aktuellerWert--;
    }
    else
    {
      aktuellerWert++;
      richtung = 0;
    }
  }
  else
  { //aufwärts
    if (aktuellerWert < periodendauer)
    {
      aktuellerWert++;
    }
    else
    {
      aktuellerWert--;
      richtung = 1;
    }
  }
}

ISR (TIMER1_OVF_vect)
{
  signalErzeugung();
  uint16_t test = aktuellerWert * prozent;
  OCR1A = test;
}

ISR (TIMER4_OVF_vect)
{
  signalErzeugung();
  uint16_t test = aktuellerWert * prozent;
  OCR4C = test;
}
