/*
   In dieser Datei werden alle Variablen und definitionen der restlichen Dateien initialisiert.
   So kann aus allen Dokumenten zentral auf diese zugegriffen werden
*/



#ifndef GLOBALS_H_ //verhindern das die Datei zweimal aufgerufen wird
#define GLOBALS_H_

#ifndef EXTERN
#define EXTERN extern
#endif //EXTERN

#include <stdint.h>
#include "OneButton.h"
#include <UTFT.h>
#include <UTFT_SdRaw.h>
#include <SdFat.h>

EXTERN UTFT myGLCD;
EXTERN UTFT_SdRaw myFiles;
EXTERN SdFat sd;

EXTERN OneButton button_Hertz_Minus;
EXTERN OneButton button_Hertz_Plus;
EXTERN OneButton button_Power_Minus;
EXTERN OneButton button_Power_Plus;
EXTERN OneButton button_ChangeMode;
EXTERN OneButton button_ChangeForm;
EXTERN OneButton button_ChangeAmplifier;
EXTERN OneButton button_StartStop;

//**************************** Abschnitt für die Taster **************************

EXTERN bool state_Button_HertzMinus, state_Button_HertzPlus, state_Button_PowerMinus, state_Button_PowerPlus, state_Button_ChangeMode,
            state_Button_ChangeForm, state_Button_ChangeAmplifier, state_Button_StartStop, state_ButtonLong_StartStop;

//**************************** Abschnitt für die Taster **************************
EXTERN bool paused;
EXTERN int counterMenu;

#define SD_CHIP_SELECT  53  // SD chip select pin
#define treatmentScreen 0
#define waitForInAnyInput 1
#define buildsettingScreen 2
#define waitforSettings 3
#define waitforEnd 4


//**************************** Abschnitt für die SD-Karte **************************

// file system object

//**************************** Abschnitt für die SD-Karte **************************



//**************************** Abschnitt für das Display **************************

//Variablen zur aktualisierung von bestimmten Display Abschnitten
EXTERN bool refresh_StartStop, refresh_ChangeForm, refresh_ChangeAmplifier, refresh_ChangeMode, refresh_Hertz, refresh_Power;

//Speicherorte der Dateinamen der verwendeten Grafiken
EXTERN const char NamePicHertz[25][12] PROGMEM; 
EXTERN const char NamePicPower[20][12] PROGMEM;
EXTERN const char NameTime[61][10] PROGMEM;

//**************************** Abschnitt für das Display **************************



//**************************** Abschnitt für das Menü **************************
EXTERN bool state_StartStop, state_ChangeForm, state_ChangeMode;
EXTERN bool state_ChangeAmplifier; 
//0 = kleine Leistung //Timer 1 //Pin11
//1 = große Leistung  //Timer 4 //Pin8

EXTERN char filename[30];
EXTERN uint8_t counter_Hertz, counter_Power;
EXTERN int counterSekunden, counterMinuten;
EXTERN unsigned long lastTimeTimer1s, lastTimeTimer1m;

//**************************** Abschnitt für das Menü **************************


//**************************** Abschnitt für den Frequenzgenerator **************************

EXTERN uint16_t wertVergleichsRegister[25];

//**************************** Abschnitt für den Frequenzgenerator **************************

// Period = 1 ms => Frequenz = 1kHz
EXTERN uint16_t periodendauer, aktuellerWert;
EXTERN bool richtung; //0=aufwärts 1=abwärts
EXTERN float prozent;

#endif /* GLOBALS_H_ */
