; Schnelle Bildschirmausgabe fr VGA-Karten
;  im Halb- und Vollformat (128*128 bzw. 128*256 Pixel)

DATA SEGMENT WORD PUBLIC 'DATA'

DATA ENDS

CODE SEGMENT BYTE PUBLIC 'CODE'
     ASSUME  CS:CODE,DS:DATA
     PUBLIC  Anzeige

; bergabeparameter:

PLUS         EQU    WORD    PTR [BP+4] ; Bildschirm-Offset
                                       ; 0 --> linke obere Ecke

HALB         EQU    BYTE    PTR [BP+6] ; Flag : 0 = Vollformat
                                       ;        1 = Halbformat

ERGEBNIS     EQU    DWORD   PTR [BP+8] ; Pointer auf Ergebnisfeld

FARBE        EQU    BYTE    PTR [BP+12]; Die vier Lowbits bezeichnen
                                       ;  die Bitplanes

Anzeige      PROC   NEAR
             PUSH   BP
             MOV    BP,SP
             PUSH   DS


             LDS    SI,ERGEBNIS    ; auf Ergebnisfeld

             MOV    AX,0A000H
             MOV    ES,AX
             MOV    DI,0000H       ; ES:DI auf Bildschirm
             MOV    AX,PLUS        ; plus Offset
             ADD    DI,AX
             CLD                   ; Flags lschen

             MOV    AL,HALB
             CMP    AL,1
             JZ     W1             ; nach W1, falls Halbformat

             MOV    CL,240         ; Anzahl Zeilen (jede Zeile wird
                                   ;  doppelt dargestellt, entsprechend
                                   ;  der Geometrie des Speicherchips)
             ADD    SI, 4112       ; Ende des Ergebnisfeldes
             JMP    W2

W1:          MOV    CL,128         ; 128 Zeilen bei Halbformat
             ADD    SI,2064        ; Ende des Ergebnisfeldes

W2:          XOR    CH,CH          ; CH lschen

L2:          PUSH   CX             ; Zeilenzhler sichern
             SUB    SI,32          ; Zeilen werden rckwrts ausgegeben
             MOV    CL,16          ; 16 Bytes/Zeile
             XOR    CH,CH

             MOV    DX,03C4H       ; Befehlsregister des VGA-Adapters
             MOV    AL,2           ; Befehl "2": bernahme Bitplaneinfo
             OUT    DX,AL          ; ausgeben

;             MOV    AL,2
             INC    DX             ; Adresse fr Bitplaneinformation
             MOV    AL,FARBE       ; Wahl der Bitplanes
             OUT    DX,AL          ; an Karte

L1:          LODSB                 ; Bytes aus Ergebnisfeld laden
                                   ;  (8 Pixel)
             STOSB                 ; in Bildschirmspeicher
             LOOP   L1             ; 16 mal

             POP    CX             ; Zeilenzhler holen
             ADD    DI,144         ; Startadresse nchste Zeile
             LOOP   L2             ; 128 bzw 240 mal


; die ganze Prozedur noch einmal, da bisher nur jede zweite Zeile
; des Bildschirms benutzt wurde
             LDS    SI,ERGEBNIS
             MOV    AX,0A000H
             MOV    ES,AX
             MOV    DI,0000H
             ADD    DI,80          ; jetzt werden die ungeraden
                                   ; Bildschirmzeilen dargestellt
             MOV    AX,PLUS
             ADD    DI,AX
             CLD

             MOV    AL,HALB
             CMP    AL,1
             JZ     W3

             MOV    CL,240
             ADD    SI,4112
             JMP    W4

W3:          MOV    CL,128
             ADD    SI,2064
W4:          XOR    CH,CH

L4:          PUSH   CX
             SUB    SI,32
             MOV    CL,16
             XOR    CH,CH

L3:          LODSB
             STOSB
             LOOP   L3

             POP    CX
             ADD    DI,144
             LOOP   L4


             POP    DS
             POP    BP         ; DS und BP wiederherstellen
             RET    10         ; Rcksprung

Anzeige      ENDP
CODE         ENDS
             END


