program dither16;
{
   aus 9 s/w Bildern ein gedithertes Halbtonbild

   Eingabe : fn.9         (Halb- oder Vollbild)
   Ausgabe : fnX.BMP

   Format der erzeugten Bilder : 384*768 bzw.
                                 384*1536 Pixel
   Version 1.2
   25. 6.1992
}

{$I video.inc}

type ausgabe = array[0..47] of byte;

var fn,s         : string;
    halb         : boolean;
    nummer       : word;
    ergebnis     : grosses_feld;
    aus          : ausgabe;
    fil          : file;
    kopf         : kopftype;

procedure init;
var gd,gm : integer;
    i,j : word;
    f : file;
begin
   write('Datei : '); readln(fn);

   if not exist(fn + '.9') then
   begin write('Datei nicht gefunden');
         readln;
         halt
   end;

   assign(f,PFAD + fn + '.9');
   reset(f,1);
   halb := filesize(f) = 18432;
   for j := 0 to 47 do aus[j] := 0;
   gd := detect;
   initgraph(gd,gm,'');
end;

procedure arbeit;
{
  Das Bild wird auf dem Bildschirm dargestellt,
  dann die Information vom Bildschirm gelesen und abgespeichert
}
var res,x,y,yy,z,i,gx,gy : word;
    ii : integer;
    m : byte;
    f : shortint;
    a_i1,a_i2,a_i3,mal : word;                 { Zeile, Byte, Bit }
begin
   kopf := VollFormatKopf;
   if halb then begin kopf.bfSize := 36926;
                      kopf.biHeigth := 768;
                      mal := 2048
                end
           else begin kopf.bfSize := 73790;
                      kopf.biHeigth :=1536;
                      mal := 4096
                end;

   kopf.biWidth := 384;

   assign(fil, PFAD+fn+'x.bmp');
   rewrite(fil,1);
   blockwrite(fil,kopf,62);

   schnell_lesen(fn+'.9',Ergebnis,res,halb,9);

   for y := 0 to 127 do                        { jede Zeile }
   begin
      yy := 16*y;
      gy := 384-3*(1+y);
      gx := 0;
      a_i1 := yy*3;
      for x := 0 to 15 do                      { jedes Byte der Zeile }
      begin
         m := 128;
         for z := 0 to 7 do                    { jedes Bit des Bytes }
         begin
            f := 0;
            for i := 0 to 8 do                 { alle Ergebnisse }
            begin
               if ergebnis[i*mal + yy+x] and m = m then f := succ(f);
            end;

            if f > 4 then for ii := 0 to 8 do
               putpixel(gx+ii mod 3,gy+ii div 3,15);

            case f of
              1:putpixel(gx+random(3),gy+random(3),15);
              2:begin
                   putpixel(gx+random(3),gy+random(3),15);
                   putpixel(gx+random(3),gy+random(3),15);
                end;
              3:for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,15);
              4:begin
                   for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,15);
                   putpixel(gx+random(3),gy+random(3),15);
                end;
              8:putpixel(gx+random(3),gy+random(3),0);
              7:begin
                   putpixel(gx+random(3),gy+random(3),0);
                   putpixel(gx+random(3),gy+random(3),0);
                end;
              6:for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,0);
              5:begin
                   for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,0);
                   putpixel(gx+random(3),gy+random(3),0);
                end;
            end;

            gx := gx + 3;

            m := m shr 1;
         end;
      end;
   end;

   for y := 383 downto 0 do
   begin
      for x := 0 to 47 do
      begin
         port[$3ce] := 4;
         port[$3cf] := 1;
         aus[x] := mem[$A000:y*80 + x];
      end;
      blockwrite(fil,aus,48,res);
      blockwrite(fil,aus,48,res);
   end;

   if not halb then
   begin
      cleardevice;
      for y := 0 to 127 do                     { jede Zeile }
      begin
         yy := 16*y+2048;
         gy := 384-3*(1+y);
         gx := 0;
         a_i1 := yy*3;
         for x := 0 to 15 do                   { jedes Byte der Zeile }
         begin
            m := 128;
            for z := 0 to 7 do                 { jedes Bit des Bytes }
            begin
               f := 0;

               for i := 0 to 8 do              { alle Ergebnisse }
               begin
                  if ergebnis[i*mal + yy+x] and m = m then f := succ(f);
               end;

               if f > 4 then for ii := 0 to 8 do
                  putpixel(gx+ii mod 3,gy+ii div 3,15);

               case f of
                 1:putpixel(gx+random(3),gy+random(3),15);
                 2:begin
                      putpixel(gx+random(3),gy+random(3),15);
                      putpixel(gx+random(3),gy+random(3),15);
                   end;
                 3:for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,15);
                 4:begin
                      for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,15);
                      putpixel(gx+random(3),gy+random(3),15);
                   end;
                 8:putpixel(gx+random(3),gy+random(3),0);
                 7:begin
                      putpixel(gx+random(3),gy+random(3),0);
                      putpixel(gx+random(3),gy+random(3),0);
                   end;
                 6:for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,0);
                 5:begin
                      for ii := 0 to 2 do putpixel(gx+random(2),gy+ii,0);
                      putpixel(gx+random(3),gy+random(3),0);
                   end;
               end;

               gx := gx + 3;
               m := m shr 1;
            end;
         end;
      end;
      for y := 383 downto 0 do
      begin
         for x := 0 to 47 do
         begin
            port[$3ce] := 4;
            port[$3cf] := 1;
            aus[x] := mem[$A000:y*80 + x];
         end;
         blockwrite(fil,aus,48,res);
         blockwrite(fil,aus,48,res);
      end;
   end;
   close(fil);
end; {Arbeit}




begin
   init;
   arbeit;
end.